/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.InspectPrimitiveDataText;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WindowGeometry;

public class InspectPrimitiveDialog
extends ExtendedDialog {
    protected transient List<OsmPrimitive> primitives;
    protected transient OsmDataLayer layer;
    private boolean mappaintTabLoaded;
    private boolean editcountTabLoaded;

    public InspectPrimitiveDialog(Collection<OsmPrimitive> collection, OsmDataLayer osmDataLayer) {
        super(Main.parent, I18n.tr("Advanced object info", new Object[0]), I18n.tr("Close", new Object[0]));
        this.primitives = new ArrayList<OsmPrimitive>(collection);
        this.layer = osmDataLayer;
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(750, 550)));
        this.setButtonIcons("ok.png");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(I18n.tr("data", new Object[0]), InspectPrimitiveDialog.genericMonospacePanel(new JPanel(), InspectPrimitiveDialog.buildDataText(osmDataLayer, this.primitives)));
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab(I18n.tr("map style", new Object[0]), jPanel);
        jTabbedPane.getModel().addChangeListener(changeEvent -> {
            if (!this.mappaintTabLoaded && ((SingleSelectionModel)changeEvent.getSource()).getSelectedIndex() == 1) {
                this.mappaintTabLoaded = true;
                InspectPrimitiveDialog.genericMonospacePanel(jPanel, InspectPrimitiveDialog.buildMapPaintText());
            }
        });
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab(I18n.tr("edit counts", new Object[0]), jPanel2);
        jTabbedPane.getModel().addChangeListener(changeEvent -> {
            if (!this.editcountTabLoaded && ((SingleSelectionModel)changeEvent.getSource()).getSelectedIndex() == 2) {
                this.editcountTabLoaded = true;
                InspectPrimitiveDialog.genericMonospacePanel(jPanel2, InspectPrimitiveDialog.buildListOfEditorsText(collection));
            }
        });
        this.setContent(jTabbedPane, false);
    }

    protected static JPanel genericMonospacePanel(JPanel jPanel, String string) {
        jPanel.setLayout(new GridBagLayout());
        JosmTextArea josmTextArea = new JosmTextArea();
        josmTextArea.setFont(GuiHelper.getMonospacedFont(josmTextArea));
        josmTextArea.setEditable(false);
        josmTextArea.append(string);
        josmTextArea.setCaretPosition(0);
        jPanel.add((Component)new JScrollPane(josmTextArea), GBC.std().fill());
        return jPanel;
    }

    protected static String buildDataText(OsmDataLayer osmDataLayer, List<OsmPrimitive> list) {
        InspectPrimitiveDataText inspectPrimitiveDataText = new InspectPrimitiveDataText(osmDataLayer);
        list.sort(new OsmPrimitiveComparator());
        for (OsmPrimitive osmPrimitive : list) {
            inspectPrimitiveDataText.addPrimitive(osmPrimitive);
        }
        return inspectPrimitiveDataText.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String buildMapPaintText() {
        Object object;
        Collection<OsmPrimitive> collection = Main.getLayerManager().getEditDataSet().getAllSelected();
        ElemStyles elemStyles = MapPaintStyles.getStyles();
        MapView mapView = Main.map.mapView;
        double d = mapView.getDist100Pixel();
        StringBuilder stringBuilder = new StringBuilder();
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            for (OsmPrimitive object2 : collection) {
                stringBuilder.append(I18n.tr("Styles Cache for \"{0}\":", object2.getDisplayName(DefaultNameFormatter.getInstance())));
                object = new MultiCascade();
                for (StyleSource styleSource : elemStyles.getStyleSources()) {
                    if (styleSource.active) {
                        stringBuilder.append(I18n.tr("\n\n> applying {0} style \"{1}\"\n", InspectPrimitiveDialog.getSort(styleSource), styleSource.getDisplayString()));
                        styleSource.apply((MultiCascade)object, object2, d, false);
                        stringBuilder.append(I18n.tr("\nRange:{0}", ((MultiCascade)object).range));
                        for (Map.Entry entry : ((MultiCascade)object).getLayers()) {
                            stringBuilder.append("\n ").append((String)entry.getKey()).append(": \n").append(entry.getValue());
                        }
                        continue;
                    }
                    stringBuilder.append(I18n.tr("\n\n> skipping \"{0}\" (not active)", styleSource.getDisplayString()));
                }
                stringBuilder.append(I18n.tr("\n\nList of generated Styles:\n", new Object[0]));
                StyleElementList styleElementList = elemStyles.get(object2, d, mapView);
                Iterator<StyleElement> iterator = styleElementList.iterator();
                while (iterator.hasNext()) {
                    StyleElement styleElement = iterator.next();
                    stringBuilder.append(" * ").append(styleElement).append('\n');
                }
                stringBuilder.append("\n\n");
            }
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
        if (collection.size() == 2) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection);
            StyleCache styleCache = ((OsmPrimitive)arrayList.get((int)0)).mappaintStyle;
            object = ((OsmPrimitive)arrayList.get((int)1)).mappaintStyle;
            if (styleCache == object) {
                stringBuilder.append(I18n.tr("The 2 selected objects have identical style caches.", new Object[0]));
            }
            if (!styleCache.equals(object)) {
                stringBuilder.append(I18n.tr("The 2 selected objects have different style caches.", new Object[0]));
            }
            if (styleCache.equals(object) && styleCache != object) {
                stringBuilder.append(I18n.tr("Warning: The 2 selected objects have equal, but not identical style caches.", new Object[0]));
            }
        }
        return stringBuilder.toString();
    }

    protected static String buildListOfEditorsText(Iterable<OsmPrimitive> iterable) {
        Object object;
        TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>(Collator.getInstance(Locale.getDefault()));
        for (OsmPrimitive object2 : iterable) {
            if (object2.getUser() == null) continue;
            String string = object2.getUser().getName();
            object = (Integer)treeMap.get(string);
            if (object == null) {
                treeMap.put(string, 1);
                continue;
            }
            treeMap.put(string, (Integer)object + 1);
        }
        StringBuilder stringBuilder = new StringBuilder(48).append(I18n.trn("{0} user last edited the selection:", "{0} users last edited the selection:", treeMap.size(), treeMap.size())).append("\n\n");
        for (Map.Entry entry : treeMap.entrySet()) {
            object = (String)entry.getKey();
            Integer n = (Integer)entry.getValue();
            stringBuilder.append(String.format("%6d  %s", n, object)).append('\n');
        }
        return stringBuilder.toString();
    }

    private static String getSort(StyleSource styleSource) {
        if (styleSource instanceof MapCSSStyleSource) {
            return I18n.tr("mapcss", new Object[0]);
        }
        return I18n.tr("unknown", new Object[0]);
    }
}

