/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.MainFrame;
import org.parosproxy.paros.view.MainPopupMenu;
import org.parosproxy.paros.view.OptionsDialog;
import org.parosproxy.paros.view.OutputPanel;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.SessionGeneralPanel;
import org.parosproxy.paros.view.SiteMapPanel;
import org.parosproxy.paros.view.WaitMessageDialog;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.keyboard.ExtensionKeyboard;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextExcludePanel;
import org.zaproxy.zap.view.ContextGeneralPanel;
import org.zaproxy.zap.view.ContextIncludePanel;
import org.zaproxy.zap.view.ContextListPanel;
import org.zaproxy.zap.view.ContextPanelFactory;
import org.zaproxy.zap.view.ContextStructurePanel;
import org.zaproxy.zap.view.ContextTechnologyPanel;
import org.zaproxy.zap.view.MessagePanelsPositionController;
import org.zaproxy.zap.view.SessionExcludeFromProxyPanel;
import org.zaproxy.zap.view.SessionExcludeFromScanPanel;
import org.zaproxy.zap.view.SessionExcludeFromSpiderPanel;
import org.zaproxy.zap.view.SplashScreen;
import org.zaproxy.zap.view.StatusUI;
import org.zaproxy.zap.view.ZapMenuItem;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightRenderersEditors;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlightEditor;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlightRenderer;

public class View
implements ViewDelegate {
    @Deprecated
    public static final int DISPLAY_OPTION_LEFT_FULL = 0;
    @Deprecated
    public static final int DISPLAY_OPTION_BOTTOM_FULL = 1;
    @Deprecated
    public static final int DISPLAY_OPTION_TOP_FULL = 2;
    public static final int DISPLAY_OPTION_ICONNAMES = 0;
    public static final int DISPLAY_OPTION_ONLYICONS = 1;
    private static View view = null;
    private static boolean daemon = false;
    private SessionDialog sessionDialog = null;
    private OptionsDialog optionsDialog = null;
    private MainFrame mainFrame = null;
    private HttpPanelRequest requestPanel = null;
    private HttpPanelResponse responsePanel = null;
    private SiteMapPanel siteMapPanel = null;
    private OutputPanel outputPanel = null;
    private Vector<JMenuItem> popupList = new Vector();
    private JMenu menuShowTabs = null;
    private JCheckBox rememberCheckbox = null;
    private JCheckBox dontPromptCheckbox = null;
    private List<AbstractContextPropertiesPanel> contextPanels = new ArrayList<AbstractContextPropertiesPanel>();
    private List<ContextPanelFactory> contextPanelFactories = new ArrayList<ContextPanelFactory>();
    private Map<ContextPanelFactory, List<AbstractContextPropertiesPanel>> contextPanelFactoriesPanels = new HashMap<ContextPanelFactory, List<AbstractContextPropertiesPanel>>();
    private static final Logger logger = Logger.getLogger(View.class);
    private SplashScreen splashScreen = null;
    private Map<AddOn.Status, StatusUI> statusMap = new HashMap<AddOn.Status, StatusUI>();
    private boolean postInitialisation;

    @Override
    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    @Deprecated
    public static void setDisplayOption(int n) {
        View.getSingleton().getMainFrame().setWorkbenchLayout(WorkbenchPanel.Layout.getLayout(n));
    }

    @Deprecated
    public static int getDisplayOption() {
        return View.getSingleton().getMainFrame().getWorkbenchLayout().getId();
    }

    public void init() {
        OptionsParam optionsParam = Model.getSingleton().getOptionsParam();
        this.mainFrame = new MainFrame(optionsParam, this.getRequestPanel(), this.getResponsePanel());
        this.mainFrame.getWorkbench().addPanel(View.getSingleton().getSiteTreePanel(), WorkbenchPanel.PanelType.SELECT);
        MessageLocationHighlightRenderersEditors.getInstance().addEditor(TextMessageLocationHighlight.class, new TextMessageLocationHighlightEditor());
        MessageLocationHighlightRenderersEditors.getInstance().addRenderer(TextMessageLocationHighlight.class, new TextMessageLocationHighlightRenderer());
        for (AddOn.Status status : AddOn.Status.values()) {
            String string;
            try {
                string = Constant.messages.getString("cfu.status." + status.toString());
            }
            catch (MissingResourceException missingResourceException) {
                string = status.toString();
                String string2 = "Caught " + missingResourceException.getClass().getName() + " " + missingResourceException.getMessage() + " when looking for i18n string: cfu.status." + string;
                if (Constant.isDevBuild()) {
                    logger.error((Object)string2);
                }
                logger.warn((Object)string2);
            }
            this.statusMap.put(status, new StatusUI(status, string));
        }
    }

    public void postInit() {
        this.mainFrame.getWorkbench().addPanel(this.getOutputPanel(), WorkbenchPanel.PanelType.STATUS);
        this.refreshTabViewMenus();
        JMenuItem jMenuItem = new JMenuItem(Constant.messages.getString("menu.view.tabs.show"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View.this.showAllTabs();
            }
        });
        this.mainFrame.getMainMenuBar().getMenuView().add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(Constant.messages.getString("menu.view.tabs.hide"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View.this.hideAllTabs();
            }
        });
        this.mainFrame.getMainMenuBar().getMenuView().add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(Constant.messages.getString("menu.view.tabs.pin"));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View.this.pinAllTabs();
            }
        });
        this.mainFrame.getMainMenuBar().getMenuView().add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(Constant.messages.getString("menu.view.tabs.unpin"));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View.this.unpinAllTabs();
            }
        });
        this.mainFrame.getMainMenuBar().getMenuView().add(jMenuItem4);
        this.postInitialisation = true;
    }

    @Deprecated
    public MessagePanelsPositionController getMessagePanelsPositionController() {
        return new MessagePanelsPositionController(null, null, null, null);
    }

    public void refreshTabViewMenus() {
        if (this.menuShowTabs != null) {
            this.mainFrame.getMainMenuBar().getMenuView().remove(this.menuShowTabs);
        }
        this.menuShowTabs = new JMenu(Constant.messages.getString("menu.view.showtab"));
        this.mainFrame.getMainMenuBar().getMenuView().add(this.menuShowTabs);
        ExtensionKeyboard extensionKeyboard = (ExtensionKeyboard)Control.getSingleton().getExtensionLoader().getExtension("ExtensionKeyboard");
        for (AbstractPanel abstractPanel : this.getWorkbench().getSortedPanels(WorkbenchPanel.PanelType.SELECT)) {
            this.registerMenu(extensionKeyboard, abstractPanel);
        }
        this.menuShowTabs.addSeparator();
        for (AbstractPanel abstractPanel : this.getWorkbench().getSortedPanels(WorkbenchPanel.PanelType.WORK)) {
            this.registerMenu(extensionKeyboard, abstractPanel);
        }
        this.menuShowTabs.addSeparator();
        for (AbstractPanel abstractPanel : this.getWorkbench().getSortedPanels(WorkbenchPanel.PanelType.STATUS)) {
            this.registerMenu(extensionKeyboard, abstractPanel);
        }
    }

    private void registerMenu(ExtensionKeyboard extensionKeyboard, final AbstractPanel abstractPanel) {
        ZapMenuItem zapMenuItem = new ZapMenuItem(abstractPanel.getClass().getName(), MessageFormat.format(Constant.messages.getString("menu.view.tab"), abstractPanel.getName()), abstractPanel.getDefaultAccelerator());
        zapMenuItem.setMnemonic(abstractPanel.getMnemonic());
        if (abstractPanel.getIcon() != null) {
            zapMenuItem.setIcon(abstractPanel.getIcon());
        }
        zapMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View.this.getWorkbench().showPanel(abstractPanel);
            }
        });
        this.menuShowTabs.add(zapMenuItem);
        if (extensionKeyboard != null) {
            extensionKeyboard.registerMenuItem(zapMenuItem);
        }
    }

    public void showAllTabs() {
        this.getWorkbench().setPanelsVisible(true);
    }

    public void hideAllTabs() {
        this.getWorkbench().setPanelsVisible(false);
    }

    public void pinAllTabs() {
        this.getWorkbench().pinVisiblePanels();
    }

    public void unpinAllTabs() {
        this.getWorkbench().unpinVisiblePanels();
    }

    public void showSplashScreen() {
        if (Model.getSingleton().getOptionsParam().getViewParam().isShowSplashScreen()) {
            this.splashScreen = new SplashScreen();
        }
    }

    public void hideSplashScreen() {
        if (this.splashScreen != null) {
            this.splashScreen.close();
            this.splashScreen = null;
        }
    }

    public void setSplashScreenLoadingCompletion(double d) {
        if (this.splashScreen != null) {
            this.splashScreen.setLoadingCompletion(d);
        }
    }

    public void addSplashScreenLoadingCompletion(double d) {
        if (this.splashScreen != null) {
            this.splashScreen.addLoadingCompletion(d);
        }
    }

    @Override
    public int showConfirmDialog(String string) {
        return this.showConfirmDialog(this.getMainFrame(), string);
    }

    public int showConfirmDialog(JPanel jPanel, String string) {
        return JOptionPane.showConfirmDialog(jPanel, string, "OWASP ZAP", 2);
    }

    public int showConfirmDialog(Window window, String string) {
        return JOptionPane.showConfirmDialog(window, string, "OWASP ZAP", 2);
    }

    @Override
    public int showYesNoCancelDialog(String string) {
        return this.showYesNoCancelDialog(this.getMainFrame(), string);
    }

    public int showYesNoCancelDialog(JPanel jPanel, String string) {
        return JOptionPane.showConfirmDialog(jPanel, string, "OWASP ZAP", 1);
    }

    public int showYesNoCancelDialog(Window window, String string) {
        return JOptionPane.showConfirmDialog(window, string, "OWASP ZAP", 1);
    }

    @Override
    public void showWarningDialog(String string) {
        this.showWarningDialog(this.getMainFrame(), string);
    }

    public void showWarningDialog(JPanel jPanel, String string) {
        JOptionPane.showMessageDialog(jPanel, string, "OWASP ZAP", 2);
    }

    public void showWarningDialog(Window window, String string) {
        JOptionPane.showMessageDialog(window, string, "OWASP ZAP", 2);
    }

    @Override
    public void showMessageDialog(String string) {
        this.showMessageDialog(this.getMainFrame(), string);
    }

    public void showMessageDialog(JPanel jPanel, String string) {
        JOptionPane.showMessageDialog(jPanel, string, "OWASP ZAP", 1);
    }

    public void showMessageDialog(Window window, String string) {
        JOptionPane.showMessageDialog(window, string, "OWASP ZAP", 1);
    }

    private JCheckBox getRememberCheckbox() {
        if (this.rememberCheckbox == null) {
            this.rememberCheckbox = new JCheckBox(Constant.messages.getString("view.dialog.remember"));
        }
        return this.rememberCheckbox;
    }

    public boolean isRememberLastDialogChosen() {
        return this.getRememberCheckbox().isSelected();
    }

    public int showYesNoRememberDialog(Window window, String string) {
        this.getRememberCheckbox().setSelected(false);
        return JOptionPane.showConfirmDialog(window, new Object[]{string + "\n", this.getRememberCheckbox()}, "OWASP ZAP", 0);
    }

    public int showYesNoDialog(Window window, Object[] objectArray) {
        return JOptionPane.showConfirmDialog(window, objectArray, "OWASP ZAP", 0);
    }

    private JCheckBox getDontPromptCheckbox() {
        if (this.dontPromptCheckbox == null) {
            this.dontPromptCheckbox = new JCheckBox(Constant.messages.getString("view.dialog.dontPrompt"));
        }
        return this.dontPromptCheckbox;
    }

    public boolean isDontPromptLastDialogChosen() {
        return this.getDontPromptCheckbox().isSelected();
    }

    public int showConfirmDontPromptDialog(Window window, String string) {
        this.getDontPromptCheckbox().setSelected(false);
        return JOptionPane.showConfirmDialog(window, new Object[]{string + "\n", this.getDontPromptCheckbox()}, "OWASP ZAP", 2);
    }

    public void showWarningDontPromptDialog(Window window, String string) {
        this.getDontPromptCheckbox().setSelected(false);
        JOptionPane.showMessageDialog(window, new Object[]{string + "\n", this.getDontPromptCheckbox()}, "OWASP ZAP", 2);
    }

    public void showWarningDontPromptDialog(String string) {
        this.showWarningDontPromptDialog(this.getMainFrame(), string);
    }

    public static synchronized View getSingleton() {
        if (view == null) {
            if (daemon) {
                Exception exception = new Exception("Attempting to initialise View in daemon mode");
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                return null;
            }
            logger.info((Object)"Initialising View");
            view = new View();
            view.init();
        }
        return view;
    }

    public static boolean isInitialised() {
        return view != null;
    }

    public static void setDaemon(boolean bl) {
        daemon = bl;
    }

    @Override
    public SiteMapPanel getSiteTreePanel() {
        if (this.siteMapPanel == null) {
            this.siteMapPanel = new SiteMapPanel();
        }
        return this.siteMapPanel;
    }

    @Override
    public OutputPanel getOutputPanel() {
        if (this.outputPanel == null) {
            this.outputPanel = new OutputPanel();
            ExtensionHelp.enableHelpKey(this.outputPanel, "ui.tabs.output");
        }
        return this.outputPanel;
    }

    @Override
    public HttpPanelRequest getRequestPanel() {
        if (this.requestPanel == null) {
            this.requestPanel = new HttpPanelRequest(false, "view.main.");
            this.requestPanel.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/105.png")));
            this.requestPanel.setName(Constant.messages.getString("http.panel.request.title"));
            this.requestPanel.setEnableViewSelect(true);
            this.requestPanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
            this.requestPanel.setDefaultAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
            this.requestPanel.setMnemonic(Constant.messages.getChar("http.panel.request.mnemonic"));
        }
        return this.requestPanel;
    }

    @Override
    public HttpPanelResponse getResponsePanel() {
        if (this.responsePanel == null) {
            this.responsePanel = new HttpPanelResponse(false, "view.main.");
            this.responsePanel.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/106.png")));
            this.responsePanel.setName(Constant.messages.getString("http.panel.response.title"));
            this.responsePanel.setEnableViewSelect(false);
            this.responsePanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
            this.responsePanel.setDefaultAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8 | 1, false));
            this.responsePanel.setMnemonic(Constant.messages.getChar("http.panel.response.mnemonic"));
        }
        return this.responsePanel;
    }

    @Override
    public SessionDialog getSessionDialog() {
        if (this.sessionDialog == null) {
            String[] stringArray = new String[]{};
            String string = Constant.messages.getString("session.properties.title");
            String string2 = Constant.messages.getString("session.dialog.title");
            this.sessionDialog = new SessionDialog((Frame)this.getMainFrame(), true, string, string2);
            this.sessionDialog.addParamPanel(stringArray, new SessionGeneralPanel(), false);
            this.sessionDialog.addParamPanel(stringArray, new SessionExcludeFromProxyPanel(), false);
            this.sessionDialog.addParamPanel(stringArray, new SessionExcludeFromScanPanel(), false);
            this.sessionDialog.addParamPanel(stringArray, new SessionExcludeFromSpiderPanel(), false);
            this.sessionDialog.addParamPanel(stringArray, new ContextListPanel(), false);
        }
        return this.sessionDialog;
    }

    public void showSessionDialog(Session session, String string) {
        this.showSessionDialog(session, string, true, null);
    }

    public void showSessionDialog(Session session, String string, boolean bl) {
        this.showSessionDialog(session, string, bl, null);
    }

    public void showSessionDialog(Session session, String string, boolean bl, Runnable runnable) {
        if (this.sessionDialog == null) {
            this.getSessionDialog();
        }
        if (bl) {
            this.sessionDialog.recreateUISharedContexts(session);
        }
        this.sessionDialog.initParam(session);
        if (runnable != null) {
            runnable.run();
        }
        this.sessionDialog.setTitle(Constant.messages.getString("session.properties.title"));
        this.sessionDialog.showDialog(false, string);
    }

    public void addContext(Context context) {
        String string = Constant.messages.getString("context.list");
        ContextGeneralPanel contextGeneralPanel = new ContextGeneralPanel(context.getName(), context.getIndex());
        contextGeneralPanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(new String[]{string}, contextGeneralPanel, false);
        this.contextPanels.add(contextGeneralPanel);
        String[] stringArray = new String[]{string, contextGeneralPanel.getName()};
        ContextIncludePanel contextIncludePanel = new ContextIncludePanel(context);
        contextIncludePanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(stringArray, contextIncludePanel, false);
        this.contextPanels.add(contextIncludePanel);
        ContextExcludePanel contextExcludePanel = new ContextExcludePanel(context);
        contextExcludePanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(stringArray, contextExcludePanel, false);
        this.contextPanels.add(contextExcludePanel);
        ContextStructurePanel contextStructurePanel = new ContextStructurePanel(context);
        contextStructurePanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(stringArray, contextStructurePanel, false);
        this.contextPanels.add(contextStructurePanel);
        ContextTechnologyPanel contextTechnologyPanel = new ContextTechnologyPanel(context);
        contextTechnologyPanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(stringArray, contextTechnologyPanel, false);
        this.contextPanels.add(contextTechnologyPanel);
        for (ContextPanelFactory contextPanelFactory : this.contextPanelFactories) {
            this.addPanelForContext(context, contextPanelFactory, stringArray);
        }
        this.getSiteTreePanel().reloadContextTree();
    }

    private void addPanelForContext(Context context, ContextPanelFactory contextPanelFactory, String[] stringArray) {
        AbstractContextPropertiesPanel abstractContextPropertiesPanel = contextPanelFactory.getContextPanel(context);
        abstractContextPropertiesPanel.setSessionDialog(this.getSessionDialog());
        this.getSessionDialog().addParamPanel(stringArray, abstractContextPropertiesPanel, false);
        this.contextPanels.add(abstractContextPropertiesPanel);
        List<AbstractContextPropertiesPanel> list = this.contextPanelFactoriesPanels.get(contextPanelFactory);
        if (list == null) {
            list = new ArrayList<AbstractContextPropertiesPanel>();
            this.contextPanelFactoriesPanels.put(contextPanelFactory, list);
        }
        list.add(abstractContextPropertiesPanel);
    }

    public void renameContext(Context context) {
        ContextGeneralPanel contextGeneralPanel = this.getContextGeneralPanel(context);
        if (contextGeneralPanel != null) {
            this.getSessionDialog().renamePanel(contextGeneralPanel, context.getIndex() + ":" + context.getName());
        }
        this.getSiteTreePanel().reloadContextTree();
    }

    private ContextGeneralPanel getContextGeneralPanel(Context context) {
        for (AbstractParamPanel abstractParamPanel : this.contextPanels) {
            ContextGeneralPanel contextGeneralPanel;
            if (!(abstractParamPanel instanceof ContextGeneralPanel) || (contextGeneralPanel = (ContextGeneralPanel)abstractParamPanel).getContextIndex() != context.getIndex()) continue;
            return contextGeneralPanel;
        }
        return null;
    }

    public void changeContext(Context context) {
        this.getSiteTreePanel().contextChanged(context);
    }

    @Override
    public void addContextPanelFactory(ContextPanelFactory contextPanelFactory) {
        if (contextPanelFactory == null) {
            throw new IllegalArgumentException("Parameter contextPanelFactory must not be null.");
        }
        this.contextPanelFactories.add(contextPanelFactory);
        if (this.postInitialisation) {
            String string = Constant.messages.getString("context.list");
            for (Context context : Model.getSingleton().getSession().getContexts()) {
                ContextGeneralPanel contextGeneralPanel = this.getContextGeneralPanel(context);
                if (contextGeneralPanel == null) continue;
                this.addPanelForContext(context, contextPanelFactory, new String[]{string, contextGeneralPanel.getName()});
            }
        }
    }

    @Override
    public void removeContextPanelFactory(ContextPanelFactory contextPanelFactory) {
        if (contextPanelFactory == null) {
            throw new IllegalArgumentException("Parameter contextPanelFactory must not be null.");
        }
        if (this.contextPanelFactories.remove(contextPanelFactory)) {
            contextPanelFactory.discardContexts();
            List<AbstractContextPropertiesPanel> list = this.contextPanelFactoriesPanels.remove(contextPanelFactory);
            if (list != null) {
                for (AbstractContextPropertiesPanel abstractContextPropertiesPanel : list) {
                    this.getSessionDialog().removeParamPanel(abstractContextPropertiesPanel);
                }
                this.contextPanels.removeAll(list);
            }
        }
    }

    public void deleteContext(Context context) {
        ArrayList<AbstractContextPropertiesPanel> arrayList = new ArrayList<AbstractContextPropertiesPanel>();
        Iterator<Object> iterator = this.contextPanels.iterator();
        while (iterator.hasNext()) {
            AbstractContextPropertiesPanel object = iterator.next();
            if (object.getContextIndex() != context.getIndex()) continue;
            this.getSessionDialog().removeParamPanel(object);
            iterator.remove();
            arrayList.add(object);
        }
        for (ContextPanelFactory contextPanelFactory : this.contextPanelFactories) {
            contextPanelFactory.discardContext(context);
            List<AbstractContextPropertiesPanel> list = this.contextPanelFactoriesPanels.get(contextPanelFactory);
            if (list == null) continue;
            list.removeAll(arrayList);
        }
        this.getSiteTreePanel().reloadContextTree();
    }

    public void discardContexts() {
        for (AbstractParamPanel object : this.contextPanels) {
            this.getSessionDialog().removeParamPanel(object);
        }
        for (ContextPanelFactory contextPanelFactory : this.contextPanelFactories) {
            contextPanelFactory.discardContexts();
            this.contextPanelFactoriesPanels.remove(contextPanelFactory);
        }
        this.contextPanels.clear();
        this.getSiteTreePanel().reloadContextTree();
    }

    public OptionsDialog getOptionsDialog(String string) {
        if (this.optionsDialog == null) {
            this.optionsDialog = new OptionsDialog((Frame)this.getMainFrame(), true, string);
        }
        this.optionsDialog.setTitle(string);
        return this.optionsDialog;
    }

    public WorkbenchPanel getWorkbench() {
        return this.mainFrame.getWorkbench();
    }

    @Override
    public MainPopupMenu getPopupMenu() {
        MainPopupMenu mainPopupMenu = new MainPopupMenu(this.popupList, this);
        return mainPopupMenu;
    }

    public Vector<JMenuItem> getPopupList() {
        return this.popupList;
    }

    @Override
    public WaitMessageDialog getWaitMessageDialog(String string) {
        WaitMessageDialog waitMessageDialog = new WaitMessageDialog((Frame)this.getMainFrame(), true);
        waitMessageDialog.setText(string);
        waitMessageDialog.centreDialog();
        return waitMessageDialog;
    }

    public WaitMessageDialog getWaitMessageDialog(JFrame jFrame, String string) {
        WaitMessageDialog waitMessageDialog = new WaitMessageDialog((Frame)jFrame, true);
        waitMessageDialog.setText(string);
        waitMessageDialog.centreDialog();
        return waitMessageDialog;
    }

    public void addMainToolbarButton(JButton jButton) {
        this.getMainFrame().getMainToolbarPanel().addButton(jButton);
    }

    public void addMainToolbarSeparator() {
        this.getMainFrame().getMainToolbarPanel().addSeparator();
    }

    public void addMainToolbarButton(JToggleButton jToggleButton) {
        this.getMainFrame().getMainToolbarPanel().addButton(jToggleButton);
    }

    public void removeMainToolbarButton(JButton jButton) {
        this.getMainFrame().getMainToolbarPanel().removeButton(jButton);
    }

    public void removeMainToolbarButton(JToggleButton jToggleButton) {
        this.getMainFrame().getMainToolbarPanel().removeButton(jToggleButton);
    }

    public void addMainToolbarSeparator(JToolBar.Separator separator) {
        this.getMainFrame().getMainToolbarPanel().addSeparator(separator);
    }

    public void removeMainToolbarSeparator(JToolBar.Separator separator) {
        this.getMainFrame().getMainToolbarPanel().removeSeparator(separator);
    }

    public Component getSplashScreen() {
        return this.splashScreen;
    }

    public StatusUI getStatusUI(AddOn.Status status) {
        return this.statusMap.get((Object)status);
    }

    public void setMainToolbarVisible(boolean bl) {
        this.getMainFrame().setMainToolbarVisible(bl);
    }

    @Override
    public void displayMessage(Message message) {
        if (message == null) {
            this.getRequestPanel().clearView(true);
            this.getResponsePanel().clearView(false);
            return;
        }
        if (!(message instanceof HttpMessage)) {
            logger.warn((Object)("Unable to display message: " + message.getClass().getCanonicalName()));
            return;
        }
        HttpMessage httpMessage = (HttpMessage)message;
        if (httpMessage.getRequestHeader().isEmpty()) {
            this.getRequestPanel().clearView(true);
        } else {
            this.getRequestPanel().setMessage(httpMessage);
        }
        if (httpMessage.getResponseHeader().isEmpty()) {
            this.getResponsePanel().clearView(false);
        } else {
            this.getResponsePanel().setMessage(httpMessage, true);
        }
    }
}

