#############################################################################
##
#W  chains.g                 GAP4 Package `RCWA'                  Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of chains
##  of subgroups.
##
##  This is a list of descending chains of groups generated by 3 class
##  transpositions. The groups are represented by their positions in the
##  list 'grps'.
##
#############################################################################

return
[[1,2279],[2,2279],[3,202],[3,1625],[3,10077],[3,17521],[4,268],[4,2479],[5,328],
 [6,393],[6,2604],[7,202],[7,1625],[7,10077],[7,17521],[8,328],[9,569],[9,2780],
 [10,268],[10,2479],[11,569],[11,2780],[12,393],[12,2604],[24,26,23,1625],
 [24,26,23,3507],[24,26,23,3520,3507],[24,26,23,3836,3507],[24,26,23,38497,3507],
 [24,26,31,1625],[24,26,31,3507],[24,26,44,1625],[24,26,44,3507],[24,26,1291],
 [24,26,1296,1625],[24,26,1296,3507],[24,26,1306],[24,26,1309,1625],[24,26,1309,3507],
 [24,26,1432],[24,26,1625],[24,26,1658],[24,26,3502,3507],[24,26,3502,41069],
 [24,26,3507],[24,26,3508,3507],[24,26,3508,41069],[24,26,3517,3507],[24,26,3517,44904],
 [24,26,3518,3507],[24,26,3518,44904],[24,26,3633,3507],[24,26,3633,41069],
 [24,26,3634,3507],[24,26,3634,41069],[24,26,3824,3507],[24,26,3824,41069],
 [24,26,3833,3507],[24,26,3833,44904],[24,26,3834,3507],[24,26,3834,44904],
 [24,26,4139,3507],[24,26,4139,44904],[24,26,38294,3507],[24,26,38294,41069],
 [24,26,38295,3507],[24,26,38295,41069],[24,26,38304],[24,26,38485,3507],
 [24,26,38485,41069],[24,26,38494,3507],[24,26,38494,44904],[24,26,38495,3507],
 [24,26,38495,44904],[24,26,38800,3507],[24,26,38800,44904],[24,26,41069],
 [24,26,41078,41069],[24,26,41078,41411],[24,26,41078,44904],[24,26,41078,45501],
 [24,26,41079,41069],[24,26,41079,41411],[24,26,41079,44904],[24,26,41079,45501],
 [24,26,41081,41069],[24,26,41081,41411],[24,26,41081,44904],[24,26,41081,45501],
 [24,26,41113,41069],[24,26,41113,41411],[24,26,41113,44904],[24,26,41113,45501],
 [24,26,41114,41069],[24,26,41114,41411],[24,26,41114,44904],[24,26,41114,45501],
 [24,26,41116,41069],[24,26,41116,41411],[24,26,41116,44904],[24,26,41116,45501],
 [24,26,41384,41069],[24,26,41384,41411],[24,26,41384,44904],[24,26,41384,45501],
 [24,26,41386,41069],[24,26,41386,41411],[24,26,41386,44904],[24,26,41386,45501],
 [24,26,41411],[24,26,44633,41069],[24,26,44633,41411],[24,26,44633,44904],
 [24,26,44633,45501],[24,26,44634,41069],[24,26,44634,41411],[24,26,44634,44904],
 [24,26,44634,45501],[24,26,44636,41069],[24,26,44636,41411],[24,26,44636,44904],
 [24,26,44636,45501],[24,26,44904],[24,26,44906,41069],[24,26,44906,41411],
 [24,26,44906,44904],[24,26,44906,45501],[24,26,44931,41069],[24,26,44931,41411],
 [24,26,44931,44904],[24,26,44931,45501],[24,26,45499,41069],[24,26,45499,41411],
 [24,26,45499,44904],[24,26,45499,45501],[24,26,45501],[24,26,45526,41069],
 [24,26,45526,41411],[24,26,45526,44904],[24,26,45526,45501],[24,26,49471,41069],
 [24,26,49471,41411],[24,26,49471,44904],[24,26,49471,45501],[24,32,1291],[24,32,1306],
 [24,32,1432],[24,32,1625],[24,32,1658],[24,32,3507],[24,32,38304],[24,32,41069],
 [24,32,41411],[24,32,44904],[24,32,45501],[24,41,1291],[24,41,1306],[24,41,1432],
 [24,41,1625],[24,41,1658],[24,41,3507],[24,41,38304],[24,41,41069],[24,41,41411],
 [24,41,44904],[24,41,45501],[24,42,1291],[24,42,1306],[24,42,1432],[24,42,1625],
 [24,42,1658],[24,42,3507],[24,42,38304],[24,42,41069],[24,42,41411],[24,42,44904],
 [24,42,45501],[24,89,90,1336],[24,89,90,5692,5705],[24,89,90,5705],
 [24,89,90,5867,5705],[24,89,90,39286,5705],[24,89,94,1336],[24,89,94,5705],
 [24,89,107,1336],[24,89,107,5705],[24,89,1291],[24,89,1306],[24,89,1336],
 [24,89,1349,1336],[24,89,1349,5705],[24,89,1377],[24,89,1432],[24,89,1511,1336],
 [24,89,1511,5705],[24,89,5645,5705],[24,89,5645,38205],[24,89,5646,5705],
 [24,89,5646,38205],[24,89,5662,5705],[24,89,5662,38205],[24,89,5689,5705],
 [24,89,5689,38205],[24,89,5690,5705],[24,89,5690,39193],[24,89,5691,5705],
 [24,89,5691,39193],[24,89,5705],[24,89,5747,5705],[24,89,5747,38205],[24,89,5774,5705],
 [24,89,5774,39193],[24,89,5788,5705],[24,89,5788,39193],[24,89,5828,5705],
 [24,89,5828,39193],[24,89,38205],[24,89,38206,38205],[24,89,38206,38331],
 [24,89,38206,39193],[24,89,38206,40055],[24,89,38207,38205],[24,89,38207,38331],
 [24,89,38207,39193],[24,89,38207,40055],[24,89,38208,38205],[24,89,38208,38331],
 [24,89,38208,39193],[24,89,38208,40055],[24,89,38221,5705],[24,89,38221,38205],
 [24,89,38248,38205],[24,89,38248,38331],[24,89,38248,39193],[24,89,38248,40055],
 [24,89,38249,38205],[24,89,38249,38331],[24,89,38249,39193],[24,89,38249,40055],
 [24,89,38250,38205],[24,89,38250,38331],[24,89,38250,39193],[24,89,38250,40055],
 [24,89,38263,5705],[24,89,38263,38205],[24,89,38290,38205],[24,89,38290,38331],
 [24,89,38290,39193],[24,89,38290,40055],[24,89,38291,38205],[24,89,38291,38331],
 [24,89,38291,39193],[24,89,38291,40055],[24,89,38304],[24,89,38331],[24,89,39151,38205],
 [24,89,39151,38331],[24,89,39151,39193],[24,89,39151,40055],[24,89,39152,38205],
 [24,89,39152,38331],[24,89,39152,39193],[24,89,39152,40055],[24,89,39153,38205],
 [24,89,39153,38331],[24,89,39153,39193],[24,89,39153,40055],[24,89,39166,5705],
 [24,89,39166,38205],[24,89,39193],[24,89,39194,38205],[24,89,39194,38331],
 [24,89,39194,39193],[24,89,39194,40055],[24,89,39207,5705],[24,89,39207,39193],
 [24,89,39234,38205],[24,89,39234,38331],[24,89,39234,39193],[24,89,39234,40055],
 [24,89,39247,5705],[24,89,39247,39193],[24,89,40054,38205],[24,89,40054,38331],
 [24,89,40054,39193],[24,89,40054,40055],[24,89,40055],[24,89,40095,38205],
 [24,89,40095,38331],[24,89,40095,39193],[24,89,40095,40055],[24,89,40915,38205],
 [24,89,40915,38331],[24,89,40915,39193],[24,89,40915,40055],[24,89,40928,5705],
 [24,89,40928,39193],[24,91,1291],[24,91,1306],[24,91,1336],[24,91,1377],[24,91,1432],
 [24,91,5705],[24,91,38205],[24,91,38304],[24,91,38331],[24,91,39193],[24,91,40055],
 [24,92,1291],[24,92,1306],[24,92,1336],[24,92,1377],[24,92,1432],[24,92,5705],
 [24,92,38205],[24,92,38304],[24,92,38331],[24,92,39193],[24,92,40055],[24,93,1291],
 [24,93,1306],[24,93,1336],[24,93,1377],[24,93,1432],[24,93,5705],[24,93,38205],
 [24,93,38304],[24,93,38331],[24,93,39193],[24,93,40055],[24,156,1377],[24,156,1658],
 [24,156,1761],[24,156,7828],[24,156,7899,7813,7828],[24,156,7899,7813,42193],
 [24,156,7899,7818,7828],[24,156,7899,7818,40287],[24,156,7899,7821,7828],
 [24,156,7899,7821,40287],[24,156,7899,7828],[24,156,7899,7832,7828],
 [24,156,7899,7832,42193],[24,156,7899,7909,7828],[24,156,7899,7909,42193],
 [24,156,7899,7913,7828],[24,156,7899,7913,42193],[24,156,7899,8087,7828],
 [24,156,7899,8087,40287],[24,156,7899,8094,7828],[24,156,7899,8094,40287],
 [24,156,7899,8193,7828],[24,156,7899,8193,40287],[24,156,7899,8393,7828],
 [24,156,7899,8393,42193],[24,156,7899,40099,40287],[24,156,7899,40102,40287],
 [24,156,7899,40109,7828],[24,156,7899,40109,42193],[24,156,7899,40113,7828],
 [24,156,7899,40113,42193],[24,156,7899,40287],[24,156,7899,40294,7828],
 [24,156,7899,40294,40287],[24,156,7899,40298,40287],[24,156,7899,40393,7828],
 [24,156,7899,40393,40287],[24,156,7899,40397,40287],[24,156,7899,40593,7828],
 [24,156,7899,40593,42193],[24,156,7899,41887,40287],[24,156,7899,41894,42193],
 [24,156,7899,41898,42193],[24,156,7899,41993,42193],[24,156,7899,41997,42193],
 [24,156,7899,42193],[24,156,7899,45328,7828],[24,156,7899,45328,40287],
 [24,156,7899,45332,40287],[24,156,7899,45528,42193],[24,156,7899,47113,42193],
 [24,156,7902,7828],[24,156,7902,40287],[24,156,7902,42193],[24,156,8098,7828],
 [24,156,8098,40287],[24,156,8098,42193],[24,156,8197,7828],[24,156,8197,40287],
 [24,156,8197,42193],[24,156,40287],[24,156,42193],[24,158,1377],[24,158,1658],
 [24,158,1761],[24,158,7828],[24,158,40287],[24,158,42193],[24,163,1377],[24,163,1658],
 [24,163,1761],[24,163,7828],[24,163,40287],[24,163,42193],[24,166,1377],[24,166,1658],
 [24,166,1761],[24,166,7828],[24,166,40287],[24,166,42193],[24,173,1377],[24,173,1658],
 [24,173,1761],[24,173,7828],[24,173,40287],[24,173,42193],[24,177,1377],[24,177,1658],
 [24,177,1761],[24,177,7828],[24,177,40287],[24,177,42193],[24,1289,1291],
 [24,1289,1306],[24,1289,1336],[24,1289,1377],[24,1289,1432],[24,1289,5705],
 [24,1289,38205],[24,1289,38304],[24,1289,38331],[24,1289,39193],[24,1289,40055],
 [24,1290,1291],[24,1290,1306],[24,1290,1336],[24,1290,1377],[24,1290,1432],
 [24,1290,5705],[24,1290,38205],[24,1290,38304],[24,1290,38331],[24,1290,39193],
 [24,1290,40055],[24,1291],[24,1292,1291],[24,1292,1306],[24,1292,1336],[24,1292,1377],
 [24,1292,1432],[24,1292,5705],[24,1292,38205],[24,1292,38304],[24,1292,38331],
 [24,1292,39193],[24,1292,40055],[24,1293,1291],[24,1293,1306],[24,1293,1336],
 [24,1293,1377],[24,1293,1432],[24,1293,5705],[24,1293,38205],[24,1293,38304],
 [24,1293,38331],[24,1293,39193],[24,1293,40055],[24,1298,1291],[24,1298,1306],
 [24,1298,1432],[24,1298,1698],[24,1298,1761],[24,1298,38304],[24,1298,38557],
 [24,1298,38563,38557],[24,1298,38563,38921],[24,1298,38563,46064],[24,1298,38563,47090],
 [24,1298,38568,38557],[24,1298,38568,38921],[24,1298,38568,46064],[24,1298,38568,47090],
 [24,1298,38570,38557],[24,1298,38570,38921],[24,1298,38570,46064],[24,1298,38570,47090],
 [24,1298,38628,38557],[24,1298,38628,38921],[24,1298,38628,46064],[24,1298,38628,47090],
 [24,1298,38633,38557],[24,1298,38633,38921],[24,1298,38633,46064],[24,1298,38633,47090],
 [24,1298,38635,38557],[24,1298,38635,38921],[24,1298,38635,46064],[24,1298,38635,47090],
 [24,1298,38804,38557],[24,1298,38804,38921],[24,1298,38804,46064],[24,1298,38804,47090],
 [24,1298,38806,38557],[24,1298,38806,38921],[24,1298,38806,46064],[24,1298,38806,47090],
 [24,1298,38921],[24,1298,45888,38557],[24,1298,45888,38921],[24,1298,45888,46064],
 [24,1298,45888,47090],[24,1298,45893,38557],[24,1298,45893,38921],[24,1298,45893,46064],
 [24,1298,45893,47090],[24,1298,45895,38557],[24,1298,45895,38921],[24,1298,45895,46064],
 [24,1298,45895,47090],[24,1298,46064],[24,1298,46066,38557],[24,1298,46066,38921],
 [24,1298,46066,46064],[24,1298,46066,47090],[24,1298,46181,38557],[24,1298,46181,38921],
 [24,1298,46181,46064],[24,1298,46181,47090],[24,1298,47088,38557],[24,1298,47088,38921],
 [24,1298,47088,46064],[24,1298,47088,47090],[24,1298,47090],[24,1298,47205,38557],
 [24,1298,47205,38921],[24,1298,47205,46064],[24,1298,47205,47090],[24,1298,49565,38557],
 [24,1298,49565,38921],[24,1298,49565,46064],[24,1298,49565,47090],[24,1300,1291],
 [24,1300,1306],[24,1300,1432],[24,1300,1698],[24,1300,1761],[24,1300,38304],
 [24,1300,38557],[24,1300,38921],[24,1300,46064],[24,1300,47090],[24,1306],
 [24,1311,1291],[24,1311,1306],[24,1311,1432],[24,1311,1698],[24,1311,1761],
 [24,1311,38304],[24,1311,38557],[24,1311,38921],[24,1311,46064],[24,1311,47090],
 [24,1313,1291],[24,1313,1306],[24,1313,1432],[24,1313,1698],[24,1313,1761],
 [24,1313,38304],[24,1313,38557],[24,1313,38921],[24,1313,46064],[24,1313,47090],
 [24,1333,1291],[24,1333,1306],[24,1333,1336],[24,1333,1377],[24,1333,1432],
 [24,1333,5705],[24,1333,38205],[24,1333,38304],[24,1333,38331],[24,1333,39193],
 [24,1333,40055],[24,1334,1291],[24,1334,1306],[24,1334,1336],[24,1334,1377],
 [24,1334,1432],[24,1334,5705],[24,1334,38205],[24,1334,38304],[24,1334,38331],
 [24,1334,39193],[24,1334,40055],[24,1335,1291],[24,1335,1306],[24,1335,1336],
 [24,1335,1377],[24,1335,1432],[24,1335,5705],[24,1335,38205],[24,1335,38304],
 [24,1335,38331],[24,1335,39193],[24,1335,40055],[24,1336],[24,1339,1336],[24,1339,1625],
 [24,1339,1761],[24,1339,39276,42593],[24,1339,39280,42593],[24,1339,39289,39779],
 [24,1339,39291,39779],[24,1339,39391,42593],[24,1339,39400,39779],[24,1339,39402,39779],
 [24,1339,39534,39779],[24,1339,39536,39779],[24,1339,39779],[24,1339,42593],
 [24,1339,42602,42593],[24,1339,42604,42593],[24,1339,42736,42593],[24,1339,42738,42593],
 [24,1339,42981,39779],[24,1339,44735,42593],[24,1339,44737,42593],[24,1339,44980,39779],
 [24,1339,47160,39779],[24,1340,1336],[24,1340,1658],[24,1340,1698],[24,1340,39277,39424],
 [24,1340,39278,39424],[24,1340,39287,42936],[24,1340,39293,42936],[24,1340,39424],
 [24,1340,39433,39424],[24,1340,39439,39424],[24,1340,39467,39424],[24,1340,39473,39424],
 [24,1340,39734,42936],[24,1340,42626,39424],[24,1340,42635,42936],[24,1340,42641,42936],
 [24,1340,42669,42936],[24,1340,42675,42936],[24,1340,42936],[24,1340,45263,39424],
 [24,1340,45269,39424],[24,1340,45530,42936],[24,1340,46091,42936],[24,1341,1336],
 [24,1341,1658],[24,1341,1698],[24,1341,39424],[24,1341,42936],[24,1343,1336],
 [24,1343,1625],[24,1343,1761],[24,1343,39779],[24,1343,42593],[24,1350,1336],
 [24,1350,1658],[24,1350,1698],[24,1350,39424],[24,1350,42936],[24,1352,1336],
 [24,1352,1625],[24,1352,1761],[24,1352,39779],[24,1352,42593],[24,1354,1336],
 [24,1354,1625],[24,1354,1761],[24,1354,39779],[24,1354,42593],[24,1356,1336],
 [24,1356,1658],[24,1356,1698],[24,1356,39424],[24,1356,42936],[24,1376,1291],
 [24,1376,1306],[24,1376,1336],[24,1376,1377],[24,1376,1432],[24,1376,5705],
 [24,1376,38205],[24,1376,38304],[24,1376,38331],[24,1376,39193],[24,1376,40055],
 [24,1377],[24,1378,1291],[24,1378,1306],[24,1378,1336],[24,1378,1377],[24,1378,1432],
 [24,1378,5705],[24,1378,38205],[24,1378,38304],[24,1378,38331],[24,1378,39193],
 [24,1378,40055],[24,1381,1377],[24,1381,1625],[24,1381,1698],[24,1381,40098,41850],
 [24,1381,40100,41850],[24,1381,40111,40642],[24,1381,40115,40642],[24,1381,40250,41850],
 [24,1381,40261,40642],[24,1381,40265,40642],[24,1381,40330,40642],[24,1381,40334,40642],
 [24,1381,40642],[24,1381,41850],[24,1381,41861,41850],[24,1381,41865,41850],
 [24,1381,41930,41850],[24,1381,41934,41850],[24,1381,42242,40642],[24,1381,44670,41850],
 [24,1381,44674,41850],[24,1381,44982,40642],[24,1381,46138,40642],[24,1382,1377],
 [24,1382,1658],[24,1382,1761],[24,1382,7828],[24,1382,40287],[24,1382,42193],
 [24,1383,1377],[24,1383,1625],[24,1383,1698],[24,1383,40642],[24,1383,41850],
 [24,1385,1377],[24,1385,1658],[24,1385,1761],[24,1385,7828],[24,1385,40287],
 [24,1385,42193],[24,1392,1377],[24,1392,1658],[24,1392,1761],[24,1392,7828],
 [24,1392,40287],[24,1392,42193],[24,1394,1377],[24,1394,1625],[24,1394,1698],
 [24,1394,40642],[24,1394,41850],[24,1396,1377],[24,1396,1658],[24,1396,1761],
 [24,1396,7828],[24,1396,40287],[24,1396,42193],[24,1398,1377],[24,1398,1625],
 [24,1398,1698],[24,1398,40642],[24,1398,41850],[24,1418,1291],[24,1418,1306],
 [24,1418,1336],[24,1418,1377],[24,1418,1432],[24,1418,5705],[24,1418,38205],
 [24,1418,38304],[24,1418,38331],[24,1418,39193],[24,1418,40055],[24,1419,1291],
 [24,1419,1306],[24,1419,1336],[24,1419,1377],[24,1419,1432],[24,1419,5705],
 [24,1419,38205],[24,1419,38304],[24,1419,38331],[24,1419,39193],[24,1419,40055],
 [24,1422,1291],[24,1422,1306],[24,1422,1432],[24,1422,1625],[24,1422,1658],
 [24,1422,3507],[24,1422,38304],[24,1422,41069],[24,1422,41411],[24,1422,44904],
 [24,1422,45501],[24,1423,1291],[24,1423,1306],[24,1423,1432],[24,1423,1625],
 [24,1423,1658],[24,1423,3507],[24,1423,38304],[24,1423,41069],[24,1423,41411],
 [24,1423,44904],[24,1423,45501],[24,1432],[24,1433,1291],[24,1433,1306],[24,1433,1432],
 [24,1433,1625],[24,1433,1658],[24,1433,3507],[24,1433,38304],[24,1433,41069],
 [24,1433,41411],[24,1433,44904],[24,1433,45501],[24,1435,1291],[24,1435,1306],
 [24,1435,1432],[24,1435,1625],[24,1435,1658],[24,1435,3507],[24,1435,38304],
 [24,1435,41069],[24,1435,41411],[24,1435,44904],[24,1435,45501],[24,1459,1291],
 [24,1459,1306],[24,1459,1336],[24,1459,1377],[24,1459,1432],[24,1459,5705],
 [24,1459,38205],[24,1459,38304],[24,1459,38331],[24,1459,39193],[24,1459,40055],
 [24,1462,1377],[24,1462,1625],[24,1462,1698],[24,1462,40642],[24,1462,41850],
 [24,1463,1377],[24,1463,1658],[24,1463,1761],[24,1463,7828],[24,1463,40287],
 [24,1463,42193],[24,1464,1377],[24,1464,1625],[24,1464,1698],[24,1464,40642],
 [24,1464,41850],[24,1466,1377],[24,1466,1658],[24,1466,1761],[24,1466,7828],
 [24,1466,40287],[24,1466,42193],[24,1473,1377],[24,1473,1658],[24,1473,1761],
 [24,1473,7828],[24,1473,40287],[24,1473,42193],[24,1475,1377],[24,1475,1625],
 [24,1475,1698],[24,1475,40642],[24,1475,41850],[24,1477,1377],[24,1477,1658],
 [24,1477,1761],[24,1477,7828],[24,1477,40287],[24,1477,42193],[24,1479,1377],
 [24,1479,1625],[24,1479,1698],[24,1479,40642],[24,1479,41850],[24,1501,1336],
 [24,1501,1625],[24,1501,1761],[24,1501,39779],[24,1501,42593],[24,1502,1336],
 [24,1502,1658],[24,1502,1698],[24,1502,39424],[24,1502,42936],[24,1503,1336],
 [24,1503,1658],[24,1503,1698],[24,1503,39424],[24,1503,42936],[24,1505,1336],
 [24,1505,1625],[24,1505,1761],[24,1505,39779],[24,1505,42593],[24,1512,1336],
 [24,1512,1658],[24,1512,1698],[24,1512,39424],[24,1512,42936],[24,1514,1336],
 [24,1514,1625],[24,1514,1761],[24,1514,39779],[24,1514,42593],[24,1516,1336],
 [24,1516,1625],[24,1516,1761],[24,1516,39779],[24,1516,42593],[24,1518,1336],
 [24,1518,1658],[24,1518,1698],[24,1518,39424],[24,1518,42936],[24,1613,1291],
 [24,1613,1306],[24,1613,1432],[24,1613,1625],[24,1613,1658],[24,1613,3507],
 [24,1613,38304],[24,1613,41069],[24,1613,41411],[24,1613,44904],[24,1613,45501],
 [24,1614,1377],[24,1614,1625],[24,1614,1698],[24,1614,40642],[24,1614,41850],
 [24,1616,1336],[24,1616,1625],[24,1616,1761],[24,1616,39779],[24,1616,42593],
 [24,1622,1291],[24,1622,1306],[24,1622,1432],[24,1622,1625],[24,1622,1658],
 [24,1622,3507],[24,1622,38304],[24,1622,41069],[24,1622,41411],[24,1622,44904],
 [24,1622,45501],[24,1623,1291],[24,1623,1306],[24,1623,1432],[24,1623,1625],
 [24,1623,1658],[24,1623,3507],[24,1623,38304],[24,1623,41069],[24,1623,41411],
 [24,1623,44904],[24,1623,45501],[24,1625],[24,1627,1336],[24,1627,1625],[24,1627,1761],
 [24,1627,39779],[24,1627,42593],[24,1629,1377],[24,1629,1625],[24,1629,1698],
 [24,1629,40642],[24,1629,41850],[24,1649,1336],[24,1649,1658],[24,1649,1698],
 [24,1649,39424],[24,1649,42936],[24,1651,1377],[24,1651,1658],[24,1651,1761],
 [24,1651,7828],[24,1651,40287],[24,1651,42193],[24,1657,1291],[24,1657,1306],
 [24,1657,1432],[24,1657,1625],[24,1657,1658],[24,1657,3507],[24,1657,38304],
 [24,1657,41069],[24,1657,41411],[24,1657,44904],[24,1657,45501],[24,1658],
 [24,1660,1291],[24,1660,1306],[24,1660,1432],[24,1660,1625],[24,1660,1658],
 [24,1660,3507],[24,1660,38304],[24,1660,41069],[24,1660,41411],[24,1660,44904],
 [24,1660,45501],[24,1662,1377],[24,1662,1658],[24,1662,1761],[24,1662,7828],
 [24,1662,40287],[24,1662,42193],[24,1664,1336],[24,1664,1658],[24,1664,1698],
 [24,1664,39424],[24,1664,42936],[24,1685,1291],[24,1685,1306],[24,1685,1432],
 [24,1685,1698],[24,1685,1761],[24,1685,38304],[24,1685,38557],[24,1685,38921],
 [24,1685,46064],[24,1685,47090],[24,1691,1291],[24,1691,1306],[24,1691,1432],
 [24,1691,1698],[24,1691,1761],[24,1691,38304],[24,1691,38557],[24,1691,38921],
 [24,1691,46064],[24,1691,47090],[24,1692,1336],[24,1692,1658],[24,1692,1698],
 [24,1692,39424],[24,1692,42936],[24,1694,1377],[24,1694,1625],[24,1694,1698],
 [24,1694,40642],[24,1694,41850],[24,1696,1291],[24,1696,1306],[24,1696,1432],
 [24,1696,1698],[24,1696,1761],[24,1696,38304],[24,1696,38557],[24,1696,38921],
 [24,1696,46064],[24,1696,47090],[24,1698],[24,1756,1291],[24,1756,1306],[24,1756,1432],
 [24,1756,1698],[24,1756,1761],[24,1756,38304],[24,1756,38557],[24,1756,38921],
 [24,1756,46064],[24,1756,47090],[24,1757,1377],[24,1757,1658],[24,1757,1761],
 [24,1757,7828],[24,1757,40287],[24,1757,42193],[24,1759,1336],[24,1759,1625],
 [24,1759,1761],[24,1759,39779],[24,1759,42593],[24,1761],[24,1763,1291],[24,1763,1306],
 [24,1763,1432],[24,1763,1698],[24,1763,1761],[24,1763,38304],[24,1763,38557],
 [24,1763,38921],[24,1763,46064],[24,1763,47090],[24,1928,1291],[24,1928,1306],
 [24,1928,1432],[24,1928,1625],[24,1928,1658],[24,1928,3507],[24,1928,38304],
 [24,1928,41069],[24,1928,41411],[24,1928,44904],[24,1928,45501],[24,1930,1291],
 [24,1930,1306],[24,1930,1432],[24,1930,1625],[24,1930,1658],[24,1930,3507],
 [24,1930,38304],[24,1930,41069],[24,1930,41411],[24,1930,44904],[24,1930,45501],
 [24,1932,1291],[24,1932,1306],[24,1932,1432],[24,1932,1698],[24,1932,1761],
 [24,1932,38304],[24,1932,38557],[24,1932,38921],[24,1932,46064],[24,1932,47090],
 [24,1934,1291],[24,1934,1306],[24,1934,1432],[24,1934,1698],[24,1934,1761],
 [24,1934,38304],[24,1934,38557],[24,1934,38921],[24,1934,46064],[24,1934,47090],
 [24,1955,1291],[24,1955,1306],[24,1955,1432],[24,1955,1625],[24,1955,1658],
 [24,1955,3507],[24,1955,38304],[24,1955,41069],[24,1955,41411],[24,1955,44904],
 [24,1955,45501],[24,1957,1377],[24,1957,1658],[24,1957,1761],[24,1957,7828],
 [24,1957,40287],[24,1957,42193],[24,1959,1336],[24,1959,1658],[24,1959,1698],
 [24,1959,39424],[24,1959,42936],[24,2004,1336],[24,2004,1625],[24,2004,1761],
 [24,2004,39779],[24,2004,42593],[24,2006,1377],[24,2006,1625],[24,2006,1698],
 [24,2006,40642],[24,2006,41850],[24,2049,1291],[24,2049,1306],[24,2049,1432],
 [24,2049,1698],[24,2049,1761],[24,2049,38304],[24,2049,38557],[24,2049,38921],
 [24,2049,46064],[24,2049,47090],[24,2279],[24,2300,2279],[24,2300,3500,3507],
 [24,2300,3500,38205],[24,2300,3501,3507],[24,2300,3501,38205],[24,2300,3507],
 [24,2300,3544,3507],[24,2300,3544,38205],[24,2300,3550,3507],[24,2300,3550,38205],
 [24,2300,3592,3507],[24,2300,3592,38205],[24,2300,5695,5705],[24,2300,5695,44904],
 [24,2300,5705],[24,2300,5706,5705],[24,2300,5706,44904],[24,2300,5978,5705],
 [24,2300,5978,44904],[24,2300,5979,5705],[24,2300,5979,44904],[24,2300,6284,5705],
 [24,2300,6284,44904],[24,2300,7725,7828],[24,2300,7725,38205],[24,2300,7726,7828],
 [24,2300,7726,38205],[24,2300,7743,7828],[24,2300,7743,38205],[24,2300,7769,7828],
 [24,2300,7769,38205],[24,2300,7786,7828],[24,2300,7786,38205],[24,2300,7817,7828],
 [24,2300,7817,44904],[24,2300,7827,7828],[24,2300,7827,44904],[24,2300,7828],
 [24,2300,8058,7828],[24,2300,8058,44904],[24,2300,8059,7828],[24,2300,8059,44904],
 [24,2300,8364,7828],[24,2300,8364,44904],[24,2300,38205],[24,2300,38211,3507],
 [24,2300,38211,38205],[24,2300,38222,7828],[24,2300,38222,38205],[24,2300,38253,3507],
 [24,2300,38253,38205],[24,2300,38264,7828],[24,2300,38264,38205],[24,2300,39156,3507],
 [24,2300,39156,38205],[24,2300,39167,7828],[24,2300,39167,38205],[24,2300,39397,5705],
 [24,2300,39397,44904],[24,2300,39398,5705],[24,2300,39398,44904],[24,2300,39703,5705],
 [24,2300,39703,44904],[24,2300,40258,7828],[24,2300,40258,44904],[24,2300,40259,7828],
 [24,2300,40259,44904],[24,2300,40564,7828],[24,2300,40564,44904],[24,2300,44904],
 [24,2301,2279],[24,2301,3507],[24,2301,5705],[24,2301,7828],[24,2301,38205],
 [24,2301,44904],[24,2302,2279],[24,2302,3507],[24,2302,5705],[24,2302,7828],
 [24,2302,38205],[24,2302,44904],[24,2308,2279],[24,2308,3507],[24,2308,5705],
 [24,2308,7828],[24,2308,38205],[24,2308,44904],[24,2318,2279],[24,2318,3507],
 [24,2318,5705],[24,2318,7828],[24,2318,38205],[24,2318,44904],[24,2319,2279],
 [24,2319,3507],[24,2319,5705],[24,2319,7828],[24,2319,38205],[24,2319,44904],
 [24,2365,2279],[24,2365,3507],[24,2365,5705],[24,2365,7828],[24,2365,38205],
 [24,2365,44904],[24,2366,2279],[24,2366,3507],[24,2366,5705],[24,2366,7828],
 [24,2366,38205],[24,2366,44904],[24,2367,2279],[24,2367,3507],[24,2367,5705],
 [24,2367,7828],[24,2367,38205],[24,2367,44904],[24,2373,2279],[24,2373,3507],
 [24,2373,5705],[24,2373,7828],[24,2373,38205],[24,2373,44904],[24,2383,2279],
 [24,2383,3507],[24,2383,5705],[24,2383,7828],[24,2383,38205],[24,2383,44904],
 [24,2384,2279],[24,2384,3507],[24,2384,5705],[24,2384,7828],[24,2384,38205],
 [24,2384,44904],[24,3507],[24,3545,3503,3507],[24,3545,3503,3677],[24,3545,3503,3714],
 [24,3545,3503,38331],[24,3545,3503,38557],[24,3545,3503,41850],[24,3545,3503,42593],
 [24,3545,3504,3507],[24,3545,3504,3677],[24,3545,3504,3714],[24,3545,3504,38331],
 [24,3545,3504,38557],[24,3545,3504,41850],[24,3545,3504,42593],[24,3545,3507],
 [24,3545,3509,3507],[24,3545,3509,3677],[24,3545,3509,3714],[24,3545,3509,38331],
 [24,3545,3509,38557],[24,3545,3509,41850],[24,3545,3509,42593],[24,3545,3511,3507],
 [24,3545,3511,3677],[24,3545,3511,3714],[24,3545,3511,38331],[24,3545,3511,38557],
 [24,3545,3511,41850],[24,3545,3511,42593],[24,3545,3670,3507],[24,3545,3670,3677],
 [24,3545,3670,3714],[24,3545,3670,38331],[24,3545,3670,38557],[24,3545,3670,41850],
 [24,3545,3670,42593],[24,3545,3673,3507],[24,3545,3673,3677],[24,3545,3673,3714],
 [24,3545,3673,38331],[24,3545,3673,38557],[24,3545,3673,41850],[24,3545,3673,42593],
 [24,3545,3675,3507],[24,3545,3675,3677],[24,3545,3675,3714],[24,3545,3675,38331],
 [24,3545,3675,38557],[24,3545,3675,41850],[24,3545,3675,42593],[24,3545,3677],
 [24,3545,3712,3507],[24,3545,3712,3677],[24,3545,3712,3714],[24,3545,3712,38331],
 [24,3545,3712,38557],[24,3545,3712,41850],[24,3545,3712,42593],[24,3545,3714],
 [24,3545,3716,3507],[24,3545,3716,3677],[24,3545,3716,3714],[24,3545,3716,38331],
 [24,3545,3716,38557],[24,3545,3716,41850],[24,3545,3716,42593],[24,3545,3825,3507],
 [24,3545,3825,3677],[24,3545,3825,3714],[24,3545,3825,38331],[24,3545,3825,38557],
 [24,3545,3825,41850],[24,3545,3825,42593],[24,3545,3827,3507],[24,3545,3827,3677],
 [24,3545,3827,3714],[24,3545,3827,38331],[24,3545,3827,38557],[24,3545,3827,41850],
 [24,3545,3827,42593],[24,3545,3896,3507],[24,3545,3896,3677],[24,3545,3896,3714],
 [24,3545,3896,38331],[24,3545,3896,38557],[24,3545,3896,41850],[24,3545,3896,42593],
 [24,3545,38205],[24,3545,38212,38205],[24,3545,38212,38557],[24,3545,38212,39424],
 [24,3545,38212,40287],[24,3545,38213,38205],[24,3545,38213,38557],[24,3545,38213,39424],
 [24,3545,38213,40287],[24,3545,38215,38205],[24,3545,38215,38557],[24,3545,38215,39424],
 [24,3545,38215,40287],[24,3545,38254,38205],[24,3545,38254,38557],[24,3545,38254,39424],
 [24,3545,38254,40287],[24,3545,38255,38205],[24,3545,38255,38557],[24,3545,38255,39424],
 [24,3545,38255,40287],[24,3545,38257,38205],[24,3545,38257,38557],[24,3545,38257,39424],
 [24,3545,38257,40287],[24,3545,38296,38557],[24,3545,38298,38557],[24,3545,38331],
 [24,3545,38334,3507],[24,3545,38334,3677],[24,3545,38334,3714],[24,3545,38334,38331],
 [24,3545,38334,38557],[24,3545,38334,41850],[24,3545,38334,42593],[24,3545,38335,38331],
 [24,3545,38336,3507],[24,3545,38336,3677],[24,3545,38336,3714],[24,3545,38336,38331],
 [24,3545,38336,38557],[24,3545,38336,41850],[24,3545,38336,42593],[24,3545,38338,3507],
 [24,3545,38338,3677],[24,3545,38338,3714],[24,3545,38338,38331],[24,3545,38338,38557],
 [24,3545,38338,41850],[24,3545,38338,42593],[24,3545,38373,3507],[24,3545,38373,3677],
 [24,3545,38373,3714],[24,3545,38373,38331],[24,3545,38373,38557],[24,3545,38373,41850],
 [24,3545,38373,42593],[24,3545,38374,38331],[24,3545,38375,3507],[24,3545,38375,3677],
 [24,3545,38375,3714],[24,3545,38375,38331],[24,3545,38375,38557],[24,3545,38375,41850],
 [24,3545,38375,42593],[24,3545,38377,3507],[24,3545,38377,3677],[24,3545,38377,3714],
 [24,3545,38377,38331],[24,3545,38377,38557],[24,3545,38377,41850],[24,3545,38377,42593],
 [24,3545,38486,3507],[24,3545,38486,3677],[24,3545,38486,3714],[24,3545,38486,38331],
 [24,3545,38486,38557],[24,3545,38486,41850],[24,3545,38486,42593],[24,3545,38488,3507],
 [24,3545,38488,3677],[24,3545,38488,3714],[24,3545,38488,38331],[24,3545,38488,38557],
 [24,3545,38488,41850],[24,3545,38488,42593],[24,3545,38521,38205],[24,3545,38521,38557],
 [24,3545,38521,39424],[24,3545,38521,40287],[24,3545,38523,38205],[24,3545,38523,38557],
 [24,3545,38523,39424],[24,3545,38523,40287],[24,3545,38557],[24,3545,39157,38205],
 [24,3545,39157,38557],[24,3545,39157,39424],[24,3545,39157,40287],[24,3545,39158,38205],
 [24,3545,39158,38557],[24,3545,39158,39424],[24,3545,39158,40287],[24,3545,39160,38205],
 [24,3545,39160,38557],[24,3545,39160,39424],[24,3545,39160,40287],[24,3545,39193],
 [24,3545,39197,39193],[24,3545,39197,39424],[24,3545,39197,41069],[24,3545,39197,41850],
 [24,3545,39198,39193],[24,3545,39198,39424],[24,3545,39198,41069],[24,3545,39198,41850],
 [24,3545,39199,39193],[24,3545,39199,39424],[24,3545,39199,41069],[24,3545,39199,41850],
 [24,3545,39201,39193],[24,3545,39237,39193],[24,3545,39237,39424],[24,3545,39237,41069],
 [24,3545,39237,41850],[24,3545,39238,39193],[24,3545,39238,39424],[24,3545,39238,41069],
 [24,3545,39238,41850],[24,3545,39239,39193],[24,3545,39239,39424],[24,3545,39239,41069],
 [24,3545,39239,41850],[24,3545,39241,39193],[24,3545,39388,39193],[24,3545,39388,39424],
 [24,3545,39388,41069],[24,3545,39388,41850],[24,3545,39389,39193],[24,3545,39389,39424],
 [24,3545,39389,41069],[24,3545,39389,41850],[24,3545,39424],[24,3545,39426,38205],
 [24,3545,39426,38557],[24,3545,39426,39424],[24,3545,39426,40287],[24,3545,39460,38205],
 [24,3545,39460,38557],[24,3545,39460,39424],[24,3545,39460,40287],[24,3545,40055],
 [24,3545,40058,40055],[24,3545,40058,40287],[24,3545,40058,41069],[24,3545,40058,42593],
 [24,3545,40059,40055],[24,3545,40059,40287],[24,3545,40059,41069],[24,3545,40059,42593],
 [24,3545,40060,40055],[24,3545,40062,40055],[24,3545,40062,40287],[24,3545,40062,41069],
 [24,3545,40062,42593],[24,3545,40137,40055],[24,3545,40137,40287],[24,3545,40137,41069],
 [24,3545,40137,42593],[24,3545,40138,40055],[24,3545,40138,40287],[24,3545,40138,41069],
 [24,3545,40138,42593],[24,3545,40139,40055],[24,3545,40141,40055],[24,3545,40141,40287],
 [24,3545,40141,41069],[24,3545,40141,42593],[24,3545,40249,40055],[24,3545,40249,40287],
 [24,3545,40249,41069],[24,3545,40249,42593],[24,3545,40252,40055],[24,3545,40252,40287],
 [24,3545,40252,41069],[24,3545,40252,42593],[24,3545,40285,38205],[24,3545,40285,38557],
 [24,3545,40285,39424],[24,3545,40285,40287],[24,3545,40287],[24,3545,40321,38205],
 [24,3545,40321,38557],[24,3545,40321,39424],[24,3545,40321,40287],[24,3545,40918,39193],
 [24,3545,40918,39424],[24,3545,40918,41069],[24,3545,40918,41850],[24,3545,40919,39193],
 [24,3545,40919,39424],[24,3545,40919,41069],[24,3545,40919,41850],[24,3545,40920,39193],
 [24,3545,40920,39424],[24,3545,40920,41069],[24,3545,40920,41850],[24,3545,40922,39193],
 [24,3545,40957,40055],[24,3545,40957,40287],[24,3545,40957,41069],[24,3545,40957,42593],
 [24,3545,40958,40055],[24,3545,40958,40287],[24,3545,40958,41069],[24,3545,40958,42593],
 [24,3545,40959,40055],[24,3545,40961,40055],[24,3545,40961,40287],[24,3545,40961,41069],
 [24,3545,40961,42593],[24,3545,41069],[24,3545,41070,39193],[24,3545,41070,39424],
 [24,3545,41070,41069],[24,3545,41070,41850],[24,3545,41072,40055],[24,3545,41072,40287],
 [24,3545,41072,41069],[24,3545,41072,42593],[24,3545,41105,39193],[24,3545,41105,39424],
 [24,3545,41105,41069],[24,3545,41105,41850],[24,3545,41107,40055],[24,3545,41107,40287],
 [24,3545,41107,41069],[24,3545,41107,42593],[24,3545,41141,38557],[24,3545,41737,3507],
 [24,3545,41737,3677],[24,3545,41737,3714],[24,3545,41737,38331],[24,3545,41737,38557],
 [24,3545,41737,41850],[24,3545,41737,42593],[24,3545,41738,38331],[24,3545,41739,3507],
 [24,3545,41739,3677],[24,3545,41739,3714],[24,3545,41739,38331],[24,3545,41739,38557],
 [24,3545,41739,41850],[24,3545,41739,42593],[24,3545,41741,3507],[24,3545,41741,3677],
 [24,3545,41741,3714],[24,3545,41741,38331],[24,3545,41741,38557],[24,3545,41741,41850],
 [24,3545,41741,42593],[24,3545,41849,39193],[24,3545,41849,39424],[24,3545,41849,41069],
 [24,3545,41849,41850],[24,3545,41850],[24,3545,41852,3507],[24,3545,41852,3677],
 [24,3545,41852,3714],[24,3545,41852,38331],[24,3545,41852,38557],[24,3545,41852,41850],
 [24,3545,41852,42593],[24,3545,41885,39193],[24,3545,41885,39424],[24,3545,41885,41069],
 [24,3545,41885,41850],[24,3545,41921,3507],[24,3545,41921,3677],[24,3545,41921,3714],
 [24,3545,41921,38331],[24,3545,41921,38557],[24,3545,41921,41850],[24,3545,41921,42593],
 [24,3545,42590,40055],[24,3545,42590,40287],[24,3545,42590,41069],[24,3545,42590,42593],
 [24,3545,42591,3507],[24,3545,42591,3677],[24,3545,42591,3714],[24,3545,42591,38331],
 [24,3545,42591,38557],[24,3545,42591,41850],[24,3545,42591,42593],[24,3545,42593],
 [24,3545,42628,40055],[24,3545,42628,40287],[24,3545,42628,41069],[24,3545,42628,42593],
 [24,3545,42662,3507],[24,3545,42662,3677],[24,3545,42662,3714],[24,3545,42662,38331],
 [24,3545,42662,38557],[24,3545,42662,41850],[24,3545,42662,42593],[24,3545,44625,39193],
 [24,3545,44625,39424],[24,3545,44625,41069],[24,3545,44625,41850],[24,3545,44627,40055],
 [24,3545,44627,40287],[24,3545,44627,41069],[24,3545,44627,42593],[24,3545,44661,3507],
 [24,3545,44661,3677],[24,3545,44661,3714],[24,3545,44661,38331],[24,3545,44661,38557],
 [24,3545,44661,41850],[24,3545,44661,42593],[24,3545,45256,38205],[24,3545,45256,38557],
 [24,3545,45256,39424],[24,3545,45256,40287],[24,3546,3507],[24,3546,3677],[24,3546,3714],
 [24,3546,38205],[24,3546,38331],[24,3546,38557],[24,3546,39193],[24,3546,39424],
 [24,3546,40055],[24,3546,40287],[24,3546,41069],[24,3546,41850],[24,3546,42593],
 [24,3547,3507],[24,3547,3677],[24,3547,3714],[24,3547,38205],[24,3547,38331],
 [24,3547,38557],[24,3547,39193],[24,3547,39424],[24,3547,40055],[24,3547,40287],
 [24,3547,41069],[24,3547,41850],[24,3547,42593],[24,3551,3507],[24,3551,3677],
 [24,3551,3714],[24,3551,38205],[24,3551,38331],[24,3551,38557],[24,3551,39193],
 [24,3551,39424],[24,3551,40055],[24,3551,40287],[24,3551,41069],[24,3551,41850],
 [24,3551,42593],[24,3552,3507],[24,3552,3677],[24,3552,3714],[24,3552,38205],
 [24,3552,38331],[24,3552,38557],[24,3552,39193],[24,3552,39424],[24,3552,40055],
 [24,3552,40287],[24,3552,41069],[24,3552,41850],[24,3552,42593],[24,3554,3507],
 [24,3554,3677],[24,3554,3714],[24,3554,38205],[24,3554,38331],[24,3554,38557],
 [24,3554,39193],[24,3554,39424],[24,3554,40055],[24,3554,40287],[24,3554,41069],
 [24,3554,41850],[24,3554,42593],[24,3560,2279],[24,3560,3507],[24,3560,5705],
 [24,3560,7828],[24,3560,38205],[24,3560,44904],[24,3561,2279],[24,3561,3507],
 [24,3561,5705],[24,3561,7828],[24,3561,38205],[24,3561,44904],[24,3563,3507],
 [24,3563,3522,3507],[24,3563,3522,38921],[24,3563,3524,3507],[24,3563,3524,38921],
 [24,3563,3838,3507],[24,3563,3838,38921],[24,3563,3840,3507],[24,3563,3840,38921],
 [24,3563,4260,3507],[24,3563,4260,38921],[24,3563,38205],[24,3563,38224,38205],
 [24,3563,38224,38921],[24,3563,38224,39779],[24,3563,38224,40642],[24,3563,38226,38205],
 [24,3563,38226,38921],[24,3563,38226,39779],[24,3563,38226,40642],[24,3563,38228,38205],
 [24,3563,38228,38921],[24,3563,38228,39779],[24,3563,38228,40642],[24,3563,38266,38205],
 [24,3563,38266,38921],[24,3563,38266,39779],[24,3563,38266,40642],[24,3563,38268,38205],
 [24,3563,38268,38921],[24,3563,38268,39779],[24,3563,38268,40642],[24,3563,38270,38205],
 [24,3563,38270,38921],[24,3563,38270,39779],[24,3563,38270,40642],[24,3563,38499,3507],
 [24,3563,38499,38921],[24,3563,38501,3507],[24,3563,38501,38921],[24,3563,38876,38205],
 [24,3563,38876,38921],[24,3563,38876,39779],[24,3563,38876,40642],[24,3563,38878,38205],
 [24,3563,38878,38921],[24,3563,38878,39779],[24,3563,38878,40642],[24,3563,38921],
 [24,3563,39169,38205],[24,3563,39169,38921],[24,3563,39169,39779],[24,3563,39169,40642],
 [24,3563,39171,38205],[24,3563,39171,38921],[24,3563,39171,39779],[24,3563,39171,40642],
 [24,3563,39173,38205],[24,3563,39173,38921],[24,3563,39173,39779],[24,3563,39173,40642],
 [24,3563,39779],[24,3563,39781,38205],[24,3563,39781,38921],[24,3563,39781,39779],
 [24,3563,39781,40642],[24,3563,39824,38205],[24,3563,39824,38921],[24,3563,39824,39779],
 [24,3563,39824,40642],[24,3563,40640,38205],[24,3563,40640,38921],[24,3563,40640,39779],
 [24,3563,40640,40642],[24,3563,40642],[24,3563,40685,38205],[24,3563,40685,38921],
 [24,3563,40685,39779],[24,3563,40685,40642],[24,3563,45025,3507],[24,3563,45025,38921],
 [24,3563,50394,38205],[24,3563,50394,38921],[24,3563,50394,39779],[24,3563,50394,40642],
 [24,3565,3507],[24,3565,38205],[24,3565,38921],[24,3565,39779],[24,3565,40642],
 [24,3567,3507],[24,3567,38205],[24,3567,38921],[24,3567,39779],[24,3567,40642],
 [24,3587,3507],[24,3587,3677],[24,3587,3714],[24,3587,38205],[24,3587,38331],
 [24,3587,38557],[24,3587,39193],[24,3587,39424],[24,3587,40055],[24,3587,40287],
 [24,3587,41069],[24,3587,41850],[24,3587,42593],[24,3588,3507],[24,3588,3677],
 [24,3588,3714],[24,3588,38205],[24,3588,38331],[24,3588,38557],[24,3588,39193],
 [24,3588,39424],[24,3588,40055],[24,3588,40287],[24,3588,41069],[24,3588,41850],
 [24,3588,42593],[24,3589,3507],[24,3589,3677],[24,3589,3714],[24,3589,38205],
 [24,3589,38331],[24,3589,38557],[24,3589,39193],[24,3589,39424],[24,3589,40055],
 [24,3589,40287],[24,3589,41069],[24,3589,41850],[24,3589,42593],[24,3593,3507],
 [24,3593,3677],[24,3593,3714],[24,3593,38205],[24,3593,38331],[24,3593,38557],
 [24,3593,39193],[24,3593,39424],[24,3593,40055],[24,3593,40287],[24,3593,41069],
 [24,3593,41850],[24,3593,42593],[24,3594,3507],[24,3594,3677],[24,3594,3714],
 [24,3594,38205],[24,3594,38331],[24,3594,38557],[24,3594,39193],[24,3594,39424],
 [24,3594,40055],[24,3594,40287],[24,3594,41069],[24,3594,41850],[24,3594,42593],
 [24,3596,3507],[24,3596,3677],[24,3596,3714],[24,3596,38205],[24,3596,38331],
 [24,3596,38557],[24,3596,39193],[24,3596,39424],[24,3596,40055],[24,3596,40287],
 [24,3596,41069],[24,3596,41850],[24,3596,42593],[24,3602,2279],[24,3602,3507],
 [24,3602,5705],[24,3602,7828],[24,3602,38205],[24,3602,44904],[24,3603,2279],
 [24,3603,3507],[24,3603,5705],[24,3603,7828],[24,3603,38205],[24,3603,44904],
 [24,3605,3507],[24,3605,38205],[24,3605,38921],[24,3605,39779],[24,3605,40642],
 [24,3607,3507],[24,3607,38205],[24,3607,38921],[24,3607,39779],[24,3607,40642],
 [24,3609,3507],[24,3609,38205],[24,3609,38921],[24,3609,39779],[24,3609,40642],
 [24,3629,3507],[24,3629,3677],[24,3629,3714],[24,3629,38205],[24,3629,38331],
 [24,3629,38557],[24,3629,39193],[24,3629,39424],[24,3629,40055],[24,3629,40287],
 [24,3629,41069],[24,3629,41850],[24,3629,42593],[24,3630,3507],[24,3630,3677],
 [24,3630,3714],[24,3630,38205],[24,3630,38331],[24,3630,38557],[24,3630,39193],
 [24,3630,39424],[24,3630,40055],[24,3630,40287],[24,3630,41069],[24,3630,41850],
 [24,3630,42593],[24,3635,3507],[24,3635,3677],[24,3635,3714],[24,3635,38205],
 [24,3635,38331],[24,3635,38557],[24,3635,39193],[24,3635,39424],[24,3635,40055],
 [24,3635,40287],[24,3635,41069],[24,3635,41850],[24,3635,42593],[24,3637,3507],
 [24,3637,3677],[24,3637,3714],[24,3637,38205],[24,3637,38331],[24,3637,38557],
 [24,3637,39193],[24,3637,39424],[24,3637,40055],[24,3637,40287],[24,3637,41069],
 [24,3637,41850],[24,3637,42593],[24,3643,1291],[24,3643,1306],[24,3643,1432],
 [24,3643,1625],[24,3643,1658],[24,3643,3507],[24,3643,38304],[24,3643,41069],
 [24,3643,41411],[24,3643,44904],[24,3643,45501],[24,3644,1291],[24,3644,1306],
 [24,3644,1432],[24,3644,1625],[24,3644,1658],[24,3644,3507],[24,3644,38304],
 [24,3644,41069],[24,3644,41411],[24,3644,44904],[24,3644,45501],[24,3646,1291],
 [24,3646,1306],[24,3646,1432],[24,3646,1625],[24,3646,1658],[24,3646,3507],
 [24,3646,38304],[24,3646,41069],[24,3646,41411],[24,3646,44904],[24,3646,45501],
 [24,3648,3507],[24,3648,38309,38921],[24,3648,38311,38921],[24,3648,38534,38921],
 [24,3648,38536,38921],[24,3648,38921],[24,3648,41069],[24,3648,41083,41069],
 [24,3648,41085,41069],[24,3648,41118,41069],[24,3648,41120,41069],[24,3648,41505,38921],
 [24,3648,44638,41069],[24,3648,44640,41069],[24,3648,45620,38921],[24,3650,3507],
 [24,3650,38921],[24,3650,41069],[24,3674,3507],[24,3674,3677],[24,3674,3714],
 [24,3674,38205],[24,3674,38331],[24,3674,38557],[24,3674,39193],[24,3674,39424],
 [24,3674,40055],[24,3674,40287],[24,3674,41069],[24,3674,41850],[24,3674,42593],
 [24,3677],[24,3683,3507],[24,3683,3677],[24,3683,3714],[24,3683,38331],
 [24,3683,38344,38331],[24,3683,38345,38331],[24,3683,38345,38921],[24,3683,38345,42193],
 [24,3683,38345,42936],[24,3683,38349,38331],[24,3683,38349,38921],[24,3683,38349,42193],
 [24,3683,38349,42936],[24,3683,38351,38331],[24,3683,38351,38921],[24,3683,38351,42193],
 [24,3683,38351,42936],[24,3683,38383,38331],[24,3683,38384,38331],[24,3683,38384,38921],
 [24,3683,38384,42193],[24,3683,38384,42936],[24,3683,38388,38331],[24,3683,38388,38921],
 [24,3683,38388,42193],[24,3683,38388,42936],[24,3683,38390,38331],[24,3683,38390,38921],
 [24,3683,38390,42193],[24,3683,38390,42936],[24,3683,38557],[24,3683,38564,38557],
 [24,3683,38629,38557],[24,3683,38829,38331],[24,3683,38829,38921],[24,3683,38829,42193],
 [24,3683,38829,42936],[24,3683,38831,38331],[24,3683,38831,38921],[24,3683,38831,42193],
 [24,3683,38831,42936],[24,3683,38921],[24,3683,41747,38331],[24,3683,41748,38331],
 [24,3683,41748,38921],[24,3683,41748,42193],[24,3683,41748,42936],[24,3683,41752,38331],
 [24,3683,41752,38921],[24,3683,41752,42193],[24,3683,41752,42936],[24,3683,41754,38331],
 [24,3683,41754,38921],[24,3683,41754,42193],[24,3683,41754,42936],[24,3683,41850],
 [24,3683,41858,41850],[24,3683,41858,42193],[24,3683,41858,44904],[24,3683,41858,46064],
 [24,3683,41859,41850],[24,3683,41859,42193],[24,3683,41859,44904],[24,3683,41859,46064],
 [24,3683,41863,41850],[24,3683,41863,42193],[24,3683,41863,44904],[24,3683,41863,46064],
 [24,3683,41927,41850],[24,3683,41927,42193],[24,3683,41927,44904],[24,3683,41927,46064],
 [24,3683,41928,41850],[24,3683,41928,42193],[24,3683,41928,44904],[24,3683,41928,46064],
 [24,3683,41932,41850],[24,3683,41932,42193],[24,3683,41932,44904],[24,3683,41932,46064],
 [24,3683,41992,47090],[24,3683,41999,47090],[24,3683,42164,41850],[24,3683,42164,42193],
 [24,3683,42164,44904],[24,3683,42164,46064],[24,3683,42168,41850],[24,3683,42168,42193],
 [24,3683,42168,44904],[24,3683,42168,46064],[24,3683,42170,47090],[24,3683,42193],
 [24,3683,42195,38331],[24,3683,42195,38921],[24,3683,42195,42193],[24,3683,42195,42936],
 [24,3683,42285,38331],[24,3683,42285,38921],[24,3683,42285,42193],[24,3683,42285,42936],
 [24,3683,42593],[24,3683,42599,42593],[24,3683,42599,42936],[24,3683,42599,44904],
 [24,3683,42599,47090],[24,3683,42600,42593],[24,3683,42600,42936],[24,3683,42600,44904],
 [24,3683,42600,47090],[24,3683,42606,42593],[24,3683,42606,42936],[24,3683,42606,44904],
 [24,3683,42606,47090],[24,3683,42668,46064],[24,3683,42673,46064],[24,3683,42733,42593],
 [24,3683,42733,42936],[24,3683,42733,44904],[24,3683,42733,47090],[24,3683,42734,42593],
 [24,3683,42734,42936],[24,3683,42734,44904],[24,3683,42734,47090],[24,3683,42740,42593],
 [24,3683,42740,42936],[24,3683,42740,44904],[24,3683,42740,47090],[24,3683,42905,42593],
 [24,3683,42905,42936],[24,3683,42905,44904],[24,3683,42905,47090],[24,3683,42909,46064],
 [24,3683,42911,42593],[24,3683,42911,42936],[24,3683,42911,44904],[24,3683,42911,47090],
 [24,3683,42934,38331],[24,3683,42934,38921],[24,3683,42934,42193],[24,3683,42934,42936],
 [24,3683,42936],[24,3683,43026,38331],[24,3683,43026,38921],[24,3683,43026,42193],
 [24,3683,43026,42936],[24,3683,44667,41850],[24,3683,44667,42193],[24,3683,44667,44904],
 [24,3683,44667,46064],[24,3683,44668,41850],[24,3683,44668,42193],[24,3683,44668,44904],
 [24,3683,44668,46064],[24,3683,44672,41850],[24,3683,44672,42193],[24,3683,44672,44904],
 [24,3683,44672,46064],[24,3683,44732,42593],[24,3683,44732,42936],[24,3683,44732,44904],
 [24,3683,44732,47090],[24,3683,44733,42593],[24,3683,44733,42936],[24,3683,44733,44904],
 [24,3683,44733,47090],[24,3683,44739,42593],[24,3683,44739,42936],[24,3683,44739,44904],
 [24,3683,44739,47090],[24,3683,44904],[24,3683,44908,41850],[24,3683,44908,42193],
 [24,3683,44908,44904],[24,3683,44908,46064],[24,3683,44910,42593],[24,3683,44910,42936],
 [24,3683,44910,44904],[24,3683,44910,47090],[24,3683,44933,41850],[24,3683,44933,42193],
 [24,3683,44933,44904],[24,3683,44933,46064],[24,3683,44935,42593],[24,3683,44935,42936],
 [24,3683,44935,44904],[24,3683,44935,47090],[24,3683,45889,38557],[24,3683,46060,41850],
 [24,3683,46060,42193],[24,3683,46060,44904],[24,3683,46060,46064],[24,3683,46064],
 [24,3683,46089,41850],[24,3683,46089,42193],[24,3683,46089,44904],[24,3683,46089,46064],
 [24,3683,47084,42593],[24,3683,47084,42936],[24,3683,47084,44904],[24,3683,47084,47090],
 [24,3683,47090],[24,3683,47115,42593],[24,3683,47115,42936],[24,3683,47115,44904],
 [24,3683,47115,47090],[24,3683,49473,41850],[24,3683,49473,42193],[24,3683,49473,44904],
 [24,3683,49473,46064],[24,3683,49475,42593],[24,3683,49475,42936],[24,3683,49475,44904],
 [24,3683,49475,47090],[24,3683,49865,38331],[24,3683,49865,38921],[24,3683,49865,42193],
 [24,3683,49865,42936],[24,3684,3507],[24,3684,3677],[24,3684,3714],[24,3684,38331],
 [24,3684,38557],[24,3684,38921],[24,3684,41850],[24,3684,42193],[24,3684,42593],
 [24,3684,42936],[24,3684,44904],[24,3684,46064],[24,3684,47090],[24,3688,3507],
 [24,3688,3677],[24,3688,3714],[24,3688,38331],[24,3688,38557],[24,3688,38921],
 [24,3688,41850],[24,3688,42193],[24,3688,42593],[24,3688,42936],[24,3688,44904],
 [24,3688,46064],[24,3688,47090],[24,3690,3507],[24,3690,3677],[24,3690,3714],
 [24,3690,38331],[24,3690,38557],[24,3690,38921],[24,3690,41850],[24,3690,42193],
 [24,3690,42593],[24,3690,42936],[24,3690,44904],[24,3690,46064],[24,3690,47090],
 [24,3713,3507],[24,3713,3677],[24,3713,3714],[24,3713,38205],[24,3713,38331],
 [24,3713,38557],[24,3713,39193],[24,3713,39424],[24,3713,40055],[24,3713,40287],
 [24,3713,41069],[24,3713,41850],[24,3713,42593],[24,3714],[24,3722,3507],[24,3722,3677],
 [24,3722,3714],[24,3722,38331],[24,3722,38557],[24,3722,38921],[24,3722,41850],
 [24,3722,42193],[24,3722,42593],[24,3722,42936],[24,3722,44904],[24,3722,46064],
 [24,3722,47090],[24,3723,3507],[24,3723,3677],[24,3723,3714],[24,3723,38331],
 [24,3723,38557],[24,3723,38921],[24,3723,41850],[24,3723,42193],[24,3723,42593],
 [24,3723,42936],[24,3723,44904],[24,3723,46064],[24,3723,47090],[24,3727,3507],
 [24,3727,3677],[24,3727,3714],[24,3727,38331],[24,3727,38557],[24,3727,38921],
 [24,3727,41850],[24,3727,42193],[24,3727,42593],[24,3727,42936],[24,3727,44904],
 [24,3727,46064],[24,3727,47090],[24,3729,3507],[24,3729,3677],[24,3729,3714],
 [24,3729,38331],[24,3729,38557],[24,3729,38921],[24,3729,41850],[24,3729,42193],
 [24,3729,42593],[24,3729,42936],[24,3729,44904],[24,3729,46064],[24,3729,47090],
 [24,3860,3507],[24,3860,3677],[24,3860,3714],[24,3860,38205],[24,3860,38331],
 [24,3860,38557],[24,3860,39193],[24,3860,39424],[24,3860,40055],[24,3860,40287],
 [24,3860,41069],[24,3860,41850],[24,3860,42593],[24,3862,3507],[24,3862,3677],
 [24,3862,3714],[24,3862,38205],[24,3862,38331],[24,3862,38557],[24,3862,39193],
 [24,3862,39424],[24,3862,40055],[24,3862,40287],[24,3862,41069],[24,3862,41850],
 [24,3862,42593],[24,3868,1291],[24,3868,1306],[24,3868,1432],[24,3868,1625],
 [24,3868,1658],[24,3868,3507],[24,3868,38304],[24,3868,41069],[24,3868,41411],
 [24,3868,44904],[24,3868,45501],[24,3869,1291],[24,3869,1306],[24,3869,1432],
 [24,3869,1625],[24,3869,1658],[24,3869,3507],[24,3869,38304],[24,3869,41069],
 [24,3869,41411],[24,3869,44904],[24,3869,45501],[24,3871,1291],[24,3871,1306],
 [24,3871,1432],[24,3871,1625],[24,3871,1658],[24,3871,3507],[24,3871,38304],
 [24,3871,41069],[24,3871,41411],[24,3871,44904],[24,3871,45501],[24,3873,3507],
 [24,3873,38921],[24,3873,41069],[24,3875,3507],[24,3875,38921],[24,3875,41069],
 [24,3902,3507],[24,3902,3677],[24,3902,3714],[24,3902,38331],[24,3902,38557],
 [24,3902,38921],[24,3902,41850],[24,3902,42193],[24,3902,42593],[24,3902,42936],
 [24,3902,44904],[24,3902,46064],[24,3902,47090],[24,3903,3507],[24,3903,3677],
 [24,3903,3714],[24,3903,38331],[24,3903,38557],[24,3903,38921],[24,3903,41850],
 [24,3903,42193],[24,3903,42593],[24,3903,42936],[24,3903,44904],[24,3903,46064],
 [24,3903,47090],[24,3907,3507],[24,3907,3677],[24,3907,3714],[24,3907,38331],
 [24,3907,38557],[24,3907,38921],[24,3907,41850],[24,3907,42193],[24,3907,42593],
 [24,3907,42936],[24,3907,44904],[24,3907,46064],[24,3907,47090],[24,3909,3507],
 [24,3909,3677],[24,3909,3714],[24,3909,38331],[24,3909,38557],[24,3909,38921],
 [24,3909,41850],[24,3909,42193],[24,3909,42593],[24,3909,42936],[24,3909,44904],
 [24,3909,46064],[24,3909,47090],[24,3967,3507],[24,3967,3677],[24,3967,3714],
 [24,3967,38331],[24,3967,38557],[24,3967,38921],[24,3967,41850],[24,3967,42193],
 [24,3967,42593],[24,3967,42936],[24,3967,44904],[24,3967,46064],[24,3967,47090],
 [24,3968,3507],[24,3968,3677],[24,3968,3714],[24,3968,38331],[24,3968,38557],
 [24,3968,38921],[24,3968,41850],[24,3968,42193],[24,3968,42593],[24,3968,42936],
 [24,3968,44904],[24,3968,46064],[24,3968,47090],[24,3972,3507],[24,3972,3677],
 [24,3972,3714],[24,3972,38331],[24,3972,38557],[24,3972,38921],[24,3972,41850],
 [24,3972,42193],[24,3972,42593],[24,3972,42936],[24,3972,44904],[24,3972,46064],
 [24,3972,47090],[24,3974,3507],[24,3974,3677],[24,3974,3714],[24,3974,38331],
 [24,3974,38557],[24,3974,38921],[24,3974,41850],[24,3974,42193],[24,3974,42593],
 [24,3974,42936],[24,3974,44904],[24,3974,46064],[24,3974,47090],[24,4141,1291],
 [24,4141,1306],[24,4141,1432],[24,4141,1625],[24,4141,1658],[24,4141,3507],
 [24,4141,38304],[24,4141,41069],[24,4141,41411],[24,4141,44904],[24,4141,45501],
 [24,4143,3507],[24,4143,3677],[24,4143,3714],[24,4143,38331],[24,4143,38557],
 [24,4143,38921],[24,4143,41850],[24,4143,42193],[24,4143,42593],[24,4143,42936],
 [24,4143,44904],[24,4143,46064],[24,4143,47090],[24,4145,3507],[24,4145,3677],
 [24,4145,3714],[24,4145,38331],[24,4145,38557],[24,4145,38921],[24,4145,41850],
 [24,4145,42193],[24,4145,42593],[24,4145,42936],[24,4145,44904],[24,4145,46064],
 [24,4145,47090],[24,4166,1291],[24,4166,1306],[24,4166,1432],[24,4166,1625],
 [24,4166,1658],[24,4166,3507],[24,4166,38304],[24,4166,41069],[24,4166,41411],
 [24,4166,44904],[24,4166,45501],[24,4168,3507],[24,4168,3677],[24,4168,3714],
 [24,4168,38331],[24,4168,38557],[24,4168,38921],[24,4168,41850],[24,4168,42193],
 [24,4168,42593],[24,4168,42936],[24,4168,44904],[24,4168,46064],[24,4168,47090],
 [24,4170,3507],[24,4170,3677],[24,4170,3714],[24,4170,38331],[24,4170,38557],
 [24,4170,38921],[24,4170,41850],[24,4170,42193],[24,4170,42593],[24,4170,42936],
 [24,4170,44904],[24,4170,46064],[24,4170,47090],[24,4215,3507],[24,4215,38205],
 [24,4215,38921],[24,4215,39779],[24,4215,40642],[24,4217,3507],[24,4217,38205],
 [24,4217,38921],[24,4217,39779],[24,4217,40642],[24,4510,2279],[24,4510,3507],
 [24,4510,5705],[24,4510,7828],[24,4510,38205],[24,4510,44904],[24,4511,2279],
 [24,4511,3507],[24,4511,5705],[24,4511,7828],[24,4511,38205],[24,4511,44904],
 [24,4512,2279],[24,4512,3507],[24,4512,5705],[24,4512,7828],[24,4512,38205],
 [24,4512,44904],[24,4518,2279],[24,4518,3507],[24,4518,5705],[24,4518,7828],
 [24,4518,38205],[24,4518,44904],[24,4528,2279],[24,4528,3507],[24,4528,5705],
 [24,4528,7828],[24,4528,38205],[24,4528,44904],[24,4529,2279],[24,4529,3507],
 [24,4529,5705],[24,4529,7828],[24,4529,38205],[24,4529,44904],[24,5647,1291],
 [24,5647,1306],[24,5647,1336],[24,5647,1377],[24,5647,1432],[24,5647,5705],
 [24,5647,38205],[24,5647,38304],[24,5647,38331],[24,5647,39193],[24,5647,40055],
 [24,5648,1291],[24,5648,1306],[24,5648,1336],[24,5648,1377],[24,5648,1432],
 [24,5648,5705],[24,5648,38205],[24,5648,38304],[24,5648,38331],[24,5648,39193],
 [24,5648,40055],[24,5649,1291],[24,5649,1306],[24,5649,1336],[24,5649,1377],
 [24,5649,1432],[24,5649,5705],[24,5649,38205],[24,5649,38304],[24,5649,38331],
 [24,5649,39193],[24,5649,40055],[24,5652,2279],[24,5652,3507],[24,5652,5705],
 [24,5652,7828],[24,5652,38205],[24,5652,44904],[24,5653,5696,5705],[24,5653,5696,6018],
 [24,5653,5696,6050],[24,5653,5696,39424],[24,5653,5696,39779],[24,5653,5696,45501],
 [24,5653,5696,46064],[24,5653,5697,5705],[24,5653,5697,6018],[24,5653,5697,6050],
 [24,5653,5697,39424],[24,5653,5697,39779],[24,5653,5697,45501],[24,5653,5697,46064],
 [24,5653,5699,5705],[24,5653,5699,47090],[24,5653,5705],[24,5653,5708,5705],
 [24,5653,5708,6018],[24,5653,5708,6050],[24,5653,5708,39424],[24,5653,5708,39779],
 [24,5653,5708,45501],[24,5653,5708,46064],[24,5653,5710,5705],[24,5653,5710,6018],
 [24,5653,5710,6050],[24,5653,5710,39424],[24,5653,5710,39779],[24,5653,5710,45501],
 [24,5653,5710,46064],[24,5653,5712,5705],[24,5653,5712,47090],[24,5653,6005,5705],
 [24,5653,6005,6018],[24,5653,6005,6050],[24,5653,6005,39424],[24,5653,6005,39779],
 [24,5653,6005,45501],[24,5653,6005,46064],[24,5653,6013,5705],[24,5653,6013,6018],
 [24,5653,6013,6050],[24,5653,6013,39424],[24,5653,6013,39779],[24,5653,6013,45501],
 [24,5653,6013,46064],[24,5653,6016,5705],[24,5653,6016,6018],[24,5653,6016,6050],
 [24,5653,6016,39424],[24,5653,6016,39779],[24,5653,6016,45501],[24,5653,6016,46064],
 [24,5653,6018],[24,5653,6047,5705],[24,5653,6047,6018],[24,5653,6047,6050],
 [24,5653,6047,39424],[24,5653,6047,39779],[24,5653,6047,45501],[24,5653,6047,46064],
 [24,5653,6050],[24,5653,6052,5705],[24,5653,6052,6018],[24,5653,6052,6050],
 [24,5653,6052,39424],[24,5653,6052,39779],[24,5653,6052,45501],[24,5653,6052,46064],
 [24,5653,6112,5705],[24,5653,6112,47090],[24,5653,6119,5705],[24,5653,6119,47090],
 [24,5653,6286,5705],[24,5653,6286,6018],[24,5653,6286,6050],[24,5653,6286,39424],
 [24,5653,6286,39779],[24,5653,6286,45501],[24,5653,6286,46064],[24,5653,6288,5705],
 [24,5653,6288,6018],[24,5653,6288,6050],[24,5653,6288,39424],[24,5653,6288,39779],
 [24,5653,6288,45501],[24,5653,6288,46064],[24,5653,6290,5705],[24,5653,6290,47090],
 [24,5653,6360,5705],[24,5653,6360,6018],[24,5653,6360,6050],[24,5653,6360,39424],
 [24,5653,6360,39779],[24,5653,6360,45501],[24,5653,6360,46064],[24,5653,38205],
 [24,5653,38529,45501],[24,5653,38532,45501],[24,5653,38557],[24,5653,38566,38557],
 [24,5653,38631,38557],[24,5653,38802,45501],[24,5653,38921],[24,5653,39424],
 [24,5653,39432,5705],[24,5653,39432,6018],[24,5653,39432,6050],[24,5653,39432,39424],
 [24,5653,39432,39779],[24,5653,39432,45501],[24,5653,39432,46064],[24,5653,39435,5705],
 [24,5653,39435,6018],[24,5653,39435,6050],[24,5653,39435,39424],[24,5653,39435,39779],
 [24,5653,39435,45501],[24,5653,39435,46064],[24,5653,39437,5705],[24,5653,39437,6018],
 [24,5653,39437,6050],[24,5653,39437,39424],[24,5653,39437,39779],[24,5653,39437,45501],
 [24,5653,39437,46064],[24,5653,39466,5705],[24,5653,39466,6018],[24,5653,39466,6050],
 [24,5653,39466,39424],[24,5653,39466,39779],[24,5653,39466,45501],[24,5653,39466,46064],
 [24,5653,39469,5705],[24,5653,39469,6018],[24,5653,39469,6050],[24,5653,39469,39424],
 [24,5653,39469,39779],[24,5653,39469,45501],[24,5653,39469,46064],[24,5653,39471,5705],
 [24,5653,39471,6018],[24,5653,39471,6050],[24,5653,39471,39424],[24,5653,39471,39779],
 [24,5653,39471,45501],[24,5653,39471,46064],[24,5653,39531,5705],[24,5653,39531,47090],
 [24,5653,39538,5705],[24,5653,39538,47090],[24,5653,39705,5705],[24,5653,39705,6018],
 [24,5653,39705,6050],[24,5653,39705,39424],[24,5653,39705,39779],[24,5653,39705,45501],
 [24,5653,39705,46064],[24,5653,39707,5705],[24,5653,39707,6018],[24,5653,39707,6050],
 [24,5653,39707,39424],[24,5653,39707,39779],[24,5653,39707,45501],[24,5653,39707,46064],
 [24,5653,39709,5705],[24,5653,39709,47090],[24,5653,39779],[24,5653,40287],
 [24,5653,40293,40287],[24,5653,40293,40642],[24,5653,40293,45501],[24,5653,40293,47090],
 [24,5653,40296,40287],[24,5653,40296,40642],[24,5653,40296,45501],[24,5653,40296,47090],
 [24,5653,40300,40287],[24,5653,40300,40642],[24,5653,40300,45501],[24,5653,40300,47090],
 [24,5653,40327,46064],[24,5653,40332,46064],[24,5653,40392,40287],[24,5653,40392,40642],
 [24,5653,40392,45501],[24,5653,40392,47090],[24,5653,40395,40287],[24,5653,40395,40642],
 [24,5653,40395,45501],[24,5653,40395,47090],[24,5653,40399,40287],[24,5653,40399,40642],
 [24,5653,40399,45501],[24,5653,40399,47090],[24,5653,40566,40287],[24,5653,40566,40642],
 [24,5653,40566,45501],[24,5653,40566,47090],[24,5653,40568,46064],[24,5653,40570,40287],
 [24,5653,40570,40642],[24,5653,40570,45501],[24,5653,40570,47090],[24,5653,40642],
 [24,5653,45262,5705],[24,5653,45262,6018],[24,5653,45262,6050],[24,5653,45262,39424],
 [24,5653,45262,39779],[24,5653,45262,45501],[24,5653,45262,46064],[24,5653,45265,5705],
 [24,5653,45265,6018],[24,5653,45265,6050],[24,5653,45265,39424],[24,5653,45265,39779],
 [24,5653,45265,45501],[24,5653,45265,46064],[24,5653,45267,5705],[24,5653,45267,6018],
 [24,5653,45267,6050],[24,5653,45267,39424],[24,5653,45267,39779],[24,5653,45267,45501],
 [24,5653,45267,46064],[24,5653,45327,40287],[24,5653,45327,40642],[24,5653,45327,45501],
 [24,5653,45327,47090],[24,5653,45330,40287],[24,5653,45330,40642],[24,5653,45330,45501],
 [24,5653,45330,47090],[24,5653,45334,40287],[24,5653,45334,40642],[24,5653,45334,45501],
 [24,5653,45334,47090],[24,5653,45501],[24,5653,45503,5705],[24,5653,45503,6018],
 [24,5653,45503,6050],[24,5653,45503,39424],[24,5653,45503,39779],[24,5653,45503,45501],
 [24,5653,45503,46064],[24,5653,45505,40287],[24,5653,45505,40642],[24,5653,45505,45501],
 [24,5653,45505,47090],[24,5653,45575,5705],[24,5653,45575,6018],[24,5653,45575,6050],
 [24,5653,45575,39424],[24,5653,45575,39779],[24,5653,45575,45501],[24,5653,45575,46064],
 [24,5653,45577,40287],[24,5653,45577,40642],[24,5653,45577,45501],[24,5653,45577,47090],
 [24,5653,45891,38557],[24,5653,46062,5705],[24,5653,46062,6018],[24,5653,46062,6050],
 [24,5653,46062,39424],[24,5653,46062,39779],[24,5653,46062,45501],[24,5653,46062,46064],
 [24,5653,46064],[24,5653,46136,5705],[24,5653,46136,6018],[24,5653,46136,6050],
 [24,5653,46136,39424],[24,5653,46136,39779],[24,5653,46136,45501],[24,5653,46136,46064],
 [24,5653,47086,40287],[24,5653,47086,40642],[24,5653,47086,45501],[24,5653,47086,47090],
 [24,5653,47090],[24,5653,47162,40287],[24,5653,47162,40642],[24,5653,47162,45501],
 [24,5653,47162,47090],[24,5653,49520,5705],[24,5653,49520,6018],[24,5653,49520,6050],
 [24,5653,49520,39424],[24,5653,49520,39779],[24,5653,49520,45501],[24,5653,49520,46064],
 [24,5653,49522,40287],[24,5653,49522,40642],[24,5653,49522,45501],[24,5653,49522,47090],
 [24,5654,5705],[24,5654,6018],[24,5654,6050],[24,5654,38205],[24,5654,38557],
 [24,5654,38921],[24,5654,39424],[24,5654,39779],[24,5654,40287],[24,5654,40642],
 [24,5654,45501],[24,5654,46064],[24,5654,47090],[24,5656,5705],[24,5656,6018],
 [24,5656,6050],[24,5656,38205],[24,5656,38557],[24,5656,38921],[24,5656,39424],
 [24,5656,39779],[24,5656,40287],[24,5656,40642],[24,5656,45501],[24,5656,46064],
 [24,5656,47090],[24,5663,2279],[24,5663,3507],[24,5663,5705],[24,5663,7828],
 [24,5663,38205],[24,5663,44904],[24,5665,5705],[24,5665,6018],[24,5665,6050],
 [24,5665,38205],[24,5665,38557],[24,5665,38921],[24,5665,39424],[24,5665,39779],
 [24,5665,40287],[24,5665,40642],[24,5665,45501],[24,5665,46064],[24,5665,47090],
 [24,5667,5705],[24,5667,6018],[24,5667,6050],[24,5667,38205],[24,5667,38557],
 [24,5667,38921],[24,5667,39424],[24,5667,39779],[24,5667,40287],[24,5667,40642],
 [24,5667,45501],[24,5667,46064],[24,5667,47090],[24,5669,5705],[24,5669,6018],
 [24,5669,6050],[24,5669,38205],[24,5669,38557],[24,5669,38921],[24,5669,39424],
 [24,5669,39779],[24,5669,40287],[24,5669,40642],[24,5669,45501],[24,5669,46064],
 [24,5669,47090],[24,5705],[24,5732,1291],[24,5732,1306],[24,5732,1336],[24,5732,1377],
 [24,5732,1432],[24,5732,5705],[24,5732,38205],[24,5732,38304],[24,5732,38331],
 [24,5732,39193],[24,5732,40055],[24,5733,1291],[24,5733,1306],[24,5733,1336],
 [24,5733,1377],[24,5733,1432],[24,5733,5705],[24,5733,38205],[24,5733,38304],
 [24,5733,38331],[24,5733,39193],[24,5733,40055],[24,5734,1291],[24,5734,1306],
 [24,5734,1336],[24,5734,1377],[24,5734,1432],[24,5734,5705],[24,5734,38205],
 [24,5734,38304],[24,5734,38331],[24,5734,39193],[24,5734,40055],[24,5737,2279],
 [24,5737,3507],[24,5737,5705],[24,5737,7828],[24,5737,38205],[24,5737,44904],
 [24,5738,5705],[24,5738,6018],[24,5738,6050],[24,5738,38205],[24,5738,38557],
 [24,5738,38921],[24,5738,39424],[24,5738,39779],[24,5738,40287],[24,5738,40642],
 [24,5738,45501],[24,5738,46064],[24,5738,47090],[24,5739,5705],[24,5739,6018],
 [24,5739,6050],[24,5739,38205],[24,5739,38557],[24,5739,38921],[24,5739,39424],
 [24,5739,39779],[24,5739,40287],[24,5739,40642],[24,5739,45501],[24,5739,46064],
 [24,5739,47090],[24,5741,5705],[24,5741,6018],[24,5741,6050],[24,5741,38205],
 [24,5741,38557],[24,5741,38921],[24,5741,39424],[24,5741,39779],[24,5741,40287],
 [24,5741,40642],[24,5741,45501],[24,5741,46064],[24,5741,47090],[24,5748,2279],
 [24,5748,3507],[24,5748,5705],[24,5748,7828],[24,5748,38205],[24,5748,44904],
 [24,5750,5705],[24,5750,6018],[24,5750,6050],[24,5750,38205],[24,5750,38557],
 [24,5750,38921],[24,5750,39424],[24,5750,39779],[24,5750,40287],[24,5750,40642],
 [24,5750,45501],[24,5750,46064],[24,5750,47090],[24,5752,5705],[24,5752,6018],
 [24,5752,6050],[24,5752,38205],[24,5752,38557],[24,5752,38921],[24,5752,39424],
 [24,5752,39779],[24,5752,40287],[24,5752,40642],[24,5752,45501],[24,5752,46064],
 [24,5752,47090],[24,5754,5705],[24,5754,6018],[24,5754,6050],[24,5754,38205],
 [24,5754,38557],[24,5754,38921],[24,5754,39424],[24,5754,39779],[24,5754,40287],
 [24,5754,40642],[24,5754,45501],[24,5754,46064],[24,5754,47090],[24,5775,1291],
 [24,5775,1306],[24,5775,1336],[24,5775,1377],[24,5775,1432],[24,5775,5705],
 [24,5775,38205],[24,5775,38304],[24,5775,38331],[24,5775,39193],[24,5775,40055],
 [24,5778,5705],[24,5778,6018],[24,5778,6050],[24,5778,39193],[24,5778,39208,39193],
 [24,5778,39208,39779],[24,5778,39208,41411],[24,5778,39208,42193],[24,5778,39210,39193],
 [24,5778,39210,39779],[24,5778,39210,41411],[24,5778,39210,42193],[24,5778,39212,39193],
 [24,5778,39212,39779],[24,5778,39212,41411],[24,5778,39212,42193],[24,5778,39248,39193],
 [24,5778,39248,39779],[24,5778,39248,41411],[24,5778,39248,42193],[24,5778,39250,39193],
 [24,5778,39250,39779],[24,5778,39250,41411],[24,5778,39250,42193],[24,5778,39252,39193],
 [24,5778,39252,39779],[24,5778,39252,41411],[24,5778,39252,42193],[24,5778,39424],
 [24,5778,39730,39193],[24,5778,39730,39779],[24,5778,39730,41411],[24,5778,39730,42193],
 [24,5778,39732,39193],[24,5778,39732,39779],[24,5778,39732,41411],[24,5778,39732,42193],
 [24,5778,39779],[24,5778,40929,39193],[24,5778,40929,39779],[24,5778,40929,41411],
 [24,5778,40929,42193],[24,5778,40931,39193],[24,5778,40931,39779],[24,5778,40931,41411],
 [24,5778,40931,42193],[24,5778,40933,39193],[24,5778,40933,39779],[24,5778,40933,41411],
 [24,5778,40933,42193],[24,5778,41069],[24,5778,41147,46064],[24,5778,41148,41411],
 [24,5778,41150,41411],[24,5778,41152,46064],[24,5778,41388,46064],[24,5778,41411],
 [24,5778,41413,39193],[24,5778,41413,39779],[24,5778,41413,41411],[24,5778,41413,42193],
 [24,5778,41460,39193],[24,5778,41460,39779],[24,5778,41460,41411],[24,5778,41460,42193],
 [24,5778,41850],[24,5778,41893,45501],[24,5778,41896,45501],[24,5778,42166,45501],
 [24,5778,42191,39193],[24,5778,42191,39779],[24,5778,42191,41411],[24,5778,42191,42193],
 [24,5778,42193],[24,5778,42240,39193],[24,5778,42240,39779],[24,5778,42240,41411],
 [24,5778,42240,42193],[24,5778,44904],[24,5778,45501],[24,5778,46064],
 [24,5778,46087,41411],[24,5778,49820,39193],[24,5778,49820,39779],[24,5778,49820,41411],
 [24,5778,49820,42193],[24,5779,5705],[24,5779,6018],[24,5779,6050],[24,5779,39193],
 [24,5779,39424],[24,5779,39779],[24,5779,41069],[24,5779,41411],[24,5779,41850],
 [24,5779,42193],[24,5779,44904],[24,5779,45501],[24,5779,46064],[24,5780,5705],
 [24,5780,6018],[24,5780,6050],[24,5780,39193],[24,5780,39424],[24,5780,39779],
 [24,5780,41069],[24,5780,41411],[24,5780,41850],[24,5780,42193],[24,5780,44904],
 [24,5780,45501],[24,5780,46064],[24,5782,5705],[24,5782,39193],[24,5782,39214,39193],
 [24,5782,39254,39193],[24,5782,40935,39193],[24,5782,41212,47090],[24,5782,41219,47090],
 [24,5782,41390,47090],[24,5782,47090],[24,5789,5705],[24,5789,6018],[24,5789,6050],
 [24,5789,39193],[24,5789,39424],[24,5789,39779],[24,5789,41069],[24,5789,41411],
 [24,5789,41850],[24,5789,42193],[24,5789,44904],[24,5789,45501],[24,5789,46064],
 [24,5791,5705],[24,5791,6018],[24,5791,6050],[24,5791,39193],[24,5791,39424],
 [24,5791,39779],[24,5791,41069],[24,5791,41411],[24,5791,41850],[24,5791,42193],
 [24,5791,44904],[24,5791,45501],[24,5791,46064],[24,5793,5705],[24,5793,6018],
 [24,5793,6050],[24,5793,39193],[24,5793,39424],[24,5793,39779],[24,5793,41069],
 [24,5793,41411],[24,5793,41850],[24,5793,42193],[24,5793,44904],[24,5793,45501],
 [24,5793,46064],[24,5795,5705],[24,5795,39193],[24,5795,47090],[24,5815,1291],
 [24,5815,1306],[24,5815,1336],[24,5815,1377],[24,5815,1432],[24,5815,5705],
 [24,5815,38205],[24,5815,38304],[24,5815,38331],[24,5815,39193],[24,5815,40055],
 [24,5818,5705],[24,5818,6018],[24,5818,6050],[24,5818,39193],[24,5818,39424],
 [24,5818,39779],[24,5818,41069],[24,5818,41411],[24,5818,41850],[24,5818,42193],
 [24,5818,44904],[24,5818,45501],[24,5818,46064],[24,5819,5705],[24,5819,6018],
 [24,5819,6050],[24,5819,39193],[24,5819,39424],[24,5819,39779],[24,5819,41069],
 [24,5819,41411],[24,5819,41850],[24,5819,42193],[24,5819,44904],[24,5819,45501],
 [24,5819,46064],[24,5820,5705],[24,5820,6018],[24,5820,6050],[24,5820,39193],
 [24,5820,39424],[24,5820,39779],[24,5820,41069],[24,5820,41411],[24,5820,41850],
 [24,5820,42193],[24,5820,44904],[24,5820,45501],[24,5820,46064],[24,5822,5705],
 [24,5822,39193],[24,5822,47090],[24,5829,5705],[24,5829,6018],[24,5829,6050],
 [24,5829,39193],[24,5829,39424],[24,5829,39779],[24,5829,41069],[24,5829,41411],
 [24,5829,41850],[24,5829,42193],[24,5829,44904],[24,5829,45501],[24,5829,46064],
 [24,5831,5705],[24,5831,6018],[24,5831,6050],[24,5831,39193],[24,5831,39424],
 [24,5831,39779],[24,5831,41069],[24,5831,41411],[24,5831,41850],[24,5831,42193],
 [24,5831,44904],[24,5831,45501],[24,5831,46064],[24,5833,5705],[24,5833,6018],
 [24,5833,6050],[24,5833,39193],[24,5833,39424],[24,5833,39779],[24,5833,41069],
 [24,5833,41411],[24,5833,41850],[24,5833,42193],[24,5833,44904],[24,5833,45501],
 [24,5833,46064],[24,5835,5705],[24,5835,39193],[24,5835,47090],[24,5857,5705],
 [24,5857,42593],[24,5857,42936],[24,5857,44904],[24,5857,47090],[24,5861,5705],
 [24,5861,42593],[24,5861,42936],[24,5861,44904],[24,5861,47090],[24,5868,5705],
 [24,5868,42593],[24,5868,42936],[24,5868,44904],[24,5868,47090],[24,5874,5705],
 [24,5874,42593],[24,5874,42936],[24,5874,44904],[24,5874,47090],[24,5969,5705],
 [24,5969,6018],[24,5969,6050],[24,5969,39193],[24,5969,39424],[24,5969,39779],
 [24,5969,41069],[24,5969,41411],[24,5969,41850],[24,5969,42193],[24,5969,44904],
 [24,5969,45501],[24,5969,46064],[24,5970,5705],[24,5970,6018],[24,5970,6050],
 [24,5970,39193],[24,5970,39424],[24,5970,39779],[24,5970,41069],[24,5970,41411],
 [24,5970,41850],[24,5970,42193],[24,5970,44904],[24,5970,45501],[24,5970,46064],
 [24,5972,5705],[24,5972,42593],[24,5972,42936],[24,5972,44904],[24,5972,47090],
 [24,5981,5705],[24,5981,6018],[24,5981,6050],[24,5981,39193],[24,5981,39424],
 [24,5981,39779],[24,5981,41069],[24,5981,41411],[24,5981,41850],[24,5981,42193],
 [24,5981,44904],[24,5981,45501],[24,5981,46064],[24,5983,5705],[24,5983,6018],
 [24,5983,6050],[24,5983,39193],[24,5983,39424],[24,5983,39779],[24,5983,41069],
 [24,5983,41411],[24,5983,41850],[24,5983,42193],[24,5983,44904],[24,5983,45501],
 [24,5983,46064],[24,5985,5705],[24,5985,42593],[24,5985,42936],[24,5985,44904],
 [24,5985,47090],[24,6007,5705],[24,6007,6018],[24,6007,6050],[24,6007,38205],
 [24,6007,38557],[24,6007,38921],[24,6007,39424],[24,6007,39779],[24,6007,40287],
 [24,6007,40642],[24,6007,45501],[24,6007,46064],[24,6007,47090],[24,6014,5705],
 [24,6014,6018],[24,6014,6050],[24,6014,39193],[24,6014,39424],[24,6014,39779],
 [24,6014,41069],[24,6014,41411],[24,6014,41850],[24,6014,42193],[24,6014,44904],
 [24,6014,45501],[24,6014,46064],[24,6018],[24,6020,5705],[24,6020,6018],[24,6020,6050],
 [24,6020,38205],[24,6020,38557],[24,6020,38921],[24,6020,39424],[24,6020,39779],
 [24,6020,40287],[24,6020,40642],[24,6020,45501],[24,6020,46064],[24,6020,47090],
 [24,6041,5705],[24,6041,6018],[24,6041,6050],[24,6041,38205],[24,6041,38557],
 [24,6041,38921],[24,6041,39424],[24,6041,39779],[24,6041,40287],[24,6041,40642],
 [24,6041,45501],[24,6041,46064],[24,6041,47090],[24,6048,5705],[24,6048,6018],
 [24,6048,6050],[24,6048,39193],[24,6048,39424],[24,6048,39779],[24,6048,41069],
 [24,6048,41411],[24,6048,41850],[24,6048,42193],[24,6048,44904],[24,6048,45501],
 [24,6048,46064],[24,6050],[24,6054,5705],[24,6054,6018],[24,6054,6050],[24,6054,38205],
 [24,6054,38557],[24,6054,38921],[24,6054,39424],[24,6054,39779],[24,6054,40287],
 [24,6054,40642],[24,6054,45501],[24,6054,46064],[24,6054,47090],[24,6113,5705],
 [24,6113,42593],[24,6113,42936],[24,6113,44904],[24,6113,47090],[24,6115,5705],
 [24,6115,6018],[24,6115,6050],[24,6115,38205],[24,6115,38557],[24,6115,38921],
 [24,6115,39424],[24,6115,39779],[24,6115,40287],[24,6115,40642],[24,6115,45501],
 [24,6115,46064],[24,6115,47090],[24,6117,5705],[24,6117,6018],[24,6117,6050],
 [24,6117,38205],[24,6117,38557],[24,6117,38921],[24,6117,39424],[24,6117,39779],
 [24,6117,40287],[24,6117,40642],[24,6117,45501],[24,6117,46064],[24,6117,47090],
 [24,6311,5705],[24,6311,6018],[24,6311,6050],[24,6311,39193],[24,6311,39424],
 [24,6311,39779],[24,6311,41069],[24,6311,41411],[24,6311,41850],[24,6311,42193],
 [24,6311,44904],[24,6311,45501],[24,6311,46064],[24,6313,5705],[24,6313,6018],
 [24,6313,6050],[24,6313,39193],[24,6313,39424],[24,6313,39779],[24,6313,41069],
 [24,6313,41411],[24,6313,41850],[24,6313,42193],[24,6313,44904],[24,6313,45501],
 [24,6313,46064],[24,6315,5705],[24,6315,42593],[24,6315,42936],[24,6315,44904],
 [24,6315,47090],[24,6362,5705],[24,6362,6018],[24,6362,6050],[24,6362,38205],
 [24,6362,38557],[24,6362,38921],[24,6362,39424],[24,6362,39779],[24,6362,40287],
 [24,6362,40642],[24,6362,45501],[24,6362,46064],[24,6362,47090],[24,6405,5705],
 [24,6405,6018],[24,6405,6050],[24,6405,38205],[24,6405,38557],[24,6405,38921],
 [24,6405,39424],[24,6405,39779],[24,6405,40287],[24,6405,40642],[24,6405,45501],
 [24,6405,46064],[24,6405,47090],[24,7727,7812,7828],[24,7727,7812,7875],
 [24,7727,7812,7950],[24,7727,7812,40055],[24,7727,7812,40642],[24,7727,7812,41411],
 [24,7727,7812,42936],[24,7727,7814,7828],[24,7727,7814,7875],[24,7727,7814,7950],
 [24,7727,7814,40055],[24,7727,7814,40642],[24,7727,7814,41411],[24,7727,7814,42936],
 [24,7727,7828],[24,7727,7830,7828],[24,7727,7830,7875],[24,7727,7830,7950],
 [24,7727,7830,40055],[24,7727,7830,40642],[24,7727,7830,41411],[24,7727,7830,42936],
 [24,7727,7834,7828],[24,7727,7834,7875],[24,7727,7834,7950],[24,7727,7834,40055],
 [24,7727,7834,40642],[24,7727,7834,41411],[24,7727,7834,42936],[24,7727,7855,7828],
 [24,7727,7855,7875],[24,7727,7855,7950],[24,7727,7855,40055],[24,7727,7855,40642],
 [24,7727,7855,41411],[24,7727,7855,42936],[24,7727,7869,7828],[24,7727,7869,7875],
 [24,7727,7869,7950],[24,7727,7869,40055],[24,7727,7869,40642],[24,7727,7869,41411],
 [24,7727,7869,42936],[24,7727,7871,7828],[24,7727,7871,7875],[24,7727,7871,7950],
 [24,7727,7871,40055],[24,7727,7871,40642],[24,7727,7871,41411],[24,7727,7871,42936],
 [24,7727,7875],[24,7727,7948,7828],[24,7727,7948,7875],[24,7727,7948,7950],
 [24,7727,7948,40055],[24,7727,7948,40642],[24,7727,7948,41411],[24,7727,7948,42936],
 [24,7727,7950],[24,7727,7954,7828],[24,7727,7954,7875],[24,7727,7954,7950],
 [24,7727,7954,40055],[24,7727,7954,40642],[24,7727,7954,41411],[24,7727,7954,42936],
 [24,7727,8391,7828],[24,7727,8391,7875],[24,7727,8391,7950],[24,7727,8391,40055],
 [24,7727,8391,40642],[24,7727,8391,41411],[24,7727,8391,42936],[24,7727,8395,7828],
 [24,7727,8395,7875],[24,7727,8395,7950],[24,7727,8395,40055],[24,7727,8395,40642],
 [24,7727,8395,41411],[24,7727,8395,42936],[24,7727,8442,7828],[24,7727,8442,7875],
 [24,7727,8442,7950],[24,7727,8442,40055],[24,7727,8442,40642],[24,7727,8442,41411],
 [24,7727,8442,42936],[24,7727,38205],[24,7727,38305,41411],[24,7727,38307,41411],
 [24,7727,38331],[24,7727,38347,38331],[24,7727,38386,38331],[24,7727,38827,41411],
 [24,7727,38921],[24,7727,39193],[24,7727,39779],[24,7727,40055],[24,7727,40069,7828],
 [24,7727,40069,7875],[24,7727,40069,7950],[24,7727,40069,40055],[24,7727,40069,40642],
 [24,7727,40069,41411],[24,7727,40069,42936],[24,7727,40071,7828],[24,7727,40071,7875],
 [24,7727,40071,7950],[24,7727,40071,40055],[24,7727,40071,40642],[24,7727,40071,41411],
 [24,7727,40071,42936],[24,7727,40073,40055],[24,7727,40075,7828],[24,7727,40075,7875],
 [24,7727,40075,7950],[24,7727,40075,40055],[24,7727,40075,40642],[24,7727,40075,41411],
 [24,7727,40075,42936],[24,7727,40148,7828],[24,7727,40148,7875],[24,7727,40148,7950],
 [24,7727,40148,40055],[24,7727,40148,40642],[24,7727,40148,41411],[24,7727,40148,42936],
 [24,7727,40150,7828],[24,7727,40150,7875],[24,7727,40150,7950],[24,7727,40150,40055],
 [24,7727,40150,40642],[24,7727,40150,41411],[24,7727,40150,42936],[24,7727,40152,40055],
 [24,7727,40154,7828],[24,7727,40154,7875],[24,7727,40154,7950],[24,7727,40154,40055],
 [24,7727,40154,40642],[24,7727,40154,41411],[24,7727,40154,42936],[24,7727,40591,7828],
 [24,7727,40591,7875],[24,7727,40591,7950],[24,7727,40591,40055],[24,7727,40591,40642],
 [24,7727,40591,41411],[24,7727,40591,42936],[24,7727,40595,7828],[24,7727,40595,7875],
 [24,7727,40595,7950],[24,7727,40595,40055],[24,7727,40595,40642],[24,7727,40595,41411],
 [24,7727,40595,42936],[24,7727,40642],[24,7727,40968,7828],[24,7727,40968,7875],
 [24,7727,40968,7950],[24,7727,40968,40055],[24,7727,40968,40642],[24,7727,40968,41411],
 [24,7727,40968,42936],[24,7727,40970,7828],[24,7727,40970,7875],[24,7727,40970,7950],
 [24,7727,40970,40055],[24,7727,40970,40642],[24,7727,40970,41411],[24,7727,40970,42936],
 [24,7727,40972,40055],[24,7727,40974,7828],[24,7727,40974,7875],[24,7727,40974,7950],
 [24,7727,40974,40055],[24,7727,40974,40642],[24,7727,40974,41411],[24,7727,40974,42936],
 [24,7727,41411],[24,7727,41415,7828],[24,7727,41415,7875],[24,7727,41415,7950],
 [24,7727,41415,40055],[24,7727,41415,40642],[24,7727,41415,41411],[24,7727,41415,42936],
 [24,7727,41462,7828],[24,7727,41462,7875],[24,7727,41462,7950],[24,7727,41462,40055],
 [24,7727,41462,40642],[24,7727,41462,41411],[24,7727,41462,42936],[24,7727,41750,38331],
 [24,7727,42193],[24,7727,42932,7828],[24,7727,42932,7875],[24,7727,42932,7950],
 [24,7727,42932,40055],[24,7727,42932,40642],[24,7727,42932,41411],[24,7727,42932,42936],
 [24,7727,42936],[24,7727,42983,7828],[24,7727,42983,7875],[24,7727,42983,7950],
 [24,7727,42983,40055],[24,7727,42983,40642],[24,7727,42983,41411],[24,7727,42983,42936],
 [24,7727,49822,7828],[24,7727,49822,7875],[24,7727,49822,7950],[24,7727,49822,40055],
 [24,7727,49822,40642],[24,7727,49822,41411],[24,7727,49822,42936],[24,7728,7828],
 [24,7728,7875],[24,7728,7950],[24,7728,38205],[24,7728,38331],[24,7728,38921],
 [24,7728,39193],[24,7728,39779],[24,7728,40055],[24,7728,40642],[24,7728,41411],
 [24,7728,42193],[24,7728,42936],[24,7729,7828],[24,7729,7875],[24,7729,7950],
 [24,7729,38205],[24,7729,38331],[24,7729,38921],[24,7729,39193],[24,7729,39779],
 [24,7729,40055],[24,7729,40642],[24,7729,41411],[24,7729,42193],[24,7729,42936],
 [24,7732,2279],[24,7732,3507],[24,7732,5705],[24,7732,7828],[24,7732,38205],
 [24,7732,44904],[24,7733,7819,7828],[24,7733,7828],[24,7733,8128,7828],[24,7733,38205],
 [24,7733,38557],[24,7733,39424],[24,7733,40287],[24,7733,40328,7828],[24,7734,7828],
 [24,7734,38205],[24,7734,38557],[24,7734,39424],[24,7734,40287],[24,7736,7828],
 [24,7736,38205],[24,7736,38557],[24,7736,39424],[24,7736,40287],[24,7742,2279],
 [24,7742,3507],[24,7742,5705],[24,7742,7828],[24,7742,38205],[24,7742,44904],
 [24,7745,7828],[24,7745,7875],[24,7745,7950],[24,7745,38205],[24,7745,38331],
 [24,7745,38921],[24,7745,39193],[24,7745,39779],[24,7745,40055],[24,7745,40642],
 [24,7745,41411],[24,7745,42193],[24,7745,42936],[24,7747,7828],[24,7747,7875],
 [24,7747,7950],[24,7747,38205],[24,7747,38331],[24,7747,38921],[24,7747,39193],
 [24,7747,39779],[24,7747,40055],[24,7747,40642],[24,7747,41411],[24,7747,42193],
 [24,7747,42936],[24,7749,7828],[24,7749,7875],[24,7749,7950],[24,7749,38205],
 [24,7749,38331],[24,7749,38921],[24,7749,39193],[24,7749,39779],[24,7749,40055],
 [24,7749,40642],[24,7749,41411],[24,7749,42193],[24,7749,42936],[24,7770,7828],
 [24,7770,7875],[24,7770,7950],[24,7770,38205],[24,7770,38331],[24,7770,38921],
 [24,7770,39193],[24,7770,39779],[24,7770,40055],[24,7770,40642],[24,7770,41411],
 [24,7770,42193],[24,7770,42936],[24,7771,7828],[24,7771,7875],[24,7771,7950],
 [24,7771,38205],[24,7771,38331],[24,7771,38921],[24,7771,39193],[24,7771,39779],
 [24,7771,40055],[24,7771,40642],[24,7771,41411],[24,7771,42193],[24,7771,42936],
 [24,7772,7828],[24,7772,7875],[24,7772,7950],[24,7772,38205],[24,7772,38331],
 [24,7772,38921],[24,7772,39193],[24,7772,39779],[24,7772,40055],[24,7772,40642],
 [24,7772,41411],[24,7772,42193],[24,7772,42936],[24,7775,2279],[24,7775,3507],
 [24,7775,5705],[24,7775,7828],[24,7775,38205],[24,7775,44904],[24,7776,7828],
 [24,7776,38205],[24,7776,38557],[24,7776,39424],[24,7776,40287],[24,7777,7828],
 [24,7777,38205],[24,7777,38557],[24,7777,39424],[24,7777,40287],[24,7779,7828],
 [24,7779,38205],[24,7779,38557],[24,7779,39424],[24,7779,40287],[24,7785,2279],
 [24,7785,3507],[24,7785,5705],[24,7785,7828],[24,7785,38205],[24,7785,44904],
 [24,7788,7828],[24,7788,7875],[24,7788,7950],[24,7788,38205],[24,7788,38331],
 [24,7788,38921],[24,7788,39193],[24,7788,39779],[24,7788,40055],[24,7788,40642],
 [24,7788,41411],[24,7788,42193],[24,7788,42936],[24,7790,7828],[24,7790,7875],
 [24,7790,7950],[24,7790,38205],[24,7790,38331],[24,7790,38921],[24,7790,39193],
 [24,7790,39779],[24,7790,40055],[24,7790,40642],[24,7790,41411],[24,7790,42193],
 [24,7790,42936],[24,7792,7828],[24,7792,7875],[24,7792,7950],[24,7792,38205],
 [24,7792,38331],[24,7792,38921],[24,7792,39193],[24,7792,39779],[24,7792,40055],
 [24,7792,40642],[24,7792,41411],[24,7792,42193],[24,7792,42936],[24,7828],
 [24,7854,7828],[24,7854,7875],[24,7854,7950],[24,7854,38205],[24,7854,38331],
 [24,7854,38921],[24,7854,39193],[24,7854,39779],[24,7854,40055],[24,7854,40642],
 [24,7854,41411],[24,7854,42193],[24,7854,42936],[24,7858,7828],[24,7858,7875],
 [24,7858,7950],[24,7858,40055],[24,7858,40068,40055],[24,7858,40147,40055],
 [24,7858,40287],[24,7858,40642],[24,7858,40967,40055],[24,7858,41069],
 [24,7858,41213,41411],[24,7858,41215,41411],[24,7858,41411],[24,7858,42593],
 [24,7858,42634,45501],[24,7858,42637,45501],[24,7858,42907,45501],[24,7858,42936],
 [24,7858,44904],[24,7858,45501],[24,7858,47090],[24,7858,47111,41411],[24,7859,7828],
 [24,7859,7875],[24,7859,7950],[24,7859,40055],[24,7859,40287],[24,7859,40642],
 [24,7859,41069],[24,7859,41411],[24,7859,42593],[24,7859,42936],[24,7859,44904],
 [24,7859,45501],[24,7859,47090],[24,7862,7828],[24,7862,7875],[24,7862,7950],
 [24,7862,40055],[24,7862,40287],[24,7862,40642],[24,7862,41069],[24,7862,41411],
 [24,7862,42593],[24,7862,42936],[24,7862,44904],[24,7862,45501],[24,7862,47090],
 [24,7868,7828],[24,7868,7875],[24,7868,7950],[24,7868,40055],[24,7868,40287],
 [24,7868,40642],[24,7868,41069],[24,7868,41411],[24,7868,42593],[24,7868,42936],
 [24,7868,44904],[24,7868,45501],[24,7868,47090],[24,7873,7828],[24,7873,7875],
 [24,7873,7950],[24,7873,38205],[24,7873,38331],[24,7873,38921],[24,7873,39193],
 [24,7873,39779],[24,7873,40055],[24,7873,40642],[24,7873,41411],[24,7873,42193],
 [24,7873,42936],[24,7875],[24,7895,7828],[24,7895,7875],[24,7895,7950],[24,7895,38205],
 [24,7895,38331],[24,7895,38921],[24,7895,39193],[24,7895,39779],[24,7895,40055],
 [24,7895,40642],[24,7895,41411],[24,7895,42193],[24,7895,42936],[24,7898,7828],
 [24,7898,41850],[24,7898,42193],[24,7898,44904],[24,7898,46064],[24,7900,7828],
 [24,7900,41850],[24,7900,42193],[24,7900,44904],[24,7900,46064],[24,7908,7828],
 [24,7908,41850],[24,7908,42193],[24,7908,44904],[24,7908,46064],[24,7911,7828],
 [24,7911,7875],[24,7911,7950],[24,7911,38205],[24,7911,38331],[24,7911,38921],
 [24,7911,39193],[24,7911,39779],[24,7911,40055],[24,7911,40642],[24,7911,41411],
 [24,7911,42193],[24,7911,42936],[24,7915,7828],[24,7915,7875],[24,7915,7950],
 [24,7915,38205],[24,7915,38331],[24,7915,38921],[24,7915,39193],[24,7915,39779],
 [24,7915,40055],[24,7915,40642],[24,7915,41411],[24,7915,42193],[24,7915,42936],
 [24,7937,7828],[24,7937,7875],[24,7937,7950],[24,7937,40055],[24,7937,40287],
 [24,7937,40642],[24,7937,41069],[24,7937,41411],[24,7937,42593],[24,7937,42936],
 [24,7937,44904],[24,7937,45501],[24,7937,47090],[24,7938,7828],[24,7938,7875],
 [24,7938,7950],[24,7938,40055],[24,7938,40287],[24,7938,40642],[24,7938,41069],
 [24,7938,41411],[24,7938,42593],[24,7938,42936],[24,7938,44904],[24,7938,45501],
 [24,7938,47090],[24,7941,7828],[24,7941,7875],[24,7941,7950],[24,7941,40055],
 [24,7941,40287],[24,7941,40642],[24,7941,41069],[24,7941,41411],[24,7941,42593],
 [24,7941,42936],[24,7941,44904],[24,7941,45501],[24,7941,47090],[24,7947,7828],
 [24,7947,7875],[24,7947,7950],[24,7947,40055],[24,7947,40287],[24,7947,40642],
 [24,7947,41069],[24,7947,41411],[24,7947,42593],[24,7947,42936],[24,7947,44904],
 [24,7947,45501],[24,7947,47090],[24,7950],[24,7952,7828],[24,7952,7875],[24,7952,7950],
 [24,7952,38205],[24,7952,38331],[24,7952,38921],[24,7952,39193],[24,7952,39779],
 [24,7952,40055],[24,7952,40642],[24,7952,41411],[24,7952,42193],[24,7952,42936],
 [24,8049,7828],[24,8049,7875],[24,8049,7950],[24,8049,40055],[24,8049,40287],
 [24,8049,40642],[24,8049,41069],[24,8049,41411],[24,8049,42593],[24,8049,42936],
 [24,8049,44904],[24,8049,45501],[24,8049,47090],[24,8050,7828],[24,8050,41850],
 [24,8050,42193],[24,8050,44904],[24,8050,46064],[24,8052,7828],[24,8052,7875],
 [24,8052,7950],[24,8052,40055],[24,8052,40287],[24,8052,40642],[24,8052,41069],
 [24,8052,41411],[24,8052,42593],[24,8052,42936],[24,8052,44904],[24,8052,45501],
 [24,8052,47090],[24,8061,7828],[24,8061,7875],[24,8061,7950],[24,8061,40055],
 [24,8061,40287],[24,8061,40642],[24,8061,41069],[24,8061,41411],[24,8061,42593],
 [24,8061,42936],[24,8061,44904],[24,8061,45501],[24,8061,47090],[24,8063,7828],
 [24,8063,41850],[24,8063,42193],[24,8063,44904],[24,8063,46064],[24,8065,7828],
 [24,8065,7875],[24,8065,7950],[24,8065,40055],[24,8065,40287],[24,8065,40642],
 [24,8065,41069],[24,8065,41411],[24,8065,42593],[24,8065,42936],[24,8065,44904],
 [24,8065,45501],[24,8065,47090],[24,8085,7828],[24,8085,38205],[24,8085,38557],
 [24,8085,39424],[24,8085,40287],[24,8093,7828],[24,8093,7875],[24,8093,7950],
 [24,8093,40055],[24,8093,40287],[24,8093,40642],[24,8093,41069],[24,8093,41411],
 [24,8093,42593],[24,8093,42936],[24,8093,44904],[24,8093,45501],[24,8093,47090],
 [24,8096,7828],[24,8096,7875],[24,8096,7950],[24,8096,40055],[24,8096,40287],
 [24,8096,40642],[24,8096,41069],[24,8096,41411],[24,8096,42593],[24,8096,42936],
 [24,8096,44904],[24,8096,45501],[24,8096,47090],[24,8100,7828],[24,8100,7875],
 [24,8100,7950],[24,8100,40055],[24,8100,40287],[24,8100,40642],[24,8100,41069],
 [24,8100,41411],[24,8100,42593],[24,8100,42936],[24,8100,44904],[24,8100,45501],
 [24,8100,47090],[24,8121,7828],[24,8121,38205],[24,8121,38557],[24,8121,39424],
 [24,8121,40287],[24,8127,7828],[24,8127,41850],[24,8127,42193],[24,8127,44904],
 [24,8127,46064],[24,8132,7828],[24,8132,41850],[24,8132,42193],[24,8132,44904],
 [24,8132,46064],[24,8192,7828],[24,8192,7875],[24,8192,7950],[24,8192,40055],
 [24,8192,40287],[24,8192,40642],[24,8192,41069],[24,8192,41411],[24,8192,42593],
 [24,8192,42936],[24,8192,44904],[24,8192,45501],[24,8192,47090],[24,8195,7828],
 [24,8195,7875],[24,8195,7950],[24,8195,40055],[24,8195,40287],[24,8195,40642],
 [24,8195,41069],[24,8195,41411],[24,8195,42593],[24,8195,42936],[24,8195,44904],
 [24,8195,45501],[24,8195,47090],[24,8199,7828],[24,8199,7875],[24,8199,7950],
 [24,8199,40055],[24,8199,40287],[24,8199,40642],[24,8199,41069],[24,8199,41411],
 [24,8199,42593],[24,8199,42936],[24,8199,44904],[24,8199,45501],[24,8199,47090],
 [24,8366,7828],[24,8366,7875],[24,8366,7950],[24,8366,40055],[24,8366,40287],
 [24,8366,40642],[24,8366,41069],[24,8366,41411],[24,8366,42593],[24,8366,42936],
 [24,8366,44904],[24,8366,45501],[24,8366,47090],[24,8368,7828],[24,8368,41850],
 [24,8368,42193],[24,8368,44904],[24,8368,46064],[24,8370,7828],[24,8370,7875],
 [24,8370,7950],[24,8370,40055],[24,8370,40287],[24,8370,40642],[24,8370,41069],
 [24,8370,41411],[24,8370,42593],[24,8370,42936],[24,8370,44904],[24,8370,45501],
 [24,8370,47090],[24,8440,7828],[24,8440,7875],[24,8440,7950],[24,8440,38205],
 [24,8440,38331],[24,8440,38921],[24,8440,39193],[24,8440,39779],[24,8440,40055],
 [24,8440,40642],[24,8440,41411],[24,8440,42193],[24,8440,42936],[24,8485,7828],
 [24,8485,7875],[24,8485,7950],[24,8485,38205],[24,8485,38331],[24,8485,38921],
 [24,8485,39193],[24,8485,39779],[24,8485,40055],[24,8485,40642],[24,8485,41411],
 [24,8485,42193],[24,8485,42936],[24,38205],[24,38304],[24,38331],[24,38557],
 [24,38921],[24,39193],[24,39424],[24,39779],[24,40055],[24,40287],[24,40642],
 [24,41069],[24,41217],[24,41411],[24,41850],[24,41900],[24,42193],[24,42593],
 [24,42936],[24,44904],[24,45501],[24,46064],[24,47090],[25,1291],[25,1306],
 [25,1336],[25,1377],[25,1432],[25,1625],[25,1658],[25,1698],[25,1761],[25,2279],
 [25,3507],[25,3677],[25,3714],[25,5705],[25,6018],[25,6050],[25,7828],[25,7875],
 [25,7950],[25,38205],[25,38304],[25,38331],[25,38557],[25,38921],[25,39193],
 [25,39424],[25,39779],[25,40055],[25,40287],[25,40642],[25,41069],[25,41217],
 [25,41411],[25,41850],[25,41900],[25,42193],[25,42593],[25,42936],[25,44904],
 [25,45501],[25,46064],[25,47090],[27,1291],[27,1306],[27,1336],[27,1377],[27,1432],
 [27,1625],[27,1658],[27,1698],[27,1761],[27,2279],[27,3507],[27,3677],[27,3714],
 [27,5705],[27,6018],[27,6050],[27,7828],[27,7875],[27,7950],[27,38205],[27,38304],
 [27,38331],[27,38557],[27,38921],[27,39193],[27,39424],[27,39779],[27,40055],
 [27,40287],[27,40642],[27,41069],[27,41217],[27,41411],[27,41850],[27,41900],
 [27,42193],[27,42593],[27,42936],[27,44904],[27,45501],[27,46064],[27,47090],
 [28,1291],[28,1306],[28,1336],[28,1377],[28,1432],[28,1625],[28,1658],[28,1698],
 [28,1761],[28,2279],[28,3507],[28,3677],[28,3714],[28,5705],[28,6018],[28,6050],
 [28,7828],[28,7875],[28,7950],[28,38205],[28,38304],[28,38331],[28,38557],
 [28,38921],[28,39193],[28,39424],[28,39779],[28,40055],[28,40287],[28,40642],
 [28,41069],[28,41217],[28,41411],[28,41850],[28,41900],[28,42193],[28,42593],
 [28,42936],[28,44904],[28,45501],[28,46064],[28,47090],[29,3756],[30,1583],
 [30,3794],[33,1291],[33,1306],[33,1336],[33,1377],[33,1432],[33,1625],[33,1658],
 [33,1698],[33,1761],[33,2279],[33,3507],[33,3677],[33,3714],[33,5705],[33,6018],
 [33,6050],[33,7828],[33,7875],[33,7950],[33,38205],[33,38304],[33,38331],[33,38557],
 [33,38921],[33,39193],[33,39424],[33,39779],[33,40055],[33,40287],[33,40642],
 [33,41069],[33,41217],[33,41411],[33,41850],[33,41900],[33,42193],[33,42593],
 [33,42936],[33,44904],[33,45501],[33,46064],[33,47090],[34,1719],[34,3930],
 [35,1291],[35,1306],[35,1336],[35,1377],[35,1432],[35,1625],[35,1658],[35,1698],
 [35,1761],[35,2279],[35,3507],[35,3677],[35,3714],[35,5705],[35,6018],[35,6050],
 [35,7828],[35,7875],[35,7950],[35,38205],[35,38304],[35,38331],[35,38557],
 [35,38921],[35,39193],[35,39424],[35,39779],[35,40055],[35,40287],[35,40642],
 [35,41069],[35,41217],[35,41411],[35,41850],[35,41900],[35,42193],[35,42593],
 [35,42936],[35,44904],[35,45501],[35,46064],[35,47090],[36,1719],[36,3930],
 [37,3756],[38,1583],[38,3794],[39,1887],[39,4098],[40,1915],[40,4126],[43,4193],
 [45,2033],[45,4244],[46,1291],[46,1306],[46,1336],[46,1377],[46,1432],[46,1625],
 [46,1658],[46,1698],[46,1761],[46,2279],[46,3507],[46,3677],[46,3714],[46,5705],
 [46,6018],[46,6050],[46,7828],[46,7875],[46,7950],[46,38205],[46,38304],[46,38331],
 [46,38557],[46,38921],[46,39193],[46,39424],[46,39779],[46,40055],[46,40287],
 [46,40642],[46,41069],[46,41217],[46,41411],[46,41850],[46,41900],[46,42193],
 [46,42593],[46,42936],[46,44904],[46,45501],[46,46064],[46,47090],[47,4193],
 [48,1291],[48,1306],[48,1336],[48,1377],[48,1432],[48,1625],[48,1658],[48,1698],
 [48,1761],[48,2279],[48,3507],[48,3677],[48,3714],[48,5705],[48,6018],[48,6050],
 [48,7828],[48,7875],[48,7950],[48,38205],[48,38304],[48,38331],[48,38557],
 [48,38921],[48,39193],[48,39424],[48,39779],[48,40055],[48,40287],[48,40642],
 [48,41069],[48,41217],[48,41411],[48,41850],[48,41900],[48,42193],[48,42593],
 [48,42936],[48,44904],[48,45501],[48,46064],[48,47090],[49,1625],[49,1630,1625],
 [49,1630,44983,45084],[49,1630,44984,45084],[49,1630,45084],[49,1630,50453,45084],
 [49,1631,1625],[49,1631,45084],[49,2007,1625],[49,2007,45084],[49,2008,1625],
 [49,2008,45084],[49,2108,1625],[49,2108,45084],[49,3507],[49,45084],[50,1625],
 [50,3507],[50,45084],[51,1316,39015],[51,1317,39015],[51,1625],[51,2143,39015],
 [51,3507],[51,39015],[52,1625],[52,3507],[52,39015],[53,2033],[53,4244],[54,1887],
 [54,4098],[55,1915],[55,4126],[56,2215],[56,4426],[57,2224],[57,4435],[58,2224],
 [58,4435],[59,2215],[59,4426],[60,2254],[60,4465],[61,2262],[61,4473],[62,2268],
 [62,4479],[63,2270],[63,4481],[64,2254],[64,4465],[65,2270],[65,4481],[66,2262],
 [66,4473],[67,2268],[67,4479],[68,2279],[69,202],[69,1336],[69,9788],[69,17232],
 [70,268],[70,4624],[71,328],[72,393],[72,4749],[73,202],[73,1336],[73,9788],
 [73,17232],[74,328],[75,569],[75,4925],[76,268],[76,4624],[77,569],[77,4925],
 [78,393],[78,4749],[95,1336],[95,1337,1336],[95,1337,39274,39313],[95,1337,39275,39313],
 [95,1337,39313],[95,1337,42515,39313],[95,1338,1336],[95,1338,39313],[95,1499,1336],
 [95,1499,39313],[95,1500,1336],[95,1500,39313],[95,1538,1336],[95,1538,39313],
 [95,5705],[95,39313],[96,1336],[96,5705],[96,39313],[97,1291],[97,1306],[97,1336],
 [97,1377],[97,1432],[97,1625],[97,1658],[97,1698],[97,1761],[97,2279],[97,3507],
 [97,3677],[97,3714],[97,5705],[97,6018],[97,6050],[97,7828],[97,7875],[97,7950],
 [97,38205],[97,38304],[97,38331],[97,38557],[97,38921],[97,39193],[97,39424],
 [97,39779],[97,40055],[97,40287],[97,40642],[97,41069],[97,41217],[97,41411],
 [97,41850],[97,41900],[97,42193],[97,42593],[97,42936],[97,44904],[97,45501],
 [97,46064],[97,47090],[98,1291],[98,1306],[98,1336],[98,1377],[98,1432],[98,1625],
 [98,1658],[98,1698],[98,1761],[98,2279],[98,3507],[98,3677],[98,3714],[98,5705],
 [98,6018],[98,6050],[98,7828],[98,7875],[98,7950],[98,38205],[98,38304],[98,38331],
 [98,38557],[98,38921],[98,39193],[98,39424],[98,39779],[98,40055],[98,40287],
 [98,40642],[98,41069],[98,41217],[98,41411],[98,41850],[98,41900],[98,42193],
 [98,42593],[98,42936],[98,44904],[98,45501],[98,46064],[98,47090],[99,1291],
 [99,1306],[99,1336],[99,1377],[99,1432],[99,1625],[99,1658],[99,1698],[99,1761],
 [99,2279],[99,3507],[99,3677],[99,3714],[99,5705],[99,6018],[99,6050],[99,7828],
 [99,7875],[99,7950],[99,38205],[99,38304],[99,38331],[99,38557],[99,38921],
 [99,39193],[99,39424],[99,39779],[99,40055],[99,40287],[99,40642],[99,41069],
 [99,41217],[99,41411],[99,41850],[99,41900],[99,42193],[99,42593],[99,42936],
 [99,44904],[99,45501],[99,46064],[99,47090],[100,1336],[100,1724,46593],
 [100,1730,46593],[100,1933,46593],[100,5705],[100,46593],[101,1291],[101,1306],
 [101,1336],[101,1377],[101,1432],[101,1625],[101,1658],[101,1698],[101,1761],
 [101,2279],[101,3507],[101,3677],[101,3714],[101,5705],[101,6018],[101,6050],
 [101,7828],[101,7875],[101,7950],[101,38205],[101,38304],[101,38331],[101,38557],
 [101,38921],[101,39193],[101,39424],[101,39779],[101,40055],[101,40287],[101,40642],
 [101,41069],[101,41217],[101,41411],[101,41850],[101,41900],[101,42193],[101,42593],
 [101,42936],[101,44904],[101,45501],[101,46064],[101,47090],[102,6152],[103,1827],
 [103,6183],[104,6213],[105,1887],[105,6243],[106,1915],[106,6271],[108,1291],
 [108,1306],[108,1336],[108,1377],[108,1432],[108,1625],[108,1658],[108,1698],
 [108,1761],[108,2279],[108,3507],[108,3677],[108,3714],[108,5705],[108,6018],
 [108,6050],[108,7828],[108,7875],[108,7950],[108,38205],[108,38304],[108,38331],
 [108,38557],[108,38921],[108,39193],[108,39424],[108,39779],[108,40055],[108,40287],
 [108,40642],[108,41069],[108,41217],[108,41411],[108,41850],[108,41900],[108,42193],
 [108,42593],[108,42936],[108,44904],[108,45501],[108,46064],[108,47090],[109,1984],
 [109,6340],[110,1291],[110,1306],[110,1336],[110,1377],[110,1432],[110,1625],
 [110,1658],[110,1698],[110,1761],[110,2279],[110,3507],[110,3677],[110,3714],
 [110,5705],[110,6018],[110,6050],[110,7828],[110,7875],[110,7950],[110,38205],
 [110,38304],[110,38331],[110,38557],[110,38921],[110,39193],[110,39424],[110,39779],
 [110,40055],[110,40287],[110,40642],[110,41069],[110,41217],[110,41411],[110,41850],
 [110,41900],[110,42193],[110,42593],[110,42936],[110,44904],[110,45501],[110,46064],
 [110,47090],[111,2033],[111,6389],[112,1291],[112,1306],[112,1336],[112,1377],
 [112,1432],[112,1625],[112,1658],[112,1698],[112,1761],[112,2279],[112,3507],
 [112,3677],[112,3714],[112,5705],[112,6018],[112,6050],[112,7828],[112,7875],
 [112,7950],[112,38205],[112,38304],[112,38331],[112,38557],[112,38921],[112,39193],
 [112,39424],[112,39779],[112,40055],[112,40287],[112,40642],[112,41069],[112,41217],
 [112,41411],[112,41850],[112,41900],[112,42193],[112,42593],[112,42936],[112,44904],
 [112,45501],[112,46064],[112,47090],[113,1336],[113,5705],[113,46593],[114,1291],
 [114,1306],[114,1336],[114,1377],[114,1432],[114,1625],[114,1658],[114,1698],
 [114,1761],[114,2279],[114,3507],[114,3677],[114,3714],[114,5705],[114,6018],
 [114,6050],[114,7828],[114,7875],[114,7950],[114,38205],[114,38304],[114,38331],
 [114,38557],[114,38921],[114,39193],[114,39424],[114,39779],[114,40055],[114,40287],
 [114,40642],[114,41069],[114,41217],[114,41411],[114,41850],[114,41900],[114,42193],
 [114,42593],[114,42936],[114,44904],[114,45501],[114,46064],[114,47090],[115,1984],
 [115,6340],[116,6152],[117,1827],[117,6183],[118,6213],[119,2033],[119,6389],
 [120,1887],[120,6243],[121,1915],[121,6271],[122,2215],[122,6571],[123,2224],
 [123,6580],[124,2224],[124,6580],[125,2215],[125,6571],[126,2254],[126,6610],
 [127,2262],[127,6618],[128,2268],[128,6624],[129,2270],[129,6626],[130,2254],
 [130,6610],[131,2270],[131,6626],[132,2262],[132,6618],[133,2268],[133,6624],
 [134,202],[135,268],[135,6704],[136,328],[136,6764],[137,393],[137,6829],[138,202],
 [139,328],[139,6764],[140,569],[140,7005],[141,268],[141,6704],[142,569],[142,7005],
 [143,393],[143,6829],[154,1291],[154,1306],[154,1336],[154,1377],[154,1432],
 [154,1625],[154,1658],[154,1698],[154,1761],[154,2279],[154,3507],[154,3677],
 [154,3714],[154,5705],[154,6018],[154,6050],[154,7828],[154,7875],[154,7950],
 [154,38205],[154,38304],[154,38331],[154,38557],[154,38921],[154,39193],[154,39424],
 [154,39779],[154,40055],[154,40287],[154,40642],[154,41069],[154,41217],[154,41411],
 [154,41850],[154,41900],[154,42193],[154,42593],[154,42936],[154,44904],[154,45501],
 [154,46064],[154,47090],[155,1291],[155,1306],[155,1336],[155,1377],[155,1432],
 [155,1625],[155,1658],[155,1698],[155,1761],[155,2279],[155,3507],[155,3677],
 [155,3714],[155,5705],[155,6018],[155,6050],[155,7828],[155,7875],[155,7950],
 [155,38205],[155,38304],[155,38331],[155,38557],[155,38921],[155,39193],[155,39424],
 [155,39779],[155,40055],[155,40287],[155,40642],[155,41069],[155,41217],[155,41411],
 [155,41850],[155,41900],[155,42193],[155,42593],[155,42936],[155,44904],[155,45501],
 [155,46064],[155,47090],[157,1424,1698],[157,1424,41154],[157,1439,1698],
 [157,1439,41154],[157,1698],[157,7860,7875],[157,7860,41154],[157,7875],[157,8134,7875],
 [157,8134,41154],[157,41154],[159,1291],[159,1306],[159,1336],[159,1377],[159,1432],
 [159,1625],[159,1658],[159,1698],[159,1761],[159,2279],[159,3507],[159,3677],
 [159,3714],[159,5705],[159,6018],[159,6050],[159,7828],[159,7875],[159,7950],
 [159,38205],[159,38304],[159,38331],[159,38557],[159,38921],[159,39193],[159,39424],
 [159,39779],[159,40055],[159,40287],[159,40642],[159,41069],[159,41217],[159,41411],
 [159,41850],[159,41900],[159,42193],[159,42593],[159,42936],[159,44904],[159,45501],
 [159,46064],[159,47090],[160,1560],[160,7996],[161,8032],[162,1291],[162,1306],
 [162,1336],[162,1377],[162,1432],[162,1625],[162,1658],[162,1698],[162,1761],
 [162,2279],[162,3507],[162,3677],[162,3714],[162,5705],[162,6018],[162,6050],
 [162,7828],[162,7875],[162,7950],[162,38205],[162,38304],[162,38331],[162,38557],
 [162,38921],[162,39193],[162,39424],[162,39779],[162,40055],[162,40287],[162,40642],
 [162,41069],[162,41217],[162,41411],[162,41850],[162,41900],[162,42193],[162,42593],
 [162,42936],[162,44904],[162,45501],[162,46064],[162,47090],[164,1698],[164,7875],
 [164,41154],[165,8168],[167,1377],[167,1540,1551],[167,1540,1658],[167,1540,1719],
 [167,1540,43330],[167,1540,43332,43330],[167,1540,43338,43330],[167,1540,43339,43330],
 [167,1540,43399,43330],[167,1540,43405,43330],[167,1540,43406,43330],[167,1540,43468,47575],
 [167,1540,43469,47575],[167,1540,43634,47575],[167,1540,45290,43330],[167,1540,45296,43330],
 [167,1540,45297,43330],[167,1540,45359,47575],[167,1540,45360,47575],[167,1540,45525,47575],
 [167,1540,46448,47575],[167,1540,46449,47575],[167,1540,46614,47575],[167,1540,47575],
 [167,1542,1551],[167,1542,1658],[167,1542,1719],[167,1542,43330],[167,1542,47575],
 [167,1544,1551],[167,1544,1658],[167,1544,1719],[167,1544,43330],[167,1544,47575],
 [167,1550,1551],[167,1550,1658],[167,1550,1719],[167,1550,43330],[167,1550,47575],
 [167,1551],[167,1650,1551],[167,1650,1658],[167,1650,1719],[167,1650,43330],
 [167,1650,47575],[167,1652,1551],[167,1652,1658],[167,1652,1719],[167,1652,43330],
 [167,1652,47575],[167,1658],[167,1659,1551],[167,1659,1658],[167,1659,1719],
 [167,1659,43330],[167,1659,47575],[167,1719],[167,1725,1551],[167,1725,1658],
 [167,1725,1719],[167,1725,43330],[167,1725,47575],[167,1726,1551],[167,1726,1658],
 [167,1726,1719],[167,1726,43330],[167,1726,47575],[167,1761],[167,1788,1551],
 [167,1788,1658],[167,1788,1719],[167,1788,43330],[167,1788,47575],[167,1789,1551],
 [167,1789,1658],[167,1789,1719],[167,1789,43330],[167,1789,47575],[167,1954,1551],
 [167,1954,1658],[167,1954,1719],[167,1954,43330],[167,1954,47575],[167,7828],
 [167,40287],[167,42193],[167,43330],[167,47575],[168,1377],[168,1387,1377],
 [168,1387,1827],[168,1387,1855],[168,1387,40104,40450],[168,1387,40105,40450],
 [168,1387,40117,42362],[168,1387,40118,42362],[168,1387,40450],[168,1387,40462,40450],
 [168,1387,40463,40450],[168,1387,40491,40450],[168,1387,40492,40450],[168,1387,40762,42362],
 [168,1387,42050,40450],[168,1387,42062,42362],[168,1387,42063,42362],[168,1387,42091,42362],
 [168,1387,42092,42362],[168,1387,42362],[168,1387,47911,40450],[168,1387,47912,40450],
 [168,1387,48182,42362],[168,1387,48588,42362],[168,1388,1377],[168,1388,1827],
 [168,1388,1855],[168,1388,40450],[168,1388,42362],[168,1400,1377],[168,1400,1827],
 [168,1400,1855],[168,1400,40450],[168,1400,42362],[168,1401,1377],[168,1401,1827],
 [168,1401,1855],[168,1401,40450],[168,1401,42362],[168,1468,1377],[168,1468,1827],
 [168,1468,1855],[168,1468,40450],[168,1468,42362],[168,1469,1377],[168,1469,1827],
 [168,1469,1855],[168,1469,40450],[168,1469,42362],[168,1481,1377],[168,1481,1827],
 [168,1481,1855],[168,1481,40450],[168,1481,42362],[168,1482,1377],[168,1482,1827],
 [168,1482,1855],[168,1482,40450],[168,1482,42362],[168,1658],[168,1761],[168,1814,1377],
 [168,1814,1827],[168,1814,1855],[168,1814,40450],[168,1814,42362],[168,1826,1377],
 [168,1826,1827],[168,1826,1855],[168,1826,40450],[168,1826,42362],[168,1827],[168,1855],
 [168,1856,1377],[168,1856,1827],[168,1856,1855],[168,1856,40450],[168,1856,42362],
 [168,2126,1377],[168,2126,1827],[168,2126,1855],[168,2126,40450],[168,2126,42362],
 [168,7828],[168,40287],[168,40450],[168,42193],[168,42362],[169,1377],[169,1658],
 [169,1761],[169,1827],[169,1855],[169,7828],[169,40287],[169,40450],[169,42193],
 [169,42362],[170,1887],[170,8323],[171,1915],[171,8351],[172,1291],[172,1306],
 [172,1336],[172,1377],[172,1432],[172,1625],[172,1658],[172,1698],[172,1761],
 [172,2279],[172,3507],[172,3677],[172,3714],[172,5705],[172,6018],[172,6050],
 [172,7828],[172,7875],[172,7950],[172,38205],[172,38304],[172,38331],[172,38557],
 [172,38921],[172,39193],[172,39424],[172,39779],[172,40055],[172,40287],[172,40642],
 [172,41069],[172,41217],[172,41411],[172,41850],[172,41900],[172,42193],[172,42593],
 [172,42936],[172,44904],[172,45501],[172,46064],[172,47090],[174,1377],[174,1551],
 [174,1658],[174,1719],[174,1761],[174,7828],[174,40287],[174,42193],[174,43330],
 [174,47575],[175,1291],[175,1306],[175,1336],[175,1377],[175,1432],[175,1625],
 [175,1658],[175,1698],[175,1761],[175,2279],[175,3507],[175,3677],[175,3714],
 [175,5705],[175,6018],[175,6050],[175,7828],[175,7875],[175,7950],[175,38205],
 [175,38304],[175,38331],[175,38557],[175,38921],[175,39193],[175,39424],[175,39779],
 [175,40055],[175,40287],[175,40642],[175,41069],[175,41217],[175,41411],[175,41850],
 [175,41900],[175,42193],[175,42593],[175,42936],[175,44904],[175,45501],[175,46064],
 [175,47090],[176,2033],[176,8469],[178,2071],[178,8507],[179,1698],[179,7875],
 [179,41154],[180,8168],[181,2071],[181,8507],[182,8032],[183,1560],[183,7996],
 [184,2033],[184,8469],[185,1887],[185,8323],[186,1915],[186,8351],[187,2215],
 [187,8651],[188,2224],[188,8660],[189,2224],[189,8660],[190,2215],[190,8651],
 [191,2254],[191,8690],[192,2262],[192,8698],[193,2268],[193,8704],[194,2270],
 [194,8706],[195,2254],[195,8690],[196,2270],[196,8706],[197,2262],[197,8698],
 [198,2268],[198,8704],[199,202],[199,268],[199,328],[199,8715],[199,8962],
 [199,10854],[199,12747],[200,202],[200,268],[200,328],[200,8715],[200,8962],
 [200,10854],[200,12747],[201,202],[201,393],[201,8845],[201,14579],[203,202],
 [203,268],[203,328],[203,8715],[203,8962],[203,10854],[203,12747],[204,202],
 [204,569],[204,9021],[204,16465],[205,202],[205,268],[205,328],[205,8715],
 [205,8962],[205,10854],[205,12747],[206,202],[206,569],[206,9021],[206,16465],
 [207,202],[207,393],[207,8845],[207,14579],[208,202],[209,202],[210,202],[211,202],
 [212,202],[213,202],[214,202],[215,202],[216,202],[217,202],[218,202],[219,202],
 [219,1336],[219,9788],[219,17232],[220,202],[220,1377],[220,9829],[220,17273],
 [221,202],[222,202],[222,1377],[222,9829],[222,17273],[223,202],[223,1336],
 [223,9788],[223,17232],[224,202],[225,202],[226,202],[226,1625],[226,10077],
 [226,17521],[227,202],[227,1658],[227,10110],[227,17554],[228,202],[228,1698],
 [228,10150],[228,17594],[229,202],[230,202],[230,1761],[230,10213],[230,17657],
 [231,202],[232,202],[233,202],[234,202],[234,1887],[234,10339],[234,17783],
 [235,202],[235,1915],[235,10367],[235,17811],[236,202],[237,202],[237,1658],
 [237,10110],[237,17554],[238,202],[239,202],[239,1625],[239,10077],[239,17521],
 [240,202],[240,2033],[240,10485],[240,17929],[241,202],[241,1761],[241,10213],
 [241,17657],[242,202],[243,202],[243,1698],[243,10150],[243,17594],[244,202],
 [245,202],[246,202],[247,202],[248,202],[248,2033],[248,10485],[248,17929],
 [249,202],[249,1887],[249,10339],[249,17783],[250,202],[250,1915],[250,10367],
 [250,17811],[251,202],[251,2215],[251,10667],[251,18111],[252,202],[252,2224],
 [252,10676],[252,18120],[253,202],[253,2224],[253,10676],[253,18120],[254,202],
 [254,2215],[254,10667],[254,18111],[255,202],[255,2254],[255,10706],[255,18150],
 [256,202],[256,2262],[256,10714],[256,18158],[257,202],[257,2268],[257,10720],
 [257,18164],[258,202],[258,2270],[258,10722],[258,18166],[259,202],[259,2254],
 [259,10706],[259,18150],[260,202],[260,2270],[260,10722],[260,18166],[261,202],
 [261,2262],[261,10714],[261,18158],[262,202],[262,2268],[262,10720],[262,18164],
 [263,202],[263,268],[263,328],[263,8715],[263,8962],[263,10854],[263,12747],
 [264,268],[264,393],[264,10796],[264,10798],[264,11032],[264,14753],[265,202],
 [265,268],[265,328],[265,8715],[265,8962],[265,10854],[265,12747],[266,202],
 [266,268],[266,328],[266,8715],[266,8962],[266,10854],[266,12747],[267,268],
 [267,569],[267,10973],[267,10974],[267,11031],[267,19886],[269,268],[269,569],
 [269,10973],[269,10974],[269,11031],[269,19886],[270,268],[270,393],[270,10796],
 [270,10798],[270,11032],[270,14753],[271,268],[271,11033],[272,268],[272,11034],
 [273,268],[273,11035],[274,268],[274,11036],[275,268],[275,11037],[276,268],
 [276,11038],[277,268],[277,11039],[278,268],[278,11040],[279,268],[279,11041],
 [280,268],[280,11042],[281,268],[281,11043],[282,268],[282,1336],[282,11044],
 [282,11048],[282,11741],[282,22192],[283,268],[283,1377],[283,11045],[283,11047],
 [283,11782],[283,22233],[284,268],[284,11046],[285,268],[285,1377],[285,11045],
 [285,11047],[285,11782],[285,22233],[286,268],[286,1336],[286,11044],[286,11048],
 [286,11741],[286,22192],[287,268],[287,11049],[288,268],[288,11050],[289,268],
 [289,1625],[289,11051],[289,11064],[289,12030],[289,22481],[290,268],[290,1658],
 [290,11052],[290,11062],[290,12063],[290,22514],[291,268],[291,1698],[291,11053],
 [291,11068],[291,12103],[291,22554],[292,268],[292,11054],[293,268],[293,1761],
 [293,11055],[293,11066],[293,12166],[293,22617],[294,268],[294,11056],[295,268],
 [295,11057],[296,268],[296,11058],[297,268],[297,1887],[297,11059],[297,11074],
 [297,12292],[297,22743],[298,268],[298,1915],[298,11060],[298,11075],[298,12320],
 [298,22771],[299,268],[299,11061],[300,268],[300,1658],[300,11052],[300,11062],
 [300,12063],[300,22514],[301,268],[301,11063],[302,268],[302,1625],[302,11051],
 [302,11064],[302,12030],[302,22481],[303,268],[303,2033],[303,11065],[303,11073],
 [303,12438],[303,22889],[304,268],[304,1761],[304,11055],[304,11066],[304,12166],
 [304,22617],[305,268],[305,11067],[306,268],[306,1698],[306,11053],[306,11068],
 [306,12103],[306,22554],[307,268],[307,11069],[308,268],[308,11070],[309,268],
 [309,11071],[310,268],[310,11072],[311,268],[311,2033],[311,11065],[311,11073],
 [311,12438],[311,22889],[312,268],[312,1887],[312,11059],[312,11074],[312,12292],
 [312,22743],[313,268],[313,1915],[313,11060],[313,11075],[313,12320],[313,22771],
 [314,268],[314,2215],[314,11076],[314,11079],[314,12620],[314,23071],[315,268],
 [315,2224],[315,11077],[315,11078],[315,12629],[315,23080],[316,268],[316,2224],
 [316,11077],[316,11078],[316,12629],[316,23080],[317,268],[317,2215],[317,11076],
 [317,11079],[317,12620],[317,23071],[318,268],[318,2254],[318,11080],[318,11084],
 [318,12659],[318,23110],[319,268],[319,2262],[319,11081],[319,11086],[319,12667],
 [319,23118],[320,268],[320,2268],[320,11082],[320,11087],[320,12673],[320,23124],
 [321,268],[321,2270],[321,11083],[321,11085],[321,12675],[321,23126],[322,268],
 [322,2254],[322,11080],[322,11084],[322,12659],[322,23110],[323,268],[323,2270],
 [323,11083],[323,11085],[323,12675],[323,23126],[324,268],[324,2262],[324,11081],
 [324,11086],[324,12667],[324,23118],[325,268],[325,2268],[325,11082],[325,11087],
 [325,12673],[325,23124],[326,328],[326,393],[326,569],[326,12685,14635],
 [326,12686,14635],[326,12688,12979],[326,12689,12979],[326,12805,14635],[326,12807,12979],
 [326,12808,12979],[326,12865,12979],[326,12866,12979],[326,12979],[326,14635],
 [326,14637,14635],[326,14638,14635],[326,14695,14635],[326,14696,14635],[326,14809,12979],
 [326,18176,14635],[326,18177,14635],[326,18290,12979],[326,19943,12979],[327,202],
 [327,268],[327,328],[327,8715],[327,8962],[327,10854],[327,12747],[329,328],
 [329,393],[329,569],[329,12979],[329,14635],[330,202],[330,268],[330,328],
 [330,8715],[330,8962],[330,10854],[330,12747],[331,328],[331,393],[331,569],
 [331,12979],[331,14635],[332,328],[332,393],[332,569],[332,12979],[332,14635],
 [333,328],[333,12809],[334,328],[334,12810],[335,328],[335,12811],[336,328],
 [336,12812],[337,328],[337,12813],[338,328],[338,12814],[339,328],[339,12815],
 [340,328],[340,12816],[341,328],[341,12817],[342,328],[342,12818],[343,328],
 [343,12819],[344,328],[344,1336],[344,12820],[344,12824],[344,13632],[344,18943],
 [345,328],[345,1377],[345,12821],[345,12823],[345,13673],[345,18984],[346,328],
 [346,12822],[347,328],[347,1377],[347,12821],[347,12823],[347,13673],[347,18984],
 [348,328],[348,1336],[348,12820],[348,12824],[348,13632],[348,18943],[349,328],
 [349,12825],[350,328],[350,12826],[351,328],[351,1625],[351,12827],[351,12840],
 [351,13921],[351,19232],[352,328],[352,1658],[352,12828],[352,12838],[352,13954],
 [352,19265],[353,328],[353,1698],[353,12829],[353,12844],[353,13994],[353,19305],
 [354,328],[354,12830],[355,328],[355,1761],[355,12831],[355,12842],[355,14057],
 [355,19368],[356,328],[356,12832],[357,328],[357,12833],[358,328],[358,12834],
 [359,328],[359,1887],[359,12835],[359,12850],[359,14183],[359,19494],[360,328],
 [360,1915],[360,12836],[360,12851],[360,13967],[360,14211],[360,19509],[360,19522],
 [361,328],[361,12837],[362,328],[362,1658],[362,12828],[362,12838],[362,13954],
 [362,19265],[363,328],[363,12839],[364,328],[364,1625],[364,12827],[364,12840],
 [364,13921],[364,19232],[365,328],[365,2033],[365,12841],[365,12849],[365,13699],
 [365,14329],[365,19083],[365,19640],[366,328],[366,1761],[366,12831],[366,12842],
 [366,14057],[366,19368],[367,328],[367,12843],[368,328],[368,1698],[368,12829],
 [368,12844],[368,13994],[368,19305],[369,328],[369,12845],[370,328],[370,12846],
 [371,328],[371,12847],[372,328],[372,12848],[373,328],[373,2033],[373,12841],
 [373,12849],[373,13699],[373,14329],[373,19083],[373,19640],[374,328],[374,1887],
 [374,12835],[374,12850],[374,14183],[374,19494],[375,328],[375,1915],[375,12836],
 [375,12851],[375,13967],[375,14211],[375,19509],[375,19522],[376,328],[376,2215],
 [376,2268],[376,12852,14514],[376,12855,19857],[376,12858,14514],[376,12863,19857],
 [376,14511,14514],[376,14514],[376,14519,14514],[376,14541,14514],[376,14546,19857],
 [376,14564,14514],[376,19822,19857],[376,19825,14514],[376,19830,19857],[376,19852,19857],
 [376,19857],[376,19875,19857],[376,52196,14514],[376,52201,19857],[376,52219,14514],
 [376,52328,19857],[377,328],[377,2224],[377,2262],[377,12853,14523],[377,12854,19848],
 [377,12857,14523],[377,12862,19848],[377,14520,14523],[377,14523],[377,14528,14523],
 [377,14532,14523],[377,14537,19848],[377,14558,14523],[377,19831,19848],[377,19834,14523],
 [377,19839,19848],[377,19843,19848],[377,19848],[377,19869,19848],[377,52232,14523],
 [377,52237,19848],[377,52258,14523],[377,52294,19848],[378,328],[378,2224],[378,2262],
 [378,14523],[378,19848],[379,328],[379,2215],[379,2268],[379,14514],[379,19857],
 [380,328],[380,2254],[380,2270],[380,12856,19862],[380,12859,14565],[380,12860,14565],
 [380,12861,19862],[380,14549,14565],[380,14550,14565],[380,14551,19862],[380,14565],
 [380,14566,14565],[380,14569,14565],[380,19860,19862],[380,19861,19862],[380,19862],
 [380,19876,14565],[380,19877,19862],[380,19880,19862],[380,52350,14565],[380,52351,19862],
 [380,52354,19862],[380,52385,14565],[381,328],[381,2224],[381,2262],[381,14523],
 [381,19848],[382,328],[382,2215],[382,2268],[382,14514],[382,19857],[383,328],
 [383,2254],[383,2270],[383,14565],[383,19862],[384,328],[384,2254],[384,2270],
 [384,14565],[384,19862],[385,328],[385,2254],[385,2270],[385,14565],[385,19862],
 [386,328],[386,2224],[386,2262],[386,14523],[386,19848],[387,328],[387,2215],
 [387,2268],[387,14514],[387,19857],[388,202],[388,393],[388,8845],[388,14579],
 [389,328],[389,393],[389,569],[389,12979],[389,14635],[390,328],[390,393],[390,569],
 [390,12979],[390,14635],[391,268],[391,393],[391,10796],[391,10798],[391,11032],
 [391,14753],[392,328],[392,393],[392,569],[392,12979],[392,14635],[394,393],
 [394,14865],[395,393],[395,14866],[396,393],[396,14867],[397,393],[397,14868],
 [398,393],[398,14869],[399,393],[399,14870],[400,393],[400,14871],[401,393],
 [401,14872],[402,393],[402,14873],[403,393],[403,14874],[404,393],[404,14875],
 [405,393],[405,1336],[405,14876],[405,14880],[405,15462],[405,25217],[406,393],
 [406,1377],[406,14877],[406,14879],[406,15503],[406,25258],[407,393],[407,14878],
 [408,393],[408,1377],[408,14877],[408,14879],[408,15503],[408,25258],[409,393],
 [409,1336],[409,14876],[409,14880],[409,15462],[409,25217],[410,393],[410,14881],
 [411,393],[411,14882],[412,393],[412,1625],[412,14883],[412,14896],[412,15751],
 [412,25506],[413,393],[413,1658],[413,14884],[413,14894],[413,15784],[413,25539],
 [414,393],[414,1698],[414,14885],[414,14900],[414,15824],[414,25579],[415,393],
 [415,14886],[416,393],[416,1761],[416,14887],[416,14898],[416,15788],[416,15887],
 [416,25638],[416,25642],[417,393],[417,14888],[418,393],[418,14889],[419,393],
 [419,14890],[420,393],[420,1887],[420,14891],[420,14906],[420,16013],[420,25768],
 [421,393],[421,1915],[421,14892],[421,14907],[421,16041],[421,25796],[422,393],
 [422,14893],[423,393],[423,1658],[423,14884],[423,14894],[423,15784],[423,25539],
 [424,393],[424,14895],[425,393],[425,1625],[425,14883],[425,14896],[425,15751],
 [425,25506],[426,393],[426,2033],[426,14897],[426,14905],[426,16159],[426,25914],
 [427,393],[427,1761],[427,14887],[427,14898],[427,15788],[427,15887],[427,25638],
 [427,25642],[428,393],[428,14899],[429,393],[429,1698],[429,14885],[429,14900],
 [429,15824],[429,25579],[430,393],[430,14901],[431,393],[431,14902],[432,393],
 [432,14903],[433,393],[433,14904],[434,393],[434,2033],[434,14897],[434,14905],
 [434,16159],[434,25914],[435,393],[435,1887],[435,14891],[435,14906],[435,16013],
 [435,25768],[436,393],[436,1915],[436,14892],[436,14907],[436,16041],[436,25796],
 [437,393],[437,2215],[437,14908],[437,14911],[437,16341],[437,26096],[438,393],
 [438,2224],[438,14909],[438,14910],[438,16350],[438,26105],[439,393],[439,2224],
 [439,14909],[439,14910],[439,16350],[439,26105],[440,393],[440,2215],[440,14908],
 [440,14911],[440,16341],[440,26096],[441,393],[441,2254],[441,14912],[441,14916],
 [441,16380],[441,26135],[442,393],[442,2262],[442,14913],[442,14918],[442,16388],
 [442,26143],[443,393],[443,2268],[443,14914],[443,14919],[443,16394],[443,26149],
 [444,393],[444,2270],[444,14915],[444,14917],[444,16396],[444,26151],[445,393],
 [445,2254],[445,14912],[445,14916],[445,16380],[445,26135],[446,393],[446,2270],
 [446,14915],[446,14917],[446,16396],[446,26151],[447,393],[447,2262],[447,14913],
 [447,14918],[447,16388],[447,26143],[448,393],[448,2268],[448,14914],[448,14919],
 [448,16394],[448,26149],[449,202],[449,268],[449,328],[449,8715],[449,8962],
 [449,10854],[449,12747],[450,202],[450,569],[450,9021],[450,16465],[451,202],
 [451,268],[451,328],[451,8715],[451,8962],[451,10854],[451,12747],[452,202],
 [452,569],[452,9021],[452,16465],[453,202],[453,393],[453,8845],[453,14579],
 [454,202],[455,202],[456,202],[457,202],[458,202],[459,202],[460,202],[461,202],
 [462,202],[463,202],[464,202],[465,202],[465,1336],[465,9788],[465,17232],[466,202],
 [466,1377],[466,9829],[466,17273],[467,202],[468,202],[468,1377],[468,9829],
 [468,17273],[469,202],[469,1336],[469,9788],[469,17232],[470,202],[471,202],
 [472,202],[472,1625],[472,10077],[472,17521],[473,202],[473,1658],[473,10110],
 [473,17554],[474,202],[474,1698],[474,10150],[474,17594],[475,202],[476,202],
 [476,1761],[476,10213],[476,17657],[477,202],[478,202],[479,202],[480,202],
 [480,1887],[480,10339],[480,17783],[481,202],[481,1915],[481,10367],[481,17811],
 [482,202],[483,202],[483,1658],[483,10110],[483,17554],[484,202],[485,202],
 [485,1625],[485,10077],[485,17521],[486,202],[486,2033],[486,10485],[486,17929],
 [487,202],[487,1761],[487,10213],[487,17657],[488,202],[489,202],[489,1698],
 [489,10150],[489,17594],[490,202],[491,202],[492,202],[493,202],[494,202],
 [494,2033],[494,10485],[494,17929],[495,202],[495,1887],[495,10339],[495,17783],
 [496,202],[496,1915],[496,10367],[496,17811],[497,202],[497,2215],[497,10667],
 [497,18111],[498,202],[498,2224],[498,10676],[498,18120],[499,202],[499,2224],
 [499,10676],[499,18120],[500,202],[500,2215],[500,10667],[500,18111],[501,202],
 [501,2254],[501,10706],[501,18150],[502,202],[502,2262],[502,10714],[502,18158],
 [503,202],[503,2268],[503,10720],[503,18164],[504,202],[504,2270],[504,10722],
 [504,18166],[505,202],[505,2254],[505,10706],[505,18150],[506,202],[506,2270],
 [506,10722],[506,18166],[507,202],[507,2262],[507,10714],[507,18158],[508,202],
 [508,2268],[508,10720],[508,18164],[509,328],[509,393],[509,569],[509,12979],
 [509,14635],[510,202],[510,268],[510,328],[510,8715],[510,8962],[510,10854],
 [510,12747],[511,328],[511,393],[511,569],[511,12979],[511,14635],[512,328],
 [512,393],[512,569],[512,12979],[512,14635],[513,328],[513,12809],[514,328],
 [514,12810],[515,328],[515,12811],[516,328],[516,12812],[517,328],[517,12813],
 [518,328],[518,12814],[519,328],[519,12815],[520,328],[520,12816],[521,328],
 [521,12817],[522,328],[522,12818],[523,328],[523,12819],[524,328],[524,1336],
 [524,12820],[524,12824],[524,13632],[524,18943],[525,328],[525,1377],[525,12821],
 [525,12823],[525,13673],[525,18984],[526,328],[526,12822],[527,328],[527,1377],
 [527,12821],[527,12823],[527,13673],[527,18984],[528,328],[528,1336],[528,12820],
 [528,12824],[528,13632],[528,18943],[529,328],[529,12825],[530,328],[530,12826],
 [531,328],[531,1625],[531,12827],[531,12840],[531,13921],[531,19232],[532,328],
 [532,1658],[532,12828],[532,12838],[532,13954],[532,19265],[533,328],[533,1698],
 [533,12829],[533,12844],[533,13994],[533,19305],[534,328],[534,12830],[535,328],
 [535,1761],[535,12831],[535,12842],[535,14057],[535,19368],[536,328],[536,12832],
 [537,328],[537,12833],[538,328],[538,12834],[539,328],[539,1887],[539,12835],
 [539,12850],[539,14183],[539,19494],[540,328],[540,1915],[540,12836],[540,12851],
 [540,13967],[540,14211],[540,19509],[540,19522],[541,328],[541,12837],[542,328],
 [542,1658],[542,12828],[542,12838],[542,13954],[542,19265],[543,328],[543,12839],
 [544,328],[544,1625],[544,12827],[544,12840],[544,13921],[544,19232],[545,328],
 [545,2033],[545,12841],[545,12849],[545,13699],[545,14329],[545,19083],[545,19640],
 [546,328],[546,1761],[546,12831],[546,12842],[546,14057],[546,19368],[547,328],
 [547,12843],[548,328],[548,1698],[548,12829],[548,12844],[548,13994],[548,19305],
 [549,328],[549,12845],[550,328],[550,12846],[551,328],[551,12847],[552,328],
 [552,12848],[553,328],[553,2033],[553,12841],[553,12849],[553,13699],[553,14329],
 [553,19083],[553,19640],[554,328],[554,1887],[554,12835],[554,12850],[554,14183],
 [554,19494],[555,328],[555,1915],[555,12836],[555,12851],[555,13967],[555,14211],
 [555,19509],[555,19522],[556,328],[556,2215],[556,2268],[556,14514],[556,19857],
 [557,328],[557,2224],[557,2262],[557,14523],[557,19848],[558,328],[558,2224],
 [558,2262],[558,14523],[558,19848],[559,328],[559,2215],[559,2268],[559,14514],
 [559,19857],[560,328],[560,2254],[560,2270],[560,14565],[560,19862],[561,328],
 [561,2224],[561,2262],[561,14523],[561,19848],[562,328],[562,2215],[562,2268],
 [562,14514],[562,19857],[563,328],[563,2254],[563,2270],[563,14565],[563,19862],
 [564,328],[564,2254],[564,2270],[564,14565],[564,19862],[565,328],[565,2254],
 [565,2270],[565,14565],[565,19862],[566,328],[566,2224],[566,2262],[566,14523],
 [566,19848],[567,328],[567,2215],[567,2268],[567,14514],[567,19857],[568,268],
 [568,569],[568,10973],[568,10974],[568,11031],[568,19886],[570,328],[570,393],
 [570,569],[570,12979],[570,14635],[571,569],[571,19944],[572,569],[572,19945],
 [573,569],[573,19946],[574,569],[574,19947],[575,569],[575,19948],[576,569],
 [576,19949],[577,569],[577,19950],[578,569],[578,19951],[579,569],[579,19952],
 [580,569],[580,19953],[581,569],[581,19954],[582,569],[582,1336],[582,19955],
 [582,19959],[582,20596],[582,23732],[583,569],[583,1377],[583,19956],[583,19958],
 [583,20637],[583,23773],[584,569],[584,19957],[585,569],[585,1377],[585,19956],
 [585,19958],[585,20637],[585,23773],[586,569],[586,1336],[586,19955],[586,19959],
 [586,20596],[586,23732],[587,569],[587,19960],[588,569],[588,19961],[589,569],
 [589,1625],[589,19962],[589,19975],[589,20885],[589,24021],[590,569],[590,1658],
 [590,19963],[590,19973],[590,20918],[590,24054],[591,569],[591,1698],[591,19964],
 [591,19979],[591,20958],[591,24094],[592,569],[592,19965],[593,569],[593,1761],
 [593,19966],[593,19977],[593,20656],[593,21021],[593,23862],[593,24157],[594,569],
 [594,19967],[595,569],[595,19968],[596,569],[596,19969],[597,569],[597,1887],
 [597,19970],[597,19985],[597,21147],[597,24283],[598,569],[598,1915],[598,19971],
 [598,19986],[598,21175],[598,24311],[599,569],[599,19972],[600,569],[600,1658],
 [600,19963],[600,19973],[600,20918],[600,24054],[601,569],[601,19974],[602,569],
 [602,1625],[602,19962],[602,19975],[602,20885],[602,24021],[603,569],[603,2033],
 [603,19976],[603,19984],[603,21293],[603,24429],[604,569],[604,1761],[604,19966],
 [604,19977],[604,20656],[604,21021],[604,23862],[604,24157],[605,569],[605,19978],
 [606,569],[606,1698],[606,19964],[606,19979],[606,20958],[606,24094],[607,569],
 [607,19980],[608,569],[608,19981],[609,569],[609,19982],[610,569],[610,19983],
 [611,569],[611,2033],[611,19976],[611,19984],[611,21293],[611,24429],[612,569],
 [612,1887],[612,19970],[612,19985],[612,21147],[612,24283],[613,569],[613,1915],
 [613,19971],[613,19986],[613,21175],[613,24311],[614,569],[614,2215],[614,19987],
 [614,19990],[614,21475],[614,24611],[615,569],[615,2224],[615,19988],[615,19989],
 [615,21484],[615,24620],[616,569],[616,2224],[616,19988],[616,19989],[616,21484],
 [616,24620],[617,569],[617,2215],[617,19987],[617,19990],[617,21475],[617,24611],
 [618,569],[618,2254],[618,19991],[618,19995],[618,21514],[618,24650],[619,569],
 [619,2262],[619,19992],[619,19997],[619,21522],[619,24658],[620,569],[620,2268],
 [620,19993],[620,19998],[620,21528],[620,24664],[621,569],[621,2270],[621,19994],
 [621,19996],[621,21530],[621,24666],[622,569],[622,2254],[622,19991],[622,19995],
 [622,21514],[622,24650],[623,569],[623,2270],[623,19994],[623,19996],[623,21530],
 [623,24666],[624,569],[624,2262],[624,19992],[624,19997],[624,21522],[624,24658],
 [625,569],[625,2268],[625,19993],[625,19998],[625,21528],[625,24664],[626,268],
 [626,569],[626,10973],[626,10974],[626,11031],[626,19886],[627,268],[627,393],
 [627,10796],[627,10798],[627,11032],[627,14753],[628,268],[628,11033],[629,268],
 [629,11034],[630,268],[630,11035],[631,268],[631,11036],[632,268],[632,11037],
 [633,268],[633,11038],[634,268],[634,11039],[635,268],[635,11040],[636,268],
 [636,11041],[637,268],[637,11042],[638,268],[638,11043],[639,268],[639,1336],
 [639,11044],[639,11048],[639,11741],[639,22192],[640,268],[640,1377],[640,11045],
 [640,11047],[640,11782],[640,22233],[641,268],[641,11046],[642,268],[642,1377],
 [642,11045],[642,11047],[642,11782],[642,22233],[643,268],[643,1336],[643,11044],
 [643,11048],[643,11741],[643,22192],[644,268],[644,11049],[645,268],[645,11050],
 [646,268],[646,1625],[646,11051],[646,11064],[646,12030],[646,22481],[647,268],
 [647,1658],[647,11052],[647,11062],[647,12063],[647,22514],[648,268],[648,1698],
 [648,11053],[648,11068],[648,12103],[648,22554],[649,268],[649,11054],[650,268],
 [650,1761],[650,11055],[650,11066],[650,12166],[650,22617],[651,268],[651,11056],
 [652,268],[652,11057],[653,268],[653,11058],[654,268],[654,1887],[654,11059],
 [654,11074],[654,12292],[654,22743],[655,268],[655,1915],[655,11060],[655,11075],
 [655,12320],[655,22771],[656,268],[656,11061],[657,268],[657,1658],[657,11052],
 [657,11062],[657,12063],[657,22514],[658,268],[658,11063],[659,268],[659,1625],
 [659,11051],[659,11064],[659,12030],[659,22481],[660,268],[660,2033],[660,11065],
 [660,11073],[660,12438],[660,22889],[661,268],[661,1761],[661,11055],[661,11066],
 [661,12166],[661,22617],[662,268],[662,11067],[663,268],[663,1698],[663,11053],
 [663,11068],[663,12103],[663,22554],[664,268],[664,11069],[665,268],[665,11070],
 [666,268],[666,11071],[667,268],[667,11072],[668,268],[668,2033],[668,11065],
 [668,11073],[668,12438],[668,22889],[669,268],[669,1887],[669,11059],[669,11074],
 [669,12292],[669,22743],[670,268],[670,1915],[670,11060],[670,11075],[670,12320],
 [670,22771],[671,268],[671,2215],[671,11076],[671,11079],[671,12620],[671,23071],
 [672,268],[672,2224],[672,11077],[672,11078],[672,12629],[672,23080],[673,268],
 [673,2224],[673,11077],[673,11078],[673,12629],[673,23080],[674,268],[674,2215],
 [674,11076],[674,11079],[674,12620],[674,23071],[675,268],[675,2254],[675,11080],
 [675,11084],[675,12659],[675,23110],[676,268],[676,2262],[676,11081],[676,11086],
 [676,12667],[676,23118],[677,268],[677,2268],[677,11082],[677,11087],[677,12673],
 [677,23124],[678,268],[678,2270],[678,11083],[678,11085],[678,12675],[678,23126],
 [679,268],[679,2254],[679,11080],[679,11084],[679,12659],[679,23110],[680,268],
 [680,2270],[680,11083],[680,11085],[680,12675],[680,23126],[681,268],[681,2262],
 [681,11081],[681,11086],[681,12667],[681,23118],[682,268],[682,2268],[682,11082],
 [682,11087],[682,12673],[682,23124],[683,328],[683,393],[683,569],[683,12979],
 [683,14635],[684,569],[684,19944],[685,569],[685,19945],[686,569],[686,19946],
 [687,569],[687,19947],[688,569],[688,19948],[689,569],[689,19949],[690,569],
 [690,19950],[691,569],[691,19951],[692,569],[692,19952],[693,569],[693,19953],
 [694,569],[694,19954],[695,569],[695,1336],[695,19955],[695,19959],[695,20596],
 [695,23732],[696,569],[696,1377],[696,19956],[696,19958],[696,20637],[696,23773],
 [697,569],[697,19957],[698,569],[698,1377],[698,19956],[698,19958],[698,20637],
 [698,23773],[699,569],[699,1336],[699,19955],[699,19959],[699,20596],[699,23732],
 [700,569],[700,19960],[701,569],[701,19961],[702,569],[702,1625],[702,19962],
 [702,19975],[702,20885],[702,24021],[703,569],[703,1658],[703,19963],[703,19973],
 [703,20918],[703,24054],[704,569],[704,1698],[704,19964],[704,19979],[704,20958],
 [704,24094],[705,569],[705,19965],[706,569],[706,1761],[706,19966],[706,19977],
 [706,20656],[706,21021],[706,23862],[706,24157],[707,569],[707,19967],[708,569],
 [708,19968],[709,569],[709,19969],[710,569],[710,1887],[710,19970],[710,19985],
 [710,21147],[710,24283],[711,569],[711,1915],[711,19971],[711,19986],[711,21175],
 [711,24311],[712,569],[712,19972],[713,569],[713,1658],[713,19963],[713,19973],
 [713,20918],[713,24054],[714,569],[714,19974],[715,569],[715,1625],[715,19962],
 [715,19975],[715,20885],[715,24021],[716,569],[716,2033],[716,19976],[716,19984],
 [716,21293],[716,24429],[717,569],[717,1761],[717,19966],[717,19977],[717,20656],
 [717,21021],[717,23862],[717,24157],[718,569],[718,19978],[719,569],[719,1698],
 [719,19964],[719,19979],[719,20958],[719,24094],[720,569],[720,19980],[721,569],
 [721,19981],[722,569],[722,19982],[723,569],[723,19983],[724,569],[724,2033],
 [724,19976],[724,19984],[724,21293],[724,24429],[725,569],[725,1887],[725,19970],
 [725,19985],[725,21147],[725,24283],[726,569],[726,1915],[726,19971],[726,19986],
 [726,21175],[726,24311],[727,569],[727,2215],[727,19987],[727,19990],[727,21475],
 [727,24611],[728,569],[728,2224],[728,19988],[728,19989],[728,21484],[728,24620],
 [729,569],[729,2224],[729,19988],[729,19989],[729,21484],[729,24620],[730,569],
 [730,2215],[730,19987],[730,19990],[730,21475],[730,24611],[731,569],[731,2254],
 [731,19991],[731,19995],[731,21514],[731,24650],[732,569],[732,2262],[732,19992],
 [732,19997],[732,21522],[732,24658],[733,569],[733,2268],[733,19993],[733,19998],
 [733,21528],[733,24664],[734,569],[734,2270],[734,19994],[734,19996],[734,21530],
 [734,24666],[735,569],[735,2254],[735,19991],[735,19995],[735,21514],[735,24650],
 [736,569],[736,2270],[736,19994],[736,19996],[736,21530],[736,24666],[737,569],
 [737,2262],[737,19992],[737,19997],[737,21522],[737,24658],[738,569],[738,2268],
 [738,19993],[738,19998],[738,21528],[738,24664],[739,393],[739,14865],[740,393],
 [740,14866],[741,393],[741,14867],[742,393],[742,14868],[743,393],[743,14869],
 [744,393],[744,14870],[745,393],[745,14871],[746,393],[746,14872],[747,393],
 [747,14873],[748,393],[748,14874],[749,393],[749,14875],[750,393],[750,1336],
 [750,14876],[750,14880],[750,15462],[750,25217],[751,393],[751,1377],[751,14877],
 [751,14879],[751,15503],[751,25258],[752,393],[752,14878],[753,393],[753,1377],
 [753,14877],[753,14879],[753,15503],[753,25258],[754,393],[754,1336],[754,14876],
 [754,14880],[754,15462],[754,25217],[755,393],[755,14881],[756,393],[756,14882],
 [757,393],[757,1625],[757,14883],[757,14896],[757,15751],[757,25506],[758,393],
 [758,1658],[758,14884],[758,14894],[758,15784],[758,25539],[759,393],[759,1698],
 [759,14885],[759,14900],[759,15824],[759,25579],[760,393],[760,14886],[761,393],
 [761,1761],[761,14887],[761,14898],[761,15788],[761,15887],[761,25638],[761,25642],
 [762,393],[762,14888],[763,393],[763,14889],[764,393],[764,14890],[765,393],
 [765,1887],[765,14891],[765,14906],[765,16013],[765,25768],[766,393],[766,1915],
 [766,14892],[766,14907],[766,16041],[766,25796],[767,393],[767,14893],[768,393],
 [768,1658],[768,14884],[768,14894],[768,15784],[768,25539],[769,393],[769,14895],
 [770,393],[770,1625],[770,14883],[770,14896],[770,15751],[770,25506],[771,393],
 [771,2033],[771,14897],[771,14905],[771,16159],[771,25914],[772,393],[772,1761],
 [772,14887],[772,14898],[772,15788],[772,15887],[772,25638],[772,25642],[773,393],
 [773,14899],[774,393],[774,1698],[774,14885],[774,14900],[774,15824],[774,25579],
 [775,393],[775,14901],[776,393],[776,14902],[777,393],[777,14903],[778,393],
 [778,14904],[779,393],[779,2033],[779,14897],[779,14905],[779,16159],[779,25914],
 [780,393],[780,1887],[780,14891],[780,14906],[780,16013],[780,25768],[781,393],
 [781,1915],[781,14892],[781,14907],[781,16041],[781,25796],[782,393],[782,2215],
 [782,14908],[782,14911],[782,16341],[782,26096],[783,393],[783,2224],[783,14909],
 [783,14910],[783,16350],[783,26105],[784,393],[784,2224],[784,14909],[784,14910],
 [784,16350],[784,26105],[785,393],[785,2215],[785,14908],[785,14911],[785,16341],
 [785,26096],[786,393],[786,2254],[786,14912],[786,14916],[786,16380],[786,26135],
 [787,393],[787,2262],[787,14913],[787,14918],[787,16388],[787,26143],[788,393],
 [788,2268],[788,14914],[788,14919],[788,16394],[788,26149],[789,393],[789,2270],
 [789,14915],[789,14917],[789,16396],[789,26151],[790,393],[790,2254],[790,14912],
 [790,14916],[790,16380],[790,26135],[791,393],[791,2270],[791,14915],[791,14917],
 [791,16396],[791,26151],[792,393],[792,2262],[792,14913],[792,14918],[792,16388],
 [792,26143],[793,393],[793,2268],[793,14914],[793,14919],[793,16394],[793,26149],
 [794,26160],[795,26160],[797,26316],[798,26316],[801,26510],[802,26510],[804,1336],
 [804,26648],[805,1377],[805,26689],[807,1377],[807,26689],[808,1336],[808,26648],
 [811,1625],[811,26937],[812,1658],[812,26970],[813,1698],[813,27010],[815,1761],
 [815,27073],[819,1887],[819,27199],[820,1915],[820,27227],[822,1658],[822,26970],
 [824,1625],[824,26937],[825,2033],[825,27345],[826,1761],[826,27073],[828,1698],
 [828,27010],[833,2033],[833,27345],[834,1887],[834,27199],[835,1915],[835,27227],
 [836,2215],[836,27527],[837,2224],[837,27536],[838,2224],[838,27536],[839,2215],
 [839,27527],[840,2254],[840,27566],[841,2262],[841,27574],[842,2268],[842,27580],
 [843,2270],[843,27582],[844,2254],[844,27566],[845,2270],[845,27582],[846,2262],
 [846,27574],[847,2268],[847,27580],[848,26160],[849,27643],[850,27643],[853,27841],
 [854,27841],[857,1336],[857,28026],[858,1377],[858,28067],[860,1377],[860,28067],
 [861,1336],[861,28026],[864,1625],[864,28315],[865,1658],[865,28348],[866,1698],
 [866,28388],[868,1761],[868,28451],[872,1887],[872,28577],[873,1915],[873,28605],
 [875,1658],[875,28348],[877,1625],[877,28315],[878,2033],[878,28723],[879,1761],
 [879,28451],[881,1698],[881,28388],[886,2033],[886,28723],[887,1887],[887,28577],
 [888,1915],[888,28605],[889,2215],[889,28905],[890,2224],[890,28914],[891,2224],
 [891,28914],[892,2215],[892,28905],[893,2254],[893,28944],[894,2262],[894,28952],
 [895,2268],[895,28958],[896,2270],[896,28960],[897,2254],[897,28944],[898,2270],
 [898,28960],[899,2262],[899,28952],[900,2268],[900,28958],[901,28970],[903,28970],
 [905,29168],[907,29168],[909,1336],[909,29352],[910,1377],[910,29393],[912,1377],
 [912,29393],[913,1336],[913,29352],[916,1625],[916,29641],[917,1658],[917,29674],
 [918,1698],[918,29714],[920,1761],[920,29777],[924,1887],[924,29903],[925,1915],
 [925,29931],[927,1658],[927,29674],[929,1625],[929,29641],[930,2033],[930,30049],
 [931,1761],[931,29777],[933,1698],[933,29714],[938,2033],[938,30049],[939,1887],
 [939,29903],[940,1915],[940,29931],[941,2215],[941,30231],[942,2224],[942,30240],
 [943,2224],[943,30240],[944,2215],[944,30231],[945,2254],[945,30270],[946,2262],
 [946,30278],[947,2268],[947,30284],[948,2270],[948,30286],[949,2254],[949,30270],
 [950,2270],[950,30286],[951,2262],[951,30278],[952,2268],[952,30284],[953,27643],
 [954,28970],[955,30394],[956,30394],[960,1336],[960,30627],[961,1377],[961,30668],
 [963,1377],[963,30668],[964,1336],[964,30627],[967,1625],[967,30916],[968,1658],
 [968,30949],[969,1698],[969,30989],[971,1761],[971,31052],[975,1887],[975,31178],
 [976,1915],[976,31206],[978,1658],[978,30949],[980,1625],[980,30916],[981,2033],
 [981,31324],[982,1761],[982,31052],[984,1698],[984,30989],[989,2033],[989,31324],
 [990,1887],[990,31178],[991,1915],[991,31206],[992,2215],[992,31506],[993,2224],
 [993,31515],[994,2224],[994,31515],[995,2215],[995,31506],[996,2254],[996,31545],
 [997,2262],[997,31553],[998,2268],[998,31559],[999,2270],[999,31561],[1000,2254],
 [1000,31545],[1001,2270],[1001,31561],[1002,2262],[1002,31553],[1003,2268],[1003,31559],
 [1004,26316],[1005,31620],[1007,31620],[1010,1336],[1010,31852],[1011,1377],[1011,31893],
 [1013,1377],[1013,31893],[1014,1336],[1014,31852],[1017,1625],[1017,32141],[1018,1658],
 [1018,32174],[1019,1698],[1019,32214],[1021,1761],[1021,32277],[1025,1887],[1025,32403],
 [1026,1915],[1026,32431],[1028,1658],[1028,32174],[1030,1625],[1030,32141],[1031,2033],
 [1031,32549],[1032,1761],[1032,32277],[1034,1698],[1034,32214],[1039,2033],[1039,32549],
 [1040,1887],[1040,32403],[1041,1915],[1041,32431],[1042,2215],[1042,32731],[1043,2224],
 [1043,32740],[1044,2224],[1044,32740],[1045,2215],[1045,32731],[1046,2254],[1046,32770],
 [1047,2262],[1047,32778],[1048,2268],[1048,32784],[1049,2270],[1049,32786],[1050,2254],
 [1050,32770],[1051,2270],[1051,32786],[1052,2262],[1052,32778],[1053,2268],[1053,32784],
 [1054,32797],[1057,32797],[1059,1336],[1059,33028],[1060,1377],[1060,33069],[1062,1377],
 [1062,33069],[1063,1336],[1063,33028],[1066,1625],[1066,33317],[1067,1658],[1067,33350],
 [1068,1698],[1068,33390],[1070,1761],[1070,33453],[1074,1887],[1074,33579],[1075,1915],
 [1075,33607],[1077,1658],[1077,33350],[1079,1625],[1079,33317],[1080,2033],[1080,33725],
 [1081,1761],[1081,33453],[1083,1698],[1083,33390],[1088,2033],[1088,33725],[1089,1887],
 [1089,33579],[1090,1915],[1090,33607],[1091,2215],[1091,33907],[1092,2224],[1092,33916],
 [1093,2224],[1093,33916],[1094,2215],[1094,33907],[1095,2254],[1095,33946],[1096,2262],
 [1096,33954],[1097,2268],[1097,33960],[1098,2270],[1098,33962],[1099,2254],[1099,33946],
 [1100,2270],[1100,33962],[1101,2262],[1101,33954],[1102,2268],[1102,33960],[1103,30394],
 [1104,31620],[1105,32797],[1107,1336],[1107,34156],[1108,1377],[1108,34197],[1110,1377],
 [1110,34197],[1111,1336],[1111,34156],[1114,1625],[1114,34445],[1115,1658],[1115,34478],
 [1116,1698],[1116,34518],[1118,1761],[1118,34581],[1122,1887],[1122,34707],[1123,1915],
 [1123,34735],[1125,1658],[1125,34478],[1127,1625],[1127,34445],[1128,2033],[1128,34853],
 [1129,1761],[1129,34581],[1131,1698],[1131,34518],[1136,2033],[1136,34853],[1137,1887],
 [1137,34707],[1138,1915],[1138,34735],[1139,2215],[1139,35035],[1140,2224],[1140,35044],
 [1141,2224],[1141,35044],[1142,2215],[1142,35035],[1143,2254],[1143,35074],[1144,2262],
 [1144,35082],[1145,2268],[1145,35088],[1146,2270],[1146,35090],[1147,2254],[1147,35074],
 [1148,2270],[1148,35090],[1149,2262],[1149,35082],[1150,2268],[1150,35088],[1151,27841],
 [1152,29168],[1154,1336],[1154,35237],[1155,1377],[1155,35278],[1157,1377],[1157,35278],
 [1158,1336],[1158,35237],[1161,1625],[1161,35526],[1162,1658],[1162,35559],[1163,1698],
 [1163,35599],[1165,1761],[1165,35662],[1169,1887],[1169,35788],[1170,1915],[1170,35816],
 [1172,1658],[1172,35559],[1174,1625],[1174,35526],[1175,2033],[1175,35934],[1176,1761],
 [1176,35662],[1178,1698],[1178,35599],[1183,2033],[1183,35934],[1184,1887],[1184,35788],
 [1185,1915],[1185,35816],[1186,2215],[1186,36116],[1187,2224],[1187,36125],[1188,2224],
 [1188,36125],[1189,2215],[1189,36116],[1190,2254],[1190,36155],[1191,2262],[1191,36163],
 [1192,2268],[1192,36169],[1193,2270],[1193,36171],[1194,2254],[1194,36155],[1195,2270],
 [1195,36171],[1196,2262],[1196,36163],[1197,2268],[1197,36169],[1198,26510],[1200,1336],
 [1200,36272],[1201,1377],[1201,36313],[1203,1377],[1203,36313],[1204,1336],[1204,36272],
 [1207,1625],[1207,36561],[1208,1658],[1208,36594],[1209,1698],[1209,36634],[1211,1761],
 [1211,36697],[1215,1887],[1215,36823],[1216,1915],[1216,36851],[1218,1658],[1218,36594],
 [1220,1625],[1220,36561],[1221,2033],[1221,36969],[1222,1761],[1222,36697],[1224,1698],
 [1224,36634],[1229,2033],[1229,36969],[1230,1887],[1230,36823],[1231,1915],[1231,36851],
 [1232,2215],[1232,37151],[1233,2224],[1233,37160],[1234,2224],[1234,37160],[1235,2215],
 [1235,37151],[1236,2254],[1236,37190],[1237,2262],[1237,37198],[1238,2268],[1238,37204],
 [1239,2270],[1239,37206],[1240,2254],[1240,37190],[1241,2270],[1241,37206],[1242,2262],
 [1242,37198],[1243,2268],[1243,37204],[1245,1336],[1245,37262],[1246,1377],[1246,37303],
 [1248,1377],[1248,37303],[1249,1336],[1249,37262],[1252,1625],[1252,37551],[1253,1658],
 [1253,37584],[1254,1698],[1254,37624],[1256,1761],[1256,37687],[1260,1887],[1260,37813],
 [1261,1915],[1261,37841],[1263,1658],[1263,37584],[1265,1625],[1265,37551],[1266,2033],
 [1266,37959],[1267,1761],[1267,37687],[1269,1698],[1269,37624],[1274,2033],[1274,37959],
 [1275,1887],[1275,37813],[1276,1915],[1276,37841],[1277,2215],[1277,38141],[1278,2224],
 [1278,38150],[1279,2224],[1279,38150],[1280,2215],[1280,38141],[1281,2254],[1281,38180],
 [1282,2262],[1282,38188],[1283,2268],[1283,38194],[1284,2270],[1284,38196],[1285,2254],
 [1285,38180],[1286,2270],[1286,38196],[1287,2262],[1287,38188],[1288,2268],[1288,38194],
 [1297,1658],[1297,38530],[1304,1887],[1304,38759],[1305,1915],[1305,38787],[1307,1658],
 [1307,38530],[1310,2033],[1310,38905],[1318,2033],[1318,38905],[1319,1887],[1319,38759],
 [1320,1915],[1320,38787],[1321,2215],[1321,39087],[1322,2224],[1322,39096],[1323,2224],
 [1323,39096],[1324,2215],[1324,39087],[1325,2254],[1325,39126],[1326,2262],[1326,39134],
 [1327,2268],[1327,39140],[1328,2270],[1328,39142],[1329,2254],[1329,39126],[1330,2270],
 [1330,39142],[1331,2262],[1331,39134],[1332,2268],[1332,39140],[1342,1336],[1342,39279],
 [1344,1336],[1344,39281,42761],[1344,39283,42761],[1344,39559,42761],[1344,42761],
 [1345,1336],[1345,39282],[1346,1336],[1346,42761],[1347,1336],[1347,1887],[1347,39284],
 [1347,39299],[1347,39662],[1347,42864],[1348,1336],[1348,1915],[1348,39285],[1348,39300],
 [1348,39690],[1348,42892],[1351,1336],[1351,39288],[1353,1336],[1353,2033],[1353,39290],
 [1353,39298],[1353,39808],[1353,43010],[1355,1336],[1355,39292],[1357,1336],[1357,39294],
 [1358,1336],[1358,39295,43104],[1358,39297,43104],[1358,39902,43104],[1358,43104],
 [1359,1336],[1359,39296],[1360,1336],[1360,43104],[1361,1336],[1361,2033],[1361,39290],
 [1361,39298],[1361,39808],[1361,43010],[1362,1336],[1362,1887],[1362,39284],[1362,39299],
 [1362,39662],[1362,42864],[1363,1336],[1363,1915],[1363,39285],[1363,39300],[1363,39690],
 [1363,42892],[1364,1336],[1364,2215],[1364,39301],[1364,39304],[1364,39990],[1364,43192],
 [1365,1336],[1365,2224],[1365,39302],[1365,39303],[1365,39999],[1365,43201],[1366,1336],
 [1366,2224],[1366,39302],[1366,39303],[1366,39999],[1366,43201],[1367,1336],[1367,2215],
 [1367,39301],[1367,39304],[1367,39990],[1367,43192],[1368,1336],[1368,2254],[1368,39305],
 [1368,39309],[1368,40029],[1368,43231],[1369,1336],[1369,2262],[1369,39306],[1369,39311],
 [1369,40037],[1369,43239],[1370,1336],[1370,2268],[1370,39307],[1370,39312],[1370,40043],
 [1370,43245],[1371,1336],[1371,2270],[1371,39308],[1371,39310],[1371,40045],[1371,43247],
 [1372,1336],[1372,2254],[1372,39305],[1372,39309],[1372,40029],[1372,43231],[1373,1336],
 [1373,2270],[1373,39308],[1373,39310],[1373,40045],[1373,43247],[1374,1336],[1374,2262],
 [1374,39306],[1374,39311],[1374,40037],[1374,43239],[1375,1336],[1375,2268],[1375,39307],
 [1375,39312],[1375,40043],[1375,43245],[1379,1377],[1379,40096],[1380,1377],[1380,40097],
 [1384,1377],[1384,40101],[1386,1377],[1386,1798],[1386,40103],[1386,40119],[1386,40434],
 [1386,42034],[1389,1377],[1389,1887],[1389,1915],[1389,40106,42109],[1389,40107,42109],
 [1389,40121,40824],[1389,40122,40824],[1389,40509,42109],[1389,40523,40824],
 [1389,40524,40824],[1389,40550,40824],[1389,40551,40824],[1389,40824],[1389,42109],
 [1389,42123,42109],[1389,42124,42109],[1389,42150,42109],[1389,42151,42109],
 [1389,42424,40824],[1389,48754,42109],[1389,48755,42109],[1389,49028,40824],
 [1389,49379,40824],[1390,1377],[1390,1887],[1390,1915],[1390,40824],[1390,42109],
 [1391,1377],[1391,40108],[1393,1377],[1393,1984],[1393,40110],[1393,40116],[1393,40620],
 [1393,42220],[1395,1377],[1395,2033],[1395,40112],[1395,40120],[1395,40669],[1395,42269],
 [1397,1377],[1397,40114],[1399,1377],[1399,1984],[1399,40110],[1399,40116],[1399,40620],
 [1399,42220],[1402,1377],[1402,1798],[1402,40103],[1402,40119],[1402,40434],[1402,42034],
 [1403,1377],[1403,2033],[1403,40112],[1403,40120],[1403,40669],[1403,42269],[1404,1377],
 [1404,1887],[1404,1915],[1404,40824],[1404,42109],[1405,1377],[1405,1887],[1405,1915],
 [1405,40824],[1405,42109],[1406,1377],[1406,2215],[1406,2224],[1406,40123,42449],
 [1406,40124,42449],[1406,40125,40870],[1406,40126,40870],[1406,40849,42449],
 [1406,40850,40870],[1406,40851,40870],[1406,40860,40870],[1406,40861,40870],[1406,40870],
 [1406,42449],[1406,42450,42449],[1406,42451,42449],[1406,42460,42449],[1406,42461,42449],
 [1406,42470,40870],[1406,52175,42449],[1406,52176,42449],[1406,52185,40870],
 [1406,52230,40870],[1407,1377],[1407,2215],[1407,2224],[1407,40870],[1407,42449],
 [1408,1377],[1408,2215],[1408,2224],[1408,40870],[1408,42449],[1409,1377],[1409,2215],
 [1409,2224],[1409,40870],[1409,42449],[1410,1377],[1410,2254],[1410,40127],[1410,40131],
 [1410,40890],[1410,42490],[1411,1377],[1411,2262],[1411,2268],[1411,40128,42494],
 [1411,40129,42494],[1411,40133,40914],[1411,40134,40914],[1411,40894,42494],
 [1411,40898,40914],[1411,40899,40914],[1411,40903,40914],[1411,40904,40914],[1411,40914],
 [1411,42494],[1411,42498,42494],[1411,42499,42494],[1411,42503,42494],[1411,42504,42494],
 [1411,42514,40914],[1411,52363,42494],[1411,52364,42494],[1411,52374,40914],
 [1411,52384,40914],[1412,1377],[1412,2262],[1412,2268],[1412,40914],[1412,42494],
 [1413,1377],[1413,2270],[1413,40130],[1413,40132],[1413,40906],[1413,42506],[1414,1377],
 [1414,2254],[1414,40127],[1414,40131],[1414,40890],[1414,42490],[1415,1377],[1415,2270],
 [1415,40130],[1415,40132],[1415,40906],[1415,42506],[1416,1377],[1416,2262],[1416,2268],
 [1416,40914],[1416,42494],[1417,1377],[1417,2262],[1417,2268],[1417,40914],[1417,42494],
 [1426,1761],[1426,41217],[1427,41239],[1428,41239],[1430,1887],[1430,41343],[1431,1915],
 [1431,41371],[1436,2033],[1436,41489],[1437,1761],[1437,41217],[1444,2033],[1444,41489],
 [1445,1887],[1445,41343],[1446,1915],[1446,41371],[1447,2215],[1447,41671],[1448,2224],
 [1448,41680],[1449,2224],[1449,41680],[1450,2215],[1450,41671],[1451,2254],[1451,41710],
 [1452,2262],[1452,41718],[1453,2268],[1453,41724],[1454,2270],[1454,41726],[1455,2254],
 [1455,41710],[1456,2270],[1456,41726],[1457,2262],[1457,41718],[1458,2268],[1458,41724],
 [1460,1377],[1460,40096],[1461,1377],[1461,40097],[1465,1377],[1465,40101],[1467,1377],
 [1467,1798],[1467,40103],[1467,40119],[1467,40434],[1467,42034],[1470,1377],[1470,1887],
 [1470,1915],[1470,40824],[1470,42109],[1471,1377],[1471,1887],[1471,1915],[1471,40824],
 [1471,42109],[1472,1377],[1472,40108],[1474,1377],[1474,1984],[1474,40110],[1474,40116],
 [1474,40620],[1474,42220],[1476,1377],[1476,2033],[1476,40112],[1476,40120],[1476,40669],
 [1476,42269],[1478,1377],[1478,40114],[1480,1377],[1480,1984],[1480,40110],[1480,40116],
 [1480,40620],[1480,42220],[1483,1377],[1483,1798],[1483,40103],[1483,40119],[1483,40434],
 [1483,42034],[1484,1377],[1484,2033],[1484,40112],[1484,40120],[1484,40669],[1484,42269],
 [1485,1377],[1485,1887],[1485,1915],[1485,40824],[1485,42109],[1486,1377],[1486,1887],
 [1486,1915],[1486,40824],[1486,42109],[1487,1377],[1487,2215],[1487,2224],[1487,40870],
 [1487,42449],[1488,1377],[1488,2215],[1488,2224],[1488,40870],[1488,42449],[1489,1377],
 [1489,2215],[1489,2224],[1489,40870],[1489,42449],[1490,1377],[1490,2215],[1490,2224],
 [1490,40870],[1490,42449],[1491,1377],[1491,2254],[1491,40127],[1491,40131],[1491,40890],
 [1491,42490],[1492,1377],[1492,2262],[1492,2268],[1492,40914],[1492,42494],[1493,1377],
 [1493,2262],[1493,2268],[1493,40914],[1493,42494],[1494,1377],[1494,2270],[1494,40130],
 [1494,40132],[1494,40906],[1494,42506],[1495,1377],[1495,2254],[1495,40127],[1495,40131],
 [1495,40890],[1495,42490],[1496,1377],[1496,2270],[1496,40130],[1496,40132],[1496,40906],
 [1496,42506],[1497,1377],[1497,2262],[1497,2268],[1497,40914],[1497,42494],[1498,1377],
 [1498,2262],[1498,2268],[1498,40914],[1498,42494],[1504,1336],[1504,39279],[1506,1336],
 [1506,42761],[1507,1336],[1507,39282],[1508,1336],[1508,42761],[1509,1336],[1509,1887],
 [1509,39284],[1509,39299],[1509,39662],[1509,42864],[1510,1336],[1510,1915],[1510,39285],
 [1510,39300],[1510,39690],[1510,42892],[1513,1336],[1513,39288],[1515,1336],[1515,2033],
 [1515,39290],[1515,39298],[1515,39808],[1515,43010],[1517,1336],[1517,39292],
 [1519,1336],[1519,39294],[1520,1336],[1520,43104],[1521,1336],[1521,39296],[1522,1336],
 [1522,43104],[1523,1336],[1523,2033],[1523,39290],[1523,39298],[1523,39808],[1523,43010],
 [1524,1336],[1524,1887],[1524,39284],[1524,39299],[1524,39662],[1524,42864],[1525,1336],
 [1525,1915],[1525,39285],[1525,39300],[1525,39690],[1525,42892],[1526,1336],[1526,2215],
 [1526,39301],[1526,39304],[1526,39990],[1526,43192],[1527,1336],[1527,2224],[1527,39302],
 [1527,39303],[1527,39999],[1527,43201],[1528,1336],[1528,2224],[1528,39302],[1528,39303],
 [1528,39999],[1528,43201],[1529,1336],[1529,2215],[1529,39301],[1529,39304],[1529,39990],
 [1529,43192],[1530,1336],[1530,2254],[1530,39305],[1530,39309],[1530,40029],[1530,43231],
 [1531,1336],[1531,2262],[1531,39306],[1531,39311],[1531,40037],[1531,43239],[1532,1336],
 [1532,2268],[1532,39307],[1532,39312],[1532,40043],[1532,43245],[1533,1336],[1533,2270],
 [1533,39308],[1533,39310],[1533,40045],[1533,43247],[1534,1336],[1534,2254],[1534,39305],
 [1534,39309],[1534,40029],[1534,43231],[1535,1336],[1535,2270],[1535,39308],[1535,39310],
 [1535,40045],[1535,43247],[1536,1336],[1536,2262],[1536,39306],[1536,39311],[1536,40037],
 [1536,43239],[1537,1336],[1537,2268],[1537,39307],[1537,39312],[1537,40043],[1537,43245],
 [1539,1625],[1539,43305,43685],[1539,43308,43685],[1539,43685],[1539,44981,43685],
 [1541,1698],[1541,43378],[1543,1761],[1543,43441],[1545,3756],[1547,1887],[1547,43567],
 [1548,1915],[1548,43595],[1552,1625],[1552,43685],[1553,2033],[1553,43713],[1554,1761],
 [1554,43441],[1555,1625],[1555,43685],[1556,1698],[1556,43378],[1561,2033],[1561,43713],
 [1562,1887],[1562,43567],[1563,1915],[1563,43595],[1564,2215],[1564,43895],[1565,2224],
 [1565,43904],[1566,2224],[1566,43904],[1567,2215],[1567,43895],[1568,2254],[1568,43934],
 [1569,2262],[1569,43942],[1570,2268],[1570,43948],[1571,2270],[1571,43950],[1572,2254],
 [1572,43934],[1573,2270],[1573,43950],[1574,2262],[1574,43942],[1575,2268],[1575,43948],
 [1576,1625],[1576,43971],[1577,1583],[1577,1658],[1577,44000],[1577,44004],[1577,44193],
 [1577,45418],[1578,1698],[1578,44030],[1578,44044,44030],[1578,44077,44030],
 [1578,45863,44030],[1579,1698],[1579,44030],[1580,1761],[1580,44107,44394],
 [1580,44108,44394],[1580,44394],[1580,47204,44394],[1584,1887],[1584,44233],[1585,1915],
 [1585,44261],[1587,1583],[1587,1658],[1587,44000],[1587,44004],[1587,44193],[1587,45418],
 [1589,1625],[1589,43971],[1590,2033],[1590,44379],[1591,1761],[1591,44394],[1592,1761],
 [1592,44394],[1593,1698],[1593,44030],[1596,8032],[1598,2033],[1598,44379],[1599,1887],
 [1599,44233],[1600,1915],[1600,44261],[1601,2215],[1601,44561],[1602,2224],[1602,44570],
 [1603,2224],[1603,44570],[1604,2215],[1604,44561],[1605,2254],[1605,44600],[1606,2262],
 [1606,44608],[1607,2268],[1607,44614],[1608,2270],[1608,44616],[1609,2254],[1609,44600],
 [1610,2270],[1610,44616],[1611,2262],[1611,44608],[1612,2268],[1612,44614],[1615,1625],
 [1615,44703],[1617,1625],[1617,44766],[1618,1625],[1618,44795,48035],[1618,44796,48035],
 [1618,44955,48035],[1618,48035],[1619,1625],[1619,44825],[1620,1625],[1620,1887],
 [1620,44853],[1620,44863],[1620,44988],[1620,48852],[1621,1625],[1621,1915],[1621,44880],
 [1621,44891],[1621,44989],[1621,49204],[1624,1625],[1624,48035],[1626,1625],[1626,2033],
 [1626,44979],[1626,44987],[1626,45009],[1626,50378],[1628,1625],[1628,43685],
 [1632,1625],[1632,44985],[1633,1625],[1633,44986],[1634,1625],[1634,2033],[1634,44979],
 [1634,44987],[1634,45009],[1634,50378],[1635,1625],[1635,1887],[1635,44853],[1635,44863],
 [1635,44988],[1635,48852],[1636,1625],[1636,1915],[1636,44880],[1636,44891],[1636,44989],
 [1636,49204],[1637,1625],[1637,2215],[1637,44990],[1637,44993],[1637,45191],[1637,50560],
 [1638,1625],[1638,2224],[1638,44991],[1638,44992],[1638,45200],[1638,50569],[1639,1625],
 [1639,2224],[1639,44991],[1639,44992],[1639,45200],[1639,50569],[1640,1625],[1640,2215],
 [1640,44990],[1640,44993],[1640,45191],[1640,50560],[1641,1625],[1641,2254],[1641,44994],
 [1641,44998],[1641,45230],[1641,50599],[1642,1625],[1642,2262],[1642,44995],[1642,45000],
 [1642,45238],[1642,50607],[1643,1625],[1643,2268],[1643,44996],[1643,45001],[1643,45244],
 [1643,50613],[1644,1625],[1644,2270],[1644,44997],[1644,44999],[1644,45246],[1644,50615],
 [1645,1625],[1645,2254],[1645,44994],[1645,44998],[1645,45230],[1645,50599],[1646,1625],
 [1646,2270],[1646,44997],[1646,44999],[1646,45246],[1646,50615],[1647,1625],[1647,2262],
 [1647,44995],[1647,45000],[1647,45238],[1647,50607],[1648,1625],[1648,2268],[1648,44996],
 [1648,45001],[1648,45244],[1648,50613],[1653,1658],[1653,1823],[1653,45389],[1653,45394],
 [1653,45529],[1653,48014],[1654,1583],[1654,1658],[1654,44000],[1654,44004],[1654,44193],
 [1654,45418],[1655,1658],[1655,1887],[1655,2033],[1655,45446,48796],[1655,45449,48796],
 [1655,45457,45745],[1655,45458,45745],[1655,45527,48796],[1655,45535,45745],
 [1655,45536,45745],[1655,45604,45745],[1655,45605,45745],[1655,45745],[1655,48796],
 [1655,48804,48796],[1655,48805,48796],[1655,48873,48796],[1655,48874,48796],
 [1655,49014,45745],[1655,49849,48796],[1655,49850,48796],[1655,49990,45745],
 [1655,50750,45745],[1656,1658],[1656,1915],[1656,45473],[1656,45486],[1656,45537],
 [1656,49157],[1661,1658],[1661,1887],[1661,2033],[1661,45745],[1661,48796],[1663,1658],
 [1663,1823],[1663,45389],[1663,45394],[1663,45529],[1663,48014],[1665,1658],[1665,45531],
 [1666,1658],[1666,45532],[1667,1658],[1667,45533],[1668,1658],[1668,45534],[1669,1658],
 [1669,1887],[1669,2033],[1669,45745],[1669,48796],[1670,1658],[1670,1887],[1670,2033],
 [1670,45745],[1670,48796],[1671,1658],[1671,1915],[1671,45473],[1671,45486],[1671,45537],
 [1671,49157],[1672,1658],[1672,2215],[1672,45538],[1672,45541],[1672,45786],[1672,50031],
 [1673,1658],[1673,2224],[1673,2254],[1673,45539,50046],[1673,45540,45806],
 [1673,45542,45806],[1673,45546,50046],[1673,45795,45806],[1673,45797,45806],
 [1673,45801,50046],[1673,45806],[1673,45810,45806],[1673,45825,45806],[1673,50040,50046],
 [1673,50042,50046],[1673,50046],[1673,50051,45806],[1673,50055,50046],[1673,50070,50046],
 [1673,52231,45806],[1673,52235,50046],[1673,52250,50046],[1673,52286,45806],[1674,1658],
 [1674,2224],[1674,2254],[1674,45806],[1674,50046],[1675,1658],[1675,2215],[1675,45538],
 [1675,45541],[1675,45786],[1675,50031],[1676,1658],[1676,2224],[1676,2254],[1676,45806],
 [1676,50046],[1677,1658],[1677,2262],[1677,2270],[1677,45543,50075],[1677,45545,50075],
 [1677,45547,45847],[1677,45548,45847],[1677,45830,50075],[1677,45832,45847],
 [1677,45833,45847],[1677,45841,45847],[1677,45842,45847],[1677,45847],[1677,50075],
 [1677,50077,50075],[1677,50078,50075],[1677,50086,50075],[1677,50087,50075],
 [1677,50092,45847],[1677,52366,50075],[1677,52367,50075],[1677,52372,45847],
 [1677,52388,45847],[1678,1658],[1678,2268],[1678,45544],[1678,45549],[1678,45839],
 [1678,50084],[1679,1658],[1679,2262],[1679,2270],[1679,45847],[1679,50075],[1680,1658],
 [1680,2224],[1680,2254],[1680,45806],[1680,50046],[1681,1658],[1681,2262],[1681,2270],
 [1681,45847],[1681,50075],[1682,1658],[1682,2262],[1682,2270],[1682,45847],[1682,50075],
 [1683,1658],[1683,2268],[1683,45544],[1683,45549],[1683,45839],[1683,50084],[1684,1698],
 [1684,44030],[1686,1698],[1686,45926],[1687,1698],[1687,45956],[1688,1698],
 [1688,45980,48445],[1688,45985,48445],[1688,46115,48445],[1688,48445],[1689,1698],
 [1689,1887],[1689,46013],[1689,46019],[1689,46226],[1689,48934],[1690,1698],[1690,1915],
 [1690,46040],[1690,46047],[1690,46227],[1690,49286],[1693,1698],[1693,48445],
 [1695,1698],[1695,2033],[1695,46160],[1695,46165],[1695,46225],[1695,50669],[1697,1698],
 [1697,46201],[1699,1698],[1699,46221,46241],[1699,46223,46241],[1699,46241],
 [1699,51256,46241],[1700,1698],[1700,46222],[1701,1698],[1701,46241],[1702,1698],
 [1702,46224],[1703,1698],[1703,2033],[1703,46160],[1703,46165],[1703,46225],[1703,50669],
 [1704,1698],[1704,1887],[1704,46013],[1704,46019],[1704,46226],[1704,48934],[1705,1698],
 [1705,1915],[1705,46040],[1705,46047],[1705,46227],[1705,49286],[1706,1698],[1706,2215],
 [1706,46228],[1706,46231],[1706,46347],[1706,51362],[1707,1698],[1707,2224],[1707,46229],
 [1707,46230],[1707,46356],[1707,51371],[1708,1698],[1708,2224],[1708,46229],[1708,46230],
 [1708,46356],[1708,51371],[1709,1698],[1709,2215],[1709,46228],[1709,46231],[1709,46347],
 [1709,51362],[1710,1698],[1710,2254],[1710,46232],[1710,46236],[1710,46386],[1710,51401],
 [1711,1698],[1711,2262],[1711,46233],[1711,46238],[1711,46394],[1711,51409],[1712,1698],
 [1712,2268],[1712,46234],[1712,46239],[1712,46400],[1712,51415],[1713,1698],[1713,2270],
 [1713,46235],[1713,46237],[1713,46402],[1713,51417],[1714,1698],[1714,2254],[1714,46232],
 [1714,46236],[1714,46386],[1714,51401],[1715,1698],[1715,2270],[1715,46235],[1715,46237],
 [1715,46402],[1715,51417],[1716,1698],[1716,2262],[1716,46233],[1716,46238],[1716,46394],
 [1716,51409],[1717,1698],[1717,2268],[1717,46234],[1717,46239],[1717,46400],[1717,51415],
 [1718,1761],[1718,46421],[1722,1887],[1722,46547],[1723,1915],[1723,46575],[1727,1625],
 [1727,44703],[1728,2033],[1728,46693],[1729,1761],[1729,46421],[1731,1698],[1731,44030],
 [1732,8168],[1736,2033],[1736,46693],[1737,1887],[1737,46547],[1738,1915],[1738,46575],
 [1739,2215],[1739,46875],[1740,2224],[1740,46884],[1741,2224],[1741,46884],[1742,2215],
 [1742,46875],[1743,2254],[1743,46914],[1744,2262],[1744,46922],[1745,2268],[1745,46928],
 [1746,2270],[1746,46930],[1747,2254],[1747,46914],[1748,2270],[1748,46930],[1749,2262],
 [1749,46922],[1750,2268],[1750,46928],[1751,1761],[1751,46948],[1752,1761],[1752,46978],
 [1753,1761],[1753,47007],[1754,1761],[1754,1887],[1754,47035],[1754,47043],[1754,47211],
 [1754,48895],[1755,1761],[1755,1915],[1755,2033],[1755,47061,49217],[1755,47062,49217],
 [1755,47069,47331],[1755,47071,47331],[1755,47182,49217],[1755,47189,47331],
 [1755,47191,47331],[1755,47210,47331],[1755,47212,47331],[1755,47331],[1755,49217],
 [1755,49224,49217],[1755,49226,49217],[1755,49245,49217],[1755,49247,49217],
 [1755,49366,47331],[1755,50630,49217],[1755,50632,49217],[1755,50751,47331],
 [1755,50961,47331],[1758,1761],[1758,47137],[1760,1761],[1760,1915],[1760,2033],
 [1760,47331],[1760,49217],[1762,1761],[1762,44394],[1764,1761],[1764,47206,47266],
 [1764,47209,47266],[1764,47266],[1764,50896,47266],[1765,1761],[1765,47207],[1766,1761],
 [1766,47208],[1767,1761],[1767,47266],[1768,1761],[1768,1915],[1768,2033],[1768,47331],
 [1768,49217],[1769,1761],[1769,1887],[1769,47035],[1769,47043],[1769,47211],[1769,48895],
 [1770,1761],[1770,1915],[1770,2033],[1770,47331],[1770,49217],[1771,1761],[1771,2215],
 [1771,2254],[1771,47213,51006],[1771,47216,47399],[1771,47217,47399],[1771,47221,51006],
 [1771,47371,47399],[1771,47372,47399],[1771,47376,51006],[1771,47399],[1771,47403,47399],
 [1771,47410,47399],[1771,51001,51006],[1771,51002,51006],[1771,51006],[1771,51029,47399],
 [1771,51033,51006],[1771,51040,51006],[1771,52194,47399],[1771,52198,51006],
 [1771,52205,51006],[1771,52314,47399],[1772,1761],[1772,2224],[1772,47214],[1772,47215],
 [1772,47380],[1772,51010],[1773,1761],[1773,2224],[1773,47214],[1773,47215],[1773,47380],
 [1773,51010],[1774,1761],[1774,2215],[1774,2254],[1774,47399],[1774,51006],[1775,1761],
 [1775,2215],[1775,2254],[1775,47399],[1775,51006],[1776,1761],[1776,2262],[1776,47218],
 [1776,47223],[1776,47418],[1776,51048],[1777,1761],[1777,2268],[1777,2270],
 [1777,47219,51050],[1777,47220,51050],[1777,47222,47433],[1777,47224,47433],
 [1777,47420,51050],[1777,47422,47433],[1777,47424,47433],[1777,47426,47433],
 [1777,47428,47433],[1777,47433],[1777,51050],[1777,51052,51050],[1777,51054,51050],
 [1777,51056,51050],[1777,51058,51050],[1777,51063,47433],[1777,52376,51050],
 [1777,52378,51050],[1777,52383,47433],[1777,52389,47433],[1778,1761],[1778,2268],
 [1778,2270],[1778,47433],[1778,51050],[1779,1761],[1779,2215],[1779,2254],[1779,47399],
 [1779,51006],[1780,1761],[1780,2268],[1780,2270],[1780,47433],[1780,51050],[1781,1761],
 [1781,2262],[1781,47218],[1781,47223],[1781,47418],[1781,51048],[1782,1761],[1782,2268],
 [1782,2270],[1782,47433],[1782,51050],[1783,41239],[1784,1336],[1784,42761],[1785,1887],
 [1785,47508],[1786,1915],[1786,47536],[1790,1625],[1790,44766],[1791,2033],[1791,47654],
 [1792,1761],[1792,46948],[1794,1698],[1794,45926],[1796,6152],[1799,2033],[1799,47654],
 [1800,1887],[1800,47508],[1801,1915],[1801,47536],[1802,2215],[1802,47836],[1803,2224],
 [1803,47845],[1804,2224],[1804,47845],[1805,2215],[1805,47836],[1806,2254],[1806,47875],
 [1807,2262],[1807,47883],[1808,2268],[1808,47889],[1809,2270],[1809,47891],[1810,2254],
 [1810,47875],[1811,2270],[1811,47891],[1812,2262],[1812,47883],[1813,2268],[1813,47889],
 [1815,1887],[1815,47943],[1816,1915],[1816,47971],[1818,1658],[1818,1823],[1818,45389],
 [1818,45394],[1818,45529],[1818,48014],[1819,1625],[1819,48035],[1820,1625],[1820,48035],
 [1821,2033],[1821,48089],[1822,1761],[1822,46978],[1824,1698],[1824,45956],[1829,2033],
 [1829,48089],[1830,1887],[1830,47943],[1831,1915],[1831,47971],[1832,2215],[1832,48271],
 [1833,2224],[1833,48280],[1834,2224],[1834,48280],[1835,2215],[1835,48271],[1836,2254],
 [1836,48310],[1837,2262],[1837,48318],[1838,2268],[1838,48324],[1839,2270],[1839,48326],
 [1840,2254],[1840,48310],[1841,2270],[1841,48326],[1842,2262],[1842,48318],[1843,2268],
 [1843,48324],[1844,1887],[1844,48349],[1845,1915],[1845,48377],[1847,1583],[1847,1658],
 [1847,44000],[1847,44004],[1847,44193],[1847,45418],[1848,1698],[1848,48445],
 [1849,1625],[1849,44825],[1850,2033],[1850,48495],[1851,1761],[1851,47007],[1853,1698],
 [1853,48445],[1857,6213],[1858,2033],[1858,48495],[1859,1887],[1859,48349],[1860,1915],
 [1860,48377],[1861,2215],[1861,48677],[1862,2224],[1862,48686],[1863,2224],[1863,48686],
 [1864,2215],[1864,48677],[1865,2254],[1865,48716],[1866,2262],[1866,48724],[1867,2268],
 [1867,48730],[1868,2270],[1868,48732],[1869,2254],[1869,48716],[1870,2270],[1870,48732],
 [1871,2262],[1871,48724],[1872,2268],[1872,48730],[1873,1377],[1873,1887],[1873,1915],
 [1873,40824],[1873,42109],[1874,1887],[1874,48780],[1875,1658],[1875,1887],[1875,2033],
 [1875,45745],[1875,48796],[1876,1887],[1876,48829],[1877,1625],[1877,1887],[1877,44853],
 [1877,44863],[1877,44988],[1877,48852],[1878,1658],[1878,1887],[1878,2033],[1878,45745],
 [1878,48796],[1879,1761],[1879,1887],[1879,47035],[1879,47043],[1879,47211],[1879,48895],
 [1880,1887],[1880,48915],[1881,1698],[1881,1887],[1881,46013],[1881,46019],[1881,46226],
 [1881,48934],[1882,1887],[1882,48952],[1883,1887],[1883,48969],[1884,1887],[1884,48985],
 [1885,1887],[1885,49000],[1886,1658],[1886,1887],[1886,2033],[1886,45745],[1886,48796],
 [1888,1377],[1888,1887],[1888,1915],[1888,40824],[1888,42109],[1889,1887],[1889,2215],
 [1889,49029],[1889,49032],[1889,49055],[1889,52045],[1890,1887],[1890,2224],[1890,49030],
 [1890,49031],[1890,49064],[1890,52054],[1891,1887],[1891,2224],[1891,49030],[1891,49031],
 [1891,49064],[1891,52054],[1892,1887],[1892,2215],[1892,49029],[1892,49032],[1892,49055],
 [1892,52045],[1893,1887],[1893,2254],[1893,49033],[1893,49037],[1893,49094],[1893,52084],
 [1894,1887],[1894,2262],[1894,49034],[1894,49039],[1894,49102],[1894,52092],[1895,1887],
 [1895,2268],[1895,49035],[1895,49040],[1895,49108],[1895,52098],[1896,1887],[1896,2270],
 [1896,49036],[1896,49038],[1896,49110],[1896,52100],[1897,1887],[1897,2254],[1897,49033],
 [1897,49037],[1897,49094],[1897,52084],[1898,1887],[1898,2270],[1898,49036],[1898,49038],
 [1898,49110],[1898,52100],[1899,1887],[1899,2262],[1899,49034],[1899,49039],[1899,49102],
 [1899,52092],[1900,1887],[1900,2268],[1900,49035],[1900,49040],[1900,49108],[1900,52098],
 [1901,1915],[1901,49132],[1902,1658],[1902,1915],[1902,45473],[1902,45486],[1902,45537],
 [1902,49157],[1903,1915],[1903,49181],[1904,1625],[1904,1915],[1904,44880],[1904,44891],
 [1904,44989],[1904,49204],[1905,1761],[1905,1915],[1905,2033],[1905,47331],[1905,49217],
 [1906,1761],[1906,1915],[1906,2033],[1906,47331],[1906,49217],[1907,1915],[1907,49267],
 [1908,1698],[1908,1915],[1908,46040],[1908,46047],[1908,46227],[1908,49286],[1909,1915],
 [1909,49304],[1910,1915],[1910,49321],[1911,1915],[1911,49337],[1912,1915],[1912,49352],
 [1913,1761],[1913,1915],[1913,2033],[1913,47331],[1913,49217],[1914,1377],[1914,1887],
 [1914,1915],[1914,40824],[1914,42109],[1916,1915],[1916,2215],[1916,49392],[1916,49395],
 [1916,49406],[1916,52111],[1917,1915],[1917,2224],[1917,49393],[1917,49394],[1917,49415],
 [1917,52120],[1918,1915],[1918,2224],[1918,49393],[1918,49394],[1918,49415],[1918,52120],
 [1919,1915],[1919,2215],[1919,49392],[1919,49395],[1919,49406],[1919,52111],[1920,1915],
 [1920,2254],[1920,49396],[1920,49400],[1920,49445],[1920,52150],[1921,1915],[1921,2262],
 [1921,49397],[1921,49402],[1921,49453],[1921,52158],[1922,1915],[1922,2268],[1922,49398],
 [1922,49403],[1922,49459],[1922,52164],[1923,1915],[1923,2270],[1923,49399],[1923,49401],
 [1923,49461],[1923,52166],[1924,1915],[1924,2254],[1924,49396],[1924,49400],[1924,49445],
 [1924,52150],[1925,1915],[1925,2270],[1925,49399],[1925,49401],[1925,49461],[1925,52166],
 [1926,1915],[1926,2262],[1926,49397],[1926,49402],[1926,49453],[1926,52158],[1927,1915],
 [1927,2268],[1927,49398],[1927,49403],[1927,49459],[1927,52164],[1931,2033],[1931,49549],
 [1939,2033],[1939,49549],[1940,1887],[1940,48780],[1941,1915],[1941,49132],[1942,2215],
 [1942,49731],[1943,2224],[1943,49740],[1944,2224],[1944,49740],[1945,2215],[1945,49731],
 [1946,2254],[1946,49770],[1947,2262],[1947,49778],[1948,2268],[1948,49784],[1949,2270],
 [1949,49786],[1950,2254],[1950,49770],[1951,2270],[1951,49786],[1952,2262],[1952,49778],
 [1953,2268],[1953,49784],[1956,1658],[1956,1887],[1956,2033],[1956,45745],[1956,48796],
 [1958,1658],[1958,1823],[1958,45389],[1958,45394],[1958,45529],[1958,48014],[1960,1658],
 [1960,45531],[1961,1658],[1961,45532],[1962,1658],[1962,45533],[1963,1658],[1963,45534],
 [1964,1658],[1964,1887],[1964,2033],[1964,45745],[1964,48796],[1965,1658],[1965,1887],
 [1965,2033],[1965,45745],[1965,48796],[1966,1658],[1966,1915],[1966,45473],[1966,45486],
 [1966,45537],[1966,49157],[1967,1658],[1967,2215],[1967,45538],[1967,45541],[1967,45786],
 [1967,50031],[1968,1658],[1968,2224],[1968,2254],[1968,45806],[1968,50046],[1969,1658],
 [1969,2224],[1969,2254],[1969,45806],[1969,50046],[1970,1658],[1970,2215],[1970,45538],
 [1970,45541],[1970,45786],[1970,50031],[1971,1658],[1971,2224],[1971,2254],[1971,45806],
 [1971,50046],[1972,1658],[1972,2262],[1972,2270],[1972,45847],[1972,50075],[1973,1658],
 [1973,2268],[1973,45544],[1973,45549],[1973,45839],[1973,50084],[1974,1658],[1974,2262],
 [1974,2270],[1974,45847],[1974,50075],[1975,1658],[1975,2224],[1975,2254],[1975,45806],
 [1975,50046],[1976,1658],[1976,2262],[1976,2270],[1976,45847],[1976,50075],[1977,1658],
 [1977,2262],[1977,2270],[1977,45847],[1977,50075],[1978,1658],[1978,2268],[1978,45544],
 [1978,45549],[1978,45839],[1978,50084],[1979,1625],[1979,48035],[1980,2033],[1980,50125],
 [1981,1761],[1981,47137],[1982,4193],[1983,1698],[1983,48445],[1988,2033],[1988,50125],
 [1989,1887],[1989,48829],[1990,1915],[1990,49181],[1991,2215],[1991,50307],[1992,2224],
 [1992,50316],[1993,2224],[1993,50316],[1994,2215],[1994,50307],[1995,2254],[1995,50346],
 [1996,2262],[1996,50354],[1997,2268],[1997,50360],[1998,2270],[1998,50362],[1999,2254],
 [1999,50346],[2000,2270],[2000,50362],[2001,2262],[2001,50354],[2002,2268],[2002,50360],
 [2003,1625],[2003,2033],[2003,44979],[2003,44987],[2003,45009],[2003,50378],[2005,1625],
 [2005,43685],[2009,1625],[2009,44985],[2010,1625],[2010,44986],[2011,1625],[2011,2033],
 [2011,44979],[2011,44987],[2011,45009],[2011,50378],[2012,1625],[2012,1887],[2012,44853],
 [2012,44863],[2012,44988],[2012,48852],[2013,1625],[2013,1915],[2013,44880],[2013,44891],
 [2013,44989],[2013,49204],[2014,1625],[2014,2215],[2014,44990],[2014,44993],[2014,45191],
 [2014,50560],[2015,1625],[2015,2224],[2015,44991],[2015,44992],[2015,45200],[2015,50569],
 [2016,1625],[2016,2224],[2016,44991],[2016,44992],[2016,45200],[2016,50569],[2017,1625],
 [2017,2215],[2017,44990],[2017,44993],[2017,45191],[2017,50560],[2018,1625],[2018,2254],
 [2018,44994],[2018,44998],[2018,45230],[2018,50599],[2019,1625],[2019,2262],[2019,44995],
 [2019,45000],[2019,45238],[2019,50607],[2020,1625],[2020,2268],[2020,44996],[2020,45001],
 [2020,45244],[2020,50613],[2021,1625],[2021,2270],[2021,44997],[2021,44999],[2021,45246],
 [2021,50615],[2022,1625],[2022,2254],[2022,44994],[2022,44998],[2022,45230],[2022,50599],
 [2023,1625],[2023,2270],[2023,44997],[2023,44999],[2023,45246],[2023,50615],[2024,1625],
 [2024,2262],[2024,44995],[2024,45000],[2024,45238],[2024,50607],[2025,1625],[2025,2268],
 [2025,44996],[2025,45001],[2025,45244],[2025,50613],[2026,1761],[2026,1915],[2026,2033],
 [2026,47331],[2026,49217],[2027,2033],[2027,50650],[2028,1698],[2028,2033],[2028,46160],
 [2028,46165],[2028,46225],[2028,50669],[2029,2033],[2029,50687],[2030,2033],[2030,50704],
 [2031,2033],[2031,50720],[2032,2033],[2032,50735],[2034,1658],[2034,1887],[2034,2033],
 [2034,45745],[2034,48796],[2035,1761],[2035,1915],[2035,2033],[2035,47331],[2035,49217],
 [2036,2033],[2036,2215],[2036,50752],[2036,50755],[2036,50791],[2036,51967],[2037,2033],
 [2037,2224],[2037,50753],[2037,50754],[2037,50800],[2037,51976],[2038,2033],[2038,2224],
 [2038,50753],[2038,50754],[2038,50800],[2038,51976],[2039,2033],[2039,2215],[2039,50752],
 [2039,50755],[2039,50791],[2039,51967],[2040,2033],[2040,2254],[2040,50756],[2040,50760],
 [2040,50830],[2040,52006],[2041,2033],[2041,2262],[2041,50757],[2041,50762],[2041,50838],
 [2041,52014],[2042,2033],[2042,2268],[2042,50758],[2042,50763],[2042,50844],[2042,52020],
 [2043,2033],[2043,2270],[2043,50759],[2043,50761],[2043,50846],[2043,52022],[2044,2033],
 [2044,2254],[2044,50756],[2044,50760],[2044,50830],[2044,52006],[2045,2033],[2045,2270],
 [2045,50759],[2045,50761],[2045,50846],[2045,52022],[2046,2033],[2046,2262],[2046,50757],
 [2046,50762],[2046,50838],[2046,52014],[2047,2033],[2047,2268],[2047,50758],[2047,50763],
 [2047,50844],[2047,52020],[2048,1761],[2048,44394],[2050,1761],[2050,47266],[2051,1761],
 [2051,47207],[2052,1761],[2052,47208],[2053,1761],[2053,47266],[2054,1761],[2054,1915],
 [2054,2033],[2054,47331],[2054,49217],[2055,1761],[2055,1887],[2055,47035],[2055,47043],
 [2055,47211],[2055,48895],[2056,1761],[2056,1915],[2056,2033],[2056,47331],[2056,49217],
 [2057,1761],[2057,2215],[2057,2254],[2057,47399],[2057,51006],[2058,1761],[2058,2224],
 [2058,47214],[2058,47215],[2058,47380],[2058,51010],[2059,1761],[2059,2224],[2059,47214],
 [2059,47215],[2059,47380],[2059,51010],[2060,1761],[2060,2215],[2060,2254],[2060,47399],
 [2060,51006],[2061,1761],[2061,2215],[2061,2254],[2061,47399],[2061,51006],[2062,1761],
 [2062,2262],[2062,47218],[2062,47223],[2062,47418],[2062,51048],[2063,1761],[2063,2268],
 [2063,2270],[2063,47433],[2063,51050],[2064,1761],[2064,2268],[2064,2270],[2064,47433],
 [2064,51050],[2065,1761],[2065,2215],[2065,2254],[2065,47399],[2065,51006],[2066,1761],
 [2066,2268],[2066,2270],[2066,47433],[2066,51050],[2067,1761],[2067,2262],[2067,47218],
 [2067,47223],[2067,47418],[2067,51048],[2068,1761],[2068,2268],[2068,2270],[2068,47433],
 [2068,51050],[2069,1698],[2069,46201],[2074,2033],[2074,50650],[2075,1887],[2075,48915],
 [2076,1915],[2076,49267],[2077,2215],[2077,51191],[2078,2224],[2078,51200],[2079,2224],
 [2079,51200],[2080,2215],[2080,51191],[2081,2254],[2081,51230],[2082,2262],[2082,51238],
 [2083,2268],[2083,51244],[2084,2270],[2084,51246],[2085,2254],[2085,51230],[2086,2270],
 [2086,51246],[2087,2262],[2087,51238],[2088,2268],[2088,51244],[2089,1698],[2089,46241],
 [2090,1698],[2090,46222],[2091,1698],[2091,46241],[2092,1698],[2092,46224],[2093,1698],
 [2093,2033],[2093,46160],[2093,46165],[2093,46225],[2093,50669],[2094,1698],[2094,1887],
 [2094,46013],[2094,46019],[2094,46226],[2094,48934],[2095,1698],[2095,1915],[2095,46040],
 [2095,46047],[2095,46227],[2095,49286],[2096,1698],[2096,2215],[2096,46228],[2096,46231],
 [2096,46347],[2096,51362],[2097,1698],[2097,2224],[2097,46229],[2097,46230],[2097,46356],
 [2097,51371],[2098,1698],[2098,2224],[2098,46229],[2098,46230],[2098,46356],[2098,51371],
 [2099,1698],[2099,2215],[2099,46228],[2099,46231],[2099,46347],[2099,51362],[2100,1698],
 [2100,2254],[2100,46232],[2100,46236],[2100,46386],[2100,51401],[2101,1698],[2101,2262],
 [2101,46233],[2101,46238],[2101,46394],[2101,51409],[2102,1698],[2102,2268],[2102,46234],
 [2102,46239],[2102,46400],[2102,51415],[2103,1698],[2103,2270],[2103,46235],[2103,46237],
 [2103,46402],[2103,51417],[2104,1698],[2104,2254],[2104,46232],[2104,46236],[2104,46386],
 [2104,51401],[2105,1698],[2105,2270],[2105,46235],[2105,46237],[2105,46402],[2105,51417],
 [2106,1698],[2106,2262],[2106,46233],[2106,46238],[2106,46394],[2106,51409],[2107,1698],
 [2107,2268],[2107,46234],[2107,46239],[2107,46400],[2107,51415],[2109,1698],[2109,46241],
 [2110,1761],[2110,47266],[2111,2033],[2111,50687],[2112,1887],[2112,48952],[2113,1915],
 [2113,49304],[2114,2215],[2114,51515],[2115,2224],[2115,51524],[2116,2224],[2116,51524],
 [2117,2215],[2117,51515],[2118,2254],[2118,51554],[2119,2262],[2119,51562],[2120,2268],
 [2120,51568],[2121,2270],[2121,51570],[2122,2254],[2122,51554],[2123,2270],[2123,51570],
 [2124,2262],[2124,51562],[2125,2268],[2125,51568],[2127,1336],[2127,43104],[2128,2033],
 [2128,50704],[2129,1887],[2129,48969],[2130,1915],[2130,49321],[2131,2215],[2131,51651],
 [2132,2224],[2132,51660],[2133,2224],[2133,51660],[2134,2215],[2134,51651],[2135,2254],
 [2135,51690],[2136,2262],[2136,51698],[2137,2268],[2137,51704],[2138,2270],[2138,51706],
 [2139,2254],[2139,51690],[2140,2270],[2140,51706],[2141,2262],[2141,51698],[2142,2268],
 [2142,51704],[2144,2033],[2144,50720],[2145,1887],[2145,48985],[2146,1915],[2146,49337],
 [2147,2215],[2147,51771],[2148,2224],[2148,51780],[2149,2224],[2149,51780],[2150,2215],
 [2150,51771],[2151,2254],[2151,51810],[2152,2262],[2152,51818],[2153,2268],[2153,51824],
 [2154,2270],[2154,51826],[2155,2254],[2155,51810],[2156,2270],[2156,51826],[2157,2262],
 [2157,51818],[2158,2268],[2158,51824],[2159,2033],[2159,50735],[2160,1887],[2160,49000],
 [2161,1915],[2161,49352],[2162,2215],[2162,51876],[2163,2224],[2163,51885],[2164,2224],
 [2164,51885],[2165,2215],[2165,51876],[2166,2254],[2166,51915],[2167,2262],[2167,51923],
 [2168,2268],[2168,51929],[2169,2270],[2169,51931],[2170,2254],[2170,51915],[2171,2270],
 [2171,51931],[2172,2262],[2172,51923],[2173,2268],[2173,51929],[2174,1658],[2174,1887],
 [2174,2033],[2174,45745],[2174,48796],[2175,1761],[2175,1915],[2175,2033],[2175,47331],
 [2175,49217],[2176,2033],[2176,2215],[2176,50752],[2176,50755],[2176,50791],[2176,51967],
 [2177,2033],[2177,2224],[2177,50753],[2177,50754],[2177,50800],[2177,51976],[2178,2033],
 [2178,2224],[2178,50753],[2178,50754],[2178,50800],[2178,51976],[2179,2033],[2179,2215],
 [2179,50752],[2179,50755],[2179,50791],[2179,51967],[2180,2033],[2180,2254],[2180,50756],
 [2180,50760],[2180,50830],[2180,52006],[2181,2033],[2181,2262],[2181,50757],[2181,50762],
 [2181,50838],[2181,52014],[2182,2033],[2182,2268],[2182,50758],[2182,50763],[2182,50844],
 [2182,52020],[2183,2033],[2183,2270],[2183,50759],[2183,50761],[2183,50846],[2183,52022],
 [2184,2033],[2184,2254],[2184,50756],[2184,50760],[2184,50830],[2184,52006],[2185,2033],
 [2185,2270],[2185,50759],[2185,50761],[2185,50846],[2185,52022],[2186,2033],[2186,2262],
 [2186,50757],[2186,50762],[2186,50838],[2186,52014],[2187,2033],[2187,2268],[2187,50758],
 [2187,50763],[2187,50844],[2187,52020],[2188,1377],[2188,1887],[2188,1915],[2188,40824],
 [2188,42109],[2189,1887],[2189,2215],[2189,49029],[2189,49032],[2189,49055],[2189,52045],
 [2190,1887],[2190,2224],[2190,49030],[2190,49031],[2190,49064],[2190,52054],[2191,1887],
 [2191,2224],[2191,49030],[2191,49031],[2191,49064],[2191,52054],[2192,1887],[2192,2215],
 [2192,49029],[2192,49032],[2192,49055],[2192,52045],[2193,1887],[2193,2254],[2193,49033],
 [2193,49037],[2193,49094],[2193,52084],[2194,1887],[2194,2262],[2194,49034],[2194,49039],
 [2194,49102],[2194,52092],[2195,1887],[2195,2268],[2195,49035],[2195,49040],[2195,49108],
 [2195,52098],[2196,1887],[2196,2270],[2196,49036],[2196,49038],[2196,49110],[2196,52100],
 [2197,1887],[2197,2254],[2197,49033],[2197,49037],[2197,49094],[2197,52084],[2198,1887],
 [2198,2270],[2198,49036],[2198,49038],[2198,49110],[2198,52100],[2199,1887],[2199,2262],
 [2199,49034],[2199,49039],[2199,49102],[2199,52092],[2200,1887],[2200,2268],[2200,49035],
 [2200,49040],[2200,49108],[2200,52098],[2201,1915],[2201,2215],[2201,49392],[2201,49395],
 [2201,49406],[2201,52111],[2202,1915],[2202,2224],[2202,49393],[2202,49394],[2202,49415],
 [2202,52120],[2203,1915],[2203,2224],[2203,49393],[2203,49394],[2203,49415],[2203,52120],
 [2204,1915],[2204,2215],[2204,49392],[2204,49395],[2204,49406],[2204,52111],[2205,1915],
 [2205,2254],[2205,49396],[2205,49400],[2205,49445],[2205,52150],[2206,1915],[2206,2262],
 [2206,49397],[2206,49402],[2206,49453],[2206,52158],[2207,1915],[2207,2268],[2207,49398],
 [2207,49403],[2207,49459],[2207,52164],[2208,1915],[2208,2270],[2208,49399],[2208,49401],
 [2208,49461],[2208,52166],[2209,1915],[2209,2254],[2209,49396],[2209,49400],[2209,49445],
 [2209,52150],[2210,1915],[2210,2270],[2210,49399],[2210,49401],[2210,49461],[2210,52166],
 [2211,1915],[2211,2262],[2211,49397],[2211,49402],[2211,49453],[2211,52158],[2212,1915],
 [2212,2268],[2212,49398],[2212,49403],[2212,49459],[2212,52164],[2213,1377],[2213,2215],
 [2213,2224],[2213,40870],[2213,42449],[2214,1377],[2214,2215],[2214,2224],[2214,40870],
 [2214,42449],[2216,1761],[2216,2215],[2216,2254],[2216,47399],[2216,51006],[2217,2215],
 [2217,2262],[2217,52195],[2217,52200],[2217,52213],[2217,52322],[2218,328],[2218,2215],
 [2218,2268],[2218,14514],[2218,19857],[2219,2215],[2219,2270],[2219,52197],[2219,52199],
 [2219,52221],[2219,52330],[2220,1761],[2220,2215],[2220,2254],[2220,47399],[2220,51006],
 [2221,2215],[2221,2270],[2221,52197],[2221,52199],[2221,52221],[2221,52330],[2222,2215],
 [2222,2262],[2222,52195],[2222,52200],[2222,52213],[2222,52322],[2223,328],[2223,2215],
 [2223,2268],[2223,14514],[2223,19857],[2225,1377],[2225,2215],[2225,2224],[2225,40870],
 [2225,42449],[2226,1658],[2226,2224],[2226,2254],[2226,45806],[2226,50046],[2227,328],
 [2227,2224],[2227,2262],[2227,14523],[2227,19848],[2228,2224],[2228,2268],[2228,52233],
 [2228,52238],[2228,52264],[2228,52300],[2229,2224],[2229,2270],[2229,52234],[2229,52236],
 [2229,52266],[2229,52302],[2230,1658],[2230,2224],[2230,2254],[2230,45806],[2230,50046],
 [2231,2224],[2231,2270],[2231,52234],[2231,52236],[2231,52266],[2231,52302],[2232,328],
 [2232,2224],[2232,2262],[2232,14523],[2232,19848],[2233,2224],[2233,2268],[2233,52233],
 [2233,52238],[2233,52264],[2233,52300],[2234,1377],[2234,2215],[2234,2224],[2234,40870],
 [2234,42449],[2235,1658],[2235,2224],[2235,2254],[2235,45806],[2235,50046],[2236,328],
 [2236,2224],[2236,2262],[2236,14523],[2236,19848],[2237,2224],[2237,2268],[2237,52233],
 [2237,52238],[2237,52264],[2237,52300],[2238,2224],[2238,2270],[2238,52234],[2238,52236],
 [2238,52266],[2238,52302],[2239,1658],[2239,2224],[2239,2254],[2239,45806],[2239,50046],
 [2240,2224],[2240,2270],[2240,52234],[2240,52236],[2240,52266],[2240,52302],[2241,328],
 [2241,2224],[2241,2262],[2241,14523],[2241,19848],[2242,2224],[2242,2268],[2242,52233],
 [2242,52238],[2242,52264],[2242,52300],[2243,1761],[2243,2215],[2243,2254],[2243,47399],
 [2243,51006],[2244,2215],[2244,2262],[2244,52195],[2244,52200],[2244,52213],[2244,52322],
 [2245,328],[2245,2215],[2245,2268],[2245,14514],[2245,19857],[2246,2215],[2246,2270],
 [2246,52197],[2246,52199],[2246,52221],[2246,52330],[2247,1761],[2247,2215],[2247,2254],
 [2247,47399],[2247,51006],[2248,2215],[2248,2270],[2248,52197],[2248,52199],[2248,52221],
 [2248,52330],[2249,2215],[2249,2262],[2249,52195],[2249,52200],[2249,52213],[2249,52322],
 [2250,328],[2250,2215],[2250,2268],[2250,14514],[2250,19857],[2251,2254],[2251,2262],
 [2251,52341],[2251,52343],[2251,52355],[2251,52370],[2252,2254],[2252,2268],[2252,52346],
 [2252,52349],[2252,52356],[2252,52381],[2253,328],[2253,2254],[2253,2270],[2253,14565],
 [2253,19862],[2255,328],[2255,2254],[2255,2270],[2255,14565],[2255,19862],[2256,2254],
 [2256,2262],[2256,52341],[2256,52343],[2256,52355],[2256,52370],[2257,2254],[2257,2268],
 [2257,52346],[2257,52349],[2257,52356],[2257,52381],[2258,1377],[2258,2262],[2258,2268],
 [2258,40914],[2258,42494],[2259,1658],[2259,2262],[2259,2270],[2259,45847],[2259,50075],
 [2260,2254],[2260,2262],[2260,52341],[2260,52343],[2260,52355],[2260,52370],[2261,1658],
 [2261,2262],[2261,2270],[2261,45847],[2261,50075],[2263,1377],[2263,2262],[2263,2268],
 [2263,40914],[2263,42494],[2264,1761],[2264,2268],[2264,2270],[2264,47433],[2264,51050],
 [2265,2254],[2265,2268],[2265,52346],[2265,52349],[2265,52356],[2265,52381],[2266,1761],
 [2266,2268],[2266,2270],[2266,47433],[2266,51050],[2267,1377],[2267,2262],[2267,2268],
 [2267,40914],[2267,42494],[2269,328],[2269,2254],[2269,2270],[2269,14565],[2269,19862],
 [2271,1658],[2271,2262],[2271,2270],[2271,45847],[2271,50075],[2272,1761],[2272,2268],
 [2272,2270],[2272,47433],[2272,51050],[2273,328],[2273,2254],[2273,2270],[2273,14565],
 [2273,19862],[2274,2254],[2274,2262],[2274,52341],[2274,52343],[2274,52355],[2274,52370],
 [2275,2254],[2275,2268],[2275,52346],[2275,52349],[2275,52356],[2275,52381],[2276,1658],
 [2276,2262],[2276,2270],[2276,45847],[2276,50075],[2277,1761],[2277,2268],[2277,2270],
 [2277,47433],[2277,51050],[2278,1377],[2278,2262],[2278,2268],[2278,40914],[2278,42494],
 [2280,2279],[2281,2279],[2282,2279],[2283,2279],[2284,2279],[2285,2279],[2286,2279],
 [2287,2279],[2288,2279],[2289,2279],[2290,2279],[2291,2279],[2292,2279],[2293,2279],
 [2294,2279],[2295,2279],[2296,2279],[2297,2279],[2298,2279],[2299,2279],[2303,1291],
 [2303,1306],[2303,1336],[2303,1377],[2303,1432],[2303,1625],[2303,1658],[2303,1698],
 [2303,1761],[2303,2279],[2303,3507],[2303,3677],[2303,3714],[2303,5705],[2303,6018],
 [2303,6050],[2303,7828],[2303,7875],[2303,7950],[2303,38205],[2303,38304],[2303,38331],
 [2303,38557],[2303,38921],[2303,39193],[2303,39424],[2303,39779],[2303,40055],
 [2303,40287],[2303,40642],[2303,41069],[2303,41217],[2303,41411],[2303,41850],
 [2303,41900],[2303,42193],[2303,42593],[2303,42936],[2303,44904],[2303,45501],
 [2303,46064],[2303,47090],[2304,1291],[2304,1306],[2304,1336],[2304,1377],[2304,1432],
 [2304,1625],[2304,1658],[2304,1698],[2304,1761],[2304,2279],[2304,3507],[2304,3677],
 [2304,3714],[2304,5705],[2304,6018],[2304,6050],[2304,7828],[2304,7875],[2304,7950],
 [2304,38205],[2304,38304],[2304,38331],[2304,38557],[2304,38921],[2304,39193],
 [2304,39424],[2304,39779],[2304,40055],[2304,40287],[2304,40642],[2304,41069],
 [2304,41217],[2304,41411],[2304,41850],[2304,41900],[2304,42193],[2304,42593],
 [2304,42936],[2304,44904],[2304,45501],[2304,46064],[2304,47090],[2305,2279],
 [2305,3714],[2305,3725,3714],[2305,3725,42671],[2305,3905,3714],[2305,3905,42671],
 [2305,5859,6050],[2305,5859,42671],[2305,5870,6050],[2305,5870,42671],[2305,6050],
 [2305,7939,7950],[2305,7939,42671],[2305,7950],[2305,8130,7950],[2305,8130,42671],
 [2305,42671],[2306,2279],[2306,3507],[2306,3548,3505,3507],[2306,3548,3505,3756],
 [2306,3548,3506,3507],[2306,3548,3506,3794],[2306,3548,3506,38455],[2306,3548,3506,43965],
 [2306,3548,3507],[2306,3548,3513,3507],[2306,3548,3513,3756],[2306,3548,3514,3507],
 [2306,3548,3514,3794],[2306,3548,3514,38455],[2306,3548,3514,43965],[2306,3548,3750,3507],
 [2306,3548,3750,3756],[2306,3548,3756],[2306,3548,3787,3507],[2306,3548,3787,3794],
 [2306,3548,3787,38455],[2306,3548,3787,43965],[2306,3548,3794],[2306,3548,3829,3507],
 [2306,3548,3829,3756],[2306,3548,3830,3507],[2306,3548,3830,3794],[2306,3548,3830,38455],
 [2306,3548,3830,43965],[2306,3548,38205],[2306,3548,38209,38205],[2306,3548,38209,39313],
 [2306,3548,38210,38205],[2306,3548,38210,39313],[2306,3548,38217,38205],
 [2306,3548,38217,40450],[2306,3548,38218,38205],[2306,3548,38218,40450],
 [2306,3548,38251,38205],[2306,3548,38251,39313],[2306,3548,38252,38205],
 [2306,3548,38252,39313],[2306,3548,38259,38205],[2306,3548,38259,40450],
 [2306,3548,38260,38205],[2306,3548,38260,40450],[2306,3548,38410,38205],
 [2306,3548,38410,39313],[2306,3548,38411,3507],[2306,3548,38411,3756],[2306,3548,38417,3507],
 [2306,3548,38417,3756],[2306,3548,38418],[2306,3548,38448,3507],[2306,3548,38448,3794],
 [2306,3548,38448,38455],[2306,3548,38448,43965],[2306,3548,38454],[2306,3548,38455],
 [2306,3548,38490,3507],[2306,3548,38490,3756],[2306,3548,38491,3507],[2306,3548,38491,3794],
 [2306,3548,38491,38455],[2306,3548,38491,43965],[2306,3548,38686,38205],
 [2306,3548,38686,40450],[2306,3548,39154,38205],[2306,3548,39154,39313],
 [2306,3548,39155,38205],[2306,3548,39155,39313],[2306,3548,39162,38205],
 [2306,3548,39162,40450],[2306,3548,39163,38205],[2306,3548,39163,40450],[2306,3548,39313],
 [2306,3548,39321,39313],[2306,3548,39358,39313],[2306,3548,39589,38205],
 [2306,3548,39589,40450],[2306,3548,40174,38205],[2306,3548,40174,39313],
 [2306,3548,40218,40450],[2306,3548,40219,40450],[2306,3548,40450],[2306,3548,43263,39313],
 [2306,3548,43298,3507],[2306,3548,43298,3756],[2306,3548,43965],[2306,3548,44160,40450],
 [2306,3549,3507],[2306,3549,3756],[2306,3549,3794],[2306,3549,38205],[2306,3549,38418],
 [2306,3549,38454],[2306,3549,38455],[2306,3549,39313],[2306,3549,40450],[2306,3549,43965],
 [2306,3556,3507],[2306,3556,3756],[2306,3556,3794],[2306,3556,38205],[2306,3556,38418],
 [2306,3556,38454],[2306,3556,38455],[2306,3556,39313],[2306,3556,40450],[2306,3556,43965],
 [2306,3557,3507],[2306,3557,3756],[2306,3557,3794],[2306,3557,38205],[2306,3557,38418],
 [2306,3557,38454],[2306,3557,38455],[2306,3557,39313],[2306,3557,40450],[2306,3557,43965],
 [2306,3570,3507],[2306,3570,3527,3507],[2306,3570,3527,39015],[2306,3570,3528,3507],
 [2306,3570,3528,39015],[2306,3570,3843,3507],[2306,3570,3843,39015],[2306,3570,3844,3507],
 [2306,3570,3844,39015],[2306,3570,4354,3507],[2306,3570,4354,39015],[2306,3570,38205],
 [2306,3570,38231,38205],[2306,3570,38231,39015],[2306,3570,38232,38205],
 [2306,3570,38232,39015],[2306,3570,38273,38205],[2306,3570,38273,39015],
 [2306,3570,38274,38205],[2306,3570,38274,39015],[2306,3570,38504,3507],
 [2306,3570,38504,39015],[2306,3570,38505,3507],[2306,3570,38505,39015],[2306,3570,39015],
 [2306,3570,39176,38205],[2306,3570,39176,39015],[2306,3570,39177,38205],
 [2306,3570,39177,39015],[2306,3570,39918,38205],[2306,3570,39918,39015],
 [2306,3570,40779,38205],[2306,3570,40779,39015],[2306,3570,45119,3507],
 [2306,3570,45119,39015],[2306,3571,3507],[2306,3571,38205],[2306,3571,39015],
 [2306,3590,3507],[2306,3590,3756],[2306,3590,3794],[2306,3590,38205],[2306,3590,38418],
 [2306,3590,38454],[2306,3590,38455],[2306,3590,39313],[2306,3590,40450],[2306,3590,43965],
 [2306,3591,3507],[2306,3591,3756],[2306,3591,3794],[2306,3591,38205],[2306,3591,38418],
 [2306,3591,38454],[2306,3591,38455],[2306,3591,39313],[2306,3591,40450],[2306,3591,43965],
 [2306,3598,3507],[2306,3598,3756],[2306,3598,3794],[2306,3598,38205],[2306,3598,38418],
 [2306,3598,38454],[2306,3598,38455],[2306,3598,39313],[2306,3598,40450],[2306,3598,43965],
 [2306,3599,3507],[2306,3599,3756],[2306,3599,3794],[2306,3599,38205],[2306,3599,38418],
 [2306,3599,38454],[2306,3599,38455],[2306,3599,39313],[2306,3599,40450],[2306,3599,43965],
 [2306,3612,3507],[2306,3612,38205],[2306,3612,39015],[2306,3613,3507],[2306,3613,38205],
 [2306,3613,39015],[2306,3749,3507],[2306,3749,3756],[2306,3749,3794],[2306,3749,38205],
 [2306,3749,38418],[2306,3749,38454],[2306,3749,38455],[2306,3749,39313],[2306,3749,40450],
 [2306,3749,43965],[2306,3756],[2306,3757,3507],[2306,3757,3756],[2306,3757,3794],
 [2306,3757,38205],[2306,3757,38418],[2306,3757,38454],[2306,3757,38455],[2306,3757,39313],
 [2306,3757,40450],[2306,3757,43965],[2306,3770,3507],[2306,3770,3756],
 [2306,3770,38431,39015],[2306,3770,38432,39015],[2306,3770,38699,39015],
 [2306,3770,38700,39015],[2306,3770,39015],[2306,3770,43823,39015],[2306,3770,48199,39015],
 [2306,3771,3507],[2306,3771,3756],[2306,3771,39015],[2306,3793,3507],[2306,3793,3756],
 [2306,3793,3794],[2306,3793,38205],[2306,3793,38418],[2306,3793,38454],[2306,3793,38455],
 [2306,3793,39313],[2306,3793,40450],[2306,3793,43965],[2306,3794],[2306,4025,3507],
 [2306,4025,3756],[2306,4025,3794],[2306,4025,38205],[2306,4025,38418],[2306,4025,38454],
 [2306,4025,38455],[2306,4025,39313],[2306,4025,40450],[2306,4025,43965],[2306,4038,3507],
 [2306,4038,3756],[2306,4038,39015],[2306,4039,3507],[2306,4039,3756],[2306,4039,39015],
 [2306,5650,5693,5705],[2306,5650,5693,39313],[2306,5650,5694,5705],[2306,5650,5694,39313],
 [2306,5650,5705],[2306,5650,5894,5705],[2306,5650,5894,39313],[2306,5650,5905,5705],
 [2306,5650,5905,39313],[2306,5650,5942,5705],[2306,5650,5942,39313],[2306,5650,38205],
 [2306,5650,39313],[2306,5650,39324,5705],[2306,5650,39324,39313],[2306,5650,39361,5705],
 [2306,5650,39361,39313],[2306,5650,43266,5705],[2306,5650,43266,39313],[2306,5651,5705],
 [2306,5651,38205],[2306,5651,39313],[2306,5658,5701,5705],[2306,5658,5701,6183],
 [2306,5658,5701,39602],[2306,5658,5701,47993],[2306,5658,5702,5705],[2306,5658,5702,6213],
 [2306,5658,5705],[2306,5658,5715,5705],[2306,5658,5715,6183],[2306,5658,5715,39602],
 [2306,5658,5715,47993],[2306,5658,5716,5705],[2306,5658,5716,6213],[2306,5658,6173,5705],
 [2306,5658,6173,6183],[2306,5658,6173,39602],[2306,5658,6173,47993],[2306,5658,6183],
 [2306,5658,6202,5705],[2306,5658,6202,6213],[2306,5658,6213],[2306,5658,6293,5705],
 [2306,5658,6293,6183],[2306,5658,6293,39602],[2306,5658,6293,47993],[2306,5658,6294,5705],
 [2306,5658,6294,6213],[2306,5658,38205],[2306,5658,39015],[2306,5658,39592,5705],
 [2306,5658,39592,6183],[2306,5658,39592,39602],[2306,5658,39592,47993],[2306,5658,39602],
 [2306,5658,39603],[2306,5658,39621,5705],[2306,5658,39621,6213],[2306,5658,39631],
 [2306,5658,39632,5705],[2306,5658,39632,6213],[2306,5658,39712,5705],[2306,5658,39712,6183],
 [2306,5658,39712,39602],[2306,5658,39712,47993],[2306,5658,39713,5705],
 [2306,5658,39713,6213],[2306,5658,40450],[2306,5658,47993],[2306,5658,48400,5705],
 [2306,5658,48400,6213],[2306,5659,5705],[2306,5659,6183],[2306,5659,6213],
 [2306,5659,38205],[2306,5659,39015],[2306,5659,39602],[2306,5659,39603],[2306,5659,39631],
 [2306,5659,40450],[2306,5659,47993],[2306,5672,5705],[2306,5672,6183],[2306,5672,6213],
 [2306,5672,38205],[2306,5672,39015],[2306,5672,39602],[2306,5672,39603],[2306,5672,39631],
 [2306,5672,40450],[2306,5672,47993],[2306,5673,5705],[2306,5673,6183],[2306,5673,6213],
 [2306,5673,38205],[2306,5673,39015],[2306,5673,39602],[2306,5673,39603],[2306,5673,39631],
 [2306,5673,40450],[2306,5673,47993],[2306,5705],[2306,5735,5705],[2306,5735,38205],
 [2306,5735,39313],[2306,5736,5705],[2306,5736,38205],[2306,5736,39313],[2306,5743,5705],
 [2306,5743,6183],[2306,5743,6213],[2306,5743,38205],[2306,5743,39015],[2306,5743,39602],
 [2306,5743,39603],[2306,5743,39631],[2306,5743,40450],[2306,5743,47993],[2306,5744,5705],
 [2306,5744,6183],[2306,5744,6213],[2306,5744,38205],[2306,5744,39015],[2306,5744,39602],
 [2306,5744,39603],[2306,5744,39631],[2306,5744,40450],[2306,5744,47993],[2306,5757,5705],
 [2306,5757,6183],[2306,5757,6213],[2306,5757,38205],[2306,5757,39015],[2306,5757,39602],
 [2306,5757,39603],[2306,5757,39631],[2306,5757,40450],[2306,5757,47993],[2306,5758,5705],
 [2306,5758,6183],[2306,5758,6213],[2306,5758,38205],[2306,5758,39015],[2306,5758,39602],
 [2306,5758,39603],[2306,5758,39631],[2306,5758,40450],[2306,5758,47993],[2306,5902,5705],
 [2306,5902,6213],[2306,5902,39313],[2306,5902,39335,39313],[2306,5902,39372,39313],
 [2306,5902,43277,39313],[2306,5916,5705],[2306,5916,6213],[2306,5916,39313],
 [2306,5939,5705],[2306,5939,6213],[2306,5939,39313],[2306,5953,5705],[2306,5953,6213],
 [2306,5953,39313],[2306,6170,5705],[2306,6170,6183],[2306,6170,6213],[2306,6170,38205],
 [2306,6170,39015],[2306,6170,39602],[2306,6170,39603],[2306,6170,39631],[2306,6170,40450],
 [2306,6170,47993],[2306,6183],[2306,6184,5705],[2306,6184,6183],[2306,6184,6213],
 [2306,6184,38205],[2306,6184,39015],[2306,6184,39602],[2306,6184,39603],[2306,6184,39631],
 [2306,6184,40450],[2306,6184,47993],[2306,6212,5705],[2306,6212,6183],[2306,6212,6213],
 [2306,6212,38205],[2306,6212,39015],[2306,6212,39602],[2306,6212,39603],[2306,6212,39631],
 [2306,6212,40450],[2306,6212,47993],[2306,6213],[2306,6499,5705],[2306,6499,6183],
 [2306,6499,6213],[2306,6499,38205],[2306,6499,39015],[2306,6499,39602],[2306,6499,39603],
 [2306,6499,39631],[2306,6499,40450],[2306,6499,47993],[2306,7730,7815,7828],
 [2306,7730,7815,7996],[2306,7730,7815,40196],[2306,7730,7815,43643],[2306,7730,7816,7828],
 [2306,7730,7816,8032],[2306,7730,7828],[2306,7730,7837,7828],[2306,7730,7837,8032],
 [2306,7730,7838,7828],[2306,7730,7838,7996],[2306,7730,7838,40196],[2306,7730,7838,43643],
 [2306,7730,7986,7828],[2306,7730,7986,7996],[2306,7730,7986,40196],[2306,7730,7986,43643],
 [2306,7730,7996],[2306,7730,8023,7828],[2306,7730,8023,8032],[2306,7730,8032],
 [2306,7730,8398,7828],[2306,7730,8398,8032],[2306,7730,8399,7828],[2306,7730,8399,7996],
 [2306,7730,8399,40196],[2306,7730,8399,43643],[2306,7730,38205],[2306,7730,39015],
 [2306,7730,39313],[2306,7730,40186,7828],[2306,7730,40186,7996],[2306,7730,40186,40196],
 [2306,7730,40186,43643],[2306,7730,40195],[2306,7730,40196],[2306,7730,40223,7828],
 [2306,7730,40223,8032],[2306,7730,40232,7828],[2306,7730,40232,8032],[2306,7730,40233],
 [2306,7730,40598,7828],[2306,7730,40598,8032],[2306,7730,40599,7828],[2306,7730,40599,7996],
 [2306,7730,40599,40196],[2306,7730,40599,43643],[2306,7730,43643],[2306,7730,44308,7828],
 [2306,7730,44308,8032],[2306,7731,7828],[2306,7731,7996],[2306,7731,8032],
 [2306,7731,38205],[2306,7731,39015],[2306,7731,39313],[2306,7731,40195],[2306,7731,40196],
 [2306,7731,40233],[2306,7731,43643],[2306,7738,7823,7828],[2306,7738,7823,40450],
 [2306,7738,7824,7828],[2306,7738,7824,40450],[2306,7738,7828],[2306,7738,8250,7828],
 [2306,7738,8250,40450],[2306,7738,8254,7828],[2306,7738,8254,40450],[2306,7738,8283,7828],
 [2306,7738,8283,40450],[2306,7738,38205],[2306,7738,40450],[2306,7738,40454,7828],
 [2306,7738,40454,40450],[2306,7738,40483,7828],[2306,7738,40483,40450],
 [2306,7738,47903,7828],[2306,7738,47903,40450],[2306,7739,7828],[2306,7739,38205],
 [2306,7739,40450],[2306,7752,7828],[2306,7752,7996],[2306,7752,8032],[2306,7752,38205],
 [2306,7752,39015],[2306,7752,39313],[2306,7752,40195],[2306,7752,40196],[2306,7752,40233],
 [2306,7752,43643],[2306,7753,7828],[2306,7753,7996],[2306,7753,8032],[2306,7753,38205],
 [2306,7753,39015],[2306,7753,39313],[2306,7753,40195],[2306,7753,40196],[2306,7753,40233],
 [2306,7753,43643],[2306,7773,7828],[2306,7773,7996],[2306,7773,8032],[2306,7773,38205],
 [2306,7773,39015],[2306,7773,39313],[2306,7773,40195],[2306,7773,40196],[2306,7773,40233],
 [2306,7773,43643],[2306,7774,7828],[2306,7774,7996],[2306,7774,8032],[2306,7774,38205],
 [2306,7774,39015],[2306,7774,39313],[2306,7774,40195],[2306,7774,40196],[2306,7774,40233],
 [2306,7774,43643],[2306,7781,7828],[2306,7781,38205],[2306,7781,40450],[2306,7782,7828],
 [2306,7782,38205],[2306,7782,40450],[2306,7795,7828],[2306,7795,7996],[2306,7795,8032],
 [2306,7795,38205],[2306,7795,39015],[2306,7795,39313],[2306,7795,40195],[2306,7795,40196],
 [2306,7795,40233],[2306,7795,43643],[2306,7796,7828],[2306,7796,7996],[2306,7796,8032],
 [2306,7796,38205],[2306,7796,39015],[2306,7796,39313],[2306,7796,40195],[2306,7796,40196],
 [2306,7796,40233],[2306,7796,43643],[2306,7828],[2306,7974,7828],[2306,7974,7996],
 [2306,7974,8032],[2306,7974,38205],[2306,7974,39015],[2306,7974,39313],[2306,7974,40195],
 [2306,7974,40196],[2306,7974,40233],[2306,7974,43643],[2306,7995,7828],[2306,7995,7996],
 [2306,7995,8032],[2306,7995,38205],[2306,7995,39015],[2306,7995,39313],[2306,7995,40195],
 [2306,7995,40196],[2306,7995,40233],[2306,7995,43643],[2306,7996],[2306,8018,7828],
 [2306,8018,8032],[2306,8018,40450],[2306,8019,7828],[2306,8019,8032],[2306,8019,40450],
 [2306,8032],[2306,8033,7828],[2306,8033,7996],[2306,8033,8032],[2306,8033,38205],
 [2306,8033,39015],[2306,8033,39313],[2306,8033,40195],[2306,8033,40196],[2306,8033,40233],
 [2306,8033,43643],[2306,8263,7828],[2306,8263,8032],[2306,8263,40450],[2306,8292,7828],
 [2306,8292,8032],[2306,8292,40450],[2306,8579,7828],[2306,8579,7996],[2306,8579,8032],
 [2306,8579,38205],[2306,8579,39015],[2306,8579,39313],[2306,8579,40195],[2306,8579,40196],
 [2306,8579,40233],[2306,8579,43643],[2306,38205],[2306,38418],[2306,38454],[2306,38455],
 [2306,38468,7828],[2306,38468,7996],[2306,38468,8032],[2306,38468,38205],[2306,38468,39015],
 [2306,38468,39313],[2306,38468,40195],[2306,38468,40196],[2306,38468,40233],
 [2306,38468,43643],[2306,38469,7828],[2306,38469,7996],[2306,38469,8032],[2306,38469,38205],
 [2306,38469,39015],[2306,38469,39313],[2306,38469,40195],[2306,38469,40196],
 [2306,38469,40233],[2306,38469,43643],[2306,38728,5705],[2306,38728,6183],[2306,38728,6213],
 [2306,38728,38205],[2306,38728,39015],[2306,38728,39602],[2306,38728,39603],
 [2306,38728,39631],[2306,38728,40450],[2306,38728,47993],[2306,38729,5705],
 [2306,38729,6183],[2306,38729,6213],[2306,38729,38205],[2306,38729,39015],
 [2306,38729,39602],[2306,38729,39603],[2306,38729,39631],[2306,38729,40450],
 [2306,38729,47993],[2306,39015],[2306,39313],[2306,39320,3507],[2306,39320,3756],
 [2306,39320,3794],[2306,39320,38205],[2306,39320,38418],[2306,39320,38454],
 [2306,39320,38455],[2306,39320,39313],[2306,39320,40450],[2306,39320,43965],
 [2306,39334,7828],[2306,39334,7996],[2306,39334,8032],[2306,39334,38205],[2306,39334,39015],
 [2306,39334,39313],[2306,39334,40195],[2306,39334,40196],[2306,39334,40233],
 [2306,39334,43643],[2306,39357,3507],[2306,39357,3756],[2306,39357,3794],[2306,39357,38205],
 [2306,39357,38418],[2306,39357,38454],[2306,39357,38455],[2306,39357,39313],
 [2306,39357,40450],[2306,39357,43965],[2306,39371,7828],[2306,39371,7996],[2306,39371,8032],
 [2306,39371,38205],[2306,39371,39015],[2306,39371,39313],[2306,39371,40195],
 [2306,39371,40196],[2306,39371,40233],[2306,39371,43643],[2306,39602],[2306,39603],
 [2306,39631],[2306,40181,3507],[2306,40181,3756],[2306,40181,3794],[2306,40181,38205],
 [2306,40181,38418],[2306,40181,38454],[2306,40181,38455],[2306,40181,39313],
 [2306,40181,40450],[2306,40181,43965],[2306,40182,3507],[2306,40182,3756],[2306,40182,3794],
 [2306,40182,38205],[2306,40182,38418],[2306,40182,38454],[2306,40182,38455],
 [2306,40182,39313],[2306,40182,40450],[2306,40182,43965],[2306,40195],[2306,40196],
 [2306,40233],[2306,40450],[2306,40464,5705],[2306,40464,6183],[2306,40464,6213],
 [2306,40464,38205],[2306,40464,39015],[2306,40464,39602],[2306,40464,39603],
 [2306,40464,39631],[2306,40464,40450],[2306,40464,47993],[2306,40493,5705],
 [2306,40493,6183],[2306,40493,6213],[2306,40493,38205],[2306,40493,39015],
 [2306,40493,39602],[2306,40493,39603],[2306,40493,39631],[2306,40493,40450],
 [2306,40493,47993],[2306,43262,3507],[2306,43262,3756],[2306,43262,3794],[2306,43262,38205],
 [2306,43262,38418],[2306,43262,38454],[2306,43262,38455],[2306,43262,39313],
 [2306,43262,40450],[2306,43262,43965],[2306,43276,7828],[2306,43276,7996],[2306,43276,8032],
 [2306,43276,38205],[2306,43276,39015],[2306,43276,39313],[2306,43276,40195],
 [2306,43276,40196],[2306,43276,40233],[2306,43276,43643],[2306,43494,3507],
 [2306,43494,3756],[2306,43494,3794],[2306,43494,38205],[2306,43494,38418],
 [2306,43494,38454],[2306,43494,38455],[2306,43494,39313],[2306,43494,40450],
 [2306,43494,43965],[2306,43507,3507],[2306,43507,3756],[2306,43507,39015],[2306,43508,3507],
 [2306,43508,3756],[2306,43508,39015],[2306,43536],[2306,43537,5705],[2306,43537,6213],
 [2306,43537,39313],[2306,43643],[2306,43965],[2306,44173,7828],[2306,44173,8032],
 [2306,44173,40450],[2306,44174],[2306,44202,7828],[2306,44202,8032],[2306,44202,40450],
 [2306,44203,5705],[2306,44203,6213],[2306,44203,39313],[2306,44489,7828],[2306,44489,7996],
 [2306,44489,8032],[2306,44489,38205],[2306,44489,39015],[2306,44489,39313],
 [2306,44489,40195],[2306,44489,40196],[2306,44489,40233],[2306,44489,43643],[2306,44904],
 [2306,47913,5705],[2306,47913,6183],[2306,47913,6213],[2306,47913,38205],[2306,47913,39015],
 [2306,47913,39602],[2306,47913,39603],[2306,47913,39631],[2306,47913,40450],
 [2306,47913,47993],[2306,47993],[2306,48605,5705],[2306,48605,6183],[2306,48605,6213],
 [2306,48605,38205],[2306,48605,39015],[2306,48605,39602],[2306,48605,39603],
 [2306,48605,39631],[2306,48605,40450],[2306,48605,47993],[2307,2279],[2307,3507],
 [2307,3756],[2307,3794],[2307,5705],[2307,6183],[2307,6213],[2307,7828],[2307,7996],
 [2307,8032],[2307,38205],[2307,38418],[2307,38454],[2307,38455],[2307,39015],
 [2307,39313],[2307,39602],[2307,39603],[2307,39631],[2307,40195],[2307,40196],
 [2307,40233],[2307,40450],[2307,43536],[2307,43643],[2307,43965],[2307,44174],
 [2307,44904],[2307,47993],[2309,1291],[2309,1306],[2309,1336],[2309,1377],[2309,1432],
 [2309,1625],[2309,1658],[2309,1698],[2309,1761],[2309,2279],[2309,3507],[2309,3677],
 [2309,3714],[2309,5705],[2309,6018],[2309,6050],[2309,7828],[2309,7875],[2309,7950],
 [2309,38205],[2309,38304],[2309,38331],[2309,38557],[2309,38921],[2309,39193],
 [2309,39424],[2309,39779],[2309,40055],[2309,40287],[2309,40642],[2309,41069],
 [2309,41217],[2309,41411],[2309,41850],[2309,41900],[2309,42193],[2309,42593],
 [2309,42936],[2309,44904],[2309,45501],[2309,46064],[2309,47090],[2310,2279],
 [2310,3714],[2310,6050],[2310,7950],[2310,42671],[2311,2279],[2311,3507],[2311,3930],
 [2311,3935,3507],[2311,3935,3510,3507],[2311,3935,3510,3930],[2311,3935,3510,38591],
 [2311,3935,3510,44695],[2311,3935,3512,3507],[2311,3935,3512,3930],[2311,3935,3512,38591],
 [2311,3935,3512,44695],[2311,3935,3519,3507],[2311,3935,3519,4193],[2311,3935,3523,3507],
 [2311,3935,3523,4193],[2311,3935,3826,3507],[2311,3935,3826,3930],[2311,3935,3826,38591],
 [2311,3935,3826,44695],[2311,3935,3828,3507],[2311,3935,3828,3930],[2311,3935,3828,38591],
 [2311,3935,3828,44695],[2311,3935,3835,3507],[2311,3935,3835,4193],[2311,3935,3839,3507],
 [2311,3935,3839,4193],[2311,3935,3930],[2311,3935,4193],[2311,3935,38487,3507],
 [2311,3935,38487,3930],[2311,3935,38487,38591],[2311,3935,38487,44695],
 [2311,3935,38489,3507],[2311,3935,38489,3930],[2311,3935,38489,38591],
 [2311,3935,38489,44695],[2311,3935,38496,3507],[2311,3935,38496,4193],[2311,3935,38500,3507],
 [2311,3935,38500,4193],[2311,3935,38591],[2311,3935,38854,3507],[2311,3935,38854,4193],
 [2311,3935,44695],[2311,3935,44700,44904],[2311,3935,44700,46593],[2311,3935,44701,44904],
 [2311,3935,44701,46593],[2311,3935,44702],[2311,3935,44706,44904],[2311,3935,44706,46593],
 [2311,3935,44763,44904],[2311,3935,44763,47575],[2311,3935,44764,44904],
 [2311,3935,44764,47575],[2311,3935,44765,44904],[2311,3935,44765,47575],[2311,3935,44769],
 [2311,3935,44904],[2311,3935,44905,44904],[2311,3935,44905,47575],[2311,3935,44909,44904],
 [2311,3935,44909,46593],[2311,3935,44930,44904],[2311,3935,44930,47575],
 [2311,3935,44934,44904],[2311,3935,44934,46593],[2311,3935,44958,3507],
 [2311,3935,44958,4193],[2311,3935,46447,46593],[2311,3935,46453,46593],
 [2311,3935,46588,44904],[2311,3935,46588,46593],[2311,3935,46593],[2311,3935,46618,44904],
 [2311,3935,46618,46593],[2311,3935,47549,44904],[2311,3935,47549,47575],
 [2311,3935,47550,44904],[2311,3935,47550,47575],[2311,3935,47554,46593],[2311,3935,47575],
 [2311,3935,49470,44904],[2311,3935,49470,47575],[2311,3935,49474,44904],
 [2311,3935,49474,46593],[2311,3936,3507],[2311,3936,3930],[2311,3936,4193],
 [2311,3936,38591],[2311,3936,44695],[2311,3936,44702],[2311,3936,44769],[2311,3936,44904],
 [2311,3936,46593],[2311,3936,47575],[2311,3937,3507],[2311,3937,3930],[2311,3937,4193],
 [2311,3937,38591],[2311,3937,44695],[2311,3937,44702],[2311,3937,44769],[2311,3937,44904],
 [2311,3937,46593],[2311,3937,47575],[2311,3941,3507],[2311,3941,3930],[2311,3941,4193],
 [2311,3941,38591],[2311,3941,44695],[2311,3941,44702],[2311,3941,44769],[2311,3941,44904],
 [2311,3941,46593],[2311,3941,47575],[2311,3998,3507],[2311,3998,3930],[2311,3998,4193],
 [2311,3998,38591],[2311,3998,44695],[2311,3998,44702],[2311,3998,44769],[2311,3998,44904],
 [2311,3998,46593],[2311,3998,47575],[2311,3999,3507],[2311,3999,3930],[2311,3999,4193],
 [2311,3999,38591],[2311,3999,44695],[2311,3999,44702],[2311,3999,44769],[2311,3999,44904],
 [2311,3999,46593],[2311,3999,47575],[2311,4000,3507],[2311,4000,3930],[2311,4000,4193],
 [2311,4000,38591],[2311,4000,44695],[2311,4000,44702],[2311,4000,44769],[2311,4000,44904],
 [2311,4000,46593],[2311,4000,47575],[2311,4004,3507],[2311,4004,3930],[2311,4004,4193],
 [2311,4004,38591],[2311,4004,44695],[2311,4004,44702],[2311,4004,44769],[2311,4004,44904],
 [2311,4004,46593],[2311,4004,47575],[2311,4140,3507],[2311,4140,3930],[2311,4140,4193],
 [2311,4140,38591],[2311,4140,44695],[2311,4140,44702],[2311,4140,44769],[2311,4140,44904],
 [2311,4140,46593],[2311,4140,47575],[2311,4144,3507],[2311,4144,3930],[2311,4144,4193],
 [2311,4144,38591],[2311,4144,44695],[2311,4144,44702],[2311,4144,44769],[2311,4144,44904],
 [2311,4144,46593],[2311,4144,47575],[2311,4146,3507],[2311,4146,3525,3507],
 [2311,4146,3525,45084],[2311,4146,3526,3507],[2311,4146,3526,45084],[2311,4146,3841,3507],
 [2311,4146,3841,45084],[2311,4146,3842,3507],[2311,4146,3842,45084],[2311,4146,4319,3507],
 [2311,4146,4319,45084],[2311,4146,38502,3507],[2311,4146,38502,45084],[2311,4146,38503,3507],
 [2311,4146,38503,45084],[2311,4146,38980,3507],[2311,4146,38980,45084],[2311,4146,44904],
 [2311,4146,44911,44904],[2311,4146,44911,45084],[2311,4146,44912,44904],
 [2311,4146,44912,45084],[2311,4146,44936,44904],[2311,4146,44936,45084],
 [2311,4146,44937,44904],[2311,4146,44937,45084],[2311,4146,45084],[2311,4146,49476,44904],
 [2311,4146,49476,45084],[2311,4146,49477,44904],[2311,4146,49477,45084],
 [2311,4146,49624,44904],[2311,4146,49624,45084],[2311,4146,49924,44904],
 [2311,4146,49924,45084],[2311,4147,3507],[2311,4147,44904],[2311,4147,45084],
 [2311,4165,3507],[2311,4165,3930],[2311,4165,4193],[2311,4165,38591],[2311,4165,44695],
 [2311,4165,44702],[2311,4165,44769],[2311,4165,44904],[2311,4165,46593],[2311,4165,47575],
 [2311,4169,3507],[2311,4169,3930],[2311,4169,4193],[2311,4169,38591],[2311,4169,44695],
 [2311,4169,44702],[2311,4169,44769],[2311,4169,44904],[2311,4169,46593],[2311,4169,47575],
 [2311,4171,3507],[2311,4171,44904],[2311,4171,45084],[2311,4172,3507],[2311,4172,44904],
 [2311,4172,45084],[2311,4193],[2311,4195,3507],[2311,4195,4193],[2311,4195,44960,45084],
 [2311,4195,44961,45084],[2311,4195,45046,45084],[2311,4195,45047,45084],[2311,4195,45084],
 [2311,4195,50200,45084],[2311,4195,51084,45084],[2311,4196,3507],[2311,4196,4193],
 [2311,4196,45084],[2311,4281,3507],[2311,4281,4193],[2311,4281,45084],[2311,4282,3507],
 [2311,4282,4193],[2311,4282,45084],[2311,5705],[2311,5971,5698,5705],
 [2311,5971,5698,46593],[2311,5971,5705],[2311,5971,5711,5705],[2311,5971,5711,46593],
 [2311,5971,6080,5705],[2311,5971,6080,46593],[2311,5971,6086,5705],[2311,5971,6086,46593],
 [2311,5971,6289,5705],[2311,5971,6289,46593],[2311,5971,39499,5705],[2311,5971,39499,46593],
 [2311,5971,39505,5705],[2311,5971,39505,46593],[2311,5971,39708,5705],
 [2311,5971,39708,46593],[2311,5971,44904],[2311,5971,46593],[2311,5973,5700,5705],
 [2311,5973,5700,6152],[2311,5973,5705],[2311,5973,5707,5705],[2311,5973,5707,6340],
 [2311,5973,5707,39759],[2311,5973,5707,49500],[2311,5973,5713,5705],[2311,5973,5713,6340],
 [2311,5973,5713,39759],[2311,5973,5713,49500],[2311,5973,5714,5705],[2311,5973,5714,6152],
 [2311,5973,6143,5705],[2311,5973,6143,6152],[2311,5973,6152],[2311,5973,6285,5705],
 [2311,5973,6285,6340],[2311,5973,6285,39759],[2311,5973,6285,49500],[2311,5973,6291,5705],
 [2311,5973,6291,6340],[2311,5973,6291,39759],[2311,5973,6291,49500],[2311,5973,6292,5705],
 [2311,5973,6292,6152],[2311,5973,6340],[2311,5973,39562,5705],[2311,5973,39562,6152],
 [2311,5973,39571,5705],[2311,5973,39571,6152],[2311,5973,39704,5705],[2311,5973,39704,6340],
 [2311,5973,39704,39759],[2311,5973,39704,49500],[2311,5973,39710,5705],
 [2311,5973,39710,6340],[2311,5973,39710,39759],[2311,5973,39710,49500],
 [2311,5973,39711,5705],[2311,5973,39711,6152],[2311,5973,39759],[2311,5973,44904],
 [2311,5973,45084],[2311,5973,47556],[2311,5973,47557,5705],[2311,5973,47557,6152],
 [2311,5973,47575],[2311,5973,47581,47575],[2311,5973,47605,47575],[2311,5973,49500],
 [2311,5973,49501],[2311,5973,49800,47575],[2311,5980,5705],[2311,5980,6152],
 [2311,5980,6340],[2311,5980,39759],[2311,5980,44904],[2311,5980,45084],[2311,5980,47556],
 [2311,5980,47575],[2311,5980,49500],[2311,5980,49501],[2311,5984,5705],[2311,5984,44904],
 [2311,5984,46593],[2311,5986,5705],[2311,5986,6152],[2311,5986,6340],[2311,5986,39759],
 [2311,5986,44904],[2311,5986,45084],[2311,5986,47556],[2311,5986,47575],[2311,5986,49500],
 [2311,5986,49501],[2311,5987,5705],[2311,5987,6152],[2311,5987,6340],[2311,5987,39759],
 [2311,5987,44904],[2311,5987,45084],[2311,5987,47556],[2311,5987,47575],[2311,5987,49500],
 [2311,5987,49501],[2311,6075,5705],[2311,6075,6152],[2311,6075,46593],
 [2311,6075,46596,46593],[2311,6075,46731,46593],[2311,6075,49587,46593],[2311,6081,5705],
 [2311,6081,44904],[2311,6081,46593],[2311,6089,5705],[2311,6089,6152],[2311,6089,46593],
 [2311,6144,5705],[2311,6144,6152],[2311,6144,6340],[2311,6144,39759],[2311,6144,44904],
 [2311,6144,45084],[2311,6144,47556],[2311,6144,47575],[2311,6144,49500],[2311,6144,49501],
 [2311,6145,5705],[2311,6145,6152],[2311,6145,6340],[2311,6145,39759],[2311,6145,44904],
 [2311,6145,45084],[2311,6145,47556],[2311,6145,47575],[2311,6145,49500],[2311,6145,49501],
 [2311,6149,5705],[2311,6149,6152],[2311,6149,46593],[2311,6151,5705],[2311,6151,6152],
 [2311,6151,6340],[2311,6151,39759],[2311,6151,44904],[2311,6151,45084],[2311,6151,47556],
 [2311,6151,47575],[2311,6151,49500],[2311,6151,49501],[2311,6152],[2311,6310,5705],
 [2311,6310,6152],[2311,6310,6340],[2311,6310,39759],[2311,6310,44904],[2311,6310,45084],
 [2311,6310,47556],[2311,6310,47575],[2311,6310,49500],[2311,6310,49501],[2311,6314,5705],
 [2311,6314,44904],[2311,6314,46593],[2311,6316,5705],[2311,6316,6152],[2311,6316,6340],
 [2311,6316,39759],[2311,6316,44904],[2311,6316,45084],[2311,6316,47556],[2311,6316,47575],
 [2311,6316,49500],[2311,6316,49501],[2311,6317,5705],[2311,6317,6152],[2311,6317,6340],
 [2311,6317,39759],[2311,6317,44904],[2311,6317,45084],[2311,6317,47556],[2311,6317,47575],
 [2311,6317,49500],[2311,6317,49501],[2311,6340],[2311,6341,5705],[2311,6341,6152],
 [2311,6341,6340],[2311,6341,39759],[2311,6341,44904],[2311,6341,45084],[2311,6341,47556],
 [2311,6341,47575],[2311,6341,49500],[2311,6341,49501],[2311,6427,5705],[2311,6427,6152],
 [2311,6427,46593],[2311,6464,5705],[2311,6464,6152],[2311,6464,6340],[2311,6464,39759],
 [2311,6464,44904],[2311,6464,45084],[2311,6464,47556],[2311,6464,47575],[2311,6464,49500],
 [2311,6464,49501],[2311,7828],[2311,8051,7820,7828],[2311,8051,7820,8168],[2311,8051,7828],
 [2311,8051,7833,7828],[2311,8051,7833,8507],[2311,8051,7833,40707],[2311,8051,7833,49887],
 [2311,8051,7835,7828],[2311,8051,7835,8168],[2311,8051,7836,7828],[2311,8051,7836,8507],
 [2311,8051,7836,40707],[2311,8051,7836,49887],[2311,8051,8161,7828],[2311,8051,8161,8168],
 [2311,8051,8168],[2311,8051,8394,7828],[2311,8051,8394,8507],[2311,8051,8394,40707],
 [2311,8051,8394,49887],[2311,8051,8396,7828],[2311,8051,8396,8168],[2311,8051,8397,7828],
 [2311,8051,8397,8507],[2311,8051,8397,40707],[2311,8051,8397,49887],[2311,8051,8507],
 [2311,8051,40361,7828],[2311,8051,40361,8168],[2311,8051,40368,7828],[2311,8051,40368,8168],
 [2311,8051,40594,7828],[2311,8051,40594,8507],[2311,8051,40594,40707],
 [2311,8051,40594,49887],[2311,8051,40596,7828],[2311,8051,40596,8168],[2311,8051,40597,7828],
 [2311,8051,40597,8507],[2311,8051,40597,40707],[2311,8051,40597,49887],[2311,8051,40707],
 [2311,8051,44904],[2311,8051,45084],[2311,8051,46593],[2311,8051,46620,7828],
 [2311,8051,46620,8168],[2311,8051,46621],[2311,8051,49886],[2311,8051,49887],
 [2311,8053,7822,7828],[2311,8053,7822,47575],[2311,8053,7828],[2311,8053,7829,7828],
 [2311,8053,7829,47575],[2311,8053,8224,7828],[2311,8053,8224,47575],[2311,8053,8225,7828],
 [2311,8053,8225,47575],[2311,8053,8390,7828],[2311,8053,8390,47575],[2311,8053,40424,7828],
 [2311,8053,40424,47575],[2311,8053,40425,7828],[2311,8053,40425,47575],
 [2311,8053,40590,7828],[2311,8053,40590,47575],[2311,8053,44904],[2311,8053,47575],
 [2311,8060,7828],[2311,8060,44904],[2311,8060,47575],[2311,8064,7828],[2311,8064,8168],
 [2311,8064,8507],[2311,8064,40707],[2311,8064,44904],[2311,8064,45084],[2311,8064,46593],
 [2311,8064,46621],[2311,8064,49886],[2311,8064,49887],[2311,8066,7828],[2311,8066,8168],
 [2311,8066,8507],[2311,8066,40707],[2311,8066,44904],[2311,8066,45084],[2311,8066,46593],
 [2311,8066,46621],[2311,8066,49886],[2311,8066,49887],[2311,8067,7828],[2311,8067,8168],
 [2311,8067,8507],[2311,8067,40707],[2311,8067,44904],[2311,8067,45084],[2311,8067,46593],
 [2311,8067,46621],[2311,8067,49886],[2311,8067,49887],[2311,8155,7828],[2311,8155,8168],
 [2311,8155,47575],[2311,8160,7828],[2311,8160,8168],[2311,8160,8507],[2311,8160,40707],
 [2311,8160,44904],[2311,8160,45084],[2311,8160,46593],[2311,8160,46621],[2311,8160,49886],
 [2311,8160,49887],[2311,8162,7828],[2311,8162,8168],[2311,8162,47575],[2311,8166,7828],
 [2311,8166,8168],[2311,8166,8507],[2311,8166,40707],[2311,8166,44904],[2311,8166,45084],
 [2311,8166,46593],[2311,8166,46621],[2311,8166,49886],[2311,8166,49887],[2311,8168],
 [2311,8169,7828],[2311,8169,8168],[2311,8169,8507],[2311,8169,40707],[2311,8169,44904],
 [2311,8169,45084],[2311,8169,46593],[2311,8169,46621],[2311,8169,49886],[2311,8169,49887],
 [2311,8223,7828],[2311,8223,44904],[2311,8223,47575],[2311,8231,7828],[2311,8231,8168],
 [2311,8231,47575],[2311,8365,7828],[2311,8365,44904],[2311,8365,47575],[2311,8369,7828],
 [2311,8369,8168],[2311,8369,8507],[2311,8369,40707],[2311,8369,44904],[2311,8369,45084],
 [2311,8369,46593],[2311,8369,46621],[2311,8369,49886],[2311,8369,49887],[2311,8371,7828],
 [2311,8371,8168],[2311,8371,8507],[2311,8371,40707],[2311,8371,44904],[2311,8371,45084],
 [2311,8371,46593],[2311,8371,46621],[2311,8371,49886],[2311,8371,49887],[2311,8372,7828],
 [2311,8372,8168],[2311,8372,8507],[2311,8372,40707],[2311,8372,44904],[2311,8372,45084],
 [2311,8372,46593],[2311,8372,46621],[2311,8372,49886],[2311,8372,49887],[2311,8420,7828],
 [2311,8420,8168],[2311,8420,47575],[2311,8506,7828],[2311,8506,8168],[2311,8506,8507],
 [2311,8506,40707],[2311,8506,44904],[2311,8506,45084],[2311,8506,46593],[2311,8506,46621],
 [2311,8506,49886],[2311,8506,49887],[2311,8507],[2311,8544,7828],[2311,8544,8168],
 [2311,8544,8507],[2311,8544,40707],[2311,8544,44904],[2311,8544,45084],[2311,8544,46593],
 [2311,8544,46621],[2311,8544,49886],[2311,8544,49887],[2311,38205],[2311,38591],
 [2311,39759],[2311,40707],[2311,44695],[2311,44702],[2311,44708,7828],[2311,44708,8168],
 [2311,44708,8507],[2311,44708,40707],[2311,44708,44904],[2311,44708,45084],
 [2311,44708,46593],[2311,44708,46621],[2311,44708,49886],[2311,44708,49887],
 [2311,44709,7828],[2311,44709,8168],[2311,44709,8507],[2311,44709,40707],[2311,44709,44904],
 [2311,44709,45084],[2311,44709,46593],[2311,44709,46621],[2311,44709,49886],
 [2311,44709,49887],[2311,44769],[2311,44771,5705],[2311,44771,6152],[2311,44771,6340],
 [2311,44771,39759],[2311,44771,44904],[2311,44771,45084],[2311,44771,47556],
 [2311,44771,47575],[2311,44771,49500],[2311,44771,49501],[2311,44772,5705],
 [2311,44772,6152],[2311,44772,6340],[2311,44772,39759],[2311,44772,44904],
 [2311,44772,45084],[2311,44772,47556],[2311,44772,47575],[2311,44772,49500],
 [2311,44772,49501],[2311,44904],[2311,45084],[2311,46455,7828],[2311,46455,8168],
 [2311,46455,47575],[2311,46456,5705],[2311,46456,6152],[2311,46456,46593],[2311,46589,3507],
 [2311,46589,3930],[2311,46589,4193],[2311,46589,38591],[2311,46589,44695],
 [2311,46589,44702],[2311,46589,44769],[2311,46589,44904],[2311,46589,46593],
 [2311,46589,47575],[2311,46593],[2311,46595,7828],[2311,46595,8168],[2311,46595,8507],
 [2311,46595,40707],[2311,46595,44904],[2311,46595,45084],[2311,46595,46593],
 [2311,46595,46621],[2311,46595,49886],[2311,46595,49887],[2311,46621],[2311,46642,3507],
 [2311,46642,3930],[2311,46642,4193],[2311,46642,38591],[2311,46642,44695],
 [2311,46642,44702],[2311,46642,44769],[2311,46642,44904],[2311,46642,46593],
 [2311,46642,47575],[2311,46644,7828],[2311,46644,8168],[2311,46644,47575],[2311,46645],
 [2311,46730,7828],[2311,46730,8168],[2311,46730,8507],[2311,46730,40707],[2311,46730,44904],
 [2311,46730,45084],[2311,46730,46593],[2311,46730,46621],[2311,46730,49886],
 [2311,46730,49887],[2311,46768,7828],[2311,46768,8168],[2311,46768,8507],[2311,46768,40707],
 [2311,46768,44904],[2311,46768,45084],[2311,46768,46593],[2311,46768,46621],
 [2311,46768,49886],[2311,46768,49887],[2311,47556],[2311,47575],[2311,47579,3507],
 [2311,47579,3930],[2311,47579,4193],[2311,47579,38591],[2311,47579,44695],
 [2311,47579,44702],[2311,47579,44769],[2311,47579,44904],[2311,47579,46593],
 [2311,47579,47575],[2311,47582,5705],[2311,47582,6152],[2311,47582,6340],[2311,47582,39759],
 [2311,47582,44904],[2311,47582,45084],[2311,47582,47556],[2311,47582,47575],
 [2311,47582,49500],[2311,47582,49501],[2311,47603,3507],[2311,47603,3930],[2311,47603,4193],
 [2311,47603,38591],[2311,47603,44695],[2311,47603,44702],[2311,47603,44769],
 [2311,47603,44904],[2311,47603,46593],[2311,47603,47575],[2311,47606,5705],
 [2311,47606,6152],[2311,47606,6340],[2311,47606,39759],[2311,47606,44904],
 [2311,47606,45084],[2311,47606,47556],[2311,47606,47575],[2311,47606,49500],
 [2311,47606,49501],[2311,47691],[2311,47692,5705],[2311,47692,6152],[2311,47692,46593],
 [2311,47729,5705],[2311,47729,6152],[2311,47729,6340],[2311,47729,39759],[2311,47729,44904],
 [2311,47729,45084],[2311,47729,47556],[2311,47729,47575],[2311,47729,49500],
 [2311,47729,49501],[2311,49498,3507],[2311,49498,3930],[2311,49498,4193],[2311,49498,38591],
 [2311,49498,44695],[2311,49498,44702],[2311,49498,44769],[2311,49498,44904],
 [2311,49498,46593],[2311,49498,47575],[2311,49500],[2311,49501],[2311,49586,7828],
 [2311,49586,8168],[2311,49586,8507],[2311,49586,40707],[2311,49586,44904],
 [2311,49586,45084],[2311,49586,46593],[2311,49586,46621],[2311,49586,49886],
 [2311,49586,49887],[2311,49798,3507],[2311,49798,3930],[2311,49798,4193],[2311,49798,38591],
 [2311,49798,44695],[2311,49798,44702],[2311,49798,44769],[2311,49798,44904],
 [2311,49798,46593],[2311,49798,47575],[2311,49801,5705],[2311,49801,6152],[2311,49801,6340],
 [2311,49801,39759],[2311,49801,44904],[2311,49801,45084],[2311,49801,47556],
 [2311,49801,47575],[2311,49801,49500],[2311,49801,49501],[2311,49886],[2311,49887],
 [2311,50162,3507],[2311,50162,4193],[2311,50162,45084],[2311,50163,3507],[2311,50163,4193],
 [2311,50163,45084],[2312,1291],[2312,1306],[2312,1336],[2312,1377],[2312,1432],
 [2312,1625],[2312,1658],[2312,1698],[2312,1761],[2312,2279],[2312,3507],[2312,3677],
 [2312,3714],[2312,5705],[2312,6018],[2312,6050],[2312,7828],[2312,7875],[2312,7950],
 [2312,38205],[2312,38304],[2312,38331],[2312,38557],[2312,38921],[2312,39193],
 [2312,39424],[2312,39779],[2312,40055],[2312,40287],[2312,40642],[2312,41069],
 [2312,41217],[2312,41411],[2312,41850],[2312,41900],[2312,42193],[2312,42593],
 [2312,42936],[2312,44904],[2312,45501],[2312,46064],[2312,47090],[2313,2279],
 [2313,3507],[2313,3930],[2313,4193],[2313,5705],[2313,6152],[2313,6340],[2313,7828],
 [2313,8168],[2313,8507],[2313,38205],[2313,38591],[2313,39759],[2313,40707],[2313,44695],
 [2313,44702],[2313,44769],[2313,44904],[2313,45084],[2313,46593],[2313,46621],
 [2313,46645],[2313,47556],[2313,47575],[2313,47691],[2313,49500],[2313,49501],
 [2313,49886],[2313,49887],[2314,2279],[2314,3507],[2314,3756],[2314,3794],[2314,5705],
 [2314,6183],[2314,6213],[2314,7828],[2314,7996],[2314,8032],[2314,38205],[2314,38418],
 [2314,38454],[2314,38455],[2314,39015],[2314,39313],[2314,39602],[2314,39603],
 [2314,39631],[2314,40195],[2314,40196],[2314,40233],[2314,40450],[2314,43536],
 [2314,43643],[2314,43965],[2314,44174],[2314,44904],[2314,47993],[2315,2279],
 [2315,3507],[2315,3756],[2315,3794],[2315,5705],[2315,6183],[2315,6213],[2315,7828],
 [2315,7996],[2315,8032],[2315,38205],[2315,38418],[2315,38454],[2315,38455],[2315,39015],
 [2315,39313],[2315,39602],[2315,39603],[2315,39631],[2315,40195],[2315,40196],
 [2315,40233],[2315,40450],[2315,43536],[2315,43643],[2315,43965],[2315,44174],
 [2315,44904],[2315,47993],[2316,2279],[2317,2279],[2320,2279],[2320,3507],[2320,3930],
 [2320,4193],[2320,5705],[2320,6152],[2320,6340],[2320,7828],[2320,8168],[2320,8507],
 [2320,38205],[2320,38591],[2320,39759],[2320,40707],[2320,44695],[2320,44702],
 [2320,44769],[2320,44904],[2320,45084],[2320,46593],[2320,46621],[2320,46645],
 [2320,47556],[2320,47575],[2320,47691],[2320,49500],[2320,49501],[2320,49886],
 [2320,49887],[2321,2279],[2321,3714],[2321,6050],[2321,7950],[2321,42671],[2322,2279],
 [2323,1291],[2323,1306],[2323,1336],[2323,1377],[2323,1432],[2323,1625],[2323,1658],
 [2323,1698],[2323,1761],[2323,2279],[2323,3507],[2323,3677],[2323,3714],[2323,5705],
 [2323,6018],[2323,6050],[2323,7828],[2323,7875],[2323,7950],[2323,38205],[2323,38304],
 [2323,38331],[2323,38557],[2323,38921],[2323,39193],[2323,39424],[2323,39779],
 [2323,40055],[2323,40287],[2323,40642],[2323,41069],[2323,41217],[2323,41411],
 [2323,41850],[2323,41900],[2323,42193],[2323,42593],[2323,42936],[2323,44904],
 [2323,45501],[2323,46064],[2323,47090],[2324,2279],[2324,3507],[2324,3930],[2324,4193],
 [2324,5705],[2324,6152],[2324,6340],[2324,7828],[2324,8168],[2324,8507],[2324,38205],
 [2324,38591],[2324,39759],[2324,40707],[2324,44695],[2324,44702],[2324,44769],
 [2324,44904],[2324,45084],[2324,46593],[2324,46621],[2324,46645],[2324,47556],
 [2324,47575],[2324,47691],[2324,49500],[2324,49501],[2324,49886],[2324,49887],
 [2325,1291],[2325,1306],[2325,1336],[2325,1377],[2325,1432],[2325,1625],[2325,1658],
 [2325,1698],[2325,1761],[2325,2279],[2325,3507],[2325,3677],[2325,3714],[2325,5705],
 [2325,6018],[2325,6050],[2325,7828],[2325,7875],[2325,7950],[2325,38205],[2325,38304],
 [2325,38331],[2325,38557],[2325,38921],[2325,39193],[2325,39424],[2325,39779],
 [2325,40055],[2325,40287],[2325,40642],[2325,41069],[2325,41217],[2325,41411],
 [2325,41850],[2325,41900],[2325,42193],[2325,42593],[2325,42936],[2325,44904],
 [2325,45501],[2325,46064],[2325,47090],[2326,2279],[2326,3507],[2326,3930],[2326,4193],
 [2326,5705],[2326,6152],[2326,6340],[2326,7828],[2326,8168],[2326,8507],[2326,38205],
 [2326,38591],[2326,39759],[2326,40707],[2326,44695],[2326,44702],[2326,44769],
 [2326,44904],[2326,45084],[2326,46593],[2326,46621],[2326,46645],[2326,47556],
 [2326,47575],[2326,47691],[2326,49500],[2326,49501],[2326,49886],[2326,49887],
 [2327,2279],[2327,3507],[2327,3930],[2327,4193],[2327,5705],[2327,6152],[2327,6340],
 [2327,7828],[2327,8168],[2327,8507],[2327,38205],[2327,38591],[2327,39759],[2327,40707],
 [2327,44695],[2327,44702],[2327,44769],[2327,44904],[2327,45084],[2327,46593],
 [2327,46621],[2327,46645],[2327,47556],[2327,47575],[2327,47691],[2327,49500],
 [2327,49501],[2327,49886],[2327,49887],[2328,2279],[2328,3507],[2328,3756],[2328,3794],
 [2328,5705],[2328,6183],[2328,6213],[2328,7828],[2328,7996],[2328,8032],[2328,38205],
 [2328,38418],[2328,38454],[2328,38455],[2328,39015],[2328,39313],[2328,39602],
 [2328,39603],[2328,39631],[2328,40195],[2328,40196],[2328,40233],[2328,40450],
 [2328,43536],[2328,43643],[2328,43965],[2328,44174],[2328,44904],[2328,47993],
 [2329,2279],[2329,3507],[2329,3756],[2329,3794],[2329,5705],[2329,6183],[2329,6213],
 [2329,7828],[2329,7996],[2329,8032],[2329,38205],[2329,38418],[2329,38454],[2329,38455],
 [2329,39015],[2329,39313],[2329,39602],[2329,39603],[2329,39631],[2329,40195],
 [2329,40196],[2329,40233],[2329,40450],[2329,43536],[2329,43643],[2329,43965],
 [2329,44174],[2329,44904],[2329,47993],[2330,2279],[2331,2279],[2332,2279],[2333,2279],
 [2334,2279],[2335,2279],[2336,2279],[2337,2279],[2338,2279],[2339,2279],[2340,2279],
 [2341,2279],[2342,2279],[2343,2279],[2344,2279],[2345,2279],[2346,2279],[2347,2279],
 [2348,2279],[2349,2279],[2350,2279],[2351,2279],[2352,2279],[2353,2279],[2354,2279],
 [2355,2279],[2356,2279],[2357,2279],[2358,2279],[2359,2279],[2360,2279],[2361,2279],
 [2362,2279],[2363,2279],[2364,2279],[2368,1291],[2368,1306],[2368,1336],[2368,1377],
 [2368,1432],[2368,1625],[2368,1658],[2368,1698],[2368,1761],[2368,2279],[2368,3507],
 [2368,3677],[2368,3714],[2368,5705],[2368,6018],[2368,6050],[2368,7828],[2368,7875],
 [2368,7950],[2368,38205],[2368,38304],[2368,38331],[2368,38557],[2368,38921],
 [2368,39193],[2368,39424],[2368,39779],[2368,40055],[2368,40287],[2368,40642],
 [2368,41069],[2368,41217],[2368,41411],[2368,41850],[2368,41900],[2368,42193],
 [2368,42593],[2368,42936],[2368,44904],[2368,45501],[2368,46064],[2368,47090],
 [2369,1291],[2369,1306],[2369,1336],[2369,1377],[2369,1432],[2369,1625],[2369,1658],
 [2369,1698],[2369,1761],[2369,2279],[2369,3507],[2369,3677],[2369,3714],[2369,5705],
 [2369,6018],[2369,6050],[2369,7828],[2369,7875],[2369,7950],[2369,38205],[2369,38304],
 [2369,38331],[2369,38557],[2369,38921],[2369,39193],[2369,39424],[2369,39779],
 [2369,40055],[2369,40287],[2369,40642],[2369,41069],[2369,41217],[2369,41411],
 [2369,41850],[2369,41900],[2369,42193],[2369,42593],[2369,42936],[2369,44904],
 [2369,45501],[2369,46064],[2369,47090],[2370,2279],[2370,3714],[2370,6050],[2370,7950],
 [2370,42671],[2371,2279],[2371,3507],[2371,3756],[2371,3794],[2371,5705],[2371,6183],
 [2371,6213],[2371,7828],[2371,7996],[2371,8032],[2371,38205],[2371,38418],[2371,38454],
 [2371,38455],[2371,39015],[2371,39313],[2371,39602],[2371,39603],[2371,39631],
 [2371,40195],[2371,40196],[2371,40233],[2371,40450],[2371,43536],[2371,43643],
 [2371,43965],[2371,44174],[2371,44904],[2371,47993],[2372,2279],[2372,3507],[2372,3756],
 [2372,3794],[2372,5705],[2372,6183],[2372,6213],[2372,7828],[2372,7996],[2372,8032],
 [2372,38205],[2372,38418],[2372,38454],[2372,38455],[2372,39015],[2372,39313],
 [2372,39602],[2372,39603],[2372,39631],[2372,40195],[2372,40196],[2372,40233],
 [2372,40450],[2372,43536],[2372,43643],[2372,43965],[2372,44174],[2372,44904],
 [2372,47993],[2374,1291],[2374,1306],[2374,1336],[2374,1377],[2374,1432],[2374,1625],
 [2374,1658],[2374,1698],[2374,1761],[2374,2279],[2374,3507],[2374,3677],[2374,3714],
 [2374,5705],[2374,6018],[2374,6050],[2374,7828],[2374,7875],[2374,7950],[2374,38205],
 [2374,38304],[2374,38331],[2374,38557],[2374,38921],[2374,39193],[2374,39424],
 [2374,39779],[2374,40055],[2374,40287],[2374,40642],[2374,41069],[2374,41217],
 [2374,41411],[2374,41850],[2374,41900],[2374,42193],[2374,42593],[2374,42936],
 [2374,44904],[2374,45501],[2374,46064],[2374,47090],[2375,2279],[2375,3714],[2375,6050],
 [2375,7950],[2375,42671],[2376,2279],[2376,3507],[2376,3930],[2376,4193],[2376,5705],
 [2376,6152],[2376,6340],[2376,7828],[2376,8168],[2376,8507],[2376,38205],[2376,38591],
 [2376,39759],[2376,40707],[2376,44695],[2376,44702],[2376,44769],[2376,44904],
 [2376,45084],[2376,46593],[2376,46621],[2376,46645],[2376,47556],[2376,47575],
 [2376,47691],[2376,49500],[2376,49501],[2376,49886],[2376,49887],[2377,1291],
 [2377,1306],[2377,1336],[2377,1377],[2377,1432],[2377,1625],[2377,1658],[2377,1698],
 [2377,1761],[2377,2279],[2377,3507],[2377,3677],[2377,3714],[2377,5705],[2377,6018],
 [2377,6050],[2377,7828],[2377,7875],[2377,7950],[2377,38205],[2377,38304],[2377,38331],
 [2377,38557],[2377,38921],[2377,39193],[2377,39424],[2377,39779],[2377,40055],
 [2377,40287],[2377,40642],[2377,41069],[2377,41217],[2377,41411],[2377,41850],
 [2377,41900],[2377,42193],[2377,42593],[2377,42936],[2377,44904],[2377,45501],
 [2377,46064],[2377,47090],[2378,2279],[2378,3507],[2378,3930],[2378,4193],[2378,5705],
 [2378,6152],[2378,6340],[2378,7828],[2378,8168],[2378,8507],[2378,38205],[2378,38591],
 [2378,39759],[2378,40707],[2378,44695],[2378,44702],[2378,44769],[2378,44904],
 [2378,45084],[2378,46593],[2378,46621],[2378,46645],[2378,47556],[2378,47575],
 [2378,47691],[2378,49500],[2378,49501],[2378,49886],[2378,49887],[2379,2279],
 [2379,3507],[2379,3756],[2379,3794],[2379,5705],[2379,6183],[2379,6213],[2379,7828],
 [2379,7996],[2379,8032],[2379,38205],[2379,38418],[2379,38454],[2379,38455],[2379,39015],
 [2379,39313],[2379,39602],[2379,39603],[2379,39631],[2379,40195],[2379,40196],
 [2379,40233],[2379,40450],[2379,43536],[2379,43643],[2379,43965],[2379,44174],
 [2379,44904],[2379,47993],[2380,2279],[2380,3507],[2380,3756],[2380,3794],[2380,5705],
 [2380,6183],[2380,6213],[2380,7828],[2380,7996],[2380,8032],[2380,38205],[2380,38418],
 [2380,38454],[2380,38455],[2380,39015],[2380,39313],[2380,39602],[2380,39603],
 [2380,39631],[2380,40195],[2380,40196],[2380,40233],[2380,40450],[2380,43536],
 [2380,43643],[2380,43965],[2380,44174],[2380,44904],[2380,47993],[2381,2279],
 [2382,2279],[2385,2279],[2385,3507],[2385,3930],[2385,4193],[2385,5705],[2385,6152],
 [2385,6340],[2385,7828],[2385,8168],[2385,8507],[2385,38205],[2385,38591],[2385,39759],
 [2385,40707],[2385,44695],[2385,44702],[2385,44769],[2385,44904],[2385,45084],
 [2385,46593],[2385,46621],[2385,46645],[2385,47556],[2385,47575],[2385,47691],
 [2385,49500],[2385,49501],[2385,49886],[2385,49887],[2386,2279],[2386,3714],[2386,6050],
 [2386,7950],[2386,42671],[2387,2279],[2388,1291],[2388,1306],[2388,1336],[2388,1377],
 [2388,1432],[2388,1625],[2388,1658],[2388,1698],[2388,1761],[2388,2279],[2388,3507],
 [2388,3677],[2388,3714],[2388,5705],[2388,6018],[2388,6050],[2388,7828],[2388,7875],
 [2388,7950],[2388,38205],[2388,38304],[2388,38331],[2388,38557],[2388,38921],
 [2388,39193],[2388,39424],[2388,39779],[2388,40055],[2388,40287],[2388,40642],
 [2388,41069],[2388,41217],[2388,41411],[2388,41850],[2388,41900],[2388,42193],
 [2388,42593],[2388,42936],[2388,44904],[2388,45501],[2388,46064],[2388,47090],
 [2389,2279],[2389,3507],[2389,3930],[2389,4193],[2389,5705],[2389,6152],[2389,6340],
 [2389,7828],[2389,8168],[2389,8507],[2389,38205],[2389,38591],[2389,39759],[2389,40707],
 [2389,44695],[2389,44702],[2389,44769],[2389,44904],[2389,45084],[2389,46593],
 [2389,46621],[2389,46645],[2389,47556],[2389,47575],[2389,47691],[2389,49500],
 [2389,49501],[2389,49886],[2389,49887],[2390,1291],[2390,1306],[2390,1336],[2390,1377],
 [2390,1432],[2390,1625],[2390,1658],[2390,1698],[2390,1761],[2390,2279],[2390,3507],
 [2390,3677],[2390,3714],[2390,5705],[2390,6018],[2390,6050],[2390,7828],[2390,7875],
 [2390,7950],[2390,38205],[2390,38304],[2390,38331],[2390,38557],[2390,38921],
 [2390,39193],[2390,39424],[2390,39779],[2390,40055],[2390,40287],[2390,40642],
 [2390,41069],[2390,41217],[2390,41411],[2390,41850],[2390,41900],[2390,42193],
 [2390,42593],[2390,42936],[2390,44904],[2390,45501],[2390,46064],[2390,47090],
 [2391,2279],[2391,3507],[2391,3930],[2391,4193],[2391,5705],[2391,6152],[2391,6340],
 [2391,7828],[2391,8168],[2391,8507],[2391,38205],[2391,38591],[2391,39759],[2391,40707],
 [2391,44695],[2391,44702],[2391,44769],[2391,44904],[2391,45084],[2391,46593],
 [2391,46621],[2391,46645],[2391,47556],[2391,47575],[2391,47691],[2391,49500],
 [2391,49501],[2391,49886],[2391,49887],[2392,2279],[2392,3507],[2392,3930],[2392,4193],
 [2392,5705],[2392,6152],[2392,6340],[2392,7828],[2392,8168],[2392,8507],[2392,38205],
 [2392,38591],[2392,39759],[2392,40707],[2392,44695],[2392,44702],[2392,44769],
 [2392,44904],[2392,45084],[2392,46593],[2392,46621],[2392,46645],[2392,47556],
 [2392,47575],[2392,47691],[2392,49500],[2392,49501],[2392,49886],[2392,49887],
 [2393,2279],[2393,3507],[2393,3756],[2393,3794],[2393,5705],[2393,6183],[2393,6213],
 [2393,7828],[2393,7996],[2393,8032],[2393,38205],[2393,38418],[2393,38454],[2393,38455],
 [2393,39015],[2393,39313],[2393,39602],[2393,39603],[2393,39631],[2393,40195],
 [2393,40196],[2393,40233],[2393,40450],[2393,43536],[2393,43643],[2393,43965],
 [2393,44174],[2393,44904],[2393,47993],[2394,2279],[2394,3507],[2394,3756],[2394,3794],
 [2394,5705],[2394,6183],[2394,6213],[2394,7828],[2394,7996],[2394,8032],[2394,38205],
 [2394,38418],[2394,38454],[2394,38455],[2394,39015],[2394,39313],[2394,39602],
 [2394,39603],[2394,39631],[2394,40195],[2394,40196],[2394,40233],[2394,40450],
 [2394,43536],[2394,43643],[2394,43965],[2394,44174],[2394,44904],[2394,47993],
 [2395,2279],[2396,2279],[2397,2279],[2398,2279],[2399,2279],[2400,2279],[2401,2279],
 [2402,2279],[2403,2279],[2404,2279],[2405,2279],[2406,2279],[2407,2279],[2408,2279],
 [2409,2279],[2410,8715],[2411,8715],[2413,202],[2413,1625],[2413,10077],[2413,17521],
 [2414,2849,3507],[2414,2857,3507],[2414,3507],[2414,8962],[2414,22152,3507],
 [2414,22478,44904],[2414,22479,44904],[2414,22784,44904],[2414,44904],[2416,3507],
 [2416,8962],[2416,44904],[2430,2429,3507],[2430,2437,3507],[2430,3507],[2430,9741,38205],
 [2430,9742,38205],[2430,9748,3507],[2430,9785,38205],[2430,38205],[2431,3507],
 [2431,38205],[2432,3507],[2432,9874,41069],[2432,9875,41069],[2432,10065,41069],
 [2432,41069],[2433,3677],[2433,3714],[2433,9918],[2433,9955],[2434,3677],[2434,3714],
 [2434,9918],[2434,9955],[2435,3756],[2436,3794],[2436,10035],[2438,3507],[2438,41069],
 [2439,3677],[2439,3714],[2439,9918],[2439,9955],[2440,3930],[2440,10171],[2441,3677],
 [2441,3714],[2441,9918],[2441,9955],[2442,3930],[2442,10171],[2443,3756],[2444,3794],
 [2444,10035],[2447,3507],[2447,10074,44904],[2447,10075,44904],[2447,10380,44904],
 [2447,44904],[2448,3507],[2448,44904],[2449,4193],[2450,202],[2450,1625],[2450,10077],
 [2450,17521],[2452,3507],[2452,9763,38921],[2452,9765,38921],[2452,10501,38921],
 [2452,38921],[2453,4193],[2454,3507],[2454,38921],[2455,3507],[2455,10082,45084],
 [2455,10083,45084],[2455,10560,45084],[2455,45084],[2456,3507],[2456,45084],[2457,3507],
 [2457,9768,39015],[2457,9769,39015],[2457,10595,39015],[2457,39015],[2458,3507],
 [2458,39015],[2474,8715],[2476,10854],[2477,10854],[2493,2492,3507],[2493,2500,3507],
 [2493,3507],[2493,11694,38205],[2493,11695,38205],[2493,11701,3507],[2493,11738,38205],
 [2493,38205],[2494,3507],[2494,38205],[2495,3507],[2495,11827,41069],[2495,11828,41069],
 [2495,12018,41069],[2495,41069],[2496,3677],[2496,3714],[2496,11871],[2496,11908],
 [2497,3677],[2497,3714],[2497,11871],[2497,11908],[2498,3756],[2499,3794],[2499,11988],
 [2501,3507],[2501,41069],[2502,3677],[2502,3714],[2502,11871],[2502,11908],[2503,3930],
 [2503,12124],[2504,3677],[2504,3714],[2504,11871],[2504,11908],[2505,3930],[2505,12124],
 [2506,3756],[2507,3794],[2507,11988],[2510,3507],[2510,12027,44904],[2510,12028,44904],
 [2510,12333,44904],[2510,44904],[2511,3507],[2511,44904],[2512,4193],[2515,3507],
 [2515,11716,38921],[2515,11718,38921],[2515,12454,38921],[2515,38921],[2516,4193],
 [2517,3507],[2517,38921],[2518,3507],[2518,12035,45084],[2518,12036,45084],
 [2518,12513,45084],[2518,45084],[2519,3507],[2519,45084],[2520,3507],[2520,11721,39015],
 [2520,11722,39015],[2520,12548,39015],[2520,39015],[2521,3507],[2521,39015],[2538,3507],
 [2538,12747],[2538,22278,41069],[2538,22279,41069],[2538,22469,41069],[2538,41069],
 [2539,328],[2541,3507],[2541,12747],[2541,41069],[2542,12979],[2543,12979],
 [2555,2554,3507],[2555,2562,3507],[2555,3507],[2555,13585,38205],[2555,13586,38205],
 [2555,13592,3507],[2555,13629,38205],[2555,38205],[2556,3507],[2556,38205],[2557,3507],
 [2557,13718,41069],[2557,13719,41069],[2557,13909,41069],[2557,41069],[2558,3677],
 [2558,13762],[2559,3714],[2559,13799],[2560,3756],[2561,3794],[2561,13879],[2563,3507],
 [2563,41069],[2564,3714],[2564,13799],[2565,3930],[2565,14015],[2566,3677],[2566,13762],
 [2567,3930],[2567,14015],[2568,3756],[2569,3794],[2569,13879],[2572,3507],
 [2572,13918,44904],[2572,13919,44904],[2572,14224,44904],[2572,44904],[2573,3507],
 [2573,44904],[2574,4193],[2577,3507],[2577,13607,38921],[2577,13609,38921],
 [2577,14345,38921],[2577,38921],[2578,4193],[2579,3507],[2579,38921],[2580,3507],
 [2580,13926,45084],[2580,13927,45084],[2580,14404,45084],[2580,45084],[2581,3507],
 [2581,45084],[2582,3507],[2582,13612,39015],[2582,13613,39015],[2582,14439,39015],
 [2582,39015],[2583,3507],[2583,39015],[2587,14514],[2588,14523],[2592,14523],
 [2593,14514],[2594,14565],[2595,14565],[2600,14635],[2601,14635],[2616,2615,3507],
 [2616,2623,3507],[2616,3507],[2616,15415,38205],[2616,15416,38205],[2616,15422,3507],
 [2616,15459,38205],[2616,38205],[2617,3507],[2617,38205],[2618,3507],[2618,15548,41069],
 [2618,15549,41069],[2618,15739,41069],[2618,41069],[2619,3677],[2619,15592],[2620,3714],
 [2620,15629],[2621,3756],[2622,3794],[2622,15709],[2624,3507],[2624,41069],[2625,3714],
 [2625,15629],[2626,3930],[2626,15845],[2627,3677],[2627,15592],[2628,3930],[2628,15845],
 [2629,3756],[2630,3794],[2630,15709],[2633,3507],[2633,15748,44904],[2633,15749,44904],
 [2633,16054,44904],[2633,44904],[2634,3507],[2634,44904],[2635,4193],[2638,3507],
 [2638,15437,38921],[2638,15439,38921],[2638,16175,38921],[2638,38921],[2639,4193],
 [2640,3507],[2640,38921],[2641,3507],[2641,15756,45084],[2641,15757,45084],
 [2641,16234,45084],[2641,45084],[2642,3507],[2642,45084],[2643,3507],[2643,15442,39015],
 [2643,15443,39015],[2643,16269,39015],[2643,39015],[2644,3507],[2644,39015],[2660,10854],
 [2662,3507],[2662,12747],[2662,41069],[2676,2675,3507],[2676,2683,3507],[2676,3507],
 [2676,17185,38205],[2676,17186,38205],[2676,17192,3507],[2676,17229,38205],[2676,38205],
 [2677,3507],[2677,38205],[2678,3507],[2678,17318,41069],[2678,17319,41069],
 [2678,17509,41069],[2678,41069],[2679,3677],[2679,3714],[2679,17362],[2679,17399],
 [2680,3677],[2680,3714],[2680,17362],[2680,17399],[2681,3756],[2682,3794],[2682,17479],
 [2684,3507],[2684,41069],[2685,3677],[2685,3714],[2685,17362],[2685,17399],[2686,3930],
 [2686,17615],[2687,3677],[2687,3714],[2687,17362],[2687,17399],[2688,3930],[2688,17615],
 [2689,3756],[2690,3794],[2690,17479],[2693,3507],[2693,17518,44904],[2693,17519,44904],
 [2693,17824,44904],[2693,44904],[2694,3507],[2694,44904],[2695,4193],[2696,202],
 [2696,1625],[2696,10077],[2696,17521],[2698,3507],[2698,17207,38921],[2698,17209,38921],
 [2698,17945,38921],[2698,38921],[2699,4193],[2700,3507],[2700,38921],[2701,3507],
 [2701,17526,45084],[2701,17527,45084],[2701,18004,45084],[2701,45084],[2702,3507],
 [2702,45084],[2703,3507],[2703,17212,39015],[2703,17213,39015],[2703,18039,39015],
 [2703,39015],[2704,3507],[2704,39015],[2720,14635],[2721,3507],[2721,8962],[2721,44904],
 [2735,2734,3507],[2735,2742,3507],[2735,3507],[2735,18896,38205],[2735,18897,38205],
 [2735,18903,3507],[2735,18940,38205],[2735,38205],[2736,3507],[2736,38205],[2737,3507],
 [2737,19029,41069],[2737,19030,41069],[2737,19220,41069],[2737,41069],[2738,3677],
 [2738,19073],[2739,3714],[2739,19110],[2740,3756],[2741,3794],[2741,19190],[2743,3507],
 [2743,41069],[2744,3714],[2744,19110],[2745,3930],[2745,19326],[2746,3677],[2746,19073],
 [2747,3930],[2747,19326],[2748,3756],[2749,3794],[2749,19190],[2752,3507],
 [2752,19229,44904],[2752,19230,44904],[2752,19535,44904],[2752,44904],[2753,3507],
 [2753,44904],[2754,4193],[2757,3507],[2757,18918,38921],[2757,18920,38921],
 [2757,19656,38921],[2757,38921],[2758,4193],[2759,3507],[2759,38921],[2760,3507],
 [2760,19237,45084],[2760,19238,45084],[2760,19715,45084],[2760,45084],[2761,3507],
 [2761,45084],[2762,3507],[2762,18923,39015],[2762,18924,39015],[2762,19750,39015],
 [2762,39015],[2763,3507],[2763,39015],[2769,19848],[2770,19857],[2771,19862],
 [2776,19862],[2777,19848],[2778,19857],[2793,2792,3507],[2793,2800,3507],[2793,3507],
 [2793,20549,38205],[2793,20550,38205],[2793,20556,3507],[2793,20593,38205],[2793,38205],
 [2794,3507],[2794,38205],[2795,3507],[2795,20682,41069],[2795,20683,41069],
 [2795,20873,41069],[2795,41069],[2796,3677],[2796,20726],[2797,3714],[2797,20763],
 [2798,3756],[2799,3794],[2799,20843],[2801,3507],[2801,41069],[2802,3714],[2802,20763],
 [2803,3930],[2803,20979],[2804,3677],[2804,20726],[2805,3930],[2805,20979],[2806,3756],
 [2807,3794],[2807,20843],[2810,3507],[2810,20882,44904],[2810,20883,44904],
 [2810,21188,44904],[2810,44904],[2811,3507],[2811,44904],[2812,4193],[2815,3507],
 [2815,20571,38921],[2815,20573,38921],[2815,21309,38921],[2815,38921],[2816,4193],
 [2817,3507],[2817,38921],[2818,3507],[2818,20890,45084],[2818,20891,45084],
 [2818,21368,45084],[2818,45084],[2819,3507],[2819,45084],[2820,3507],[2820,20576,39015],
 [2820,20577,39015],[2820,21403,39015],[2820,39015],[2821,3507],[2821,39015],[2850,3507],
 [2850,22145,38205],[2850,22146,38205],[2850,22189,38205],[2850,38205],[2851,3507],
 [2851,38205],[2852,3507],[2852,12747],[2852,41069],[2853,3677],[2853,22322],[2854,3714],
 [2854,22359],[2855,3756],[2856,3794],[2856,22439],[2858,3507],[2858,12747],[2858,41069],
 [2859,3714],[2859,22359],[2860,3930],[2860,22575],[2861,3677],[2861,22322],[2862,3930],
 [2862,22575],[2863,3756],[2864,3794],[2864,22439],[2867,3507],[2867,8962],[2867,44904],
 [2868,3507],[2868,8962],[2868,44904],[2869,4193],[2872,3507],[2872,22167,38921],
 [2872,22169,38921],[2872,22905,38921],[2872,38921],[2873,4193],[2874,3507],[2874,38921],
 [2875,3507],[2875,22486,45084],[2875,22487,45084],[2875,22964,45084],[2875,45084],
 [2876,3507],[2876,45084],[2877,3507],[2877,22172,39015],[2877,22173,39015],
 [2877,22999,39015],[2877,39015],[2878,3507],[2878,39015],[2894,12979],[2906,2905,3507],
 [2906,2913,3507],[2906,3507],[2906,23685,38205],[2906,23686,38205],[2906,23692,3507],
 [2906,23729,38205],[2906,38205],[2907,3507],[2907,38205],[2908,3507],[2908,23818,41069],
 [2908,23819,41069],[2908,24009,41069],[2908,41069],[2909,3677],[2909,23862],[2909,24157],
 [2910,3714],[2910,23899],[2911,3756],[2912,3794],[2912,23979],[2914,3507],[2914,41069],
 [2915,3714],[2915,23899],[2916,3930],[2916,24115],[2917,3677],[2917,23862],[2917,24157],
 [2918,3930],[2918,24115],[2919,3756],[2920,3794],[2920,23979],[2923,3507],
 [2923,24018,44904],[2923,24019,44904],[2923,24324,44904],[2923,44904],[2924,3507],
 [2924,44904],[2925,4193],[2928,3507],[2928,23707,38921],[2928,23709,38921],
 [2928,24445,38921],[2928,38921],[2929,4193],[2930,3507],[2930,38921],[2931,3507],
 [2931,24026,45084],[2931,24027,45084],[2931,24504,45084],[2931,45084],[2932,3507],
 [2932,45084],[2933,3507],[2933,23712,39015],[2933,23713,39015],[2933,24539,39015],
 [2933,39015],[2934,3507],[2934,39015],[2961,2960,3507],[2961,2968,3507],[2961,3507],
 [2961,25170,38205],[2961,25171,38205],[2961,25177,3507],[2961,25214,38205],[2961,38205],
 [2962,3507],[2962,38205],[2963,3507],[2963,25303,41069],[2963,25304,41069],
 [2963,25494,41069],[2963,41069],[2964,3677],[2964,25347],[2965,3714],[2965,25384],
 [2966,3756],[2967,3794],[2967,25464],[2969,3507],[2969,41069],[2970,3714],[2970,25384],
 [2971,3930],[2971,25600],[2972,3677],[2972,25347],[2973,3930],[2973,25600],[2974,3756],
 [2975,3794],[2975,25464],[2978,3507],[2978,25503,44904],[2978,25504,44904],
 [2978,25809,44904],[2978,44904],[2979,3507],[2979,44904],[2980,4193],[2983,3507],
 [2983,25192,38921],[2983,25194,38921],[2983,25930,38921],[2983,38921],[2984,4193],
 [2985,3507],[2985,38921],[2986,3507],[2986,25511,45084],[2986,25512,45084],
 [2986,25989,45084],[2986,45084],[2987,3507],[2987,45084],[2988,3507],[2988,25197,39015],
 [2988,25198,39015],[2988,26024,39015],[2988,39015],[2989,3507],[2989,39015],[3005,26160],
 [3006,26160],[3008,26316],[3009,26316],[3012,26510],[3013,26510],[3015,3014,3507],
 [3015,3022,3507],[3015,3507],[3015,26601,38205],[3015,26602,38205],[3015,26608,3507],
 [3015,26645,38205],[3015,38205],[3016,3507],[3016,38205],[3017,3507],[3017,26734,41069],
 [3017,26735,41069],[3017,26925,41069],[3017,41069],[3018,3677],[3018,26778],[3019,3714],
 [3019,26815],[3020,3756],[3021,3794],[3021,26895],[3023,3507],[3023,41069],[3024,3714],
 [3024,26815],[3025,3930],[3025,27031],[3026,3677],[3026,26778],[3027,3930],[3027,27031],
 [3028,3756],[3029,3794],[3029,26895],[3032,3507],[3032,26934,44904],[3032,26935,44904],
 [3032,27240,44904],[3032,44904],[3033,3507],[3033,44904],[3034,4193],[3037,3507],
 [3037,26623,38921],[3037,26625,38921],[3037,27361,38921],[3037,38921],[3038,4193],
 [3039,3507],[3039,38921],[3040,3507],[3040,26942,45084],[3040,26943,45084],
 [3040,27420,45084],[3040,45084],[3041,3507],[3041,45084],[3042,3507],[3042,26628,39015],
 [3042,26629,39015],[3042,27455,39015],[3042,39015],[3043,3507],[3043,39015],[3059,26160],
 [3060,27643],[3061,27643],[3064,27841],[3065,27841],[3068,3067,3507],[3068,3075,3507],
 [3068,3507],[3068,27979,38205],[3068,27980,38205],[3068,27986,3507],[3068,28023,38205],
 [3068,38205],[3069,3507],[3069,38205],[3070,3507],[3070,28112,41069],[3070,28113,41069],
 [3070,28303,41069],[3070,41069],[3071,3677],[3071,28156],[3072,3714],[3072,28193],
 [3073,3756],[3074,3794],[3074,28273],[3076,3507],[3076,41069],[3077,3714],[3077,28193],
 [3078,3930],[3078,28409],[3079,3677],[3079,28156],[3080,3930],[3080,28409],[3081,3756],
 [3082,3794],[3082,28273],[3085,3507],[3085,28312,44904],[3085,28313,44904],
 [3085,28618,44904],[3085,44904],[3086,3507],[3086,44904],[3087,4193],[3090,3507],
 [3090,28001,38921],[3090,28003,38921],[3090,28739,38921],[3090,38921],[3091,4193],
 [3092,3507],[3092,38921],[3093,3507],[3093,28320,45084],[3093,28321,45084],
 [3093,28798,45084],[3093,45084],[3094,3507],[3094,45084],[3095,3507],[3095,28006,39015],
 [3095,28007,39015],[3095,28833,39015],[3095,39015],[3096,3507],[3096,39015],[3112,28970],
 [3114,28970],[3116,29168],[3118,29168],[3120,3119,3507],[3120,3127,3507],[3120,3507],
 [3120,29305,38205],[3120,29306,38205],[3120,29312,3507],[3120,29349,38205],[3120,38205],
 [3121,3507],[3121,38205],[3122,3507],[3122,29438,41069],[3122,29439,41069],
 [3122,29629,41069],[3122,41069],[3123,3677],[3123,29482],[3124,3714],[3124,29519],
 [3125,3756],[3126,3794],[3126,29599],[3128,3507],[3128,41069],[3129,3714],[3129,29519],
 [3130,3930],[3130,29735],[3131,3677],[3131,29482],[3132,3930],[3132,29735],[3133,3756],
 [3134,3794],[3134,29599],[3137,3507],[3137,29638,44904],[3137,29639,44904],
 [3137,29944,44904],[3137,44904],[3138,3507],[3138,44904],[3139,4193],[3142,3507],
 [3142,29327,38921],[3142,29329,38921],[3142,30065,38921],[3142,38921],[3143,4193],
 [3144,3507],[3144,38921],[3145,3507],[3145,29646,45084],[3145,29647,45084],
 [3145,30124,45084],[3145,45084],[3146,3507],[3146,45084],[3147,3507],[3147,29332,39015],
 [3147,29333,39015],[3147,30159,39015],[3147,39015],[3148,3507],[3148,39015],[3164,27643],
 [3165,28970],[3166,30394],[3167,30394],[3171,3170,3507],[3171,3178,3507],[3171,3507],
 [3171,30580,38205],[3171,30581,38205],[3171,30587,3507],[3171,30624,38205],[3171,38205],
 [3172,3507],[3172,38205],[3173,3507],[3173,30713,41069],[3173,30714,41069],
 [3173,30904,41069],[3173,41069],[3174,3677],[3174,30757],[3175,3714],[3175,30794],
 [3176,3756],[3177,3794],[3177,30874],[3179,3507],[3179,41069],[3180,3714],[3180,30794],
 [3181,3930],[3181,31010],[3182,3677],[3182,30757],[3183,3930],[3183,31010],[3184,3756],
 [3185,3794],[3185,30874],[3188,3507],[3188,30913,44904],[3188,30914,44904],
 [3188,31219,44904],[3188,44904],[3189,3507],[3189,44904],[3190,4193],[3193,3507],
 [3193,30602,38921],[3193,30604,38921],[3193,31340,38921],[3193,38921],[3194,4193],
 [3195,3507],[3195,38921],[3196,3507],[3196,30921,45084],[3196,30922,45084],
 [3196,31399,45084],[3196,45084],[3197,3507],[3197,45084],[3198,3507],[3198,30607,39015],
 [3198,30608,39015],[3198,31434,39015],[3198,39015],[3199,3507],[3199,39015],[3215,26316],
 [3216,31620],[3218,31620],[3221,3220,3507],[3221,3228,3507],[3221,3507],
 [3221,31805,38205],[3221,31806,38205],[3221,31812,3507],[3221,31849,38205],[3221,38205],
 [3222,3507],[3222,38205],[3223,3507],[3223,31938,41069],[3223,31939,41069],
 [3223,32129,41069],[3223,41069],[3224,3677],[3224,31982],[3225,3714],[3225,32019],
 [3226,3756],[3227,3794],[3227,32099],[3229,3507],[3229,41069],[3230,3714],[3230,32019],
 [3231,3930],[3231,32235],[3232,3677],[3232,31982],[3233,3930],[3233,32235],[3234,3756],
 [3235,3794],[3235,32099],[3238,3507],[3238,32138,44904],[3238,32139,44904],
 [3238,32444,44904],[3238,44904],[3239,3507],[3239,44904],[3240,4193],[3243,3507],
 [3243,31827,38921],[3243,31829,38921],[3243,32565,38921],[3243,38921],[3244,4193],
 [3245,3507],[3245,38921],[3246,3507],[3246,32146,45084],[3246,32147,45084],
 [3246,32624,45084],[3246,45084],[3247,3507],[3247,45084],[3248,3507],[3248,31832,39015],
 [3248,31833,39015],[3248,32659,39015],[3248,39015],[3249,3507],[3249,39015],[3265,32797],
 [3268,32797],[3270,3269,3507],[3270,3277,3507],[3270,3507],[3270,32981,38205],
 [3270,32982,38205],[3270,32988,3507],[3270,33025,38205],[3270,38205],[3271,3507],
 [3271,38205],[3272,3507],[3272,33114,41069],[3272,33115,41069],[3272,33305,41069],
 [3272,41069],[3273,3677],[3273,33158],[3274,3714],[3274,33195],[3275,3756],[3276,3794],
 [3276,33275],[3278,3507],[3278,41069],[3279,3714],[3279,33195],[3280,3930],[3280,33411],
 [3281,3677],[3281,33158],[3282,3930],[3282,33411],[3283,3756],[3284,3794],[3284,33275],
 [3287,3507],[3287,33314,44904],[3287,33315,44904],[3287,33620,44904],[3287,44904],
 [3288,3507],[3288,44904],[3289,4193],[3292,3507],[3292,33003,38921],[3292,33005,38921],
 [3292,33741,38921],[3292,38921],[3293,4193],[3294,3507],[3294,38921],[3295,3507],
 [3295,33322,45084],[3295,33323,45084],[3295,33800,45084],[3295,45084],[3296,3507],
 [3296,45084],[3297,3507],[3297,33008,39015],[3297,33009,39015],[3297,33835,39015],
 [3297,39015],[3298,3507],[3298,39015],[3314,30394],[3315,31620],[3316,32797],
 [3318,3317,3507],[3318,3325,3507],[3318,3507],[3318,34109,38205],[3318,34110,38205],
 [3318,34116,3507],[3318,34153,38205],[3318,38205],[3319,3507],[3319,38205],[3320,3507],
 [3320,34242,41069],[3320,34243,41069],[3320,34433,41069],[3320,41069],[3321,3677],
 [3321,34286],[3322,3714],[3322,34323],[3323,3756],[3324,3794],[3324,34403],[3326,3507],
 [3326,41069],[3327,3714],[3327,34323],[3328,3930],[3328,34539],[3329,3677],[3329,34286],
 [3330,3930],[3330,34539],[3331,3756],[3332,3794],[3332,34403],[3335,3507],
 [3335,34442,44904],[3335,34443,44904],[3335,34748,44904],[3335,44904],[3336,3507],
 [3336,44904],[3337,4193],[3340,3507],[3340,34131,38921],[3340,34133,38921],
 [3340,34869,38921],[3340,38921],[3341,4193],[3342,3507],[3342,38921],[3343,3507],
 [3343,34450,45084],[3343,34451,45084],[3343,34928,45084],[3343,45084],[3344,3507],
 [3344,45084],[3345,3507],[3345,34136,39015],[3345,34137,39015],[3345,34963,39015],
 [3345,39015],[3346,3507],[3346,39015],[3362,27841],[3363,29168],[3365,3364,3507],
 [3365,3372,3507],[3365,3507],[3365,35190,38205],[3365,35191,38205],[3365,35197,3507],
 [3365,35234,38205],[3365,38205],[3366,3507],[3366,38205],[3367,3507],[3367,35323,41069],
 [3367,35324,41069],[3367,35514,41069],[3367,41069],[3368,3677],[3368,35367],[3369,3714],
 [3369,35404],[3370,3756],[3371,3794],[3371,35484],[3373,3507],[3373,41069],[3374,3714],
 [3374,35404],[3375,3930],[3375,35620],[3376,3677],[3376,35367],[3377,3930],[3377,35620],
 [3378,3756],[3379,3794],[3379,35484],[3382,3507],[3382,35523,44904],[3382,35524,44904],
 [3382,35829,44904],[3382,44904],[3383,3507],[3383,44904],[3384,4193],[3387,3507],
 [3387,35212,38921],[3387,35214,38921],[3387,35950,38921],[3387,38921],[3388,4193],
 [3389,3507],[3389,38921],[3390,3507],[3390,35531,45084],[3390,35532,45084],
 [3390,36009,45084],[3390,45084],[3391,3507],[3391,45084],[3392,3507],[3392,35217,39015],
 [3392,35218,39015],[3392,36044,39015],[3392,39015],[3393,3507],[3393,39015],[3409,26510],
 [3411,3410,3507],[3411,3418,3507],[3411,3507],[3411,36225,38205],[3411,36226,38205],
 [3411,36232,3507],[3411,36269,38205],[3411,38205],[3412,3507],[3412,38205],[3413,3507],
 [3413,36358,41069],[3413,36359,41069],[3413,36549,41069],[3413,41069],[3414,3677],
 [3414,36402],[3415,3714],[3415,36439],[3416,3756],[3417,3794],[3417,36519],[3419,3507],
 [3419,41069],[3420,3714],[3420,36439],[3421,3930],[3421,36655],[3422,3677],[3422,36402],
 [3423,3930],[3423,36655],[3424,3756],[3425,3794],[3425,36519],[3428,3507],
 [3428,36558,44904],[3428,36559,44904],[3428,36864,44904],[3428,44904],[3429,3507],
 [3429,44904],[3430,4193],[3433,3507],[3433,36247,38921],[3433,36249,38921],
 [3433,36985,38921],[3433,38921],[3434,4193],[3435,3507],[3435,38921],[3436,3507],
 [3436,36566,45084],[3436,36567,45084],[3436,37044,45084],[3436,45084],[3437,3507],
 [3437,45084],[3438,3507],[3438,36252,39015],[3438,36253,39015],[3438,37079,39015],
 [3438,39015],[3439,3507],[3439,39015],[3456,3455,3507],[3456,3463,3507],[3456,3507],
 [3456,37215,38205],[3456,37216,38205],[3456,37222,3507],[3456,37259,38205],[3456,38205],
 [3457,3507],[3457,38205],[3458,3507],[3458,37348,41069],[3458,37349,41069],
 [3458,37539,41069],[3458,41069],[3459,3677],[3459,37392],[3460,3714],[3460,37429],
 [3461,3756],[3462,3794],[3462,37509],[3464,3507],[3464,41069],[3465,3714],[3465,37429],
 [3466,3930],[3466,37645],[3467,3677],[3467,37392],[3468,3930],[3468,37645],[3469,3756],
 [3470,3794],[3470,37509],[3473,3507],[3473,37548,44904],[3473,37549,44904],
 [3473,37854,44904],[3473,44904],[3474,3507],[3474,44904],[3475,4193],[3478,3507],
 [3478,37237,38921],[3478,37239,38921],[3478,37975,38921],[3478,38921],[3479,4193],
 [3480,3507],[3480,38921],[3481,3507],[3481,37556,45084],[3481,37557,45084],
 [3481,38034,45084],[3481,45084],[3482,3507],[3482,45084],[3483,3507],[3483,37242,39015],
 [3483,37243,39015],[3483,38069,39015],[3483,39015],[3484,3507],[3484,39015],[3553,3507],
 [3553,3930],[3553,38205],[3553,38214,38205],[3553,38216,38205],[3553,38256,38205],
 [3553,38258,38205],[3553,38591],[3553,39159,38205],[3553,39161,38205],[3553,39494],
 [3553,40355],[3553,44695],[3555,3507],[3555,3930],[3555,38205],[3555,38591],[3555,39494],
 [3555,40355],[3555,44695],[3558,3507],[3558,3515,3507],[3558,3831,3507],[3558,38205],
 [3558,38219,38205],[3558,38261,38205],[3558,38492,3507],[3558,39164,38205],[3559,3507],
 [3559,3516,3507],[3559,3832,3507],[3559,38205],[3559,38220,38205],[3559,38262,38205],
 [3559,38493,3507],[3559,39165,38205],[3562,3507],[3562,4193],[3562,38205],
 [3562,38223,38205],[3562,38227,38205],[3562,38265,38205],[3562,38269,38205],
 [3562,39168,38205],[3562,39172,38205],[3564,3507],[3564,3521,3507],[3564,3837,3507],
 [3564,38205],[3564,38225,38205],[3564,38267,38205],[3564,38498,3507],[3564,39170,38205],
 [3566,3507],[3566,4193],[3566,38205],[3568,3507],[3568,38205],[3568,38229,38205],
 [3568,38230,38205],[3568,38271,38205],[3568,38272,38205],[3568,39174,38205],
 [3568,39175,38205],[3568,39405,45084],[3568,39406,45084],[3568,39883,45084],
 [3568,40266,45084],[3568,40267,45084],[3568,40744,45084],[3568,45084],[3569,3507],
 [3569,38205],[3569,45084],[3572,3507],[3572,3529,3507],[3572,3845,3507],[3572,38205],
 [3572,38233,38205],[3572,38275,38205],[3572,38506,3507],[3572,39178,38205],[3573,3507],
 [3573,3530,3507],[3573,3531,3507],[3573,3846,3507],[3573,3847,3507],[3573,38205],
 [3573,38234,38205],[3573,38234,40824],[3573,38235,38205],[3573,38235,40824],
 [3573,38276,38205],[3573,38276,40824],[3573,38277,38205],[3573,38277,40824],
 [3573,38507,3507],[3573,38508,3507],[3573,39060,38205],[3573,39060,40824],
 [3573,39179,38205],[3573,39179,40824],[3573,39180,38205],[3573,39180,40824],
 [3573,39963,38205],[3573,39963,40824],[3573,40824],[3574,3507],[3574,38205],[3574,40824],
 [3575,3507],[3575,3532,3507],[3575,3848,3507],[3575,38205],[3575,38236,38205],
 [3575,38278,38205],[3575,38509,3507],[3575,39181,38205],[3576,3507],[3576,3533,3507],
 [3576,3849,3507],[3576,38205],[3576,38237,38205],[3576,38279,38205],[3576,38510,3507],
 [3576,39182,38205],[3577,3507],[3577,3534,3507],[3577,3535,3507],[3577,3850,3507],
 [3577,3851,3507],[3577,38205],[3577,38238,38205],[3577,38238,40870],[3577,38239,38205],
 [3577,38239,40870],[3577,38280,38205],[3577,38280,40870],[3577,38281,38205],
 [3577,38281,40870],[3577,38511,3507],[3577,38512,3507],[3577,39106,38205],
 [3577,39106,40870],[3577,39183,38205],[3577,39183,40870],[3577,39184,38205],
 [3577,39184,40870],[3577,40009,38205],[3577,40009,40870],[3577,40870],[3578,3507],
 [3578,38205],[3578,40870],[3579,3507],[3579,3536,3507],[3579,3852,3507],[3579,38205],
 [3579,38240,38205],[3579,38282,38205],[3579,38513,3507],[3579,39185,38205],[3580,3507],
 [3580,3537,3507],[3580,3853,3507],[3580,38205],[3580,38241,38205],[3580,38283,38205],
 [3580,38514,3507],[3580,39186,38205],[3581,3507],[3581,3538,3507],[3581,3854,3507],
 [3581,38205],[3581,38242,38205],[3581,38284,38205],[3581,38515,3507],[3581,39187,38205],
 [3582,3507],[3582,3539,3507],[3582,3855,3507],[3582,38205],[3582,38243,38205],
 [3582,38285,38205],[3582,38516,3507],[3582,39188,38205],[3583,3507],[3583,3540,3507],
 [3583,3856,3507],[3583,38205],[3583,38244,38205],[3583,38286,38205],[3583,38517,3507],
 [3583,39189,38205],[3584,3507],[3584,3541,3507],[3584,3857,3507],[3584,38205],
 [3584,38245,38205],[3584,38287,38205],[3584,38518,3507],[3584,39190,38205],[3585,3507],
 [3585,3542,3507],[3585,3543,3507],[3585,3858,3507],[3585,3859,3507],[3585,38205],
 [3585,38246,38205],[3585,38246,40914],[3585,38247,38205],[3585,38247,40914],
 [3585,38288,38205],[3585,38288,40914],[3585,38289,38205],[3585,38289,40914],
 [3585,38519,3507],[3585,38520,3507],[3585,39150,38205],[3585,39150,40914],
 [3585,39191,38205],[3585,39191,40914],[3585,39192,38205],[3585,39192,40914],
 [3585,40053,38205],[3585,40053,40914],[3585,40914],[3586,3507],[3586,38205],[3586,40914],
 [3595,3507],[3595,3930],[3595,38205],[3595,38591],[3595,39494],[3595,40355],[3595,44695],
 [3597,3507],[3597,3930],[3597,38205],[3597,38591],[3597,39494],[3597,40355],[3597,44695],
 [3600,3507],[3600,38205],[3601,3507],[3601,38205],[3604,3507],[3604,4193],[3604,38205],
 [3606,3507],[3606,38205],[3608,3507],[3608,4193],[3608,38205],[3610,3507],[3610,38205],
 [3610,45084],[3611,3507],[3611,38205],[3611,45084],[3614,3507],[3614,38205],[3615,3507],
 [3615,38205],[3615,40824],[3616,3507],[3616,38205],[3616,40824],[3617,3507],[3617,38205],
 [3618,3507],[3618,38205],[3619,3507],[3619,38205],[3619,40870],[3620,3507],[3620,38205],
 [3620,40870],[3621,3507],[3621,38205],[3622,3507],[3622,38205],[3623,3507],[3623,38205],
 [3624,3507],[3624,38205],[3625,3507],[3625,38205],[3626,3507],[3626,38205],[3627,3507],
 [3627,38205],[3627,40914],[3628,3507],[3628,38205],[3628,40914],[3631,3507],[3631,3756],
 [3631,3930],[3631,38591],[3631,40995,41069],[3631,40995,43330],[3631,40996,41069],
 [3631,40996,43330],[3631,40998,41069],[3631,40998,43330],[3631,41069],[3631,41071,41069],
 [3631,41071,43330],[3631,41073,41069],[3631,41073,41239],[3631,41074,41069],
 [3631,41074,41239],[3631,41106,41069],[3631,41106,43330],[3631,41108,41069],
 [3631,41108,41239],[3631,41109,41069],[3631,41109,41239],[3631,41175,41239],
 [3631,41176,41239],[3631,41239],[3631,43293,41069],[3631,43293,43330],[3631,43295,41069],
 [3631,43295,43330],[3631,43297],[3631,43330],[3631,44626,41069],[3631,44626,43330],
 [3631,44628,41069],[3631,44628,41239],[3631,44629,41069],[3631,44629,41239],[3631,44695],
 [3631,44696],[3631,44759,41069],[3631,44759,41239],[3631,45354,41069],[3631,45354,41239],
 [3631,46443,41239],[3632,3507],[3632,3794],[3632,38455],[3632,41032,41069],
 [3632,41033,41069],[3632,41039],[3632,41069],[3632,41075,41069],[3632,41110,41069],
 [3632,43959,41069],[3632,43965],[3632,44000],[3632,44630,41069],[3636,3507],[3636,3756],
 [3636,3930],[3636,38591],[3636,41069],[3636,41239],[3636,43297],[3636,43330],
 [3636,44695],[3636,44696],[3638,3507],[3638,3756],[3638,3930],[3638,38591],[3638,41069],
 [3638,41239],[3638,43297],[3638,43330],[3638,44695],[3638,44696],[3639,3507],
 [3639,3756],[3639,3930],[3639,38591],[3639,41069],[3639,41239],[3639,43297],[3639,43330],
 [3639,44695],[3639,44696],[3640,3507],[3640,3794],[3640,38455],[3640,41039],[3640,41069],
 [3640,43965],[3640,44000],[3641,3507],[3641,41069],[3641,41076,41069],[3641,41111,41069],
 [3641,44631,41069],[3642,3507],[3642,41069],[3642,41077,41069],[3642,41112,41069],
 [3642,44632,41069],[3645,3507],[3645,4193],[3645,41069],[3645,41080,41069],
 [3645,41084,41069],[3645,41115,41069],[3645,41119,41069],[3645,44635,41069],
 [3645,44639,41069],[3647,3507],[3647,41069],[3647,41082,41069],[3647,41117,41069],
 [3647,44637,41069],[3649,3507],[3649,4193],[3649,41069],[3651,3507],[3651,41069],
 [3651,41086,41069],[3651,41086,45084],[3651,41087,41069],[3651,41087,45084],
 [3651,41121,41069],[3651,41121,45084],[3651,41122,41069],[3651,41122,45084],
 [3651,41564,41069],[3651,41564,45084],[3651,44641,41069],[3651,44641,45084],
 [3651,44642,41069],[3651,44642,45084],[3651,45084],[3651,45679,41069],[3651,45679,45084],
 [3652,3507],[3652,41069],[3652,45084],[3653,3507],[3653,38314,39015],[3653,38315,39015],
 [3653,38539,39015],[3653,38540,39015],[3653,39015],[3653,41069],[3653,41088,41069],
 [3653,41089,41069],[3653,41123,41069],[3653,41124,41069],[3653,41599,39015],
 [3653,44643,41069],[3653,44644,41069],[3653,45714,39015],[3654,3507],[3654,39015],
 [3654,41069],[3655,3507],[3655,41069],[3655,41090,41069],[3655,41090,45745],
 [3655,41091,41069],[3655,41091,45745],[3655,41125,41069],[3655,41125,45745],
 [3655,41126,41069],[3655,41126,45745],[3655,41630,41069],[3655,41630,45745],
 [3655,44645,41069],[3655,44645,45745],[3655,44646,41069],[3655,44646,45745],
 [3655,45150,41069],[3655,45150,45745],[3655,45745],[3656,3507],[3656,41069],[3656,45745],
 [3657,3507],[3657,41069],[3657,41092,41069],[3657,41127,41069],[3657,44647,41069],
 [3658,3507],[3658,41069],[3658,41093,41069],[3658,41128,41069],[3658,44648,41069],
 [3659,3507],[3659,41069],[3659,41094,41069],[3659,41129,41069],[3659,44649,41069],
 [3660,3507],[3660,41069],[3660,41095,41069],[3660,41095,45806],[3660,41097,41069],
 [3660,41097,45806],[3660,41130,41069],[3660,41130,45806],[3660,41132,41069],
 [3660,41132,45806],[3660,41691,41069],[3660,41691,45806],[3660,44650,41069],
 [3660,44650,45806],[3660,44652,41069],[3660,44652,45806],[3660,45211,41069],
 [3660,45211,45806],[3660,45806],[3661,3507],[3661,41069],[3661,41096,41069],
 [3661,41131,41069],[3661,44651,41069],[3662,3507],[3662,41069],[3662,45806],[3663,3507],
 [3663,41069],[3663,41098,41069],[3663,41133,41069],[3663,44653,41069],[3664,3507],
 [3664,41069],[3664,41099,41069],[3664,41134,41069],[3664,44654,41069],[3665,3507],
 [3665,41069],[3665,41100,41069],[3665,41135,41069],[3665,44655,41069],[3666,3507],
 [3666,41069],[3666,41101,41069],[3666,41136,41069],[3666,44656,41069],[3667,3507],
 [3667,41069],[3667,41102,41069],[3667,41102,45847],[3667,41103,41069],[3667,41103,45847],
 [3667,41137,41069],[3667,41137,45847],[3667,41138,41069],[3667,41138,45847],
 [3667,41732,41069],[3667,41732,45847],[3667,44657,41069],[3667,44657,45847],
 [3667,44658,41069],[3667,44658,45847],[3667,45252,41069],[3667,45252,45847],[3667,45847],
 [3668,3507],[3668,41069],[3668,45847],[3669,3507],[3669,41069],[3669,41104,41069],
 [3669,41139,41069],[3669,44659,41069],[3671,3677],[3671,3756],[3671,41779],[3671,41988],
 [3672,3677],[3672,3794],[3672,41816],[3672,41819],[3672,41989],[3672,44099],[3676,3677],
 [3676,3930],[3676,41954],[3676,41955],[3676,41987],[3676,46411],[3678,3677],[3678,3930],
 [3678,41954],[3678,41955],[3678,41987],[3678,46411],[3679,3677],[3679,3756],[3679,41779],
 [3679,41988],[3680,3677],[3680,3794],[3680,41816],[3680,41819],[3680,41989],[3680,44099],
 [3681,3677],[3681,41990,42109],[3681,41991,42109],[3681,42109],[3681,47029,42109],
 [3682,3677],[3682,42109],[3685,3677],[3685,4193],[3685,41994],[3685,41998],[3686,3677],
 [3686,41995],[3687,3677],[3687,41996],[3689,3677],[3689,4193],[3689,41994],[3689,41998],
 [3691,3507],[3691,3677],[3691,3714],[3691,38331],[3691,38352,38331],[3691,38353,38331],
 [3691,38353,39015],[3691,38353,42362],[3691,38353,43104],[3691,38354,38331],
 [3691,38354,39015],[3691,38354,42362],[3691,38354,43104],[3691,38355,38331],
 [3691,38355,39015],[3691,38355,42362],[3691,38355,43104],[3691,38391,38331],
 [3691,38392,38331],[3691,38392,39015],[3691,38392,42362],[3691,38392,43104],
 [3691,38393,38331],[3691,38393,39015],[3691,38393,42362],[3691,38393,43104],
 [3691,38394,38331],[3691,38394,39015],[3691,38394,42362],[3691,38394,43104],[3691,38557],
 [3691,38571,38557],[3691,38571,39015],[3691,38571,46241],[3691,38571,47266],
 [3691,38572,38557],[3691,38573,38557],[3691,38573,39015],[3691,38573,46241],
 [3691,38573,47266],[3691,38574,38557],[3691,38574,39015],[3691,38574,46241],
 [3691,38574,47266],[3691,38636,38557],[3691,38636,39015],[3691,38636,46241],
 [3691,38636,47266],[3691,38637,38557],[3691,38638,38557],[3691,38638,39015],
 [3691,38638,46241],[3691,38638,47266],[3691,38639,38557],[3691,38639,39015],
 [3691,38639,46241],[3691,38639,47266],[3691,38981,38557],[3691,38981,39015],
 [3691,38981,46241],[3691,38981,47266],[3691,38982,38557],[3691,38982,39015],
 [3691,38982,46241],[3691,38982,47266],[3691,38998,38331],[3691,38998,39015],
 [3691,38998,42362],[3691,38998,43104],[3691,38999,38331],[3691,38999,39015],
 [3691,38999,42362],[3691,38999,43104],[3691,39015],[3691,41755,38331],[3691,41756,38331],
 [3691,41756,39015],[3691,41756,42362],[3691,41756,43104],[3691,41757,38331],
 [3691,41757,39015],[3691,41757,42362],[3691,41757,43104],[3691,41758,38331],
 [3691,41758,39015],[3691,41758,42362],[3691,41758,43104],[3691,41850],[3691,41866,41850],
 [3691,41866,42362],[3691,41866,45084],[3691,41866,46241],[3691,41867,41850],
 [3691,41867,42362],[3691,41867,45084],[3691,41867,46241],[3691,41868,41850],
 [3691,41868,42362],[3691,41868,45084],[3691,41868,46241],[3691,41869,41850],
 [3691,41935,41850],[3691,41935,42362],[3691,41935,45084],[3691,41935,46241],
 [3691,41936,41850],[3691,41936,42362],[3691,41936,45084],[3691,41936,46241],
 [3691,41937,41850],[3691,41937,42362],[3691,41937,45084],[3691,41937,46241],
 [3691,41938,41850],[3691,42000,47266],[3691,42001,42362],[3691,42002,42362],
 [3691,42003,47266],[3691,42344,41850],[3691,42344,42362],[3691,42344,45084],
 [3691,42344,46241],[3691,42345,41850],[3691,42345,42362],[3691,42345,45084],
 [3691,42345,46241],[3691,42346,47266],[3691,42362],[3691,42363,38331],[3691,42363,39015],
 [3691,42363,42362],[3691,42363,43104],[3691,42379,38331],[3691,42379,39015],
 [3691,42379,42362],[3691,42379,43104],[3691,42593],[3691,42607,42593],[3691,42607,43104],
 [3691,42607,45084],[3691,42607,47266],[3691,42608,42593],[3691,42608,43104],
 [3691,42608,45084],[3691,42608,47266],[3691,42609,42593],[3691,42610,42593],
 [3691,42610,43104],[3691,42610,45084],[3691,42610,47266],[3691,42676,46241],
 [3691,42677,43104],[3691,42678,46241],[3691,42679,43104],[3691,42741,42593],
 [3691,42741,43104],[3691,42741,45084],[3691,42741,47266],[3691,42742,42593],
 [3691,42742,43104],[3691,42742,45084],[3691,42742,47266],[3691,42743,42593],
 [3691,42744,42593],[3691,42744,43104],[3691,42744,45084],[3691,42744,47266],
 [3691,43085,42593],[3691,43085,43104],[3691,43085,45084],[3691,43085,47266],
 [3691,43086,46241],[3691,43087,42593],[3691,43087,43104],[3691,43087,45084],
 [3691,43087,47266],[3691,43103,38331],[3691,43103,39015],[3691,43103,42362],
 [3691,43103,43104],[3691,43104],[3691,43120,38331],[3691,43120,39015],[3691,43120,42362],
 [3691,43120,43104],[3691,44675,41850],[3691,44675,42362],[3691,44675,45084],
 [3691,44675,46241],[3691,44676,41850],[3691,44676,42362],[3691,44676,45084],
 [3691,44676,46241],[3691,44677,41850],[3691,44677,42362],[3691,44677,45084],
 [3691,44677,46241],[3691,44678,41850],[3691,44740,42593],[3691,44740,43104],
 [3691,44740,45084],[3691,44740,47266],[3691,44741,42593],[3691,44741,43104],
 [3691,44741,45084],[3691,44741,47266],[3691,44742,42593],[3691,44743,42593],
 [3691,44743,43104],[3691,44743,45084],[3691,44743,47266],[3691,45084],[3691,45085,41850],
 [3691,45085,42362],[3691,45085,45084],[3691,45085,46241],[3691,45086,42593],
 [3691,45086,43104],[3691,45086,45084],[3691,45086,47266],[3691,45102,41850],
 [3691,45102,42362],[3691,45102,45084],[3691,45102,46241],[3691,45103,42593],
 [3691,45103,43104],[3691,45103,45084],[3691,45103,47266],[3691,45896,38557],
 [3691,45896,39015],[3691,45896,46241],[3691,45896,47266],[3691,45897,38557],
 [3691,45898,38557],[3691,45898,39015],[3691,45898,46241],[3691,45898,47266],
 [3691,45899,38557],[3691,45899,39015],[3691,45899,46241],[3691,45899,47266],
 [3691,46240,41850],[3691,46240,42362],[3691,46240,45084],[3691,46240,46241],[3691,46241],
 [3691,46242,38557],[3691,46242,39015],[3691,46242,46241],[3691,46242,47266],
 [3691,46258,41850],[3691,46258,42362],[3691,46258,45084],[3691,46258,46241],
 [3691,46259,43104],[3691,46275,38557],[3691,46275,39015],[3691,46275,46241],
 [3691,46275,47266],[3691,47264,42593],[3691,47264,43104],[3691,47264,45084],
 [3691,47264,47266],[3691,47265,38557],[3691,47265,39015],[3691,47265,46241],
 [3691,47265,47266],[3691,47266],[3691,47282,42362],[3691,47283,42593],[3691,47283,43104],
 [3691,47283,45084],[3691,47283,47266],[3691,47299,38557],[3691,47299,39015],
 [3691,47299,46241],[3691,47299,47266],[3691,51426,41850],[3691,51426,42362],
 [3691,51426,45084],[3691,51426,46241],[3691,51427,42593],[3691,51427,43104],
 [3691,51427,45084],[3691,51427,47266],[3691,51443,38557],[3691,51443,39015],
 [3691,51443,46241],[3691,51443,47266],[3691,51579,38331],[3691,51579,39015],
 [3691,51579,42362],[3691,51579,43104],[3692,3507],[3692,3677],[3692,3714],[3692,38331],
 [3692,38557],[3692,39015],[3692,41850],[3692,42362],[3692,42593],[3692,43104],
 [3692,45084],[3692,46241],[3692,47266],[3693,3507],[3693,3677],[3693,3714],[3693,38331],
 [3693,38557],[3693,39015],[3693,41850],[3693,42362],[3693,42593],[3693,43104],
 [3693,45084],[3693,46241],[3693,47266],[3694,3507],[3694,3677],[3694,3714],[3694,38331],
 [3694,38557],[3694,39015],[3694,41850],[3694,42362],[3694,42593],[3694,43104],
 [3694,45084],[3694,46241],[3694,47266],[3695,3677],[3695,42004,47331],[3695,42006,47331],
 [3695,42411,47331],[3695,47331],[3696,3677],[3696,42005],[3697,3677],[3697,47331],
 [3698,3677],[3698,42007,42449],[3698,42008,42449],[3698,42449],[3698,47369,42449],
 [3699,3677],[3699,42449],[3700,3677],[3700,42009],[3701,3677],[3701,42010,47399],
 [3701,42011,47399],[3701,42479,47399],[3701,47399],[3702,3677],[3702,47399],[3703,3677],
 [3703,42012,42494],[3703,42013,42494],[3703,42494],[3703,47414,42494],[3704,3677],
 [3704,42494],[3705,3677],[3705,42014],[3706,3677],[3706,42015],[3707,3677],
 [3707,42016,47433],[3707,42018,47433],[3707,42513,47433],[3707,47433],[3708,3677],
 [3708,42017],[3709,3677],[3709,47433],[3710,3714],[3710,3756],[3710,42518],[3710,42664],
 [3711,3714],[3711,3794],[3711,3930],[3711,42555,44030],[3711,42556,44030],
 [3711,42558,42761],[3711,42560,42761],[3711,42661,44030],[3711,42663,42761],
 [3711,42665,42761],[3711,42696,42761],[3711,42698,42761],[3711,42761],[3711,44030],
 [3711,44032,44030],[3711,44034,44030],[3711,44065,44030],[3711,44067,44030],
 [3711,44130,42761],[3711,45851,44030],[3711,45853,44030],[3711,45916,42761],
 [3711,46444,42761],[3715,3714],[3715,3794],[3715,3930],[3715,42761],[3715,44030],
 [3717,3714],[3717,3794],[3717,3930],[3717,42761],[3717,44030],[3718,3714],[3718,3756],
 [3718,42518],[3718,42664],[3719,3714],[3719,3794],[3719,3930],[3719,42761],[3719,44030],
 [3720,3714],[3720,42666],[3721,3714],[3721,42667],[3724,3714],[3724,4193],[3724,42670],
 [3724,42674],[3726,3714],[3726,42672],[3728,3714],[3728,4193],[3728,42670],[3728,42674],
 [3730,3507],[3730,3677],[3730,3714],[3730,38331],[3730,38557],[3730,39015],[3730,41850],
 [3730,42362],[3730,42593],[3730,43104],[3730,45084],[3730,46241],[3730,47266],
 [3731,3507],[3731,3677],[3731,3714],[3731,38331],[3731,38557],[3731,39015],[3731,41850],
 [3731,42362],[3731,42593],[3731,43104],[3731,45084],[3731,46241],[3731,47266],
 [3732,3507],[3732,3677],[3732,3714],[3732,38331],[3732,38557],[3732,39015],[3732,41850],
 [3732,42362],[3732,42593],[3732,43104],[3732,45084],[3732,46241],[3732,47266],
 [3733,3507],[3733,3677],[3733,3714],[3733,38331],[3733,38557],[3733,39015],[3733,41850],
 [3733,42362],[3733,42593],[3733,43104],[3733,45084],[3733,46241],[3733,47266],
 [3734,3714],[3734,42680],[3735,3714],[3735,42681],[3736,3714],[3736,42682],[3737,3714],
 [3737,42683],[3738,3714],[3738,42684],[3739,3714],[3739,42685],[3740,3714],[3740,42686],
 [3741,3714],[3741,42687],[3742,3714],[3742,42688],[3743,3714],[3743,42689],[3744,3714],
 [3744,42690],[3745,3714],[3745,42691],[3746,3714],[3746,42692],[3747,3714],[3747,42693],
 [3748,3714],[3748,42694],[3751,3507],[3751,3756],[3751,3930],[3751,38591],[3751,41069],
 [3751,41239],[3751,43297],[3751,43330],[3751,44695],[3751,44696],[3752,3714],
 [3752,3756],[3752,42518],[3752,42664],[3753,3507],[3753,3756],[3753,3930],[3753,38591],
 [3753,41069],[3753,41239],[3753,43297],[3753,43330],[3753,44695],[3753,44696],
 [3754,3677],[3754,3756],[3754,41779],[3754,41988],[3755,3507],[3755,3756],[3755,3930],
 [3755,38591],[3755,41069],[3755,41239],[3755,43297],[3755,43330],[3755,44695],
 [3755,44696],[3758,3756],[3759,3756],[3760,3507],[3760,3756],[3760,43302,44904],
 [3760,43303,44904],[3760,43608,44904],[3760,44793,44904],[3760,44794,44904],[3760,44904],
 [3760,47984,44904],[3761,3507],[3761,3756],[3761,44904],[3762,3756],[3762,4193],
 [3762,43685],[3762,48035],[3763,3756],[3763,4193],[3763,43685],[3763,48035],[3764,3756],
 [3765,3507],[3765,3756],[3765,38426,38921],[3765,38428,38921],[3765,38694,38921],
 [3765,38696,38921],[3765,38921],[3765,43729,38921],[3765,48105,38921],[3766,3756],
 [3766,4193],[3766,43685],[3766,48035],[3767,3507],[3767,3756],[3767,38921],[3768,3507],
 [3768,3756],[3768,43310,45084],[3768,43311,45084],[3768,43788,45084],[3768,44801,45084],
 [3768,44802,45084],[3768,45084],[3768,48164,45084],[3769,3507],[3769,3756],[3769,45084],
 [3772,3756],[3773,3756],[3774,3756],[3775,3756],[3776,3756],[3777,3756],[3778,3756],
 [3779,3756],[3780,3756],[3781,3756],[3782,3756],[3783,3756],[3784,3756],[3785,3756],
 [3786,3756],[3788,3507],[3788,3794],[3788,38455],[3788,41039],[3788,41069],[3788,43965],
 [3788,44000],[3789,3714],[3789,3794],[3789,3930],[3789,42761],[3789,44030],[3790,3714],
 [3790,3794],[3790,3930],[3790,42761],[3790,44030],[3791,3677],[3791,3794],[3791,41816],
 [3791,41819],[3791,41989],[3791,44099],[3792,3714],[3792,3794],[3792,3930],[3792,42761],
 [3792,44030],[3795,3794],[3795,44190],[3796,3794],[3796,44191],[3797,3507],[3797,3794],
 [3797,38455],[3797,43965],[3797,43968,44904],[3797,43969,44904],[3797,44192],[3797,44193],
 [3797,44274,44904],[3797,44822,44904],[3797,44823,44904],[3797,44904],[3797,48390,44904],
 [3798,3507],[3798,3794],[3798,38455],[3798,43965],[3798,44192],[3798,44193],[3798,44904],
 [3799,3507],[3799,3794],[3799,4193],[3799,38455],[3799,38460],[3799,38463,38921],
 [3799,38463,44394],[3799,38464,38921],[3799,38464,44394],[3799,38465,38921],
 [3799,38465,44394],[3799,38720,38921],[3799,38720,48445],[3799,38723,38921],
 [3799,38723,48445],[3799,38724],[3799,38725,38921],[3799,38725,48445],[3799,38853,38921],
 [3799,38853,48445],[3799,38855,38921],[3799,38855,48445],[3799,38920,38921],
 [3799,38920,44394],[3799,38921],[3799,38941,38921],[3799,38941,44394],[3799,43965],
 [3799,44194,48445],[3799,44197,44394],[3799,44198,44394],[3799,44199,48445],
 [3799,44329,48445],[3799,44394],[3799,44395,38921],[3799,44395,44394],[3799,44415,38921],
 [3799,44415,44394],[3799,48443,38921],[3799,48443,48445],[3799,48445],[3799,48510,44394],
 [3799,48511,38921],[3799,48511,48445],[3799,50141,38921],[3799,50141,48445],
 [3799,50855,38921],[3799,50855,44394],[3800,3794],[3800,44195],[3801,3794],[3801,44196],
 [3802,3507],[3802,3794],[3802,4193],[3802,38455],[3802,38460],[3802,38724],[3802,38921],
 [3802,43965],[3802,44394],[3802,48445],[3803,3507],[3803,3794],[3803,4193],[3803,38455],
 [3803,38460],[3803,38724],[3803,38921],[3803,43965],[3803,44394],[3803,48445],
 [3804,3507],[3804,3794],[3804,4193],[3804,38455],[3804,38460],[3804,38724],[3804,38921],
 [3804,43965],[3804,44394],[3804,48445],[3805,3507],[3805,3794],[3805,38455],[3805,43965],
 [3805,43976,45084],[3805,43977,45084],[3805,44200],[3805,44201],[3805,44454,45084],
 [3805,44830,45084],[3805,44831,45084],[3805,45084],[3805,48570,45084],[3806,3507],
 [3806,3794],[3806,38455],[3806,43965],[3806,44200],[3806,44201],[3806,45084],
 [3807,2279],[3807,3507],[3807,3756],[3807,3794],[3807,5705],[3807,6183],[3807,6213],
 [3807,7828],[3807,7996],[3807,8032],[3807,38205],[3807,38418],[3807,38454],[3807,38455],
 [3807,39015],[3807,39313],[3807,39602],[3807,39603],[3807,39631],[3807,40195],
 [3807,40196],[3807,40233],[3807,40450],[3807,43536],[3807,43643],[3807,43965],
 [3807,44174],[3807,44904],[3807,47993],[3808,2279],[3808,3507],[3808,3756],[3808,3794],
 [3808,5705],[3808,6183],[3808,6213],[3808,7828],[3808,7996],[3808,8032],[3808,38205],
 [3808,38418],[3808,38454],[3808,38455],[3808,39015],[3808,39313],[3808,39602],
 [3808,39603],[3808,39631],[3808,40195],[3808,40196],[3808,40233],[3808,40450],
 [3808,43536],[3808,43643],[3808,43965],[3808,44174],[3808,44904],[3808,47993],
 [3809,3794],[3809,44204],[3810,3794],[3810,44205],[3811,3794],[3811,44206],[3812,3794],
 [3812,44207],[3813,3794],[3813,44208],[3814,3794],[3814,44209],[3815,3794],[3815,44210],
 [3816,3794],[3816,44211],[3817,3794],[3817,44212],[3818,3794],[3818,44213],[3819,3794],
 [3819,44214],[3820,3794],[3820,44215],[3821,3794],[3821,44216],[3822,3794],[3822,44217],
 [3823,3794],[3823,44218],[3861,3507],[3861,3756],[3861,3930],[3861,38591],[3861,41069],
 [3861,41239],[3861,43297],[3861,43330],[3861,44695],[3861,44696],[3863,3507],
 [3863,3756],[3863,3930],[3863,38591],[3863,41069],[3863,41239],[3863,43297],[3863,43330],
 [3863,44695],[3863,44696],[3864,3507],[3864,3756],[3864,3930],[3864,38591],[3864,41069],
 [3864,41239],[3864,43297],[3864,43330],[3864,44695],[3864,44696],[3865,3507],
 [3865,3794],[3865,38455],[3865,41039],[3865,41069],[3865,43965],[3865,44000],
 [3866,3507],[3866,41069],[3867,3507],[3867,41069],[3870,3507],[3870,4193],[3870,41069],
 [3872,3507],[3872,41069],[3874,3507],[3874,4193],[3874,41069],[3876,3507],[3876,41069],
 [3876,45084],[3877,3507],[3877,41069],[3877,45084],[3878,3507],[3878,39015],[3878,41069],
 [3879,3507],[3879,39015],[3879,41069],[3880,3507],[3880,41069],[3880,45745],[3881,3507],
 [3881,41069],[3881,45745],[3882,3507],[3882,41069],[3883,3507],[3883,41069],[3884,3507],
 [3884,41069],[3885,3507],[3885,41069],[3885,45806],[3886,3507],[3886,41069],[3887,3507],
 [3887,41069],[3887,45806],[3888,3507],[3888,41069],[3889,3507],[3889,41069],[3890,3507],
 [3890,41069],[3891,3507],[3891,41069],[3892,3507],[3892,41069],[3892,45847],[3893,3507],
 [3893,41069],[3893,45847],[3894,3507],[3894,41069],[3895,3714],[3895,3794],[3895,3930],
 [3895,42761],[3895,44030],[3897,3714],[3897,3794],[3897,3930],[3897,42761],[3897,44030],
 [3898,3714],[3898,3756],[3898,42518],[3898,42664],[3899,3714],[3899,3794],[3899,3930],
 [3899,42761],[3899,44030],[3900,3714],[3900,42666],[3901,3714],[3901,42667],[3904,3714],
 [3904,4193],[3904,42670],[3904,42674],[3906,3714],[3906,42672],[3908,3714],[3908,4193],
 [3908,42670],[3908,42674],[3910,3507],[3910,3677],[3910,3714],[3910,38331],[3910,38557],
 [3910,39015],[3910,41850],[3910,42362],[3910,42593],[3910,43104],[3910,45084],
 [3910,46241],[3910,47266],[3911,3507],[3911,3677],[3911,3714],[3911,38331],[3911,38557],
 [3911,39015],[3911,41850],[3911,42362],[3911,42593],[3911,43104],[3911,45084],
 [3911,46241],[3911,47266],[3912,3507],[3912,3677],[3912,3714],[3912,38331],[3912,38557],
 [3912,39015],[3912,41850],[3912,42362],[3912,42593],[3912,43104],[3912,45084],
 [3912,46241],[3912,47266],[3913,3507],[3913,3677],[3913,3714],[3913,38331],[3913,38557],
 [3913,39015],[3913,41850],[3913,42362],[3913,42593],[3913,43104],[3913,45084],
 [3913,46241],[3913,47266],[3914,3714],[3914,42680],[3915,3714],[3915,42681],[3916,3714],
 [3916,42682],[3917,3714],[3917,42683],[3918,3714],[3918,42684],[3919,3714],[3919,42685],
 [3920,3714],[3920,42686],[3921,3714],[3921,42687],[3922,3714],[3922,42688],[3923,3714],
 [3923,42689],[3924,3714],[3924,42690],[3925,3714],[3925,42691],[3926,3714],[3926,42692],
 [3927,3714],[3927,42693],[3928,3714],[3928,42694],[3929,3677],[3929,3930],[3929,41954],
 [3929,41955],[3929,41987],[3929,46411],[3931,3507],[3931,3756],[3931,3930],[3931,38591],
 [3931,41069],[3931,41239],[3931,43297],[3931,43330],[3931,44695],[3931,44696],
 [3932,3714],[3932,3794],[3932,3930],[3932,42761],[3932,44030],[3933,3930],[3933,46445],
 [3934,3930],[3934,46446],[3938,3930],[3938,46450],[3939,3930],[3939,46451],[3940,3507],
 [3940,3930],[3940,38591],[3940,38601,38921],[3940,38603,38921],[3940,38664,38921],
 [3940,38666,38921],[3940,38921],[3940,44695],[3940,46452],[3940,46454],[3940,46709,38921],
 [3940,47670,38921],[3942,3507],[3942,3930],[3942,38591],[3942,38921],[3942,44695],
 [3942,46452],[3942,46454],[3943,2279],[3943,3507],[3943,3930],[3943,4193],[3943,5705],
 [3943,6152],[3943,6340],[3943,7828],[3943,8168],[3943,8507],[3943,38205],[3943,38591],
 [3943,39759],[3943,40707],[3943,44695],[3943,44702],[3943,44769],[3943,44904],
 [3943,45084],[3943,46593],[3943,46621],[3943,46645],[3943,47556],[3943,47575],
 [3943,47691],[3943,49500],[3943,49501],[3943,49886],[3943,49887],[3944,2279],
 [3944,3507],[3944,3930],[3944,4193],[3944,5705],[3944,6152],[3944,6340],[3944,7828],
 [3944,8168],[3944,8507],[3944,38205],[3944,38591],[3944,39759],[3944,40707],[3944,44695],
 [3944,44702],[3944,44769],[3944,44904],[3944,45084],[3944,46593],[3944,46621],
 [3944,46645],[3944,47556],[3944,47575],[3944,47691],[3944,49500],[3944,49501],
 [3944,49886],[3944,49887],[3945,3507],[3945,3930],[3945,38591],[3945,38606,39015],
 [3945,38607,39015],[3945,38669,39015],[3945,38670,39015],[3945,39015],[3945,44695],
 [3945,46457],[3945,46458],[3945,46803,39015],[3945,47764,39015],[3946,3507],[3946,3930],
 [3946,38591],[3946,39015],[3946,44695],[3946,46457],[3946,46458],[3947,3930],
 [3947,46459],[3948,3930],[3948,46460],[3949,3930],[3949,46461],[3950,3930],[3950,46462],
 [3951,3930],[3951,46463],[3952,3930],[3952,46464],[3953,3930],[3953,46465],[3954,3930],
 [3954,46466],[3955,3930],[3955,46467],[3956,3930],[3956,46468],[3957,3930],[3957,46469],
 [3958,3930],[3958,46470],[3959,3930],[3959,46471],[3960,3930],[3960,46472],[3961,3930],
 [3961,46473],[3962,3677],[3962,3930],[3962,41954],[3962,41955],[3962,41987],[3962,46411],
 [3963,3677],[3963,3756],[3963,41779],[3963,41988],[3964,3677],[3964,3794],[3964,41816],
 [3964,41819],[3964,41989],[3964,44099],[3965,3677],[3965,42109],[3966,3677],[3966,42109],
 [3969,3677],[3969,4193],[3969,41994],[3969,41998],[3970,3677],[3970,41995],[3971,3677],
 [3971,41996],[3973,3677],[3973,4193],[3973,41994],[3973,41998],[3975,3507],[3975,3677],
 [3975,3714],[3975,38331],[3975,38557],[3975,39015],[3975,41850],[3975,42362],
 [3975,42593],[3975,43104],[3975,45084],[3975,46241],[3975,47266],[3976,3507],
 [3976,3677],[3976,3714],[3976,38331],[3976,38557],[3976,39015],[3976,41850],[3976,42362],
 [3976,42593],[3976,43104],[3976,45084],[3976,46241],[3976,47266],[3977,3507],
 [3977,3677],[3977,3714],[3977,38331],[3977,38557],[3977,39015],[3977,41850],[3977,42362],
 [3977,42593],[3977,43104],[3977,45084],[3977,46241],[3977,47266],[3978,3507],
 [3978,3677],[3978,3714],[3978,38331],[3978,38557],[3978,39015],[3978,41850],[3978,42362],
 [3978,42593],[3978,43104],[3978,45084],[3978,46241],[3978,47266],[3979,3677],
 [3979,47331],[3980,3677],[3980,42005],[3981,3677],[3981,47331],[3982,3677],[3982,42449],
 [3983,3677],[3983,42449],[3984,3677],[3984,42009],[3985,3677],[3985,47399],[3986,3677],
 [3986,47399],[3987,3677],[3987,42494],[3988,3677],[3988,42494],[3989,3677],[3989,42014],
 [3990,3677],[3990,42015],[3991,3677],[3991,47433],[3992,3677],[3992,42017],[3993,3677],
 [3993,47433],[3994,3507],[3994,3756],[3994,3930],[3994,38591],[3994,41069],[3994,41239],
 [3994,43297],[3994,43330],[3994,44695],[3994,44696],[3995,3714],[3995,3794],[3995,3930],
 [3995,42761],[3995,44030],[3996,3930],[3996,46445],[3997,3930],[3997,46446],[4001,3930],
 [4001,46450],[4002,3930],[4002,46451],[4003,3507],[4003,3930],[4003,38591],[4003,38921],
 [4003,44695],[4003,46452],[4003,46454],[4005,3507],[4005,3930],[4005,38591],[4005,38921],
 [4005,44695],[4005,46452],[4005,46454],[4006,2279],[4006,3507],[4006,3930],[4006,4193],
 [4006,5705],[4006,6152],[4006,6340],[4006,7828],[4006,8168],[4006,8507],[4006,38205],
 [4006,38591],[4006,39759],[4006,40707],[4006,44695],[4006,44702],[4006,44769],
 [4006,44904],[4006,45084],[4006,46593],[4006,46621],[4006,46645],[4006,47556],
 [4006,47575],[4006,47691],[4006,49500],[4006,49501],[4006,49886],[4006,49887],
 [4007,2279],[4007,3507],[4007,3930],[4007,4193],[4007,5705],[4007,6152],[4007,6340],
 [4007,7828],[4007,8168],[4007,8507],[4007,38205],[4007,38591],[4007,39759],[4007,40707],
 [4007,44695],[4007,44702],[4007,44769],[4007,44904],[4007,45084],[4007,46593],
 [4007,46621],[4007,46645],[4007,47556],[4007,47575],[4007,47691],[4007,49500],
 [4007,49501],[4007,49886],[4007,49887],[4008,3507],[4008,3930],[4008,38591],[4008,39015],
 [4008,44695],[4008,46457],[4008,46458],[4009,3507],[4009,3930],[4009,38591],[4009,39015],
 [4009,44695],[4009,46457],[4009,46458],[4010,3930],[4010,46459],[4011,3930],[4011,46460],
 [4012,3930],[4012,46461],[4013,3930],[4013,46462],[4014,3930],[4014,46463],[4015,3930],
 [4015,46464],[4016,3930],[4016,46465],[4017,3930],[4017,46466],[4018,3930],[4018,46467],
 [4019,3930],[4019,46468],[4020,3930],[4020,46469],[4021,3930],[4021,46470],[4022,3930],
 [4022,46471],[4023,3930],[4023,46472],[4024,3930],[4024,46473],[4026,3756],[4027,3756],
 [4028,3507],[4028,3756],[4028,44904],[4029,3507],[4029,3756],[4029,44904],[4030,3756],
 [4030,4193],[4030,43685],[4030,48035],[4031,3756],[4031,4193],[4031,43685],[4031,48035],
 [4032,3756],[4033,3507],[4033,3756],[4033,38921],[4034,3756],[4034,4193],[4034,43685],
 [4034,48035],[4035,3507],[4035,3756],[4035,38921],[4036,3507],[4036,3756],[4036,45084],
 [4037,3507],[4037,3756],[4037,45084],[4040,3756],[4041,3756],[4042,3756],[4043,3756],
 [4044,3756],[4045,3756],[4046,3756],[4047,3756],[4048,3756],[4049,3756],[4050,3756],
 [4051,3756],[4052,3756],[4053,3756],[4054,3756],[4055,3794],[4055,44190],[4056,3794],
 [4056,44191],[4057,3507],[4057,3794],[4057,38455],[4057,43965],[4057,44192],[4057,44193],
 [4057,44904],[4058,3507],[4058,3794],[4058,38455],[4058,43965],[4058,44192],[4058,44193],
 [4058,44904],[4059,3507],[4059,3794],[4059,4193],[4059,38455],[4059,38460],[4059,38724],
 [4059,38921],[4059,43965],[4059,44394],[4059,48445],[4060,3794],[4060,44195],
 [4061,3794],[4061,44196],[4062,3507],[4062,3794],[4062,4193],[4062,38455],[4062,38460],
 [4062,38724],[4062,38921],[4062,43965],[4062,44394],[4062,48445],[4063,3507],
 [4063,3794],[4063,4193],[4063,38455],[4063,38460],[4063,38724],[4063,38921],[4063,43965],
 [4063,44394],[4063,48445],[4064,3507],[4064,3794],[4064,4193],[4064,38455],[4064,38460],
 [4064,38724],[4064,38921],[4064,43965],[4064,44394],[4064,48445],[4065,3507],
 [4065,3794],[4065,38455],[4065,43965],[4065,44200],[4065,44201],[4065,45084],
 [4066,3507],[4066,3794],[4066,38455],[4066,43965],[4066,44200],[4066,44201],[4066,45084],
 [4067,2279],[4067,3507],[4067,3756],[4067,3794],[4067,5705],[4067,6183],[4067,6213],
 [4067,7828],[4067,7996],[4067,8032],[4067,38205],[4067,38418],[4067,38454],[4067,38455],
 [4067,39015],[4067,39313],[4067,39602],[4067,39603],[4067,39631],[4067,40195],
 [4067,40196],[4067,40233],[4067,40450],[4067,43536],[4067,43643],[4067,43965],
 [4067,44174],[4067,44904],[4067,47993],[4068,2279],[4068,3507],[4068,3756],[4068,3794],
 [4068,5705],[4068,6183],[4068,6213],[4068,7828],[4068,7996],[4068,8032],[4068,38205],
 [4068,38418],[4068,38454],[4068,38455],[4068,39015],[4068,39313],[4068,39602],
 [4068,39603],[4068,39631],[4068,40195],[4068,40196],[4068,40233],[4068,40450],
 [4068,43536],[4068,43643],[4068,43965],[4068,44174],[4068,44904],[4068,47993],
 [4069,3794],[4069,44204],[4070,3794],[4070,44205],[4071,3794],[4071,44206],[4072,3794],
 [4072,44207],[4073,3794],[4073,44208],[4074,3794],[4074,44209],[4075,3794],[4075,44210],
 [4076,3794],[4076,44211],[4077,3794],[4077,44212],[4078,3794],[4078,44213],[4079,3794],
 [4079,44214],[4080,3794],[4080,44215],[4081,3794],[4081,44216],[4082,3794],[4082,44217],
 [4083,3794],[4083,44218],[4084,3677],[4084,42109],[4085,3507],[4085,44850,44904],
 [4085,44850,48796],[4085,44851,44904],[4085,44851,48796],[4085,44854,44904],
 [4085,44854,48796],[4085,44904],[4085,44907,44904],[4085,44907,48796],[4085,44932,44904],
 [4085,44932,48796],[4085,48768,44904],[4085,48768,48796],[4085,48771,44904],
 [4085,48771,48796],[4085,48796],[4085,49472,44904],[4085,49472,48796],[4086,3507],
 [4086,44904],[4086,48796],[4087,4193],[4089,3507],[4089,44904],[4089,48796],[4090,3507],
 [4090,38751,38921],[4090,38753,38921],[4090,38921],[4090,48889,38921],[4091,4193],
 [4092,3507],[4092,38921],[4093,3507],[4093,44858,45084],[4093,44859,45084],[4093,45084],
 [4093,48948,45084],[4094,3507],[4094,45084],[4095,3507],[4095,38756,39015],
 [4095,38757,39015],[4095,39015],[4095,48983,39015],[4096,3507],[4096,39015],[4112,3507],
 [4112,44877,44904],[4112,44878,44904],[4112,44904],[4112,49119,44904],[4113,3507],
 [4113,44904],[4114,4193],[4116,3507],[4116,38777,38921],[4116,38777,49217],
 [4116,38778,38921],[4116,38778,49217],[4116,38780,38921],[4116,38780,49217],
 [4116,38898,38921],[4116,38898,49217],[4116,38900,38921],[4116,38900,49217],[4116,38921],
 [4116,49217],[4116,49219,38921],[4116,49219,49217],[4116,49240,38921],[4116,49240,49217],
 [4116,50625,38921],[4116,50625,49217],[4117,3507],[4117,38921],[4117,49217],[4118,4193],
 [4119,3507],[4119,38921],[4119,49217],[4120,3507],[4120,44885,45084],[4120,44886,45084],
 [4120,45084],[4120,49299,45084],[4121,3507],[4121,45084],[4122,3507],[4122,38783,39015],
 [4122,38784,39015],[4122,39015],[4122,49334,39015],[4123,3507],[4123,39015],[4142,3507],
 [4142,44904],[4142,48796],[4148,3507],[4148,38809,39015],[4148,38810,39015],
 [4148,38834,39015],[4148,38835,39015],[4148,39015],[4148,44904],[4148,44913,44904],
 [4148,44914,44904],[4148,44938,44904],[4148,44939,44904],[4148,49478,44904],
 [4148,49479,44904],[4148,49659,39015],[4148,49959,39015],[4149,3507],[4149,39015],
 [4149,44904],[4150,3507],[4150,44904],[4150,44915,44904],[4150,44940,44904],
 [4150,49480,44904],[4151,3507],[4151,44904],[4151,44916,44904],[4151,44941,44904],
 [4151,49481,44904],[4152,3507],[4152,44904],[4152,44917,44904],[4152,44942,44904],
 [4152,49482,44904],[4153,3507],[4153,44904],[4153,44918,44904],[4153,44943,44904],
 [4153,49483,44904],[4154,3507],[4154,44904],[4154,44919,44904],[4154,44919,50046],
 [4154,44926,44904],[4154,44926,50046],[4154,44944,44904],[4154,44944,50046],
 [4154,44951,44904],[4154,44951,50046],[4154,45206,44904],[4154,45206,50046],
 [4154,49484,44904],[4154,49484,50046],[4154,49491,44904],[4154,49491,50046],
 [4154,49746,44904],[4154,49746,50046],[4154,50046],[4155,3507],[4155,44904],
 [4155,44920,44904],[4155,44945,44904],[4155,49485,44904],[4156,3507],[4156,44904],
 [4156,44921,44904],[4156,44946,44904],[4156,49486,44904],[4157,3507],[4157,44904],
 [4157,44922,44904],[4157,44947,44904],[4157,49487,44904],[4158,3507],[4158,44904],
 [4158,44923,44904],[4158,44923,50075],[4158,44925,44904],[4158,44925,50075],
 [4158,44948,44904],[4158,44948,50075],[4158,44950,44904],[4158,44950,50075],
 [4158,45235,44904],[4158,45235,50075],[4158,49488,44904],[4158,49488,50075],
 [4158,49490,44904],[4158,49490,50075],[4158,49775,44904],[4158,49775,50075],[4158,50075],
 [4159,3507],[4159,44904],[4159,44924,44904],[4159,44949,44904],[4159,49489,44904],
 [4160,3507],[4160,44904],[4160,50075],[4161,3507],[4161,44904],[4161,50046],[4162,3507],
 [4162,44904],[4162,44927,44904],[4162,44952,44904],[4162,49492,44904],[4163,3507],
 [4163,44904],[4163,44928,44904],[4163,44953,44904],[4163,49493,44904],[4164,3507],
 [4164,44904],[4164,44929,44904],[4164,44954,44904],[4164,49494,44904],[4167,3507],
 [4167,44904],[4167,48796],[4173,3507],[4173,39015],[4173,44904],[4174,3507],[4174,39015],
 [4174,44904],[4175,3507],[4175,44904],[4176,3507],[4176,44904],[4177,3507],[4177,44904],
 [4178,3507],[4178,44904],[4179,3507],[4179,44904],[4179,50046],[4180,3507],[4180,44904],
 [4181,3507],[4181,44904],[4182,3507],[4182,44904],[4183,3507],[4183,44904],[4183,50075],
 [4184,3507],[4184,44904],[4185,3507],[4185,44904],[4185,50075],[4186,3507],[4186,44904],
 [4186,50046],[4187,3507],[4187,44904],[4188,3507],[4188,44904],[4189,3507],[4189,44904],
 [4190,3756],[4190,4193],[4190,43685],[4190,48035],[4191,4193],[4192,3507],[4192,3794],
 [4192,4193],[4192,38455],[4192,38460],[4192,38724],[4192,38921],[4192,43965],
 [4192,44394],[4192,48445],[4194,3507],[4194,3794],[4194,4193],[4194,38455],[4194,38460],
 [4194,38724],[4194,38921],[4194,43965],[4194,44394],[4194,48445],[4197,3507],
 [4197,4193],[4197,38858,39015],[4197,38859,39015],[4197,38944,39015],[4197,38945,39015],
 [4197,39015],[4197,50235,39015],[4197,51119,39015],[4198,3507],[4198,4193],[4198,39015],
 [4199,4193],[4200,4193],[4201,4193],[4202,4193],[4203,4193],[4204,4193],[4205,4193],
 [4206,4193],[4207,4193],[4208,4193],[4209,4193],[4210,4193],[4211,4193],[4212,4193],
 [4213,4193],[4216,3756],[4216,4193],[4216,43685],[4216,48035],[4218,3507],[4218,45084],
 [4219,3507],[4219,45084],[4220,3507],[4220,38881,39015],[4220,38882,39015],[4220,39015],
 [4220,50488,39015],[4221,3507],[4221,39015],[4237,3507],[4237,38921],[4237,49217],
 [4238,4193],[4239,3507],[4239,38921],[4239,49217],[4240,3507],[4240,45005,45084],
 [4240,45006,45084],[4240,45084],[4240,50684,45084],[4241,3507],[4241,45084],[4242,3507],
 [4242,38903,39015],[4242,38904,39015],[4242,39015],[4242,50719,39015],[4243,3507],
 [4243,39015],[4259,3507],[4259,3794],[4259,4193],[4259,38455],[4259,38460],[4259,38724],
 [4259,38921],[4259,43965],[4259,44394],[4259,48445],[4261,3507],[4261,38921],
 [4261,38922,38921],[4261,38923,38921],[4261,38961,38921],[4261,38962,38921],
 [4261,45026,45084],[4261,45027,45084],[4261,45065,45084],[4261,45066,45084],[4261,45084],
 [4261,50875,38921],[4261,50876,38921],[4261,50894,45084],[4261,51255,45084],[4262,3507],
 [4262,38921],[4262,45084],[4263,3507],[4263,38921],[4263,38924,38921],[4263,38924,39015],
 [4263,38925,38921],[4263,38925,39015],[4263,38963,38921],[4263,38963,39015],
 [4263,38964,38921],[4263,38964,39015],[4263,39015],[4263,50877,38921],[4263,50877,39015],
 [4263,50878,38921],[4263,50878,39015],[4263,50929,38921],[4263,50929,39015],
 [4263,51290,38921],[4263,51290,39015],[4264,3507],[4264,38921],[4264,39015],[4265,3507],
 [4265,38921],[4265,38926,38921],[4265,38965,38921],[4265,50879,38921],[4266,3507],
 [4266,38921],[4266,38927,38921],[4266,38966,38921],[4266,50880,38921],[4267,3507],
 [4267,38921],[4267,38928,38921],[4267,38967,38921],[4267,50881,38921],[4268,3507],
 [4268,38921],[4268,38929,38921],[4268,38929,51006],[4268,38937,38921],[4268,38937,51006],
 [4268,38968,38921],[4268,38968,51006],[4268,38976,38921],[4268,38976,51006],
 [4268,39092,38921],[4268,39092,51006],[4268,50882,38921],[4268,50882,51006],
 [4268,50890,38921],[4268,50890,51006],[4268,51006],[4268,51367,38921],[4268,51367,51006],
 [4269,3507],[4269,38921],[4269,38930,38921],[4269,38969,38921],[4269,50883,38921],
 [4270,3507],[4270,38921],[4270,38931,38921],[4270,38970,38921],[4270,50884,38921],
 [4271,3507],[4271,38921],[4271,38932,38921],[4271,38971,38921],[4271,50885,38921],
 [4272,3507],[4272,38921],[4272,38933,38921],[4272,38972,38921],[4272,50886,38921],
 [4273,3507],[4273,38921],[4273,38934,38921],[4273,38973,38921],[4273,50887,38921],
 [4274,3507],[4274,38921],[4274,38935,38921],[4274,38935,51050],[4274,38936,38921],
 [4274,38936,51050],[4274,38974,38921],[4274,38974,51050],[4274,38975,38921],
 [4274,38975,51050],[4274,39136,38921],[4274,39136,51050],[4274,50888,38921],
 [4274,50888,51050],[4274,50889,38921],[4274,50889,51050],[4274,51050],[4274,51411,38921],
 [4274,51411,51050],[4275,3507],[4275,38921],[4275,51050],[4276,3507],[4276,38921],
 [4276,51006],[4277,3507],[4277,38921],[4277,38938,38921],[4277,38977,38921],
 [4277,50891,38921],[4278,3507],[4278,38921],[4278,38939,38921],[4278,38978,38921],
 [4278,50892,38921],[4279,3507],[4279,38921],[4279,38940,38921],[4279,38979,38921],
 [4279,50893,38921],[4280,3507],[4280,3794],[4280,4193],[4280,38455],[4280,38460],
 [4280,38724],[4280,38921],[4280,43965],[4280,44394],[4280,48445],[4283,3507],
 [4283,4193],[4283,39015],[4284,3507],[4284,4193],[4284,39015],[4285,4193],[4286,4193],
 [4287,4193],[4288,4193],[4289,4193],[4290,4193],[4291,4193],[4292,4193],[4293,4193],
 [4294,4193],[4295,4193],[4296,4193],[4297,4193],[4298,4193],[4299,4193],[4300,3507],
 [4300,38921],[4300,45084],[4301,3507],[4301,38921],[4301,45084],[4302,3507],[4302,38921],
 [4302,39015],[4303,3507],[4303,38921],[4303,39015],[4304,3507],[4304,38921],[4305,3507],
 [4305,38921],[4306,3507],[4306,38921],[4307,3507],[4307,38921],[4307,51006],[4308,3507],
 [4308,38921],[4309,3507],[4309,38921],[4310,3507],[4310,38921],[4311,3507],[4311,38921],
 [4312,3507],[4312,38921],[4313,3507],[4313,38921],[4313,51050],[4314,3507],[4314,38921],
 [4314,51050],[4315,3507],[4315,38921],[4315,51006],[4316,3507],[4316,38921],[4317,3507],
 [4317,38921],[4318,3507],[4318,38921],[4320,3507],[4320,3677],[4320,3714],[4320,38331],
 [4320,38557],[4320,39015],[4320,41850],[4320,42362],[4320,42593],[4320,43104],
 [4320,45084],[4320,46241],[4320,47266],[4321,3507],[4321,3677],[4321,3714],[4321,38331],
 [4321,38557],[4321,39015],[4321,41850],[4321,42362],[4321,42593],[4321,43104],
 [4321,45084],[4321,46241],[4321,47266],[4322,3507],[4322,45084],[4322,45087,45084],
 [4322,45104,45084],[4322,51428,45084],[4323,3507],[4323,45084],[4323,45088,45084],
 [4323,45105,45084],[4323,51429,45084],[4324,3507],[4324,45084],[4324,45089,45084],
 [4324,45106,45084],[4324,51430,45084],[4325,3507],[4325,45084],[4325,45090,45084],
 [4325,45107,45084],[4325,51431,45084],[4326,3507],[4326,45084],[4326,45091,45084],
 [4326,45108,45084],[4326,51432,45084],[4327,3507],[4327,45084],[4327,45092,45084],
 [4327,45109,45084],[4327,51433,45084],[4328,3507],[4328,45084],[4328,45093,45084],
 [4328,45110,45084],[4328,51434,45084],[4329,3507],[4329,45084],[4329,45094,45084],
 [4329,45111,45084],[4329,51435,45084],[4330,3507],[4330,45084],[4330,45095,45084],
 [4330,45112,45084],[4330,51436,45084],[4331,3507],[4331,45084],[4331,45096,45084],
 [4331,45113,45084],[4331,51437,45084],[4332,3507],[4332,45084],[4332,45097,45084],
 [4332,45114,45084],[4332,51438,45084],[4333,3507],[4333,45084],[4333,45098,45084],
 [4333,45115,45084],[4333,51439,45084],[4334,3507],[4334,45084],[4334,45099,45084],
 [4334,45116,45084],[4334,51440,45084],[4335,3507],[4335,45084],[4335,45100,45084],
 [4335,45117,45084],[4335,51441,45084],[4336,3507],[4336,45084],[4336,45101,45084],
 [4336,45118,45084],[4336,51442,45084],[4337,3507],[4337,3677],[4337,3714],[4337,38331],
 [4337,38557],[4337,39015],[4337,41850],[4337,42362],[4337,42593],[4337,43104],
 [4337,45084],[4337,46241],[4337,47266],[4338,3507],[4338,3677],[4338,3714],[4338,38331],
 [4338,38557],[4338,39015],[4338,41850],[4338,42362],[4338,42593],[4338,43104],
 [4338,45084],[4338,46241],[4338,47266],[4339,3507],[4339,45084],[4340,3507],[4340,45084],
 [4341,3507],[4341,45084],[4342,3507],[4342,45084],[4343,3507],[4343,45084],[4344,3507],
 [4344,45084],[4345,3507],[4345,45084],[4346,3507],[4346,45084],[4347,3507],[4347,45084],
 [4348,3507],[4348,45084],[4349,3507],[4349,45084],[4350,3507],[4350,45084],[4351,3507],
 [4351,45084],[4352,3507],[4352,45084],[4353,3507],[4353,45084],[4355,3507],[4355,39015],
 [4355,39016,39015],[4355,39031,39015],[4355,51715,39015],[4356,3507],[4356,39015],
 [4356,39017,39015],[4356,39032,39015],[4356,51716,39015],[4357,3507],[4357,39015],
 [4357,39018,39015],[4357,39033,39015],[4357,51717,39015],[4358,3507],[4358,39015],
 [4358,39019,39015],[4358,39034,39015],[4358,51718,39015],[4359,3507],[4359,39015],
 [4359,39020,39015],[4359,39035,39015],[4359,51719,39015],[4360,3507],[4360,39015],
 [4360,39021,39015],[4360,39036,39015],[4360,51720,39015],[4361,3507],[4361,39015],
 [4361,39022,39015],[4361,39037,39015],[4361,51721,39015],[4362,3507],[4362,39015],
 [4362,39023,39015],[4362,39038,39015],[4362,51722,39015],[4363,3507],[4363,39015],
 [4363,39024,39015],[4363,39039,39015],[4363,51723,39015],[4364,3507],[4364,39015],
 [4364,39025,39015],[4364,39040,39015],[4364,51724,39015],[4365,3507],[4365,39015],
 [4365,39026,39015],[4365,39041,39015],[4365,51725,39015],[4366,3507],[4366,39015],
 [4366,39027,39015],[4366,39042,39015],[4366,51726,39015],[4367,3507],[4367,39015],
 [4367,39028,39015],[4367,39043,39015],[4367,51727,39015],[4368,3507],[4368,39015],
 [4368,39029,39015],[4368,39044,39015],[4368,51728,39015],[4369,3507],[4369,39015],
 [4369,39030,39015],[4369,39045,39015],[4369,51729,39015],[4370,3507],[4370,39015],
 [4371,3507],[4371,39015],[4372,3507],[4372,39015],[4373,3507],[4373,39015],[4374,3507],
 [4374,39015],[4375,3507],[4375,39015],[4376,3507],[4376,39015],[4377,3507],[4377,39015],
 [4378,3507],[4378,39015],[4379,3507],[4379,39015],[4380,3507],[4380,39015],[4381,3507],
 [4381,39015],[4382,3507],[4382,39015],[4383,3507],[4383,39015],[4384,3507],[4384,39015],
 [4385,3507],[4385,41069],[4385,45745],[4386,3677],[4386,47331],[4399,3507],[4399,38205],
 [4399,40824],[4424,3677],[4424,42449],[4429,14514],[4431,3507],[4431,38921],[4431,51006],
 [4438,14523],[4441,3507],[4441,44904],[4441,50046],[4445,3507],[4445,38205],[4445,40870],
 [4446,3507],[4446,41069],[4446,45806],[4452,19848],[4454,3677],[4454,47399],[4461,19857],
 [4466,19862],[4469,3677],[4469,42494],[4470,3507],[4470,44904],[4470,50075],[4475,3507],
 [4475,38921],[4475,51050],[4480,14565],[4487,3507],[4487,41069],[4487,45847],
 [4488,3677],[4488,47433],[4489,3507],[4489,38205],[4489,40914],[4490,2279],[4491,2279],
 [4492,2279],[4493,2279],[4494,2279],[4495,2279],[4496,2279],[4497,2279],[4498,2279],
 [4499,2279],[4500,2279],[4501,2279],[4502,2279],[4503,2279],[4504,2279],[4505,2279],
 [4506,2279],[4507,2279],[4508,2279],[4509,2279],[4513,1291],[4513,1306],[4513,1336],
 [4513,1377],[4513,1432],[4513,1625],[4513,1658],[4513,1698],[4513,1761],[4513,2279],
 [4513,3507],[4513,3677],[4513,3714],[4513,5705],[4513,6018],[4513,6050],[4513,7828],
 [4513,7875],[4513,7950],[4513,38205],[4513,38304],[4513,38331],[4513,38557],[4513,38921],
 [4513,39193],[4513,39424],[4513,39779],[4513,40055],[4513,40287],[4513,40642],
 [4513,41069],[4513,41217],[4513,41411],[4513,41850],[4513,41900],[4513,42193],
 [4513,42593],[4513,42936],[4513,44904],[4513,45501],[4513,46064],[4513,47090],
 [4514,1291],[4514,1306],[4514,1336],[4514,1377],[4514,1432],[4514,1625],[4514,1658],
 [4514,1698],[4514,1761],[4514,2279],[4514,3507],[4514,3677],[4514,3714],[4514,5705],
 [4514,6018],[4514,6050],[4514,7828],[4514,7875],[4514,7950],[4514,38205],[4514,38304],
 [4514,38331],[4514,38557],[4514,38921],[4514,39193],[4514,39424],[4514,39779],
 [4514,40055],[4514,40287],[4514,40642],[4514,41069],[4514,41217],[4514,41411],
 [4514,41850],[4514,41900],[4514,42193],[4514,42593],[4514,42936],[4514,44904],
 [4514,45501],[4514,46064],[4514,47090],[4515,2279],[4515,3714],[4515,6050],[4515,7950],
 [4515,42671],[4516,2279],[4516,3507],[4516,3756],[4516,3794],[4516,5705],[4516,6183],
 [4516,6213],[4516,7828],[4516,7996],[4516,8032],[4516,38205],[4516,38418],[4516,38454],
 [4516,38455],[4516,39015],[4516,39313],[4516,39602],[4516,39603],[4516,39631],
 [4516,40195],[4516,40196],[4516,40233],[4516,40450],[4516,43536],[4516,43643],
 [4516,43965],[4516,44174],[4516,44904],[4516,47993],[4517,2279],[4517,3507],[4517,3756],
 [4517,3794],[4517,5705],[4517,6183],[4517,6213],[4517,7828],[4517,7996],[4517,8032],
 [4517,38205],[4517,38418],[4517,38454],[4517,38455],[4517,39015],[4517,39313],
 [4517,39602],[4517,39603],[4517,39631],[4517,40195],[4517,40196],[4517,40233],
 [4517,40450],[4517,43536],[4517,43643],[4517,43965],[4517,44174],[4517,44904],
 [4517,47993],[4519,1291],[4519,1306],[4519,1336],[4519,1377],[4519,1432],[4519,1625],
 [4519,1658],[4519,1698],[4519,1761],[4519,2279],[4519,3507],[4519,3677],[4519,3714],
 [4519,5705],[4519,6018],[4519,6050],[4519,7828],[4519,7875],[4519,7950],[4519,38205],
 [4519,38304],[4519,38331],[4519,38557],[4519,38921],[4519,39193],[4519,39424],
 [4519,39779],[4519,40055],[4519,40287],[4519,40642],[4519,41069],[4519,41217],
 [4519,41411],[4519,41850],[4519,41900],[4519,42193],[4519,42593],[4519,42936],
 [4519,44904],[4519,45501],[4519,46064],[4519,47090],[4520,2279],[4520,3714],[4520,6050],
 [4520,7950],[4520,42671],[4521,2279],[4521,3507],[4521,3930],[4521,4193],[4521,5705],
 [4521,6152],[4521,6340],[4521,7828],[4521,8168],[4521,8507],[4521,38205],[4521,38591],
 [4521,39759],[4521,40707],[4521,44695],[4521,44702],[4521,44769],[4521,44904],
 [4521,45084],[4521,46593],[4521,46621],[4521,46645],[4521,47556],[4521,47575],
 [4521,47691],[4521,49500],[4521,49501],[4521,49886],[4521,49887],[4522,1291],
 [4522,1306],[4522,1336],[4522,1377],[4522,1432],[4522,1625],[4522,1658],[4522,1698],
 [4522,1761],[4522,2279],[4522,3507],[4522,3677],[4522,3714],[4522,5705],[4522,6018],
 [4522,6050],[4522,7828],[4522,7875],[4522,7950],[4522,38205],[4522,38304],[4522,38331],
 [4522,38557],[4522,38921],[4522,39193],[4522,39424],[4522,39779],[4522,40055],
 [4522,40287],[4522,40642],[4522,41069],[4522,41217],[4522,41411],[4522,41850],
 [4522,41900],[4522,42193],[4522,42593],[4522,42936],[4522,44904],[4522,45501],
 [4522,46064],[4522,47090],[4523,2279],[4523,3507],[4523,3930],[4523,4193],[4523,5705],
 [4523,6152],[4523,6340],[4523,7828],[4523,8168],[4523,8507],[4523,38205],[4523,38591],
 [4523,39759],[4523,40707],[4523,44695],[4523,44702],[4523,44769],[4523,44904],
 [4523,45084],[4523,46593],[4523,46621],[4523,46645],[4523,47556],[4523,47575],
 [4523,47691],[4523,49500],[4523,49501],[4523,49886],[4523,49887],[4524,2279],
 [4524,3507],[4524,3756],[4524,3794],[4524,5705],[4524,6183],[4524,6213],[4524,7828],
 [4524,7996],[4524,8032],[4524,38205],[4524,38418],[4524,38454],[4524,38455],[4524,39015],
 [4524,39313],[4524,39602],[4524,39603],[4524,39631],[4524,40195],[4524,40196],
 [4524,40233],[4524,40450],[4524,43536],[4524,43643],[4524,43965],[4524,44174],
 [4524,44904],[4524,47993],[4525,2279],[4525,3507],[4525,3756],[4525,3794],[4525,5705],
 [4525,6183],[4525,6213],[4525,7828],[4525,7996],[4525,8032],[4525,38205],[4525,38418],
 [4525,38454],[4525,38455],[4525,39015],[4525,39313],[4525,39602],[4525,39603],
 [4525,39631],[4525,40195],[4525,40196],[4525,40233],[4525,40450],[4525,43536],
 [4525,43643],[4525,43965],[4525,44174],[4525,44904],[4525,47993],[4526,2279],
 [4527,2279],[4530,2279],[4530,3507],[4530,3930],[4530,4193],[4530,5705],[4530,6152],
 [4530,6340],[4530,7828],[4530,8168],[4530,8507],[4530,38205],[4530,38591],[4530,39759],
 [4530,40707],[4530,44695],[4530,44702],[4530,44769],[4530,44904],[4530,45084],
 [4530,46593],[4530,46621],[4530,46645],[4530,47556],[4530,47575],[4530,47691],
 [4530,49500],[4530,49501],[4530,49886],[4530,49887],[4531,2279],[4531,3714],[4531,6050],
 [4531,7950],[4531,42671],[4532,2279],[4533,1291],[4533,1306],[4533,1336],[4533,1377],
 [4533,1432],[4533,1625],[4533,1658],[4533,1698],[4533,1761],[4533,2279],[4533,3507],
 [4533,3677],[4533,3714],[4533,5705],[4533,6018],[4533,6050],[4533,7828],[4533,7875],
 [4533,7950],[4533,38205],[4533,38304],[4533,38331],[4533,38557],[4533,38921],
 [4533,39193],[4533,39424],[4533,39779],[4533,40055],[4533,40287],[4533,40642],
 [4533,41069],[4533,41217],[4533,41411],[4533,41850],[4533,41900],[4533,42193],
 [4533,42593],[4533,42936],[4533,44904],[4533,45501],[4533,46064],[4533,47090],
 [4534,2279],[4534,3507],[4534,3930],[4534,4193],[4534,5705],[4534,6152],[4534,6340],
 [4534,7828],[4534,8168],[4534,8507],[4534,38205],[4534,38591],[4534,39759],[4534,40707],
 [4534,44695],[4534,44702],[4534,44769],[4534,44904],[4534,45084],[4534,46593],
 [4534,46621],[4534,46645],[4534,47556],[4534,47575],[4534,47691],[4534,49500],
 [4534,49501],[4534,49886],[4534,49887],[4535,1291],[4535,1306],[4535,1336],[4535,1377],
 [4535,1432],[4535,1625],[4535,1658],[4535,1698],[4535,1761],[4535,2279],[4535,3507],
 [4535,3677],[4535,3714],[4535,5705],[4535,6018],[4535,6050],[4535,7828],[4535,7875],
 [4535,7950],[4535,38205],[4535,38304],[4535,38331],[4535,38557],[4535,38921],
 [4535,39193],[4535,39424],[4535,39779],[4535,40055],[4535,40287],[4535,40642],
 [4535,41069],[4535,41217],[4535,41411],[4535,41850],[4535,41900],[4535,42193],
 [4535,42593],[4535,42936],[4535,44904],[4535,45501],[4535,46064],[4535,47090],
 [4536,2279],[4536,3507],[4536,3930],[4536,4193],[4536,5705],[4536,6152],[4536,6340],
 [4536,7828],[4536,8168],[4536,8507],[4536,38205],[4536,38591],[4536,39759],[4536,40707],
 [4536,44695],[4536,44702],[4536,44769],[4536,44904],[4536,45084],[4536,46593],
 [4536,46621],[4536,46645],[4536,47556],[4536,47575],[4536,47691],[4536,49500],
 [4536,49501],[4536,49886],[4536,49887],[4537,2279],[4537,3507],[4537,3930],[4537,4193],
 [4537,5705],[4537,6152],[4537,6340],[4537,7828],[4537,8168],[4537,8507],[4537,38205],
 [4537,38591],[4537,39759],[4537,40707],[4537,44695],[4537,44702],[4537,44769],
 [4537,44904],[4537,45084],[4537,46593],[4537,46621],[4537,46645],[4537,47556],
 [4537,47575],[4537,47691],[4537,49500],[4537,49501],[4537,49886],[4537,49887],
 [4538,2279],[4538,3507],[4538,3756],[4538,3794],[4538,5705],[4538,6183],[4538,6213],
 [4538,7828],[4538,7996],[4538,8032],[4538,38205],[4538,38418],[4538,38454],[4538,38455],
 [4538,39015],[4538,39313],[4538,39602],[4538,39603],[4538,39631],[4538,40195],
 [4538,40196],[4538,40233],[4538,40450],[4538,43536],[4538,43643],[4538,43965],
 [4538,44174],[4538,44904],[4538,47993],[4539,2279],[4539,3507],[4539,3756],[4539,3794],
 [4539,5705],[4539,6183],[4539,6213],[4539,7828],[4539,7996],[4539,8032],[4539,38205],
 [4539,38418],[4539,38454],[4539,38455],[4539,39015],[4539,39313],[4539,39602],
 [4539,39603],[4539,39631],[4539,40195],[4539,40196],[4539,40233],[4539,40450],
 [4539,43536],[4539,43643],[4539,43965],[4539,44174],[4539,44904],[4539,47993],
 [4540,2279],[4541,2279],[4542,2279],[4543,2279],[4544,2279],[4545,2279],[4546,2279],
 [4547,2279],[4548,2279],[4549,2279],[4550,2279],[4551,2279],[4552,2279],[4553,2279],
 [4554,2279],[4555,8715],[4556,8715],[4558,202],[4558,1336],[4558,9788],[4558,17232],
 [4559,4995,5705],[4559,5012,5705],[4559,5705],[4559,8962],[4559,22190,39193],
 [4559,22191,39193],[4559,22205,5705],[4559,22274,39193],[4559,39193],[4561,5705],
 [4561,8962],[4561,39193],[4574,4575,5705],[4574,4592,5705],[4574,5705],[4574,9801,5705],
 [4574,38205],[4576,5705],[4576,38205],[4577,5705],[4577,9786,39193],[4577,9787,39193],
 [4577,9870,39193],[4577,39193],[4578,5705],[4578,39193],[4579,202],[4579,1336],
 [4579,9788],[4579,17232],[4580,5705],[4580,9789,39313],[4580,9790,39313],
 [4580,9990,39313],[4580,39313],[4581,5705],[4581,39313],[4582,5705],[4582,44904],
 [4583,6018],[4583,6050],[4583,10114],[4583,10146],[4584,6018],[4584,6050],[4584,10114],
 [4584,10146],[4585,5705],[4585,10176,46593],[4585,10182,46593],[4585,10385,46593],
 [4585,46593],[4586,5705],[4586,10208,47090],[4586,10215,47090],[4586,10386,47090],
 [4586,47090],[4587,6152],[4588,6183],[4588,10279],[4589,6213],[4593,5705],[4593,44904],
 [4594,6340],[4594,10436],[4595,6018],[4595,6050],[4595,10114],[4595,10146],[4597,6018],
 [4597,6050],[4597,10114],[4597,10146],[4598,5705],[4598,46593],[4599,5705],[4599,47090],
 [4600,6340],[4600,10436],[4601,6152],[4602,6183],[4602,10279],[4603,6213],[4619,8715],
 [4621,10854],[4622,10854],[4637,4638,5705],[4637,4655,5705],[4637,5705],[4637,11754,5705],
 [4637,38205],[4639,5705],[4639,38205],[4640,5705],[4640,11739,39193],[4640,11740,39193],
 [4640,11823,39193],[4640,39193],[4641,5705],[4641,39193],[4643,5705],[4643,11742,39313],
 [4643,11743,39313],[4643,11943,39313],[4643,39313],[4644,5705],[4644,39313],[4645,5705],
 [4645,44904],[4646,6018],[4646,6050],[4646,12067],[4646,12099],[4647,6018],[4647,6050],
 [4647,12067],[4647,12099],[4648,5705],[4648,12129,46593],[4648,12135,46593],
 [4648,12338,46593],[4648,46593],[4649,5705],[4649,12161,47090],[4649,12168,47090],
 [4649,12339,47090],[4649,47090],[4650,6152],[4651,6183],[4651,12232],[4652,6213],
 [4656,5705],[4656,44904],[4657,6340],[4657,12389],[4658,6018],[4658,6050],[4658,12067],
 [4658,12099],[4660,6018],[4660,6050],[4660,12067],[4660,12099],[4661,5705],[4661,46593],
 [4662,5705],[4662,47090],[4663,6340],[4663,12389],[4664,6152],[4665,6183],[4665,12232],
 [4666,6213],[4683,5705],[4683,12747],[4683,38205],[4684,328],[4686,5705],[4686,12747],
 [4686,38205],[4687,12979],[4688,12979],[4699,4700,5705],[4699,4717,5705],[4699,5705],
 [4699,13645,5705],[4699,38205],[4701,5705],[4701,38205],[4702,5705],[4702,13630,39193],
 [4702,13631,39193],[4702,13714,39193],[4702,39193],[4703,5705],[4703,39193],[4705,5705],
 [4705,13633,39313],[4705,13634,39313],[4705,13834,39313],[4705,39313],[4706,5705],
 [4706,39313],[4707,5705],[4707,44904],[4708,6018],[4708,13958],[4709,6050],[4709,13990],
 [4710,5705],[4710,14020,46593],[4710,14026,46593],[4710,14229,46593],[4710,46593],
 [4711,5705],[4711,14052,47090],[4711,14059,47090],[4711,14230,47090],[4711,47090],
 [4712,6152],[4713,6183],[4713,14123],[4714,6213],[4718,5705],[4718,44904],[4719,6340],
 [4719,14280],[4720,6050],[4720,13990],[4722,6018],[4722,13958],[4723,5705],[4723,46593],
 [4724,5705],[4724,47090],[4725,6340],[4725,14280],[4726,6152],[4727,6183],[4727,14123],
 [4728,6213],[4732,14514],[4733,14523],[4737,14523],[4738,14514],[4739,14565],
 [4740,14565],[4745,14635],[4746,14635],[4760,4761,5705],[4760,4778,5705],[4760,5705],
 [4760,15475,5705],[4760,38205],[4762,5705],[4762,38205],[4763,5705],[4763,15460,39193],
 [4763,15461,39193],[4763,15544,39193],[4763,39193],[4764,5705],[4764,39193],[4766,5705],
 [4766,15463,39313],[4766,15464,39313],[4766,15664,39313],[4766,39313],[4767,5705],
 [4767,39313],[4768,5705],[4768,44904],[4769,6018],[4769,15788],[4769,15887],[4770,6050],
 [4770,15820],[4771,5705],[4771,15850,46593],[4771,15856,46593],[4771,16059,46593],
 [4771,46593],[4772,5705],[4772,15882,47090],[4772,15889,47090],[4772,16060,47090],
 [4772,47090],[4773,6152],[4774,6183],[4774,15953],[4775,6213],[4779,5705],[4779,44904],
 [4780,6340],[4780,16110],[4781,6050],[4781,15820],[4783,6018],[4783,15788],[4783,15887],
 [4784,5705],[4784,46593],[4785,5705],[4785,47090],[4786,6340],[4786,16110],[4787,6152],
 [4788,6183],[4788,15953],[4789,6213],[4805,10854],[4807,5705],[4807,12747],[4807,38205],
 [4820,4821,5705],[4820,4838,5705],[4820,5705],[4820,17245,5705],[4820,38205],[4822,5705],
 [4822,38205],[4823,5705],[4823,17230,39193],[4823,17231,39193],[4823,17314,39193],
 [4823,39193],[4824,5705],[4824,39193],[4825,202],[4825,1336],[4825,9788],[4825,17232],
 [4826,5705],[4826,17233,39313],[4826,17234,39313],[4826,17434,39313],[4826,39313],
 [4827,5705],[4827,39313],[4828,5705],[4828,44904],[4829,6018],[4829,6050],[4829,17558],
 [4829,17590],[4830,6018],[4830,6050],[4830,17558],[4830,17590],[4831,5705],
 [4831,17620,46593],[4831,17626,46593],[4831,17829,46593],[4831,46593],[4832,5705],
 [4832,17652,47090],[4832,17659,47090],[4832,17830,47090],[4832,47090],[4833,6152],
 [4834,6183],[4834,17723],[4835,6213],[4839,5705],[4839,44904],[4840,6340],[4840,17880],
 [4841,6018],[4841,6050],[4841,17558],[4841,17590],[4843,6018],[4843,6050],[4843,17558],
 [4843,17590],[4844,5705],[4844,46593],[4845,5705],[4845,47090],[4846,6340],[4846,17880],
 [4847,6152],[4848,6183],[4848,17723],[4849,6213],[4865,14635],[4866,5705],[4866,8962],
 [4866,39193],[4879,4880,5705],[4879,4897,5705],[4879,5705],[4879,18956,5705],[4879,38205],
 [4881,5705],[4881,38205],[4882,5705],[4882,18941,39193],[4882,18942,39193],
 [4882,19025,39193],[4882,39193],[4883,5705],[4883,39193],[4885,5705],[4885,18944,39313],
 [4885,18945,39313],[4885,19145,39313],[4885,39313],[4886,5705],[4886,39313],[4887,5705],
 [4887,44904],[4888,6018],[4888,19269],[4889,6050],[4889,19301],[4890,5705],
 [4890,19331,46593],[4890,19337,46593],[4890,19540,46593],[4890,46593],[4891,5705],
 [4891,19363,47090],[4891,19370,47090],[4891,19541,47090],[4891,47090],[4892,6152],
 [4893,6183],[4893,19434],[4894,6213],[4898,5705],[4898,44904],[4899,6340],[4899,19591],
 [4900,6050],[4900,19301],[4902,6018],[4902,19269],[4903,5705],[4903,46593],[4904,5705],
 [4904,47090],[4905,6340],[4905,19591],[4906,6152],[4907,6183],[4907,19434],[4908,6213],
 [4914,19848],[4915,19857],[4916,19862],[4921,19862],[4922,19848],[4923,19857],
 [4937,4938,5705],[4937,4955,5705],[4937,5705],[4937,20609,5705],[4937,38205],[4939,5705],
 [4939,38205],[4940,5705],[4940,20594,39193],[4940,20595,39193],[4940,20678,39193],
 [4940,39193],[4941,5705],[4941,39193],[4943,5705],[4943,20597,39313],[4943,20598,39313],
 [4943,20798,39313],[4943,39313],[4944,5705],[4944,39313],[4945,5705],[4945,44904],
 [4946,6018],[4946,20922],[4947,6050],[4947,20954],[4948,5705],[4948,20984,46593],
 [4948,20990,46593],[4948,21193,46593],[4948,46593],[4949,5705],[4949,21016,47090],
 [4949,21023,47090],[4949,21194,47090],[4949,47090],[4950,6152],[4951,6183],[4951,21087],
 [4952,6213],[4956,5705],[4956,44904],[4957,6340],[4957,21244],[4958,6050],[4958,20954],
 [4960,6018],[4960,20922],[4961,5705],[4961,46593],[4962,5705],[4962,47090],[4963,6340],
 [4963,21244],[4964,6152],[4965,6183],[4965,21087],[4966,6213],[4994,5705],[4994,12747],
 [4994,38205],[4996,5705],[4996,12747],[4996,38205],[4997,5705],[4997,8962],[4997,39193],
 [4998,5705],[4998,8962],[4998,39193],[5000,5705],[5000,22193,39313],[5000,22194,39313],
 [5000,22394,39313],[5000,39313],[5001,5705],[5001,39313],[5002,5705],[5002,44904],
 [5003,6018],[5003,22518],[5004,6050],[5004,22550],[5005,5705],[5005,22580,46593],
 [5005,22586,46593],[5005,22789,46593],[5005,46593],[5006,5705],[5006,22612,47090],
 [5006,22619,47090],[5006,22790,47090],[5006,47090],[5007,6152],[5008,6183],[5008,22683],
 [5009,6213],[5013,5705],[5013,44904],[5014,6340],[5014,22840],[5015,6050],[5015,22550],
 [5017,6018],[5017,22518],[5018,5705],[5018,46593],[5019,5705],[5019,47090],[5020,6340],
 [5020,22840],[5021,6152],[5022,6183],[5022,22683],[5023,6213],[5039,12979],
 [5050,5051,5705],[5050,5068,5705],[5050,5705],[5050,23745,5705],[5050,38205],[5052,5705],
 [5052,38205],[5053,5705],[5053,23730,39193],[5053,23731,39193],[5053,23814,39193],
 [5053,39193],[5054,5705],[5054,39193],[5056,5705],[5056,23733,39313],[5056,23734,39313],
 [5056,23934,39313],[5056,39313],[5057,5705],[5057,39313],[5058,5705],[5058,44904],
 [5059,6018],[5059,24058],[5060,6050],[5060,24090],[5061,5705],[5061,24120,46593],
 [5061,24126,46593],[5061,24329,46593],[5061,46593],[5062,5705],[5062,24152,47090],
 [5062,24159,47090],[5062,24330,47090],[5062,47090],[5063,6152],[5064,6183],[5064,24223],
 [5065,6213],[5069,5705],[5069,44904],[5070,6340],[5070,24380],[5071,6050],[5071,24090],
 [5073,6018],[5073,24058],[5074,5705],[5074,46593],[5075,5705],[5075,47090],[5076,6340],
 [5076,24380],[5077,6152],[5078,6183],[5078,24223],[5079,6213],[5105,5106,5705],
 [5105,5123,5705],[5105,5705],[5105,25230,5705],[5105,38205],[5107,5705],[5107,38205],
 [5108,5705],[5108,25215,39193],[5108,25216,39193],[5108,25299,39193],[5108,39193],
 [5109,5705],[5109,39193],[5111,5705],[5111,25218,39313],[5111,25219,39313],
 [5111,25419,39313],[5111,39313],[5112,5705],[5112,39313],[5113,5705],[5113,44904],
 [5114,6018],[5114,25543],[5115,6050],[5115,25575],[5116,5705],[5116,25605,46593],
 [5116,25611,46593],[5116,25814,46593],[5116,46593],[5117,5705],[5117,25637,47090],
 [5117,25644,47090],[5117,25815,47090],[5117,47090],[5118,6152],[5119,6183],[5119,25708],
 [5120,6213],[5124,5705],[5124,44904],[5125,6340],[5125,25865],[5126,6050],[5126,25575],
 [5128,6018],[5128,25543],[5129,5705],[5129,46593],[5130,5705],[5130,47090],[5131,6340],
 [5131,25865],[5132,6152],[5133,6183],[5133,25708],[5134,6213],[5150,26160],[5151,26160],
 [5153,26316],[5154,26316],[5157,26510],[5158,26510],[5159,5160,5705],[5159,5177,5705],
 [5159,5705],[5159,26661,5705],[5159,38205],[5161,5705],[5161,38205],[5162,5705],
 [5162,26646,39193],[5162,26647,39193],[5162,26730,39193],[5162,39193],[5163,5705],
 [5163,39193],[5165,5705],[5165,26649,39313],[5165,26650,39313],[5165,26850,39313],
 [5165,39313],[5166,5705],[5166,39313],[5167,5705],[5167,44904],[5168,6018],[5168,26974],
 [5169,6050],[5169,27006],[5170,5705],[5170,27036,46593],[5170,27042,46593],
 [5170,27245,46593],[5170,46593],[5171,5705],[5171,27068,47090],[5171,27075,47090],
 [5171,27246,47090],[5171,47090],[5172,6152],[5173,6183],[5173,27139],[5174,6213],
 [5178,5705],[5178,44904],[5179,6340],[5179,27296],[5180,6050],[5180,27006],[5182,6018],
 [5182,26974],[5183,5705],[5183,46593],[5184,5705],[5184,47090],[5185,6340],[5185,27296],
 [5186,6152],[5187,6183],[5187,27139],[5188,6213],[5204,26160],[5205,27643],[5206,27643],
 [5209,27841],[5210,27841],[5212,5213,5705],[5212,5230,5705],[5212,5705],[5212,28039,5705],
 [5212,38205],[5214,5705],[5214,38205],[5215,5705],[5215,28024,39193],[5215,28025,39193],
 [5215,28108,39193],[5215,39193],[5216,5705],[5216,39193],[5218,5705],[5218,28027,39313],
 [5218,28028,39313],[5218,28228,39313],[5218,39313],[5219,5705],[5219,39313],[5220,5705],
 [5220,44904],[5221,6018],[5221,28352],[5222,6050],[5222,28384],[5223,5705],
 [5223,28414,46593],[5223,28420,46593],[5223,28623,46593],[5223,46593],[5224,5705],
 [5224,28446,47090],[5224,28453,47090],[5224,28624,47090],[5224,47090],[5225,6152],
 [5226,6183],[5226,28517],[5227,6213],[5231,5705],[5231,44904],[5232,6340],[5232,28674],
 [5233,6050],[5233,28384],[5235,6018],[5235,28352],[5236,5705],[5236,46593],[5237,5705],
 [5237,47090],[5238,6340],[5238,28674],[5239,6152],[5240,6183],[5240,28517],[5241,6213],
 [5257,28970],[5259,28970],[5261,29168],[5263,29168],[5264,5265,5705],[5264,5282,5705],
 [5264,5705],[5264,29365,5705],[5264,38205],[5266,5705],[5266,38205],[5267,5705],
 [5267,29350,39193],[5267,29351,39193],[5267,29434,39193],[5267,39193],[5268,5705],
 [5268,39193],[5270,5705],[5270,29353,39313],[5270,29354,39313],[5270,29554,39313],
 [5270,39313],[5271,5705],[5271,39313],[5272,5705],[5272,44904],[5273,6018],[5273,29678],
 [5274,6050],[5274,29710],[5275,5705],[5275,29740,46593],[5275,29746,46593],
 [5275,29949,46593],[5275,46593],[5276,5705],[5276,29772,47090],[5276,29779,47090],
 [5276,29950,47090],[5276,47090],[5277,6152],[5278,6183],[5278,29843],[5279,6213],
 [5283,5705],[5283,44904],[5284,6340],[5284,30000],[5285,6050],[5285,29710],[5287,6018],
 [5287,29678],[5288,5705],[5288,46593],[5289,5705],[5289,47090],[5290,6340],[5290,30000],
 [5291,6152],[5292,6183],[5292,29843],[5293,6213],[5309,27643],[5310,28970],[5311,30394],
 [5312,30394],[5315,5316,5705],[5315,5333,5705],[5315,5705],[5315,30640,5705],[5315,38205],
 [5317,5705],[5317,38205],[5318,5705],[5318,30625,39193],[5318,30626,39193],
 [5318,30709,39193],[5318,39193],[5319,5705],[5319,39193],[5321,5705],[5321,30628,39313],
 [5321,30629,39313],[5321,30829,39313],[5321,39313],[5322,5705],[5322,39313],[5323,5705],
 [5323,44904],[5324,6018],[5324,30953],[5325,6050],[5325,30985],[5326,5705],
 [5326,31015,46593],[5326,31021,46593],[5326,31224,46593],[5326,46593],[5327,5705],
 [5327,31047,47090],[5327,31054,47090],[5327,31225,47090],[5327,47090],[5328,6152],
 [5329,6183],[5329,31118],[5330,6213],[5334,5705],[5334,44904],[5335,6340],[5335,31275],
 [5336,6050],[5336,30985],[5338,6018],[5338,30953],[5339,5705],[5339,46593],[5340,5705],
 [5340,47090],[5341,6340],[5341,31275],[5342,6152],[5343,6183],[5343,31118],[5344,6213],
 [5360,26316],[5361,31620],[5363,31620],[5365,5366,5705],[5365,5383,5705],[5365,5705],
 [5365,31865,5705],[5365,38205],[5367,5705],[5367,38205],[5368,5705],[5368,31850,39193],
 [5368,31851,39193],[5368,31934,39193],[5368,39193],[5369,5705],[5369,39193],[5371,5705],
 [5371,31853,39313],[5371,31854,39313],[5371,32054,39313],[5371,39313],[5372,5705],
 [5372,39313],[5373,5705],[5373,44904],[5374,6018],[5374,32178],[5375,6050],[5375,32210],
 [5376,5705],[5376,32240,46593],[5376,32246,46593],[5376,32449,46593],[5376,46593],
 [5377,5705],[5377,32272,47090],[5377,32279,47090],[5377,32450,47090],[5377,47090],
 [5378,6152],[5379,6183],[5379,32343],[5380,6213],[5384,5705],[5384,44904],[5385,6340],
 [5385,32500],[5386,6050],[5386,32210],[5388,6018],[5388,32178],[5389,5705],[5389,46593],
 [5390,5705],[5390,47090],[5391,6340],[5391,32500],[5392,6152],[5393,6183],[5393,32343],
 [5394,6213],[5410,32797],[5413,32797],[5414,5415,5705],[5414,5432,5705],[5414,5705],
 [5414,33041,5705],[5414,38205],[5416,5705],[5416,38205],[5417,5705],[5417,33026,39193],
 [5417,33027,39193],[5417,33110,39193],[5417,39193],[5418,5705],[5418,39193],[5420,5705],
 [5420,33029,39313],[5420,33030,39313],[5420,33230,39313],[5420,39313],[5421,5705],
 [5421,39313],[5422,5705],[5422,44904],[5423,6018],[5423,33354],[5424,6050],[5424,33386],
 [5425,5705],[5425,33416,46593],[5425,33422,46593],[5425,33625,46593],[5425,46593],
 [5426,5705],[5426,33448,47090],[5426,33455,47090],[5426,33626,47090],[5426,47090],
 [5427,6152],[5428,6183],[5428,33519],[5429,6213],[5433,5705],[5433,44904],[5434,6340],
 [5434,33676],[5435,6050],[5435,33386],[5437,6018],[5437,33354],[5438,5705],[5438,46593],
 [5439,5705],[5439,47090],[5440,6340],[5440,33676],[5441,6152],[5442,6183],[5442,33519],
 [5443,6213],[5459,30394],[5460,31620],[5461,32797],[5462,5463,5705],[5462,5480,5705],
 [5462,5705],[5462,34169,5705],[5462,38205],[5464,5705],[5464,38205],[5465,5705],
 [5465,34154,39193],[5465,34155,39193],[5465,34238,39193],[5465,39193],[5466,5705],
 [5466,39193],[5468,5705],[5468,34157,39313],[5468,34158,39313],[5468,34358,39313],
 [5468,39313],[5469,5705],[5469,39313],[5470,5705],[5470,44904],[5471,6018],[5471,34482],
 [5472,6050],[5472,34514],[5473,5705],[5473,34544,46593],[5473,34550,46593],
 [5473,34753,46593],[5473,46593],[5474,5705],[5474,34576,47090],[5474,34583,47090],
 [5474,34754,47090],[5474,47090],[5475,6152],[5476,6183],[5476,34647],[5477,6213],
 [5481,5705],[5481,44904],[5482,6340],[5482,34804],[5483,6050],[5483,34514],[5485,6018],
 [5485,34482],[5486,5705],[5486,46593],[5487,5705],[5487,47090],[5488,6340],[5488,34804],
 [5489,6152],[5490,6183],[5490,34647],[5491,6213],[5507,27841],[5508,29168],
 [5509,5510,5705],[5509,5527,5705],[5509,5705],[5509,35250,5705],[5509,38205],[5511,5705],
 [5511,38205],[5512,5705],[5512,35235,39193],[5512,35236,39193],[5512,35319,39193],
 [5512,39193],[5513,5705],[5513,39193],[5515,5705],[5515,35238,39313],[5515,35239,39313],
 [5515,35439,39313],[5515,39313],[5516,5705],[5516,39313],[5517,5705],[5517,44904],
 [5518,6018],[5518,35563],[5519,6050],[5519,35595],[5520,5705],[5520,35625,46593],
 [5520,35631,46593],[5520,35834,46593],[5520,46593],[5521,5705],[5521,35657,47090],
 [5521,35664,47090],[5521,35835,47090],[5521,47090],[5522,6152],[5523,6183],[5523,35728],
 [5524,6213],[5528,5705],[5528,44904],[5529,6340],[5529,35885],[5530,6050],[5530,35595],
 [5532,6018],[5532,35563],[5533,5705],[5533,46593],[5534,5705],[5534,47090],[5535,6340],
 [5535,35885],[5536,6152],[5537,6183],[5537,35728],[5538,6213],[5554,26510],
 [5555,5556,5705],[5555,5573,5705],[5555,5705],[5555,36285,5705],[5555,38205],[5557,5705],
 [5557,38205],[5558,5705],[5558,36270,39193],[5558,36271,39193],[5558,36354,39193],
 [5558,39193],[5559,5705],[5559,39193],[5561,5705],[5561,36273,39313],[5561,36274,39313],
 [5561,36474,39313],[5561,39313],[5562,5705],[5562,39313],[5563,5705],[5563,44904],
 [5564,6018],[5564,36598],[5565,6050],[5565,36630],[5566,5705],[5566,36660,46593],
 [5566,36666,46593],[5566,36869,46593],[5566,46593],[5567,5705],[5567,36692,47090],
 [5567,36699,47090],[5567,36870,47090],[5567,47090],[5568,6152],[5569,6183],[5569,36763],
 [5570,6213],[5574,5705],[5574,44904],[5575,6340],[5575,36920],[5576,6050],[5576,36630],
 [5578,6018],[5578,36598],[5579,5705],[5579,46593],[5580,5705],[5580,47090],[5581,6340],
 [5581,36920],[5582,6152],[5583,6183],[5583,36763],[5584,6213],[5600,5601,5705],
 [5600,5618,5705],[5600,5705],[5600,37275,5705],[5600,38205],[5602,5705],[5602,38205],
 [5603,5705],[5603,37260,39193],[5603,37261,39193],[5603,37344,39193],[5603,39193],
 [5604,5705],[5604,39193],[5606,5705],[5606,37263,39313],[5606,37264,39313],
 [5606,37464,39313],[5606,39313],[5607,5705],[5607,39313],[5608,5705],[5608,44904],
 [5609,6018],[5609,37588],[5610,6050],[5610,37620],[5611,5705],[5611,37650,46593],
 [5611,37656,46593],[5611,37859,46593],[5611,46593],[5612,5705],[5612,37682,47090],
 [5612,37689,47090],[5612,37860,47090],[5612,47090],[5613,6152],[5614,6183],[5614,37753],
 [5615,6213],[5619,5705],[5619,44904],[5620,6340],[5620,37910],[5621,6050],[5621,37620],
 [5623,6018],[5623,37588],[5624,5705],[5624,46593],[5625,5705],[5625,47090],[5626,6340],
 [5626,37910],[5627,6152],[5628,6183],[5628,37753],[5629,6213],[5655,5705],[5655,38205],
 [5655,38596,46593],[5655,38602,46593],[5655,38805,46593],[5655,40360,46593],
 [5655,40366,46593],[5655,40569,46593],[5655,46593],[5657,5705],[5657,6152],[5657,38205],
 [5660,5703,5705],[5660,5705],[5660,6230,5705],[5660,38205],[5660,39649,5705],
 [5661,5704,5705],[5661,5705],[5661,6257,5705],[5661,38205],[5661,39676,5705],[5664,5705],
 [5664,6340],[5664,38205],[5664,38856],[5664,39759],[5664,40620],[5664,49500],
 [5666,5705],[5666,5709,5705],[5666,6287,5705],[5666,38205],[5666,39706,5705],[5668,5705],
 [5668,38205],[5668,46593],[5670,5705],[5670,6340],[5670,38205],[5670,38856],[5670,39759],
 [5670,40620],[5670,49500],[5671,5705],[5671,6152],[5671,38205],[5674,5705],
 [5674,5717,5705],[5674,6295,5705],[5674,38205],[5674,39714,5705],[5675,5705],
 [5675,5718,5705],[5675,5719,5705],[5675,6296,5705],[5675,6297,5705],[5675,38205],
 [5675,39715,5705],[5675,39716,5705],[5675,40824],[5676,5705],[5676,38205],[5676,40824],
 [5677,5705],[5677,5720,5705],[5677,6298,5705],[5677,38205],[5677,39717,5705],[5678,5705],
 [5678,5721,5705],[5678,6299,5705],[5678,38205],[5678,39718,5705],[5679,5705],
 [5679,5722,5705],[5679,5723,5705],[5679,6300,5705],[5679,6301,5705],[5679,38205],
 [5679,39719,5705],[5679,39720,5705],[5679,40870],[5680,5705],[5680,38205],[5680,40870],
 [5681,5705],[5681,5724,5705],[5681,6302,5705],[5681,38205],[5681,39721,5705],[5682,5705],
 [5682,5725,5705],[5682,6303,5705],[5682,38205],[5682,39722,5705],[5683,5705],
 [5683,5726,5705],[5683,6304,5705],[5683,38205],[5683,39723,5705],[5684,5705],
 [5684,5727,5705],[5684,6305,5705],[5684,38205],[5684,39724,5705],[5685,5705],
 [5685,5728,5705],[5685,6306,5705],[5685,38205],[5685,39725,5705],[5686,5705],
 [5686,5729,5705],[5686,6307,5705],[5686,38205],[5686,39726,5705],[5687,5705],
 [5687,5730,5705],[5687,5731,5705],[5687,6308,5705],[5687,6309,5705],[5687,38205],
 [5687,39727,5705],[5687,39728,5705],[5687,40914],[5688,5705],[5688,38205],[5688,40914],
 [5740,5705],[5740,38205],[5740,46593],[5742,5705],[5742,6152],[5742,38205],[5745,5705],
 [5745,38205],[5746,5705],[5746,38205],[5749,5705],[5749,6340],[5749,38205],[5749,38856],
 [5749,39759],[5749,40620],[5749,49500],[5751,5705],[5751,38205],[5753,5705],[5753,38205],
 [5753,46593],[5755,5705],[5755,6340],[5755,38205],[5755,38856],[5755,39759],[5755,40620],
 [5755,49500],[5756,5705],[5756,6152],[5756,38205],[5759,5705],[5759,38205],[5760,5705],
 [5760,38205],[5760,40824],[5761,5705],[5761,38205],[5761,40824],[5762,5705],[5762,38205],
 [5763,5705],[5763,38205],[5764,5705],[5764,38205],[5764,40870],[5765,5705],[5765,38205],
 [5765,40870],[5766,5705],[5766,38205],[5767,5705],[5767,38205],[5768,5705],[5768,38205],
 [5769,5705],[5769,38205],[5770,5705],[5770,38205],[5771,5705],[5771,38205],[5772,5705],
 [5772,38205],[5772,40914],[5773,5705],[5773,38205],[5773,40914],[5776,5705],[5776,39193],
 [5776,39195,39193],[5776,39195,39313],[5776,39196,39193],[5776,39196,39313],
 [5776,39235,39193],[5776,39235,39313],[5776,39236,39193],[5776,39236,39313],[5776,39313],
 [5776,40916,39193],[5776,40916,39313],[5776,40917,39193],[5776,40917,39313],
 [5776,40994,39193],[5776,40994,39313],[5776,41774,39193],[5776,41774,39313],[5777,5705],
 [5777,39193],[5777,39313],[5781,5705],[5781,39193],[5781,39200,39193],[5781,39213,39193],
 [5781,39240,39193],[5781,39253,39193],[5781,40921,39193],[5781,40934,39193],
 [5781,41180,46593],[5781,41186,46593],[5781,41389,46593],[5781,41960,46593],
 [5781,41966,46593],[5781,42169,46593],[5781,46593],[5783,5705],[5783,6152],[5783,6183],
 [5783,39193],[5783,39202,39193],[5783,39202,41239],[5783,39203,39193],[5783,39203,41239],
 [5783,39216,39193],[5783,39216,42362],[5783,39217,39193],[5783,39217,42362],
 [5783,39242,39193],[5783,39242,41239],[5783,39243,39193],[5783,39243,41239],
 [5783,39256,39193],[5783,39256,42362],[5783,39257,39193],[5783,39257,42362],
 [5783,39558,39193],[5783,39558,41239],[5783,39572],[5783,39601],[5783,39602],
 [5783,39901,39193],[5783,39901,42362],[5783,40923,39193],[5783,40923,41239],
 [5783,40924,39193],[5783,40924,41239],[5783,40937,39193],[5783,40937,42362],
 [5783,40938,39193],[5783,40938,42362],[5783,41239],[5783,41253,41239],[5783,41283,41239],
 [5783,41582,39193],[5783,41582,42362],[5783,42019,39193],[5783,42019,41239],[5783,42362],
 [5783,47448,41239],[5783,47993],[5784,5705],[5784,6152],[5784,6183],[5784,39193],
 [5784,39572],[5784,39601],[5784,39602],[5784,41239],[5784,42362],[5784,47993],
 [5785,5705],[5785,6213],[5785,39193],[5785,39204,39193],[5785,39218,39193],
 [5785,39244,39193],[5785,39258,39193],[5785,40925,39193],[5785,40939,39193],[5786,5705],
 [5786,39193],[5786,39205,39193],[5786,39205,42109],[5786,39206,39193],[5786,39206,42109],
 [5786,39245,39193],[5786,39245,42109],[5786,39246,39193],[5786,39246,42109],
 [5786,39648,39193],[5786,39648,42109],[5786,40926,39193],[5786,40926,42109],
 [5786,40927,39193],[5786,40927,42109],[5786,41329,39193],[5786,41329,42109],[5786,42109],
 [5787,5705],[5787,39193],[5787,42109],[5790,5705],[5790,6340],[5790,39193],
 [5790,39209,39193],[5790,39215,39193],[5790,39249,39193],[5790,39255,39193],[5790,39759],
 [5790,40930,39193],[5790,40936,39193],[5790,41440],[5790,42220],[5790,49500],[5792,5705],
 [5792,39193],[5792,39211,39193],[5792,39251,39193],[5792,40932,39193],[5794,5705],
 [5794,39193],[5794,46593],[5796,5705],[5796,6340],[5796,39193],[5796,39759],[5796,41440],
 [5796,42220],[5796,49500],[5797,5705],[5797,6152],[5797,6183],[5797,39193],[5797,39572],
 [5797,39601],[5797,39602],[5797,41239],[5797,42362],[5797,47993],[5798,5705],
 [5798,6152],[5798,6183],[5798,39193],[5798,39572],[5798,39601],[5798,39602],[5798,41239],
 [5798,42362],[5798,47993],[5799,5705],[5799,6213],[5799,39193],[5800,5705],[5800,39193],
 [5800,39219,39193],[5800,39259,39193],[5800,40940,39193],[5801,5705],[5801,39193],
 [5801,39220,39193],[5801,39260,39193],[5801,40941,39193],[5802,5705],[5802,39193],
 [5802,39221,39193],[5802,39261,39193],[5802,40942,39193],[5803,5705],[5803,39193],
 [5803,39222,39193],[5803,39222,42449],[5803,39223,39193],[5803,39223,42449],
 [5803,39262,39193],[5803,39262,42449],[5803,39263,39193],[5803,39263,42449],
 [5803,39988,39193],[5803,39988,42449],[5803,40943,39193],[5803,40943,42449],
 [5803,40944,39193],[5803,40944,42449],[5803,41669,39193],[5803,41669,42449],[5803,42449],
 [5804,5705],[5804,39193],[5804,42449],[5805,5705],[5805,39193],[5805,39224,39193],
 [5805,39264,39193],[5805,40945,39193],[5806,5705],[5806,39193],[5806,39225,39193],
 [5806,39265,39193],[5806,40946,39193],[5807,5705],[5807,39193],[5807,39226,39193],
 [5807,39266,39193],[5807,40947,39193],[5808,5705],[5808,39193],[5808,39227,39193],
 [5808,39227,42494],[5808,39228,39193],[5808,39228,42494],[5808,39267,39193],
 [5808,39267,42494],[5808,39268,39193],[5808,39268,42494],[5808,40033,39193],
 [5808,40033,42494],[5808,40948,39193],[5808,40948,42494],[5808,40949,39193],
 [5808,40949,42494],[5808,41714,39193],[5808,41714,42494],[5808,42494],[5809,5705],
 [5809,39193],[5809,42494],[5810,5705],[5810,39193],[5810,39229,39193],[5810,39269,39193],
 [5810,40950,39193],[5811,5705],[5811,39193],[5811,39230,39193],[5811,39270,39193],
 [5811,40951,39193],[5812,5705],[5812,39193],[5812,39231,39193],[5812,39271,39193],
 [5812,40952,39193],[5813,5705],[5813,39193],[5813,39232,39193],[5813,39272,39193],
 [5813,40953,39193],[5814,5705],[5814,39193],[5814,39233,39193],[5814,39273,39193],
 [5814,40954,39193],[5816,5705],[5816,39193],[5816,39313],[5817,5705],[5817,39193],
 [5817,39313],[5821,5705],[5821,39193],[5821,46593],[5823,5705],[5823,6152],[5823,6183],
 [5823,39193],[5823,39572],[5823,39601],[5823,39602],[5823,41239],[5823,42362],
 [5823,47993],[5824,5705],[5824,6152],[5824,6183],[5824,39193],[5824,39572],[5824,39601],
 [5824,39602],[5824,41239],[5824,42362],[5824,47993],[5825,5705],[5825,6213],[5825,39193],
 [5826,5705],[5826,39193],[5826,42109],[5827,5705],[5827,39193],[5827,42109],[5830,5705],
 [5830,6340],[5830,39193],[5830,39759],[5830,41440],[5830,42220],[5830,49500],
 [5832,5705],[5832,39193],[5834,5705],[5834,39193],[5834,46593],[5836,5705],[5836,6340],
 [5836,39193],[5836,39759],[5836,41440],[5836,42220],[5836,49500],[5837,5705],
 [5837,6152],[5837,6183],[5837,39193],[5837,39572],[5837,39601],[5837,39602],[5837,41239],
 [5837,42362],[5837,47993],[5838,5705],[5838,6152],[5838,6183],[5838,39193],[5838,39572],
 [5838,39601],[5838,39602],[5838,41239],[5838,42362],[5838,47993],[5839,5705],
 [5839,6213],[5839,39193],[5840,5705],[5840,39193],[5841,5705],[5841,39193],[5842,5705],
 [5842,39193],[5843,5705],[5843,39193],[5843,42449],[5844,5705],[5844,39193],[5844,42449],
 [5845,5705],[5845,39193],[5846,5705],[5846,39193],[5847,5705],[5847,39193],[5848,5705],
 [5848,39193],[5848,42494],[5849,5705],[5849,39193],[5849,42494],[5850,5705],[5850,39193],
 [5851,5705],[5851,39193],[5852,5705],[5852,39193],[5853,5705],[5853,39193],[5854,5705],
 [5854,39193],[5855,5705],[5855,39313],[5856,5705],[5856,39313],[5858,6018],[5858,42639],
 [5860,5705],[5860,42701,46593],[5860,42707,46593],[5860,42910,46593],[5860,46593],
 [5862,6152],[5862,6213],[5862,42761],[5862,43104],[5863,6183],[5863,42804],[5864,6152],
 [5864,6213],[5864,42761],[5864,43104],[5869,6340],[5869,42961],[5872,6018],[5872,42639],
 [5873,5705],[5873,46593],[5875,6340],[5875,42961],[5876,6152],[5876,6213],[5876,42761],
 [5876,43104],[5877,6183],[5877,42804],[5878,6152],[5878,6213],[5878,42761],[5878,43104],
 [5895,5705],[5895,39313],[5895,39314,39313],[5895,39325,39313],[5895,39351,39313],
 [5895,39362,39313],[5895,43256,39313],[5895,43267,39313],[5895,44904],[5896,5705],
 [5896,6018],[5896,6050],[5896,39313],[5896,39315,39313],[5896,39315,39424],
 [5896,39315,43330],[5896,39315,44030],[5896,39316,39313],[5896,39316,39424],
 [5896,39316,43330],[5896,39316,44030],[5896,39317,39313],[5896,39317,39424],
 [5896,39317,43330],[5896,39317,44030],[5896,39327,39313],[5896,39327,39779],
 [5896,39327,43685],[5896,39327,44394],[5896,39329,39313],[5896,39329,39779],
 [5896,39329,43685],[5896,39329,44394],[5896,39330,39313],[5896,39330,39779],
 [5896,39330,43685],[5896,39330,44394],[5896,39352,39313],[5896,39352,39424],
 [5896,39352,43330],[5896,39352,44030],[5896,39353,39313],[5896,39353,39424],
 [5896,39353,43330],[5896,39353,44030],[5896,39354,39313],[5896,39354,39424],
 [5896,39354,43330],[5896,39354,44030],[5896,39364,39313],[5896,39364,39779],
 [5896,39364,43685],[5896,39364,44394],[5896,39366,39313],[5896,39366,39779],
 [5896,39366,43685],[5896,39366,44394],[5896,39367,39313],[5896,39367,39779],
 [5896,39367,43685],[5896,39367,44394],[5896,39424],[5896,39425,39313],[5896,39425,39424],
 [5896,39425,43330],[5896,39425,44030],[5896,39438,39424],[5896,39459,39313],
 [5896,39459,39424],[5896,39459,43330],[5896,39459,44030],[5896,39472,39424],
 [5896,39502,39779],[5896,39504,39779],[5896,39779],[5896,39780,39313],[5896,39780,39779],
 [5896,39780,43685],[5896,39780,44394],[5896,39823,39313],[5896,39823,39779],
 [5896,39823,43685],[5896,39823,44394],[5896,43257,39313],[5896,43257,39424],
 [5896,43257,43330],[5896,43257,44030],[5896,43258,39313],[5896,43258,39424],
 [5896,43258,43330],[5896,43258,44030],[5896,43259,39313],[5896,43259,39424],
 [5896,43259,43330],[5896,43259,44030],[5896,43269,39313],[5896,43269,39779],
 [5896,43269,43685],[5896,43269,44394],[5896,43271,39313],[5896,43271,39779],
 [5896,43271,43685],[5896,43271,44394],[5896,43272,39313],[5896,43272,39779],
 [5896,43272,43685],[5896,43272,44394],[5896,43329,39313],[5896,43329,39424],
 [5896,43329,43330],[5896,43329,44030],[5896,43330],[5896,43337,43330],[5896,43337,43685],
 [5896,43337,45501],[5896,43337,46593],[5896,43340,43330],[5896,43340,43685],
 [5896,43340,45501],[5896,43340,46593],[5896,43342,43330],[5896,43343,43330],
 [5896,43343,43685],[5896,43343,45501],[5896,43343,46593],[5896,43364,39313],
 [5896,43364,39424],[5896,43364,43330],[5896,43364,44030],[5896,43371,46064],
 [5896,43374,43685],[5896,43376,46064],[5896,43377,43685],[5896,43404,43330],
 [5896,43404,43685],[5896,43404,45501],[5896,43404,46593],[5896,43407,43330],
 [5896,43407,43685],[5896,43407,45501],[5896,43407,46593],[5896,43409,43330],
 [5896,43410,43330],[5896,43410,43685],[5896,43410,45501],[5896,43410,46593],
 [5896,43610,43330],[5896,43610,43685],[5896,43610,45501],[5896,43610,46593],
 [5896,43612,46064],[5896,43613,43330],[5896,43613,43685],[5896,43613,45501],
 [5896,43613,46593],[5896,43684,39313],[5896,43684,39779],[5896,43684,43685],
 [5896,43684,44394],[5896,43685],[5896,43728,39313],[5896,43728,39779],[5896,43728,43685],
 [5896,43728,44394],[5896,43995,39313],[5896,43995,39424],[5896,43995,43330],
 [5896,43995,44030],[5896,43996,39313],[5896,43996,39424],[5896,43996,43330],
 [5896,43996,44030],[5896,44003,45501],[5896,44006,45501],[5896,44008,44394],
 [5896,44009,44394],[5896,44030],[5896,44037,44030],[5896,44037,44394],[5896,44037,46064],
 [5896,44037,46593],[5896,44040,44030],[5896,44042,44030],[5896,44042,44394],
 [5896,44042,46064],[5896,44042,46593],[5896,44043,44030],[5896,44043,44394],
 [5896,44043,46064],[5896,44043,46593],[5896,44070,44030],[5896,44070,44394],
 [5896,44070,46064],[5896,44070,46593],[5896,44073,44030],[5896,44075,44030],
 [5896,44075,44394],[5896,44075,46064],[5896,44075,46593],[5896,44076,44030],
 [5896,44076,44394],[5896,44076,46064],[5896,44076,46593],[5896,44276,45501],
 [5896,44278,44030],[5896,44278,44394],[5896,44278,46064],[5896,44278,46593],
 [5896,44279,44030],[5896,44279,44394],[5896,44279,46064],[5896,44279,46593],
 [5896,44350,39313],[5896,44350,39779],[5896,44350,43685],[5896,44350,44394],
 [5896,44351,39313],[5896,44351,39779],[5896,44351,43685],[5896,44351,44394],[5896,44394],
 [5896,45255,39313],[5896,45255,39424],[5896,45255,43330],[5896,45255,44030],
 [5896,45268,39424],[5896,45295,43330],[5896,45295,43685],[5896,45295,45501],
 [5896,45295,46593],[5896,45298,43330],[5896,45298,43685],[5896,45298,45501],
 [5896,45298,46593],[5896,45300,43330],[5896,45301,43330],[5896,45301,43685],
 [5896,45301,45501],[5896,45301,46593],[5896,45501],[5896,45504,43330],[5896,45504,43685],
 [5896,45504,45501],[5896,45504,46593],[5896,45576,43330],[5896,45576,43685],
 [5896,45576,45501],[5896,45576,46593],[5896,45619,44394],[5896,45856,44030],
 [5896,45856,44394],[5896,45856,46064],[5896,45856,46593],[5896,45859,44030],
 [5896,45861,44030],[5896,45861,44394],[5896,45861,46064],[5896,45861,46593],
 [5896,45862,44030],[5896,45862,44394],[5896,45862,46064],[5896,45862,46593],[5896,46064],
 [5896,46065,44030],[5896,46065,44394],[5896,46065,46064],[5896,46065,46593],
 [5896,46137,43685],[5896,46180,44030],[5896,46180,44394],[5896,46180,46064],
 [5896,46180,46593],[5896,46590,43330],[5896,46590,43685],[5896,46590,45501],
 [5896,46590,46593],[5896,46592,44030],[5896,46592,44394],[5896,46592,46064],
 [5896,46592,46593],[5896,46593],[5896,46664,39779],[5896,46665,43330],[5896,46665,43685],
 [5896,46665,45501],[5896,46665,46593],[5896,46708,44030],[5896,46708,44394],
 [5896,46708,46064],[5896,46708,46593],[5896,49521,43330],[5896,49521,43685],
 [5896,49521,45501],[5896,49521,46593],[5896,49564,44030],[5896,49564,44394],
 [5896,49564,46064],[5896,49564,46593],[5896,50393,39313],[5896,50393,39779],
 [5896,50393,43685],[5896,50393,44394],[5897,5705],[5897,6018],[5897,6050],[5897,39313],
 [5897,39424],[5897,39779],[5897,43330],[5897,43685],[5897,44030],[5897,44394],
 [5897,45501],[5897,46064],[5897,46593],[5898,5705],[5898,6018],[5898,6050],[5898,39313],
 [5898,39424],[5898,39779],[5898,43330],[5898,43685],[5898,44030],[5898,44394],
 [5898,45501],[5898,46064],[5898,46593],[5899,5705],[5899,39313],[5899,39318,39313],
 [5899,39331,39313],[5899,39355,39313],[5899,39368,39313],[5899,43260,39313],
 [5899,43273,39313],[5899,43436,47090],[5899,43443,47090],[5899,43614,47090],
 [5899,44102,47090],[5899,44109,47090],[5899,44280,47090],[5899,47090],[5900,5705],
 [5900,6152],[5900,39313],[5900,39319,39313],[5900,39333,39313],[5900,39356,39313],
 [5900,39370,39313],[5900,43261,39313],[5900,43275,39313],[5901,2279],[5901,3507],
 [5901,3756],[5901,3794],[5901,5705],[5901,6183],[5901,6213],[5901,7828],[5901,7996],
 [5901,8032],[5901,38205],[5901,38418],[5901,38454],[5901,38455],[5901,39015],
 [5901,39313],[5901,39602],[5901,39603],[5901,39631],[5901,40195],[5901,40196],
 [5901,40233],[5901,40450],[5901,43536],[5901,43643],[5901,43965],[5901,44174],
 [5901,44904],[5901,47993],[5903,5705],[5903,39313],[5903,39322,39313],[5903,39359,39313],
 [5903,43264,39313],[5904,5705],[5904,39313],[5904,39323,39313],[5904,39360,39313],
 [5904,43265,39313],[5906,5705],[5906,39313],[5906,44904],[5907,5705],[5907,6340],
 [5907,39313],[5907,39326,39313],[5907,39332,39313],[5907,39363,39313],[5907,39369,39313],
 [5907,39759],[5907,43268,39313],[5907,43274,39313],[5907,43664],[5907,44330],[5907,49500],
 [5908,5705],[5908,6018],[5908,6050],[5908,39313],[5908,39424],[5908,39779],[5908,43330],
 [5908,43685],[5908,44030],[5908,44394],[5908,45501],[5908,46064],[5908,46593],
 [5909,5705],[5909,39313],[5909,39328,39313],[5909,39365,39313],[5909,43270,39313],
 [5910,5705],[5910,6018],[5910,6050],[5910,39313],[5910,39424],[5910,39779],[5910,43330],
 [5910,43685],[5910,44030],[5910,44394],[5910,45501],[5910,46064],[5910,46593],
 [5911,5705],[5911,6018],[5911,6050],[5911,39313],[5911,39424],[5911,39779],[5911,43330],
 [5911,43685],[5911,44030],[5911,44394],[5911,45501],[5911,46064],[5911,46593],
 [5912,5705],[5912,39313],[5912,47090],[5913,5705],[5913,6340],[5913,39313],[5913,39759],
 [5913,43664],[5913,44330],[5913,49500],[5914,5705],[5914,6152],[5914,39313],[5915,2279],
 [5915,3507],[5915,3756],[5915,3794],[5915,5705],[5915,6183],[5915,6213],[5915,7828],
 [5915,7996],[5915,8032],[5915,38205],[5915,38418],[5915,38454],[5915,38455],[5915,39015],
 [5915,39313],[5915,39602],[5915,39603],[5915,39631],[5915,40195],[5915,40196],
 [5915,40233],[5915,40450],[5915,43536],[5915,43643],[5915,43965],[5915,44174],
 [5915,44904],[5915,47993],[5917,5705],[5917,39313],[5917,39336,39313],[5917,39373,39313],
 [5917,43278,39313],[5918,5705],[5918,39313],[5918,39337,39313],[5918,39374,39313],
 [5918,43279,39313],[5919,5705],[5919,39313],[5919,39338,39313],[5919,39375,39313],
 [5919,43280,39313],[5920,5705],[5920,39313],[5920,39339,39313],[5920,39376,39313],
 [5920,43281,39313],[5921,5705],[5921,39313],[5921,39340,39313],[5921,39377,39313],
 [5921,43282,39313],[5922,5705],[5922,39313],[5922,39341,39313],[5922,39378,39313],
 [5922,43283,39313],[5923,5705],[5923,39313],[5923,39342,39313],[5923,39379,39313],
 [5923,43284,39313],[5924,5705],[5924,39313],[5924,39343,39313],[5924,39380,39313],
 [5924,43285,39313],[5925,5705],[5925,39313],[5925,39344,39313],[5925,39381,39313],
 [5925,43286,39313],[5926,5705],[5926,39313],[5926,39345,39313],[5926,39382,39313],
 [5926,43287,39313],[5927,5705],[5927,39313],[5927,39346,39313],[5927,39383,39313],
 [5927,43288,39313],[5928,5705],[5928,39313],[5928,39347,39313],[5928,39384,39313],
 [5928,43289,39313],[5929,5705],[5929,39313],[5929,39348,39313],[5929,39385,39313],
 [5929,43290,39313],[5930,5705],[5930,39313],[5930,39349,39313],[5930,39386,39313],
 [5930,43291,39313],[5931,5705],[5931,39313],[5931,39350,39313],[5931,39387,39313],
 [5931,43292,39313],[5932,5705],[5932,39313],[5932,44904],[5933,5705],[5933,6018],
 [5933,6050],[5933,39313],[5933,39424],[5933,39779],[5933,43330],[5933,43685],
 [5933,44030],[5933,44394],[5933,45501],[5933,46064],[5933,46593],[5934,5705],
 [5934,6018],[5934,6050],[5934,39313],[5934,39424],[5934,39779],[5934,43330],[5934,43685],
 [5934,44030],[5934,44394],[5934,45501],[5934,46064],[5934,46593],[5935,5705],
 [5935,6018],[5935,6050],[5935,39313],[5935,39424],[5935,39779],[5935,43330],[5935,43685],
 [5935,44030],[5935,44394],[5935,45501],[5935,46064],[5935,46593],[5936,5705],
 [5936,39313],[5936,47090],[5937,5705],[5937,6152],[5937,39313],[5938,2279],[5938,3507],
 [5938,3756],[5938,3794],[5938,5705],[5938,6183],[5938,6213],[5938,7828],[5938,7996],
 [5938,8032],[5938,38205],[5938,38418],[5938,38454],[5938,38455],[5938,39015],
 [5938,39313],[5938,39602],[5938,39603],[5938,39631],[5938,40195],[5938,40196],
 [5938,40233],[5938,40450],[5938,43536],[5938,43643],[5938,43965],[5938,44174],
 [5938,44904],[5938,47993],[5940,5705],[5940,39313],[5941,5705],[5941,39313],[5943,5705],
 [5943,39313],[5943,44904],[5944,5705],[5944,6340],[5944,39313],[5944,39759],[5944,43664],
 [5944,44330],[5944,49500],[5945,5705],[5945,6018],[5945,6050],[5945,39313],[5945,39424],
 [5945,39779],[5945,43330],[5945,43685],[5945,44030],[5945,44394],[5945,45501],
 [5945,46064],[5945,46593],[5946,5705],[5946,39313],[5947,5705],[5947,6018],[5947,6050],
 [5947,39313],[5947,39424],[5947,39779],[5947,43330],[5947,43685],[5947,44030],
 [5947,44394],[5947,45501],[5947,46064],[5947,46593],[5948,5705],[5948,6018],[5948,6050],
 [5948,39313],[5948,39424],[5948,39779],[5948,43330],[5948,43685],[5948,44030],
 [5948,44394],[5948,45501],[5948,46064],[5948,46593],[5949,5705],[5949,39313],
 [5949,47090],[5950,5705],[5950,6340],[5950,39313],[5950,39759],[5950,43664],[5950,44330],
 [5950,49500],[5951,5705],[5951,6152],[5951,39313],[5952,2279],[5952,3507],[5952,3756],
 [5952,3794],[5952,5705],[5952,6183],[5952,6213],[5952,7828],[5952,7996],[5952,8032],
 [5952,38205],[5952,38418],[5952,38454],[5952,38455],[5952,39015],[5952,39313],
 [5952,39602],[5952,39603],[5952,39631],[5952,40195],[5952,40196],[5952,40233],
 [5952,40450],[5952,43536],[5952,43643],[5952,43965],[5952,44174],[5952,44904],
 [5952,47993],[5954,5705],[5954,39313],[5955,5705],[5955,39313],[5956,5705],[5956,39313],
 [5957,5705],[5957,39313],[5958,5705],[5958,39313],[5959,5705],[5959,39313],[5960,5705],
 [5960,39313],[5961,5705],[5961,39313],[5962,5705],[5962,39313],[5963,5705],[5963,39313],
 [5964,5705],[5964,39313],[5965,5705],[5965,39313],[5966,5705],[5966,39313],[5967,5705],
 [5967,39313],[5968,5705],[5968,39313],[5974,5705],[5974,6183],[5974,39602],[5974,44803],
 [5974,44904],[5974,47993],[5974,48018],[5975,5705],[5975,6213],[5975,44904],[5976,5705],
 [5976,44904],[5976,48796],[5977,5705],[5977,44904],[5982,5705],[5982,44904],[5982,48796],
 [5988,5705],[5988,6183],[5988,39602],[5988,44803],[5988,44904],[5988,47993],[5988,48018],
 [5989,5705],[5989,6213],[5989,44904],[5990,5705],[5990,44904],[5991,5705],[5991,44904],
 [5992,5705],[5992,44904],[5993,5705],[5993,44904],[5994,5705],[5994,44904],[5994,50046],
 [5995,5705],[5995,44904],[5996,5705],[5996,44904],[5997,5705],[5997,44904],[5998,5705],
 [5998,44904],[5998,50075],[5999,5705],[5999,44904],[6000,5705],[6000,44904],[6000,50075],
 [6001,5705],[6001,44904],[6001,50046],[6002,5705],[6002,44904],[6003,5705],[6003,44904],
 [6004,5705],[6004,44904],[6006,5705],[6006,6018],[6006,6050],[6006,39313],[6006,39424],
 [6006,39779],[6006,43330],[6006,43685],[6006,44030],[6006,44394],[6006,45501],
 [6006,46064],[6006,46593],[6008,6018],[6008,6152],[6008,45363],[6008,45622],[6009,6018],
 [6009,6183],[6009,45393],[6009,45398],[6009,45623],[6009,48108],[6010,6018],[6010,6213],
 [6010,45422],[6010,45624],[6011,6018],[6011,45450],[6012,6018],[6012,45476,49217],
 [6012,45477,49217],[6012,45597,49217],[6012,49217],[6015,6018],[6015,6340],[6015,45552],
 [6015,45555],[6015,45621],[6015,50142],[6017,6018],[6017,49217],[6019,5705],[6019,6018],
 [6019,6050],[6019,39313],[6019,39424],[6019,39779],[6019,43330],[6019,43685],
 [6019,44030],[6019,44394],[6019,45501],[6019,46064],[6019,46593],[6021,6018],
 [6021,6340],[6021,45552],[6021,45555],[6021,45621],[6021,50142],[6022,6018],[6022,6152],
 [6022,45363],[6022,45622],[6023,6018],[6023,6183],[6023,45393],[6023,45398],[6023,45623],
 [6023,48108],[6024,6018],[6024,6213],[6024,45422],[6024,45624],[6025,6018],
 [6025,45625,45745],[6025,45626,45745],[6025,45745],[6025,50960,45745],[6026,6018],
 [6026,45745],[6027,6018],[6027,45627],[6028,6018],[6028,45628,51006],[6028,45636,51006],
 [6028,45791,51006],[6028,51006],[6029,6018],[6029,45629],[6030,6018],[6030,45630,45806],
 [6030,45632,45806],[6030,45806],[6030,51021,45806],[6031,6018],[6031,45631],[6032,6018],
 [6032,45806],[6033,6018],[6033,45633],[6034,6018],[6034,45634,51050],[6034,45635,51050],
 [6034,45835,51050],[6034,51050],[6035,6018],[6035,51050],[6036,6018],[6036,51006],
 [6037,6018],[6037,45637,45847],[6037,45638,45847],[6037,45847],[6037,51062,45847],
 [6038,6018],[6038,45847],[6039,6018],[6039,45639],[6040,5705],[6040,6018],[6040,6050],
 [6040,39313],[6040,39424],[6040,39779],[6040,43330],[6040,43685],[6040,44030],
 [6040,44394],[6040,45501],[6040,46064],[6040,46593],[6042,6050],[6042,6152],[6042,45922],
 [6042,46140],[6043,6050],[6043,6183],[6043,6340],[6043,45951,48035],[6043,45952,48035],
 [6043,45957,46241],[6043,45959,46241],[6043,46111,48035],[6043,46116,46241],
 [6043,46118,46241],[6043,46139,46241],[6043,46141,46241],[6043,46241],[6043,48035],
 [6043,48040,48035],[6043,48042,48035],[6043,48063,48035],[6043,48065,48035],
 [6043,48165,46241],[6043,50099,48035],[6043,50101,48035],[6043,50201,46241],
 [6043,50454,46241],[6044,6050],[6044,6213],[6044,45981],[6044,46142],[6045,6050],
 [6045,46009],[6046,6050],[6046,46036],[6049,6050],[6049,6183],[6049,6340],[6049,46241],
 [6049,48035],[6051,6050],[6051,46135],[6053,5705],[6053,6018],[6053,6050],[6053,39313],
 [6053,39424],[6053,39779],[6053,43330],[6053,43685],[6053,44030],[6053,44394],
 [6053,45501],[6053,46064],[6053,46593],[6055,6050],[6055,6183],[6055,6340],[6055,46241],
 [6055,48035],[6056,6050],[6056,6152],[6056,45922],[6056,46140],[6057,6050],[6057,6183],
 [6057,6340],[6057,46241],[6057,48035],[6058,6050],[6058,6213],[6058,45981],[6058,46142],
 [6059,6050],[6059,46143],[6060,6050],[6060,46144],[6061,6050],[6061,46145],[6062,6050],
 [6062,46146],[6063,6050],[6063,46147],[6064,6050],[6064,46148],[6065,6050],[6065,46149],
 [6066,6050],[6066,46150],[6067,6050],[6067,46151],[6068,6050],[6068,46152],[6069,6050],
 [6069,46153],[6070,6050],[6070,46154],[6071,6050],[6071,46155],[6072,6050],[6072,46156],
 [6073,6050],[6073,46157],[6074,5705],[6074,46416,46593],[6074,46416,47090],
 [6074,46422,46593],[6074,46422,47090],[6074,46423,46593],[6074,46423,47090],[6074,46593],
 [6074,46594,46593],[6074,46594,47090],[6074,46729,46593],[6074,46729,47090],
 [6074,47089,46593],[6074,47089,47090],[6074,47090],[6074,47225,46593],[6074,47225,47090],
 [6074,49585,46593],[6074,49585,47090],[6076,5705],[6076,6183],[6076,39602],
 [6076,46477,46593],[6076,46483,46593],[6076,46487],[6076,46593],[6076,46597,46593],
 [6076,46732,46593],[6076,47989,46593],[6076,47993],[6076,48128],[6076,49588,46593],
 [6077,5705],[6077,6213],[6077,46506,46593],[6077,46512,46593],[6077,46593],
 [6077,46598,46593],[6077,46733,46593],[6077,48395,46593],[6077,49589,46593],[6078,5705],
 [6078,46534,46593],[6078,46540,46593],[6078,46593],[6078,48773,46593],[6079,5705],
 [6079,46561,46593],[6079,46567,46593],[6079,46593],[6079,49124,46593],[6082,2279],
 [6082,3507],[6082,3930],[6082,4193],[6082,5705],[6082,6152],[6082,6340],[6082,7828],
 [6082,8168],[6082,8507],[6082,38205],[6082,38591],[6082,39759],[6082,40707],[6082,44695],
 [6082,44702],[6082,44769],[6082,44904],[6082,45084],[6082,46593],[6082,46621],
 [6082,46645],[6082,47556],[6082,47575],[6082,47691],[6082,49500],[6082,49501],
 [6082,49886],[6082,49887],[6083,5705],[6083,6018],[6083,6050],[6083,39313],[6083,39424],
 [6083,39779],[6083,43330],[6083,43685],[6083,44030],[6083,44394],[6083,45501],
 [6083,46064],[6083,46593],[6084,5705],[6084,46591,46593],[6084,46593],[6084,46687,46593],
 [6084,49543,46593],[6085,5705],[6085,6018],[6085,6050],[6085,39313],[6085,39424],
 [6085,39779],[6085,43330],[6085,43685],[6085,44030],[6085,44394],[6085,45501],
 [6085,46064],[6085,46593],[6087,5705],[6087,46593],[6087,47090],[6088,2279],[6088,3507],
 [6088,3930],[6088,4193],[6088,5705],[6088,6152],[6088,6340],[6088,7828],[6088,8168],
 [6088,8507],[6088,38205],[6088,38591],[6088,39759],[6088,40707],[6088,44695],
 [6088,44702],[6088,44769],[6088,44904],[6088,45084],[6088,46593],[6088,46621],
 [6088,46645],[6088,47556],[6088,47575],[6088,47691],[6088,49500],[6088,49501],
 [6088,49886],[6088,49887],[6090,5705],[6090,6183],[6090,39602],[6090,46487],[6090,46593],
 [6090,47993],[6090,48128],[6091,5705],[6091,6213],[6091,46593],[6092,5705],[6092,46593],
 [6092,46599,46593],[6092,46734,46593],[6092,49590,46593],[6093,5705],[6093,46593],
 [6093,46600,46593],[6093,46735,46593],[6093,49591,46593],[6094,5705],[6094,46593],
 [6094,46601,46593],[6094,46736,46593],[6094,49592,46593],[6095,5705],[6095,46593],
 [6095,46602,46593],[6095,46737,46593],[6095,49593,46593],[6096,5705],[6096,46593],
 [6096,46603,46593],[6096,46738,46593],[6096,49594,46593],[6097,5705],[6097,46593],
 [6097,46604,46593],[6097,46739,46593],[6097,49595,46593],[6098,5705],[6098,46593],
 [6098,46605,46593],[6098,46740,46593],[6098,49596,46593],[6099,5705],[6099,46593],
 [6099,46606,46593],[6099,46741,46593],[6099,49597,46593],[6100,5705],[6100,46593],
 [6100,46607,46593],[6100,46742,46593],[6100,49598,46593],[6101,5705],[6101,46593],
 [6101,46608,46593],[6101,46743,46593],[6101,49599,46593],[6102,5705],[6102,46593],
 [6102,46609,46593],[6102,46744,46593],[6102,49600,46593],[6103,5705],[6103,46593],
 [6103,46610,46593],[6103,46745,46593],[6103,49601,46593],[6104,5705],[6104,46593],
 [6104,46611,46593],[6104,46746,46593],[6104,49602,46593],[6105,5705],[6105,46593],
 [6105,46612,46593],[6105,46747,46593],[6105,49603,46593],[6106,5705],[6106,46593],
 [6106,46613,46593],[6106,46748,46593],[6106,49604,46593],[6107,5705],[6107,6152],
 [6107,46943,47090],[6107,46950,47090],[6107,47090],[6107,47092,47090],[6107,47246,47090],
 [6107,47555,47090],[6107,49606,47090],[6108,5705],[6108,6183],[6108,39602],
 [6108,46973,47090],[6108,46980,47090],[6108,46983],[6108,47090],[6108,47093,47090],
 [6108,47247,47090],[6108,47990,47090],[6108,47993],[6108,48147],[6108,49607,47090],
 [6109,5705],[6109,6213],[6109,6340],[6109,39759],[6109,47002,47090],[6109,47002,48445],
 [6109,47004,47090],[6109,47004,48445],[6109,47009,47090],[6109,47009,48445],
 [6109,47085,47090],[6109,47085,48445],[6109,47090],[6109,47091,47090],[6109,47091,47266],
 [6109,47094,47090],[6109,47094,47266],[6109,47139,47090],[6109,47139,48445],
 [6109,47140,47266],[6109,47143,47266],[6109,47245,47090],[6109,47245,47266],
 [6109,47248,47090],[6109,47248,47266],[6109,47266],[6109,48391,47090],[6109,48391,48445],
 [6109,48396,47090],[6109,48396,48445],[6109,48397],[6109,48445],[6109,48446,48445],
 [6109,48551,48445],[6109,49499,47090],[6109,49499,48445],[6109,49500],[6109,49503],
 [6109,49605,47090],[6109,49605,47266],[6109,49608,47090],[6109,49608,47266],
 [6109,49626,47090],[6109,49626,47266],[6109,50181,48445],[6109,50202,47266],
 [6109,51257,47090],[6109,51257,47266],[6110,5705],[6110,47030,47090],[6110,47037,47090],
 [6110,47090],[6110,48774,47090],[6111,5705],[6111,47057,47090],[6111,47064,47090],
 [6111,47090],[6111,49125,47090],[6114,5705],[6114,6213],[6114,6340],[6114,39759],
 [6114,47090],[6114,47266],[6114,48397],[6114,48445],[6114,49500],[6114,49503],
 [6116,5705],[6116,47087,47090],[6116,47090],[6116,47184,47090],[6116,49544,47090],
 [6118,5705],[6118,46593],[6118,47090],[6120,5705],[6120,6213],[6120,6340],[6120,39759],
 [6120,47090],[6120,47266],[6120,48397],[6120,48445],[6120,49500],[6120,49503],
 [6121,5705],[6121,6152],[6121,47090],[6122,5705],[6122,6183],[6122,39602],[6122,46983],
 [6122,47090],[6122,47993],[6122,48147],[6123,5705],[6123,6213],[6123,6340],[6123,39759],
 [6123,47090],[6123,47266],[6123,48397],[6123,48445],[6123,49500],[6123,49503],
 [6124,5705],[6124,47090],[6124,47095,47090],[6124,47095,47331],[6124,47097,47090],
 [6124,47097,47331],[6124,47249,47090],[6124,47249,47331],[6124,47251,47090],
 [6124,47251,47331],[6124,47331],[6124,49609,47090],[6124,49609,47331],[6124,49611,47090],
 [6124,49611,47331],[6124,49691,47090],[6124,49691,47331],[6124,51322,47090],
 [6124,51322,47331],[6125,5705],[6125,47090],[6125,47096,47090],[6125,47250,47090],
 [6125,49610,47090],[6126,5705],[6126,47090],[6126,47331],[6127,5705],[6127,47090],
 [6127,47098,47090],[6127,47252,47090],[6127,49612,47090],[6128,5705],[6128,47090],
 [6128,47099,47090],[6128,47253,47090],[6128,49613,47090],[6129,5705],[6129,47090],
 [6129,47100,47090],[6129,47254,47090],[6129,49614,47090],[6130,5705],[6130,47090],
 [6130,47101,47090],[6130,47101,47399],[6130,47102,47090],[6130,47102,47399],
 [6130,47255,47090],[6130,47255,47399],[6130,47256,47090],[6130,47256,47399],[6130,47399],
 [6130,49615,47090],[6130,49615,47399],[6130,49616,47090],[6130,49616,47399],
 [6130,49759,47090],[6130,49759,47399],[6130,51390,47090],[6130,51390,47399],[6131,5705],
 [6131,47090],[6131,47399],[6132,5705],[6132,47090],[6132,47103,47090],[6132,47257,47090],
 [6132,49617,47090],[6133,5705],[6133,47090],[6133,47104,47090],[6133,47258,47090],
 [6133,49618,47090],[6134,5705],[6134,47090],[6134,47105,47090],[6134,47259,47090],
 [6134,49619,47090],[6135,5705],[6135,47090],[6135,47106,47090],[6135,47260,47090],
 [6135,49620,47090],[6136,5705],[6136,47090],[6136,47107,47090],[6136,47107,47433],
 [6136,47109,47090],[6136,47109,47433],[6136,47261,47090],[6136,47261,47433],
 [6136,47263,47090],[6136,47263,47433],[6136,47433],[6136,49621,47090],[6136,49621,47433],
 [6136,49623,47090],[6136,49623,47433],[6136,49793,47090],[6136,49793,47433],
 [6136,51424,47090],[6136,51424,47433],[6137,5705],[6137,47090],[6137,47108,47090],
 [6137,47262,47090],[6137,49622,47090],[6138,5705],[6138,47090],[6138,47433],[6139,5705],
 [6139,6152],[6139,6183],[6139,39193],[6139,39572],[6139,39601],[6139,39602],[6139,41239],
 [6139,42362],[6139,47993],[6140,6152],[6140,6213],[6140,42761],[6140,43104],[6141,6152],
 [6142,6152],[6146,6050],[6146,6152],[6146,45922],[6146,46140],[6147,6152],[6148,6018],
 [6148,6152],[6148,45363],[6148,45622],[6150,5705],[6150,6152],[6150,47090],[6153,5705],
 [6153,6152],[6153,6183],[6153,39193],[6153,39572],[6153,39601],[6153,39602],[6153,41239],
 [6153,42362],[6153,47993],[6154,6152],[6154,6213],[6154,42761],[6154,43104],[6155,6152],
 [6156,6152],[6157,6152],[6158,6152],[6159,6152],[6160,6152],[6161,6152],[6162,6152],
 [6163,6152],[6164,6152],[6165,6152],[6166,6152],[6167,6152],[6168,6152],[6169,6152],
 [6171,6183],[6171,47940],[6172,6183],[6172,47967],[6174,5705],[6174,6183],[6174,39602],
 [6174,44803],[6174,44904],[6174,47993],[6174,48018],[6175,6050],[6175,6183],[6175,6340],
 [6175,46241],[6175,48035],[6176,6050],[6176,6183],[6176,6340],[6176,46241],[6176,48035],
 [6177,6183],[6177,48087],[6178,6018],[6178,6183],[6178,45393],[6178,45398],[6178,45623],
 [6178,48108],[6179,5705],[6179,6183],[6179,39602],[6179,46487],[6179,46593],[6179,47993],
 [6179,48128],[6180,5705],[6180,6183],[6180,39602],[6180,46983],[6180,47090],[6180,47993],
 [6180,48147],[6181,6050],[6181,6183],[6181,6340],[6181,46241],[6181,48035],[6182,5705],
 [6182,6152],[6182,6183],[6182,39193],[6182,39572],[6182,39601],[6182,39602],[6182,41239],
 [6182,42362],[6182,47993],[6185,6183],[6185,48200],[6186,6183],[6186,48201],[6187,6183],
 [6187,48202],[6188,6183],[6188,48203],[6189,6183],[6189,48204],[6190,6183],[6190,48205],
 [6191,6183],[6191,48206],[6192,6183],[6192,48207],[6193,6183],[6193,48208],[6194,6183],
 [6194,48209],[6195,6183],[6195,48210],[6196,6183],[6196,48211],[6197,6183],[6197,48212],
 [6198,6183],[6198,48213],[6199,6183],[6199,48214],[6200,6213],[6201,6213],[6203,5705],
 [6203,6213],[6203,44904],[6204,5705],[6204,6213],[6204,6340],[6204,39759],[6204,47090],
 [6204,47266],[6204,48397],[6204,48445],[6204,49500],[6204,49503],[6205,6050],
 [6205,6213],[6205,45981],[6205,46142],[6206,6213],[6207,6018],[6207,6213],[6207,45422],
 [6207,45624],[6208,5705],[6208,6213],[6208,46593],[6209,5705],[6209,6213],[6209,6340],
 [6209,39759],[6209,47090],[6209,47266],[6209,48397],[6209,48445],[6209,49500],
 [6209,49503],[6210,5705],[6210,6213],[6210,6340],[6210,39759],[6210,47090],[6210,47266],
 [6210,48397],[6210,48445],[6210,49500],[6210,49503],[6211,6152],[6211,6213],[6211,42761],
 [6211,43104],[6214,6213],[6215,6213],[6216,6213],[6217,6213],[6218,6213],[6219,6213],
 [6220,6213],[6221,6213],[6222,6213],[6223,6213],[6224,6213],[6225,6213],[6226,6213],
 [6227,6213],[6228,6213],[6229,5705],[6229,39193],[6229,42109],[6231,5705],[6231,44904],
 [6231,48796],[6232,6340],[6232,48824],[6233,6050],[6233,46009],[6234,5705],[6234,44904],
 [6234,48796],[6235,6018],[6235,45450],[6236,5705],[6236,46593],[6237,5705],[6237,47090],
 [6238,6340],[6238,48824],[6239,6152],[6240,6183],[6240,47940],[6241,6213],[6258,5705],
 [6258,44904],[6259,6340],[6259,49175],[6260,6050],[6260,46036],[6261,6018],[6261,49217],
 [6262,6018],[6262,49217],[6263,5705],[6263,46593],[6264,5705],[6264,47090],[6265,6340],
 [6265,49175],[6266,6152],[6267,6183],[6267,47967],[6268,6213],[6312,5705],[6312,44904],
 [6312,48796],[6318,5705],[6318,6183],[6318,39602],[6318,44803],[6318,44904],[6318,47993],
 [6318,48018],[6319,5705],[6319,6213],[6319,44904],[6320,5705],[6320,44904],[6321,5705],
 [6321,44904],[6322,5705],[6322,44904],[6323,5705],[6323,44904],[6324,5705],[6324,44904],
 [6324,50046],[6325,5705],[6325,44904],[6326,5705],[6326,44904],[6327,5705],[6327,44904],
 [6328,5705],[6328,44904],[6328,50075],[6329,5705],[6329,44904],[6330,5705],[6330,44904],
 [6330,50075],[6331,5705],[6331,44904],[6331,50046],[6332,5705],[6332,44904],[6333,5705],
 [6333,44904],[6334,5705],[6334,44904],[6335,6050],[6335,6183],[6335,6340],[6335,46241],
 [6335,48035],[6336,6340],[6336,50121],[6337,6018],[6337,6340],[6337,45552],[6337,45555],
 [6337,45621],[6337,50142],[6338,2279],[6338,3507],[6338,3930],[6338,4193],[6338,5705],
 [6338,6152],[6338,6340],[6338,7828],[6338,8168],[6338,8507],[6338,38205],[6338,38591],
 [6338,39759],[6338,40707],[6338,44695],[6338,44702],[6338,44769],[6338,44904],
 [6338,45084],[6338,46593],[6338,46621],[6338,46645],[6338,47556],[6338,47575],
 [6338,47691],[6338,49500],[6338,49501],[6338,49886],[6338,49887],[6339,5705],
 [6339,6213],[6339,6340],[6339,39759],[6339,47090],[6339,47266],[6339,48397],[6339,48445],
 [6339,49500],[6339,49503],[6342,6050],[6342,6183],[6342,6340],[6342,46241],[6342,48035],
 [6343,5705],[6343,6213],[6343,6340],[6343,39759],[6343,47090],[6343,47266],[6343,48397],
 [6343,48445],[6343,49500],[6343,49503],[6344,6340],[6344,50203],[6345,6340],[6345,50204],
 [6346,6340],[6346,50205],[6347,6340],[6347,50206],[6348,6340],[6348,50207],[6349,6340],
 [6349,50208],[6350,6340],[6350,50209],[6351,6340],[6351,50210],[6352,6340],[6352,50211],
 [6353,6340],[6353,50212],[6354,6340],[6354,50213],[6355,6340],[6355,50214],[6356,6340],
 [6356,50215],[6357,6340],[6357,50216],[6358,6340],[6358,50217],[6359,6050],[6359,46135],
 [6361,5705],[6361,6018],[6361,6050],[6361,39313],[6361,39424],[6361,39779],[6361,43330],
 [6361,43685],[6361,44030],[6361,44394],[6361,45501],[6361,46064],[6361,46593],
 [6363,6050],[6363,6183],[6363,6340],[6363,46241],[6363,48035],[6364,6050],[6364,6152],
 [6364,45922],[6364,46140],[6365,6050],[6365,6183],[6365,6340],[6365,46241],[6365,48035],
 [6366,6050],[6366,6213],[6366,45981],[6366,46142],[6367,6050],[6367,46143],[6368,6050],
 [6368,46144],[6369,6050],[6369,46145],[6370,6050],[6370,46146],[6371,6050],[6371,46147],
 [6372,6050],[6372,46148],[6373,6050],[6373,46149],[6374,6050],[6374,46150],[6375,6050],
 [6375,46151],[6376,6050],[6376,46152],[6377,6050],[6377,46153],[6378,6050],[6378,46154],
 [6379,6050],[6379,46155],[6380,6050],[6380,46156],[6381,6050],[6381,46157],[6382,6018],
 [6382,49217],[6383,5705],[6383,46593],[6384,5705],[6384,47090],[6385,6340],[6385,50121],
 [6386,6152],[6387,6183],[6387,48087],[6388,6213],[6404,5705],[6404,6018],[6404,6050],
 [6404,39313],[6404,39424],[6404,39779],[6404,43330],[6404,43685],[6404,44030],
 [6404,44394],[6404,45501],[6404,46064],[6404,46593],[6406,6018],[6406,6340],[6406,45552],
 [6406,45555],[6406,45621],[6406,50142],[6407,6018],[6407,6152],[6407,45363],[6407,45622],
 [6408,6018],[6408,6183],[6408,45393],[6408,45398],[6408,45623],[6408,48108],[6409,6018],
 [6409,6213],[6409,45422],[6409,45624],[6410,6018],[6410,45745],[6411,6018],[6411,45745],
 [6412,6018],[6412,45627],[6413,6018],[6413,51006],[6414,6018],[6414,45629],[6415,6018],
 [6415,45806],[6416,6018],[6416,45631],[6417,6018],[6417,45806],[6418,6018],[6418,45633],
 [6419,6018],[6419,51050],[6420,6018],[6420,51050],[6421,6018],[6421,51006],[6422,6018],
 [6422,45847],[6423,6018],[6423,45847],[6424,6018],[6424,45639],[6425,5705],[6425,46593],
 [6425,47090],[6426,2279],[6426,3507],[6426,3930],[6426,4193],[6426,5705],[6426,6152],
 [6426,6340],[6426,7828],[6426,8168],[6426,8507],[6426,38205],[6426,38591],[6426,39759],
 [6426,40707],[6426,44695],[6426,44702],[6426,44769],[6426,44904],[6426,45084],
 [6426,46593],[6426,46621],[6426,46645],[6426,47556],[6426,47575],[6426,47691],
 [6426,49500],[6426,49501],[6426,49886],[6426,49887],[6428,5705],[6428,6183],[6428,39602],
 [6428,46487],[6428,46593],[6428,47993],[6428,48128],[6429,5705],[6429,6213],[6429,46593],
 [6430,5705],[6430,46593],[6431,5705],[6431,46593],[6432,5705],[6432,46593],[6433,5705],
 [6433,46593],[6434,5705],[6434,46593],[6435,5705],[6435,46593],[6436,5705],[6436,46593],
 [6437,5705],[6437,46593],[6438,5705],[6438,46593],[6439,5705],[6439,46593],[6440,5705],
 [6440,46593],[6441,5705],[6441,46593],[6442,5705],[6442,46593],[6443,5705],[6443,46593],
 [6444,5705],[6444,46593],[6445,5705],[6445,6213],[6445,6340],[6445,39759],[6445,47090],
 [6445,47266],[6445,48397],[6445,48445],[6445,49500],[6445,49503],[6446,5705],
 [6446,6152],[6446,47090],[6447,5705],[6447,6183],[6447,39602],[6447,46983],[6447,47090],
 [6447,47993],[6447,48147],[6448,5705],[6448,6213],[6448,6340],[6448,39759],[6448,47090],
 [6448,47266],[6448,48397],[6448,48445],[6448,49500],[6448,49503],[6449,5705],
 [6449,47090],[6449,47331],[6450,5705],[6450,47090],[6451,5705],[6451,47090],[6451,47331],
 [6452,5705],[6452,47090],[6453,5705],[6453,47090],[6454,5705],[6454,47090],[6455,5705],
 [6455,47090],[6455,47399],[6456,5705],[6456,47090],[6456,47399],[6457,5705],[6457,47090],
 [6458,5705],[6458,47090],[6459,5705],[6459,47090],[6460,5705],[6460,47090],[6461,5705],
 [6461,47090],[6461,47433],[6462,5705],[6462,47090],[6463,5705],[6463,47090],[6463,47433],
 [6465,6050],[6465,6183],[6465,6340],[6465,46241],[6465,48035],[6466,5705],[6466,6213],
 [6466,6340],[6466,39759],[6466,47090],[6466,47266],[6466,48397],[6466,48445],
 [6466,49500],[6466,49503],[6467,6340],[6467,50203],[6468,6340],[6468,50204],[6469,6340],
 [6469,50205],[6470,6340],[6470,50206],[6471,6340],[6471,50207],[6472,6340],[6472,50208],
 [6473,6340],[6473,50209],[6474,6340],[6474,50210],[6475,6340],[6475,50211],[6476,6340],
 [6476,50212],[6477,6340],[6477,50213],[6478,6340],[6478,50214],[6479,6340],[6479,50215],
 [6480,6340],[6480,50216],[6481,6340],[6481,50217],[6482,5705],[6482,6152],[6482,6183],
 [6482,39193],[6482,39572],[6482,39601],[6482,39602],[6482,41239],[6482,42362],
 [6482,47993],[6483,6152],[6483,6213],[6483,42761],[6483,43104],[6484,6152],[6485,6152],
 [6486,6152],[6487,6152],[6488,6152],[6489,6152],[6490,6152],[6491,6152],[6492,6152],
 [6493,6152],[6494,6152],[6495,6152],[6496,6152],[6497,6152],[6498,6152],[6500,6183],
 [6500,48200],[6501,6183],[6501,48201],[6502,6183],[6502,48202],[6503,6183],[6503,48203],
 [6504,6183],[6504,48204],[6505,6183],[6505,48205],[6506,6183],[6506,48206],[6507,6183],
 [6507,48207],[6508,6183],[6508,48208],[6509,6183],[6509,48209],[6510,6183],[6510,48210],
 [6511,6183],[6511,48211],[6512,6183],[6512,48212],[6513,6183],[6513,48213],[6514,6183],
 [6514,48214],[6515,6213],[6516,6213],[6517,6213],[6518,6213],[6519,6213],[6520,6213],
 [6521,6213],[6522,6213],[6523,6213],[6524,6213],[6525,6213],[6526,6213],[6527,6213],
 [6528,6213],[6529,6213],[6530,6018],[6530,45745],[6531,5705],[6531,47090],[6531,47331],
 [6544,5705],[6544,38205],[6544,40824],[6569,5705],[6569,39193],[6569,42449],[6574,14514],
 [6576,6018],[6576,51006],[6583,14523],[6586,5705],[6586,44904],[6586,50046],[6590,5705],
 [6590,38205],[6590,40870],[6591,6018],[6591,45806],[6597,19848],[6599,5705],[6599,47090],
 [6599,47399],[6606,19857],[6611,19862],[6614,5705],[6614,39193],[6614,42494],
 [6615,5705],[6615,44904],[6615,50075],[6620,6018],[6620,51050],[6625,14565],[6632,6018],
 [6632,45847],[6633,5705],[6633,47090],[6633,47433],[6634,5705],[6634,38205],[6634,40914],
 [6635,8715],[6636,8715],[6638,202],[6639,8962],[6641,8962],[6654,6656,7828],
 [6654,6673,7828],[6654,7828],[6654,9844,7828],[6654,38205],[6655,7828],[6655,38205],
 [6657,7875],[6657,9891],[6658,7828],[6658,9925,42193],[6658,9929,42193],
 [6658,10409,42193],[6658,42193],[6659,7950],[6659,9966],[6660,7996],[6660,10012],
 [6661,8032],[6662,7828],[6662,44904],[6663,7828],[6663,9834,40287],[6663,9837,40287],
 [6663,10103,40287],[6663,40287],[6665,8168],[6666,7828],[6666,40287],[6667,7828],
 [6667,10240,47575],[6667,10241,47575],[6667,10406,47575],[6667,47575],[6668,7828],
 [6668,9839,40450],[6668,9840,40450],[6668,10266,40450],[6668,40450],[6669,7828],
 [6669,40450],[6672,7828],[6672,44904],[6674,7828],[6674,47575],[6675,7950],[6675,9966],
 [6677,7828],[6677,42193],[6678,8507],[6678,10523],[6679,7875],[6679,9891],[6680,8168],
 [6681,8507],[6681,10523],[6682,8032],[6683,7996],[6683,10012],[6699,8715],[6701,10854],
 [6702,10854],[6717,6719,7828],[6717,6736,7828],[6717,7828],[6717,11797,7828],[6717,38205],
 [6718,7828],[6718,38205],[6720,7875],[6720,11844],[6721,7828],[6721,11878,42193],
 [6721,11882,42193],[6721,12362,42193],[6721,42193],[6722,7950],[6722,11919],[6723,7996],
 [6723,11965],[6724,8032],[6725,7828],[6725,44904],[6726,7828],[6726,11787,40287],
 [6726,11790,40287],[6726,12056,40287],[6726,40287],[6728,8168],[6729,7828],[6729,40287],
 [6730,7828],[6730,12193,47575],[6730,12194,47575],[6730,12359,47575],[6730,47575],
 [6731,7828],[6731,11792,40450],[6731,11793,40450],[6731,12219,40450],[6731,40450],
 [6732,7828],[6732,40450],[6735,7828],[6735,44904],[6737,7828],[6737,47575],[6738,7950],
 [6738,11919],[6740,7828],[6740,42193],[6741,8507],[6741,12476],[6742,7875],[6742,11844],
 [6743,8168],[6744,8507],[6744,12476],[6745,8032],[6746,7996],[6746,11965],[6763,12747],
 [6766,12747],[6767,12979],[6768,12979],[6779,6781,7828],[6779,6798,7828],[6779,7828],
 [6779,13688,7828],[6779,38205],[6780,7828],[6780,38205],[6782,7875],[6782,7950],
 [6782,13735],[6782,13810],[6783,7828],[6783,13769,42193],[6783,13773,42193],
 [6783,14253,42193],[6783,42193],[6784,7875],[6784,7950],[6784,13735],[6784,13810],
 [6785,7996],[6785,13856],[6786,8032],[6787,7828],[6787,44904],[6788,7828],
 [6788,13678,40287],[6788,13681,40287],[6788,13947,40287],[6788,40287],[6790,8168],
 [6791,7828],[6791,40287],[6792,7828],[6792,14084,47575],[6792,14085,47575],
 [6792,14250,47575],[6792,47575],[6793,7828],[6793,13683,40450],[6793,13684,40450],
 [6793,14110,40450],[6793,40450],[6794,7828],[6794,40450],[6797,7828],[6797,44904],
 [6799,7828],[6799,47575],[6800,7875],[6800,7950],[6800,13735],[6800,13810],[6802,7828],
 [6802,42193],[6803,8507],[6803,14367],[6804,7875],[6804,7950],[6804,13735],[6804,13810],
 [6805,8168],[6806,8507],[6806,14367],[6807,8032],[6808,7996],[6808,13856],[6812,14514],
 [6813,14523],[6813,14565],[6817,14523],[6817,14565],[6818,14514],[6819,14523],
 [6819,14565],[6820,14523],[6820,14565],[6825,14635],[6826,14635],[6840,6842,7828],
 [6840,6859,7828],[6840,7828],[6840,15518,7828],[6840,38205],[6841,7828],[6841,38205],
 [6843,7875],[6843,15565],[6844,7828],[6844,42193],[6845,7950],[6845,15640],[6846,7996],
 [6846,15686],[6847,8032],[6848,7828],[6848,44904],[6849,7828],[6849,15508,40287],
 [6849,15511,40287],[6849,15777,40287],[6849,40287],[6851,8168],[6852,7828],[6852,40287],
 [6853,7828],[6853,15914,47575],[6853,15915,47575],[6853,16080,47575],[6853,47575],
 [6854,7828],[6854,15513,40450],[6854,15514,40450],[6854,15940,40450],[6854,40450],
 [6855,7828],[6855,40450],[6858,7828],[6858,44904],[6860,7828],[6860,47575],[6861,7950],
 [6861,15640],[6863,7828],[6863,42193],[6864,8507],[6864,16197],[6865,7875],[6865,15565],
 [6866,8168],[6867,8507],[6867,16197],[6868,8032],[6869,7996],[6869,15686],[6885,10854],
 [6887,12747],[6900,6902,7828],[6900,6919,7828],[6900,7828],[6900,17288,7828],[6900,38205],
 [6901,7828],[6901,38205],[6903,7875],[6903,17335],[6904,7828],[6904,17369,42193],
 [6904,17373,42193],[6904,17853,42193],[6904,42193],[6905,7950],[6905,17410],[6906,7996],
 [6906,17456],[6907,8032],[6908,7828],[6908,44904],[6909,7828],[6909,17278,40287],
 [6909,17281,40287],[6909,17547,40287],[6909,40287],[6911,8168],[6912,7828],[6912,40287],
 [6913,7828],[6913,17684,47575],[6913,17685,47575],[6913,17850,47575],[6913,47575],
 [6914,7828],[6914,17283,40450],[6914,17284,40450],[6914,17710,40450],[6914,40450],
 [6915,7828],[6915,40450],[6918,7828],[6918,44904],[6920,7828],[6920,47575],[6921,7950],
 [6921,17410],[6923,7828],[6923,42193],[6924,8507],[6924,17967],[6925,7875],[6925,17335],
 [6926,8168],[6927,8507],[6927,17967],[6928,8032],[6929,7996],[6929,17456],[6945,14635],
 [6946,8962],[6959,6961,7828],[6959,6978,7828],[6959,7828],[6959,18999,7828],[6959,38205],
 [6960,7828],[6960,38205],[6962,7875],[6962,7950],[6962,19046],[6962,19121],[6963,7828],
 [6963,19080,42193],[6963,19084,42193],[6963,19564,42193],[6963,42193],[6964,7875],
 [6964,7950],[6964,19046],[6964,19121],[6965,7996],[6965,19167],[6966,8032],[6967,7828],
 [6967,44904],[6968,7828],[6968,18989,40287],[6968,18992,40287],[6968,19258,40287],
 [6968,40287],[6970,8168],[6971,7828],[6971,40287],[6972,7828],[6972,19395,47575],
 [6972,19396,47575],[6972,19561,47575],[6972,47575],[6973,7828],[6973,18994,40450],
 [6973,18995,40450],[6973,19421,40450],[6973,40450],[6974,7828],[6974,40450],[6977,7828],
 [6977,44904],[6979,7828],[6979,47575],[6980,7875],[6980,7950],[6980,19046],[6980,19121],
 [6982,7828],[6982,42193],[6983,8507],[6983,19678],[6984,7875],[6984,7950],[6984,19046],
 [6984,19121],[6985,8168],[6986,8507],[6986,19678],[6987,8032],[6988,7996],[6988,19167],
 [6994,19848],[6994,19857],[6995,19848],[6995,19857],[6996,19862],[7001,19862],
 [7002,19848],[7002,19857],[7003,19848],[7003,19857],[7017,7019,7828],[7017,7036,7828],
 [7017,7828],[7017,20652,7828],[7017,38205],[7018,7828],[7018,38205],[7020,7875],
 [7020,20699],[7021,7828],[7021,20733,42193],[7021,20737,42193],[7021,21217,42193],
 [7021,42193],[7022,7950],[7022,20774],[7023,7996],[7023,20820],[7024,8032],[7025,7828],
 [7025,44904],[7026,7828],[7026,20642,40287],[7026,20645,40287],[7026,20911,40287],
 [7026,40287],[7028,8168],[7029,7828],[7029,40287],[7030,7828],[7030,21048,47575],
 [7030,21049,47575],[7030,21214,47575],[7030,47575],[7031,7828],[7031,20647,40450],
 [7031,20648,40450],[7031,21074,40450],[7031,40450],[7032,7828],[7032,40450],[7035,7828],
 [7035,44904],[7037,7828],[7037,47575],[7038,7950],[7038,20774],[7040,7828],[7040,42193],
 [7041,8507],[7041,21331],[7042,7875],[7042,20699],[7043,8168],[7044,8507],[7044,21331],
 [7045,8032],[7046,7996],[7046,20820],[7074,7076,7828],[7074,7093,7828],[7074,7828],
 [7074,22248,7828],[7074,22329,42193],[7074,22333,42193],[7074,22813,42193],[7074,38205],
 [7074,42193],[7075,7828],[7075,38205],[7075,42193],[7077,7875],[7078,7828],[7078,38205],
 [7078,42193],[7079,7950],[7079,22370],[7080,7996],[7080,22416],[7081,8032],[7082,7828],
 [7082,22238,40287],[7082,22241,40287],[7082,22507,40287],[7082,40287],[7082,44904],
 [7083,7828],[7083,40287],[7083,44904],[7085,8168],[7086,7828],[7086,40287],[7086,44904],
 [7087,7828],[7087,22243,40450],[7087,22244,40450],[7087,22644,47575],[7087,22645,47575],
 [7087,22670,40450],[7087,22810,47575],[7087,40450],[7087,47575],[7088,7828],[7088,40450],
 [7088,47575],[7089,7828],[7089,40450],[7089,47575],[7092,7828],[7092,40287],[7092,44904],
 [7094,7828],[7094,40450],[7094,47575],[7095,7950],[7095,22370],[7097,7828],[7097,38205],
 [7097,42193],[7098,8507],[7098,22927],[7099,7875],[7100,8168],[7101,8507],[7101,22927],
 [7102,8032],[7103,7996],[7103,22416],[7119,12979],[7130,7132,7828],[7130,7149,7828],
 [7130,7828],[7130,23788,7828],[7130,38205],[7131,7828],[7131,38205],[7133,7875],
 [7133,23835],[7134,7828],[7134,23869,42193],[7134,23873,42193],[7134,24353,42193],
 [7134,42193],[7135,7950],[7135,23910],[7136,7996],[7136,23956],[7137,8032],[7138,7828],
 [7138,44904],[7139,7828],[7139,40287],[7141,8168],[7142,7828],[7142,40287],[7143,7828],
 [7143,24184,47575],[7143,24185,47575],[7143,24350,47575],[7143,47575],[7144,7828],
 [7144,23783,40450],[7144,23784,40450],[7144,24210,40450],[7144,40450],[7145,7828],
 [7145,40450],[7148,7828],[7148,44904],[7150,7828],[7150,47575],[7151,7950],[7151,23910],
 [7153,7828],[7153,42193],[7154,8507],[7154,24467],[7155,7875],[7155,23835],[7156,8168],
 [7157,8507],[7157,24467],[7158,8032],[7159,7996],[7159,23956],[7185,7187,7828],
 [7185,7204,7828],[7185,7828],[7185,25273,7828],[7185,38205],[7186,7828],[7186,38205],
 [7188,7875],[7188,25320],[7189,7828],[7189,25354,42193],[7189,25358,42193],
 [7189,25838,42193],[7189,42193],[7190,7950],[7190,25395],[7191,7996],[7191,25441],
 [7192,8032],[7193,7828],[7193,44904],[7194,7828],[7194,25263,40287],[7194,25266,40287],
 [7194,25532,40287],[7194,40287],[7196,8168],[7197,7828],[7197,40287],[7198,7828],
 [7198,25669,47575],[7198,25670,47575],[7198,25835,47575],[7198,47575],[7199,7828],
 [7199,25268,40450],[7199,25269,40450],[7199,25695,40450],[7199,40450],[7200,7828],
 [7200,40450],[7203,7828],[7203,44904],[7205,7828],[7205,47575],[7206,7950],[7206,25395],
 [7208,7828],[7208,42193],[7209,8507],[7209,25952],[7210,7875],[7210,25320],[7211,8168],
 [7212,8507],[7212,25952],[7213,8032],[7214,7996],[7214,25441],[7230,26160],[7231,26160],
 [7233,26316],[7234,26316],[7237,26510],[7238,26510],[7239,7241,7828],[7239,7258,7828],
 [7239,7828],[7239,26704,7828],[7239,38205],[7240,7828],[7240,38205],[7242,7875],
 [7242,26751],[7243,7828],[7243,26785,42193],[7243,26789,42193],[7243,27269,42193],
 [7243,42193],[7244,7950],[7244,26826],[7245,7996],[7245,26872],[7246,8032],[7247,7828],
 [7247,44904],[7248,7828],[7248,26694,40287],[7248,26697,40287],[7248,26963,40287],
 [7248,40287],[7250,8168],[7251,7828],[7251,40287],[7252,7828],[7252,27100,47575],
 [7252,27101,47575],[7252,27266,47575],[7252,47575],[7253,7828],[7253,26699,40450],
 [7253,26700,40450],[7253,27126,40450],[7253,40450],[7254,7828],[7254,40450],[7257,7828],
 [7257,44904],[7259,7828],[7259,47575],[7260,7950],[7260,26826],[7262,7828],[7262,42193],
 [7263,8507],[7263,27383],[7264,7875],[7264,26751],[7265,8168],[7266,8507],[7266,27383],
 [7267,8032],[7268,7996],[7268,26872],[7284,26160],[7285,27643],[7286,27643],[7289,27841],
 [7290,27841],[7292,7294,7828],[7292,7311,7828],[7292,7828],[7292,28082,7828],[7292,38205],
 [7293,7828],[7293,38205],[7295,7875],[7295,28129],[7296,7828],[7296,28163,42193],
 [7296,28167,42193],[7296,28647,42193],[7296,42193],[7297,7950],[7297,28204],[7298,7996],
 [7298,28250],[7299,8032],[7300,7828],[7300,44904],[7301,7828],[7301,28072,40287],
 [7301,28075,40287],[7301,28341,40287],[7301,40287],[7303,8168],[7304,7828],[7304,40287],
 [7305,7828],[7305,28478,47575],[7305,28479,47575],[7305,28644,47575],[7305,47575],
 [7306,7828],[7306,28077,40450],[7306,28078,40450],[7306,28504,40450],[7306,40450],
 [7307,7828],[7307,40450],[7310,7828],[7310,44904],[7312,7828],[7312,47575],[7313,7950],
 [7313,28204],[7315,7828],[7315,42193],[7316,8507],[7316,28761],[7317,7875],[7317,28129],
 [7318,8168],[7319,8507],[7319,28761],[7320,8032],[7321,7996],[7321,28250],[7337,28970],
 [7339,28970],[7341,29168],[7343,29168],[7344,7346,7828],[7344,7363,7828],[7344,7828],
 [7344,29408,7828],[7344,38205],[7345,7828],[7345,38205],[7347,7875],[7347,29455],
 [7348,7828],[7348,29489,42193],[7348,29493,42193],[7348,29973,42193],[7348,42193],
 [7349,7950],[7349,29530],[7350,7996],[7350,29576],[7351,8032],[7352,7828],[7352,44904],
 [7353,7828],[7353,29398,40287],[7353,29401,40287],[7353,29667,40287],[7353,40287],
 [7355,8168],[7356,7828],[7356,40287],[7357,7828],[7357,29804,47575],[7357,29805,47575],
 [7357,29970,47575],[7357,47575],[7358,7828],[7358,29403,40450],[7358,29404,40450],
 [7358,29830,40450],[7358,40450],[7359,7828],[7359,40450],[7362,7828],[7362,44904],
 [7364,7828],[7364,47575],[7365,7950],[7365,29530],[7367,7828],[7367,42193],[7368,8507],
 [7368,30087],[7369,7875],[7369,29455],[7370,8168],[7371,8507],[7371,30087],[7372,8032],
 [7373,7996],[7373,29576],[7389,27643],[7390,28970],[7391,30394],[7392,30394],
 [7395,7397,7828],[7395,7414,7828],[7395,7828],[7395,30683,7828],[7395,38205],[7396,7828],
 [7396,38205],[7398,7875],[7398,30730],[7399,7828],[7399,30764,42193],[7399,30768,42193],
 [7399,31248,42193],[7399,42193],[7400,7950],[7400,30805],[7401,7996],[7401,30851],
 [7402,8032],[7403,7828],[7403,44904],[7404,7828],[7404,30673,40287],[7404,30676,40287],
 [7404,30942,40287],[7404,40287],[7406,8168],[7407,7828],[7407,40287],[7408,7828],
 [7408,31079,47575],[7408,31080,47575],[7408,31245,47575],[7408,47575],[7409,7828],
 [7409,30678,40450],[7409,30679,40450],[7409,31105,40450],[7409,40450],[7410,7828],
 [7410,40450],[7413,7828],[7413,44904],[7415,7828],[7415,47575],[7416,7950],[7416,30805],
 [7418,7828],[7418,42193],[7419,8507],[7419,31362],[7420,7875],[7420,30730],[7421,8168],
 [7422,8507],[7422,31362],[7423,8032],[7424,7996],[7424,30851],[7440,26316],[7441,31620],
 [7443,31620],[7445,7447,7828],[7445,7464,7828],[7445,7828],[7445,31908,7828],[7445,38205],
 [7446,7828],[7446,38205],[7448,7875],[7448,31955],[7449,7828],[7449,31989,42193],
 [7449,31993,42193],[7449,32473,42193],[7449,42193],[7450,7950],[7450,32030],[7451,7996],
 [7451,32076],[7452,8032],[7453,7828],[7453,44904],[7454,7828],[7454,31898,40287],
 [7454,31901,40287],[7454,32167,40287],[7454,40287],[7456,8168],[7457,7828],[7457,40287],
 [7458,7828],[7458,32304,47575],[7458,32305,47575],[7458,32470,47575],[7458,47575],
 [7459,7828],[7459,31903,40450],[7459,31904,40450],[7459,32330,40450],[7459,40450],
 [7460,7828],[7460,40450],[7463,7828],[7463,44904],[7465,7828],[7465,47575],[7466,7950],
 [7466,32030],[7468,7828],[7468,42193],[7469,8507],[7469,32587],[7470,7875],[7470,31955],
 [7471,8168],[7472,8507],[7472,32587],[7473,8032],[7474,7996],[7474,32076],[7490,32797],
 [7493,32797],[7494,7496,7828],[7494,7513,7828],[7494,7828],[7494,33084,7828],[7494,38205],
 [7495,7828],[7495,38205],[7497,7875],[7497,33131],[7498,7828],[7498,33165,42193],
 [7498,33169,42193],[7498,33649,42193],[7498,42193],[7499,7950],[7499,33206],[7500,7996],
 [7500,33252],[7501,8032],[7502,7828],[7502,44904],[7503,7828],[7503,33074,40287],
 [7503,33077,40287],[7503,33343,40287],[7503,40287],[7505,8168],[7506,7828],[7506,40287],
 [7507,7828],[7507,33480,47575],[7507,33481,47575],[7507,33646,47575],[7507,47575],
 [7508,7828],[7508,33079,40450],[7508,33080,40450],[7508,33506,40450],[7508,40450],
 [7509,7828],[7509,40450],[7512,7828],[7512,44904],[7514,7828],[7514,47575],[7515,7950],
 [7515,33206],[7517,7828],[7517,42193],[7518,8507],[7518,33763],[7519,7875],[7519,33131],
 [7520,8168],[7521,8507],[7521,33763],[7522,8032],[7523,7996],[7523,33252],[7539,30394],
 [7540,31620],[7541,32797],[7542,7544,7828],[7542,7561,7828],[7542,7828],[7542,34212,7828],
 [7542,38205],[7543,7828],[7543,38205],[7545,7875],[7545,34259],[7546,7828],
 [7546,34293,42193],[7546,34297,42193],[7546,34777,42193],[7546,42193],[7547,7950],
 [7547,34334],[7548,7996],[7548,34380],[7549,8032],[7550,7828],[7550,44904],[7551,7828],
 [7551,34202,40287],[7551,34205,40287],[7551,34471,40287],[7551,40287],[7553,8168],
 [7554,7828],[7554,40287],[7555,7828],[7555,34608,47575],[7555,34609,47575],
 [7555,34774,47575],[7555,47575],[7556,7828],[7556,34207,40450],[7556,34208,40450],
 [7556,34634,40450],[7556,40450],[7557,7828],[7557,40450],[7560,7828],[7560,44904],
 [7562,7828],[7562,47575],[7563,7950],[7563,34334],[7565,7828],[7565,42193],[7566,8507],
 [7566,34891],[7567,7875],[7567,34259],[7568,8168],[7569,8507],[7569,34891],[7570,8032],
 [7571,7996],[7571,34380],[7587,27841],[7588,29168],[7589,7591,7828],[7589,7608,7828],
 [7589,7828],[7589,35293,7828],[7589,38205],[7590,7828],[7590,38205],[7592,7875],
 [7592,35340],[7593,7828],[7593,35374,42193],[7593,35378,42193],[7593,35858,42193],
 [7593,42193],[7594,7950],[7594,35415],[7595,7996],[7595,35461],[7596,8032],[7597,7828],
 [7597,44904],[7598,7828],[7598,35283,40287],[7598,35286,40287],[7598,35552,40287],
 [7598,40287],[7600,8168],[7601,7828],[7601,40287],[7602,7828],[7602,35689,47575],
 [7602,35690,47575],[7602,35855,47575],[7602,47575],[7603,7828],[7603,35288,40450],
 [7603,35289,40450],[7603,35715,40450],[7603,40450],[7604,7828],[7604,40450],[7607,7828],
 [7607,44904],[7609,7828],[7609,47575],[7610,7950],[7610,35415],[7612,7828],[7612,42193],
 [7613,8507],[7613,35972],[7614,7875],[7614,35340],[7615,8168],[7616,8507],[7616,35972],
 [7617,8032],[7618,7996],[7618,35461],[7634,26510],[7635,7637,7828],[7635,7654,7828],
 [7635,7828],[7635,36328,7828],[7635,38205],[7636,7828],[7636,38205],[7638,7875],
 [7638,36375],[7639,7828],[7639,36409,42193],[7639,36413,42193],[7639,36893,42193],
 [7639,42193],[7640,7950],[7640,36450],[7641,7996],[7641,36496],[7642,8032],[7643,7828],
 [7643,44904],[7644,7828],[7644,36318,40287],[7644,36321,40287],[7644,36587,40287],
 [7644,40287],[7646,8168],[7647,7828],[7647,40287],[7648,7828],[7648,36724,47575],
 [7648,36725,47575],[7648,36890,47575],[7648,47575],[7649,7828],[7649,36323,40450],
 [7649,36324,40450],[7649,36750,40450],[7649,40450],[7650,7828],[7650,40450],[7653,7828],
 [7653,44904],[7655,7828],[7655,47575],[7656,7950],[7656,36450],[7658,7828],[7658,42193],
 [7659,8507],[7659,37007],[7660,7875],[7660,36375],[7661,8168],[7662,8507],[7662,37007],
 [7663,8032],[7664,7996],[7664,36496],[7680,7682,7828],[7680,7699,7828],[7680,7828],
 [7680,37318,7828],[7680,38205],[7681,7828],[7681,38205],[7683,7875],[7683,37365],
 [7684,7828],[7684,37399,42193],[7684,37403,42193],[7684,37883,42193],[7684,42193],
 [7685,7950],[7685,37440],[7686,7996],[7686,37486],[7687,8032],[7688,7828],[7688,44904],
 [7689,7828],[7689,37308,40287],[7689,37311,40287],[7689,37577,40287],[7689,40287],
 [7691,8168],[7692,7828],[7692,40287],[7693,7828],[7693,37714,47575],[7693,37715,47575],
 [7693,37880,47575],[7693,47575],[7694,7828],[7694,37313,40450],[7694,37314,40450],
 [7694,37740,40450],[7694,40450],[7695,7828],[7695,40450],[7698,7828],[7698,44904],
 [7700,7828],[7700,47575],[7701,7950],[7701,37440],[7703,7828],[7703,42193],[7704,8507],
 [7704,37997],[7705,7875],[7705,37365],[7706,8168],[7707,8507],[7707,37997],[7708,8032],
 [7709,7996],[7709,37486],[7735,7828],[7735,8168],[7735,38205],[7737,7828],[7737,38205],
 [7737,38660,47575],[7737,38661,47575],[7737,38826,47575],[7737,39563,47575],
 [7737,39564,47575],[7737,39729,47575],[7737,47575],[7740,7825,7828],[7740,7825,48796],
 [7740,7828],[7740,7831,7828],[7740,7831,48796],[7740,8311,7828],[7740,8311,48796],
 [7740,8314,7828],[7740,8314,48796],[7740,8392,7828],[7740,8392,48796],[7740,38205],
 [7740,40511,7828],[7740,40511,48796],[7740,40514,7828],[7740,40514,48796],[7740,40592,7828],
 [7740,40592,48796],[7740,48796],[7741,7826,7828],[7741,7828],[7741,8338,7828],
 [7741,38205],[7741,40538,7828],[7744,7828],[7744,38205],[7744,47575],[7746,7828],
 [7746,38205],[7746,48796],[7748,7828],[7748,8507],[7748,38205],[7748,38943],[7748,39846],
 [7748,40707],[7748,49887],[7750,7828],[7750,8168],[7750,38205],[7751,7828],[7751,8507],
 [7751,38205],[7751,38943],[7751,39846],[7751,40707],[7751,49887],[7754,7828],
 [7754,7839,7828],[7754,8400,7828],[7754,38205],[7754,40600,7828],[7755,7828],
 [7755,7840,7828],[7755,7840,40824],[7755,7841,7828],[7755,7841,40824],[7755,8401,7828],
 [7755,8401,40824],[7755,8402,7828],[7755,8402,40824],[7755,8624,7828],[7755,8624,40824],
 [7755,38205],[7755,40601,7828],[7755,40601,40824],[7755,40602,7828],[7755,40602,40824],
 [7755,40824],[7755,50004,7828],[7755,50004,40824],[7756,7828],[7756,38205],[7756,40824],
 [7757,7828],[7757,7842,7828],[7757,8403,7828],[7757,38205],[7757,40603,7828],[7758,7828],
 [7758,7843,7828],[7758,7843,50046],[7758,7850,7828],[7758,7850,50046],[7758,8404,7828],
 [7758,8404,50046],[7758,8411,7828],[7758,8411,50046],[7758,8666,7828],[7758,8666,50046],
 [7758,38205],[7758,40604,7828],[7758,40604,50046],[7758,40611,7828],[7758,40611,50046],
 [7758,40866,7828],[7758,40866,50046],[7758,50046],[7759,7828],[7759,7844,7828],
 [7759,7844,40870],[7759,7845,7828],[7759,7845,40870],[7759,8405,7828],[7759,8405,40870],
 [7759,8406,7828],[7759,8406,40870],[7759,8670,7828],[7759,8670,40870],[7759,38205],
 [7759,40605,7828],[7759,40605,40870],[7759,40606,7828],[7759,40606,40870],[7759,40870],
 [7759,50050,7828],[7759,50050,40870],[7760,7828],[7760,38205],[7760,40870],[7761,7828],
 [7761,7846,7828],[7761,8407,7828],[7761,38205],[7761,40607,7828],[7762,7828],
 [7762,7847,7828],[7762,7847,50075],[7762,7849,7828],[7762,7849,50075],[7762,8408,7828],
 [7762,8408,50075],[7762,8410,7828],[7762,8410,50075],[7762,8695,7828],[7762,8695,50075],
 [7762,38205],[7762,40608,7828],[7762,40608,50075],[7762,40610,7828],[7762,40610,50075],
 [7762,40895,7828],[7762,40895,50075],[7762,50075],[7763,7828],[7763,7848,7828],
 [7763,8409,7828],[7763,38205],[7763,40609,7828],[7764,7828],[7764,38205],[7764,50075],
 [7765,7828],[7765,38205],[7765,50046],[7766,7828],[7766,7851,7828],[7766,8412,7828],
 [7766,38205],[7766,40612,7828],[7767,7828],[7767,7852,7828],[7767,7852,40914],
 [7767,7853,7828],[7767,7853,40914],[7767,8413,7828],[7767,8413,40914],[7767,8414,7828],
 [7767,8414,40914],[7767,8714,7828],[7767,8714,40914],[7767,38205],[7767,40613,7828],
 [7767,40613,40914],[7767,40614,7828],[7767,40614,40914],[7767,40914],[7767,50094,7828],
 [7767,50094,40914],[7768,7828],[7768,38205],[7768,40914],[7778,7828],[7778,8168],
 [7778,38205],[7780,7828],[7780,38205],[7780,47575],[7783,7828],[7783,38205],[7783,48796],
 [7784,7828],[7784,38205],[7787,7828],[7787,38205],[7787,47575],[7789,7828],[7789,38205],
 [7789,48796],[7791,7828],[7791,8507],[7791,38205],[7791,38943],[7791,39846],[7791,40707],
 [7791,49887],[7793,7828],[7793,8168],[7793,38205],[7794,7828],[7794,8507],[7794,38205],
 [7794,38943],[7794,39846],[7794,40707],[7794,49887],[7797,7828],[7797,38205],
 [7798,7828],[7798,38205],[7798,40824],[7799,7828],[7799,38205],[7799,40824],[7800,7828],
 [7800,38205],[7801,7828],[7801,38205],[7801,50046],[7802,7828],[7802,38205],[7802,40870],
 [7803,7828],[7803,38205],[7803,40870],[7804,7828],[7804,38205],[7805,7828],[7805,38205],
 [7805,50075],[7806,7828],[7806,38205],[7807,7828],[7807,38205],[7807,50075],[7808,7828],
 [7808,38205],[7808,50046],[7809,7828],[7809,38205],[7810,7828],[7810,38205],[7810,40914],
 [7811,7828],[7811,38205],[7811,40914],[7856,7875],[7856,7996],[7856,41012],[7856,41016],
 [7856,41548],[7856,43772],[7857,7875],[7857,8032],[7857,41049],[7857,41547],[7861,7875],
 [7861,8168],[7861,41187],[7861,41545],[7863,7828],[7863,7875],[7863,7950],[7863,40055],
 [7863,40063,40055],[7863,40063,40450],[7863,40063,41239],[7863,40063,42761],
 [7863,40064,40055],[7863,40064,40450],[7863,40064,41239],[7863,40064,42761],
 [7863,40065,40055],[7863,40065,40450],[7863,40065,41239],[7863,40065,42761],
 [7863,40070,40055],[7863,40142,40055],[7863,40142,40450],[7863,40142,41239],
 [7863,40142,42761],[7863,40143,40055],[7863,40143,40450],[7863,40143,41239],
 [7863,40143,42761],[7863,40144,40055],[7863,40144,40450],[7863,40144,41239],
 [7863,40144,42761],[7863,40149,40055],[7863,40419,40055],[7863,40419,40450],
 [7863,40419,41239],[7863,40419,42761],[7863,40420,40055],[7863,40420,40450],
 [7863,40420,41239],[7863,40420,42761],[7863,40426,40642],[7863,40430,40642],[7863,40450],
 [7863,40455,40450],[7863,40455,40642],[7863,40455,48035],[7863,40455,48445],
 [7863,40456,40450],[7863,40456,40642],[7863,40456,48035],[7863,40456,48445],
 [7863,40460,40450],[7863,40460,40642],[7863,40460,48035],[7863,40460,48445],
 [7863,40484,40450],[7863,40484,40642],[7863,40484,48035],[7863,40484,48445],
 [7863,40485,40450],[7863,40485,40642],[7863,40485,48035],[7863,40485,48445],
 [7863,40489,40450],[7863,40489,40642],[7863,40489,48035],[7863,40489,48445],
 [7863,40615,40450],[7863,40615,40642],[7863,40615,48035],[7863,40615,48445],
 [7863,40619,40450],[7863,40619,40642],[7863,40619,48035],[7863,40619,48445],[7863,40642],
 [7863,40962,40055],[7863,40962,40450],[7863,40962,41239],[7863,40962,42761],
 [7863,40963,40055],[7863,40963,40450],[7863,40963,41239],[7863,40963,42761],
 [7863,40964,40055],[7863,40964,40450],[7863,40964,41239],[7863,40964,42761],
 [7863,40969,40055],[7863,41239],[7863,41240,40055],[7863,41240,40450],[7863,41240,41239],
 [7863,41240,42761],[7863,41244,41239],[7863,41244,41411],[7863,41244,47575],
 [7863,41244,48035],[7863,41245,41239],[7863,41245,41411],[7863,41245,47575],
 [7863,41245,48035],[7863,41246,41239],[7863,41246,41411],[7863,41246,47575],
 [7863,41246,48035],[7863,41250,41239],[7863,41270,40055],[7863,41270,40450],
 [7863,41270,41239],[7863,41270,42761],[7863,41274,41239],[7863,41274,41411],
 [7863,41274,47575],[7863,41274,48035],[7863,41275,41239],[7863,41275,41411],
 [7863,41275,47575],[7863,41275,48035],[7863,41276,41239],[7863,41276,41411],
 [7863,41276,47575],[7863,41276,48035],[7863,41280,41239],[7863,41303,41411],
 [7863,41304,48445],[7863,41305,41411],[7863,41309,48445],[7863,41410,41239],
 [7863,41410,41411],[7863,41410,47575],[7863,41410,48035],[7863,41411],[7863,41435,41239],
 [7863,41435,41411],[7863,41435,47575],[7863,41435,48035],[7863,41439,48445],
 [7863,42760,40055],[7863,42760,40450],[7863,42760,41239],[7863,42760,42761],[7863,42761],
 [7863,42765,42761],[7863,42765,42936],[7863,42765,47575],[7863,42765,48445],
 [7863,42766,42761],[7863,42766,42936],[7863,42766,47575],[7863,42766,48445],
 [7863,42767,42761],[7863,42771,42761],[7863,42771,42936],[7863,42771,47575],
 [7863,42771,48445],[7863,42791,40055],[7863,42791,40450],[7863,42791,41239],
 [7863,42791,42761],[7863,42795,42936],[7863,42796,48035],[7863,42797,48035],
 [7863,42801,42936],[7863,42824,42761],[7863,42824,42936],[7863,42824,47575],
 [7863,42824,48445],[7863,42825,42761],[7863,42825,42936],[7863,42825,47575],
 [7863,42825,48445],[7863,42826,42761],[7863,42830,42761],[7863,42830,42936],
 [7863,42830,47575],[7863,42830,48445],[7863,42931,42761],[7863,42931,42936],
 [7863,42931,47575],[7863,42931,48445],[7863,42936],[7863,42956,48035],[7863,42960,42761],
 [7863,42960,42936],[7863,42960,47575],[7863,42960,48445],[7863,47435,40055],
 [7863,47435,40450],[7863,47435,41239],[7863,47435,42761],[7863,47439,41239],
 [7863,47439,41411],[7863,47439,47575],[7863,47439,48035],[7863,47440,41239],
 [7863,47440,41411],[7863,47440,47575],[7863,47440,48035],[7863,47441,41239],
 [7863,47441,41411],[7863,47441,47575],[7863,47441,48035],[7863,47445,41239],
 [7863,47468,42761],[7863,47468,42936],[7863,47468,47575],[7863,47468,48445],
 [7863,47469,42761],[7863,47469,42936],[7863,47469,47575],[7863,47469,48445],
 [7863,47470,42761],[7863,47474,42761],[7863,47474,42936],[7863,47474,47575],
 [7863,47474,48445],[7863,47575],[7863,47576,41239],[7863,47576,41411],[7863,47576,47575],
 [7863,47576,48035],[7863,47580,42761],[7863,47580,42936],[7863,47580,47575],
 [7863,47580,48445],[7863,47600,41239],[7863,47600,41411],[7863,47600,47575],
 [7863,47600,48035],[7863,47604,42761],[7863,47604,42936],[7863,47604,47575],
 [7863,47604,48445],[7863,47627,40642],[7863,47904,40450],[7863,47904,40642],
 [7863,47904,48035],[7863,47904,48445],[7863,47905,40450],[7863,47905,40642],
 [7863,47905,48035],[7863,47905,48445],[7863,47909,40450],[7863,47909,40642],
 [7863,47909,48035],[7863,47909,48445],[7863,48010,41239],[7863,48010,41411],
 [7863,48010,47575],[7863,48010,48035],[7863,48011,41239],[7863,48011,41411],
 [7863,48011,47575],[7863,48011,48035],[7863,48015,42936],[7863,48035],[7863,48039,40450],
 [7863,48039,40642],[7863,48039,48035],[7863,48039,48445],[7863,48062,40450],
 [7863,48062,40642],[7863,48062,48035],[7863,48062,48445],[7863,48416,42761],
 [7863,48416,42936],[7863,48416,47575],[7863,48416,48445],[7863,48417,41411],
 [7863,48421,42761],[7863,48421,42936],[7863,48421,47575],[7863,48421,48445],
 [7863,48441,40450],[7863,48441,40642],[7863,48441,48035],[7863,48441,48445],[7863,48445],
 [7863,48468,40450],[7863,48468,40642],[7863,48468,48035],[7863,48468,48445],
 [7863,49795,41239],[7863,49795,41411],[7863,49795,47575],[7863,49795,48035],
 [7863,49799,42761],[7863,49799,42936],[7863,49799,47575],[7863,49799,48445],
 [7863,50098,40450],[7863,50098,40642],[7863,50098,48035],[7863,50098,48445],[7864,7828],
 [7864,7875],[7864,7950],[7864,40055],[7864,40450],[7864,40642],[7864,41239],[7864,41411],
 [7864,42761],[7864,42936],[7864,47575],[7864,48035],[7864,48445],[7865,7828],
 [7865,7875],[7865,7950],[7865,40055],[7865,40450],[7865,40642],[7865,41239],[7865,41411],
 [7865,42761],[7865,42936],[7865,47575],[7865,48035],[7865,48445],[7866,7875],
 [7866,41337],[7867,7875],[7867,7950],[7867,41364],[7867,42881],[7870,7828],[7870,7875],
 [7870,7950],[7870,40055],[7870,40450],[7870,40642],[7870,41239],[7870,41411],
 [7870,42761],[7870,42936],[7870,47575],[7870,48035],[7870,48445],[7872,7875],
 [7872,41484],[7874,7875],[7874,8507],[7874,41525],[7874,41527],[7874,41546],[7874,51066],
 [7876,7875],[7876,8168],[7876,41187],[7876,41545],[7877,7875],[7877,8507],[7877,41525],
 [7877,41527],[7877,41546],[7877,51066],[7878,7875],[7878,8032],[7878,41049],[7878,41547],
 [7879,7875],[7879,7996],[7879,41012],[7879,41016],[7879,41548],[7879,43772],[7880,7875],
 [7880,7950],[7880,41549],[7880,42988],[7881,7875],[7881,41550],[7882,7875],[7882,41551],
 [7883,7875],[7883,7950],[7883,41552],[7883,42991],[7884,7875],[7884,41553],[7885,7875],
 [7885,41554],[7886,7875],[7886,41555],[7887,7875],[7887,7950],[7887,41556],[7887,42995],
 [7888,7875],[7888,41557],[7889,7875],[7889,7950],[7889,41558],[7889,42997],[7890,7875],
 [7890,41559],[7891,7875],[7891,41560],[7892,7875],[7892,7950],[7892,41561],[7892,43000],
 [7893,7875],[7893,41562],[7894,7875],[7894,41563],[7896,7828],[7896,7996],[7896,40196],
 [7896,41786,42193],[7896,41790,42193],[7896,41796],[7896,42193],[7896,42199,42193],
 [7896,42289,42193],[7896,43637,42193],[7896,43643],[7896,43733],[7896,49869,42193],
 [7897,7828],[7897,8032],[7897,8507],[7897,40707],[7897,41823,42193],[7897,41823,44394],
 [7897,41827,42193],[7897,41827,44394],[7897,41828,42193],[7897,41828,44394],[7897,42193],
 [7897,42194,42193],[7897,42194,44394],[7897,42197,42193],[7897,42197,42362],
 [7897,42198,42193],[7897,42198,42362],[7897,42284,42193],[7897,42284,44394],
 [7897,42287,42193],[7897,42287,42362],[7897,42288,42193],[7897,42288,42362],
 [7897,42307,42362],[7897,42308,42362],[7897,42362],[7897,44303,42193],[7897,44303,44394],
 [7897,44304,42193],[7897,44304,44394],[7897,44307],[7897,44394],[7897,44397,44394],
 [7897,44417,44394],[7897,49864,42193],[7897,49864,44394],[7897,49867,42193],
 [7897,49867,42362],[7897,49868,42193],[7897,49868,42362],[7897,49887],[7897,49888],
 [7897,49942,42193],[7897,49942,42362],[7897,50857,44394],[7897,50912,42193],
 [7897,50912,42362],[7897,51102,42362],[7901,7828],[7901,8168],[7901,41961,42193],
 [7901,41965,42193],[7901,42193],[7901,42196,42193],[7901,42286,42193],[7901,46617,42193],
 [7901,49866,42193],[7903,7828],[7903,42024,42193],[7903,42024,47575],[7903,42025,42193],
 [7903,42025,47575],[7903,42028,42193],[7903,42028,47575],[7903,42190,42193],
 [7903,42190,47575],[7903,42193],[7903,42217,42193],[7903,42217,47575],[7903,47575],
 [7903,47578,42193],[7903,47578,47575],[7903,47602,42193],[7903,47602,47575],
 [7903,49797,42193],[7903,49797,47575],[7904,7828],[7904,40450],[7904,40458,40450],
 [7904,40487,40450],[7904,42054,42193],[7904,42058,42193],[7904,42083,42193],
 [7904,42087,42193],[7904,42193],[7904,47907,40450],[7904,48013,42193],[7904,48419,42193],
 [7905,7828],[7905,40450],[7905,42193],[7906,7828],[7906,42109],[7906,42111,42109],
 [7906,42111,42193],[7906,42111,48796],[7906,42111,49217],[7906,42114,42109],
 [7906,42114,42193],[7906,42114,48796],[7906,42114,49217],[7906,42115,42109],
 [7906,42115,42193],[7906,42115,48796],[7906,42115,49217],[7906,42138,42109],
 [7906,42138,42193],[7906,42138,48796],[7906,42138,49217],[7906,42141,42109],
 [7906,42141,42193],[7906,42141,48796],[7906,42141,49217],[7906,42142,42109],
 [7906,42142,42193],[7906,42142,48796],[7906,42142,49217],[7906,42192,42109],
 [7906,42192,42193],[7906,42192,48796],[7906,42192,49217],[7906,42193],[7906,42262,42109],
 [7906,42262,42193],[7906,42262,48796],[7906,42262,49217],[7906,48742,42109],
 [7906,48742,42193],[7906,48742,48796],[7906,48742,49217],[7906,48745,42109],
 [7906,48745,42193],[7906,48745,48796],[7906,48745,49217],[7906,48746,42109],
 [7906,48746,42193],[7906,48746,48796],[7906,48746,49217],[7906,48796],[7906,48797,42109],
 [7906,48797,42193],[7906,48797,48796],[7906,48797,49217],[7906,48866,42109],
 [7906,48866,42193],[7906,48866,48796],[7906,48866,49217],[7906,49147,42109],
 [7906,49147,42193],[7906,49147,48796],[7906,49147,49217],[7906,49148,42109],
 [7906,49148,42193],[7906,49148,48796],[7906,49148,49217],[7906,49217],[7906,49842,42109],
 [7906,49842,42193],[7906,49842,48796],[7906,49842,49217],[7907,7828],[7907,42109],
 [7907,42193],[7907,48796],[7907,49217],[7910,7828],[7910,42193],[7910,47575],
 [7912,7828],[7912,42109],[7912,42193],[7912,48796],[7912,49217],[7914,7828],[7914,8032],
 [7914,8507],[7914,40707],[7914,42193],[7914,42362],[7914,44307],[7914,44394],
 [7914,49887],[7914,49888],[7916,7828],[7916,8168],[7916,42193],[7917,7828],[7917,8032],
 [7917,8507],[7917,40707],[7917,42193],[7917,42362],[7917,44307],[7917,44394],
 [7917,49887],[7917,49888],[7918,7828],[7918,8032],[7918,8507],[7918,40707],[7918,42193],
 [7918,42362],[7918,44307],[7918,44394],[7918,49887],[7918,49888],[7919,7828],
 [7919,7996],[7919,40196],[7919,41796],[7919,42193],[7919,43643],[7919,43733],
 [7920,7828],[7920,42193],[7920,42200,42193],[7920,42290,42193],[7920,49870,42193],
 [7921,7828],[7921,40824],[7921,42193],[7921,42201,42193],[7921,42202,42193],
 [7921,42291,42193],[7921,42292,42193],[7921,49871,42193],[7921,49872,42193],[7922,7828],
 [7922,40824],[7922,42193],[7923,7828],[7923,42193],[7923,42203,42193],[7923,42203,42449],
 [7923,42203,50046],[7923,42203,51006],[7923,42204,42193],[7923,42204,42449],
 [7923,42204,50046],[7923,42204,51006],[7923,42211,42193],[7923,42211,42449],
 [7923,42211,50046],[7923,42211,51006],[7923,42293,42193],[7923,42293,42449],
 [7923,42293,50046],[7923,42293,51006],[7923,42294,42193],[7923,42294,42449],
 [7923,42294,50046],[7923,42294,51006],[7923,42301,42193],[7923,42301,42449],
 [7923,42301,50046],[7923,42301,51006],[7923,42449],[7923,42456,42193],[7923,42456,42449],
 [7923,42456,50046],[7923,42456,51006],[7923,42466,42193],[7923,42466,42449],
 [7923,42466,50046],[7923,42466,51006],[7923,49873,42193],[7923,49873,42449],
 [7923,49873,50046],[7923,49873,51006],[7923,49874,42193],[7923,49874,42449],
 [7923,49874,50046],[7923,49874,51006],[7923,49881,42193],[7923,49881,42449],
 [7923,49881,50046],[7923,49881,51006],[7923,50029,42193],[7923,50029,42449],
 [7923,50029,50046],[7923,50029,51006],[7923,50036,42193],[7923,50036,42449],
 [7923,50036,50046],[7923,50036,51006],[7923,50046],[7923,50999,42193],[7923,50999,42449],
 [7923,50999,50046],[7923,50999,51006],[7923,51006],[7923,51016,42193],[7923,51016,42449],
 [7923,51016,50046],[7923,51016,51006],[7923,52181,42193],[7923,52181,42449],
 [7923,52181,50046],[7923,52181,51006],[7924,7828],[7924,42193],[7924,42449],[7924,50046],
 [7924,51006],[7925,7828],[7925,40870],[7925,42193],[7925,42205,42193],[7925,42206,42193],
 [7925,42295,42193],[7925,42296,42193],[7925,49875,42193],[7925,49876,42193],[7926,7828],
 [7926,40870],[7926,42193],[7927,7828],[7927,42193],[7927,42207,42193],[7927,42297,42193],
 [7927,49877,42193],[7928,7828],[7928,42193],[7928,42208,42193],[7928,42208,42494],
 [7928,42208,50075],[7928,42208,51050],[7928,42209,42193],[7928,42209,42494],
 [7928,42209,50075],[7928,42209,51050],[7928,42210,42193],[7928,42210,42494],
 [7928,42210,50075],[7928,42210,51050],[7928,42298,42193],[7928,42298,42494],
 [7928,42298,50075],[7928,42298,51050],[7928,42299,42193],[7928,42299,42494],
 [7928,42299,50075],[7928,42299,51050],[7928,42300,42193],[7928,42300,42494],
 [7928,42300,50075],[7928,42300,51050],[7928,42494],[7928,42495,42193],[7928,42495,42494],
 [7928,42495,50075],[7928,42495,51050],[7928,42500,42193],[7928,42500,42494],
 [7928,42500,50075],[7928,42500,51050],[7928,49878,42193],[7928,49878,42494],
 [7928,49878,50075],[7928,49878,51050],[7928,49879,42193],[7928,49879,42494],
 [7928,49879,50075],[7928,49879,51050],[7928,49880,42193],[7928,49880,42494],
 [7928,49880,50075],[7928,49880,51050],[7928,50074,42193],[7928,50074,42494],
 [7928,50074,50075],[7928,50074,51050],[7928,50075],[7928,50080,42193],[7928,50080,42494],
 [7928,50080,50075],[7928,50080,51050],[7928,51044,42193],[7928,51044,42494],
 [7928,51044,50075],[7928,51044,51050],[7928,51045,42193],[7928,51045,42494],
 [7928,51045,50075],[7928,51045,51050],[7928,51050],[7928,52360,42193],[7928,52360,42494],
 [7928,52360,50075],[7928,52360,51050],[7929,7828],[7929,42193],[7929,42494],[7929,50075],
 [7929,51050],[7930,7828],[7930,42193],[7930,42494],[7930,50075],[7930,51050],
 [7931,7828],[7931,42193],[7931,42449],[7931,50046],[7931,51006],[7932,7828],[7932,42193],
 [7932,42212,42193],[7932,42302,42193],[7932,49882,42193],[7933,7828],[7933,40914],
 [7933,42193],[7933,42213,42193],[7933,42214,42193],[7933,42303,42193],[7933,42304,42193],
 [7933,49883,42193],[7933,49884,42193],[7934,7828],[7934,40914],[7934,42193],[7935,7950],
 [7935,7996],[7935,8507],[7935,42529,43685],[7935,42532,43685],[7935,42535,43104],
 [7935,42537,43104],[7935,42982,43685],[7935,42985,43104],[7935,42987,43104],
 [7935,43048,43104],[7935,43050,43104],[7935,43104],[7935,43685],[7935,43688,43685],
 [7935,43690,43685],[7935,43751,43685],[7935,43753,43685],[7935,43807,43104],
 [7935,50416,43685],[7935,50418,43685],[7935,50472,43104],[7935,51103,43104],[7936,7950],
 [7936,8032],[7936,42566],[7936,42986],[7940,7950],[7940,8168],[7940,42704],[7940,42984],
 [7942,7828],[7942,7875],[7942,7950],[7942,40055],[7942,40450],[7942,40642],[7942,41239],
 [7942,41411],[7942,42761],[7942,42936],[7942,47575],[7942,48035],[7942,48445],
 [7943,7828],[7943,7875],[7943,7950],[7943,40055],[7943,40450],[7943,40642],[7943,41239],
 [7943,41411],[7943,42761],[7943,42936],[7943,47575],[7943,48035],[7943,48445],
 [7944,7828],[7944,7875],[7944,7950],[7944,40055],[7944,40450],[7944,40642],[7944,41239],
 [7944,41411],[7944,42761],[7944,42936],[7944,47575],[7944,48035],[7944,48445],
 [7945,7950],[7945,42854],[7946,7875],[7946,7950],[7946,41364],[7946,42881],[7949,7828],
 [7949,7875],[7949,7950],[7949,40055],[7949,40450],[7949,40642],[7949,41239],[7949,41411],
 [7949,42761],[7949,42936],[7949,47575],[7949,48035],[7949,48445],[7951,7950],
 [7951,42980],[7953,7950],[7953,7996],[7953,8507],[7953,43104],[7953,43685],[7955,7950],
 [7955,8168],[7955,42704],[7955,42984],[7956,7950],[7956,7996],[7956,8507],[7956,43104],
 [7956,43685],[7957,7950],[7957,8032],[7957,42566],[7957,42986],[7958,7950],[7958,7996],
 [7958,8507],[7958,43104],[7958,43685],[7959,7875],[7959,7950],[7959,41549],[7959,42988],
 [7960,7950],[7960,42989],[7961,7950],[7961,42990],[7962,7875],[7962,7950],[7962,41552],
 [7962,42991],[7963,7950],[7963,42992],[7964,7950],[7964,42993],[7965,7950],[7965,42994],
 [7966,7875],[7966,7950],[7966,41556],[7966,42995],[7967,7950],[7967,42996],[7968,7875],
 [7968,7950],[7968,41558],[7968,42997],[7969,7950],[7969,42998],[7970,7950],[7970,42999],
 [7971,7875],[7971,7950],[7971,41561],[7971,43000],[7972,7950],[7972,43001],[7973,7950],
 [7973,43002],[7975,7828],[7975,7996],[7975,40196],[7975,43313],[7975,43618],[7975,43643],
 [7975,44904],[7976,7828],[7976,7996],[7976,8168],[7976,40176,40287],[7976,40176,43330],
 [7976,40178,40287],[7976,40178,43330],[7976,40179,40287],[7976,40179,43330],[7976,40193],
 [7976,40196],[7976,40286,40287],[7976,40286,43330],[7976,40287],[7976,40301,40287],
 [7976,40301,47266],[7976,40304,40287],[7976,40304,47266],[7976,40354,40287],
 [7976,40354,43330],[7976,40371],[7976,40400,40287],[7976,40400,47266],[7976,40403,40287],
 [7976,40403,47266],[7976,40746,40287],[7976,40746,47266],[7976,43330],[7976,43331,40287],
 [7976,43331,43330],[7976,43348,43330],[7976,43398,40287],[7976,43398,43330],
 [7976,43415,43330],[7976,43444,47266],[7976,43447,47266],[7976,43643],[7976,43790,47266],
 [7976,45289,40287],[7976,45289,43330],[7976,45306,43330],[7976,45335,40287],
 [7976,45335,47266],[7976,45338,40287],[7976,45338,47266],[7976,45681,40287],
 [7976,45681,47266],[7976,47266],[7977,7996],[7977,43382],[7978,7828],[7978,7996],
 [7978,8168],[7978,40193],[7978,40196],[7978,40287],[7978,40371],[7978,43330],
 [7978,43643],[7978,47266],[7979,7828],[7979,7996],[7979,8168],[7979,40193],[7979,40196],
 [7979,40287],[7979,40371],[7979,43330],[7979,43643],[7979,47266],[7980,7828],
 [7980,7996],[7980,40196],[7980,43478],[7980,43643],[7980,43667],[7980,47575],
 [7980,47584,47575],[7980,47608,47575],[7980,49803,47575],[7981,2279],[7981,3507],
 [7981,3756],[7981,3794],[7981,5705],[7981,6183],[7981,6213],[7981,7828],[7981,7996],
 [7981,8032],[7981,38205],[7981,38418],[7981,38454],[7981,38455],[7981,39015],
 [7981,39313],[7981,39602],[7981,39603],[7981,39631],[7981,40195],[7981,40196],
 [7981,40233],[7981,40450],[7981,43536],[7981,43643],[7981,43965],[7981,44174],
 [7981,44904],[7981,47993],[7982,2279],[7982,3507],[7982,3756],[7982,3794],[7982,5705],
 [7982,6183],[7982,6213],[7982,7828],[7982,7996],[7982,8032],[7982,38205],[7982,38418],
 [7982,38454],[7982,38455],[7982,39015],[7982,39313],[7982,39602],[7982,39603],
 [7982,39631],[7982,40195],[7982,40196],[7982,40233],[7982,40450],[7982,43536],
 [7982,43643],[7982,43965],[7982,44174],[7982,44904],[7982,47993],[7983,7996],
 [7983,43565],[7984,7996],[7984,43592],[7985,7828],[7985,7996],[7985,40196],[7985,43313],
 [7985,43618],[7985,43643],[7985,44904],[7987,7828],[7987,7996],[7987,40196],[7987,43478],
 [7987,43643],[7987,43667],[7987,47575],[7988,7950],[7988,7996],[7988,8507],[7988,43104],
 [7988,43685],[7989,7996],[7989,43712],[7990,7828],[7990,7996],[7990,40196],[7990,41796],
 [7990,42193],[7990,43643],[7990,43733],[7991,7950],[7991,7996],[7991,8507],[7991,43104],
 [7991,43685],[7992,7875],[7992,7996],[7992,41012],[7992,41016],[7992,41548],[7992,43772],
 [7993,7828],[7993,7996],[7993,8168],[7993,40193],[7993,40196],[7993,40287],[7993,40371],
 [7993,43330],[7993,43643],[7993,47266],[7994,7950],[7994,7996],[7994,8507],[7994,43104],
 [7994,43685],[7997,7996],[7997,43839],[7998,7996],[7998,43840],[7999,7996],[7999,43841],
 [8000,7996],[8000,43842],[8001,7996],[8001,43843],[8002,7996],[8002,43844],[8003,7996],
 [8003,43845],[8004,7996],[8004,43846],[8005,7996],[8005,43847],[8006,7996],[8006,43848],
 [8007,7996],[8007,43849],[8008,7996],[8008,43850],[8009,7996],[8009,43851],[8010,7996],
 [8010,43852],[8011,7996],[8011,43853],[8012,7828],[8012,8032],[8012,44904],[8013,7828],
 [8013,8032],[8013,40213,40287],[8013,40216,40287],[8013,40287],[8013,40303,40287],
 [8013,40402,40287],[8013,43997,40287],[8013,45337,40287],[8014,8032],[8014,8168],
 [8014,44030],[8014,46241],[8015,8032],[8015,8168],[8015,44030],[8015,46241],[8016,7828],
 [8016,8032],[8016,40287],[8017,7828],[8017,8032],[8017,44134,47575],[8017,44135,47575],
 [8017,44300,47575],[8017,47575],[8017,47583,47575],[8017,47607,47575],[8017,49802,47575],
 [8020,8032],[8021,8032],[8022,7828],[8022,8032],[8022,44904],[8024,7828],[8024,8032],
 [8024,47575],[8025,7950],[8025,8032],[8025,42566],[8025,42986],[8026,8032],[8027,7828],
 [8027,8032],[8027,8507],[8027,40707],[8027,42193],[8027,42362],[8027,44307],[8027,44394],
 [8027,49887],[8027,49888],[8028,7828],[8028,8032],[8028,8507],[8028,40707],[8028,42193],
 [8028,42362],[8028,44307],[8028,44394],[8028,49887],[8028,49888],[8029,7875],
 [8029,8032],[8029,41049],[8029,41547],[8030,8032],[8030,8168],[8030,44030],[8030,46241],
 [8031,7828],[8031,8032],[8031,8507],[8031,40707],[8031,42193],[8031,42362],[8031,44307],
 [8031,44394],[8031,49887],[8031,49888],[8034,8032],[8035,8032],[8036,8032],[8037,8032],
 [8038,8032],[8039,8032],[8040,8032],[8041,8032],[8042,8032],[8043,8032],[8044,8032],
 [8045,8032],[8046,8032],[8047,8032],[8048,8032],[8054,7828],[8054,40254,40450],
 [8054,40255,40450],[8054,40450],[8054,40453,40450],[8054,40482,40450],[8054,44790,40450],
 [8054,44904],[8054,47902,40450],[8055,7828],[8055,40450],[8055,44904],[8056,7828],
 [8056,44904],[8056,48796],[8057,7828],[8057,44904],[8062,7828],[8062,44904],[8062,48796],
 [8068,7828],[8068,8032],[8068,44904],[8069,7828],[8069,7996],[8069,40196],[8069,43313],
 [8069,43618],[8069,43643],[8069,44904],[8070,7828],[8070,44904],[8071,7828],[8071,40824],
 [8071,44904],[8072,7828],[8072,40824],[8072,44904],[8073,7828],[8073,44904],[8074,7828],
 [8074,44904],[8074,50046],[8075,7828],[8075,40870],[8075,44904],[8076,7828],[8076,40870],
 [8076,44904],[8077,7828],[8077,44904],[8078,7828],[8078,44904],[8078,50075],[8079,7828],
 [8079,44904],[8080,7828],[8080,44904],[8080,50075],[8081,7828],[8081,44904],[8081,50046],
 [8082,7828],[8082,44904],[8083,7828],[8083,40914],[8083,44904],[8084,7828],[8084,40914],
 [8084,44904],[8086,7828],[8086,7996],[8086,8168],[8086,40193],[8086,40196],[8086,40287],
 [8086,40371],[8086,43330],[8086,43643],[8086,47266],[8088,7828],[8088,40287],
 [8088,40288,40287],[8088,40295,40287],[8088,40387,40287],[8088,40394,40287],
 [8088,45322,40287],[8088,45329,40287],[8088,46944,47575],[8088,46945,47575],
 [8088,47110,47575],[8088,47575],[8089,7828],[8089,40287],[8089,40289,40287],
 [8089,40289,40450],[8089,40290,40287],[8089,40290,40450],[8089,40388,40287],
 [8089,40388,40450],[8089,40389,40287],[8089,40389,40450],[8089,40450],[8089,45323,40287],
 [8089,45323,40450],[8089,45324,40287],[8089,45324,40450],[8089,45385,40287],
 [8089,45385,40450],[8089,46970,40287],[8089,46970,40450],[8090,7828],[8090,40287],
 [8090,40450],[8091,7828],[8091,40287],[8091,40291,40287],[8091,40297,40287],
 [8091,40390,40287],[8091,40396,40287],[8091,45325,40287],[8091,45331,40287],[8091,48796],
 [8092,7828],[8092,40287],[8092,40292,40287],[8092,40391,40287],[8092,45326,40287],
 [8095,7828],[8095,40287],[8095,47575],[8097,7828],[8097,40287],[8097,48796],[8099,7828],
 [8099,8507],[8099,40287],[8099,40299,40287],[8099,40302,40287],[8099,40398,40287],
 [8099,40401,40287],[8099,40707],[8099,45333,40287],[8099,45336,40287],[8099,45642],
 [8099,47227],[8099,49887],[8101,7828],[8101,7996],[8101,8168],[8101,40193],[8101,40196],
 [8101,40287],[8101,40371],[8101,43330],[8101,43643],[8101,47266],[8102,7828],
 [8102,8507],[8102,40287],[8102,40707],[8102,45642],[8102,47227],[8102,49887],
 [8103,7828],[8103,8032],[8103,40287],[8104,7828],[8104,7996],[8104,8168],[8104,40193],
 [8104,40196],[8104,40287],[8104,40371],[8104,43330],[8104,43643],[8104,47266],
 [8105,7828],[8105,40287],[8105,40305,40287],[8105,40305,40824],[8105,40305,45745],
 [8105,40305,47331],[8105,40306,40287],[8105,40306,40824],[8105,40306,45745],
 [8105,40306,47331],[8105,40307,40287],[8105,40307,40824],[8105,40307,45745],
 [8105,40307,47331],[8105,40404,40287],[8105,40404,40824],[8105,40404,45745],
 [8105,40404,47331],[8105,40405,40287],[8105,40405,40824],[8105,40405,45745],
 [8105,40405,47331],[8105,40406,40287],[8105,40406,40824],[8105,40406,45745],
 [8105,40406,47331],[8105,40810,40287],[8105,40810,40824],[8105,40810,45745],
 [8105,40810,47331],[8105,40811,40287],[8105,40811,40824],[8105,40811,45745],
 [8105,40811,47331],[8105,40824],[8105,45339,40287],[8105,45339,40824],[8105,45339,45745],
 [8105,45339,47331],[8105,45340,40287],[8105,45340,40824],[8105,45340,45745],
 [8105,45340,47331],[8105,45341,40287],[8105,45341,40824],[8105,45341,45745],
 [8105,45341,47331],[8105,45745],[8105,45746,40287],[8105,45746,40824],[8105,45746,45745],
 [8105,45746,47331],[8105,45759,40287],[8105,45759,40824],[8105,45759,45745],
 [8105,45759,47331],[8105,47330,40287],[8105,47330,40824],[8105,47330,45745],
 [8105,47330,47331],[8105,47331],[8105,47344,40287],[8105,47344,40824],[8105,47344,45745],
 [8105,47344,47331],[8105,51940,40287],[8105,51940,40824],[8105,51940,45745],
 [8105,51940,47331],[8106,7828],[8106,40287],[8106,40824],[8106,45745],[8106,47331],
 [8107,7828],[8107,40287],[8107,40824],[8107,45745],[8107,47331],[8108,7828],[8108,40287],
 [8108,40308,40287],[8108,40407,40287],[8108,45342,40287],[8109,7828],[8109,40287],
 [8109,40309,40287],[8109,40316,40287],[8109,40408,40287],[8109,40415,40287],
 [8109,45343,40287],[8109,45350,40287],[8109,50046],[8110,7828],[8110,40287],
 [8110,40310,40287],[8110,40310,40870],[8110,40310,45806],[8110,40310,47399],
 [8110,40311,40287],[8110,40311,40870],[8110,40311,45806],[8110,40311,47399],
 [8110,40312,40287],[8110,40312,40870],[8110,40312,45806],[8110,40312,47399],
 [8110,40409,40287],[8110,40409,40870],[8110,40409,45806],[8110,40409,47399],
 [8110,40410,40287],[8110,40410,40870],[8110,40410,45806],[8110,40410,47399],
 [8110,40411,40287],[8110,40411,40870],[8110,40411,45806],[8110,40411,47399],[8110,40870],
 [8110,40871,40287],[8110,40871,40870],[8110,40871,45806],[8110,40871,47399],
 [8110,40879,40287],[8110,40879,40870],[8110,40879,45806],[8110,40879,47399],
 [8110,45344,40287],[8110,45344,40870],[8110,45344,45806],[8110,45344,47399],
 [8110,45345,40287],[8110,45345,40870],[8110,45345,45806],[8110,45345,47399],
 [8110,45346,40287],[8110,45346,40870],[8110,45346,45806],[8110,45346,47399],
 [8110,45805,40287],[8110,45805,40870],[8110,45805,45806],[8110,45805,47399],[8110,45806],
 [8110,45814,40287],[8110,45814,40870],[8110,45814,45806],[8110,45814,47399],
 [8110,47390,40287],[8110,47390,40870],[8110,47390,45806],[8110,47390,47399],
 [8110,47391,40287],[8110,47391,40870],[8110,47391,45806],[8110,47391,47399],[8110,47399],
 [8110,52275,40287],[8110,52275,40870],[8110,52275,45806],[8110,52275,47399],[8111,7828],
 [8111,40287],[8111,40870],[8111,45806],[8111,47399],[8112,7828],[8112,40287],
 [8112,40870],[8112,45806],[8112,47399],[8113,7828],[8113,40287],[8113,40313,40287],
 [8113,40315,40287],[8113,40412,40287],[8113,40414,40287],[8113,45347,40287],
 [8113,45349,40287],[8113,50075],[8114,7828],[8114,40287],[8114,40314,40287],
 [8114,40413,40287],[8114,45348,40287],[8115,7828],[8115,40287],[8115,50075],[8116,7828],
 [8116,40287],[8116,50046],[8117,7828],[8117,40287],[8117,40317,40287],[8117,40317,40914],
 [8117,40317,45847],[8117,40317,47433],[8117,40318,40287],[8117,40318,40914],
 [8117,40318,45847],[8117,40318,47433],[8117,40319,40287],[8117,40319,40914],
 [8117,40319,45847],[8117,40319,47433],[8117,40416,40287],[8117,40416,40914],
 [8117,40416,45847],[8117,40416,47433],[8117,40417,40287],[8117,40417,40914],
 [8117,40417,45847],[8117,40417,47433],[8117,40418,40287],[8117,40418,40914],
 [8117,40418,45847],[8117,40418,47433],[8117,40912,40287],[8117,40912,40914],
 [8117,40912,45847],[8117,40912,47433],[8117,40913,40287],[8117,40913,40914],
 [8117,40913,45847],[8117,40913,47433],[8117,40914],[8117,45351,40287],[8117,45351,40914],
 [8117,45351,45847],[8117,45351,47433],[8117,45352,40287],[8117,45352,40914],
 [8117,45352,45847],[8117,45352,47433],[8117,45353,40287],[8117,45353,40914],
 [8117,45353,45847],[8117,45353,47433],[8117,45847],[8117,45848,40287],[8117,45848,40914],
 [8117,45848,45847],[8117,45848,47433],[8117,45849,40287],[8117,45849,40914],
 [8117,45849,45847],[8117,45849,47433],[8117,47432,40287],[8117,47432,40914],
 [8117,47432,45847],[8117,47432,47433],[8117,47433],[8117,47434,40287],[8117,47434,40914],
 [8117,47434,45847],[8117,47434,47433],[8117,52394,40287],[8117,52394,40914],
 [8117,52394,45847],[8117,52394,47433],[8118,7828],[8118,40287],[8118,40914],[8118,45847],
 [8118,47433],[8119,7828],[8119,40287],[8119,40914],[8119,45847],[8119,47433],
 [8120,8032],[8120,8168],[8120,44030],[8120,46241],[8122,7828],[8122,45920,47575],
 [8122,45921,47575],[8122,46086,47575],[8122,47575],[8123,7828],[8123,40323,40450],
 [8123,40324,40450],[8123,40450],[8123,45946,40450],[8124,7828],[8124,40450],[8129,7828],
 [8129,47575],[8133,8507],[8133,46203],[8135,8032],[8135,8168],[8135,44030],[8135,46241],
 [8136,8507],[8136,46203],[8137,8032],[8137,8168],[8137,44030],[8137,46241],[8138,7996],
 [8138,43382],[8154,7828],[8154,7996],[8154,8168],[8154,40193],[8154,40196],[8154,40287],
 [8154,40371],[8154,43330],[8154,43643],[8154,47266],[8156,7828],[8156,8168],
 [8156,40356,40450],[8156,40357,40450],[8156,40450],[8156,40461,40450],[8156,40490,40450],
 [8156,46474,40450],[8156,47910,40450],[8157,7828],[8157,8168],[8157,40450],[8158,8168],
 [8159,8168],[8163,7950],[8163,8168],[8163,42704],[8163,42984],[8164,8168],[8165,7828],
 [8165,8168],[8165,42193],[8167,7875],[8167,8168],[8167,41187],[8167,41545],[8170,8032],
 [8170,8168],[8170,44030],[8170,46241],[8171,7828],[8171,7996],[8171,8168],[8171,40193],
 [8171,40196],[8171,40287],[8171,40371],[8171,43330],[8171,43643],[8171,47266],
 [8172,8168],[8173,8168],[8174,8168],[8175,8168],[8176,8168],[8177,8168],[8178,8168],
 [8179,8168],[8180,8168],[8181,8168],[8182,8168],[8183,8168],[8184,8168],[8185,8168],
 [8186,8168],[8187,7828],[8187,40287],[8187,47575],[8188,7828],[8188,40287],[8188,40450],
 [8189,7828],[8189,40287],[8189,40450],[8190,7828],[8190,40287],[8190,48796],[8191,7828],
 [8191,40287],[8194,7828],[8194,40287],[8194,47575],[8196,7828],[8196,40287],[8196,48796],
 [8198,7828],[8198,8507],[8198,40287],[8198,40707],[8198,45642],[8198,47227],[8198,49887],
 [8200,7828],[8200,7996],[8200,8168],[8200,40193],[8200,40196],[8200,40287],[8200,40371],
 [8200,43330],[8200,43643],[8200,47266],[8201,7828],[8201,8507],[8201,40287],[8201,40707],
 [8201,45642],[8201,47227],[8201,49887],[8202,7828],[8202,8032],[8202,40287],[8203,7828],
 [8203,7996],[8203,8168],[8203,40193],[8203,40196],[8203,40287],[8203,40371],[8203,43330],
 [8203,43643],[8203,47266],[8204,7828],[8204,40287],[8204,40824],[8204,45745],
 [8204,47331],[8205,7828],[8205,40287],[8205,40824],[8205,45745],[8205,47331],
 [8206,7828],[8206,40287],[8206,40824],[8206,45745],[8206,47331],[8207,7828],[8207,40287],
 [8208,7828],[8208,40287],[8208,50046],[8209,7828],[8209,40287],[8209,40870],[8209,45806],
 [8209,47399],[8210,7828],[8210,40287],[8210,40870],[8210,45806],[8210,47399],
 [8211,7828],[8211,40287],[8211,40870],[8211,45806],[8211,47399],[8212,7828],[8212,40287],
 [8212,50075],[8213,7828],[8213,40287],[8214,7828],[8214,40287],[8214,50075],[8215,7828],
 [8215,40287],[8215,50046],[8216,7828],[8216,40287],[8216,40914],[8216,45847],
 [8216,47433],[8217,7828],[8217,40287],[8217,40914],[8217,45847],[8217,47433],
 [8218,7828],[8218,40287],[8218,40914],[8218,45847],[8218,47433],[8219,7828],[8219,7875],
 [8219,7950],[8219,40055],[8219,40450],[8219,40642],[8219,41239],[8219,41411],
 [8219,42761],[8219,42936],[8219,47575],[8219,48035],[8219,48445],[8220,7828],
 [8220,7875],[8220,7950],[8220,40055],[8220,40450],[8220,40642],[8220,41239],[8220,41411],
 [8220,42761],[8220,42936],[8220,47575],[8220,48035],[8220,48445],[8221,7828],
 [8221,47496,47575],[8221,47496,48796],[8221,47497,47575],[8221,47497,48796],
 [8221,47499,47575],[8221,47499,48796],[8221,47575],[8221,47577,47575],[8221,47577,48796],
 [8221,47601,47575],[8221,47601,48796],[8221,48794,47575],[8221,48794,48796],[8221,48796],
 [8221,48820,47575],[8221,48820,48796],[8221,49796,47575],[8221,49796,48796],[8222,7828],
 [8222,47523,47575],[8222,47524,47575],[8222,47575],[8222,49145,47575],[8226,7828],
 [8226,7875],[8226,7950],[8226,40055],[8226,40450],[8226,40642],[8226,41239],[8226,41411],
 [8226,42761],[8226,42936],[8226,47575],[8226,48035],[8226,48445],[8227,7828],
 [8227,47575],[8227,48796],[8228,7828],[8228,42193],[8228,47575],[8229,2279],[8229,3507],
 [8229,3930],[8229,4193],[8229,5705],[8229,6152],[8229,6340],[8229,7828],[8229,8168],
 [8229,8507],[8229,38205],[8229,38591],[8229,39759],[8229,40707],[8229,44695],
 [8229,44702],[8229,44769],[8229,44904],[8229,45084],[8229,46593],[8229,46621],
 [8229,46645],[8229,47556],[8229,47575],[8229,47691],[8229,49500],[8229,49501],
 [8229,49886],[8229,49887],[8230,7828],[8230,7875],[8230,7950],[8230,40055],[8230,40450],
 [8230,40642],[8230,41239],[8230,41411],[8230,42761],[8230,42936],[8230,47575],
 [8230,48035],[8230,48445],[8232,2279],[8232,3507],[8232,3930],[8232,4193],[8232,5705],
 [8232,6152],[8232,6340],[8232,7828],[8232,8168],[8232,8507],[8232,38205],[8232,38591],
 [8232,39759],[8232,40707],[8232,44695],[8232,44702],[8232,44769],[8232,44904],
 [8232,45084],[8232,46593],[8232,46621],[8232,46645],[8232,47556],[8232,47575],
 [8232,47691],[8232,49500],[8232,49501],[8232,49886],[8232,49887],[8233,7828],
 [8233,8032],[8233,47575],[8234,7828],[8234,7996],[8234,40196],[8234,43478],[8234,43643],
 [8234,43667],[8234,47575],[8235,7828],[8235,47575],[8235,47585,47575],[8235,47609,47575],
 [8235,49804,47575],[8236,7828],[8236,40824],[8236,47575],[8236,47586,47575],
 [8236,47587,47575],[8236,47610,47575],[8236,47611,47575],[8236,49805,47575],
 [8236,49806,47575],[8237,7828],[8237,40824],[8237,47575],[8238,7828],[8238,47575],
 [8238,47588,47575],[8238,47612,47575],[8238,49807,47575],[8239,7828],[8239,47575],
 [8239,47589,47575],[8239,47589,50046],[8239,47596,47575],[8239,47596,50046],
 [8239,47613,47575],[8239,47613,50046],[8239,47620,47575],[8239,47620,50046],
 [8239,47851,47575],[8239,47851,50046],[8239,49808,47575],[8239,49808,50046],
 [8239,49815,47575],[8239,49815,50046],[8239,50046],[8239,50322,47575],[8239,50322,50046],
 [8240,7828],[8240,40870],[8240,47575],[8240,47590,47575],[8240,47591,47575],
 [8240,47614,47575],[8240,47615,47575],[8240,49809,47575],[8240,49810,47575],[8241,7828],
 [8241,40870],[8241,47575],[8242,7828],[8242,47575],[8242,47592,47575],[8242,47616,47575],
 [8242,49811,47575],[8243,7828],[8243,47575],[8243,47593,47575],[8243,47593,50075],
 [8243,47595,47575],[8243,47595,50075],[8243,47617,47575],[8243,47617,50075],
 [8243,47619,47575],[8243,47619,50075],[8243,47880,47575],[8243,47880,50075],
 [8243,49812,47575],[8243,49812,50075],[8243,49814,47575],[8243,49814,50075],[8243,50075],
 [8243,50351,47575],[8243,50351,50075],[8244,7828],[8244,47575],[8244,47594,47575],
 [8244,47618,47575],[8244,49813,47575],[8245,7828],[8245,47575],[8245,50075],[8246,7828],
 [8246,47575],[8246,50046],[8247,7828],[8247,47575],[8247,47597,47575],[8247,47621,47575],
 [8247,49816,47575],[8248,7828],[8248,40914],[8248,47575],[8248,47598,47575],
 [8248,47599,47575],[8248,47622,47575],[8248,47623,47575],[8248,49817,47575],
 [8248,49818,47575],[8249,7828],[8249,40914],[8249,47575],[8251,7828],[8251,40450],
 [8251,40451,40450],[8251,40457,40450],[8251,40480,40450],[8251,40486,40450],
 [8251,47900,40450],[8251,47906,40450],[8251,48796],[8252,7828],[8252,40450],
 [8252,40452,40450],[8252,40481,40450],[8252,47901,40450],[8253,7828],[8253,40450],
 [8253,44904],[8255,7828],[8255,7875],[8255,7950],[8255,40055],[8255,40450],[8255,40642],
 [8255,41239],[8255,41411],[8255,42761],[8255,42936],[8255,47575],[8255,48035],
 [8255,48445],[8256,7828],[8256,7875],[8256,7950],[8256,40055],[8256,40450],[8256,40642],
 [8256,41239],[8256,41411],[8256,42761],[8256,42936],[8256,47575],[8256,48035],
 [8256,48445],[8257,7828],[8257,40450],[8257,48796],[8258,7828],[8258,40450],[8258,42193],
 [8259,7828],[8259,8507],[8259,40450],[8259,40459,40450],[8259,40488,40450],[8259,40707],
 [8259,47908,40450],[8259,48127],[8259,48533],[8259,49887],[8260,7828],[8260,7875],
 [8260,7950],[8260,40055],[8260,40450],[8260,40642],[8260,41239],[8260,41411],
 [8260,42761],[8260,42936],[8260,47575],[8260,48035],[8260,48445],[8261,7828],
 [8261,8168],[8261,40450],[8262,7828],[8262,8507],[8262,40450],[8262,40707],[8262,48127],
 [8262,48533],[8262,49887],[8264,2279],[8264,3507],[8264,3756],[8264,3794],[8264,5705],
 [8264,6183],[8264,6213],[8264,7828],[8264,7996],[8264,8032],[8264,38205],[8264,38418],
 [8264,38454],[8264,38455],[8264,39015],[8264,39313],[8264,39602],[8264,39603],
 [8264,39631],[8264,40195],[8264,40196],[8264,40233],[8264,40450],[8264,43536],
 [8264,43643],[8264,43965],[8264,44174],[8264,44904],[8264,47993],[8265,7828],
 [8265,40450],[8265,40465,40450],[8265,40494,40450],[8265,47914,40450],[8266,7828],
 [8266,40450],[8266,40466,40450],[8266,40466,40824],[8266,40467,40450],[8266,40467,40824],
 [8266,40495,40450],[8266,40495,40824],[8266,40496,40450],[8266,40496,40824],[8266,40824],
 [8266,47915,40450],[8266,47915,40824],[8266,47916,40450],[8266,47916,40824],
 [8266,48244,40450],[8266,48244,40824],[8266,48650,40450],[8266,48650,40824],[8267,7828],
 [8267,40450],[8267,40824],[8268,7828],[8268,40450],[8268,40468,40450],[8268,40497,40450],
 [8268,47917,40450],[8269,7828],[8269,40450],[8269,40469,40450],[8269,40476,40450],
 [8269,40498,40450],[8269,40505,40450],[8269,47918,40450],[8269,47925,40450],[8269,50046],
 [8270,7828],[8270,40450],[8270,40470,40450],[8270,40470,40870],[8270,40471,40450],
 [8270,40471,40870],[8270,40499,40450],[8270,40499,40870],[8270,40500,40450],
 [8270,40500,40870],[8270,40870],[8270,47919,40450],[8270,47919,40870],[8270,47920,40450],
 [8270,47920,40870],[8270,48290,40450],[8270,48290,40870],[8270,48696,40450],
 [8270,48696,40870],[8271,7828],[8271,40450],[8271,40870],[8272,7828],[8272,40450],
 [8272,40472,40450],[8272,40501,40450],[8272,47921,40450],[8273,7828],[8273,40450],
 [8273,40473,40450],[8273,40475,40450],[8273,40502,40450],[8273,40504,40450],
 [8273,47922,40450],[8273,47924,40450],[8273,50075],[8274,7828],[8274,40450],
 [8274,40474,40450],[8274,40503,40450],[8274,47923,40450],[8275,7828],[8275,40450],
 [8275,50075],[8276,7828],[8276,40450],[8276,50046],[8277,7828],[8277,40450],
 [8277,40477,40450],[8277,40506,40450],[8277,47926,40450],[8278,7828],[8278,40450],
 [8278,40478,40450],[8278,40478,40914],[8278,40479,40450],[8278,40479,40914],
 [8278,40507,40450],[8278,40507,40914],[8278,40508,40450],[8278,40508,40914],[8278,40914],
 [8278,47927,40450],[8278,47927,40914],[8278,47928,40450],[8278,47928,40914],
 [8278,48334,40450],[8278,48334,40914],[8278,48740,40450],[8278,48740,40914],[8279,7828],
 [8279,40450],[8279,40914],[8280,7828],[8280,40450],[8280,48796],[8281,7828],[8281,40450],
 [8282,7828],[8282,40450],[8282,44904],[8284,7828],[8284,7875],[8284,7950],[8284,40055],
 [8284,40450],[8284,40642],[8284,41239],[8284,41411],[8284,42761],[8284,42936],
 [8284,47575],[8284,48035],[8284,48445],[8285,7828],[8285,7875],[8285,7950],[8285,40055],
 [8285,40450],[8285,40642],[8285,41239],[8285,41411],[8285,42761],[8285,42936],
 [8285,47575],[8285,48035],[8285,48445],[8286,7828],[8286,40450],[8286,48796],
 [8287,7828],[8287,40450],[8287,42193],[8288,7828],[8288,8507],[8288,40450],[8288,40707],
 [8288,48127],[8288,48533],[8288,49887],[8289,7828],[8289,7875],[8289,7950],[8289,40055],
 [8289,40450],[8289,40642],[8289,41239],[8289,41411],[8289,42761],[8289,42936],
 [8289,47575],[8289,48035],[8289,48445],[8290,7828],[8290,8168],[8290,40450],[8291,7828],
 [8291,8507],[8291,40450],[8291,40707],[8291,48127],[8291,48533],[8291,49887],
 [8293,2279],[8293,3507],[8293,3756],[8293,3794],[8293,5705],[8293,6183],[8293,6213],
 [8293,7828],[8293,7996],[8293,8032],[8293,38205],[8293,38418],[8293,38454],[8293,38455],
 [8293,39015],[8293,39313],[8293,39602],[8293,39603],[8293,39631],[8293,40195],
 [8293,40196],[8293,40233],[8293,40450],[8293,43536],[8293,43643],[8293,43965],
 [8293,44174],[8293,44904],[8293,47993],[8294,7828],[8294,40450],[8295,7828],[8295,40450],
 [8295,40824],[8296,7828],[8296,40450],[8296,40824],[8297,7828],[8297,40450],[8298,7828],
 [8298,40450],[8298,50046],[8299,7828],[8299,40450],[8299,40870],[8300,7828],[8300,40450],
 [8300,40870],[8301,7828],[8301,40450],[8302,7828],[8302,40450],[8302,50075],[8303,7828],
 [8303,40450],[8304,7828],[8304,40450],[8304,50075],[8305,7828],[8305,40450],[8305,50046],
 [8306,7828],[8306,40450],[8307,7828],[8307,40450],[8307,40914],[8308,7828],[8308,40450],
 [8308,40914],[8309,7828],[8309,42109],[8309,42193],[8309,48796],[8309,49217],
 [8310,7828],[8310,44904],[8310,48796],[8312,7828],[8312,47575],[8312,48796],[8313,7950],
 [8313,42854],[8315,7828],[8315,42109],[8315,42193],[8315,48796],[8315,49217],
 [8316,8507],[8316,48911],[8317,7875],[8317,41337],[8318,8168],[8319,8507],[8319,48911],
 [8320,8032],[8321,7996],[8321,43565],[8337,7828],[8337,44904],[8339,7828],[8339,47575],
 [8340,7875],[8340,7950],[8340,41364],[8340,42881],[8341,7828],[8341,42109],[8341,42193],
 [8341,48796],[8341,49217],[8342,7828],[8342,42109],[8342,42193],[8342,48796],
 [8342,49217],[8343,8507],[8343,49262],[8344,7875],[8344,7950],[8344,41364],[8344,42881],
 [8345,8168],[8346,8507],[8346,49262],[8347,8032],[8348,7996],[8348,43592],[8367,7828],
 [8367,44904],[8367,48796],[8373,7828],[8373,8032],[8373,44904],[8374,7828],[8374,7996],
 [8374,40196],[8374,43313],[8374,43618],[8374,43643],[8374,44904],[8375,7828],
 [8375,44904],[8376,7828],[8376,40824],[8376,44904],[8377,7828],[8377,40824],[8377,44904],
 [8378,7828],[8378,44904],[8379,7828],[8379,44904],[8379,50046],[8380,7828],[8380,40870],
 [8380,44904],[8381,7828],[8381,40870],[8381,44904],[8382,7828],[8382,44904],[8383,7828],
 [8383,44904],[8383,50075],[8384,7828],[8384,44904],[8385,7828],[8385,44904],[8385,50075],
 [8386,7828],[8386,44904],[8386,50046],[8387,7828],[8387,44904],[8388,7828],[8388,40914],
 [8388,44904],[8389,7828],[8389,40914],[8389,44904],[8415,7828],[8415,7875],[8415,7950],
 [8415,40055],[8415,40450],[8415,40642],[8415,41239],[8415,41411],[8415,42761],
 [8415,42936],[8415,47575],[8415,48035],[8415,48445],[8416,7828],[8416,47575],
 [8416,48796],[8417,7828],[8417,42193],[8417,47575],[8418,2279],[8418,3507],[8418,3930],
 [8418,4193],[8418,5705],[8418,6152],[8418,6340],[8418,7828],[8418,8168],[8418,8507],
 [8418,38205],[8418,38591],[8418,39759],[8418,40707],[8418,44695],[8418,44702],
 [8418,44769],[8418,44904],[8418,45084],[8418,46593],[8418,46621],[8418,46645],
 [8418,47556],[8418,47575],[8418,47691],[8418,49500],[8418,49501],[8418,49886],
 [8418,49887],[8419,7828],[8419,7875],[8419,7950],[8419,40055],[8419,40450],[8419,40642],
 [8419,41239],[8419,41411],[8419,42761],[8419,42936],[8419,47575],[8419,48035],
 [8419,48445],[8421,2279],[8421,3507],[8421,3930],[8421,4193],[8421,5705],[8421,6152],
 [8421,6340],[8421,7828],[8421,8168],[8421,8507],[8421,38205],[8421,38591],[8421,39759],
 [8421,40707],[8421,44695],[8421,44702],[8421,44769],[8421,44904],[8421,45084],
 [8421,46593],[8421,46621],[8421,46645],[8421,47556],[8421,47575],[8421,47691],
 [8421,49500],[8421,49501],[8421,49886],[8421,49887],[8422,7828],[8422,8032],[8422,47575],
 [8423,7828],[8423,7996],[8423,40196],[8423,43478],[8423,43643],[8423,43667],[8423,47575],
 [8424,7828],[8424,47575],[8425,7828],[8425,40824],[8425,47575],[8426,7828],[8426,40824],
 [8426,47575],[8427,7828],[8427,47575],[8428,7828],[8428,47575],[8428,50046],[8429,7828],
 [8429,40870],[8429,47575],[8430,7828],[8430,40870],[8430,47575],[8431,7828],[8431,47575],
 [8432,7828],[8432,47575],[8432,50075],[8433,7828],[8433,47575],[8434,7828],[8434,47575],
 [8434,50075],[8435,7828],[8435,47575],[8435,50046],[8436,7828],[8436,47575],[8437,7828],
 [8437,40914],[8437,47575],[8438,7828],[8438,40914],[8438,47575],[8439,7950],[8439,42980],
 [8441,7950],[8441,7996],[8441,8507],[8441,43104],[8441,43685],[8443,7950],[8443,8168],
 [8443,42704],[8443,42984],[8444,7950],[8444,7996],[8444,8507],[8444,43104],[8444,43685],
 [8445,7950],[8445,8032],[8445,42566],[8445,42986],[8446,7950],[8446,7996],[8446,8507],
 [8446,43104],[8446,43685],[8447,7875],[8447,7950],[8447,41549],[8447,42988],[8448,7950],
 [8448,42989],[8449,7950],[8449,42990],[8450,7875],[8450,7950],[8450,41552],[8450,42991],
 [8451,7950],[8451,42992],[8452,7950],[8452,42993],[8453,7950],[8453,42994],[8454,7875],
 [8454,7950],[8454,41556],[8454,42995],[8455,7950],[8455,42996],[8456,7875],[8456,7950],
 [8456,41558],[8456,42997],[8457,7950],[8457,42998],[8458,7950],[8458,42999],[8459,7875],
 [8459,7950],[8459,41561],[8459,43000],[8460,7950],[8460,43001],[8461,7950],[8461,43002],
 [8462,7828],[8462,42109],[8462,42193],[8462,48796],[8462,49217],[8463,8507],[8463,50647],
 [8464,7875],[8464,41484],[8465,8168],[8466,8507],[8466,50647],[8467,8032],[8468,7996],
 [8468,43712],[8484,7828],[8484,8032],[8484,8507],[8484,40707],[8484,42193],[8484,42362],
 [8484,44307],[8484,44394],[8484,49887],[8484,49888],[8486,7828],[8486,8168],[8486,42193],
 [8487,7828],[8487,8032],[8487,8507],[8487,40707],[8487,42193],[8487,42362],[8487,44307],
 [8487,44394],[8487,49887],[8487,49888],[8488,7828],[8488,8032],[8488,8507],[8488,40707],
 [8488,42193],[8488,42362],[8488,44307],[8488,44394],[8488,49887],[8488,49888],
 [8489,7828],[8489,7996],[8489,40196],[8489,41796],[8489,42193],[8489,43643],[8489,43733],
 [8490,7828],[8490,42193],[8491,7828],[8491,40824],[8491,42193],[8492,7828],[8492,40824],
 [8492,42193],[8493,7828],[8493,42193],[8493,42449],[8493,50046],[8493,51006],
 [8494,7828],[8494,42193],[8494,42449],[8494,50046],[8494,51006],[8495,7828],[8495,40870],
 [8495,42193],[8496,7828],[8496,40870],[8496,42193],[8497,7828],[8497,42193],[8498,7828],
 [8498,42193],[8498,42494],[8498,50075],[8498,51050],[8499,7828],[8499,42193],
 [8499,42494],[8499,50075],[8499,51050],[8500,7828],[8500,42193],[8500,42494],
 [8500,50075],[8500,51050],[8501,7828],[8501,42193],[8501,42449],[8501,50046],
 [8501,51006],[8502,7828],[8502,42193],[8503,7828],[8503,40914],[8503,42193],[8504,7828],
 [8504,40914],[8504,42193],[8505,7875],[8505,8507],[8505,41525],[8505,41527],[8505,41546],
 [8505,51066],[8508,7828],[8508,8032],[8508,8507],[8508,40707],[8508,42193],[8508,42362],
 [8508,44307],[8508,44394],[8508,49887],[8508,49888],[8509,7950],[8509,7996],[8509,8507],
 [8509,43104],[8509,43685],[8510,8507],[8510,51104],[8511,8507],[8511,51105],[8512,8507],
 [8512,51106],[8513,8507],[8513,51107],[8514,8507],[8514,51108],[8515,8507],[8515,51109],
 [8516,8507],[8516,51110],[8517,8507],[8517,51111],[8518,8507],[8518,51112],[8519,8507],
 [8519,51113],[8520,8507],[8520,51114],[8521,8507],[8521,51115],[8522,8507],[8522,51116],
 [8523,8507],[8523,51117],[8524,8507],[8524,51118],[8525,7875],[8525,8168],[8525,41187],
 [8525,41545],[8526,7875],[8526,8507],[8526,41525],[8526,41527],[8526,41546],[8526,51066],
 [8527,7875],[8527,8032],[8527,41049],[8527,41547],[8528,7875],[8528,7996],[8528,41012],
 [8528,41016],[8528,41548],[8528,43772],[8529,7875],[8529,7950],[8529,41549],[8529,42988],
 [8530,7875],[8530,41550],[8531,7875],[8531,41551],[8532,7875],[8532,7950],[8532,41552],
 [8532,42991],[8533,7875],[8533,41553],[8534,7875],[8534,41554],[8535,7875],[8535,41555],
 [8536,7875],[8536,7950],[8536,41556],[8536,42995],[8537,7875],[8537,41557],[8538,7875],
 [8538,7950],[8538,41558],[8538,42997],[8539,7875],[8539,41559],[8540,7875],[8540,41560],
 [8541,7875],[8541,7950],[8541,41561],[8541,43000],[8542,7875],[8542,41562],[8543,7875],
 [8543,41563],[8545,8032],[8545,8168],[8545,44030],[8545,46241],[8546,7828],[8546,7996],
 [8546,8168],[8546,40193],[8546,40196],[8546,40287],[8546,40371],[8546,43330],
 [8546,43643],[8546,47266],[8547,8168],[8548,8168],[8549,8168],[8550,8168],[8551,8168],
 [8552,8168],[8553,8168],[8554,8168],[8555,8168],[8556,8168],[8557,8168],[8558,8168],
 [8559,8168],[8560,8168],[8561,8168],[8562,7828],[8562,8032],[8562,8507],[8562,40707],
 [8562,42193],[8562,42362],[8562,44307],[8562,44394],[8562,49887],[8562,49888],
 [8563,7950],[8563,7996],[8563,8507],[8563,43104],[8563,43685],[8564,8507],[8564,51104],
 [8565,8507],[8565,51105],[8566,8507],[8566,51106],[8567,8507],[8567,51107],[8568,8507],
 [8568,51108],[8569,8507],[8569,51109],[8570,8507],[8570,51110],[8571,8507],[8571,51111],
 [8572,8507],[8572,51112],[8573,8507],[8573,51113],[8574,8507],[8574,51114],[8575,8507],
 [8575,51115],[8576,8507],[8576,51116],[8577,8507],[8577,51117],[8578,8507],[8578,51118],
 [8580,8032],[8581,8032],[8582,8032],[8583,8032],[8584,8032],[8585,8032],[8586,8032],
 [8587,8032],[8588,8032],[8589,8032],[8590,8032],[8591,8032],[8592,8032],[8593,8032],
 [8594,8032],[8595,7996],[8595,43839],[8596,7996],[8596,43840],[8597,7996],[8597,43841],
 [8598,7996],[8598,43842],[8599,7996],[8599,43843],[8600,7996],[8600,43844],[8601,7996],
 [8601,43845],[8602,7996],[8602,43846],[8603,7996],[8603,43847],[8604,7996],[8604,43848],
 [8605,7996],[8605,43849],[8606,7996],[8606,43850],[8607,7996],[8607,43851],[8608,7996],
 [8608,43852],[8609,7996],[8609,43853],[8610,7828],[8610,40287],[8610,40824],[8610,45745],
 [8610,47331],[8611,7828],[8611,40287],[8611,40824],[8611,45745],[8611,47331],
 [8649,7828],[8649,42193],[8649,42449],[8649,50046],[8649,51006],[8654,14514],
 [8656,7828],[8656,42193],[8656,42449],[8656,50046],[8656,51006],[8663,14523],
 [8663,14565],[8671,7828],[8671,40287],[8671,40870],[8671,45806],[8671,47399],
 [8677,19848],[8677,19857],[8679,7828],[8679,40287],[8679,40870],[8679,45806],
 [8679,47399],[8686,19848],[8686,19857],[8691,19862],[8694,7828],[8694,42193],
 [8694,42494],[8694,50075],[8694,51050],[8700,7828],[8700,42193],[8700,42494],
 [8700,50075],[8700,51050],[8705,14523],[8705,14565],[8712,7828],[8712,40287],
 [8712,40914],[8712,45847],[8712,47433],[8713,7828],[8713,40287],[8713,40914],
 [8713,45847],[8713,47433],[8716,8715],[8717,202],[8717,268],[8717,328],[8717,8715],
 [8717,8962],[8717,10854],[8717,12747],[8718,202],[8718,268],[8718,328],[8718,8715],
 [8718,8962],[8718,10854],[8718,12747],[8719,8715],[8720,202],[8720,268],[8720,328],
 [8720,8715],[8720,8962],[8720,10854],[8720,12747],[8721,8715],[8721,12979],[8722,8715],
 [8722,12979],[8723,8715],[8724,8715],[8725,8715],[8726,8715],[8727,8715],[8728,8715],
 [8729,8715],[8730,8715],[8731,8715],[8732,8715],[8733,8715],[8734,8715],[8735,8715],
 [8736,8715],[8737,8715],[8738,8715],[8739,8715],[8740,8715],[8741,8715],[8742,8715],
 [8743,8715],[8744,8715],[8745,8715],[8746,8715],[8747,8715],[8748,8715],[8749,8715],
 [8750,8715],[8751,8715],[8752,8715],[8753,8715],[8754,8715],[8755,8715],[8756,8715],
 [8757,8715],[8758,8715],[8759,8715],[8760,8715],[8761,8715],[8762,8715],[8763,8715],
 [8764,8715],[8765,8715],[8766,8715],[8766,14514],[8767,8715],[8767,14523],[8768,8715],
 [8769,8715],[8770,8715],[8771,8715],[8771,14523],[8772,8715],[8772,14514],[8773,8715],
 [8773,14565],[8774,8715],[8774,14565],[8775,8715],[8776,8715],[8777,8715],[8778,8715],
 [8779,202],[8779,268],[8779,328],[8779,8715],[8779,8962],[8779,10854],[8779,12747],
 [8780,202],[8780,268],[8780,328],[8780,8715],[8780,8962],[8780,10854],[8780,12747],
 [8781,8715],[8782,202],[8782,268],[8782,328],[8782,8715],[8782,8962],[8782,10854],
 [8782,12747],[8783,8715],[8783,12979],[8784,8715],[8784,12979],[8785,8715],[8786,8715],
 [8787,8715],[8788,8715],[8789,8715],[8790,8715],[8791,8715],[8792,8715],[8793,8715],
 [8794,8715],[8795,8715],[8796,8715],[8797,8715],[8798,8715],[8799,8715],[8800,8715],
 [8801,8715],[8802,8715],[8803,8715],[8804,8715],[8805,8715],[8806,8715],[8807,8715],
 [8808,8715],[8809,8715],[8810,8715],[8811,8715],[8812,8715],[8813,8715],[8814,8715],
 [8815,8715],[8816,8715],[8817,8715],[8818,8715],[8819,8715],[8820,8715],[8821,8715],
 [8822,8715],[8823,8715],[8824,8715],[8825,8715],[8826,8715],[8827,8715],[8828,8715],
 [8828,14514],[8829,8715],[8829,14523],[8830,8715],[8831,8715],[8832,8715],[8833,8715],
 [8833,14523],[8834,8715],[8834,14514],[8835,8715],[8835,14565],[8836,8715],[8836,14565],
 [8837,8715],[8838,8715],[8839,8715],[8840,202],[8840,393],[8840,8845],[8840,14579],
 [8841,8962],[8841,14635],[8842,8962],[8842,14635],[8843,8962],[8843,14635],[8901,202],
 [8901,268],[8901,328],[8901,8715],[8901,8962],[8901,10854],[8901,12747],[8902,202],
 [8902,569],[8902,9021],[8902,16465],[8903,202],[8903,268],[8903,328],[8903,8715],
 [8903,8962],[8903,10854],[8903,12747],[8904,202],[8904,569],[8904,9021],[8904,16465],
 [8905,202],[8905,393],[8905,8845],[8905,14579],[8906,202],[8907,202],[8908,202],
 [8909,202],[8910,202],[8911,202],[8912,202],[8913,202],[8914,202],[8915,202],
 [8916,202],[8917,202],[8917,1336],[8917,9788],[8917,17232],[8918,202],[8918,1377],
 [8918,9829],[8918,17273],[8919,202],[8920,202],[8920,1377],[8920,9829],[8920,17273],
 [8921,202],[8921,1336],[8921,9788],[8921,17232],[8922,202],[8923,202],[8924,202],
 [8924,1625],[8924,10077],[8924,17521],[8925,202],[8925,1658],[8925,10110],[8925,17554],
 [8926,202],[8926,1698],[8926,10150],[8926,17594],[8927,202],[8928,202],[8928,1761],
 [8928,10213],[8928,17657],[8929,202],[8930,202],[8931,202],[8932,202],[8932,1887],
 [8932,10339],[8932,17783],[8933,202],[8933,1915],[8933,10367],[8933,17811],[8934,202],
 [8935,202],[8935,1658],[8935,10110],[8935,17554],[8936,202],[8937,202],[8937,1625],
 [8937,10077],[8937,17521],[8938,202],[8938,2033],[8938,10485],[8938,17929],[8939,202],
 [8939,1761],[8939,10213],[8939,17657],[8940,202],[8941,202],[8941,1698],[8941,10150],
 [8941,17594],[8942,202],[8943,202],[8944,202],[8945,202],[8946,202],[8946,2033],
 [8946,10485],[8946,17929],[8947,202],[8947,1887],[8947,10339],[8947,17783],[8948,202],
 [8948,1915],[8948,10367],[8948,17811],[8949,202],[8949,2215],[8949,10667],[8949,18111],
 [8950,202],[8950,2224],[8950,10676],[8950,18120],[8951,202],[8951,2224],[8951,10676],
 [8951,18120],[8952,202],[8952,2215],[8952,10667],[8952,18111],[8953,202],[8953,2254],
 [8953,10706],[8953,18150],[8954,202],[8954,2262],[8954,10714],[8954,18158],[8955,202],
 [8955,2268],[8955,10720],[8955,18164],[8956,202],[8956,2270],[8956,10722],[8956,18166],
 [8957,202],[8957,2254],[8957,10706],[8957,18150],[8958,202],[8958,2270],[8958,10722],
 [8958,18166],[8959,202],[8959,2262],[8959,10714],[8959,18158],[8960,202],[8960,2268],
 [8960,10720],[8960,18164],[8961,8962],[8961,14635],[8963,8962],[8964,8962],[8965,8962],
 [8966,8962],[8967,8962],[8968,8962],[8969,8962],[8970,8962],[8971,8962],[8972,8962],
 [8973,8962],[8974,8962],[8975,8962],[8976,8962],[8977,8962],[8978,8962],[8979,8962],
 [8980,8962],[8981,8962],[8982,8962],[8983,8962],[8984,8962],[8985,8962],[8986,8962],
 [8987,8962],[8988,8962],[8989,8962],[8990,8962],[8991,8962],[8992,8962],[8993,8962],
 [8994,8962],[8995,8962],[8996,8962],[8997,8962],[8998,8962],[8999,8962],[9000,8962],
 [9001,8962],[9002,8962],[9003,8962],[9004,8962],[9005,8962],[9006,8962],[9007,8962],
 [9008,8962],[9009,8962],[9010,8962],[9010,19848],[9011,8962],[9011,19857],[9012,8962],
 [9012,19862],[9013,8962],[9014,8962],[9015,8962],[9016,8962],[9017,8962],[9017,19862],
 [9018,8962],[9018,19848],[9019,8962],[9019,19857],[9020,8962],[9020,14635],[9078,8962],
 [9079,8962],[9080,8962],[9081,8962],[9082,8962],[9083,8962],[9084,8962],[9085,8962],
 [9086,8962],[9087,8962],[9088,8962],[9089,8962],[9090,8962],[9091,8962],[9092,8962],
 [9093,8962],[9094,8962],[9095,8962],[9096,8962],[9097,8962],[9098,8962],[9099,8962],
 [9100,8962],[9101,8962],[9102,8962],[9103,8962],[9104,8962],[9105,8962],[9106,8962],
 [9107,8962],[9108,8962],[9109,8962],[9110,8962],[9111,8962],[9112,8962],[9113,8962],
 [9114,8962],[9115,8962],[9116,8962],[9117,8962],[9118,8962],[9119,8962],[9120,8962],
 [9121,8962],[9122,8962],[9123,8962],[9124,8962],[9125,8962],[9125,19848],[9126,8962],
 [9126,19857],[9127,8962],[9127,19862],[9128,8962],[9129,8962],[9130,8962],[9131,8962],
 [9132,8962],[9132,19862],[9133,8962],[9133,19848],[9134,8962],[9134,19857],[9135,8715],
 [9135,12979],[9246,26160],[9247,26160],[9249,26316],[9250,26316],[9253,26510],
 [9254,26510],[9300,26160],[9301,27643],[9302,27643],[9305,27841],[9306,27841],
 [9353,28970],[9355,28970],[9357,29168],[9359,29168],[9405,27643],[9406,28970],
 [9407,30394],[9408,30394],[9456,26316],[9457,31620],[9459,31620],[9506,32797],
 [9509,32797],[9555,30394],[9556,31620],[9557,32797],[9603,27841],[9604,29168],
 [9650,26510],[9744,38331],[9745,38331],[9750,38557],[9752,38557],[9792,39424],
 [9793,39424],[9804,39779],[9806,39779],[9828,40055],[9830,40055],[9846,40642],
 [9850,40642],[9856,40824],[9857,40824],[9860,40870],[9861,40870],[9868,40914],
 [9869,40914],[9871,40055],[9879,41239],[9880,41239],[9885,41411],[9887,41411],
 [9911,38331],[9914,41850],[9916,41850],[9922,42109],[9923,42109],[9933,42362],
 [9934,42362],[9939,42449],[9940,42449],[9944,42494],[9945,42494],[9953,42593],
 [9957,42593],[9958,42761],[9960,42761],[9964,42936],[9970,42936],[9972,43104],
 [9974,43104],[9992,43330],[9994,43330],[9997,3756],[10004,43685],[10007,43685],
 [10030,44030],[10031,44030],[10043,44394],[10044,44394],[10048,8032],[10066,41850],
 [10068,42593],[10101,39424],[10102,43330],[10109,45501],[10112,45501],[10121,45745],
 [10122,45745],[10126,45806],[10128,45806],[10133,45847],[10134,45847],[10136,44030],
 [10137,38557],[10143,46064],[10148,46064],[10151,46241],[10153,46241],[10184,8168],
 [10216,47266],[10219,47266],[10220,47331],[10222,47331],[10226,47399],[10227,47399],
 [10232,47433],[10234,47433],[10235,41239],[10236,42761],[10248,6152],[10271,48035],
 [10272,48035],[10300,48445],[10305,48445],[10309,6213],[10325,42109],[10327,48796],
 [10330,48796],[10357,49217],[10358,49217],[10382,45501],[10384,46064],[10407,41411],
 [10408,48796],[10411,42936],[10420,50046],[10424,50075],[10426,50075],[10427,50046],
 [10431,48035],[10434,4193],[10435,48445],[10456,39779],[10457,43685],[10458,40642],
 [10478,49217],[10500,44394],[10509,51006],[10515,51050],[10516,51050],[10517,51006],
 [10561,46241],[10562,47266],[10578,42362],[10579,43104],[10626,45745],[10627,47331],
 [10640,40824],[10665,42449],[10670,8715],[10670,14514],[10672,51006],[10679,8715],
 [10679,14523],[10682,50046],[10686,40870],[10687,45806],[10693,8962],[10693,19848],
 [10695,47399],[10702,8962],[10702,19857],[10707,8962],[10707,19862],[10710,42494],
 [10711,50075],[10716,51050],[10721,8715],[10721,14565],[10728,45847],[10729,47433],
 [10730,40914],[10731,8715],[10732,202],[10732,268],[10732,328],[10732,8715],[10732,8962],
 [10732,10854],[10732,12747],[10733,202],[10733,268],[10733,328],[10733,8715],
 [10733,8962],[10733,10854],[10733,12747],[10734,8715],[10735,202],[10735,268],
 [10735,328],[10735,8715],[10735,8962],[10735,10854],[10735,12747],[10736,8715],
 [10736,12979],[10737,8715],[10737,12979],[10738,8715],[10739,8715],[10740,8715],
 [10741,8715],[10742,8715],[10743,8715],[10744,8715],[10745,8715],[10746,8715],
 [10747,8715],[10748,8715],[10749,8715],[10750,8715],[10751,8715],[10752,8715],
 [10753,8715],[10754,8715],[10755,8715],[10756,8715],[10757,8715],[10758,8715],
 [10759,8715],[10760,8715],[10761,8715],[10762,8715],[10763,8715],[10764,8715],
 [10765,8715],[10766,8715],[10767,8715],[10768,8715],[10769,8715],[10770,8715],
 [10771,8715],[10772,8715],[10773,8715],[10774,8715],[10775,8715],[10776,8715],
 [10777,8715],[10778,8715],[10779,8715],[10780,8715],[10781,8715],[10781,14514],
 [10782,8715],[10782,14523],[10783,8715],[10784,8715],[10785,8715],[10786,8715],
 [10786,14523],[10787,8715],[10787,14514],[10788,8715],[10788,14565],[10789,8715],
 [10789,14565],[10790,8715],[10791,8715],[10792,8715],[10793,10854],[10793,14635],
 [10794,10854],[10794,14635],[10795,10854],[10795,14635],[10855,10854],[10855,14635],
 [10856,202],[10856,268],[10856,328],[10856,8715],[10856,8962],[10856,10854],
 [10856,12747],[10857,10854],[10858,10854],[10859,10854],[10860,10854],[10861,10854],
 [10862,10854],[10863,10854],[10864,10854],[10865,10854],[10866,10854],[10867,10854],
 [10868,10854],[10869,10854],[10870,10854],[10871,10854],[10872,10854],[10873,10854],
 [10874,10854],[10875,10854],[10876,10854],[10877,10854],[10878,10854],[10879,10854],
 [10880,10854],[10881,10854],[10882,10854],[10883,10854],[10884,10854],[10885,10854],
 [10886,10854],[10887,10854],[10888,10854],[10889,10854],[10890,10854],[10891,10854],
 [10892,10854],[10893,10854],[10894,10854],[10895,10854],[10896,10854],[10897,10854],
 [10898,10854],[10899,10854],[10900,10854],[10901,10854],[10902,10854],[10903,10854],
 [10904,10854],[10904,19848],[10905,10854],[10905,19857],[10906,10854],[10906,19862],
 [10907,10854],[10908,10854],[10909,10854],[10910,10854],[10911,10854],[10911,19862],
 [10912,10854],[10912,19848],[10913,10854],[10913,19857],[10914,10854],[10914,14635],
 [10915,202],[10915,268],[10915,328],[10915,8715],[10915,8962],[10915,10854],
 [10915,12747],[10916,10854],[10917,10854],[10918,10854],[10919,10854],[10920,10854],
 [10921,10854],[10922,10854],[10923,10854],[10924,10854],[10925,10854],[10926,10854],
 [10927,10854],[10928,10854],[10929,10854],[10930,10854],[10931,10854],[10932,10854],
 [10933,10854],[10934,10854],[10935,10854],[10936,10854],[10937,10854],[10938,10854],
 [10939,10854],[10940,10854],[10941,10854],[10942,10854],[10943,10854],[10944,10854],
 [10945,10854],[10946,10854],[10947,10854],[10948,10854],[10949,10854],[10950,10854],
 [10951,10854],[10952,10854],[10953,10854],[10954,10854],[10955,10854],[10956,10854],
 [10957,10854],[10958,10854],[10959,10854],[10960,10854],[10961,10854],[10962,10854],
 [10963,10854],[10963,19848],[10964,10854],[10964,19857],[10965,10854],[10965,19862],
 [10966,10854],[10967,10854],[10968,10854],[10969,10854],[10970,10854],[10970,19862],
 [10971,10854],[10971,19848],[10972,10854],[10972,19857],[11088,8715],[11088,12979],
 [11199,26160],[11200,26160],[11202,26316],[11203,26316],[11206,26510],[11207,26510],
 [11253,26160],[11254,27643],[11255,27643],[11258,27841],[11259,27841],[11306,28970],
 [11308,28970],[11310,29168],[11312,29168],[11358,27643],[11359,28970],[11360,30394],
 [11361,30394],[11409,26316],[11410,31620],[11412,31620],[11459,32797],[11462,32797],
 [11508,30394],[11509,31620],[11510,32797],[11556,27841],[11557,29168],[11603,26510],
 [11697,38331],[11698,38331],[11703,38557],[11705,38557],[11745,39424],[11746,39424],
 [11757,39779],[11759,39779],[11781,40055],[11783,40055],[11799,40642],[11803,40642],
 [11809,40824],[11810,40824],[11813,40870],[11814,40870],[11821,40914],[11822,40914],
 [11824,40055],[11832,41239],[11833,41239],[11838,41411],[11840,41411],[11864,38331],
 [11867,41850],[11869,41850],[11875,42109],[11876,42109],[11886,42362],[11887,42362],
 [11892,42449],[11893,42449],[11897,42494],[11898,42494],[11906,42593],[11910,42593],
 [11911,42761],[11913,42761],[11917,42936],[11923,42936],[11925,43104],[11927,43104],
 [11945,43330],[11947,43330],[11950,3756],[11957,43685],[11960,43685],[11983,44030],
 [11984,44030],[11996,44394],[11997,44394],[12001,8032],[12019,41850],[12021,42593],
 [12054,39424],[12055,43330],[12062,45501],[12065,45501],[12074,45745],[12075,45745],
 [12079,45806],[12081,45806],[12086,45847],[12087,45847],[12089,44030],[12090,38557],
 [12096,46064],[12101,46064],[12104,46241],[12106,46241],[12137,8168],[12169,47266],
 [12172,47266],[12173,47331],[12175,47331],[12179,47399],[12180,47399],[12185,47433],
 [12187,47433],[12188,41239],[12189,42761],[12201,6152],[12224,48035],[12225,48035],
 [12253,48445],[12258,48445],[12262,6213],[12278,42109],[12280,48796],[12283,48796],
 [12310,49217],[12311,49217],[12335,45501],[12337,46064],[12360,41411],[12361,48796],
 [12364,42936],[12373,50046],[12377,50075],[12379,50075],[12380,50046],[12384,48035],
 [12387,4193],[12388,48445],[12409,39779],[12410,43685],[12411,40642],[12431,49217],
 [12453,44394],[12462,51006],[12468,51050],[12469,51050],[12470,51006],[12514,46241],
 [12515,47266],[12531,42362],[12532,43104],[12579,45745],[12580,47331],[12593,40824],
 [12618,42449],[12623,8715],[12623,14514],[12625,51006],[12632,8715],[12632,14523],
 [12635,50046],[12639,40870],[12640,45806],[12646,10854],[12646,19848],[12648,47399],
 [12655,10854],[12655,19857],[12660,10854],[12660,19862],[12663,42494],[12664,50075],
 [12669,51050],[12674,8715],[12674,14565],[12681,45847],[12682,47433],[12683,40914],
 [12684,12747],[12687,12747],[12733,14514],[12734,14523],[12738,14523],[12739,14514],
 [12740,14565],[12741,14565],[12745,202],[12745,268],[12745,328],[12745,8715],
 [12745,8962],[12745,10854],[12745,12747],[12746,12747],[12748,12747],[12748,12979],
 [12749,12747],[12749,12979],[12750,12747],[12751,12747],[12752,12747],[12753,12747],
 [12754,12747],[12755,12747],[12756,12747],[12757,12747],[12758,12747],[12759,12747],
 [12760,12747],[12761,12747],[12762,12747],[12763,12747],[12764,12747],[12765,12747],
 [12766,12747],[12767,12747],[12768,12747],[12769,12747],[12770,12747],[12771,12747],
 [12772,12747],[12773,12747],[12774,12747],[12775,12747],[12776,12747],[12777,12747],
 [12778,12747],[12779,12747],[12780,12747],[12781,12747],[12782,12747],[12783,12747],
 [12784,12747],[12785,12747],[12786,12747],[12787,12747],[12788,12747],[12789,12747],
 [12790,12747],[12791,12747],[12792,12747],[12793,12747],[12793,14514],[12794,12747],
 [12794,14523],[12795,12747],[12796,12747],[12797,12747],[12798,12747],[12798,14523],
 [12799,12747],[12799,14514],[12800,12747],[12800,14565],[12801,12747],[12801,14565],
 [12802,12747],[12803,12747],[12804,12747],[12806,202],[12806,268],[12806,328],
 [12806,8715],[12806,8962],[12806,10854],[12806,12747],[12864,12747],[12910,14514],
 [12911,14523],[12915,14523],[12916,14514],[12917,14565],[12918,14565],[12922,12747],
 [12922,12979],[12923,12747],[12923,12979],[12924,12747],[12925,12747],[12926,12747],
 [12927,12747],[12928,12747],[12929,12747],[12930,12747],[12931,12747],[12932,12747],
 [12933,12747],[12934,12747],[12935,12747],[12936,12747],[12937,12747],[12938,12747],
 [12939,12747],[12940,12747],[12941,12747],[12942,12747],[12943,12747],[12944,12747],
 [12945,12747],[12946,12747],[12947,12747],[12948,12747],[12949,12747],[12950,12747],
 [12951,12747],[12952,12747],[12953,12747],[12954,12747],[12955,12747],[12956,12747],
 [12957,12747],[12958,12747],[12959,12747],[12960,12747],[12961,12747],[12962,12747],
 [12963,12747],[12964,12747],[12965,12747],[12966,12747],[12967,12747],[12967,14514],
 [12968,12747],[12968,14523],[12969,12747],[12970,12747],[12971,12747],[12972,12747],
 [12972,14523],[12973,12747],[12973,14514],[12974,12747],[12974,14565],[12975,12747],
 [12975,14565],[12976,12747],[12977,12747],[12978,12747],[12980,12979],[12981,12979],
 [12982,12979],[12983,12979],[12984,12979],[12985,12979],[12986,12979],[12987,12979],
 [12988,12979],[12989,12979],[12990,12979],[12991,12979],[12992,12979],[12993,12979],
 [12994,12979],[12995,12979],[12996,12979],[12997,12979],[12998,12979],[12999,12979],
 [13000,12979],[13001,12979],[13002,12979],[13003,12979],[13004,12979],[13005,12979],
 [13006,12979],[13007,12979],[13008,12979],[13009,12979],[13010,12979],[13011,12979],
 [13012,12979],[13013,12979],[13014,12979],[13015,12979],[13016,12979],[13017,12979],
 [13018,12979],[13019,12979],[13020,12979],[13021,12979],[13022,12979],[13023,12979],
 [13023,14514],[13024,12979],[13024,14523],[13025,12979],[13026,12979],[13027,12979],
 [13028,12979],[13028,14523],[13029,12979],[13029,14514],[13030,12979],[13030,14565],
 [13031,12979],[13031,14565],[13032,12979],[13033,12979],[13034,12979],[13035,12979],
 [13036,12979],[13037,12979],[13038,12979],[13039,12979],[13040,12979],[13041,12979],
 [13042,12979],[13043,12979],[13044,12979],[13045,12979],[13046,12979],[13047,12979],
 [13048,12979],[13049,12979],[13050,12979],[13051,12979],[13052,12979],[13053,12979],
 [13054,12979],[13055,12979],[13056,12979],[13057,12979],[13058,12979],[13059,12979],
 [13060,12979],[13061,12979],[13062,12979],[13063,12979],[13064,12979],[13065,12979],
 [13066,12979],[13067,12979],[13068,12979],[13069,12979],[13070,12979],[13071,12979],
 [13072,12979],[13073,12979],[13074,12979],[13075,12979],[13076,12979],[13077,12979],
 [13078,12979],[13078,14514],[13079,12979],[13079,14523],[13080,12979],[13081,12979],
 [13082,12979],[13083,12979],[13083,14523],[13084,12979],[13084,14514],[13085,12979],
 [13085,14565],[13086,12979],[13086,14565],[13087,12979],[13088,12979],[13089,12979],
 [13090,26160],[13091,26160],[13093,26316],[13094,26316],[13097,26510],[13098,26510],
 [13132,14514],[13133,14523],[13137,14523],[13138,14514],[13139,14565],[13140,14565],
 [13144,26160],[13145,27643],[13146,27643],[13149,27841],[13150,27841],[13185,14514],
 [13186,14523],[13190,14523],[13191,14514],[13192,14565],[13193,14565],[13197,28970],
 [13199,28970],[13201,29168],[13203,29168],[13237,14514],[13238,14523],[13242,14523],
 [13243,14514],[13244,14565],[13245,14565],[13249,27643],[13250,28970],[13251,30394],
 [13252,30394],[13288,14514],[13289,14523],[13293,14523],[13294,14514],[13295,14565],
 [13296,14565],[13300,26316],[13301,31620],[13303,31620],[13338,14514],[13339,14523],
 [13343,14523],[13344,14514],[13345,14565],[13346,14565],[13350,32797],[13353,32797],
 [13387,14514],[13388,14523],[13392,14523],[13393,14514],[13394,14565],[13395,14565],
 [13399,30394],[13400,31620],[13401,32797],[13435,14514],[13436,14523],[13440,14523],
 [13441,14514],[13442,14565],[13443,14565],[13447,27841],[13448,29168],[13482,14514],
 [13483,14523],[13487,14523],[13488,14514],[13489,14565],[13490,14565],[13494,26510],
 [13528,14514],[13529,14523],[13533,14523],[13534,14514],[13535,14565],[13536,14565],
 [13573,14514],[13574,14523],[13578,14523],[13579,14514],[13580,14565],[13581,14565],
 [13588,38331],[13589,38331],[13594,38557],[13596,38557],[13617,14514],[13618,14523],
 [13622,14523],[13623,14514],[13624,14565],[13625,14565],[13636,39424],[13637,39424],
 [13648,39779],[13650,39779],[13660,14514],[13661,14523],[13665,14523],[13666,14514],
 [13667,14565],[13668,14565],[13672,40055],[13674,40055],[13690,40642],[13694,40642],
 [13700,40824],[13701,40824],[13702,14514],[13703,14523],[13704,40870],[13705,40870],
 [13707,14523],[13708,14514],[13709,14565],[13710,14565],[13712,40914],[13713,40914],
 [13715,40055],[13723,41239],[13724,41239],[13729,41411],[13731,41411],[13743,14514],
 [13744,14523],[13748,14523],[13749,14514],[13750,14565],[13751,14565],[13755,38331],
 [13758,41850],[13760,41850],[13766,42109],[13767,42109],[13777,42362],[13778,42362],
 [13783,14514],[13783,14523],[13783,42449],[13783,42494],[13784,14514],[13784,14523],
 [13784,42449],[13784,42494],[13788,14514],[13788,14523],[13788,42449],[13788,42494],
 [13789,14514],[13789,14523],[13789,42449],[13789,42494],[13790,14565],[13791,14565],
 [13797,42593],[13801,42593],[13802,42761],[13804,42761],[13808,42936],[13814,42936],
 [13816,43104],[13818,43104],[13822,14514],[13823,14523],[13827,14523],[13828,14514],
 [13829,14565],[13830,14565],[13836,43330],[13838,43330],[13841,3756],[13848,43685],
 [13851,43685],[13860,14514],[13861,14523],[13865,14523],[13866,14514],[13867,14565],
 [13868,14565],[13874,44030],[13875,44030],[13881,13796],[13881,13806],[13887,44394],
 [13888,44394],[13892,8032],[13897,14514],[13898,14523],[13902,14523],[13903,14514],
 [13904,14565],[13905,14565],[13910,41850],[13912,42593],[13933,14514],[13934,14523],
 [13938,14523],[13939,14514],[13940,14565],[13941,14565],[13945,39424],[13946,43330],
 [13953,45501],[13956,45501],[13965,45745],[13966,45745],[13968,14514],[13969,14523],
 [13970,45806],[13972,45806],[13973,14523],[13974,14514],[13975,14565],[13976,14565],
 [13977,45847],[13978,45847],[13980,44030],[13981,38557],[13987,46064],[13992,46064],
 [13995,46241],[13997,46241],[14002,14514],[14003,14523],[14007,14523],[14008,14514],
 [14009,14565],[14010,14565],[14028,8168],[14035,14514],[14036,14523],[14040,14523],
 [14041,14514],[14042,14565],[14043,14565],[14060,47266],[14063,47266],[14064,47331],
 [14066,47331],[14067,14514],[14068,14523],[14070,47399],[14071,47399],[14072,14523],
 [14073,14514],[14074,14565],[14075,14565],[14076,47433],[14078,47433],[14079,41239],
 [14080,42761],[14081,13982],[14081,13985],[14092,6152],[14098,14514],[14099,14523],
 [14103,14523],[14104,14514],[14105,14565],[14106,14565],[14115,48035],[14116,48035],
 [14128,14514],[14129,14523],[14133,14523],[14134,14514],[14135,14565],[14136,14565],
 [14144,48445],[14149,48445],[14153,6213],[14157,14514],[14158,14523],[14162,14523],
 [14163,14514],[14164,14565],[14165,14565],[14169,42109],[14171,48796],[14174,48796],
 [14179,14173],[14179,14304],[14185,14514],[14186,14523],[14190,14523],[14191,14514],
 [14192,14565],[14193,14565],[14201,49217],[14202,49217],[14207,14200],[14207,14305],
 [14212,14514],[14213,14523],[14217,14523],[14218,14514],[14219,14565],[14220,14565],
 [14226,45501],[14228,46064],[14238,14514],[14239,14523],[14243,14523],[14244,14514],
 [14245,14565],[14246,14565],[14251,41411],[14252,48796],[14255,42936],[14263,14514],
 [14264,14523],[14264,14565],[14264,50046],[14264,50075],[14268,14523],[14268,14565],
 [14268,50046],[14268,50075],[14269,14514],[14270,14523],[14270,14565],[14270,50046],
 [14270,50075],[14271,14523],[14271,14565],[14271,50046],[14271,50075],[14275,48035],
 [14276,13989],[14276,13991],[14278,4193],[14279,48445],[14287,14514],[14288,14523],
 [14292,14523],[14293,14514],[14294,14565],[14295,14565],[14300,39779],[14301,43685],
 [14302,40642],[14310,14514],[14311,14523],[14315,14523],[14316,14514],[14317,14565],
 [14318,14565],[14322,49217],[14323,13811],[14323,13813],[14332,14514],[14333,14523],
 [14337,14523],[14338,14514],[14339,14565],[14340,14565],[14344,44394],[14353,14514],
 [14353,14565],[14353,51006],[14353,51050],[14354,14523],[14358,14523],[14359,14514],
 [14359,14565],[14359,51006],[14359,51050],[14360,14514],[14360,14565],[14360,51006],
 [14360,51050],[14361,14514],[14361,14565],[14361,51006],[14361,51050],[14373,14514],
 [14374,14523],[14378,14523],[14379,14514],[14380,14565],[14381,14565],[14392,14514],
 [14393,14523],[14397,14523],[14398,14514],[14399,14565],[14400,14565],[14405,46241],
 [14406,47266],[14410,14514],[14411,14523],[14415,14523],[14416,14514],[14417,14565],
 [14418,14565],[14422,42362],[14423,43104],[14427,14514],[14428,14523],[14432,14523],
 [14433,14514],[14434,14565],[14435,14565],[14443,14514],[14444,14523],[14448,14523],
 [14449,14514],[14450,14565],[14451,14565],[14458,14514],[14459,14523],[14463,14523],
 [14464,14514],[14465,14565],[14466,14565],[14470,45745],[14471,47331],[14472,14514],
 [14473,14523],[14477,14523],[14478,14514],[14479,14565],[14480,14565],[14484,40824],
 [14485,14514],[14486,14523],[14490,14523],[14491,14514],[14492,14565],[14493,14565],
 [14497,14514],[14498,14523],[14502,14523],[14503,14514],[14504,14565],[14505,14565],
 [14509,14514],[14509,14523],[14509,42449],[14509,42494],[14510,14514],[14512,14514],
 [14513,14514],[14513,14523],[14513,42449],[14513,42494],[14515,14514],[14515,14565],
 [14515,51006],[14515,51050],[14516,14514],[14516,14565],[14516,51006],[14516,51050],
 [14517,14514],[14518,14514],[14521,14523],[14522,14523],[14524,14514],[14524,14523],
 [14524,42449],[14524,42494],[14525,14523],[14525,14565],[14525,50046],[14525,50075],
 [14526,14523],[14526,14565],[14526,50046],[14526,50075],[14527,14523],[14529,14523],
 [14530,40870],[14531,45806],[14533,14514],[14534,14565],[14535,14565],[14539,47399],
 [14540,14523],[14542,14565],[14543,14565],[14547,14523],[14548,14514],[14554,14514],
 [14554,14523],[14554,42449],[14554,42494],[14555,14523],[14555,14565],[14555,50046],
 [14555,50075],[14556,14523],[14556,14565],[14556,50046],[14556,50075],[14557,14523],
 [14559,14523],[14560,14514],[14560,14565],[14560,51006],[14560,51050],[14561,14514],
 [14561,14565],[14561,51006],[14561,51050],[14562,14514],[14563,14514],[14567,14565],
 [14568,14565],[14570,14565],[14571,14565],[14572,45847],[14573,47433],[14574,40914],
 [14575,10854],[14575,14635],[14576,10854],[14576,14635],[14577,12747],[14636,8962],
 [14636,14635],[14639,14635],[14640,14635],[14641,14635],[14642,14635],[14643,14635],
 [14644,14635],[14645,14635],[14646,14635],[14647,14635],[14648,14635],[14649,14635],
 [14650,14635],[14651,14635],[14652,14635],[14653,14635],[14654,14635],[14655,14635],
 [14656,14635],[14657,14635],[14658,14635],[14659,14635],[14660,14635],[14661,14635],
 [14662,14635],[14663,14635],[14664,14635],[14665,14635],[14666,14635],[14667,14635],
 [14668,14635],[14669,14635],[14670,14635],[14671,14635],[14672,14635],[14673,14635],
 [14674,14635],[14675,14635],[14676,14635],[14677,14635],[14678,14635],[14679,14635],
 [14680,14635],[14681,14635],[14682,14635],[14683,14635],[14684,14635],[14684,19848],
 [14685,14635],[14685,19857],[14686,14635],[14686,19862],[14687,14635],[14688,14635],
 [14689,14635],[14690,14635],[14691,14635],[14691,19862],[14692,14635],[14692,19848],
 [14693,14635],[14693,19857],[14694,8962],[14694,14635],[14697,14635],[14698,14635],
 [14699,14635],[14700,14635],[14701,14635],[14702,14635],[14703,14635],[14704,14635],
 [14705,14635],[14706,14635],[14707,14635],[14708,14635],[14709,14635],[14710,14635],
 [14711,14635],[14712,14635],[14713,14635],[14714,14635],[14715,14635],[14716,14635],
 [14717,14635],[14718,14635],[14719,14635],[14720,14635],[14721,14635],[14722,14635],
 [14723,14635],[14724,14635],[14725,14635],[14726,14635],[14727,14635],[14728,14635],
 [14729,14635],[14730,14635],[14731,14635],[14732,14635],[14733,14635],[14734,14635],
 [14735,14635],[14736,14635],[14737,14635],[14738,14635],[14739,14635],[14740,14635],
 [14741,14635],[14742,14635],[14742,19848],[14743,14635],[14743,19857],[14744,14635],
 [14744,19862],[14745,14635],[14746,14635],[14747,14635],[14748,14635],[14749,14635],
 [14749,19862],[14750,14635],[14750,19848],[14751,14635],[14751,19857],[14920,26160],
 [14921,26160],[14923,26316],[14924,26316],[14927,26510],[14928,26510],[14974,26160],
 [14975,27643],[14976,27643],[14979,27841],[14980,27841],[15027,28970],[15029,28970],
 [15031,29168],[15033,29168],[15079,27643],[15080,28970],[15081,30394],[15082,30394],
 [15130,26316],[15131,31620],[15133,31620],[15180,32797],[15183,32797],[15229,30394],
 [15230,31620],[15231,32797],[15277,27841],[15278,29168],[15324,26510],[15418,38331],
 [15419,38331],[15424,38557],[15426,38557],[15466,39424],[15467,39424],[15478,39779],
 [15480,39779],[15502,40055],[15504,40055],[15520,40642],[15524,40642],[15530,40824],
 [15531,40824],[15534,40870],[15535,40870],[15542,40914],[15543,40914],[15545,40055],
 [15553,41239],[15554,41239],[15559,41411],[15561,41411],[15585,38331],[15588,41850],
 [15590,41850],[15596,42109],[15597,42109],[15599,7828],[15599,42193],[15603,7828],
 [15603,42193],[15607,42362],[15608,42362],[15613,42449],[15614,42449],[15618,42494],
 [15619,42494],[15627,42593],[15631,42593],[15632,42761],[15634,42761],[15638,42936],
 [15644,42936],[15646,43104],[15648,43104],[15666,43330],[15668,43330],[15671,3756],
 [15678,43685],[15681,43685],[15704,44030],[15705,44030],[15717,44394],[15718,44394],
 [15722,8032],[15740,41850],[15742,42593],[15775,39424],[15776,43330],[15783,45501],
 [15786,45501],[15795,45745],[15796,45745],[15800,45806],[15802,45806],[15807,45847],
 [15808,45847],[15810,44030],[15811,38557],[15817,46064],[15822,46064],[15825,46241],
 [15827,46241],[15858,8168],[15890,47266],[15893,47266],[15894,47331],[15896,47331],
 [15900,47399],[15901,47399],[15906,47433],[15908,47433],[15909,41239],[15910,42761],
 [15922,6152],[15945,48035],[15946,48035],[15974,48445],[15979,48445],[15983,6213],
 [15999,42109],[16001,48796],[16004,48796],[16019,16377],[16019,49091],[16020,16377],
 [16020,49091],[16031,49217],[16032,49217],[16042,16341],[16042,49406],[16045,16341],
 [16045,49406],[16056,45501],[16058,46064],[16081,41411],[16082,48796],[16083,7828],
 [16083,42193],[16085,42936],[16094,50046],[16098,50075],[16100,50075],[16101,50046],
 [16105,48035],[16108,4193],[16109,48445],[16130,39779],[16131,43685],[16132,40642],
 [16152,49217],[16164,16365],[16164,50815],[16170,16365],[16170,50815],[16174,44394],
 [16183,51006],[16189,51050],[16190,51050],[16191,51006],[16235,46241],[16236,47266],
 [16252,42362],[16253,43104],[16300,45745],[16301,47331],[16314,40824],[16339,42449],
 [16344,14514],[16346,51006],[16353,14523],[16356,50046],[16360,40870],[16361,45806],
 [16367,14635],[16367,19848],[16369,47399],[16376,14635],[16376,19857],[16381,14635],
 [16381,19862],[16384,42494],[16385,50075],[16390,51050],[16395,14565],[16402,45847],
 [16403,47433],[16404,40914],[16405,10854],[16405,14635],[16406,202],[16406,268],
 [16406,328],[16406,8715],[16406,8962],[16406,10854],[16406,12747],[16407,10854],
 [16408,10854],[16409,10854],[16410,10854],[16411,10854],[16412,10854],[16413,10854],
 [16414,10854],[16415,10854],[16416,10854],[16417,10854],[16418,10854],[16419,10854],
 [16420,10854],[16421,10854],[16422,10854],[16423,10854],[16424,10854],[16425,10854],
 [16426,10854],[16427,10854],[16428,10854],[16429,10854],[16430,10854],[16431,10854],
 [16432,10854],[16433,10854],[16434,10854],[16435,10854],[16436,10854],[16437,10854],
 [16438,10854],[16439,10854],[16440,10854],[16441,10854],[16442,10854],[16443,10854],
 [16444,10854],[16445,10854],[16446,10854],[16447,10854],[16448,10854],[16449,10854],
 [16450,10854],[16451,10854],[16452,10854],[16453,10854],[16454,10854],[16454,19848],
 [16455,10854],[16455,19857],[16456,10854],[16456,19862],[16457,10854],[16458,10854],
 [16459,10854],[16460,10854],[16461,10854],[16461,19862],[16462,10854],[16462,19848],
 [16463,10854],[16463,19857],[16464,12747],[16522,12747],[16522,12979],[16523,12747],
 [16523,12979],[16524,12747],[16525,12747],[16526,12747],[16527,12747],[16528,12747],
 [16529,12747],[16530,12747],[16531,12747],[16532,12747],[16533,12747],[16534,12747],
 [16535,12747],[16536,12747],[16537,12747],[16538,12747],[16539,12747],[16540,12747],
 [16541,12747],[16542,12747],[16543,12747],[16544,12747],[16545,12747],[16546,12747],
 [16547,12747],[16548,12747],[16549,12747],[16550,12747],[16551,12747],[16552,12747],
 [16553,12747],[16554,12747],[16555,12747],[16556,12747],[16557,12747],[16558,12747],
 [16559,12747],[16560,12747],[16561,12747],[16562,12747],[16563,12747],[16564,12747],
 [16565,12747],[16566,12747],[16567,12747],[16567,14514],[16568,12747],[16568,14523],
 [16569,12747],[16570,12747],[16571,12747],[16572,12747],[16572,14523],[16573,12747],
 [16573,14514],[16574,12747],[16574,14565],[16575,12747],[16575,14565],[16576,12747],
 [16577,12747],[16578,12747],[16579,12747],[16579,12979],[16690,26160],[16691,26160],
 [16693,26316],[16694,26316],[16697,26510],[16698,26510],[16744,26160],[16745,27643],
 [16746,27643],[16749,27841],[16750,27841],[16797,28970],[16799,28970],[16801,29168],
 [16803,29168],[16849,27643],[16850,28970],[16851,30394],[16852,30394],[16900,26316],
 [16901,31620],[16903,31620],[16950,32797],[16953,32797],[16999,30394],[17000,31620],
 [17001,32797],[17047,27841],[17048,29168],[17094,26510],[17188,38331],[17189,38331],
 [17194,38557],[17196,38557],[17236,39424],[17237,39424],[17248,39779],[17250,39779],
 [17272,40055],[17274,40055],[17290,40642],[17294,40642],[17300,40824],[17301,40824],
 [17304,40870],[17305,40870],[17312,40914],[17313,40914],[17315,40055],[17323,41239],
 [17324,41239],[17329,41411],[17331,41411],[17355,38331],[17358,41850],[17360,41850],
 [17366,42109],[17367,42109],[17377,42362],[17378,42362],[17383,42449],[17384,42449],
 [17388,42494],[17389,42494],[17397,42593],[17401,42593],[17402,42761],[17404,42761],
 [17408,42936],[17414,42936],[17416,43104],[17418,43104],[17436,43330],[17438,43330],
 [17441,3756],[17448,43685],[17451,43685],[17474,44030],[17475,44030],[17487,44394],
 [17488,44394],[17492,8032],[17510,41850],[17512,42593],[17545,39424],[17546,43330],
 [17553,45501],[17556,45501],[17565,45745],[17566,45745],[17570,45806],[17572,45806],
 [17577,45847],[17578,45847],[17580,44030],[17581,38557],[17587,46064],[17592,46064],
 [17595,46241],[17597,46241],[17628,8168],[17660,47266],[17663,47266],[17664,47331],
 [17666,47331],[17670,47399],[17671,47399],[17676,47433],[17678,47433],[17679,41239],
 [17680,42761],[17692,6152],[17715,48035],[17716,48035],[17744,48445],[17749,48445],
 [17753,6213],[17769,42109],[17771,48796],[17774,48796],[17801,49217],[17802,49217],
 [17826,45501],[17828,46064],[17851,41411],[17852,48796],[17855,42936],[17864,50046],
 [17868,50075],[17870,50075],[17871,50046],[17875,48035],[17878,4193],[17879,48445],
 [17900,39779],[17901,43685],[17902,40642],[17922,49217],[17944,44394],[17953,51006],
 [17959,51050],[17960,51050],[17961,51006],[18005,46241],[18006,47266],[18022,42362],
 [18023,43104],[18070,45745],[18071,47331],[18084,40824],[18109,42449],[18114,12747],
 [18114,14514],[18116,51006],[18123,12747],[18123,14523],[18126,50046],[18130,40870],
 [18131,45806],[18137,10854],[18137,19848],[18139,47399],[18146,10854],[18146,19857],
 [18151,10854],[18151,19862],[18154,42494],[18155,50075],[18160,51050],[18165,12747],
 [18165,14565],[18172,45847],[18173,47433],[18174,40914],[18175,8962],[18175,14635],
 [18178,14635],[18179,14635],[18180,14635],[18181,14635],[18182,14635],[18183,14635],
 [18184,14635],[18185,14635],[18186,14635],[18187,14635],[18188,14635],[18189,14635],
 [18190,14635],[18191,14635],[18192,14635],[18193,14635],[18194,14635],[18195,14635],
 [18196,14635],[18197,14635],[18198,14635],[18199,14635],[18200,14635],[18201,14635],
 [18202,14635],[18203,14635],[18204,14635],[18205,14635],[18206,14635],[18207,14635],
 [18208,14635],[18209,14635],[18210,14635],[18211,14635],[18212,14635],[18213,14635],
 [18214,14635],[18215,14635],[18216,14635],[18217,14635],[18218,14635],[18219,14635],
 [18220,14635],[18221,14635],[18222,14635],[18223,14635],[18223,19848],[18224,14635],
 [18224,19857],[18225,14635],[18225,19862],[18226,14635],[18227,14635],[18228,14635],
 [18229,14635],[18230,14635],[18230,19862],[18231,14635],[18231,19848],[18232,14635],
 [18232,19857],[18233,8962],[18234,8962],[18235,8962],[18236,8962],[18237,8962],
 [18238,8962],[18239,8962],[18240,8962],[18241,8962],[18242,8962],[18243,8962],
 [18244,8962],[18245,8962],[18246,8962],[18247,8962],[18248,8962],[18249,8962],
 [18250,8962],[18251,8962],[18252,8962],[18253,8962],[18254,8962],[18255,8962],
 [18256,8962],[18257,8962],[18258,8962],[18259,8962],[18260,8962],[18261,8962],
 [18262,8962],[18263,8962],[18264,8962],[18265,8962],[18266,8962],[18267,8962],
 [18268,8962],[18269,8962],[18270,8962],[18271,8962],[18272,8962],[18273,8962],
 [18274,8962],[18275,8962],[18276,8962],[18277,8962],[18278,8962],[18279,8962],
 [18280,8962],[18280,19848],[18281,8962],[18281,19857],[18282,8962],[18282,19862],
 [18283,8962],[18284,8962],[18285,8962],[18286,8962],[18287,8962],[18287,19862],
 [18288,8962],[18288,19848],[18289,8962],[18289,19857],[18336,19848],[18337,19857],
 [18338,19862],[18343,19862],[18344,19848],[18345,19857],[18391,19848],[18392,19857],
 [18393,19862],[18398,19862],[18399,19848],[18400,19857],[18401,26160],[18402,26160],
 [18404,26316],[18405,26316],[18408,26510],[18409,26510],[18445,19848],[18446,19857],
 [18447,19862],[18452,19862],[18453,19848],[18454,19857],[18455,26160],[18456,27643],
 [18457,27643],[18460,27841],[18461,27841],[18498,19848],[18499,19857],[18500,19862],
 [18505,19862],[18506,19848],[18507,19857],[18508,28970],[18510,28970],[18512,29168],
 [18514,29168],[18550,19848],[18551,19857],[18552,19862],[18557,19862],[18558,19848],
 [18559,19857],[18560,27643],[18561,28970],[18562,30394],[18563,30394],[18601,19848],
 [18602,19857],[18603,19862],[18608,19862],[18609,19848],[18610,19857],[18611,26316],
 [18612,31620],[18614,31620],[18651,19848],[18652,19857],[18653,19862],[18658,19862],
 [18659,19848],[18660,19857],[18661,32797],[18664,32797],[18700,19848],[18701,19857],
 [18702,19862],[18707,19862],[18708,19848],[18709,19857],[18710,30394],[18711,31620],
 [18712,32797],[18748,19848],[18749,19857],[18750,19862],[18755,19862],[18756,19848],
 [18757,19857],[18758,27841],[18759,29168],[18795,19848],[18796,19857],[18797,19862],
 [18802,19862],[18803,19848],[18804,19857],[18805,26510],[18841,19848],[18842,19857],
 [18843,19862],[18848,19862],[18849,19848],[18850,19857],[18886,19848],[18887,19857],
 [18888,19862],[18893,19862],[18894,19848],[18895,19857],[18899,38331],[18900,38331],
 [18905,38557],[18907,38557],[18930,19848],[18931,19857],[18932,19862],[18937,19862],
 [18938,19848],[18939,19857],[18947,39424],[18948,39424],[18959,39779],[18961,39779],
 [18973,19848],[18974,19857],[18975,19862],[18980,19862],[18981,19848],[18982,19857],
 [18983,40055],[18985,40055],[19001,40642],[19005,40642],[19011,40824],[19012,40824],
 [19015,19848],[19015,19857],[19015,40870],[19015,40914],[19016,19848],[19016,19857],
 [19016,40870],[19016,40914],[19017,19862],[19022,19862],[19023,19848],[19023,19857],
 [19023,40870],[19023,40914],[19024,19848],[19024,19857],[19024,40870],[19024,40914],
 [19026,40055],[19034,41239],[19035,41239],[19040,41411],[19042,41411],[19056,19848],
 [19057,19857],[19058,19862],[19063,19862],[19064,19848],[19065,19857],[19066,38331],
 [19069,41850],[19071,41850],[19077,42109],[19078,42109],[19088,42362],[19089,42362],
 [19094,42449],[19095,42449],[19096,19848],[19097,19857],[19098,19862],[19099,42494],
 [19100,42494],[19103,19862],[19104,19848],[19105,19857],[19108,42593],[19112,42593],
 [19113,42761],[19115,42761],[19119,42936],[19125,42936],[19127,43104],[19129,43104],
 [19135,19848],[19136,19857],[19137,19862],[19142,19862],[19143,19848],[19144,19857],
 [19147,43330],[19149,43330],[19152,3756],[19159,43685],[19162,43685],[19169,19106],
 [19169,19131],[19173,19848],[19174,19857],[19175,19862],[19180,19862],[19181,19848],
 [19182,19857],[19185,44030],[19186,44030],[19198,44394],[19199,44394],[19203,8032],
 [19210,19848],[19211,19857],[19212,19862],[19217,19862],[19218,19848],[19219,19857],
 [19221,41850],[19223,42593],[19246,19848],[19247,19857],[19248,19862],[19253,19862],
 [19254,19848],[19255,19857],[19256,39424],[19257,43330],[19264,45501],[19267,45501],
 [19276,45745],[19277,45745],[19281,19848],[19281,19862],[19281,45806],[19281,45847],
 [19282,19857],[19283,19848],[19283,19862],[19283,45806],[19283,45847],[19288,19848],
 [19288,19862],[19288,45806],[19288,45847],[19289,19848],[19289,19862],[19289,45806],
 [19289,45847],[19290,19857],[19291,44030],[19292,38557],[19298,46064],[19303,46064],
 [19306,46241],[19308,46241],[19315,19848],[19316,19857],[19317,19862],[19322,19862],
 [19323,19848],[19324,19857],[19339,8168],[19343,19111],[19343,19130],[19348,19848],
 [19349,19857],[19350,19862],[19355,19862],[19356,19848],[19357,19857],[19371,47266],
 [19374,47266],[19375,47331],[19377,47331],[19380,19848],[19381,19857],[19381,19862],
 [19381,47399],[19381,47433],[19382,19857],[19382,19862],[19382,47399],[19382,47433],
 [19387,19857],[19387,19862],[19387,47399],[19387,47433],[19388,19848],[19389,19857],
 [19389,19862],[19389,47399],[19389,47433],[19390,41239],[19391,42761],[19403,6152],
 [19411,19848],[19412,19857],[19413,19862],[19418,19862],[19419,19848],[19420,19857],
 [19426,48035],[19427,48035],[19437,19294],[19437,19311],[19441,19848],[19442,19857],
 [19443,19862],[19448,19862],[19449,19848],[19450,19857],[19455,48445],[19460,48445],
 [19464,6213],[19467,19295],[19467,19312],[19470,19848],[19471,19857],[19472,19862],
 [19477,19862],[19478,19848],[19479,19857],[19480,42109],[19482,48796],[19485,48796],
 [19498,19848],[19499,19857],[19500,19862],[19505,19862],[19506,19848],[19507,19857],
 [19512,49217],[19513,49217],[19525,19848],[19526,19857],[19527,19862],[19532,19862],
 [19533,19848],[19534,19857],[19537,45501],[19539,46064],[19551,19848],[19552,19857],
 [19553,19862],[19558,19862],[19559,19848],[19560,19857],[19562,41411],[19563,48796],
 [19566,42936],[19575,50046],[19576,19848],[19577,19857],[19578,19862],[19579,50075],
 [19581,50075],[19582,50046],[19583,19862],[19584,19848],[19585,19857],[19586,48035],
 [19589,4193],[19590,48445],[19600,19848],[19601,19857],[19602,19862],[19607,19862],
 [19608,19848],[19609,19857],[19611,39779],[19612,43685],[19613,40642],[19623,19848],
 [19624,19857],[19625,19862],[19630,19862],[19631,19848],[19632,19857],[19633,49217],
 [19645,19848],[19646,19857],[19647,19862],[19652,19862],[19653,19848],[19654,19857],
 [19655,44394],[19664,51006],[19666,19848],[19667,19857],[19668,19862],[19670,51050],
 [19671,51050],[19672,51006],[19673,19862],[19674,19848],[19675,19857],[19686,19848],
 [19687,19857],[19688,19862],[19693,19862],[19694,19848],[19695,19857],[19705,19848],
 [19706,19857],[19707,19862],[19712,19862],[19713,19848],[19714,19857],[19716,46241],
 [19717,47266],[19718,19614],[19718,19618],[19723,19848],[19724,19857],[19725,19862],
 [19730,19862],[19731,19848],[19732,19857],[19733,42362],[19734,43104],[19740,19848],
 [19741,19857],[19742,19862],[19747,19862],[19748,19848],[19749,19857],[19756,19848],
 [19757,19857],[19758,19862],[19763,19862],[19764,19848],[19765,19857],[19768,19617],
 [19768,19620],[19771,19848],[19772,19857],[19773,19862],[19778,19862],[19779,19848],
 [19780,19857],[19781,45745],[19782,47331],[19785,19848],[19786,19857],[19787,19862],
 [19792,19862],[19793,19848],[19794,19857],[19795,40824],[19798,19848],[19799,19857],
 [19800,19862],[19805,19862],[19806,19848],[19807,19857],[19810,19848],[19811,19857],
 [19812,19862],[19817,19862],[19818,19848],[19819,19857],[19820,42449],[19821,19848],
 [19823,19862],[19827,51006],[19828,19862],[19829,19848],[19832,19857],[19833,19862],
 [19837,50046],[19838,19862],[19840,19857],[19841,19848],[19841,19857],[19841,40870],
 [19841,40914],[19842,19848],[19842,19862],[19842,45806],[19842,45847],[19844,19848],
 [19845,19848],[19846,19848],[19847,19848],[19847,19862],[19847,45806],[19847,45847],
 [19849,19848],[19849,19857],[19849,40870],[19849,40914],[19850,19857],[19850,19862],
 [19850,47399],[19850,47433],[19851,19857],[19853,19857],[19854,19857],[19855,19857],
 [19855,19862],[19855,47399],[19855,47433],[19856,19848],[19856,19857],[19856,40870],
 [19856,40914],[19858,19862],[19859,19862],[19863,19848],[19863,19862],[19863,45806],
 [19863,45847],[19864,19857],[19864,19862],[19864,47399],[19864,47433],[19865,42494],
 [19866,50075],[19868,19862],[19870,19857],[19871,51050],[19873,19862],[19874,19848],
 [19878,19848],[19879,19857],[19881,19848],[19882,19857],[19883,19848],[19883,19862],
 [19883,45806],[19883,45847],[19884,19857],[19884,19862],[19884,47399],[19884,47433],
 [19885,19848],[19885,19857],[19885,40870],[19885,40914],[20054,26160],[20055,26160],
 [20057,26316],[20058,26316],[20061,26510],[20062,26510],[20108,26160],[20109,27643],
 [20110,27643],[20113,27841],[20114,27841],[20161,28970],[20163,28970],[20165,29168],
 [20167,29168],[20213,27643],[20214,28970],[20215,30394],[20216,30394],[20264,26316],
 [20265,31620],[20267,31620],[20314,32797],[20317,32797],[20363,30394],[20364,31620],
 [20365,32797],[20411,27841],[20412,29168],[20458,26510],[20552,38331],[20553,38331],
 [20558,38557],[20560,38557],[20600,39424],[20601,39424],[20612,39779],[20614,39779],
 [20636,40055],[20638,40055],[20654,40642],[20658,40642],[20664,40824],[20665,40824],
 [20668,40870],[20669,40870],[20676,40914],[20677,40914],[20679,40055],[20687,41239],
 [20688,41239],[20693,41411],[20695,41411],[20719,38331],[20722,41850],[20724,41850],
 [20730,42109],[20731,42109],[20741,42362],[20742,42362],[20747,42449],[20748,42449],
 [20752,42494],[20753,42494],[20761,42593],[20765,42593],[20766,42761],[20768,42761],
 [20772,42936],[20778,42936],[20780,43104],[20782,43104],[20800,43330],[20802,43330],
 [20805,3756],[20812,43685],[20815,43685],[20838,44030],[20839,44030],[20851,44394],
 [20852,44394],[20856,8032],[20874,41850],[20876,42593],[20909,39424],[20910,43330],
 [20917,45501],[20920,45501],[20929,45745],[20930,45745],[20934,45806],[20936,45806],
 [20941,45847],[20942,45847],[20944,44030],[20945,38557],[20951,46064],[20956,46064],
 [20959,46241],[20961,46241],[20992,8168],[21024,47266],[21027,47266],[21028,47331],
 [21030,47331],[21034,47399],[21035,47399],[21040,47433],[21042,47433],[21043,41239],
 [21044,42761],[21056,6152],[21079,48035],[21080,48035],[21108,48445],[21113,48445],
 [21117,6213],[21133,42109],[21135,48796],[21138,48796],[21150,21493],[21150,49073],
 [21160,21493],[21160,49073],[21165,49217],[21166,49217],[21182,21527],[21182,49458],
 [21186,21527],[21186,49458],[21190,45501],[21192,46064],[21215,41411],[21216,48796],
 [21219,42936],[21228,50046],[21232,50075],[21234,50075],[21235,50046],[21239,48035],
 [21242,4193],[21243,48445],[21264,39779],[21265,43685],[21266,40642],[21286,49217],
 [21303,21530],[21303,50846],[21305,21530],[21305,50846],[21308,44394],[21317,51006],
 [21323,51050],[21324,51050],[21325,51006],[21369,46241],[21370,47266],[21386,42362],
 [21387,43104],[21434,45745],[21435,47331],[21448,40824],[21473,42449],[21478,14514],
 [21480,51006],[21487,14523],[21490,50046],[21494,40870],[21495,45806],[21501,14635],
 [21501,19848],[21503,47399],[21510,14635],[21510,19857],[21515,14635],[21515,19862],
 [21518,42494],[21519,50075],[21524,51050],[21529,14565],[21536,45847],[21537,47433],
 [21538,40914],[21539,12747],[21539,12979],[21650,26160],[21651,26160],[21653,26316],
 [21654,26316],[21657,26510],[21658,26510],[21704,26160],[21705,27643],[21706,27643],
 [21709,27841],[21710,27841],[21757,28970],[21759,28970],[21761,29168],[21763,29168],
 [21809,27643],[21810,28970],[21811,30394],[21812,30394],[21860,26316],[21861,31620],
 [21863,31620],[21910,32797],[21913,32797],[21959,30394],[21960,31620],[21961,32797],
 [22007,27841],[22008,29168],[22054,26510],[22148,38331],[22149,38331],[22154,38557],
 [22156,38557],[22196,39424],[22197,39424],[22208,39779],[22210,39779],[22232,40055],
 [22234,40055],[22250,40642],[22254,40642],[22260,40824],[22261,40824],[22264,40870],
 [22265,40870],[22272,40914],[22273,40914],[22275,40055],[22283,41239],[22284,41239],
 [22289,41411],[22291,41411],[22295,7875],[22315,38331],[22318,41850],[22320,41850],
 [22326,42109],[22327,42109],[22337,42362],[22338,42362],[22343,42449],[22344,42449],
 [22348,42494],[22349,42494],[22357,42593],[22361,42593],[22362,42761],[22364,42761],
 [22368,42936],[22374,42936],[22376,43104],[22378,43104],[22396,43330],[22398,43330],
 [22401,3756],[22408,43685],[22411,43685],[22434,44030],[22435,44030],[22447,44394],
 [22448,44394],[22452,8032],[22470,41850],[22472,42593],[22505,39424],[22506,43330],
 [22513,45501],[22516,45501],[22525,45745],[22526,45745],[22530,45806],[22532,45806],
 [22537,45847],[22538,45847],[22540,44030],[22541,38557],[22547,46064],[22552,46064],
 [22555,46241],[22557,46241],[22588,8168],[22620,47266],[22623,47266],[22624,47331],
 [22626,47331],[22630,47399],[22631,47399],[22636,47433],[22638,47433],[22639,41239],
 [22640,42761],[22652,6152],[22675,48035],[22676,48035],[22704,48445],[22709,48445],
 [22713,6213],[22729,42109],[22731,48796],[22734,48796],[22761,49217],[22762,49217],
 [22786,45501],[22788,46064],[22811,41411],[22812,48796],[22815,42936],[22824,50046],
 [22828,50075],[22830,50075],[22831,50046],[22835,48035],[22838,4193],[22839,48445],
 [22860,39779],[22861,43685],[22862,40642],[22882,49217],[22904,44394],[22913,51006],
 [22919,51050],[22920,51050],[22921,51006],[22965,46241],[22966,47266],[22982,42362],
 [22983,43104],[23030,45745],[23031,47331],[23044,40824],[23069,42449],[23074,12747],
 [23074,14514],[23076,51006],[23083,12747],[23083,14523],[23086,50046],[23090,40870],
 [23091,45806],[23097,8962],[23097,19848],[23099,47399],[23106,8962],[23106,19857],
 [23111,8962],[23111,19862],[23114,42494],[23115,50075],[23120,51050],[23125,12747],
 [23125,14565],[23132,45847],[23133,47433],[23134,40914],[23135,12979],[23136,12979],
 [23137,12979],[23138,12979],[23139,12979],[23140,12979],[23141,12979],[23142,12979],
 [23143,12979],[23144,12979],[23145,12979],[23146,12979],[23147,12979],[23148,12979],
 [23149,12979],[23150,12979],[23151,12979],[23152,12979],[23153,12979],[23154,12979],
 [23155,12979],[23156,12979],[23157,12979],[23158,12979],[23159,12979],[23160,12979],
 [23161,12979],[23162,12979],[23163,12979],[23164,12979],[23165,12979],[23166,12979],
 [23167,12979],[23168,12979],[23169,12979],[23170,12979],[23171,12979],[23172,12979],
 [23173,12979],[23174,12979],[23175,12979],[23176,12979],[23177,12979],[23178,12979],
 [23178,14514],[23179,12979],[23179,14523],[23180,12979],[23181,12979],[23182,12979],
 [23183,12979],[23183,14523],[23184,12979],[23184,14514],[23185,12979],[23185,14565],
 [23186,12979],[23186,14565],[23187,12979],[23188,12979],[23189,12979],[23190,26160],
 [23191,26160],[23193,26316],[23194,26316],[23197,26510],[23198,26510],[23244,26160],
 [23245,27643],[23246,27643],[23249,27841],[23250,27841],[23297,28970],[23299,28970],
 [23301,29168],[23303,29168],[23349,27643],[23350,28970],[23351,30394],[23352,30394],
 [23400,26316],[23401,31620],[23403,31620],[23450,32797],[23453,32797],[23499,30394],
 [23500,31620],[23501,32797],[23547,27841],[23548,29168],[23594,26510],[23688,38331],
 [23689,38331],[23694,38557],[23696,38557],[23736,39424],[23737,39424],[23748,39779],
 [23750,39779],[23772,40055],[23774,40055],[23778,7828],[23778,40287],[23781,7828],
 [23781,40287],[23790,40642],[23794,40642],[23800,40824],[23801,40824],[23804,40870],
 [23805,40870],[23812,40914],[23813,40914],[23815,40055],[23823,41239],[23824,41239],
 [23829,41411],[23831,41411],[23855,38331],[23858,41850],[23860,41850],[23866,42109],
 [23867,42109],[23877,42362],[23878,42362],[23883,42449],[23884,42449],[23888,42494],
 [23889,42494],[23897,42593],[23901,42593],[23902,42761],[23904,42761],[23908,42936],
 [23914,42936],[23916,43104],[23918,43104],[23936,43330],[23938,43330],[23941,3756],
 [23948,43685],[23951,43685],[23974,44030],[23975,44030],[23987,44394],[23988,44394],
 [23992,8032],[24010,41850],[24012,42593],[24045,39424],[24046,43330],[24047,7828],
 [24047,40287],[24053,45501],[24056,45501],[24065,45745],[24066,45745],[24070,45806],
 [24072,45806],[24077,45847],[24078,45847],[24080,44030],[24081,38557],[24087,46064],
 [24092,46064],[24095,46241],[24097,46241],[24128,8168],[24160,47266],[24163,47266],
 [24164,47331],[24166,47331],[24170,47399],[24171,47399],[24176,47433],[24178,47433],
 [24179,41239],[24180,42761],[24192,6152],[24215,48035],[24216,48035],[24244,48445],
 [24249,48445],[24253,6213],[24269,42109],[24271,48796],[24274,48796],[24301,49217],
 [24302,49217],[24326,45501],[24328,46064],[24351,41411],[24352,48796],[24355,42936],
 [24364,50046],[24368,50075],[24370,50075],[24371,50046],[24375,48035],[24378,4193],
 [24379,48445],[24400,39779],[24401,43685],[24402,40642],[24422,49217],[24444,44394],
 [24453,51006],[24459,51050],[24460,51050],[24461,51006],[24505,46241],[24506,47266],
 [24522,42362],[24523,43104],[24570,45745],[24571,47331],[24579,24666],[24579,52022],
 [24581,24666],[24581,52022],[24584,40824],[24587,24633],[24587,52067],[24591,24633],
 [24591,52067],[24602,24659],[24602,52159],[24608,24659],[24608,52159],[24609,42449],
 [24614,12979],[24614,14514],[24616,51006],[24623,12979],[24623,14523],[24626,50046],
 [24630,40870],[24631,45806],[24637,19848],[24639,47399],[24646,19857],[24651,19862],
 [24654,42494],[24655,50075],[24660,51050],[24665,12979],[24665,14565],[24672,45847],
 [24673,47433],[24674,40914],[24675,26160],[24676,26160],[24678,26316],[24679,26316],
 [24682,26510],[24683,26510],[24729,26160],[24730,27643],[24731,27643],[24734,27841],
 [24735,27841],[24782,28970],[24784,28970],[24786,29168],[24788,29168],[24834,27643],
 [24835,28970],[24836,30394],[24837,30394],[24885,26316],[24886,31620],[24888,31620],
 [24935,32797],[24938,32797],[24984,30394],[24985,31620],[24986,32797],[25032,27841],
 [25033,29168],[25079,26510],[25173,38331],[25174,38331],[25179,38557],[25181,38557],
 [25221,39424],[25222,39424],[25233,39779],[25235,39779],[25257,40055],[25259,40055],
 [25275,40642],[25279,40642],[25285,40824],[25286,40824],[25289,40870],[25290,40870],
 [25297,40914],[25298,40914],[25300,40055],[25308,41239],[25309,41239],[25314,41411],
 [25316,41411],[25340,38331],[25343,41850],[25345,41850],[25351,42109],[25352,42109],
 [25362,42362],[25363,42362],[25368,42449],[25369,42449],[25373,42494],[25374,42494],
 [25382,42593],[25386,42593],[25387,42761],[25389,42761],[25393,42936],[25399,42936],
 [25401,43104],[25403,43104],[25421,43330],[25423,43330],[25426,3756],[25433,43685],
 [25436,43685],[25459,44030],[25460,44030],[25472,44394],[25473,44394],[25477,8032],
 [25495,41850],[25497,42593],[25530,39424],[25531,43330],[25538,45501],[25541,45501],
 [25550,45745],[25551,45745],[25555,45806],[25557,45806],[25562,45847],[25563,45847],
 [25565,44030],[25566,38557],[25572,46064],[25577,46064],[25580,46241],[25582,46241],
 [25613,8168],[25645,47266],[25648,47266],[25649,47331],[25651,47331],[25655,47399],
 [25656,47399],[25661,47433],[25663,47433],[25664,41239],[25665,42761],[25677,6152],
 [25700,48035],[25701,48035],[25729,48445],[25734,48445],[25738,6213],[25754,42109],
 [25756,48796],[25759,48796],[25786,49217],[25787,49217],[25811,45501],[25813,46064],
 [25836,41411],[25837,48796],[25840,42936],[25849,50046],[25853,50075],[25855,50075],
 [25856,50046],[25860,48035],[25863,4193],[25864,48445],[25885,39779],[25886,43685],
 [25887,40642],[25907,49217],[25929,44394],[25938,51006],[25944,51050],[25945,51050],
 [25946,51006],[25990,46241],[25991,47266],[26007,42362],[26008,43104],[26055,45745],
 [26056,47331],[26058,26107],[26058,51978],[26061,26107],[26061,51978],[26069,40824],
 [26078,26155],[26078,52104],[26080,26155],[26080,52104],[26082,26096],[26082,52111],
 [26085,26096],[26085,52111],[26094,42449],[26099,12979],[26099,14514],[26101,51006],
 [26108,12979],[26108,14523],[26111,50046],[26115,40870],[26116,45806],[26122,19848],
 [26124,47399],[26131,19857],[26136,19862],[26139,42494],[26140,50075],[26145,51050],
 [26150,12979],[26150,14565],[26157,45847],[26158,47433],[26159,40914],[26161,26160],
 [26161,26316],[26161,27643],[26161,28970],[26162,26160],[26162,26316],[26162,27643],
 [26162,28970],[26163,26160],[26163,26316],[26163,27643],[26163,28970],[26164,26160],
 [26165,26160],[26165,26510],[26165,27841],[26165,29168],[26166,26160],[26166,26510],
 [26166,27841],[26166,29168],[26167,26160],[26167,26510],[26167,27841],[26167,29168],
 [26168,26160],[26169,26160],[26170,26160],[26171,26160],[26172,26160],[26173,26160],
 [26174,26160],[26175,26160],[26176,26160],[26177,26160],[26178,26160],[26179,26160],
 [26180,26160],[26181,26160],[26182,26160],[26183,26160],[26184,26160],[26185,26160],
 [26186,26160],[26187,26160],[26188,26160],[26189,26160],[26190,26160],[26191,26160],
 [26192,26160],[26193,26160],[26194,26160],[26195,26160],[26196,26160],[26197,26160],
 [26198,26160],[26199,26160],[26200,26160],[26201,26160],[26202,26160],[26203,26160],
 [26204,26160],[26205,26160],[26206,26160],[26207,26160],[26208,26160],[26209,26160],
 [26210,26160],[26211,26160],[26212,26160],[26213,26160],[26213,26316],[26213,27643],
 [26213,28970],[26214,26160],[26214,26316],[26214,27643],[26214,28970],[26215,26160],
 [26215,26316],[26215,27643],[26215,28970],[26216,26160],[26217,26160],[26217,26510],
 [26217,27841],[26217,29168],[26218,26160],[26218,26510],[26218,27841],[26218,29168],
 [26219,26160],[26219,26510],[26219,27841],[26219,29168],[26220,26160],[26221,26160],
 [26222,26160],[26223,26160],[26224,26160],[26225,26160],[26226,26160],[26227,26160],
 [26228,26160],[26229,26160],[26230,26160],[26231,26160],[26232,26160],[26233,26160],
 [26234,26160],[26235,26160],[26236,26160],[26237,26160],[26238,26160],[26239,26160],
 [26240,26160],[26241,26160],[26242,26160],[26243,26160],[26244,26160],[26245,26160],
 [26246,26160],[26247,26160],[26248,26160],[26249,26160],[26250,26160],[26251,26160],
 [26252,26160],[26253,26160],[26254,26160],[26255,26160],[26256,26160],[26257,26160],
 [26258,26160],[26259,26160],[26260,26160],[26261,26160],[26262,26160],[26263,26160],
 [26264,26160],[26265,26160],[26265,26316],[26265,27643],[26265,28970],[26266,26160],
 [26266,26316],[26266,27643],[26266,28970],[26267,30394],[26268,30394],[26269,26510],
 [26270,26510],[26317,26316],[26317,26510],[26317,31620],[26317,32797],[26318,26316],
 [26319,26316],[26319,26510],[26319,31620],[26319,32797],[26320,26316],[26320,26510],
 [26320,31620],[26320,32797],[26321,26316],[26322,26316],[26323,26316],[26324,26316],
 [26325,26316],[26326,26316],[26327,26316],[26328,26316],[26329,26316],[26330,26316],
 [26331,26316],[26332,26316],[26333,26316],[26334,26316],[26335,26316],[26336,26316],
 [26337,26316],[26338,26316],[26339,26316],[26340,26316],[26341,26316],[26342,26316],
 [26343,26316],[26344,26316],[26345,26316],[26346,26316],[26347,26316],[26348,26316],
 [26349,26316],[26350,26316],[26351,26316],[26352,26316],[26353,26316],[26354,26316],
 [26355,26316],[26356,26316],[26357,26316],[26358,26316],[26359,26316],[26360,26316],
 [26361,26316],[26362,26316],[26363,26316],[26364,26316],[26365,26316],[26366,26316],
 [26366,26510],[26366,31620],[26366,32797],[26367,26316],[26368,26316],[26368,26510],
 [26368,31620],[26368,32797],[26369,26316],[26369,26510],[26369,31620],[26369,32797],
 [26370,26316],[26371,26316],[26372,26316],[26373,26316],[26374,26316],[26375,26316],
 [26376,26316],[26377,26316],[26378,26316],[26379,26316],[26380,26316],[26381,26316],
 [26382,26316],[26383,26316],[26384,26316],[26385,26316],[26386,26316],[26387,26316],
 [26388,26316],[26389,26316],[26390,26316],[26391,26316],[26392,26316],[26393,26316],
 [26394,26316],[26395,26316],[26396,26316],[26397,26316],[26398,26316],[26399,26316],
 [26400,26316],[26401,26316],[26402,26316],[26403,26316],[26404,26316],[26405,26316],
 [26406,26316],[26407,26316],[26408,26316],[26409,26316],[26410,26316],[26411,26316],
 [26412,26316],[26413,26316],[26414,26316],[26415,30394],[26416,26316],[26416,26510],
 [26416,31620],[26416,32797],[26417,26316],[26417,26510],[26417,31620],[26417,32797],
 [26463,26160],[26463,26510],[26463,27841],[26463,29168],[26464,26160],[26464,26510],
 [26464,27841],[26464,29168],[26511,26510],[26512,26510],[26513,26510],[26514,26510],
 [26515,26510],[26516,26510],[26517,26510],[26518,26510],[26519,26510],[26520,26510],
 [26521,26510],[26522,26510],[26523,26510],[26524,26510],[26525,26510],[26526,26510],
 [26527,26510],[26528,26510],[26529,26510],[26530,26510],[26531,26510],[26532,26510],
 [26533,26510],[26534,26510],[26535,26510],[26536,26510],[26537,26510],[26538,26510],
 [26539,26510],[26540,26510],[26541,26510],[26542,26510],[26543,26510],[26544,26510],
 [26545,26510],[26546,26510],[26547,26510],[26548,26510],[26549,26510],[26550,26510],
 [26551,26510],[26552,26510],[26553,26510],[26554,26510],[26555,26510],[26556,26510],
 [26557,26510],[26558,26510],[26559,26510],[26560,26510],[26561,26510],[26562,26510],
 [26563,26510],[26564,26510],[26565,26510],[26566,26510],[26567,26510],[26568,26510],
 [26569,26510],[26570,26510],[26571,26510],[26572,26510],[26573,26510],[26574,26510],
 [26575,26510],[26576,26510],[26577,26510],[26578,26510],[26579,26510],[26580,26510],
 [26581,26510],[26582,26510],[26583,26510],[26584,26510],[26585,26510],[26586,26510],
 [26587,26510],[26588,26510],[26589,26510],[26590,26510],[26591,26510],[26592,26510],
 [26593,26510],[26594,26510],[26595,26510],[26596,26510],[26597,26510],[26598,26510],
 [26599,26510],[26600,26510],[26604,38331],[26605,38331],[26610,38557],[26612,38557],
 [26652,39424],[26653,39424],[26664,39779],[26666,39779],[26688,40055],[26690,40055],
 [26706,40642],[26710,40642],[26716,40824],[26717,40824],[26720,40870],[26721,40870],
 [26728,40914],[26729,40914],[26731,40055],[26739,41239],[26740,41239],[26745,41411],
 [26747,41411],[26771,38331],[26774,41850],[26776,41850],[26782,42109],[26783,42109],
 [26793,42362],[26794,42362],[26799,42449],[26800,42449],[26804,42494],[26805,42494],
 [26813,42593],[26817,42593],[26818,42761],[26820,42761],[26824,42936],[26830,42936],
 [26832,43104],[26834,43104],[26852,43330],[26854,43330],[26857,3756],[26864,43685],
 [26867,43685],[26890,44030],[26891,44030],[26903,44394],[26904,44394],[26908,8032],
 [26926,41850],[26928,42593],[26961,39424],[26962,43330],[26969,45501],[26972,45501],
 [26981,45745],[26982,45745],[26986,45806],[26988,45806],[26993,45847],[26994,45847],
 [26996,44030],[26997,38557],[27003,46064],[27008,46064],[27011,46241],[27013,46241],
 [27044,8168],[27076,47266],[27079,47266],[27080,47331],[27082,47331],[27086,47399],
 [27087,47399],[27092,47433],[27094,47433],[27095,41239],[27096,42761],[27108,6152],
 [27131,48035],[27132,48035],[27160,48445],[27165,48445],[27169,6213],[27185,42109],
 [27187,48796],[27190,48796],[27217,49217],[27218,49217],[27242,45501],[27244,46064],
 [27267,41411],[27268,48796],[27271,42936],[27280,50046],[27284,50075],[27286,50075],
 [27287,50046],[27291,48035],[27294,4193],[27295,48445],[27316,39779],[27317,43685],
 [27318,40642],[27338,49217],[27360,44394],[27369,51006],[27375,51050],[27376,51050],
 [27377,51006],[27421,46241],[27422,47266],[27438,42362],[27439,43104],[27486,45745],
 [27487,47331],[27500,40824],[27525,42449],[27530,14514],[27532,51006],[27539,14523],
 [27542,50046],[27546,40870],[27547,45806],[27553,19848],[27555,47399],[27562,19857],
 [27567,19862],[27570,42494],[27571,50075],[27576,51050],[27581,14565],[27588,45847],
 [27589,47433],[27590,40914],[27591,26160],[27591,26316],[27591,27643],[27591,28970],
 [27592,26160],[27592,26316],[27592,27643],[27592,28970],[27593,26160],[27593,26316],
 [27593,27643],[27593,28970],[27594,26160],[27595,26160],[27595,26510],[27595,27841],
 [27595,29168],[27596,26160],[27596,26510],[27596,27841],[27596,29168],[27597,26160],
 [27597,26510],[27597,27841],[27597,29168],[27598,26160],[27599,26160],[27600,26160],
 [27601,26160],[27602,26160],[27603,26160],[27604,26160],[27605,26160],[27606,26160],
 [27607,26160],[27608,26160],[27609,26160],[27610,26160],[27611,26160],[27612,26160],
 [27613,26160],[27614,26160],[27615,26160],[27616,26160],[27617,26160],[27618,26160],
 [27619,26160],[27620,26160],[27621,26160],[27622,26160],[27623,26160],[27624,26160],
 [27625,26160],[27626,26160],[27627,26160],[27628,26160],[27629,26160],[27630,26160],
 [27631,26160],[27632,26160],[27633,26160],[27634,26160],[27635,26160],[27636,26160],
 [27637,26160],[27638,26160],[27639,26160],[27640,26160],[27641,26160],[27642,26160],
 [27644,26160],[27644,26316],[27644,27643],[27644,28970],[27645,27643],[27645,27841],
 [27645,30394],[27645,31620],[27646,27643],[27646,27841],[27646,30394],[27646,31620],
 [27647,27643],[27647,27841],[27647,30394],[27647,31620],[27648,27643],[27649,27643],
 [27650,27643],[27651,27643],[27652,27643],[27653,27643],[27654,27643],[27655,27643],
 [27656,27643],[27657,27643],[27658,27643],[27659,27643],[27660,27643],[27661,27643],
 [27662,27643],[27663,27643],[27664,27643],[27665,27643],[27666,27643],[27667,27643],
 [27668,27643],[27669,27643],[27670,27643],[27671,27643],[27672,27643],[27673,27643],
 [27674,27643],[27675,27643],[27676,27643],[27677,27643],[27678,27643],[27679,27643],
 [27680,27643],[27681,27643],[27682,27643],[27683,27643],[27684,27643],[27685,27643],
 [27686,27643],[27687,27643],[27688,27643],[27689,27643],[27690,27643],[27691,27643],
 [27692,27643],[27693,27643],[27694,26160],[27694,26316],[27694,27643],[27694,28970],
 [27695,27643],[27695,27841],[27695,30394],[27695,31620],[27696,27643],[27696,27841],
 [27696,30394],[27696,31620],[27697,27643],[27697,27841],[27697,30394],[27697,31620],
 [27698,27643],[27699,27643],[27700,27643],[27701,27643],[27702,27643],[27703,27643],
 [27704,27643],[27705,27643],[27706,27643],[27707,27643],[27708,27643],[27709,27643],
 [27710,27643],[27711,27643],[27712,27643],[27713,27643],[27714,27643],[27715,27643],
 [27716,27643],[27717,27643],[27718,27643],[27719,27643],[27720,27643],[27721,27643],
 [27722,27643],[27723,27643],[27724,27643],[27725,27643],[27726,27643],[27727,27643],
 [27728,27643],[27729,27643],[27730,27643],[27731,27643],[27732,27643],[27733,27643],
 [27734,27643],[27735,27643],[27736,27643],[27737,27643],[27738,27643],[27739,27643],
 [27740,27643],[27741,27643],[27742,27643],[27743,27643],[27744,32797],[27745,27841],
 [27746,27841],[27747,32797],[27793,27643],[27793,27841],[27793,30394],[27793,31620],
 [27794,27643],[27794,27841],[27794,30394],[27794,31620],[27795,32797],[27842,26160],
 [27842,26510],[27842,27841],[27842,29168],[27843,27841],[27844,27841],[27845,27841],
 [27846,27841],[27847,27841],[27848,27841],[27849,27841],[27850,27841],[27851,27841],
 [27852,27841],[27853,27841],[27854,27841],[27855,27841],[27856,27841],[27857,27841],
 [27858,27841],[27859,27841],[27860,27841],[27861,27841],[27862,27841],[27863,27841],
 [27864,27841],[27865,27841],[27866,27841],[27867,27841],[27868,27841],[27869,27841],
 [27870,27841],[27871,27841],[27872,27841],[27873,27841],[27874,27841],[27875,27841],
 [27876,27841],[27877,27841],[27878,27841],[27879,27841],[27880,27841],[27881,27841],
 [27882,27841],[27883,27841],[27884,27841],[27885,27841],[27886,27841],[27887,27841],
 [27888,26160],[27888,26510],[27888,27841],[27888,29168],[27889,27841],[27890,27841],
 [27891,27841],[27892,27841],[27893,27841],[27894,27841],[27895,27841],[27896,27841],
 [27897,27841],[27898,27841],[27899,27841],[27900,27841],[27901,27841],[27902,27841],
 [27903,27841],[27904,27841],[27905,27841],[27906,27841],[27907,27841],[27908,27841],
 [27909,27841],[27910,27841],[27911,27841],[27912,27841],[27913,27841],[27914,27841],
 [27915,27841],[27916,27841],[27917,27841],[27918,27841],[27919,27841],[27920,27841],
 [27921,27841],[27922,27841],[27923,27841],[27924,27841],[27925,27841],[27926,27841],
 [27927,27841],[27928,27841],[27929,27841],[27930,27841],[27931,27841],[27932,27841],
 [27933,27841],[27982,38331],[27983,38331],[27988,38557],[27990,38557],[28030,39424],
 [28031,39424],[28042,39779],[28044,39779],[28066,40055],[28068,40055],[28084,40642],
 [28088,40642],[28094,40824],[28095,40824],[28098,40870],[28099,40870],[28106,40914],
 [28107,40914],[28109,40055],[28117,41239],[28118,41239],[28123,41411],[28125,41411],
 [28149,38331],[28152,41850],[28154,41850],[28160,42109],[28161,42109],[28171,42362],
 [28172,42362],[28177,42449],[28178,42449],[28182,42494],[28183,42494],[28191,42593],
 [28195,42593],[28196,42761],[28198,42761],[28202,42936],[28208,42936],[28210,43104],
 [28212,43104],[28230,43330],[28232,43330],[28235,3756],[28242,43685],[28245,43685],
 [28268,44030],[28269,44030],[28281,44394],[28282,44394],[28286,8032],[28304,41850],
 [28306,42593],[28339,39424],[28340,43330],[28347,45501],[28350,45501],[28359,45745],
 [28360,45745],[28364,45806],[28366,45806],[28371,45847],[28372,45847],[28374,44030],
 [28375,38557],[28381,46064],[28386,46064],[28389,46241],[28391,46241],[28422,8168],
 [28454,47266],[28457,47266],[28458,47331],[28460,47331],[28464,47399],[28465,47399],
 [28470,47433],[28472,47433],[28473,41239],[28474,42761],[28486,6152],[28509,48035],
 [28510,48035],[28538,48445],[28543,48445],[28547,6213],[28563,42109],[28565,48796],
 [28568,48796],[28595,49217],[28596,49217],[28620,45501],[28622,46064],[28645,41411],
 [28646,48796],[28649,42936],[28658,50046],[28662,50075],[28664,50075],[28665,50046],
 [28669,48035],[28672,4193],[28673,48445],[28694,39779],[28695,43685],[28696,40642],
 [28716,49217],[28738,44394],[28747,51006],[28753,51050],[28754,51050],[28755,51006],
 [28799,46241],[28800,47266],[28816,42362],[28817,43104],[28864,45745],[28865,47331],
 [28878,40824],[28903,42449],[28908,14514],[28910,51006],[28917,14523],[28920,50046],
 [28924,40870],[28925,45806],[28931,19848],[28933,47399],[28940,19857],[28945,19862],
 [28948,42494],[28949,50075],[28954,51050],[28959,14565],[28966,45847],[28967,47433],
 [28968,40914],[28969,26160],[28969,26316],[28969,27643],[28969,28970],[28971,28970],
 [28971,29168],[28971,30394],[28971,32797],[28972,28970],[28972,29168],[28972,30394],
 [28972,32797],[28973,28970],[28974,28970],[28974,29168],[28974,30394],[28974,32797],
 [28975,28970],[28976,28970],[28977,28970],[28978,28970],[28979,28970],[28980,28970],
 [28981,28970],[28982,28970],[28983,28970],[28984,28970],[28985,28970],[28986,28970],
 [28987,28970],[28988,28970],[28989,28970],[28990,28970],[28991,28970],[28992,28970],
 [28993,28970],[28994,28970],[28995,28970],[28996,28970],[28997,28970],[28998,28970],
 [28999,28970],[29000,28970],[29001,28970],[29002,28970],[29003,28970],[29004,28970],
 [29005,28970],[29006,28970],[29007,28970],[29008,28970],[29009,28970],[29010,28970],
 [29011,28970],[29012,28970],[29013,28970],[29014,28970],[29015,28970],[29016,28970],
 [29017,28970],[29018,28970],[29019,28970],[29020,26160],[29020,26316],[29020,27643],
 [29020,28970],[29021,31620],[29022,29168],[29023,31620],[29024,29168],[29070,28970],
 [29070,29168],[29070,30394],[29070,32797],[29071,28970],[29071,29168],[29071,30394],
 [29071,32797],[29072,28970],[29073,28970],[29073,29168],[29073,30394],[29073,32797],
 [29074,28970],[29075,28970],[29076,28970],[29077,28970],[29078,28970],[29079,28970],
 [29080,28970],[29081,28970],[29082,28970],[29083,28970],[29084,28970],[29085,28970],
 [29086,28970],[29087,28970],[29088,28970],[29089,28970],[29090,28970],[29091,28970],
 [29092,28970],[29093,28970],[29094,28970],[29095,28970],[29096,28970],[29097,28970],
 [29098,28970],[29099,28970],[29100,28970],[29101,28970],[29102,28970],[29103,28970],
 [29104,28970],[29105,28970],[29106,28970],[29107,28970],[29108,28970],[29109,28970],
 [29110,28970],[29111,28970],[29112,28970],[29113,28970],[29114,28970],[29115,28970],
 [29116,28970],[29117,28970],[29118,28970],[29119,28970],[29119,29168],[29119,30394],
 [29119,32797],[29120,31620],[29121,28970],[29121,29168],[29121,30394],[29121,32797],
 [29167,26160],[29167,26510],[29167,27841],[29167,29168],[29169,29168],[29170,29168],
 [29171,29168],[29172,29168],[29173,29168],[29174,29168],[29175,29168],[29176,29168],
 [29177,29168],[29178,29168],[29179,29168],[29180,29168],[29181,29168],[29182,29168],
 [29183,29168],[29184,29168],[29185,29168],[29186,29168],[29187,29168],[29188,29168],
 [29189,29168],[29190,29168],[29191,29168],[29192,29168],[29193,29168],[29194,29168],
 [29195,29168],[29196,29168],[29197,29168],[29198,29168],[29199,29168],[29200,29168],
 [29201,29168],[29202,29168],[29203,29168],[29204,29168],[29205,29168],[29206,29168],
 [29207,29168],[29208,29168],[29209,29168],[29210,29168],[29211,29168],[29212,29168],
 [29213,29168],[29214,26160],[29214,26510],[29214,27841],[29214,29168],[29260,29168],
 [29261,29168],[29262,29168],[29263,29168],[29264,29168],[29265,29168],[29266,29168],
 [29267,29168],[29268,29168],[29269,29168],[29270,29168],[29271,29168],[29272,29168],
 [29273,29168],[29274,29168],[29275,29168],[29276,29168],[29277,29168],[29278,29168],
 [29279,29168],[29280,29168],[29281,29168],[29282,29168],[29283,29168],[29284,29168],
 [29285,29168],[29286,29168],[29287,29168],[29288,29168],[29289,29168],[29290,29168],
 [29291,29168],[29292,29168],[29293,29168],[29294,29168],[29295,29168],[29296,29168],
 [29297,29168],[29298,29168],[29299,29168],[29300,29168],[29301,29168],[29302,29168],
 [29303,29168],[29304,29168],[29308,38331],[29309,38331],[29314,38557],[29316,38557],
 [29356,39424],[29357,39424],[29368,39779],[29370,39779],[29392,40055],[29394,40055],
 [29410,40642],[29414,40642],[29420,40824],[29421,40824],[29424,40870],[29425,40870],
 [29432,40914],[29433,40914],[29435,40055],[29443,41239],[29444,41239],[29449,41411],
 [29451,41411],[29475,38331],[29478,41850],[29480,41850],[29486,42109],[29487,42109],
 [29497,42362],[29498,42362],[29503,42449],[29504,42449],[29508,42494],[29509,42494],
 [29517,42593],[29521,42593],[29522,42761],[29524,42761],[29528,42936],[29534,42936],
 [29536,43104],[29538,43104],[29556,43330],[29558,43330],[29561,3756],[29568,43685],
 [29571,43685],[29594,44030],[29595,44030],[29607,44394],[29608,44394],[29612,8032],
 [29630,41850],[29632,42593],[29665,39424],[29666,43330],[29673,45501],[29676,45501],
 [29685,45745],[29686,45745],[29690,45806],[29692,45806],[29697,45847],[29698,45847],
 [29700,44030],[29701,38557],[29707,46064],[29712,46064],[29715,46241],[29717,46241],
 [29748,8168],[29780,47266],[29783,47266],[29784,47331],[29786,47331],[29790,47399],
 [29791,47399],[29796,47433],[29798,47433],[29799,41239],[29800,42761],[29812,6152],
 [29835,48035],[29836,48035],[29864,48445],[29869,48445],[29873,6213],[29889,42109],
 [29891,48796],[29894,48796],[29921,49217],[29922,49217],[29946,45501],[29948,46064],
 [29971,41411],[29972,48796],[29975,42936],[29984,50046],[29988,50075],[29990,50075],
 [29991,50046],[29995,48035],[29998,4193],[29999,48445],[30020,39779],[30021,43685],
 [30022,40642],[30042,49217],[30064,44394],[30073,51006],[30079,51050],[30080,51050],
 [30081,51006],[30125,46241],[30126,47266],[30142,42362],[30143,43104],[30190,45745],
 [30191,47331],[30204,40824],[30229,42449],[30234,14514],[30236,51006],[30243,14523],
 [30246,50046],[30250,40870],[30251,45806],[30257,19848],[30259,47399],[30266,19857],
 [30271,19862],[30274,42494],[30275,50075],[30280,51050],[30285,14565],[30292,45847],
 [30293,47433],[30294,40914],[30295,26160],[30295,26316],[30295,27643],[30295,28970],
 [30296,27643],[30296,27841],[30296,30394],[30296,31620],[30297,27643],[30297,27841],
 [30297,30394],[30297,31620],[30298,27643],[30298,27841],[30298,30394],[30298,31620],
 [30299,27643],[30300,27643],[30301,27643],[30302,27643],[30303,27643],[30304,27643],
 [30305,27643],[30306,27643],[30307,27643],[30308,27643],[30309,27643],[30310,27643],
 [30311,27643],[30312,27643],[30313,27643],[30314,27643],[30315,27643],[30316,27643],
 [30317,27643],[30318,27643],[30319,27643],[30320,27643],[30321,27643],[30322,27643],
 [30323,27643],[30324,27643],[30325,27643],[30326,27643],[30327,27643],[30328,27643],
 [30329,27643],[30330,27643],[30331,27643],[30332,27643],[30333,27643],[30334,27643],
 [30335,27643],[30336,27643],[30337,27643],[30338,27643],[30339,27643],[30340,27643],
 [30341,27643],[30342,27643],[30343,27643],[30344,27643],[30345,28970],[30345,29168],
 [30345,30394],[30345,32797],[30346,28970],[30346,29168],[30346,30394],[30346,32797],
 [30347,28970],[30348,28970],[30348,29168],[30348,30394],[30348,32797],[30349,28970],
 [30350,28970],[30351,28970],[30352,28970],[30353,28970],[30354,28970],[30355,28970],
 [30356,28970],[30357,28970],[30358,28970],[30359,28970],[30360,28970],[30361,28970],
 [30362,28970],[30363,28970],[30364,28970],[30365,28970],[30366,28970],[30367,28970],
 [30368,28970],[30369,28970],[30370,28970],[30371,28970],[30372,28970],[30373,28970],
 [30374,28970],[30375,28970],[30376,28970],[30377,28970],[30378,28970],[30379,28970],
 [30380,28970],[30381,28970],[30382,28970],[30383,28970],[30384,28970],[30385,28970],
 [30386,28970],[30387,28970],[30388,28970],[30389,28970],[30390,28970],[30391,28970],
 [30392,28970],[30393,28970],[30395,27643],[30395,27841],[30395,30394],[30395,31620],
 [30396,28970],[30396,29168],[30396,30394],[30396,32797],[30397,30394],[30398,30394],
 [30399,30394],[30400,30394],[30401,30394],[30402,30394],[30403,30394],[30404,30394],
 [30405,30394],[30406,30394],[30407,30394],[30408,30394],[30409,30394],[30410,30394],
 [30411,30394],[30412,30394],[30413,30394],[30414,30394],[30415,30394],[30416,30394],
 [30417,30394],[30418,30394],[30419,30394],[30420,30394],[30421,30394],[30422,30394],
 [30423,30394],[30424,30394],[30425,30394],[30426,30394],[30427,30394],[30428,30394],
 [30429,30394],[30430,30394],[30431,30394],[30432,30394],[30433,30394],[30434,30394],
 [30435,30394],[30436,30394],[30437,30394],[30438,30394],[30439,30394],[30440,30394],
 [30441,30394],[30442,27643],[30442,27841],[30442,30394],[30442,31620],[30443,28970],
 [30443,29168],[30443,30394],[30443,32797],[30444,30394],[30445,30394],[30446,30394],
 [30447,30394],[30448,30394],[30449,30394],[30450,30394],[30451,30394],[30452,30394],
 [30453,30394],[30454,30394],[30455,30394],[30456,30394],[30457,30394],[30458,30394],
 [30459,30394],[30460,30394],[30461,30394],[30462,30394],[30463,30394],[30464,30394],
 [30465,30394],[30466,30394],[30467,30394],[30468,30394],[30469,30394],[30470,30394],
 [30471,30394],[30472,30394],[30473,30394],[30474,30394],[30475,30394],[30476,30394],
 [30477,30394],[30478,30394],[30479,30394],[30480,30394],[30481,30394],[30482,30394],
 [30483,30394],[30484,30394],[30485,30394],[30486,30394],[30487,30394],[30488,30394],
 [30489,26510],[30583,38331],[30584,38331],[30589,38557],[30591,38557],[30631,39424],
 [30632,39424],[30643,39779],[30645,39779],[30667,40055],[30669,40055],[30685,40642],
 [30689,40642],[30695,40824],[30696,40824],[30699,40870],[30700,40870],[30707,40914],
 [30708,40914],[30710,40055],[30718,41239],[30719,41239],[30724,41411],[30726,41411],
 [30750,38331],[30753,41850],[30755,41850],[30761,42109],[30762,42109],[30772,42362],
 [30773,42362],[30778,42449],[30779,42449],[30783,42494],[30784,42494],[30792,42593],
 [30796,42593],[30797,42761],[30799,42761],[30803,42936],[30809,42936],[30811,43104],
 [30813,43104],[30831,43330],[30833,43330],[30836,3756],[30843,43685],[30846,43685],
 [30869,44030],[30870,44030],[30882,44394],[30883,44394],[30887,8032],[30905,41850],
 [30907,42593],[30940,39424],[30941,43330],[30948,45501],[30951,45501],[30960,45745],
 [30961,45745],[30965,45806],[30967,45806],[30972,45847],[30973,45847],[30975,44030],
 [30976,38557],[30982,46064],[30987,46064],[30990,46241],[30992,46241],[31023,8168],
 [31055,47266],[31058,47266],[31059,47331],[31061,47331],[31065,47399],[31066,47399],
 [31071,47433],[31073,47433],[31074,41239],[31075,42761],[31087,6152],[31110,48035],
 [31111,48035],[31139,48445],[31144,48445],[31148,6213],[31164,42109],[31166,48796],
 [31169,48796],[31196,49217],[31197,49217],[31221,45501],[31223,46064],[31246,41411],
 [31247,48796],[31250,42936],[31259,50046],[31263,50075],[31265,50075],[31266,50046],
 [31270,48035],[31273,4193],[31274,48445],[31295,39779],[31296,43685],[31297,40642],
 [31317,49217],[31339,44394],[31348,51006],[31354,51050],[31355,51050],[31356,51006],
 [31400,46241],[31401,47266],[31417,42362],[31418,43104],[31465,45745],[31466,47331],
 [31479,40824],[31504,42449],[31509,14514],[31511,51006],[31518,14523],[31521,50046],
 [31525,40870],[31526,45806],[31532,19848],[31534,47399],[31541,19857],[31546,19862],
 [31549,42494],[31550,50075],[31555,51050],[31560,14565],[31567,45847],[31568,47433],
 [31569,40914],[31570,26316],[31570,26510],[31570,31620],[31570,32797],[31571,26316],
 [31572,26316],[31572,26510],[31572,31620],[31572,32797],[31573,26316],[31573,26510],
 [31573,31620],[31573,32797],[31574,26316],[31575,26316],[31576,26316],[31577,26316],
 [31578,26316],[31579,26316],[31580,26316],[31581,26316],[31582,26316],[31583,26316],
 [31584,26316],[31585,26316],[31586,26316],[31587,26316],[31588,26316],[31589,26316],
 [31590,26316],[31591,26316],[31592,26316],[31593,26316],[31594,26316],[31595,26316],
 [31596,26316],[31597,26316],[31598,26316],[31599,26316],[31600,26316],[31601,26316],
 [31602,26316],[31603,26316],[31604,26316],[31605,26316],[31606,26316],[31607,26316],
 [31608,26316],[31609,26316],[31610,26316],[31611,26316],[31612,26316],[31613,26316],
 [31614,26316],[31615,26316],[31616,26316],[31617,26316],[31618,26316],[31619,27643],
 [31619,27841],[31619,30394],[31619,31620],[31621,26316],[31621,26510],[31621,31620],
 [31621,32797],[31622,31620],[31623,31620],[31624,31620],[31625,31620],[31626,31620],
 [31627,31620],[31628,31620],[31629,31620],[31630,31620],[31631,31620],[31632,31620],
 [31633,31620],[31634,31620],[31635,31620],[31636,31620],[31637,31620],[31638,31620],
 [31639,31620],[31640,31620],[31641,31620],[31642,31620],[31643,31620],[31644,31620],
 [31645,31620],[31646,31620],[31647,31620],[31648,31620],[31649,31620],[31650,31620],
 [31651,31620],[31652,31620],[31653,31620],[31654,31620],[31655,31620],[31656,31620],
 [31657,31620],[31658,31620],[31659,31620],[31660,31620],[31661,31620],[31662,31620],
 [31663,31620],[31664,31620],[31665,31620],[31666,31620],[31667,27643],[31667,27841],
 [31667,30394],[31667,31620],[31668,29168],[31714,26316],[31714,26510],[31714,31620],
 [31714,32797],[31715,31620],[31716,31620],[31717,31620],[31718,31620],[31719,31620],
 [31720,31620],[31721,31620],[31722,31620],[31723,31620],[31724,31620],[31725,31620],
 [31726,31620],[31727,31620],[31728,31620],[31729,31620],[31730,31620],[31731,31620],
 [31732,31620],[31733,31620],[31734,31620],[31735,31620],[31736,31620],[31737,31620],
 [31738,31620],[31739,31620],[31740,31620],[31741,31620],[31742,31620],[31743,31620],
 [31744,31620],[31745,31620],[31746,31620],[31747,31620],[31748,31620],[31749,31620],
 [31750,31620],[31751,31620],[31752,31620],[31753,31620],[31754,31620],[31755,31620],
 [31756,31620],[31757,31620],[31758,31620],[31759,31620],[31808,38331],[31809,38331],
 [31814,38557],[31816,38557],[31856,39424],[31857,39424],[31868,39779],[31870,39779],
 [31892,40055],[31894,40055],[31910,40642],[31914,40642],[31920,40824],[31921,40824],
 [31924,40870],[31925,40870],[31932,40914],[31933,40914],[31935,40055],[31943,41239],
 [31944,41239],[31949,41411],[31951,41411],[31975,38331],[31978,41850],[31980,41850],
 [31986,42109],[31987,42109],[31997,42362],[31998,42362],[32003,42449],[32004,42449],
 [32008,42494],[32009,42494],[32017,42593],[32021,42593],[32022,42761],[32024,42761],
 [32028,42936],[32034,42936],[32036,43104],[32038,43104],[32056,43330],[32058,43330],
 [32061,3756],[32068,43685],[32071,43685],[32094,44030],[32095,44030],[32107,44394],
 [32108,44394],[32112,8032],[32130,41850],[32132,42593],[32165,39424],[32166,43330],
 [32173,45501],[32176,45501],[32185,45745],[32186,45745],[32190,45806],[32192,45806],
 [32197,45847],[32198,45847],[32200,44030],[32201,38557],[32207,46064],[32212,46064],
 [32215,46241],[32217,46241],[32248,8168],[32280,47266],[32283,47266],[32284,47331],
 [32286,47331],[32290,47399],[32291,47399],[32296,47433],[32298,47433],[32299,41239],
 [32300,42761],[32312,6152],[32335,48035],[32336,48035],[32364,48445],[32369,48445],
 [32373,6213],[32389,42109],[32391,48796],[32394,48796],[32421,49217],[32422,49217],
 [32446,45501],[32448,46064],[32471,41411],[32472,48796],[32475,42936],[32484,50046],
 [32488,50075],[32490,50075],[32491,50046],[32495,48035],[32498,4193],[32499,48445],
 [32520,39779],[32521,43685],[32522,40642],[32542,49217],[32564,44394],[32573,51006],
 [32579,51050],[32580,51050],[32581,51006],[32625,46241],[32626,47266],[32642,42362],
 [32643,43104],[32690,45745],[32691,47331],[32704,40824],[32729,42449],[32734,14514],
 [32736,51006],[32743,14523],[32746,50046],[32750,40870],[32751,45806],[32757,19848],
 [32759,47399],[32766,19857],[32771,19862],[32774,42494],[32775,50075],[32780,51050],
 [32785,14565],[32792,45847],[32793,47433],[32794,40914],[32795,28970],[32795,29168],
 [32795,30394],[32795,32797],[32796,26316],[32796,26510],[32796,31620],[32796,32797],
 [32798,32797],[32799,32797],[32800,32797],[32801,32797],[32802,32797],[32803,32797],
 [32804,32797],[32805,32797],[32806,32797],[32807,32797],[32808,32797],[32809,32797],
 [32810,32797],[32811,32797],[32812,32797],[32813,32797],[32814,32797],[32815,32797],
 [32816,32797],[32817,32797],[32818,32797],[32819,32797],[32820,32797],[32821,32797],
 [32822,32797],[32823,32797],[32824,32797],[32825,32797],[32826,32797],[32827,32797],
 [32828,32797],[32829,32797],[32830,32797],[32831,32797],[32832,32797],[32833,32797],
 [32834,32797],[32835,32797],[32836,32797],[32837,32797],[32838,32797],[32839,32797],
 [32840,32797],[32841,32797],[32842,32797],[32843,27841],[32844,28970],[32844,29168],
 [32844,30394],[32844,32797],[32890,26316],[32890,26510],[32890,31620],[32890,32797],
 [32936,32797],[32937,32797],[32938,32797],[32939,32797],[32940,32797],[32941,32797],
 [32942,32797],[32943,32797],[32944,32797],[32945,32797],[32946,32797],[32947,32797],
 [32948,32797],[32949,32797],[32950,32797],[32951,32797],[32952,32797],[32953,32797],
 [32954,32797],[32955,32797],[32956,32797],[32957,32797],[32958,32797],[32959,32797],
 [32960,32797],[32961,32797],[32962,32797],[32963,32797],[32964,32797],[32965,32797],
 [32966,32797],[32967,32797],[32968,32797],[32969,32797],[32970,32797],[32971,32797],
 [32972,32797],[32973,32797],[32974,32797],[32975,32797],[32976,32797],[32977,32797],
 [32978,32797],[32979,32797],[32980,32797],[32984,38331],[32985,38331],[32990,38557],
 [32992,38557],[33032,39424],[33033,39424],[33044,39779],[33046,39779],[33068,40055],
 [33070,40055],[33086,40642],[33090,40642],[33096,40824],[33097,40824],[33100,40870],
 [33101,40870],[33108,40914],[33109,40914],[33111,40055],[33119,41239],[33120,41239],
 [33125,41411],[33127,41411],[33151,38331],[33154,41850],[33156,41850],[33162,42109],
 [33163,42109],[33173,42362],[33174,42362],[33179,42449],[33180,42449],[33184,42494],
 [33185,42494],[33193,42593],[33197,42593],[33198,42761],[33200,42761],[33204,42936],
 [33210,42936],[33212,43104],[33214,43104],[33232,43330],[33234,43330],[33237,3756],
 [33244,43685],[33247,43685],[33270,44030],[33271,44030],[33283,44394],[33284,44394],
 [33288,8032],[33306,41850],[33308,42593],[33341,39424],[33342,43330],[33349,45501],
 [33352,45501],[33361,45745],[33362,45745],[33366,45806],[33368,45806],[33373,45847],
 [33374,45847],[33376,44030],[33377,38557],[33383,46064],[33388,46064],[33391,46241],
 [33393,46241],[33424,8168],[33456,47266],[33459,47266],[33460,47331],[33462,47331],
 [33466,47399],[33467,47399],[33472,47433],[33474,47433],[33475,41239],[33476,42761],
 [33488,6152],[33511,48035],[33512,48035],[33540,48445],[33545,48445],[33549,6213],
 [33565,42109],[33567,48796],[33570,48796],[33597,49217],[33598,49217],[33622,45501],
 [33624,46064],[33647,41411],[33648,48796],[33651,42936],[33660,50046],[33664,50075],
 [33666,50075],[33667,50046],[33671,48035],[33674,4193],[33675,48445],[33696,39779],
 [33697,43685],[33698,40642],[33718,49217],[33740,44394],[33749,51006],[33755,51050],
 [33756,51050],[33757,51006],[33801,46241],[33802,47266],[33818,42362],[33819,43104],
 [33866,45745],[33867,47331],[33880,40824],[33905,42449],[33910,14514],[33912,51006],
 [33919,14523],[33922,50046],[33926,40870],[33927,45806],[33933,19848],[33935,47399],
 [33942,19857],[33947,19862],[33950,42494],[33951,50075],[33956,51050],[33961,14565],
 [33968,45847],[33969,47433],[33970,40914],[33971,27643],[33971,27841],[33971,30394],
 [33971,31620],[33972,28970],[33972,29168],[33972,30394],[33972,32797],[33973,30394],
 [33974,30394],[33975,30394],[33976,30394],[33977,30394],[33978,30394],[33979,30394],
 [33980,30394],[33981,30394],[33982,30394],[33983,30394],[33984,30394],[33985,30394],
 [33986,30394],[33987,30394],[33988,30394],[33989,30394],[33990,30394],[33991,30394],
 [33992,30394],[33993,30394],[33994,30394],[33995,30394],[33996,30394],[33997,30394],
 [33998,30394],[33999,30394],[34000,30394],[34001,30394],[34002,30394],[34003,30394],
 [34004,30394],[34005,30394],[34006,30394],[34007,30394],[34008,30394],[34009,30394],
 [34010,30394],[34011,30394],[34012,30394],[34013,30394],[34014,30394],[34015,30394],
 [34016,30394],[34017,30394],[34018,26316],[34018,26510],[34018,31620],[34018,32797],
 [34019,31620],[34020,31620],[34021,31620],[34022,31620],[34023,31620],[34024,31620],
 [34025,31620],[34026,31620],[34027,31620],[34028,31620],[34029,31620],[34030,31620],
 [34031,31620],[34032,31620],[34033,31620],[34034,31620],[34035,31620],[34036,31620],
 [34037,31620],[34038,31620],[34039,31620],[34040,31620],[34041,31620],[34042,31620],
 [34043,31620],[34044,31620],[34045,31620],[34046,31620],[34047,31620],[34048,31620],
 [34049,31620],[34050,31620],[34051,31620],[34052,31620],[34053,31620],[34054,31620],
 [34055,31620],[34056,31620],[34057,31620],[34058,31620],[34059,31620],[34060,31620],
 [34061,31620],[34062,31620],[34063,31620],[34064,32797],[34065,32797],[34066,32797],
 [34067,32797],[34068,32797],[34069,32797],[34070,32797],[34071,32797],[34072,32797],
 [34073,32797],[34074,32797],[34075,32797],[34076,32797],[34077,32797],[34078,32797],
 [34079,32797],[34080,32797],[34081,32797],[34082,32797],[34083,32797],[34084,32797],
 [34085,32797],[34086,32797],[34087,32797],[34088,32797],[34089,32797],[34090,32797],
 [34091,32797],[34092,32797],[34093,32797],[34094,32797],[34095,32797],[34096,32797],
 [34097,32797],[34098,32797],[34099,32797],[34100,32797],[34101,32797],[34102,32797],
 [34103,32797],[34104,32797],[34105,32797],[34106,32797],[34107,32797],[34108,32797],
 [34112,38331],[34113,38331],[34118,38557],[34120,38557],[34160,39424],[34161,39424],
 [34172,39779],[34174,39779],[34196,40055],[34198,40055],[34214,40642],[34218,40642],
 [34224,40824],[34225,40824],[34228,40870],[34229,40870],[34236,40914],[34237,40914],
 [34239,40055],[34247,41239],[34248,41239],[34253,41411],[34255,41411],[34279,38331],
 [34282,41850],[34284,41850],[34290,42109],[34291,42109],[34301,42362],[34302,42362],
 [34307,42449],[34308,42449],[34312,42494],[34313,42494],[34321,42593],[34325,42593],
 [34326,42761],[34328,42761],[34332,42936],[34338,42936],[34340,43104],[34342,43104],
 [34360,43330],[34362,43330],[34365,3756],[34372,43685],[34375,43685],[34398,44030],
 [34399,44030],[34411,44394],[34412,44394],[34416,8032],[34434,41850],[34436,42593],
 [34469,39424],[34470,43330],[34477,45501],[34480,45501],[34489,45745],[34490,45745],
 [34494,45806],[34496,45806],[34501,45847],[34502,45847],[34504,44030],[34505,38557],
 [34511,46064],[34516,46064],[34519,46241],[34521,46241],[34552,8168],[34584,47266],
 [34587,47266],[34588,47331],[34590,47331],[34594,47399],[34595,47399],[34600,47433],
 [34602,47433],[34603,41239],[34604,42761],[34616,6152],[34639,48035],[34640,48035],
 [34668,48445],[34673,48445],[34677,6213],[34693,42109],[34695,48796],[34698,48796],
 [34725,49217],[34726,49217],[34750,45501],[34752,46064],[34775,41411],[34776,48796],
 [34779,42936],[34788,50046],[34792,50075],[34794,50075],[34795,50046],[34799,48035],
 [34802,4193],[34803,48445],[34824,39779],[34825,43685],[34826,40642],[34846,49217],
 [34868,44394],[34877,51006],[34883,51050],[34884,51050],[34885,51006],[34929,46241],
 [34930,47266],[34946,42362],[34947,43104],[34994,45745],[34995,47331],[35008,40824],
 [35033,42449],[35038,14514],[35040,51006],[35047,14523],[35050,50046],[35054,40870],
 [35055,45806],[35061,19848],[35063,47399],[35070,19857],[35075,19862],[35078,42494],
 [35079,50075],[35084,51050],[35089,14565],[35096,45847],[35097,47433],[35098,40914],
 [35099,26160],[35099,26510],[35099,27841],[35099,29168],[35100,27841],[35101,27841],
 [35102,27841],[35103,27841],[35104,27841],[35105,27841],[35106,27841],[35107,27841],
 [35108,27841],[35109,27841],[35110,27841],[35111,27841],[35112,27841],[35113,27841],
 [35114,27841],[35115,27841],[35116,27841],[35117,27841],[35118,27841],[35119,27841],
 [35120,27841],[35121,27841],[35122,27841],[35123,27841],[35124,27841],[35125,27841],
 [35126,27841],[35127,27841],[35128,27841],[35129,27841],[35130,27841],[35131,27841],
 [35132,27841],[35133,27841],[35134,27841],[35135,27841],[35136,27841],[35137,27841],
 [35138,27841],[35139,27841],[35140,27841],[35141,27841],[35142,27841],[35143,27841],
 [35144,27841],[35145,29168],[35146,29168],[35147,29168],[35148,29168],[35149,29168],
 [35150,29168],[35151,29168],[35152,29168],[35153,29168],[35154,29168],[35155,29168],
 [35156,29168],[35157,29168],[35158,29168],[35159,29168],[35160,29168],[35161,29168],
 [35162,29168],[35163,29168],[35164,29168],[35165,29168],[35166,29168],[35167,29168],
 [35168,29168],[35169,29168],[35170,29168],[35171,29168],[35172,29168],[35173,29168],
 [35174,29168],[35175,29168],[35176,29168],[35177,29168],[35178,29168],[35179,29168],
 [35180,29168],[35181,29168],[35182,29168],[35183,29168],[35184,29168],[35185,29168],
 [35186,29168],[35187,29168],[35188,29168],[35189,29168],[35193,38331],[35194,38331],
 [35199,38557],[35201,38557],[35241,39424],[35242,39424],[35253,39779],[35255,39779],
 [35277,40055],[35279,40055],[35295,40642],[35299,40642],[35305,40824],[35306,40824],
 [35309,40870],[35310,40870],[35317,40914],[35318,40914],[35320,40055],[35328,41239],
 [35329,41239],[35334,41411],[35336,41411],[35360,38331],[35363,41850],[35365,41850],
 [35371,42109],[35372,42109],[35382,42362],[35383,42362],[35388,42449],[35389,42449],
 [35393,42494],[35394,42494],[35402,42593],[35406,42593],[35407,42761],[35409,42761],
 [35413,42936],[35419,42936],[35421,43104],[35423,43104],[35441,43330],[35443,43330],
 [35446,3756],[35453,43685],[35456,43685],[35479,44030],[35480,44030],[35492,44394],
 [35493,44394],[35497,8032],[35515,41850],[35517,42593],[35550,39424],[35551,43330],
 [35558,45501],[35561,45501],[35570,45745],[35571,45745],[35575,45806],[35577,45806],
 [35582,45847],[35583,45847],[35585,44030],[35586,38557],[35592,46064],[35597,46064],
 [35600,46241],[35602,46241],[35633,8168],[35665,47266],[35668,47266],[35669,47331],
 [35671,47331],[35675,47399],[35676,47399],[35681,47433],[35683,47433],[35684,41239],
 [35685,42761],[35697,6152],[35720,48035],[35721,48035],[35749,48445],[35754,48445],
 [35758,6213],[35774,42109],[35776,48796],[35779,48796],[35806,49217],[35807,49217],
 [35831,45501],[35833,46064],[35856,41411],[35857,48796],[35860,42936],[35869,50046],
 [35873,50075],[35875,50075],[35876,50046],[35880,48035],[35883,4193],[35884,48445],
 [35905,39779],[35906,43685],[35907,40642],[35927,49217],[35949,44394],[35958,51006],
 [35964,51050],[35965,51050],[35966,51006],[36010,46241],[36011,47266],[36027,42362],
 [36028,43104],[36075,45745],[36076,47331],[36089,40824],[36114,42449],[36119,14514],
 [36121,51006],[36128,14523],[36131,50046],[36135,40870],[36136,45806],[36142,19848],
 [36144,47399],[36151,19857],[36156,19862],[36159,42494],[36160,50075],[36165,51050],
 [36170,14565],[36177,45847],[36178,47433],[36179,40914],[36180,26510],[36181,26510],
 [36182,26510],[36183,26510],[36184,26510],[36185,26510],[36186,26510],[36187,26510],
 [36188,26510],[36189,26510],[36190,26510],[36191,26510],[36192,26510],[36193,26510],
 [36194,26510],[36195,26510],[36196,26510],[36197,26510],[36198,26510],[36199,26510],
 [36200,26510],[36201,26510],[36202,26510],[36203,26510],[36204,26510],[36205,26510],
 [36206,26510],[36207,26510],[36208,26510],[36209,26510],[36210,26510],[36211,26510],
 [36212,26510],[36213,26510],[36214,26510],[36215,26510],[36216,26510],[36217,26510],
 [36218,26510],[36219,26510],[36220,26510],[36221,26510],[36222,26510],[36223,26510],
 [36224,26510],[36228,38331],[36229,38331],[36234,38557],[36236,38557],[36276,39424],
 [36277,39424],[36288,39779],[36290,39779],[36312,40055],[36314,40055],[36330,40642],
 [36334,40642],[36340,40824],[36341,40824],[36344,40870],[36345,40870],[36352,40914],
 [36353,40914],[36355,40055],[36363,41239],[36364,41239],[36369,41411],[36371,41411],
 [36395,38331],[36398,41850],[36400,41850],[36406,42109],[36407,42109],[36417,42362],
 [36418,42362],[36423,42449],[36424,42449],[36428,42494],[36429,42494],[36437,42593],
 [36441,42593],[36442,42761],[36444,42761],[36448,42936],[36454,42936],[36456,43104],
 [36458,43104],[36476,43330],[36478,43330],[36481,3756],[36488,43685],[36491,43685],
 [36514,44030],[36515,44030],[36527,44394],[36528,44394],[36532,8032],[36550,41850],
 [36552,42593],[36585,39424],[36586,43330],[36593,45501],[36596,45501],[36605,45745],
 [36606,45745],[36610,45806],[36612,45806],[36617,45847],[36618,45847],[36620,44030],
 [36621,38557],[36627,46064],[36632,46064],[36635,46241],[36637,46241],[36668,8168],
 [36700,47266],[36703,47266],[36704,47331],[36706,47331],[36710,47399],[36711,47399],
 [36716,47433],[36718,47433],[36719,41239],[36720,42761],[36732,6152],[36755,48035],
 [36756,48035],[36784,48445],[36789,48445],[36793,6213],[36809,42109],[36811,48796],
 [36814,48796],[36841,49217],[36842,49217],[36866,45501],[36868,46064],[36891,41411],
 [36892,48796],[36895,42936],[36904,50046],[36908,50075],[36910,50075],[36911,50046],
 [36915,48035],[36918,4193],[36919,48445],[36940,39779],[36941,43685],[36942,40642],
 [36962,49217],[36984,44394],[36993,51006],[36999,51050],[37000,51050],[37001,51006],
 [37045,46241],[37046,47266],[37062,42362],[37063,43104],[37110,45745],[37111,47331],
 [37124,40824],[37149,42449],[37154,14514],[37156,51006],[37163,14523],[37166,50046],
 [37170,40870],[37171,45806],[37177,19848],[37179,47399],[37186,19857],[37191,19862],
 [37194,42494],[37195,50075],[37200,51050],[37205,14565],[37212,45847],[37213,47433],
 [37214,40914],[37218,38331],[37219,38331],[37224,38557],[37226,38557],[37266,39424],
 [37267,39424],[37278,39779],[37280,39779],[37302,40055],[37304,40055],[37320,40642],
 [37324,40642],[37330,40824],[37331,40824],[37334,40870],[37335,40870],[37342,40914],
 [37343,40914],[37345,40055],[37353,41239],[37354,41239],[37359,41411],[37361,41411],
 [37385,38331],[37388,41850],[37390,41850],[37396,42109],[37397,42109],[37407,42362],
 [37408,42362],[37413,42449],[37414,42449],[37418,42494],[37419,42494],[37427,42593],
 [37431,42593],[37432,42761],[37434,42761],[37438,42936],[37444,42936],[37446,43104],
 [37448,43104],[37466,43330],[37468,43330],[37471,3756],[37478,43685],[37481,43685],
 [37504,44030],[37505,44030],[37517,44394],[37518,44394],[37522,8032],[37540,41850],
 [37542,42593],[37575,39424],[37576,43330],[37583,45501],[37586,45501],[37595,45745],
 [37596,45745],[37600,45806],[37602,45806],[37607,45847],[37608,45847],[37610,44030],
 [37611,38557],[37617,46064],[37622,46064],[37625,46241],[37627,46241],[37658,8168],
 [37690,47266],[37693,47266],[37694,47331],[37696,47331],[37700,47399],[37701,47399],
 [37706,47433],[37708,47433],[37709,41239],[37710,42761],[37722,6152],[37745,48035],
 [37746,48035],[37774,48445],[37779,48445],[37783,6213],[37799,42109],[37801,48796],
 [37804,48796],[37831,49217],[37832,49217],[37856,45501],[37858,46064],[37881,41411],
 [37882,48796],[37885,42936],[37894,50046],[37898,50075],[37900,50075],[37901,50046],
 [37905,48035],[37908,4193],[37909,48445],[37930,39779],[37931,43685],[37932,40642],
 [37952,49217],[37974,44394],[37983,51006],[37989,51050],[37990,51050],[37991,51006],
 [38035,46241],[38036,47266],[38052,42362],[38053,43104],[38100,45745],[38101,47331],
 [38114,40824],[38139,42449],[38144,14514],[38146,51006],[38153,14523],[38156,50046],
 [38160,40870],[38161,45806],[38167,19848],[38169,47399],[38176,19857],[38181,19862],
 [38184,42494],[38185,50075],[38190,51050],[38195,14565],[38202,45847],[38203,47433],
 [38204,40914],[38299,41239],[38300,41239],[38332,38331],[38333,38331],[38337,38331],
 [38339,38331],[38339,42761],[38340,38331],[38341,38331],[38341,42761],[38342,38331],
 [38342,42109],[38343,38331],[38343,42109],[38346,38331],[38348,38331],[38350,38331],
 [38356,38331],[38357,38331],[38358,38331],[38359,38331],[38359,42449],[38360,38331],
 [38360,42449],[38361,38331],[38362,38331],[38363,38331],[38364,38331],[38364,42494],
 [38365,38331],[38365,42494],[38366,38331],[38367,38331],[38368,38331],[38369,38331],
 [38370,38331],[38371,38331],[38372,38331],[38376,38331],[38378,38331],[38378,42761],
 [38379,38331],[38380,38331],[38380,42761],[38381,38331],[38381,42109],[38382,38331],
 [38382,42109],[38385,38331],[38387,38331],[38389,38331],[38395,38331],[38396,38331],
 [38397,38331],[38398,38331],[38398,42449],[38399,38331],[38399,42449],[38400,38331],
 [38401,38331],[38402,38331],[38403,38331],[38403,42494],[38404,38331],[38404,42494],
 [38405,38331],[38406,38331],[38407,38331],[38408,38331],[38409,38331],[38412,43330],
 [38413,38557],[38414,43330],[38415,38557],[38424,43685],[38427,43685],[38450,38557],
 [38450,44030],[38451,38557],[38451,44030],[38452,38557],[38452,44030],[38522,43330],
 [38541,45745],[38542,45745],[38546,45806],[38548,45806],[38553,45847],[38554,45847],
 [38556,38557],[38556,44030],[38558,38557],[38559,38557],[38560,38557],[38561,38557],
 [38562,38557],[38565,38557],[38567,38557],[38569,38557],[38575,38557],[38575,47331],
 [38576,38557],[38577,38557],[38577,47331],[38578,38557],[38579,38557],[38580,38557],
 [38581,38557],[38581,47399],[38582,38557],[38582,47399],[38583,38557],[38584,38557],
 [38585,38557],[38586,38557],[38587,38557],[38587,47433],[38588,38557],[38589,38557],
 [38589,47433],[38590,38557],[38590,44030],[38604,7828],[38604,8168],[38604,38205],
 [38623,38557],[38624,38557],[38625,38557],[38626,38557],[38627,38557],[38630,38557],
 [38632,38557],[38634,38557],[38640,38557],[38640,47331],[38641,38557],[38642,38557],
 [38642,47331],[38643,38557],[38644,38557],[38645,38557],[38646,38557],[38646,47399],
 [38647,38557],[38647,47399],[38648,38557],[38649,38557],[38650,38557],[38651,38557],
 [38652,38557],[38652,47433],[38653,38557],[38654,38557],[38654,47433],[38655,41239],
 [38656,38331],[38656,42761],[38668,5705],[38668,6152],[38668,38205],[38691,48035],
 [38692,48035],[38702,38707],[38702,39064],[38745,38331],[38745,42109],[38747,48796],
 [38750,48796],[38828,48796],[38840,50046],[38844,50075],[38846,50075],[38847,50046],
 [38851,48035],[38877,43685],[38899,38908],[38899,38949],[39046,45745],[39047,38557],
 [39047,47331],[39085,38331],[39085,42449],[39090,14514],[39099,14523],[39102,50046],
 [39107,45806],[39113,19848],[39115,38557],[39115,47399],[39122,19857],[39127,19862],
 [39130,38331],[39130,42494],[39131,50075],[39141,14565],[39148,45847],[39149,38557],
 [39149,47433],[39427,39424],[39428,39424],[39429,39424],[39430,39424],[39431,39424],
 [39434,39424],[39436,39424],[39440,39424],[39440,46241],[39441,39424],[39442,39424],
 [39442,46241],[39443,39424],[39444,39424],[39444,45745],[39445,39424],[39445,45745],
 [39446,39424],[39447,39424],[39448,39424],[39449,39424],[39449,45806],[39450,39424],
 [39451,39424],[39451,45806],[39452,39424],[39453,39424],[39454,39424],[39455,39424],
 [39456,39424],[39456,45847],[39457,39424],[39457,45847],[39458,39424],[39461,39424],
 [39462,39424],[39463,39424],[39464,39424],[39465,39424],[39468,39424],[39470,39424],
 [39474,39424],[39474,46241],[39475,39424],[39476,39424],[39476,46241],[39477,39424],
 [39478,39424],[39478,45745],[39479,39424],[39479,45745],[39480,39424],[39481,39424],
 [39482,39424],[39483,39424],[39483,45806],[39484,39424],[39485,39424],[39485,45806],
 [39486,39424],[39487,39424],[39488,39424],[39489,39424],[39490,39424],[39490,45847],
 [39491,39424],[39491,45847],[39492,39424],[39507,7828],[39507,8168],[39507,38205],
 [39539,47266],[39542,47266],[39543,47331],[39545,47331],[39549,47399],[39550,47399],
 [39555,47433],[39557,47433],[39565,39779],[39567,39779],[39594,39779],[39594,48035],
 [39595,39779],[39595,48035],[39597,39779],[39597,48035],[39623,48445],[39624,39779],
 [39626,39779],[39628,48445],[39635,39638],[39635,39978],[39650,48796],[39652,39779],
 [39653,48796],[39654,39779],[39658,39664],[39658,39906],[39679,39779],[39679,49217],
 [39680,39779],[39680,49217],[39681,39779],[39681,49217],[39731,48796],[39743,50046],
 [39747,50075],[39749,50075],[39750,50046],[39754,39779],[39754,48035],[39756,39779],
 [39756,48035],[39757,3507],[39757,4193],[39757,38205],[39758,48445],[39778,39779],
 [39778,49217],[39782,39779],[39783,39779],[39784,39779],[39785,39779],[39786,39779],
 [39787,39779],[39788,39779],[39789,39779],[39789,51006],[39790,39779],[39791,39779],
 [39792,39779],[39793,39779],[39794,39779],[39795,39779],[39795,51050],[39796,39779],
 [39796,51050],[39797,39779],[39797,51006],[39798,39779],[39799,39779],[39800,39779],
 [39801,39779],[39801,49217],[39825,39779],[39826,39779],[39827,39779],[39828,39779],
 [39829,39779],[39830,39779],[39831,39779],[39832,39779],[39832,51006],[39833,39779],
 [39834,39779],[39835,39779],[39836,39779],[39837,39779],[39838,39779],[39838,51050],
 [39839,39779],[39839,51050],[39840,39779],[39840,51006],[39841,39779],[39842,39779],
 [39843,39779],[39884,39424],[39884,46241],[39885,47266],[39949,39424],[39949,45745],
 [39950,47331],[39993,14514],[39995,39779],[39995,51006],[40002,14523],[40005,50046],
 [40010,39424],[40010,45806],[40016,19848],[40018,47399],[40025,19857],[40030,19862],
 [40034,50075],[40039,39779],[40039,51050],[40044,14565],[40051,39424],[40051,45847],
 [40052,47433],[40056,40055],[40057,40055],[40061,40055],[40066,40055],[40067,40055],
 [40072,40055],[40074,40055],[40076,40055],[40077,40055],[40077,43104],[40078,40055],
 [40079,40055],[40079,43104],[40080,40055],[40081,40055],[40081,40824],[40082,40055],
 [40082,40824],[40083,40055],[40084,40055],[40085,40055],[40085,40870],[40086,40055],
 [40086,40870],[40087,40055],[40088,40055],[40089,40055],[40090,40055],[40091,40055],
 [40092,40055],[40093,40055],[40093,40914],[40094,40055],[40094,40914],[40135,40055],
 [40136,40055],[40140,40055],[40145,40055],[40146,40055],[40151,40055],[40153,40055],
 [40155,40055],[40156,40055],[40156,43104],[40157,40055],[40158,40055],[40158,43104],
 [40159,40055],[40160,40055],[40160,40824],[40161,40055],[40161,40824],[40162,40055],
 [40163,40055],[40164,40055],[40164,40870],[40165,40055],[40165,40870],[40166,40055],
 [40167,40055],[40168,40055],[40169,40055],[40170,40055],[40171,40055],[40172,40055],
 [40172,40914],[40173,40055],[40173,40914],[40188,40642],[40188,43685],[40191,40642],
 [40191,43685],[40192,40642],[40192,43685],[40198,40824],[40199,40824],[40202,40870],
 [40203,40870],[40210,40914],[40211,40914],[40214,44030],[40215,44030],[40225,40642],
 [40227,44394],[40228,44394],[40229,40642],[40235,40824],[40236,40824],[40239,40870],
 [40240,40870],[40247,40914],[40248,40914],[40271,40824],[40272,40824],[40275,40870],
 [40276,40870],[40283,40914],[40284,40914],[40320,44030],[40335,46241],[40337,46241],
 [40340,40824],[40341,40824],[40344,40870],[40345,40870],[40352,40914],[40353,40914],
 [40363,40642],[40367,40642],[40372,40377,40870],[40372,40378,40870],[40372,40814,40870],
 [40372,40815,40870],[40372,40870],[40372,46894,40870],[40372,51986,40870],[40373,40824],
 [40374,40824],[40385,40914],[40386,40914],[40432,5705],[40432,6152],[40432,38205],
 [40436,40824],[40437,40824],[40440,40870],[40441,40870],[40448,40914],[40449,40914],
 [40513,40642],[40517,40642],[40527,40870],[40528,40870],[40535,40914],[40536,40914],
 [40540,40642],[40541,49217],[40542,49217],[40544,40642],[40554,40870],[40555,40870],
 [40562,40914],[40563,40914],[40576,40824],[40577,40824],[40580,40870],[40581,40870],
 [40588,40914],[40589,40914],[40618,3507],[40618,4193],[40618,38205],[40625,40824],
 [40626,40824],[40629,40870],[40630,40870],[40637,40914],[40638,40914],[40639,40642],
 [40641,40642],[40641,43685],[40643,40642],[40644,40642],[40645,40642],[40646,40642],
 [40647,40642],[40648,40642],[40648,40824],[40649,40642],[40649,40824],[40650,40642],
 [40651,40642],[40652,40642],[40652,40870],[40653,40642],[40653,40870],[40654,40642],
 [40655,40642],[40656,40642],[40657,40642],[40658,40642],[40659,40642],[40660,40642],
 [40660,40914],[40661,40642],[40661,40914],[40662,49217],[40664,40642],[40670,40824],
 [40671,40824],[40674,40870],[40675,40870],[40682,40914],[40683,40914],[40684,44394],
 [40691,40824],[40692,40824],[40693,51006],[40695,40870],[40696,40870],[40699,51050],
 [40700,51050],[40701,51006],[40703,40914],[40704,40914],[40705,40642],[40705,43685],
 [40711,40824],[40712,40824],[40715,40870],[40716,40870],[40723,40914],[40724,40914],
 [40725,40642],[40726,40642],[40727,40642],[40728,40642],[40729,40642],[40730,40642],
 [40730,40824],[40731,40642],[40731,40824],[40732,40642],[40733,40642],[40734,40642],
 [40734,40870],[40735,40642],[40735,40870],[40736,40642],[40737,40642],[40738,40642],
 [40739,40642],[40740,40642],[40741,40642],[40742,40642],[40742,40914],[40743,40642],
 [40743,40914],[40745,46241],[40747,40752,40870],[40747,40753,40870],[40747,40870],
 [40747,51534,40870],[40748,40824],[40749,40824],[40760,40914],[40761,40914],[40763,40055],
 [40763,43104],[40765,40824],[40766,40824],[40769,40870],[40770,40870],[40777,40914],
 [40778,40914],[40781,40824],[40782,40824],[40785,40870],[40786,40870],[40793,40914],
 [40794,40914],[40796,40824],[40797,40824],[40800,40870],[40801,40870],[40808,40914],
 [40809,40914],[40822,40914],[40823,40914],[40825,40824],[40826,40824],[40827,40824],
 [40827,40870],[40828,40824],[40828,40870],[40829,40824],[40830,40824],[40831,40824],
 [40832,40824],[40833,40824],[40834,40824],[40835,40824],[40835,40914],[40836,40824],
 [40836,40914],[40837,40824],[40838,40824],[40839,40824],[40839,40870],[40840,40824],
 [40840,40870],[40841,40824],[40842,40824],[40843,40824],[40844,40824],[40845,40824],
 [40846,40824],[40847,40824],[40847,40914],[40848,40824],[40848,40914],[40854,14514],
 [40856,51006],[40858,40914],[40859,40914],[40863,14523],[40868,40914],[40869,40914],
 [40872,40870],[40873,40870],[40874,40870],[40875,40870],[40876,40870],[40877,19848],
 [40877,19857],[40877,40870],[40877,40914],[40878,19848],[40878,19857],[40878,40870],
 [40878,40914],[40880,40870],[40881,40870],[40882,40870],[40883,40870],[40884,40870],
 [40885,19848],[40885,19857],[40885,40870],[40885,40914],[40886,19848],[40886,19857],
 [40886,40870],[40886,40914],[40891,19862],[40892,40914],[40893,40914],[40900,51050],
 [40905,14565],[40907,40914],[40908,40914],[40910,40914],[40911,40914],[40955,40055],
 [40956,40055],[40960,40055],[40965,40055],[40966,40055],[40971,40055],[40973,40055],
 [40975,40055],[40976,40055],[40976,43104],[40977,40055],[40978,40055],[40978,43104],
 [40979,40055],[40980,40055],[40980,40824],[40981,40055],[40981,40824],[40982,40055],
 [40983,40055],[40984,40055],[40984,40870],[40985,40055],[40985,40870],[40986,40055],
 [40987,40055],[40988,40055],[40989,40055],[40990,40055],[40991,40055],[40992,40055],
 [40992,40914],[40993,40055],[40993,40914],[41000,3507],[41000,3756],[41000,3930],
 [41000,38591],[41000,41069],[41000,41239],[41000,43297],[41000,43330],[41000,44695],
 [41000,44696],[41001,3507],[41001,3756],[41001,3930],[41001,38591],[41001,41069],
 [41001,41239],[41001,43297],[41001,43330],[41001,44695],[41001,44696],[41006,41411],
 [41006,43685],[41008,41411],[41008,43685],[41011,41411],[41011,43685],[41034,44030],
 [41035,44030],[41037,41239],[41038,41239],[41043,41411],[41045,41411],[41047,44394],
 [41048,44394],[41052,7875],[41052,8032],[41052,41049],[41052,41547],[41140,44030],
 [41142,41239],[41143,41239],[41155,46241],[41157,46241],[41181,41411],[41183,41411],
 [41188,7875],[41188,8168],[41188,41187],[41188,41545],[41192,41205],[41192,41642],
 [41207,41239],[41208,41239],[41220,47266],[41223,47266],[41224,47331],[41226,47331],
 [41230,47399],[41231,47399],[41236,47433],[41238,47433],[41241,41239],[41242,41239],
 [41243,41239],[41247,41239],[41248,41239],[41249,41239],[41251,41239],[41252,5705],
 [41252,6152],[41252,6183],[41252,39193],[41252,39572],[41252,39601],[41252,39602],
 [41252,41239],[41252,42362],[41252,47993],[41254,41239],[41255,41239],[41256,41239],
 [41257,41239],[41258,41239],[41259,41239],[41260,41239],[41261,41239],[41262,41239],
 [41263,41239],[41264,41239],[41265,41239],[41266,41239],[41267,41239],[41268,41239],
 [41269,41239],[41271,41239],[41272,41239],[41273,41239],[41277,41239],[41278,41239],
 [41279,41239],[41281,41239],[41282,5705],[41282,6152],[41282,6183],[41282,39193],
 [41282,39572],[41282,39601],[41282,39602],[41282,41239],[41282,42362],[41282,47993],
 [41284,41239],[41285,41239],[41286,41239],[41287,41239],[41288,41239],[41289,41239],
 [41290,41239],[41291,41239],[41292,41239],[41293,41239],[41294,41239],[41295,41239],
 [41296,41239],[41297,41239],[41298,41239],[41299,41239],[41313,5705],[41313,6213],
 [41313,39193],[41331,41411],[41331,48796],[41333,41411],[41333,48796],[41334,41411],
 [41334,48796],[41358,41411],[41360,41411],[41361,49217],[41362,49217],[41367,41373],
 [41367,41604],[41412,41411],[41412,48796],[41414,41411],[41414,43685],[41416,41411],
 [41417,41411],[41418,41411],[41419,41411],[41420,41411],[41421,41411],[41422,41411],
 [41423,41411],[41424,41411],[41424,50046],[41425,41411],[41426,41411],[41427,41411],
 [41428,41411],[41428,50075],[41429,41411],[41430,41411],[41430,50075],[41431,41411],
 [41431,50046],[41432,41411],[41433,41411],[41434,41411],[41438,3507],[41438,4193],
 [41438,41069],[41459,41411],[41459,48796],[41461,41411],[41461,43685],[41463,41411],
 [41464,41411],[41465,41411],[41466,41411],[41467,41411],[41468,41411],[41469,41411],
 [41470,41411],[41471,41411],[41471,50046],[41472,41411],[41473,41411],[41474,41411],
 [41475,41411],[41475,50075],[41476,41411],[41477,41411],[41477,50075],[41478,41411],
 [41478,50046],[41479,41411],[41480,41411],[41481,41411],[41482,49217],[41504,44394],
 [41513,51006],[41519,51050],[41520,51050],[41521,51006],[41565,46241],[41566,47266],
 [41583,40055],[41583,43104],[41631,47331],[41644,40055],[41644,40824],[41674,14514],
 [41676,51006],[41683,14523],[41686,41411],[41686,50046],[41690,40055],[41690,40870],
 [41697,19848],[41699,47399],[41706,19857],[41711,19862],[41715,41411],[41715,50075],
 [41720,51050],[41725,14565],[41733,47433],[41734,40055],[41734,40914],[41735,38331],
 [41736,38331],[41740,38331],[41742,38331],[41742,42761],[41743,38331],[41744,38331],
 [41744,42761],[41745,38331],[41745,42109],[41746,38331],[41746,42109],[41749,38331],
 [41751,38331],[41753,38331],[41759,38331],[41760,38331],[41761,38331],[41762,38331],
 [41762,42449],[41763,38331],[41763,42449],[41764,38331],[41765,38331],[41766,38331],
 [41767,38331],[41767,42494],[41768,38331],[41768,42494],[41769,38331],[41770,38331],
 [41771,38331],[41772,38331],[41773,38331],[41775,41850],[41776,43330],[41777,41850],
 [41778,43330],[41781,3677],[41781,3756],[41781,41779],[41781,41988],[41783,42109],
 [41784,42109],[41788,43685],[41791,43685],[41794,42362],[41795,42362],[41800,42449],
 [41801,42449],[41805,42494],[41806,42494],[41812,41850],[41812,44030],[41814,41850],
 [41814,44030],[41815,41850],[41815,44030],[41820,42109],[41821,42109],[41831,7828],
 [41831,8032],[41831,8507],[41831,40707],[41831,42193],[41831,42362],[41831,44307],
 [41831,44394],[41831,49887],[41831,49888],[41832,7828],[41832,8032],[41832,8507],
 [41832,40707],[41832,42193],[41832,42362],[41832,44307],[41832,44394],[41832,49887],
 [41832,49888],[41837,42449],[41838,42449],[41842,42494],[41843,42494],[41851,41850],
 [41851,44030],[41853,41850],[41854,41850],[41855,41850],[41856,41850],[41856,42109],
 [41857,41850],[41857,42109],[41860,41850],[41862,41850],[41864,41850],[41870,41850],
 [41871,41850],[41872,41850],[41873,41850],[41873,42449],[41874,41850],[41874,42449],
 [41875,41850],[41876,41850],[41877,41850],[41878,41850],[41878,42494],[41879,41850],
 [41879,42494],[41880,41850],[41881,41850],[41882,41850],[41883,41850],[41884,41850],
 [41886,43330],[41891,42109],[41892,42109],[41902,42362],[41903,42362],[41905,45745],
 [41906,45745],[41908,42449],[41909,42449],[41910,45806],[41912,45806],[41913,42494],
 [41914,42494],[41917,45847],[41918,45847],[41920,41850],[41920,44030],[41922,41850],
 [41923,41850],[41924,41850],[41925,41850],[41925,42109],[41926,41850],[41926,42109],
 [41929,41850],[41931,41850],[41933,41850],[41939,41850],[41940,41850],[41941,41850],
 [41942,41850],[41942,42449],[41943,41850],[41943,42449],[41944,41850],[41945,41850],
 [41946,41850],[41947,41850],[41947,42494],[41948,41850],[41948,42494],[41949,41850],
 [41950,41850],[41951,41850],[41952,41850],[41953,41850],[41958,42109],[41959,42109],
 [41968,7828],[41968,8168],[41968,42193],[41969,42362],[41970,42362],[41975,42449],
 [41976,42449],[41980,42494],[41981,42494],[42020,38331],[42020,42761],[42021,42109],
 [42022,42109],[42032,5705],[42032,6152],[42032,6183],[42032,39193],[42032,39572],
 [42032,39601],[42032,39602],[42032,41239],[42032,42362],[42032,47993],[42033,5705],
 [42033,6152],[42033,6183],[42033,39193],[42033,39572],[42033,39601],[42033,39602],
 [42033,41239],[42033,42362],[42033,47993],[42038,42449],[42039,42449],[42043,42494],
 [42044,42494],[42051,42109],[42052,42109],[42055,48035],[42056,48035],[42068,42449],
 [42069,42449],[42073,42494],[42074,42494],[42080,42109],[42081,42109],[42084,48445],
 [42089,48445],[42093,5705],[42093,6213],[42093,39193],[42097,42449],[42098,42449],
 [42102,42494],[42103,42494],[42110,42109],[42112,42109],[42113,42109],[42116,42109],
 [42117,42109],[42118,42109],[42119,42109],[42119,42362],[42120,42109],[42120,42362],
 [42121,42109],[42122,42109],[42125,42109],[42125,42449],[42126,42109],[42126,42449],
 [42127,42109],[42128,42109],[42129,42109],[42130,42109],[42130,42494],[42131,42109],
 [42131,42494],[42132,42109],[42133,42109],[42134,42109],[42135,42109],[42136,42109],
 [42137,42109],[42139,42109],[42140,42109],[42143,42109],[42144,42109],[42145,42109],
 [42146,42109],[42146,42362],[42147,42109],[42147,42362],[42148,42109],[42149,42109],
 [42152,42109],[42152,42449],[42153,42109],[42153,42449],[42154,42109],[42155,42109],
 [42156,42109],[42157,42109],[42157,42494],[42158,42109],[42158,42494],[42159,42109],
 [42160,42109],[42161,42109],[42162,42109],[42163,42109],[42172,42362],[42173,42362],
 [42178,42449],[42179,42449],[42183,42494],[42184,42494],[42215,48035],[42216,42227,42449],
 [42216,42228,42449],[42216,42272,42449],[42216,42273,42449],[42216,42449],
 [42216,50305,42449],[42216,50789,42449],[42218,3677],[42218,4193],[42218,41994],
 [42218,41998],[42219,48445],[42221,42362],[42222,42362],[42232,42494],[42233,42494],
 [42241,43685],[42244,42362],[42245,42362],[42250,42449],[42251,42449],[42255,42494],
 [42256,42494],[42263,42277,42494],[42263,42278,42494],[42263,42318,42494],
 [42263,42319,42494],[42263,42494],[42263,50834,42494],[42263,51234,42494],[42266,42362],
 [42267,42362],[42313,42449],[42314,42449],[42326,42362],[42327,42362],[42332,42449],
 [42333,42449],[42337,42494],[42338,42494],[42350,42449],[42351,42449],[42355,42494],
 [42356,42494],[42364,42362],[42365,42362],[42366,42362],[42367,42362],[42367,42449],
 [42368,42362],[42368,42449],[42369,42362],[42370,42362],[42371,42362],[42372,42362],
 [42372,42494],[42373,42362],[42373,42494],[42374,42362],[42375,42362],[42376,42362],
 [42377,42362],[42378,42362],[42380,42362],[42381,42362],[42382,42362],[42383,42362],
 [42383,42449],[42384,42362],[42384,42449],[42385,42362],[42386,42362],[42387,42362],
 [42388,42362],[42388,42494],[42389,42362],[42389,42494],[42390,42362],[42391,42362],
 [42392,42362],[42393,42362],[42394,42362],[42398,42449],[42399,42449],[42403,42494],
 [42404,42494],[42410,45745],[42412,42449],[42413,42449],[42417,42494],[42418,42494],
 [42425,42449],[42426,42449],[42430,42494],[42431,42494],[42437,42449],[42438,42449],
 [42442,42494],[42443,42494],[42452,42449],[42453,14514],[42453,14523],[42453,42449],
 [42453,42494],[42454,14514],[42454,14523],[42454,42449],[42454,42494],[42455,42449],
 [42457,42449],[42458,42449],[42459,42449],[42462,42449],[42463,14514],[42463,14523],
 [42463,42449],[42463,42494],[42464,14514],[42464,14523],[42464,42449],[42464,42494],
 [42465,42449],[42467,42449],[42468,42449],[42469,42449],[42471,45806],[42472,42494],
 [42473,42494],[42477,19848],[42480,42494],[42481,42494],[42486,19857],[42487,42494],
 [42488,42494],[42491,19862],[42496,42494],[42497,42494],[42501,42494],[42502,42494],
 [42505,14565],[42512,45847],[42516,42593],[42517,43330],[42519,43330],[42520,42593],
 [42521,42761],[42522,3714],[42522,3756],[42522,42518],[42522,42664],[42523,42761],
 [42527,42936],[42533,42936],[42539,19106],[42539,19131],[42553,42593],[42557,42593],
 [42562,13796],[42562,13806],[42564,42936],[42568,44394],[42569,44394],[42570,42936],
 [42572,43104],[42573,7950],[42573,8032],[42573,42566],[42573,42986],[42574,43104],
 [42592,42593],[42594,42593],[42594,42761],[42595,42593],[42596,42593],[42596,42761],
 [42597,42593],[42598,42593],[42601,42593],[42603,42593],[42605,42593],[42611,42593],
 [42611,47331],[42612,42593],[42613,42593],[42613,47331],[42614,42593],[42615,42593],
 [42616,42593],[42617,42593],[42617,47399],[42618,42593],[42618,47399],[42619,42593],
 [42620,42593],[42621,42593],[42622,42593],[42623,42593],[42623,47433],[42624,42593],
 [42625,42593],[42625,47433],[42627,43330],[42629,42761],[42631,42761],[42643,43104],
 [42645,43104],[42646,45745],[42647,45745],[42651,45806],[42653,45806],[42658,45847],
 [42659,45847],[42695,42593],[42702,42936],[42708,42936],[42709,7950],[42709,8168],
 [42709,42704],[42709,42984],[42710,43104],[42712,43104],[42713,19111],[42713,19130],
 [42728,42593],[42728,42761],[42729,42593],[42730,42593],[42730,42761],[42731,42593],
 [42732,42593],[42735,42593],[42737,42593],[42739,42593],[42745,42593],[42745,47331],
 [42746,42593],[42747,42593],[42747,47331],[42748,42593],[42749,42593],[42750,42593],
 [42751,42593],[42751,47399],[42752,42593],[42752,47399],[42753,42593],[42754,42593],
 [42755,42593],[42756,42593],[42757,42593],[42757,47433],[42758,42593],[42759,42593],
 [42759,47433],[42762,42761],[42763,42761],[42764,42761],[42768,42761],[42769,42761],
 [42770,42761],[42772,42761],[42773,6152],[42773,6213],[42773,42761],[42773,43104],
 [42774,42761],[42775,6152],[42775,6213],[42775,42761],[42775,43104],[42776,42761],
 [42777,42761],[42778,42761],[42779,42761],[42780,42761],[42781,42761],[42782,42761],
 [42783,42761],[42784,42761],[42785,42761],[42786,42761],[42787,42761],[42788,42761],
 [42789,42761],[42790,42761],[42803,43104],[42805,43104],[42821,42761],[42822,42761],
 [42823,42761],[42827,42761],[42828,42761],[42829,42761],[42831,42761],[42832,6152],
 [42832,6213],[42832,42761],[42832,43104],[42833,42761],[42834,6152],[42834,6213],
 [42834,42761],[42834,43104],[42835,42761],[42836,42761],[42837,42761],[42838,42761],
 [42839,42761],[42840,42761],[42841,42761],[42842,42761],[42843,42761],[42844,42761],
 [42845,42761],[42846,42761],[42847,42761],[42848,42761],[42849,42761],[42850,38331],
 [42850,42109],[42852,42936],[42852,48796],[42855,42936],[42855,48796],[42858,42936],
 [42858,48796],[42860,43104],[42862,43104],[42879,42936],[42882,49217],[42883,49217],
 [42885,42936],[42887,43104],[42889,43104],[42913,43104],[42915,43104],[42933,42936],
 [42933,48796],[42935,42936],[42937,42936],[42938,42936],[42938,43104],[42939,42936],
 [42940,42936],[42940,43104],[42941,42936],[42942,42936],[42943,42936],[42944,42936],
 [42945,42936],[42945,50046],[42946,42936],[42947,42936],[42948,42936],[42949,42936],
 [42949,50075],[42950,42936],[42951,42936],[42951,50075],[42952,42936],[42952,50046],
 [42953,42936],[42954,42936],[42955,42936],[42959,3714],[42959,4193],[42959,42670],
 [42959,42674],[42962,43104],[42964,43104],[43003,49217],[43004,13811],[43004,13813],
 [43005,42936],[43005,48796],[43007,43104],[43009,43104],[43025,44394],[43028,43104],
 [43030,43104],[43034,51006],[43040,51050],[43041,51050],[43042,51006],[43046,42936],
 [43066,42936],[43067,42936],[43067,43104],[43068,42936],[43069,42936],[43069,43104],
 [43070,42936],[43071,42936],[43072,42936],[43073,42936],[43074,42936],[43074,50046],
 [43075,42936],[43076,42936],[43077,42936],[43078,42936],[43078,50075],[43079,42936],
 [43080,42936],[43080,50075],[43081,42936],[43081,50046],[43082,42936],[43083,42936],
 [43084,42936],[43105,43104],[43106,43104],[43107,43104],[43108,43104],[43109,43104],
 [43110,43104],[43111,43104],[43112,43104],[43113,43104],[43114,43104],[43115,43104],
 [43116,43104],[43117,43104],[43118,43104],[43119,43104],[43136,43104],[43137,43104],
 [43138,43104],[43139,43104],[43140,43104],[43141,43104],[43142,43104],[43143,43104],
 [43144,43104],[43145,43104],[43146,43104],[43147,43104],[43148,43104],[43149,43104],
 [43150,43104],[43151,45745],[43152,42593],[43152,47331],[43165,40055],[43165,40824],
 [43190,38331],[43190,42449],[43195,14514],[43197,51006],[43204,14523],[43207,42936],
 [43207,50046],[43211,40055],[43211,40870],[43212,45806],[43218,19848],[43220,42593],
 [43220,47399],[43227,19857],[43232,19862],[43235,38331],[43235,42494],[43236,42936],
 [43236,50075],[43241,51050],[43246,14565],[43253,45847],[43254,42593],[43254,47433],
 [43255,40055],[43255,40914],[43294,41850],[43296,42593],[43315,43326],[43315,45174],
 [43333,3507],[43333,3756],[43333,3930],[43333,38591],[43333,41069],[43333,41239],
 [43333,43297],[43333,43330],[43333,44695],[43333,44696],[43334,43330],[43335,43330],
 [43336,43330],[43341,43330],[43344,43330],[43345,7828],[43345,7996],[43345,8168],
 [43345,40193],[43345,40196],[43345,40287],[43345,40371],[43345,43330],[43345,43643],
 [43345,47266],[43346,43330],[43347,43330],[43349,43330],[43349,45745],[43350,43330],
 [43350,45745],[43351,43330],[43352,43330],[43353,43330],[43354,43330],[43354,45806],
 [43355,43330],[43356,43330],[43356,45806],[43357,43330],[43358,43330],[43359,43330],
 [43360,43330],[43361,43330],[43361,45847],[43362,43330],[43362,45847],[43363,43330],
 [43365,38557],[43367,3714],[43367,3756],[43367,42518],[43367,42664],[43379,46241],
 [43381,46241],[43400,3507],[43400,3756],[43400,3930],[43400,38591],[43400,41069],
 [43400,41239],[43400,43297],[43400,43330],[43400,44695],[43400,44696],[43401,43330],
 [43402,43330],[43403,43330],[43408,43330],[43411,43330],[43412,7828],[43412,7996],
 [43412,8168],[43412,40193],[43412,40196],[43412,40287],[43412,40371],[43412,43330],
 [43412,43643],[43412,47266],[43413,43330],[43414,43330],[43416,43330],[43416,45745],
 [43417,43330],[43417,45745],[43418,43330],[43419,43330],[43420,43330],[43421,43330],
 [43421,45806],[43422,43330],[43423,43330],[43423,45806],[43424,43330],[43425,43330],
 [43426,43330],[43427,43330],[43428,43330],[43428,45847],[43429,43330],[43429,45847],
 [43430,43330],[43432,3677],[43432,3756],[43432,41779],[43432,41988],[43439,43685],
 [43442,43685],[43448,47331],[43449,43454,47399],[43449,43455,47399],[43449,43923,47399],
 [43449,47348,47399],[43449,47349,47399],[43449,47399],[43449,52073,47399],[43450,47331],
 [43460,47433],[43462,47433],[43463,3507],[43463,3756],[43463,3930],[43463,38591],
 [43463,41069],[43463,41239],[43463,43297],[43463,43330],[43463,44695],[43463,44696],
 [43464,42761],[43470,43685],[43473,43685],[43476,5705],[43476,6152],[43476,39313],
 [43495,3756],[43496,3756],[43497,3507],[43497,3756],[43497,44904],[43498,3507],
 [43498,3756],[43498,44904],[43499,3756],[43499,4193],[43499,43685],[43499,48035],
 [43500,3756],[43500,4193],[43500,43685],[43500,48035],[43501,3756],[43502,3507],
 [43502,3756],[43502,38921],[43503,3756],[43503,4193],[43503,43685],[43503,48035],
 [43504,3507],[43504,3756],[43504,38921],[43505,3507],[43505,3756],[43505,45084],
 [43506,3507],[43506,3756],[43506,45084],[43509,3756],[43510,3756],[43511,3756],
 [43512,3756],[43513,3756],[43514,3756],[43515,3756],[43516,3756],[43517,3756],
 [43518,3756],[43519,3756],[43520,3756],[43521,3756],[43522,3756],[43523,3756],
 [43528,48445],[43529,43685],[43532,43685],[43533,48445],[43553,42109],[43555,48796],
 [43557,43685],[43558,48796],[43560,43685],[43584,43685],[43585,49217],[43586,49217],
 [43587,43685],[43635,41411],[43635,43685],[43636,48796],[43638,41411],[43638,43685],
 [43639,42936],[43648,50046],[43652,50075],[43654,50075],[43655,50046],[43659,3756],
 [43659,4193],[43659,43685],[43659,48035],[43662,3756],[43662,4193],[43662,43685],
 [43662,48035],[43663,48445],[43683,43685],[43686,40642],[43686,43685],[43687,43685],
 [43689,43685],[43691,43685],[43692,43685],[43693,43685],[43694,43685],[43695,43685],
 [43696,43685],[43697,43685],[43698,43685],[43699,43685],[43700,43685],[43701,43685],
 [43702,43685],[43703,43685],[43704,43685],[43705,43685],[43706,49217],[43707,43685],
 [43737,51006],[43743,51050],[43744,51050],[43745,51006],[43749,40642],[43749,43685],
 [43750,43685],[43752,43685],[43754,43685],[43755,43685],[43756,43685],[43757,43685],
 [43758,43685],[43759,43685],[43760,43685],[43761,43685],[43762,43685],[43763,43685],
 [43764,43685],[43765,43685],[43766,43685],[43767,43685],[43768,43685],[43789,46241],
 [43806,42362],[43854,43330],[43854,45745],[43855,47331],[43868,40824],[43873,47399],
 [43878,43326],[43878,45174],[43893,42449],[43898,14514],[43900,51006],[43907,14523],
 [43910,50046],[43914,40870],[43915,43330],[43915,45806],[43921,19848],[43930,19857],
 [43935,19862],[43938,42494],[43939,50075],[43944,51050],[43949,14565],[43956,43330],
 [43956,45847],[43957,47433],[43958,40914],[43960,41850],[43960,44030],[43961,41850],
 [43961,44030],[43962,42593],[43973,44394],[43974,44394],[43978,7828],[43978,8032],
 [43978,44904],[44013,7828],[44013,8032],[44013,40287],[44015,45745],[44016,45745],
 [44020,45806],[44022,45806],[44027,45847],[44028,45847],[44031,38557],[44031,44030],
 [44033,44030],[44035,44030],[44036,44030],[44038,44030],[44039,44030],[44041,44030],
 [44045,8032],[44045,8168],[44045,44030],[44045,46241],[44046,44030],[44047,8032],
 [44047,8168],[44047,44030],[44047,46241],[44048,44030],[44049,44030],[44050,44030],
 [44051,44030],[44052,44030],[44053,44030],[44054,44030],[44055,44030],[44056,44030],
 [44057,44030],[44058,44030],[44059,44030],[44060,44030],[44061,44030],[44062,44030],
 [44063,44030],[44064,38557],[44064,44030],[44066,44030],[44068,44030],[44069,44030],
 [44071,44030],[44072,44030],[44074,44030],[44078,8032],[44078,8168],[44078,44030],
 [44078,46241],[44079,44030],[44080,8032],[44080,8168],[44080,44030],[44080,46241],
 [44081,44030],[44082,44030],[44083,44030],[44084,44030],[44085,44030],[44086,44030],
 [44087,44030],[44088,44030],[44089,44030],[44090,44030],[44091,44030],[44092,44030],
 [44093,44030],[44094,44030],[44095,44030],[44096,44030],[44110,47266],[44112,7828],
 [44112,8032],[44112,40287],[44113,47266],[44114,47331],[44116,47331],[44120,47399],
 [44121,47399],[44126,47433],[44128,47433],[44129,41239],[44138,44394],[44139,44394],
 [44142,5705],[44142,6152],[44142,39313],[44143,7828],[44143,8032],[44143,47575],
 [44165,48035],[44166,48035],[44168,44394],[44169,44394],[44219,42109],[44221,48796],
 [44224,48796],[44225,44394],[44226,44394],[44230,8032],[44248,44318,50075],
 [44248,44320,50075],[44248,44605,50075],[44248,49163,50075],[44248,49165,50075],
 [44248,49450,50075],[44248,50075],[44251,44394],[44251,49217],[44252,44394],[44252,49217],
 [44253,44394],[44253,49217],[44254,44450],[44254,49295],[44257,8032],[44269,50075],
 [44270,44450],[44270,49295],[44283,7828],[44283,8032],[44283,44904],[44301,41411],
 [44302,48796],[44305,42936],[44314,50046],[44321,50046],[44325,48035],[44327,3507],
 [44327,3794],[44327,4193],[44327,38455],[44327,38460],[44327,38724],[44327,38921],
 [44327,43965],[44327,44394],[44327,48445],[44328,3507],[44328,3794],[44328,4193],
 [44328,38455],[44328,38460],[44328,38724],[44328,38921],[44328,43965],[44328,44394],
 [44328,48445],[44332,7828],[44332,8032],[44332,47575],[44352,40642],[44355,7950],
 [44355,8032],[44355,42566],[44355,42986],[44372,44394],[44372,49217],[44373,44394],
 [44373,49217],[44377,8032],[44396,44394],[44398,7828],[44398,8032],[44398,8507],
 [44398,40707],[44398,42193],[44398,42362],[44398,44307],[44398,44394],[44398,49887],
 [44398,49888],[44399,44394],[44400,44394],[44401,44394],[44402,44394],[44403,44394],
 [44403,51006],[44404,44394],[44405,44394],[44406,44394],[44407,44394],[44408,44394],
 [44409,44394],[44409,51050],[44410,44394],[44410,51050],[44411,44394],[44411,51006],
 [44412,44394],[44413,44394],[44414,44394],[44416,44394],[44418,7828],[44418,8032],
 [44418,8507],[44418,40707],[44418,42193],[44418,42362],[44418,44307],[44418,44394],
 [44418,49887],[44418,49888],[44419,44394],[44420,44394],[44421,44394],[44422,44394],
 [44423,44394],[44423,51006],[44424,44394],[44425,44394],[44426,44394],[44427,44394],
 [44428,44394],[44429,44394],[44429,51050],[44430,44394],[44430,51050],[44431,44394],
 [44431,51006],[44432,44394],[44433,44394],[44434,44394],[44437,7875],[44437,8032],
 [44437,41049],[44437,41547],[44455,8032],[44455,8168],[44455,44030],[44455,46241],
 [44456,47266],[44472,7828],[44472,8032],[44472,8507],[44472,40707],[44472,42193],
 [44472,42362],[44472,44307],[44472,44394],[44472,49887],[44472,49888],[44473,43104],
 [44490,8032],[44491,8032],[44492,8032],[44493,8032],[44494,8032],[44495,8032],
 [44496,8032],[44497,8032],[44498,8032],[44499,8032],[44500,8032],[44501,8032],
 [44502,8032],[44503,8032],[44504,8032],[44520,45745],[44521,47331],[44534,40824],
 [44559,42449],[44564,14514],[44566,44394],[44566,51006],[44573,14523],[44576,50046],
 [44580,40870],[44581,45806],[44587,19848],[44589,47399],[44596,19857],[44601,19862],
 [44604,42494],[44610,44394],[44610,51050],[44615,14565],[44622,45847],[44623,47433],
 [44624,40914],[44660,41850],[44660,44030],[44662,41850],[44663,41850],[44664,41850],
 [44665,41850],[44665,42109],[44666,41850],[44666,42109],[44669,41850],[44671,41850],
 [44673,41850],[44679,41850],[44680,41850],[44681,41850],[44682,41850],[44682,42449],
 [44683,41850],[44683,42449],[44684,41850],[44685,41850],[44686,41850],[44687,41850],
 [44687,42494],[44688,41850],[44688,42494],[44689,41850],[44690,41850],[44691,41850],
 [44692,41850],[44693,41850],[44694,42593],[44727,42593],[44727,42761],[44728,42593],
 [44729,42593],[44729,42761],[44730,42593],[44731,42593],[44734,42593],[44736,42593],
 [44738,42593],[44744,42593],[44744,47331],[44745,42593],[44746,42593],[44746,47331],
 [44747,42593],[44748,42593],[44749,42593],[44750,42593],[44750,47399],[44751,42593],
 [44751,47399],[44752,42593],[44753,42593],[44754,42593],[44755,42593],[44756,42593],
 [44756,47433],[44757,42593],[44758,42593],[44758,47433],[44760,42593],[44760,42761],
 [44824,48445],[44829,48445],[44833,5705],[44833,6213],[44833,44904],[44849,41850],
 [44849,42109],[44881,49217],[44882,49217],[44956,44972],[44956,45017],[44959,48445],
 [45002,49217],[45024,44394],[45033,51006],[45039,51050],[45040,51050],[45041,51006],
 [45151,42593],[45151,47331],[45164,40824],[45189,41850],[45189,42449],[45194,14514],
 [45196,51006],[45203,14523],[45210,40870],[45217,19848],[45219,42593],[45219,47399],
 [45226,19857],[45231,19862],[45234,41850],[45234,42494],[45240,51050],[45245,14565],
 [45253,42593],[45253,47433],[45254,40914],[45257,39424],[45258,39424],[45259,39424],
 [45260,39424],[45261,39424],[45264,39424],[45266,39424],[45270,39424],[45270,46241],
 [45271,39424],[45272,39424],[45272,46241],[45273,39424],[45274,39424],[45274,45745],
 [45275,39424],[45275,45745],[45276,39424],[45277,39424],[45278,39424],[45279,39424],
 [45279,45806],[45280,39424],[45281,39424],[45281,45806],[45282,39424],[45283,39424],
 [45284,39424],[45285,39424],[45286,39424],[45286,45847],[45287,39424],[45287,45847],
 [45288,39424],[45291,3507],[45291,3756],[45291,3930],[45291,38591],[45291,41069],
 [45291,41239],[45291,43297],[45291,43330],[45291,44695],[45291,44696],[45292,43330],
 [45293,43330],[45294,43330],[45299,43330],[45302,43330],[45303,7828],[45303,7996],
 [45303,8168],[45303,40193],[45303,40196],[45303,40287],[45303,40371],[45303,43330],
 [45303,43643],[45303,47266],[45304,43330],[45305,43330],[45307,43330],[45307,45745],
 [45308,43330],[45308,45745],[45309,43330],[45310,43330],[45311,43330],[45312,43330],
 [45312,45806],[45313,43330],[45314,43330],[45314,45806],[45315,43330],[45316,43330],
 [45317,43330],[45318,43330],[45319,43330],[45319,45847],[45320,43330],[45320,45847],
 [45321,43330],[45355,42761],[45358,45501],[45361,45501],[45367,6018],[45367,6152],
 [45367,45363],[45367,45622],[45370,45745],[45371,45745],[45375,45806],[45377,45806],
 [45382,45847],[45383,45847],[45388,45501],[45388,48035],[45390,45501],[45390,48035],
 [45391,45501],[45391,48035],[45400,45745],[45401,45745],[45405,45806],[45407,45806],
 [45412,45847],[45413,45847],[45417,45501],[45419,48445],[45420,45501],[45424,48445],
 [45428,6018],[45428,6213],[45428,45422],[45428,45624],[45429,45745],[45430,45745],
 [45431,45441,45847],[45431,45442,45847],[45431,45781,45847],[45431,45782,45847],
 [45431,45847],[45431,48738,45847],[45431,52172,45847],[45434,45806],[45436,45806],
 [45444,42109],[45445,45501],[45448,45501],[45462,45806],[45464,45806],[45469,45847],
 [45470,45847],[45472,45501],[45475,45501],[45484,45745],[45485,45745],[45489,45806],
 [45491,45806],[45496,45847],[45497,45847],[45500,45501],[45500,48035],[45502,45501],
 [45506,45501],[45507,45501],[45508,45501],[45509,45501],[45510,45501],[45510,45745],
 [45511,45501],[45511,45745],[45512,45501],[45513,45501],[45514,45501],[45515,45501],
 [45515,45806],[45516,45501],[45517,45501],[45517,45806],[45518,45501],[45519,45501],
 [45520,45501],[45521,45501],[45522,45501],[45522,45847],[45523,45501],[45523,45847],
 [45524,45501],[45550,45501],[45550,48035],[45553,3507],[45553,4193],[45553,41069],
 [45554,48445],[45559,45745],[45560,45745],[45564,45806],[45566,45806],[45571,45847],
 [45572,45847],[45574,45501],[45578,45501],[45579,45501],[45580,45501],[45581,45501],
 [45582,45501],[45582,45745],[45583,45501],[45583,45745],[45584,45501],[45585,45501],
 [45586,45501],[45587,45501],[45587,45806],[45588,45501],[45589,45501],[45589,45806],
 [45590,45501],[45591,45501],[45592,45501],[45593,45501],[45594,45501],[45594,45847],
 [45595,45501],[45595,45847],[45596,45501],[45609,45806],[45611,45806],[45616,45847],
 [45617,45847],[45645,45745],[45646,45745],[45650,45806],[45652,45806],[45657,45847],
 [45658,45847],[45664,45745],[45665,45745],[45669,45806],[45671,45806],[45676,45847],
 [45677,45847],[45680,39424],[45680,46241],[45682,45745],[45683,45745],[45687,45806],
 [45689,45806],[45694,45847],[45695,45847],[45697,42362],[45698,43104],[45699,45745],
 [45700,45745],[45704,45806],[45706,45806],[45711,45847],[45712,45847],[45715,45745],
 [45716,45745],[45720,45806],[45722,45806],[45727,45847],[45728,45847],[45730,45745],
 [45731,45745],[45732,45735,45806],[45732,45737,45806],[45732,45774,45806],
 [45732,45776,45806],[45732,45806],[45732,51896,45806],[45732,52131,45806],[45742,45847],
 [45743,45847],[45747,45745],[45748,45745],[45749,45745],[45749,45806],[45750,45745],
 [45751,45745],[45751,45806],[45752,45745],[45753,45745],[45754,45745],[45755,45745],
 [45756,45745],[45756,45847],[45757,45745],[45757,45847],[45758,45745],[45760,45745],
 [45761,45745],[45762,45745],[45762,45806],[45763,45745],[45764,45745],[45764,45806],
 [45765,45745],[45766,45745],[45767,45745],[45768,45745],[45769,45745],[45769,45847],
 [45770,45745],[45770,45847],[45771,45745],[45784,42449],[45785,45806],[45787,45806],
 [45789,14514],[45792,45847],[45793,45847],[45798,14523],[45802,45847],[45803,45847],
 [45807,45806],[45808,45806],[45809,45806],[45811,19848],[45811,19862],[45811,45806],
 [45811,45847],[45812,19848],[45812,19862],[45812,45806],[45812,45847],[45813,45806],
 [45819,45847],[45820,45847],[45821,19857],[45822,45806],[45823,45806],[45824,45806],
 [45826,19848],[45826,19862],[45826,45806],[45826,45847],[45827,19848],[45827,19862],
 [45827,45806],[45827,45847],[45828,45806],[45829,42494],[45837,45847],[45838,45847],
 [45840,14565],[45844,45847],[45845,45847],[45850,38557],[45850,44030],[45852,44030],
 [45854,44030],[45855,44030],[45857,44030],[45858,44030],[45860,44030],[45864,8032],
 [45864,8168],[45864,44030],[45864,46241],[45865,44030],[45866,8032],[45866,8168],
 [45866,44030],[45866,46241],[45867,44030],[45868,44030],[45869,44030],[45870,44030],
 [45871,44030],[45872,44030],[45873,44030],[45874,44030],[45875,44030],[45876,44030],
 [45877,44030],[45878,44030],[45879,44030],[45880,44030],[45881,44030],[45882,44030],
 [45883,38557],[45884,38557],[45885,38557],[45886,38557],[45887,38557],[45890,38557],
 [45892,38557],[45894,38557],[45900,38557],[45900,47331],[45901,38557],[45902,38557],
 [45902,47331],[45903,38557],[45904,38557],[45905,38557],[45906,38557],[45906,47399],
 [45907,38557],[45907,47399],[45908,38557],[45909,38557],[45910,38557],[45911,38557],
 [45912,38557],[45912,47433],[45913,38557],[45914,38557],[45914,47433],[45915,41239],
 [45917,13982],[45917,13985],[45919,46064],[45924,46064],[45927,46241],[45928,6050],
 [45928,6152],[45928,45922],[45928,46140],[45929,46241],[45949,46064],[45954,46064],
 [45962,19294],[45962,19311],[45978,46064],[45983,46064],[45986,46241],[45988,46241],
 [45989,6050],[45989,6213],[45989,45981],[45989,46142],[45992,19295],[45992,19312],
 [46005,41850],[46005,42109],[46006,46064],[46007,48796],[46010,48796],[46011,46064],
 [46014,46241],[46016,46241],[46033,46064],[46033,49217],[46037,46064],[46037,49217],
 [46038,46064],[46038,49217],[46041,46241],[46043,46241],[46061,46064],[46063,46064],
 [46063,49217],[46067,46064],[46067,46241],[46068,46064],[46069,46064],[46069,46241],
 [46070,46064],[46071,46064],[46072,46064],[46073,46064],[46074,46064],[46074,51006],
 [46075,46064],[46076,46064],[46077,46064],[46078,46064],[46079,46064],[46080,46064],
 [46080,51050],[46081,46064],[46081,51050],[46082,46064],[46082,51006],[46083,46064],
 [46084,46064],[46085,46064],[46088,48796],[46092,46241],[46094,46241],[46100,50046],
 [46104,50075],[46106,50075],[46107,50046],[46112,13989],[46112,13991],[46113,46064],
 [46114,3714],[46114,4193],[46114,42670],[46114,42674],[46158,46064],[46158,49217],
 [46161,46241],[46163,46241],[46182,46064],[46182,46241],[46183,46064],[46184,46064],
 [46184,46241],[46185,46064],[46186,46064],[46187,46064],[46188,46064],[46189,46064],
 [46189,51006],[46190,46064],[46191,46064],[46192,46064],[46193,46064],[46194,46064],
 [46195,46064],[46195,51050],[46196,46064],[46196,51050],[46197,46064],[46197,51006],
 [46198,46064],[46199,46064],[46200,46064],[46202,46241],[46204,46241],[46243,46241],
 [46244,46241],[46245,46241],[46246,46241],[46247,46241],[46248,46241],[46249,46241],
 [46250,46241],[46251,46241],[46252,46241],[46253,46241],[46254,46241],[46255,46241],
 [46256,46241],[46257,46241],[46276,46241],[46277,46241],[46278,46241],[46279,46241],
 [46280,46241],[46281,46241],[46282,46241],[46283,46241],[46284,46241],[46285,46241],
 [46286,46241],[46287,46241],[46288,46241],[46289,46241],[46290,46241],[46306,39424],
 [46306,45745],[46307,38557],[46307,47331],[46320,40824],[46345,41850],[46345,42449],
 [46350,14514],[46352,46064],[46352,51006],[46359,14523],[46362,50046],[46366,40870],
 [46367,39424],[46367,45806],[46373,19848],[46375,38557],[46375,47399],[46382,19857],
 [46387,19862],[46390,41850],[46390,42494],[46391,50075],[46396,46064],[46396,51050],
 [46401,14565],[46408,39424],[46408,45847],[46409,38557],[46409,47433],[46410,40914],
 [46424,7828],[46424,7996],[46424,8168],[46424,40193],[46424,40196],[46424,40287],
 [46424,40371],[46424,43330],[46424,43643],[46424,47266],[46427,7828],[46427,7996],
 [46427,8168],[46427,40193],[46427,40196],[46427,40287],[46427,40371],[46427,43330],
 [46427,43643],[46427,47266],[46428,47331],[46430,47331],[46434,47399],[46435,47399],
 [46440,47433],[46442,47433],[46479,48035],[46480,48035],[46485,7828],[46485,8168],
 [46485,40450],[46508,48445],[46513,48445],[46514,7828],[46514,8168],[46514,40450],
 [46517,5705],[46517,6213],[46517,46593],[46533,42109],[46535,48796],[46538,48796],
 [46542,8168],[46565,49217],[46566,49217],[46569,8168],[46615,41411],[46616,48796],
 [46619,42936],[46628,50046],[46632,50075],[46634,50075],[46635,50046],[46639,48035],
 [46643,48445],[46666,40642],[46667,7950],[46667,8168],[46667,42704],[46667,42984],
 [46686,49217],[46689,8168],[46710,7828],[46710,8168],[46710,42193],[46717,51006],
 [46723,51050],[46724,51050],[46725,51006],[46749,7875],[46749,8168],[46749,41187],
 [46749,41545],[46769,8032],[46769,8168],[46769,44030],[46769,46241],[46770,7828],
 [46770,7996],[46770,8168],[46770,40193],[46770,40196],[46770,40287],[46770,40371],
 [46770,43330],[46770,43643],[46770,47266],[46771,8168],[46772,8168],[46773,8168],
 [46774,8168],[46775,8168],[46776,8168],[46777,8168],[46778,8168],[46779,8168],
 [46780,8168],[46781,8168],[46782,8168],[46783,8168],[46784,8168],[46785,8168],
 [46786,42362],[46787,43104],[46834,43330],[46834,45745],[46835,47331],[46838,40870],
 [46846,41205],[46846,41642],[46848,40824],[46873,42449],[46878,14514],[46880,51006],
 [46887,14523],[46890,50046],[46895,43330],[46895,45806],[46901,19848],[46903,47399],
 [46910,19857],[46915,19862],[46918,42494],[46919,50075],[46924,51050],[46929,14565],
 [46936,43330],[46936,45847],[46937,47433],[46938,40914],[46939,41239],[46940,42593],
 [46940,42761],[46951,47266],[46952,5705],[46952,6152],[46952,47090],[46954,47266],
 [46955,47331],[46957,47331],[46961,47399],[46962,47399],[46967,47433],[46969,47433],
 [46975,48035],[46976,48035],[46981,47266],[46984,47266],[46985,47331],[46986,46997,47433],
 [46986,46999,47433],[46986,47354,47433],[46986,47356,47433],[46986,47433],
 [46986,48333,47433],[46986,52107,47433],[46987,47331],[46991,47399],[46992,47399],
 [47010,5705],[47010,6213],[47010,6340],[47010,39759],[47010,47090],[47010,47266],
 [47010,48397],[47010,48445],[47010,49500],[47010,49503],[47013,5705],[47013,6213],
 [47013,6340],[47013,39759],[47013,47090],[47013,47266],[47013,48397],[47013,48445],
 [47013,49500],[47013,49503],[47014,47331],[47016,47331],[47020,47399],[47021,47399],
 [47026,47433],[47028,47433],[47031,48796],[47034,48796],[47038,47266],[47041,47266],
 [47042,47331],[47044,47331],[47048,47399],[47049,47399],[47054,47433],[47056,47433],
 [47065,47266],[47068,47266],[47075,47399],[47076,47399],[47081,47433],[47083,47433],
 [47112,48796],[47116,47266],[47119,47266],[47120,47331],[47122,47331],[47124,50046],
 [47126,47399],[47127,47399],[47128,50075],[47130,50075],[47131,50046],[47132,47433],
 [47134,47433],[47135,48035],[47138,3677],[47138,4193],[47138,41994],[47138,41998],
 [47144,47331],[47146,47331],[47150,47399],[47151,47399],[47156,47433],[47158,47433],
 [47161,43685],[47163,47266],[47166,47266],[47167,47331],[47169,47331],[47173,47399],
 [47174,47399],[47179,47433],[47181,47433],[47185,47266],[47188,47266],[47195,47399],
 [47196,47399],[47201,47433],[47203,47433],[47226,47266],[47229,47266],[47230,47331],
 [47232,47331],[47236,47399],[47237,47399],[47242,47433],[47244,47433],[47267,47266],
 [47267,47331],[47268,47266],[47269,47266],[47269,47331],[47270,47266],[47271,47266],
 [47272,47266],[47273,47266],[47273,47399],[47274,47266],[47274,47399],[47275,47266],
 [47276,47266],[47277,47266],[47278,47266],[47279,47266],[47279,47433],[47280,47266],
 [47281,47266],[47281,47433],[47284,47331],[47286,47331],[47290,47399],[47291,47399],
 [47296,47433],[47298,47433],[47300,47331],[47302,47331],[47306,47399],[47307,47399],
 [47312,47433],[47314,47433],[47315,47266],[47315,47331],[47316,47266],[47317,47266],
 [47317,47331],[47318,47266],[47319,47266],[47320,47266],[47321,47266],[47321,47399],
 [47322,47266],[47322,47399],[47323,47266],[47324,47266],[47325,47266],[47326,47266],
 [47327,47266],[47327,47433],[47328,47266],[47329,47266],[47329,47433],[47332,47331],
 [47333,47331],[47334,47331],[47335,47331],[47335,47399],[47336,47331],[47336,47399],
 [47337,47331],[47338,47331],[47339,47331],[47340,47331],[47341,47331],[47341,47433],
 [47342,47331],[47343,47331],[47343,47433],[47357,47331],[47358,47331],[47359,47331],
 [47360,47331],[47360,47399],[47361,47331],[47361,47399],[47362,47331],[47363,47331],
 [47364,47331],[47365,47331],[47366,47331],[47366,47433],[47367,47331],[47368,47331],
 [47368,47433],[47374,14514],[47377,47433],[47379,47433],[47381,47399],[47382,47399],
 [47383,14523],[47386,50046],[47387,47433],[47389,47433],[47396,47433],[47397,19848],
 [47398,47433],[47400,47399],[47401,47399],[47402,47399],[47404,19857],[47404,19862],
 [47404,47399],[47404,47433],[47405,47399],[47406,19857],[47406,19862],[47406,47399],
 [47406,47433],[47407,47399],[47408,47399],[47409,47399],[47411,19857],[47411,19862],
 [47411,47399],[47411,47433],[47412,47399],[47413,19857],[47413,19862],[47413,47399],
 [47413,47433],[47415,50075],[47417,47433],[47419,47433],[47425,14565],[47429,47433],
 [47431,47433],[47436,41239],[47437,41239],[47438,41239],[47442,41239],[47443,41239],
 [47444,41239],[47446,41239],[47447,5705],[47447,6152],[47447,6183],[47447,39193],
 [47447,39572],[47447,39601],[47447,39602],[47447,41239],[47447,42362],[47447,47993],
 [47449,41239],[47450,41239],[47451,41239],[47452,41239],[47453,41239],[47454,41239],
 [47455,41239],[47456,41239],[47457,41239],[47458,41239],[47459,41239],[47460,41239],
 [47461,41239],[47462,41239],[47463,41239],[47464,41239],[47465,42761],[47466,42761],
 [47467,42761],[47471,42761],[47472,42761],[47473,42761],[47475,42761],[47476,6152],
 [47476,6213],[47476,42761],[47476,43104],[47477,42761],[47478,6152],[47478,6213],
 [47478,42761],[47478,43104],[47479,42761],[47480,42761],[47481,42761],[47482,42761],
 [47483,42761],[47484,42761],[47485,42761],[47486,42761],[47487,42761],[47488,42761],
 [47489,42761],[47490,42761],[47491,42761],[47492,42761],[47493,42761],[47494,42109],
 [47495,47570],[47495,48789],[47500,47678,51006],[47500,47686,51006],[47500,47841,51006],
 [47500,48897,51006],[47500,48905,51006],[47500,49060,51006],[47500,51006],[47504,6152],
 [47517,47570],[47517,48789],[47518,51006],[47526,49217],[47527,49217],[47531,6152],
 [47551,45501],[47553,46064],[47625,39779],[47626,43685],[47629,6050],[47629,6152],
 [47629,45922],[47629,46140],[47647,49217],[47651,6152],[47669,44394],[47672,6018],
 [47672,6152],[47672,45363],[47672,45622],[47684,51050],[47685,51050],[47711,5705],
 [47711,6152],[47711,47090],[47730,46241],[47731,47266],[47747,5705],[47747,6152],
 [47747,6183],[47747,39193],[47747,39572],[47747,39601],[47747,39602],[47747,41239],
 [47747,42362],[47747,47993],[47748,6152],[47748,6213],[47748,42761],[47748,43104],
 [47749,6152],[47750,6152],[47751,6152],[47752,6152],[47753,6152],[47754,6152],
 [47755,6152],[47756,6152],[47757,6152],[47758,6152],[47759,6152],[47760,6152],
 [47761,6152],[47762,6152],[47763,6152],[47795,45745],[47796,47331],[47809,40824],
 [47834,42449],[47839,14514],[47848,14523],[47855,40870],[47856,45806],[47862,19848],
 [47864,47399],[47871,19857],[47876,19862],[47879,42494],[47885,51050],[47890,14565],
 [47897,45847],[47898,47433],[47899,40914],[47929,42109],[47931,48796],[47932,48035],
 [47933,48035],[47934,48796],[47959,48035],[47960,48035],[47961,49217],[47962,49217],
 [47985,45501],[47985,48035],[47986,45501],[47986,48035],[47988,46064],[48012,48796],
 [48024,50046],[48028,50075],[48030,50075],[48031,50046],[48036,48035],[48037,39779],
 [48037,48035],[48038,3756],[48038,4193],[48038,43685],[48038,48035],[48041,48035],
 [48043,48035],[48044,48035],[48045,48035],[48046,48035],[48047,48035],[48048,48035],
 [48049,48035],[48050,48035],[48051,48035],[48052,48035],[48053,48035],[48054,48035],
 [48055,48035],[48056,48035],[48057,48035],[48058,48035],[48059,48035],[48060,39779],
 [48060,48035],[48061,3756],[48061,4193],[48061,43685],[48061,48035],[48064,48035],
 [48066,48035],[48067,48035],[48068,48035],[48069,48035],[48070,48035],[48071,48035],
 [48072,48035],[48073,48035],[48074,48035],[48075,48035],[48076,48035],[48077,48035],
 [48078,48035],[48079,48035],[48080,48035],[48081,48035],[48082,49217],[48104,44394],
 [48113,51006],[48119,51050],[48120,51050],[48121,51006],[48166,47266],[48183,43104],
 [48230,45745],[48231,47331],[48248,38707],[48248,39064],[48256,47433],[48269,42449],
 [48274,14514],[48276,51006],[48283,14523],[48286,50046],[48291,45806],[48297,19848],
 [48299,47399],[48306,19857],[48311,19862],[48314,42494],[48315,50075],[48320,51050],
 [48325,14565],[48332,45847],[48335,42109],[48337,48796],[48338,48445],[48340,48796],
 [48343,48445],[48347,6213],[48365,48445],[48367,49217],[48368,49217],[48370,48445],
 [48374,6213],[48392,45501],[48394,46064],[48418,48796],[48425,5705],[48425,6213],
 [48425,44904],[48430,50046],[48434,50075],[48436,50075],[48437,50046],[48442,48445],
 [48444,3507],[48444,3794],[48444,4193],[48444,38455],[48444,38460],[48444,38724],
 [48444,38921],[48444,43965],[48444,44394],[48444,48445],[48447,48445],[48448,48445],
 [48449,5705],[48449,6213],[48449,6340],[48449,39759],[48449,47090],[48449,47266],
 [48449,48397],[48449,48445],[48449,49500],[48449,49503],[48450,48445],[48451,48445],
 [48452,48445],[48453,48445],[48454,48445],[48455,48445],[48456,48445],[48457,48445],
 [48458,48445],[48459,48445],[48460,48445],[48461,48445],[48462,48445],[48463,48445],
 [48464,48445],[48466,39779],[48467,43685],[48472,6050],[48472,6213],[48472,45981],
 [48472,46142],[48488,49217],[48490,48445],[48494,6213],[48515,6018],[48515,6213],
 [48515,45422],[48515,45624],[48519,51006],[48525,51050],[48526,51050],[48527,51006],
 [48531,3507],[48531,3794],[48531,4193],[48531,38455],[48531,38460],[48531,38724],
 [48531,38921],[48531,43965],[48531,44394],[48531,48445],[48535,5705],[48535,6213],
 [48535,46593],[48552,48445],[48553,48445],[48554,5705],[48554,6213],[48554,6340],
 [48554,39759],[48554,47090],[48554,47266],[48554,48397],[48554,48445],[48554,49500],
 [48554,49503],[48555,48445],[48556,48445],[48557,48445],[48558,48445],[48559,48445],
 [48560,48445],[48561,48445],[48562,48445],[48563,48445],[48564,48445],[48565,48445],
 [48566,48445],[48567,48445],[48568,48445],[48569,48445],[48571,46241],[48572,5705],
 [48572,6213],[48572,6340],[48572,39759],[48572,47090],[48572,47266],[48572,48397],
 [48572,48445],[48572,49500],[48572,49503],[48589,6152],[48589,6213],[48589,42761],
 [48589,43104],[48621,6213],[48622,6213],[48623,6213],[48624,6213],[48625,6213],
 [48626,6213],[48627,6213],[48628,6213],[48629,6213],[48630,6213],[48631,6213],
 [48632,6213],[48633,6213],[48634,6213],[48635,6213],[48636,45745],[48637,47331],
 [48665,39638],[48665,39978],[48673,45847],[48675,42449],[48680,14514],[48682,51006],
 [48689,14523],[48692,50046],[48697,45806],[48703,19848],[48705,47399],[48712,19857],
 [48717,19862],[48720,42494],[48721,50075],[48726,51050],[48731,14565],[48739,47433],
 [48741,42109],[48743,42109],[48744,42109],[48747,42109],[48748,42109],[48749,42109],
 [48750,42109],[48750,42362],[48751,42109],[48751,42362],[48752,42109],[48753,42109],
 [48756,42109],[48756,42449],[48757,42109],[48757,42449],[48758,42109],[48759,42109],
 [48760,42109],[48761,42109],[48761,42494],[48762,42109],[48762,42494],[48763,42109],
 [48764,42109],[48765,42109],[48766,42109],[48767,42109],[48770,45501],[48772,46064],
 [48795,41411],[48795,48796],[48798,48796],[48799,42936],[48799,48796],[48800,48796],
 [48801,48796],[48802,48796],[48803,48796],[48806,48796],[48807,48796],[48808,48796],
 [48808,50046],[48809,48796],[48810,48796],[48811,48796],[48812,48796],[48812,50075],
 [48813,48796],[48814,48796],[48814,50075],[48815,48796],[48815,50046],[48816,48796],
 [48817,48796],[48818,48796],[48819,48035],[48822,4193],[48823,48445],[48843,41411],
 [48843,48796],[48844,39779],[48845,43685],[48846,40642],[48848,14173],[48848,14304],
 [48867,48796],[48868,42936],[48868,48796],[48869,48796],[48870,48796],[48871,48796],
 [48872,48796],[48875,48796],[48876,48796],[48877,48796],[48877,50046],[48878,48796],
 [48879,48796],[48880,48796],[48881,48796],[48881,50075],[48882,48796],[48883,48796],
 [48883,50075],[48884,48796],[48884,50046],[48885,48796],[48886,48796],[48887,48796],
 [48888,44394],[48891,48903,51050],[48891,48904,51050],[48891,49104,51050],
 [48891,50923,51050],[48891,50924,51050],[48891,51050],[48891,51700,51050],[48949,46241],
 [48950,47266],[48966,42109],[48966,42362],[48967,43104],[48971,39664],[48971,39906],
 [48977,51050],[49015,47331],[49053,42109],[49053,42449],[49058,14514],[49067,14523],
 [49070,48796],[49070,50046],[49074,40870],[49075,45806],[49081,19848],[49083,47399],
 [49090,19857],[49095,19862],[49098,42109],[49098,42494],[49099,48796],[49099,50075],
 [49109,14565],[49116,45847],[49117,47433],[49118,40914],[49121,45501],[49122,46064],
 [49122,49217],[49123,46064],[49123,49217],[49146,41411],[49150,42936],[49153,49968,50075],
 [49153,49970,50075],[49153,50075],[49153,51815,50075],[49159,50046],[49166,50046],
 [49170,48035],[49171,49217],[49172,49217],[49173,4193],[49174,48445],[49194,39779],
 [49194,49217],[49195,39779],[49195,49217],[49196,43685],[49197,40642],[49200,14200],
 [49200,14305],[49218,44394],[49218,49217],[49220,49217],[49221,49217],[49222,49217],
 [49223,49217],[49225,49217],[49227,49217],[49227,51006],[49228,49217],[49229,49217],
 [49230,49217],[49231,49217],[49232,49217],[49233,49217],[49233,51050],[49234,49217],
 [49234,51050],[49235,49217],[49235,51006],[49236,49217],[49237,49217],[49238,49217],
 [49239,44394],[49239,49217],[49241,49217],[49242,49217],[49243,49217],[49244,49217],
 [49246,49217],[49248,49217],[49248,51006],[49249,49217],[49250,49217],[49251,49217],
 [49252,49217],[49253,49217],[49254,49217],[49254,51050],[49255,49217],[49255,51050],
 [49256,49217],[49256,51006],[49257,49217],[49258,49217],[49259,49217],[49300,46241],
 [49301,47266],[49317,42109],[49317,42362],[49318,43104],[49339,41373],[49339,41604],
 [49343,50075],[49365,45745],[49404,42109],[49404,42449],[49409,14514],[49411,49217],
 [49411,51006],[49418,14523],[49421,50046],[49425,40870],[49426,45806],[49432,19848],
 [49434,47399],[49441,19857],[49446,19862],[49449,42109],[49449,42494],[49455,49217],
 [49455,51050],[49460,14565],[49467,45847],[49468,47433],[49469,40914],[49495,45501],
 [49495,48035],[49497,46064],[49519,45501],[49523,45501],[49524,45501],[49525,45501],
 [49526,45501],[49527,45501],[49527,45745],[49528,45501],[49528,45745],[49529,45501],
 [49530,45501],[49531,45501],[49532,45501],[49532,45806],[49533,45501],[49534,45501],
 [49534,45806],[49535,45501],[49536,45501],[49537,45501],[49538,45501],[49539,45501],
 [49539,45847],[49540,45501],[49540,45847],[49541,45501],[49542,46064],[49542,49217],
 [49566,46064],[49566,46241],[49567,46064],[49568,46064],[49568,46241],[49569,46064],
 [49570,46064],[49571,46064],[49572,46064],[49573,46064],[49573,51006],[49574,46064],
 [49575,46064],[49576,46064],[49577,46064],[49578,46064],[49579,46064],[49579,51050],
 [49580,46064],[49580,51050],[49581,46064],[49581,51006],[49582,46064],[49583,46064],
 [49584,46064],[49625,46064],[49625,46241],[49642,42362],[49643,43104],[49677,49687],
 [49677,49726],[49690,45501],[49690,45745],[49704,40824],[49729,42449],[49734,14514],
 [49736,46064],[49736,51006],[49743,14523],[49750,40870],[49751,45501],[49751,45806],
 [49757,19848],[49766,19857],[49771,19862],[49774,42494],[49780,46064],[49780,51050],
 [49785,14565],[49792,45501],[49792,45847],[49794,40914],[49819,41411],[49819,48796],
 [49821,41411],[49821,43685],[49823,41411],[49824,41411],[49825,41411],[49826,41411],
 [49827,41411],[49828,41411],[49829,41411],[49830,41411],[49831,41411],[49831,50046],
 [49832,41411],[49833,41411],[49834,41411],[49835,41411],[49835,50075],[49836,41411],
 [49837,41411],[49837,50075],[49838,41411],[49838,50046],[49839,41411],[49840,41411],
 [49841,41411],[49843,48796],[49844,42936],[49844,48796],[49845,48796],[49846,48796],
 [49847,48796],[49848,48796],[49851,48796],[49852,48796],[49853,48796],[49853,50046],
 [49854,48796],[49855,48796],[49856,48796],[49857,48796],[49857,50075],[49858,48796],
 [49859,48796],[49859,50075],[49860,48796],[49860,50046],[49861,48796],[49862,48796],
 [49863,48796],[49885,42936],[49894,50046],[49898,50075],[49900,50075],[49901,50046],
 [49905,42936],[49906,42936],[49906,43104],[49907,42936],[49908,42936],[49908,43104],
 [49909,42936],[49910,42936],[49911,42936],[49912,42936],[49913,42936],[49913,50046],
 [49914,42936],[49915,42936],[49916,42936],[49917,42936],[49917,50075],[49918,42936],
 [49919,42936],[49919,50075],[49920,42936],[49920,50046],[49921,42936],[49922,42936],
 [49923,42936],[49925,46241],[49926,47266],[49931,50046],[49935,50075],[49937,50075],
 [49938,50046],[49943,42936],[49943,43104],[49948,50046],[49952,50075],[49954,50075],
 [49955,50046],[49964,50046],[49971,50046],[49979,50046],[49983,50075],[49985,50075],
 [49986,50046],[49991,47331],[49993,50046],[49997,50075],[49999,50075],[50000,50046],
 [50006,50046],[50010,50075],[50012,50075],[50013,50046],[50018,50046],[50022,50075],
 [50024,50075],[50025,50046],[50033,50075],[50034,14514],[50035,50075],[50041,50046],
 [50043,14523],[50043,14565],[50043,50046],[50043,50075],[50044,50046],[50045,14523],
 [50045,14565],[50045,50046],[50045,50075],[50047,50046],[50048,50046],[50049,50046],
 [50052,50075],[50054,50075],[50057,19848],[50059,47399],[50060,50075],[50062,50075],
 [50063,50046],[50066,19857],[50067,50075],[50069,50075],[50071,19862],[50076,14523],
 [50076,14565],[50076,50046],[50076,50075],[50079,50075],[50081,50046],[50085,14523],
 [50085,14565],[50085,50046],[50085,50075],[50088,50075],[50089,50046],[50090,50046],
 [50091,50046],[50093,47433],[50095,48035],[50096,39779],[50096,48035],[50097,3756],
 [50097,4193],[50097,43685],[50097,48035],[50100,48035],[50102,48035],[50103,48035],
 [50104,48035],[50105,48035],[50106,48035],[50107,48035],[50108,48035],[50109,48035],
 [50110,48035],[50111,48035],[50112,48035],[50113,48035],[50114,48035],[50115,48035],
 [50116,48035],[50117,48035],[50118,49217],[50119,4193],[50120,48445],[50129,42449],
 [50133,44972],[50133,45017],[50140,3507],[50140,3794],[50140,4193],[50140,38455],
 [50140,38460],[50140,38724],[50140,38921],[50140,43965],[50140,44394],[50140,48445],
 [50149,51006],[50155,51050],[50156,51050],[50157,51006],[50161,3507],[50161,3794],
 [50161,4193],[50161,38455],[50161,38460],[50161,38724],[50161,38921],[50161,43965],
 [50161,44394],[50161,48445],[50164,3507],[50164,4193],[50164,39015],[50165,3507],
 [50165,4193],[50165,39015],[50166,4193],[50167,4193],[50168,4193],[50169,4193],
 [50170,4193],[50171,4193],[50172,4193],[50173,4193],[50174,4193],[50175,4193],
 [50176,4193],[50177,4193],[50178,4193],[50179,4193],[50180,4193],[50182,48445],
 [50183,48445],[50184,5705],[50184,6213],[50184,6340],[50184,39759],[50184,47090],
 [50184,47266],[50184,48397],[50184,48445],[50184,49500],[50184,49503],[50185,48445],
 [50186,48445],[50187,48445],[50188,48445],[50189,48445],[50190,48445],[50191,48445],
 [50192,48445],[50193,48445],[50194,48445],[50195,48445],[50196,48445],[50197,48445],
 [50198,48445],[50199,48445],[50218,42362],[50219,43104],[50266,45745],[50267,47331],
 [50280,40824],[50310,14514],[50312,51006],[50319,14523],[50326,40870],[50327,45806],
 [50333,19848],[50335,47399],[50342,19857],[50347,19862],[50350,42494],[50356,51050],
 [50361,14565],[50368,45847],[50369,47433],[50370,40914],[50371,39779],[50371,49217],
 [50372,43685],[50373,40642],[50395,39779],[50396,39779],[50397,39779],[50398,39779],
 [50399,39779],[50400,39779],[50401,39779],[50402,39779],[50402,51006],[50403,39779],
 [50404,39779],[50405,39779],[50406,39779],[50407,39779],[50408,39779],[50408,51050],
 [50409,39779],[50409,51050],[50410,39779],[50410,51006],[50411,39779],[50412,39779],
 [50413,39779],[50414,40642],[50414,43685],[50415,43685],[50417,43685],[50419,43685],
 [50420,43685],[50421,43685],[50422,43685],[50423,43685],[50424,43685],[50425,43685],
 [50426,43685],[50427,43685],[50428,43685],[50429,43685],[50430,43685],[50431,43685],
 [50432,43685],[50433,43685],[50434,40642],[50435,40642],[50436,40642],[50437,40642],
 [50438,40642],[50439,40642],[50439,40824],[50440,40642],[50440,40824],[50441,40642],
 [50442,40642],[50443,40642],[50443,40870],[50444,40642],[50444,40870],[50445,40642],
 [50446,40642],[50447,40642],[50448,40642],[50449,40642],[50450,40642],[50451,40642],
 [50451,40914],[50452,40642],[50452,40914],[50455,47266],[50456,19614],[50456,19618],
 [50471,42362],[50506,19617],[50506,19620],[50519,45501],[50519,45745],[50520,47331],
 [50533,40642],[50533,40824],[50558,42449],[50563,14514],[50565,39779],[50565,51006],
 [50572,14523],[50575,41411],[50575,50046],[50579,40642],[50579,40870],[50580,45501],
 [50580,45806],[50586,19848],[50588,47399],[50595,19857],[50600,19862],[50603,42494],
 [50604,41411],[50604,50075],[50609,39779],[50609,51050],[50614,14565],[50621,45501],
 [50621,45847],[50622,47433],[50623,40642],[50623,40914],[50624,44394],[50624,49217],
 [50626,49217],[50627,49217],[50628,49217],[50629,49217],[50631,49217],[50633,49217],
 [50633,51006],[50634,49217],[50635,49217],[50636,49217],[50637,49217],[50638,49217],
 [50639,49217],[50639,51050],[50640,49217],[50640,51050],[50641,49217],[50641,51006],
 [50642,49217],[50643,49217],[50644,49217],[50653,38908],[50653,38949],[50659,42494],
 [50685,46241],[50686,47266],[50702,42362],[50703,43104],[50764,40824],[50794,14514],
 [50796,49217],[50796,51006],[50803,14523],[50806,48796],[50806,50046],[50810,40870],
 [50811,45806],[50817,19848],[50819,47399],[50826,19857],[50831,19862],[50835,48796],
 [50835,50075],[50840,49217],[50840,51050],[50845,14565],[50852,45847],[50853,47433],
 [50854,40914],[50856,44394],[50858,7828],[50858,8032],[50858,8507],[50858,40707],
 [50858,42193],[50858,42362],[50858,44307],[50858,44394],[50858,49887],[50858,49888],
 [50859,44394],[50860,44394],[50861,44394],[50862,44394],[50863,44394],[50863,51006],
 [50864,44394],[50865,44394],[50866,44394],[50867,44394],[50868,44394],[50869,44394],
 [50869,51050],[50870,44394],[50870,51050],[50871,44394],[50871,51006],[50872,44394],
 [50873,44394],[50874,44394],[50895,46064],[50895,46241],[50900,51006],[50906,51050],
 [50907,51050],[50908,51006],[50913,43104],[50917,51006],[50925,51006],[50933,51006],
 [50939,51050],[50940,51050],[50941,51006],[50948,51006],[50954,51050],[50955,51050],
 [50956,51006],[50962,51006],[50968,51050],[50969,51050],[50970,51006],[50974,40824],
 [50975,51006],[50981,51050],[50982,51050],[50983,51006],[50987,51006],[50993,51050],
 [50994,51050],[50995,51006],[51000,51006],[51003,51006],[51004,14514],[51004,14565],
 [51004,51006],[51004,51050],[51005,14514],[51005,14565],[51005,51006],[51005,51050],
 [51007,51006],[51008,51006],[51009,51006],[51013,14523],[51014,51050],[51015,51050],
 [51020,40870],[51023,51050],[51024,51050],[51025,51006],[51027,19848],[51031,51050],
 [51032,51050],[51036,19857],[51038,51050],[51039,51050],[51041,19862],[51046,51006],
 [51051,14514],[51051,14565],[51051,51006],[51051,51050],[51053,51050],[51055,14514],
 [51055,14565],[51055,51006],[51055,51050],[51057,51050],[51059,51006],[51060,51006],
 [51061,51006],[51064,40914],[51085,46241],[51086,47266],[51150,45745],[51151,47331],
 [51164,40824],[51189,42449],[51194,14514],[51196,44394],[51196,51006],[51203,14523],
 [51206,50046],[51210,40870],[51211,45806],[51217,19848],[51219,47399],[51226,19857],
 [51231,19862],[51235,50075],[51240,44394],[51240,51050],[51245,14565],[51252,45847],
 [51253,47433],[51254,40914],[51258,51272],[51258,51334],[51273,42362],[51274,42936],
 [51274,43104],[51321,45745],[51335,40642],[51335,40824],[51360,42449],[51365,14514],
 [51374,14523],[51377,42936],[51377,50046],[51381,40642],[51381,40870],[51382,45806],
 [51388,19848],[51397,19857],[51402,19862],[51405,42494],[51406,42936],[51406,50075],
 [51416,14565],[51423,45847],[51425,40642],[51425,40914],[51444,46241],[51445,46241],
 [51446,46241],[51447,46241],[51448,46241],[51449,46241],[51450,46241],[51451,46241],
 [51452,46241],[51453,46241],[51454,46241],[51455,46241],[51456,46241],[51457,46241],
 [51458,46241],[51459,47266],[51459,47331],[51460,47266],[51461,47266],[51461,47331],
 [51462,47266],[51463,47266],[51464,47266],[51465,47266],[51465,47399],[51466,47266],
 [51466,47399],[51467,47266],[51468,47266],[51469,47266],[51470,47266],[51471,47266],
 [51471,47433],[51472,47266],[51473,47266],[51473,47433],[51474,45745],[51475,47266],
 [51475,47331],[51479,40870],[51487,51272],[51487,51334],[51488,40824],[51513,42449],
 [51518,14514],[51520,51006],[51527,14523],[51530,50046],[51535,45806],[51541,19848],
 [51543,47266],[51543,47399],[51550,19857],[51555,19862],[51558,42494],[51559,50075],
 [51564,51050],[51569,14565],[51576,45847],[51577,47266],[51577,47433],[51578,40914],
 [51580,42362],[51581,42362],[51582,42362],[51583,42362],[51583,42449],[51584,42362],
 [51584,42449],[51585,42362],[51586,42362],[51587,42362],[51588,42362],[51588,42494],
 [51589,42362],[51589,42494],[51590,42362],[51591,42362],[51592,42362],[51593,42362],
 [51594,42362],[51595,43104],[51596,43104],[51597,43104],[51598,43104],[51599,43104],
 [51600,43104],[51601,43104],[51602,43104],[51603,43104],[51604,43104],[51605,43104],
 [51606,43104],[51607,43104],[51608,43104],[51609,43104],[51610,45745],[51611,47331],
 [51624,40824],[51649,42362],[51649,42449],[51654,14514],[51656,51006],[51663,14523],
 [51666,50046],[51670,40870],[51671,45806],[51677,19848],[51679,47399],[51686,19857],
 [51691,19862],[51694,42362],[51694,42494],[51695,50075],[51705,14565],[51712,45847],
 [51713,47433],[51714,40914],[51730,45745],[51731,47331],[51744,40824],[51769,42362],
 [51769,42449],[51774,14514],[51776,51006],[51783,14523],[51786,50046],[51790,40870],
 [51791,45806],[51797,19848],[51799,47399],[51806,19857],[51811,19862],[51814,42362],
 [51814,42494],[51820,51050],[51825,14565],[51832,45847],[51833,47433],[51834,40914],
 [51835,45745],[51836,47266],[51836,47331],[51849,40824],[51866,45806],[51871,49687],
 [51871,49726],[51874,42449],[51879,14514],[51881,51006],[51888,14523],[51891,50046],
 [51895,40870],[51902,19848],[51904,47266],[51904,47399],[51911,19857],[51916,19862],
 [51919,42494],[51920,50075],[51925,51050],[51930,14565],[51937,45847],[51938,47266],
 [51938,47433],[51939,40914],[51941,45745],[51942,45745],[51943,45745],[51943,45806],
 [51944,45745],[51945,45745],[51945,45806],[51946,45745],[51947,45745],[51948,45745],
 [51949,45745],[51950,45745],[51950,45847],[51951,45745],[51951,45847],[51952,45745],
 [51953,47331],[51954,47331],[51955,47331],[51956,47331],[51956,47399],[51957,47331],
 [51957,47399],[51958,47331],[51959,47331],[51960,47331],[51961,47331],[51962,47331],
 [51962,47433],[51963,47331],[51964,47331],[51964,47433],[51965,42449],[51970,14514],
 [51972,51006],[51979,14523],[51982,50046],[51987,45745],[51987,45806],[51993,19848],
 [51995,47331],[51995,47399],[52002,19857],[52007,19862],[52010,42494],[52011,50075],
 [52016,51050],[52021,14565],[52028,45745],[52028,45847],[52029,47331],[52029,47433],
 [52030,40914],[52031,40824],[52032,40824],[52033,40824],[52033,40870],[52034,40824],
 [52034,40870],[52035,40824],[52036,40824],[52037,40824],[52038,40824],[52039,40824],
 [52040,40824],[52041,40824],[52041,40914],[52042,40824],[52042,40914],[52043,42449],
 [52048,14514],[52050,51006],[52057,14523],[52060,50046],[52064,40824],[52064,40870],
 [52065,45745],[52065,45806],[52071,19848],[52080,19857],[52085,19862],[52088,42494],
 [52089,50075],[52094,51050],[52099,14565],[52106,45745],[52106,45847],[52108,40824],
 [52108,40914],[52109,42449],[52114,14514],[52116,51006],[52123,14523],[52126,50046],
 [52130,40824],[52130,40870],[52137,19848],[52139,47331],[52139,47399],[52146,19857],
 [52151,19862],[52154,42494],[52155,50075],[52160,51050],[52165,14565],[52173,47331],
 [52173,47433],[52174,40824],[52174,40914],[52177,42449],[52178,14514],[52178,14523],
 [52178,42449],[52178,42494],[52179,14514],[52179,14523],[52179,42449],[52179,42494],
 [52180,42449],[52182,42449],[52183,42449],[52184,42449],[52186,45806],[52188,14514],
 [52190,51006],[52192,19848],[52203,14514],[52206,19862],[52209,14514],[52209,14523],
 [52209,42449],[52209,42494],[52210,50075],[52211,51006],[52215,14514],[52215,14565],
 [52215,51006],[52215,51050],[52216,14514],[52216,14565],[52216,51006],[52216,51050],
 [52217,14514],[52218,14514],[52220,14514],[52220,14565],[52220,51006],[52220,51050],
 [52224,51006],[52225,51006],[52226,51006],[52227,45847],[52228,47433],[52229,40914],
 [52239,47399],[52240,14523],[52243,50046],[52246,19857],[52247,14523],[52251,19862],
 [52254,14514],[52254,14523],[52254,42449],[52254,42494],[52255,14523],[52255,14565],
 [52255,50046],[52255,50075],[52256,14523],[52256,14565],[52256,50046],[52256,50075],
 [52257,14523],[52259,14523],[52260,51050],[52261,50046],[52265,14523],[52265,14565],
 [52265,50046],[52265,50075],[52269,50046],[52270,50046],[52271,50046],[52272,45847],
 [52273,47433],[52274,40914],[52276,40870],[52277,40870],[52278,40870],[52279,40870],
 [52280,40870],[52281,19848],[52281,19857],[52281,40870],[52281,40914],[52282,19848],
 [52282,19857],[52282,40870],[52282,40914],[52283,45806],[52284,45806],[52285,45806],
 [52287,19848],[52287,19862],[52287,45806],[52287,45847],[52288,19848],[52288,19862],
 [52288,45806],[52288,45847],[52289,45806],[52290,42494],[52291,50075],[52296,51050],
 [52299,19848],[52301,14565],[52303,19848],[52306,19848],[52308,19848],[52308,19862],
 [52308,45806],[52308,45847],[52309,47433],[52310,19848],[52310,19857],[52310,40870],
 [52310,40914],[52311,47399],[52312,47399],[52313,47399],[52315,19857],[52315,19862],
 [52315,47399],[52315,47433],[52316,47399],[52317,19857],[52317,19862],[52317,47399],
 [52317,47433],[52318,42494],[52319,50075],[52323,19857],[52324,51050],[52329,14565],
 [52332,19857],[52335,19857],[52336,45847],[52337,19857],[52337,19862],[52337,47399],
 [52337,47433],[52338,19848],[52338,19857],[52338,40870],[52338,40914],[52339,42494],
 [52340,50075],[52342,19862],[52345,51050],[52347,19862],[52357,19848],[52357,19862],
 [52357,45806],[52357,45847],[52358,19857],[52358,19862],[52358,47399],[52358,47433],
 [52359,40914],[52361,42494],[52362,42494],[52365,14523],[52365,14565],[52365,50046],
 [52365,50075],[52368,50075],[52373,47433],[52375,14514],[52375,14565],[52375,51006],
 [52375,51050],[52377,51050],[52382,45847],[52386,14565],[52387,14565],[52390,40914],
 [52391,45847],[52392,47433],[52393,40914]];

#############################################################################
##
#E  chains.g . . . . . . . . . . . . . . . . . . . . . . . . . . .  ends here