'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var cov_x1qtw309s = function () {
  var path = '/Users/gajuskuizinas/Documents/dev/gajus/table/src/alignString.js',
      hash = '4739a846b3e706274c1282ad93f4da2a2e3aebc9',
      global = new Function('return this')(),
      gcv = '__coverage__',
      coverageData = {
    path: '/Users/gajuskuizinas/Documents/dev/gajus/table/src/alignString.js',
    statementMap: {
      '0': {
        start: {
          line: 4,
          column: 19
        },
        end: {
          line: 8,
          column: 1
        }
      },
      '1': {
        start: {
          line: 15,
          column: 18
        },
        end: {
          line: 17,
          column: 1
        }
      },
      '2': {
        start: {
          line: 16,
          column: 2
        },
        end: {
          line: 16,
          column: 40
        }
      },
      '3': {
        start: {
          line: 24,
          column: 19
        },
        end: {
          line: 26,
          column: 1
        }
      },
      '4': {
        start: {
          line: 25,
          column: 2
        },
        end: {
          line: 25,
          column: 40
        }
      },
      '5': {
        start: {
          line: 33,
          column: 20
        },
        end: {
          line: 45,
          column: 1
        }
      },
      '6': {
        start: {
          line: 36,
          column: 2
        },
        end: {
          line: 36,
          column: 24
        }
      },
      '7': {
        start: {
          line: 38,
          column: 2
        },
        end: {
          line: 44,
          column: 3
        }
      },
      '8': {
        start: {
          line: 39,
          column: 4
        },
        end: {
          line: 39,
          column: 73
        }
      },
      '9': {
        start: {
          line: 41,
          column: 4
        },
        end: {
          line: 41,
          column: 35
        }
      },
      '10': {
        start: {
          line: 43,
          column: 4
        },
        end: {
          line: 43,
          column: 77
        }
      },
      '11': {
        start: {
          line: 57,
          column: 2
        },
        end: {
          line: 59,
          column: 3
        }
      },
      '12': {
        start: {
          line: 58,
          column: 4
        },
        end: {
          line: 58,
          column: 65
        }
      },
      '13': {
        start: {
          line: 61,
          column: 2
        },
        end: {
          line: 63,
          column: 3
        }
      },
      '14': {
        start: {
          line: 62,
          column: 4
        },
        end: {
          line: 62,
          column: 73
        }
      },
      '15': {
        start: {
          line: 65,
          column: 23
        },
        end: {
          line: 65,
          column: 43
        }
      },
      '16': {
        start: {
          line: 67,
          column: 2
        },
        end: {
          line: 71,
          column: 3
        }
      },
      '17': {
        start: {
          line: 70,
          column: 4
        },
        end: {
          line: 70,
          column: 97
        }
      },
      '18': {
        start: {
          line: 73,
          column: 2
        },
        end: {
          line: 75,
          column: 3
        }
      },
      '19': {
        start: {
          line: 74,
          column: 4
        },
        end: {
          line: 74,
          column: 67
        }
      },
      '20': {
        start: {
          line: 77,
          column: 2
        },
        end: {
          line: 79,
          column: 3
        }
      },
      '21': {
        start: {
          line: 78,
          column: 4
        },
        end: {
          line: 78,
          column: 114
        }
      },
      '22': {
        start: {
          line: 81,
          column: 2
        },
        end: {
          line: 83,
          column: 3
        }
      },
      '23': {
        start: {
          line: 82,
          column: 4
        },
        end: {
          line: 82,
          column: 41
        }
      },
      '24': {
        start: {
          line: 85,
          column: 25
        },
        end: {
          line: 85,
          column: 54
        }
      },
      '25': {
        start: {
          line: 87,
          column: 2
        },
        end: {
          line: 89,
          column: 3
        }
      },
      '26': {
        start: {
          line: 88,
          column: 4
        },
        end: {
          line: 88,
          column: 46
        }
      },
      '27': {
        start: {
          line: 91,
          column: 2
        },
        end: {
          line: 93,
          column: 3
        }
      },
      '28': {
        start: {
          line: 92,
          column: 4
        },
        end: {
          line: 92,
          column: 47
        }
      },
      '29': {
        start: {
          line: 95,
          column: 2
        },
        end: {
          line: 95,
          column: 46
        }
      }
    },
    fnMap: {
      '0': {
        name: '(anonymous_0)',
        decl: {
          start: {
            line: 15,
            column: 18
          },
          end: {
            line: 15,
            column: 19
          }
        },
        loc: {
          start: {
            line: 15,
            column: 38
          },
          end: {
            line: 17,
            column: 1
          }
        }
      },
      '1': {
        name: '(anonymous_1)',
        decl: {
          start: {
            line: 24,
            column: 19
          },
          end: {
            line: 24,
            column: 20
          }
        },
        loc: {
          start: {
            line: 24,
            column: 39
          },
          end: {
            line: 26,
            column: 1
          }
        }
      },
      '2': {
        name: '(anonymous_2)',
        decl: {
          start: {
            line: 33,
            column: 20
          },
          end: {
            line: 33,
            column: 21
          }
        },
        loc: {
          start: {
            line: 33,
            column: 40
          },
          end: {
            line: 45,
            column: 1
          }
        }
      },
      '3': {
        name: '(anonymous_3)',
        decl: {
          start: {
            line: 56,
            column: 15
          },
          end: {
            line: 56,
            column: 16
          }
        },
        loc: {
          start: {
            line: 56,
            column: 55
          },
          end: {
            line: 96,
            column: 1
          }
        }
      }
    },
    branchMap: {
      '0': {
        loc: {
          start: {
            line: 38,
            column: 2
          },
          end: {
            line: 44,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 38,
            column: 2
          },
          end: {
            line: 44,
            column: 3
          }
        }, {
          start: {
            line: 38,
            column: 2
          },
          end: {
            line: 44,
            column: 3
          }
        }]
      },
      '1': {
        loc: {
          start: {
            line: 57,
            column: 2
          },
          end: {
            line: 59,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 57,
            column: 2
          },
          end: {
            line: 59,
            column: 3
          }
        }, {
          start: {
            line: 57,
            column: 2
          },
          end: {
            line: 59,
            column: 3
          }
        }]
      },
      '2': {
        loc: {
          start: {
            line: 61,
            column: 2
          },
          end: {
            line: 63,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 61,
            column: 2
          },
          end: {
            line: 63,
            column: 3
          }
        }, {
          start: {
            line: 61,
            column: 2
          },
          end: {
            line: 63,
            column: 3
          }
        }]
      },
      '3': {
        loc: {
          start: {
            line: 67,
            column: 2
          },
          end: {
            line: 71,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 67,
            column: 2
          },
          end: {
            line: 71,
            column: 3
          }
        }, {
          start: {
            line: 67,
            column: 2
          },
          end: {
            line: 71,
            column: 3
          }
        }]
      },
      '4': {
        loc: {
          start: {
            line: 73,
            column: 2
          },
          end: {
            line: 75,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 73,
            column: 2
          },
          end: {
            line: 75,
            column: 3
          }
        }, {
          start: {
            line: 73,
            column: 2
          },
          end: {
            line: 75,
            column: 3
          }
        }]
      },
      '5': {
        loc: {
          start: {
            line: 77,
            column: 2
          },
          end: {
            line: 79,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 77,
            column: 2
          },
          end: {
            line: 79,
            column: 3
          }
        }, {
          start: {
            line: 77,
            column: 2
          },
          end: {
            line: 79,
            column: 3
          }
        }]
      },
      '6': {
        loc: {
          start: {
            line: 81,
            column: 2
          },
          end: {
            line: 83,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 81,
            column: 2
          },
          end: {
            line: 83,
            column: 3
          }
        }, {
          start: {
            line: 81,
            column: 2
          },
          end: {
            line: 83,
            column: 3
          }
        }]
      },
      '7': {
        loc: {
          start: {
            line: 87,
            column: 2
          },
          end: {
            line: 89,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 87,
            column: 2
          },
          end: {
            line: 89,
            column: 3
          }
        }, {
          start: {
            line: 87,
            column: 2
          },
          end: {
            line: 89,
            column: 3
          }
        }]
      },
      '8': {
        loc: {
          start: {
            line: 91,
            column: 2
          },
          end: {
            line: 93,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 91,
            column: 2
          },
          end: {
            line: 93,
            column: 3
          }
        }, {
          start: {
            line: 91,
            column: 2
          },
          end: {
            line: 93,
            column: 3
          }
        }]
      }
    },
    s: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0,
      '5': 0,
      '6': 0,
      '7': 0,
      '8': 0,
      '9': 0,
      '10': 0,
      '11': 0,
      '12': 0,
      '13': 0,
      '14': 0,
      '15': 0,
      '16': 0,
      '17': 0,
      '18': 0,
      '19': 0,
      '20': 0,
      '21': 0,
      '22': 0,
      '23': 0,
      '24': 0,
      '25': 0,
      '26': 0,
      '27': 0,
      '28': 0,
      '29': 0
    },
    f: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0
    },
    b: {
      '0': [0, 0],
      '1': [0, 0],
      '2': [0, 0],
      '3': [0, 0],
      '4': [0, 0],
      '5': [0, 0],
      '6': [0, 0],
      '7': [0, 0],
      '8': [0, 0]
    }
  },
      coverage = global[gcv] || (global[gcv] = {});

  if (coverage[path] && coverage[path].hash === hash) {
    return coverage[path];
  }

  coverageData.hash = hash;
  return coverage[path] = coverageData;
}();

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _stringWidth = require('string-width');

var _stringWidth2 = _interopRequireDefault(_stringWidth);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const alignments = (++cov_x1qtw309s.s[0], ['left', 'right', 'center']);

/**
 * @param {string} subject
 * @param {number} width
 * @returns {string}
 */
const alignLeft = (++cov_x1qtw309s.s[1], (subject, width) => {
  ++cov_x1qtw309s.f[0];
  ++cov_x1qtw309s.s[2];

  return subject + _lodash2.default.repeat(' ', width);
});

/**
 * @param {string} subject
 * @param {number} width
 * @returns {string}
 */
const alignRight = (++cov_x1qtw309s.s[3], (subject, width) => {
  ++cov_x1qtw309s.f[1];
  ++cov_x1qtw309s.s[4];

  return _lodash2.default.repeat(' ', width) + subject;
});

/**
 * @param {string} subject
 * @param {number} width
 * @returns {string}
 */
const alignCenter = (++cov_x1qtw309s.s[5], (subject, width) => {
  ++cov_x1qtw309s.f[2];

  let halfWidth;

  ++cov_x1qtw309s.s[6];
  halfWidth = width / 2;

  ++cov_x1qtw309s.s[7];
  if (halfWidth % 2 === 0) {
    ++cov_x1qtw309s.b[0][0];
    ++cov_x1qtw309s.s[8];

    return _lodash2.default.repeat(' ', halfWidth) + subject + _lodash2.default.repeat(' ', halfWidth);
  } else {
    ++cov_x1qtw309s.b[0][1];
    ++cov_x1qtw309s.s[9];

    halfWidth = _lodash2.default.floor(halfWidth);

    ++cov_x1qtw309s.s[10];
    return _lodash2.default.repeat(' ', halfWidth) + subject + _lodash2.default.repeat(' ', halfWidth + 1);
  }
});

/**
 * Pads a string to the left and/or right to position the subject
 * text in a desired alignment within a container.
 *
 * @param {string} subject
 * @param {number} containerWidth
 * @param {string} alignment One of the valid options (left, right, center).
 * @returns {string}
 */

exports.default = (subject, containerWidth, alignment) => {
  ++cov_x1qtw309s.f[3];
  ++cov_x1qtw309s.s[11];

  if (!_lodash2.default.isString(subject)) {
    ++cov_x1qtw309s.b[1][0];
    ++cov_x1qtw309s.s[12];

    throw new Error('Subject parameter value must be a string.');
  } else {
    ++cov_x1qtw309s.b[1][1];
  }

  ++cov_x1qtw309s.s[13];
  if (!_lodash2.default.isNumber(containerWidth)) {
    ++cov_x1qtw309s.b[2][0];
    ++cov_x1qtw309s.s[14];

    throw new Error('Container width parameter value must be a number.');
  } else {
    ++cov_x1qtw309s.b[2][1];
  }

  const subjectWidth = (++cov_x1qtw309s.s[15], (0, _stringWidth2.default)(subject));

  ++cov_x1qtw309s.s[16];
  if (subjectWidth > containerWidth) {
    ++cov_x1qtw309s.b[3][0];
    ++cov_x1qtw309s.s[17];

    // console.log('subjectWidth', subjectWidth, 'containerWidth', containerWidth, 'subject', subject);

    throw new Error('Subject parameter value width cannot be greater than the container width.');
  } else {
    ++cov_x1qtw309s.b[3][1];
  }

  ++cov_x1qtw309s.s[18];
  if (!_lodash2.default.isString(alignment)) {
    ++cov_x1qtw309s.b[4][0];
    ++cov_x1qtw309s.s[19];

    throw new Error('Alignment parameter value must be a string.');
  } else {
    ++cov_x1qtw309s.b[4][1];
  }

  ++cov_x1qtw309s.s[20];
  if (alignments.indexOf(alignment) === -1) {
    ++cov_x1qtw309s.b[5][0];
    ++cov_x1qtw309s.s[21];

    throw new Error('Alignment parameter value must be a known alignment parameter value (left, right, center).');
  } else {
    ++cov_x1qtw309s.b[5][1];
  }

  ++cov_x1qtw309s.s[22];
  if (subjectWidth === 0) {
    ++cov_x1qtw309s.b[6][0];
    ++cov_x1qtw309s.s[23];

    return _lodash2.default.repeat(' ', containerWidth);
  } else {
    ++cov_x1qtw309s.b[6][1];
  }

  const availableWidth = (++cov_x1qtw309s.s[24], containerWidth - subjectWidth);

  ++cov_x1qtw309s.s[25];
  if (alignment === 'left') {
    ++cov_x1qtw309s.b[7][0];
    ++cov_x1qtw309s.s[26];

    return alignLeft(subject, availableWidth);
  } else {
    ++cov_x1qtw309s.b[7][1];
  }

  ++cov_x1qtw309s.s[27];
  if (alignment === 'right') {
    ++cov_x1qtw309s.b[8][0];
    ++cov_x1qtw309s.s[28];

    return alignRight(subject, availableWidth);
  } else {
    ++cov_x1qtw309s.b[8][1];
  }

  ++cov_x1qtw309s.s[29];
  return alignCenter(subject, availableWidth);
};

module.exports = exports['default'];