'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var cov_1y0c093qbd = function () {
  var path = '/Users/gajuskuizinas/Documents/dev/gajus/table/src/table.js',
      hash = 'd4162e54a4a463a5103e2932efcc4187503c2876',
      global = new Function('return this')(),
      gcv = '__coverage__',
      coverageData = {
    path: '/Users/gajuskuizinas/Documents/dev/gajus/table/src/table.js',
    statementMap: {
      '0': {
        start: {
          line: 77,
          column: 2
        },
        end: {
          line: 77,
          column: 26
        }
      },
      '1': {
        start: {
          line: 79,
          column: 2
        },
        end: {
          line: 79,
          column: 34
        }
      },
      '2': {
        start: {
          line: 81,
          column: 17
        },
        end: {
          line: 81,
          column: 45
        }
      },
      '3': {
        start: {
          line: 83,
          column: 2
        },
        end: {
          line: 83,
          column: 41
        }
      },
      '4': {
        start: {
          line: 85,
          column: 25
        },
        end: {
          line: 85,
          column: 62
        }
      },
      '5': {
        start: {
          line: 87,
          column: 2
        },
        end: {
          line: 87,
          column: 66
        }
      },
      '6': {
        start: {
          line: 88,
          column: 2
        },
        end: {
          line: 88,
          column: 38
        }
      },
      '7': {
        start: {
          line: 89,
          column: 2
        },
        end: {
          line: 89,
          column: 36
        }
      },
      '8': {
        start: {
          line: 91,
          column: 25
        },
        end: {
          line: 91,
          column: 57
        }
      },
      '9': {
        start: {
          line: 93,
          column: 2
        },
        end: {
          line: 93,
          column: 99
        }
      }
    },
    fnMap: {
      '0': {
        name: '(anonymous_0)',
        decl: {
          start: {
            line: 74,
            column: 15
          },
          end: {
            line: 74,
            column: 16
          }
        },
        loc: {
          start: {
            line: 74,
            column: 42
          },
          end: {
            line: 94,
            column: 1
          }
        }
      }
    },
    branchMap: {
      '0': {
        loc: {
          start: {
            line: 74,
            column: 22
          },
          end: {
            line: 74,
            column: 37
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 74,
            column: 35
          },
          end: {
            line: 74,
            column: 37
          }
        }]
      }
    },
    s: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0,
      '5': 0,
      '6': 0,
      '7': 0,
      '8': 0,
      '9': 0
    },
    f: {
      '0': 0
    },
    b: {
      '0': [0]
    }
  },
      coverage = global[gcv] || (global[gcv] = {});

  if (coverage[path] && coverage[path].hash === hash) {
    return coverage[path];
  }

  coverageData.hash = hash;
  return coverage[path] = coverageData;
}();

var _drawTable = require('./drawTable');

var _drawTable2 = _interopRequireDefault(_drawTable);

var _calculateCellWidthIndex = require('./calculateCellWidthIndex');

var _calculateCellWidthIndex2 = _interopRequireDefault(_calculateCellWidthIndex);

var _makeConfig = require('./makeConfig');

var _makeConfig2 = _interopRequireDefault(_makeConfig);

var _calculateRowHeightIndex = require('./calculateRowHeightIndex');

var _calculateRowHeightIndex2 = _interopRequireDefault(_calculateRowHeightIndex);

var _mapDataUsingRowHeightIndex = require('./mapDataUsingRowHeightIndex');

var _mapDataUsingRowHeightIndex2 = _interopRequireDefault(_mapDataUsingRowHeightIndex);

var _alignTableData = require('./alignTableData');

var _alignTableData2 = _interopRequireDefault(_alignTableData);

var _padTableData = require('./padTableData');

var _padTableData2 = _interopRequireDefault(_padTableData);

var _validateTableData = require('./validateTableData');

var _validateTableData2 = _interopRequireDefault(_validateTableData);

var _stringifyTableData = require('./stringifyTableData');

var _stringifyTableData2 = _interopRequireDefault(_stringifyTableData);

var _truncateTableData = require('./truncateTableData');

var _truncateTableData2 = _interopRequireDefault(_truncateTableData);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * @typedef {string} table~cell
 */

/**
 * @typedef {table~cell[]} table~row
 */

/**
 * @typedef {Object} table~columns
 * @property {string} alignment Cell content alignment (enum: left, center, right) (default: left).
 * @property {number} width Column width (default: auto).
 * @property {number} truncate Number of characters are which the content will be truncated (default: Infinity).
 * @property {number} paddingLeft Cell content padding width left (default: 1).
 * @property {number} paddingRight Cell content padding width right (default: 1).
 */

/**
 * @typedef {Object} table~border
 * @property {string} topBody
 * @property {string} topJoin
 * @property {string} topLeft
 * @property {string} topRight
 * @property {string} bottomBody
 * @property {string} bottomJoin
 * @property {string} bottomLeft
 * @property {string} bottomRight
 * @property {string} bodyLeft
 * @property {string} bodyRight
 * @property {string} bodyJoin
 * @property {string} joinBody
 * @property {string} joinLeft
 * @property {string} joinRight
 * @property {string} joinJoin
 */

/**
 * Used to tell whether to draw a horizontal line.
 * This callback is called for each non-content line of the table.
 * The default behavior is to always return true.
 *
 * @typedef {Function} drawHorizontalLine
 * @param {number} index
 * @param {number} size
 * @returns {boolean}
 */

/**
 * @typedef {Object} table~config
 * @property {table~border} border
 * @property {table~columns[]} columns Column specific configuration.
 * @property {table~columns} columnDefault Default values for all columns. Column specific settings overwrite the default values.
 * @property {table~drawHorizontalLine} drawHorizontalLine
 */

/**
 * Generates a text table.
 *
 * @param {table~row[]} data
 * @param {table~config} userConfig
 * @returns {string}
 */
exports.default = function (data) {
  let userConfig = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (++cov_1y0c093qbd.b[0][0], {});
  ++cov_1y0c093qbd.f[0];

  let rows;

  ++cov_1y0c093qbd.s[0];
  (0, _validateTableData2.default)(data);

  ++cov_1y0c093qbd.s[1];
  rows = (0, _stringifyTableData2.default)(data);

  const config = (++cov_1y0c093qbd.s[2], (0, _makeConfig2.default)(rows, userConfig));

  ++cov_1y0c093qbd.s[3];
  rows = (0, _truncateTableData2.default)(data, config);

  const rowHeightIndex = (++cov_1y0c093qbd.s[4], (0, _calculateRowHeightIndex2.default)(rows, config));

  ++cov_1y0c093qbd.s[5];
  rows = (0, _mapDataUsingRowHeightIndex2.default)(rows, rowHeightIndex, config);
  ++cov_1y0c093qbd.s[6];
  rows = (0, _alignTableData2.default)(rows, config);
  ++cov_1y0c093qbd.s[7];
  rows = (0, _padTableData2.default)(rows, config);

  const cellWidthIndex = (++cov_1y0c093qbd.s[8], (0, _calculateCellWidthIndex2.default)(rows[0]));

  ++cov_1y0c093qbd.s[9];
  return (0, _drawTable2.default)(rows, config.border, cellWidthIndex, rowHeightIndex, config.drawHorizontalLine);
};

module.exports = exports['default'];