/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryAdjustAction
extends MapMode
implements AWTEventListener {
    private static volatile ImageryOffsetDialog offsetDialog;
    private static Cursor cursor;
    private EastNorth old;
    private EastNorth prevEastNorth;
    private transient AbstractTileSourceLayer<?> layer;
    private MapMode oldMapMode;

    public ImageryAdjustAction(AbstractTileSourceLayer<?> abstractTileSourceLayer) {
        super(I18n.tr("New offset", new Object[0]), "adjustimg", I18n.tr("Adjust the position of this imagery layer", new Object[0]), Main.map, cursor);
        this.putValue("toolbar", Boolean.FALSE);
        this.layer = abstractTileSourceLayer;
    }

    @Override
    public void enterMode() {
        super.enterMode();
        if (this.layer == null) {
            return;
        }
        if (!this.layer.isVisible()) {
            this.layer.setVisible(true);
        }
        this.old = this.layer.getDisplaySettings().getDisplacement();
        this.addListeners();
        offsetDialog = new ImageryOffsetDialog();
        offsetDialog.setVisible(true);
    }

    protected void addListeners() {
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            Main.error(securityException);
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        if (offsetDialog != null) {
            if (this.layer != null) {
                this.layer.getDisplaySettings().setDisplacement(this.old);
            }
            offsetDialog.setVisible(false);
            offsetDialog = null;
        }
        this.removeListeners();
    }

    protected void removeListeners() {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            Main.error(securityException);
        }
        if (Main.isDisplayingMapView()) {
            Main.map.mapView.removeMouseMotionListener(this);
            Main.map.mapView.removeMouseListener(this);
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent) || aWTEvent.getID() != 401 || this.layer == null || offsetDialog != null && ImageryAdjustAction.offsetDialog.areFieldsInFocus()) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        int n = 0;
        int n2 = 0;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                n2 = 1;
                break;
            }
            case 40: {
                n2 = -1;
                break;
            }
            case 37: {
                n = -1;
                break;
            }
            case 39: {
                n = 1;
                break;
            }
        }
        if (n != 0 || n2 != 0) {
            double d = this.layer.getPPD();
            this.layer.getDisplaySettings().addDisplacement(new EastNorth((double)n / d, (double)n2 / d));
            if (offsetDialog != null) {
                ImageryAdjustAction.offsetDialog.updateOffset();
            }
            if (Main.isDebugEnabled()) {
                Main.debug(this.getClass().getName() + " consuming event " + keyEvent);
            }
            keyEvent.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (this.layer.isVisible()) {
            this.requestFocusInMapView();
            this.prevEastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
            Main.map.mapView.setNewCursor(13, (Object)this);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.layer == null || this.prevEastNorth == null) {
            return;
        }
        EastNorth eastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        EastNorth eastNorth2 = this.layer.getDisplaySettings().getDisplacement().add(eastNorth).subtract(this.prevEastNorth);
        this.layer.getDisplaySettings().setDisplacement(eastNorth2);
        if (offsetDialog != null) {
            ImageryAdjustAction.offsetDialog.updateOffset();
        }
        this.prevEastNorth = eastNorth;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Main.map.mapView.repaint();
        Main.map.mapView.resetCursor(this);
        this.prevEastNorth = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (offsetDialog != null || this.layer == null || Main.map == null) {
            return;
        }
        this.oldMapMode = Main.map.mapMode;
        super.actionPerformed(actionEvent);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.removeListeners();
        this.layer = null;
        this.oldMapMode = null;
    }

    static {
        cursor = ImageProvider.getCursor("normal", "move");
    }

    private class ImageryOffsetDialog
    extends ExtendedDialog
    implements FocusListener {
        private final JosmTextField tOffset;
        private final JosmTextField tBookmarkName;
        private boolean ignoreListener;

        ImageryOffsetDialog() {
            super(Main.parent, I18n.tr("Adjust imagery offset", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])}, false);
            this.tOffset = new JosmTextField();
            this.tBookmarkName = new JosmTextField();
            this.setButtonIcons("ok", "cancel");
            this.contentInsets = new Insets(10, 15, 5, 15);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JMultilineLabel(I18n.tr("Use arrow keys or drag the imagery layer with mouse to adjust the imagery offset.\nYou can also enter east and north offset in the {0} coordinates.\nIf you want to save the offset as bookmark, enter the bookmark name below", Main.getProjection().toString())), GBC.eop());
            jPanel.add((Component)new JLabel(I18n.tr("Offset: ", new Object[0])), GBC.std());
            jPanel.add((Component)this.tOffset, GBC.eol().fill(2).insets(0, 0, 0, 5));
            jPanel.add((Component)new JLabel(I18n.tr("Bookmark name: ", new Object[0])), GBC.std());
            jPanel.add((Component)this.tBookmarkName, GBC.eol().fill(2));
            this.tOffset.setColumns(16);
            this.updateOffsetIntl();
            this.tOffset.addFocusListener(this);
            this.setContent(jPanel);
            this.setupDialog();
            this.addWindowListener(new WindowEventHandler());
        }

        private boolean areFieldsInFocus() {
            return this.tOffset.hasFocus();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (this.ignoreListener) {
                return;
            }
            String string = this.tOffset.getText();
            int n = string.indexOf(59);
            if (ImageryAdjustAction.this.layer != null && n >= 0 && n + 1 < string.length()) {
                try {
                    String string2 = string.substring(0, n).trim().replace(',', '.');
                    String string3 = string.substring(n + 1).trim().replace(',', '.');
                    double d = Double.parseDouble(string2);
                    double d2 = Double.parseDouble(string3);
                    ImageryAdjustAction.this.layer.getDisplaySettings().setDisplacement(new EastNorth(d, d2));
                }
                catch (NumberFormatException numberFormatException) {
                    Main.trace(numberFormatException);
                }
            }
            this.updateOffsetIntl();
            if (Main.isDisplayingMapView()) {
                Main.map.repaint();
            }
        }

        private void updateOffset() {
            this.ignoreListener = true;
            this.updateOffsetIntl();
            this.ignoreListener = false;
        }

        private void updateOffsetIntl() {
            int n = Main.getProjection().getDefaultZoomInPPD() >= 1.0 ? 2 : 7;
            try (Formatter formatter = new Formatter(Locale.US);){
                TileSourceDisplaySettings tileSourceDisplaySettings = ImageryAdjustAction.this.layer.getDisplaySettings();
                this.tOffset.setText(formatter.format("%1." + n + "f; %1." + n + 'f', tileSourceDisplaySettings.getDx(), tileSourceDisplaySettings.getDy()).toString());
            }
        }

        private boolean confirmOverwriteBookmark() {
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite", new Object[0]), new String[]{I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])}){
                {
                    this.contentInsets = new Insets(10, 15, 10, 15);
                }
            };
            extendedDialog.setContent(I18n.tr("Offset bookmark already exists. Overwrite?", new Object[0]));
            extendedDialog.setButtonIcons("ok.png", "cancel.png");
            extendedDialog.setupDialog();
            extendedDialog.setVisible(true);
            return extendedDialog.getValue() == 1;
        }

        @Override
        protected void buttonAction(int n, ActionEvent actionEvent) {
            if (n == 0 && this.tBookmarkName.getText() != null && !this.tBookmarkName.getText().isEmpty() && OffsetBookmark.getBookmarkByName(ImageryAdjustAction.this.layer, this.tBookmarkName.getText()) != null && !this.confirmOverwriteBookmark()) {
                return;
            }
            super.buttonAction(n, actionEvent);
        }

        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (bl) {
                return;
            }
            offsetDialog = null;
            if (ImageryAdjustAction.this.layer != null) {
                if (this.getValue() != 1) {
                    ImageryAdjustAction.this.layer.getDisplaySettings().setDisplacement(ImageryAdjustAction.this.old);
                } else if (this.tBookmarkName.getText() != null && !this.tBookmarkName.getText().isEmpty()) {
                    OffsetBookmark.bookmarkOffset(this.tBookmarkName.getText(), ImageryAdjustAction.this.layer);
                }
            }
            Main.main.menu.imageryMenu.refreshOffsetMenu();
        }

        class WindowEventHandler
        extends WindowAdapter {
            WindowEventHandler() {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ImageryOffsetDialog.this.setVisible(false);
                this.restoreMapModeState();
            }

            private void restoreMapModeState() {
                if (Main.map == null) {
                    return;
                }
                if (ImageryAdjustAction.this.oldMapMode != null) {
                    Main.map.selectMapMode(ImageryAdjustAction.this.oldMapMode);
                    ImageryAdjustAction.this.oldMapMode = null;
                } else {
                    Main.map.selectSelectTool(false);
                }
            }
        }
    }
}

