/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.math;

public class DoubleMatrix {
    protected double[] m;
    private int vectorSize;
    private int nbrOfVectors;

    public DoubleMatrix() {
    }

    public DoubleMatrix(int size) {
        this(size, size);
    }

    public DoubleMatrix(int vectorSize, int nbrOfVectors) {
        if (vectorSize < 0 || nbrOfVectors < 0) {
            throw new IndexOutOfBoundsException("Index (Dimensions too small)");
        }
        this.vectorSize = vectorSize;
        this.nbrOfVectors = nbrOfVectors;
        this.m = new double[vectorSize * nbrOfVectors];
        for (int i = 0; i < this.m.length; ++i) {
            this.m[i] = 0.0;
        }
    }

    public DoubleMatrix(DoubleMatrix a) {
        this(a.getVectorSize(), a.getNumberOfVectors());
        for (int i = 0; i < this.m.length; ++i) {
            this.m[i] = a.m[i];
        }
    }

    public boolean equals(Object obj) {
        DoubleMatrix mat = (DoubleMatrix)obj;
        if (obj == null || this.getVectorSize() != mat.getVectorSize() || this.getNumberOfVectors() != mat.getNumberOfVectors()) {
            return false;
        }
        for (int i = 0; i < this.m.length; ++i) {
            if (this.m[i] == mat.m[i]) continue;
            return false;
        }
        return true;
    }

    public DoubleMatrix falk(DoubleMatrix a) {
        DoubleMatrix c = this.getFalk(a);
        this.m = c.m;
        return this;
    }

    public static DoubleMatrix getAdjacencyInstance(DoubleMatrix a) {
        DoubleMatrix adj = new DoubleMatrix();
        return adj;
    }

    public double getCell(int row, int col) {
        if (row < 0 || this.vectorSize <= row || col < 0 || this.nbrOfVectors <= col) {
            throw new IndexOutOfBoundsException("getCell()");
        }
        return this.m[row * this.nbrOfVectors + col];
    }

    public static DoubleMatrix getConstantInstance(int vectorSize, int nbrOfVectors, double scalar) {
        DoubleMatrix con = new DoubleMatrix(vectorSize, nbrOfVectors);
        for (int i = 0; i < vectorSize; ++i) {
            for (int j = 0; j < nbrOfVectors; ++j) {
                con.setCell(i, j, scalar);
            }
        }
        return con;
    }

    public double getDeterminant() {
        double det = 0.0;
        return det;
    }

    public DoubleMatrix getFalk(DoubleMatrix a) {
        if (this.getNumberOfVectors() != a.getVectorSize()) {
            throw new IndexOutOfBoundsException("Index (dimension fault)");
        }
        DoubleMatrix c = DoubleMatrix.getConstantInstance(this.vectorSize, a.nbrOfVectors, 0.0);
        for (int i = 0; i < this.vectorSize; ++i) {
            for (int j = 0; j < this.nbrOfVectors; ++j) {
                for (int k = 0; k < a.nbrOfVectors; ++k) {
                    int n = i * c.nbrOfVectors + k;
                    c.m[n] = c.m[n] + this.m[i * this.nbrOfVectors + j] * a.m[j * a.nbrOfVectors + k];
                }
            }
        }
        return c;
    }

    public static DoubleMatrix getIdentityInstance(int vectorSize) {
        DoubleMatrix idn = DoubleMatrix.getConstantInstance(vectorSize, vectorSize, 0.0);
        for (int i = 0; i < vectorSize; ++i) {
            idn.setCell(i, i, 1.0);
        }
        return idn;
    }

    public static DoubleMatrix getInverseInstance(DoubleMatrix a) {
        DoubleMatrix inv = new DoubleMatrix();
        return inv;
    }

    public static DoubleMatrix getMinorInstance(DoubleMatrix a, int row, int col) {
        DoubleMatrix minor = new DoubleMatrix();
        return minor;
    }

    public int getNumberOfVectors() {
        return this.nbrOfVectors;
    }

    public DoubleMatrix getPower(int exponent) {
        this.quadraticCheck();
        switch (exponent) {
            case -1: {
                return DoubleMatrix.getInverseInstance(this);
            }
            case 0: {
                return DoubleMatrix.getIdentityInstance(this.getVectorSize());
            }
            case 1: {
                return this;
            }
        }
        DoubleMatrix pow = new DoubleMatrix(this.getVectorSize(), this.getNumberOfVectors());
        DoubleMatrix h = new DoubleMatrix(this.getVectorSize(), this.getNumberOfVectors());
        h = exponent < 0 ? DoubleMatrix.getInverseInstance(this) : this;
        pow = h;
        while (exponent > 1) {
            pow = pow.getFalk(h);
            --exponent;
        }
        return pow;
    }

    public DoubleMatrix getTransponed() {
        DoubleMatrix trn = new DoubleMatrix(this.getNumberOfVectors(), this.getVectorSize());
        for (int i = 0; i < this.getVectorSize(); ++i) {
            for (int j = 0; j < this.getNumberOfVectors(); ++j) {
                trn.setCell(j, i, this.getCell(i, j));
            }
        }
        return trn;
    }

    public int getVectorSize() {
        return this.vectorSize;
    }

    public DoubleMatrix minus(DoubleMatrix a) {
        this.sizeCheck(a);
        for (int i = 0; i < this.vectorSize * this.nbrOfVectors; ++i) {
            this.m[i] = this.m[i] - a.m[i];
        }
        return this;
    }

    public DoubleMatrix multiply(double scalar) {
        for (int i = 0; i < this.vectorSize * this.nbrOfVectors; ++i) {
            this.m[i] = this.m[i] * scalar;
        }
        return this;
    }

    public DoubleMatrix plus(DoubleMatrix a) {
        this.sizeCheck(a);
        for (int i = 0; i < this.vectorSize * this.nbrOfVectors; ++i) {
            this.m[i] = this.m[i] + a.m[i];
        }
        return this;
    }

    private void quadraticCheck() {
        if (this.getVectorSize() != this.getNumberOfVectors()) {
            throw new IndexOutOfBoundsException("Index (non-quadratic): rows = " + this.getVectorSize() + ", columns = " + this.getNumberOfVectors());
        }
    }

    public void setCell(int row, int col, double value) {
        if (row < 0 || this.vectorSize <= row || col < 0 || this.nbrOfVectors <= col) {
            throw new IndexOutOfBoundsException("setRange()");
        }
        this.m[row * this.nbrOfVectors + col] = value;
    }

    private void sizeCheck(DoubleMatrix a) {
        if (this.vectorSize != a.getVectorSize() && this.nbrOfVectors != a.getNumberOfVectors()) {
            throw new IndexOutOfBoundsException("Index (matrices of non-equal size)");
        }
    }

    public String toString() {
        String str = "[";
        for (int i = 0; i < this.getVectorSize(); ++i) {
            if (i > 0) {
                str = str + " ";
            }
            str = str + "[";
            for (int j = 0; j < this.getNumberOfVectors(); ++j) {
                if (j != 0) {
                    str = str + ", ";
                }
                str = str + this.getCell(i, j);
            }
            str = str + "]";
            if (i == this.getNumberOfVectors() - 1) continue;
            str = str + "\n";
        }
        return str + "]";
    }
}

