/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram;

import com.baselet.control.enums.LineType;
import com.baselet.control.util.Utils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorFrame
extends JComponent {
    private static final Logger log = LoggerFactory.getLogger(SelectorFrame.class);
    private int offset_left;
    private int offset_top;
    private int entity_displacement_x;
    private int entity_displacement_y;

    public SelectorFrame() {
        this.reset();
    }

    public void reset() {
        this.offset_left = 0;
        this.offset_top = 0;
        this.entity_displacement_x = 0;
        this.entity_displacement_y = 0;
    }

    public void setDisplacement(int x, int y) {
        this.entity_displacement_x = x;
        this.entity_displacement_y = y;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        g2.setStroke(Utils.getStroke(LineType.DASHED, 1.0f));
        g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
    }

    public void resizeTo(int x, int y) {
        int locx = this.getX();
        int locy = this.getY();
        int sizx = this.entity_displacement_x + x - this.getX();
        int sizy = this.entity_displacement_y + y - this.getY();
        if (sizx - this.offset_left < 0) {
            locx += sizx;
            this.offset_left = sizx = sizx * -1 + this.offset_left;
            log.trace("LEFT (offset: " + this.offset_left + "px)");
        } else {
            sizx -= this.offset_left;
            locx += this.offset_left;
            this.offset_left = 0;
            log.trace("RIGHT");
        }
        if (sizy - this.offset_top < 0) {
            locy += sizy;
            this.offset_top = sizy = sizy * -1 + this.offset_top;
            log.trace("UP (offset: " + this.offset_top + "px)");
        } else {
            sizy -= this.offset_top;
            locy += this.offset_top;
            this.offset_top = 0;
            log.trace("DOWN");
        }
        log.trace("Starting point: (" + locx + "," + locy + ") Width: " + sizx + ", Height: " + sizy);
        this.setLocation(locx, locy);
        this.setSize(sizx, sizy);
    }
}

