/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfParamToken;
import org.zaproxy.zap.extension.api.ZapApiIgnore;

public class AntiCsrfParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(AntiCsrfParam.class);
    private static final String ANTI_CSRF_BASE_KEY = "anticsrf";
    private static final String ALL_TOKENS_KEY = "anticsrf.tokens.token";
    private static final String TOKEN_NAME_KEY = "name";
    private static final String TOKEN_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_TOKEN_KEY = "anticsrf.confirmRemoveToken";
    private static final String[] DEFAULT_TOKENS_NAMES = new String[]{"anticsrf", "CSRFToken", "__RequestVerificationToken", "csrfmiddlewaretoken", "authenticity_token"};
    private List<AntiCsrfParamToken> tokens = null;
    private List<String> enabledTokensNames = null;
    private boolean confirmRemoveToken = true;

    @Override
    protected void parse() {
        try {
            String[] stringArray = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_TOKENS_KEY);
            this.tokens = new ArrayList<AntiCsrfParamToken>(stringArray.size());
            this.enabledTokensNames = new ArrayList<String>(stringArray.size());
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.size());
            for (HierarchicalConfiguration object : stringArray) {
                String string = object.getString(TOKEN_NAME_KEY, "");
                if ("".equals(string) || arrayList.contains(string)) continue;
                boolean bl = object.getBoolean(TOKEN_ENABLED_KEY, true);
                this.tokens.add(new AntiCsrfParamToken(string, bl));
                arrayList.add(string);
                if (!bl) continue;
                this.enabledTokensNames.add(string);
            }
        }
        catch (ConversionException conversionException) {
            logger.error((Object)("Error while loading anti CSRF tokens: " + conversionException.getMessage()), (Throwable)conversionException);
            this.tokens = new ArrayList<AntiCsrfParamToken>(DEFAULT_TOKENS_NAMES.length);
            this.enabledTokensNames = new ArrayList<String>(DEFAULT_TOKENS_NAMES.length);
        }
        if (this.tokens.size() == 0) {
            for (String string : DEFAULT_TOKENS_NAMES) {
                this.tokens.add(new AntiCsrfParamToken(string));
                this.enabledTokensNames.add(string);
            }
        }
        try {
            this.confirmRemoveToken = this.getConfig().getBoolean(CONFIRM_REMOVE_TOKEN_KEY, true);
        }
        catch (ConversionException conversionException) {
            logger.error((Object)("Error while loading the confirm remove token option: " + conversionException.getMessage()), (Throwable)conversionException);
        }
    }

    @ZapApiIgnore
    public List<AntiCsrfParamToken> getTokens() {
        return this.tokens;
    }

    @ZapApiIgnore
    public void setTokens(List<AntiCsrfParamToken> list) {
        this.tokens = new ArrayList<AntiCsrfParamToken>(list);
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_TOKENS_KEY);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = "anticsrf.tokens.token(" + i + ").";
            AntiCsrfParamToken antiCsrfParamToken = list.get(i);
            this.getConfig().setProperty(string + TOKEN_NAME_KEY, (Object)antiCsrfParamToken.getName());
            this.getConfig().setProperty(string + TOKEN_ENABLED_KEY, (Object)antiCsrfParamToken.isEnabled());
            if (!antiCsrfParamToken.isEnabled()) continue;
            arrayList.add(antiCsrfParamToken.getName());
        }
        arrayList.trimToSize();
        this.enabledTokensNames = arrayList;
    }

    public void addToken(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        Iterator<AntiCsrfParamToken> iterator = this.tokens.iterator();
        while (iterator.hasNext()) {
            if (!string.equals(iterator.next().getName())) continue;
            return;
        }
        this.tokens.add(new AntiCsrfParamToken(string));
        this.enabledTokensNames.add(string);
    }

    public void removeToken(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        Iterator<AntiCsrfParamToken> iterator = this.tokens.iterator();
        while (iterator.hasNext()) {
            AntiCsrfParamToken antiCsrfParamToken = iterator.next();
            if (!string.equals(antiCsrfParamToken.getName())) continue;
            iterator.remove();
            if (!antiCsrfParamToken.isEnabled()) break;
            this.enabledTokensNames.remove(string);
            break;
        }
    }

    public List<String> getTokensNames() {
        return this.enabledTokensNames;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveToken() {
        return this.confirmRemoveToken;
    }

    @ZapApiIgnore
    public void setConfirmRemoveToken(boolean bl) {
        this.confirmRemoveToken = bl;
        this.getConfig().setProperty(CONFIRM_REMOVE_TOKEN_KEY, (Object)this.confirmRemoveToken);
    }
}

