'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var cov_6np2uykqo = function () {
  var path = '/Users/gajuskuizinas/Documents/dev/gajus/table/src/makeConfig.js',
      hash = '737b4d2d082188ccc29e35a8836e0d096382661a',
      global = new Function('return this')(),
      gcv = '__coverage__',
      coverageData = {
    path: '/Users/gajuskuizinas/Documents/dev/gajus/table/src/makeConfig.js',
    statementMap: {
      '0': {
        start: {
          line: 12,
          column: 19
        },
        end: {
          line: 14,
          column: 1
        }
      },
      '1': {
        start: {
          line: 13,
          column: 2
        },
        end: {
          line: 13,
          column: 64
        }
      },
      '2': {
        start: {
          line: 25,
          column: 20
        },
        end: {
          line: 44,
          column: 1
        }
      },
      '3': {
        start: {
          line: 26,
          column: 34
        },
        end: {
          line: 26,
          column: 72
        }
      },
      '4': {
        start: {
          line: 28,
          column: 2
        },
        end: {
          line: 41,
          column: 5
        }
      },
      '5': {
        start: {
          line: 29,
          column: 4
        },
        end: {
          line: 31,
          column: 5
        }
      },
      '6': {
        start: {
          line: 30,
          column: 6
        },
        end: {
          line: 30,
          column: 26
        }
      },
      '7': {
        start: {
          line: 33,
          column: 4
        },
        end: {
          line: 40,
          column: 38
        }
      },
      '8': {
        start: {
          line: 43,
          column: 2
        },
        end: {
          line: 43,
          column: 17
        }
      },
      '9': {
        start: {
          line: 55,
          column: 2
        },
        end: {
          line: 55,
          column: 44
        }
      },
      '10': {
        start: {
          line: 57,
          column: 17
        },
        end: {
          line: 57,
          column: 40
        }
      },
      '11': {
        start: {
          line: 59,
          column: 2
        },
        end: {
          line: 59,
          column: 44
        }
      },
      '12': {
        start: {
          line: 60,
          column: 2
        },
        end: {
          line: 60,
          column: 75
        }
      },
      '13': {
        start: {
          line: 62,
          column: 2
        },
        end: {
          line: 69,
          column: 3
        }
      },
      '14': {
        start: {
          line: 66,
          column: 4
        },
        end: {
          line: 68,
          column: 6
        }
      },
      '15': {
        start: {
          line: 67,
          column: 6
        },
        end: {
          line: 67,
          column: 18
        }
      },
      '16': {
        start: {
          line: 71,
          column: 2
        },
        end: {
          line: 71,
          column: 16
        }
      }
    },
    fnMap: {
      '0': {
        name: '(anonymous_0)',
        decl: {
          start: {
            line: 12,
            column: 19
          },
          end: {
            line: 12,
            column: 20
          }
        },
        loc: {
          start: {
            line: 12,
            column: 36
          },
          end: {
            line: 14,
            column: 1
          }
        }
      },
      '1': {
        name: '(anonymous_1)',
        decl: {
          start: {
            line: 25,
            column: 20
          },
          end: {
            line: 25,
            column: 21
          }
        },
        loc: {
          start: {
            line: 25,
            column: 64
          },
          end: {
            line: 44,
            column: 1
          }
        }
      },
      '2': {
        name: '(anonymous_2)',
        decl: {
          start: {
            line: 28,
            column: 26
          },
          end: {
            line: 28,
            column: 27
          }
        },
        loc: {
          start: {
            line: 28,
            column: 37
          },
          end: {
            line: 41,
            column: 3
          }
        }
      },
      '3': {
        name: '(anonymous_3)',
        decl: {
          start: {
            line: 54,
            column: 15
          },
          end: {
            line: 54,
            column: 16
          }
        },
        loc: {
          start: {
            line: 54,
            column: 42
          },
          end: {
            line: 72,
            column: 1
          }
        }
      },
      '4': {
        name: '(anonymous_4)',
        decl: {
          start: {
            line: 66,
            column: 32
          },
          end: {
            line: 66,
            column: 33
          }
        },
        loc: {
          start: {
            line: 66,
            column: 38
          },
          end: {
            line: 68,
            column: 5
          }
        }
      }
    },
    branchMap: {
      '0': {
        loc: {
          start: {
            line: 12,
            column: 20
          },
          end: {
            line: 12,
            column: 31
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 12,
            column: 29
          },
          end: {
            line: 12,
            column: 31
          }
        }]
      },
      '1': {
        loc: {
          start: {
            line: 25,
            column: 27
          },
          end: {
            line: 25,
            column: 39
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 25,
            column: 37
          },
          end: {
            line: 25,
            column: 39
          }
        }]
      },
      '2': {
        loc: {
          start: {
            line: 25,
            column: 41
          },
          end: {
            line: 25,
            column: 59
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 25,
            column: 57
          },
          end: {
            line: 25,
            column: 59
          }
        }]
      },
      '3': {
        loc: {
          start: {
            line: 29,
            column: 4
          },
          end: {
            line: 31,
            column: 5
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 29,
            column: 4
          },
          end: {
            line: 31,
            column: 5
          }
        }, {
          start: {
            line: 29,
            column: 4
          },
          end: {
            line: 31,
            column: 5
          }
        }]
      },
      '4': {
        loc: {
          start: {
            line: 54,
            column: 22
          },
          end: {
            line: 54,
            column: 37
          }
        },
        type: 'default-arg',
        locations: [{
          start: {
            line: 54,
            column: 35
          },
          end: {
            line: 54,
            column: 37
          }
        }]
      },
      '5': {
        loc: {
          start: {
            line: 62,
            column: 2
          },
          end: {
            line: 69,
            column: 3
          }
        },
        type: 'if',
        locations: [{
          start: {
            line: 62,
            column: 2
          },
          end: {
            line: 69,
            column: 3
          }
        }, {
          start: {
            line: 62,
            column: 2
          },
          end: {
            line: 69,
            column: 3
          }
        }]
      }
    },
    s: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0,
      '5': 0,
      '6': 0,
      '7': 0,
      '8': 0,
      '9': 0,
      '10': 0,
      '11': 0,
      '12': 0,
      '13': 0,
      '14': 0,
      '15': 0,
      '16': 0
    },
    f: {
      '0': 0,
      '1': 0,
      '2': 0,
      '3': 0,
      '4': 0
    },
    b: {
      '0': [0],
      '1': [0],
      '2': [0],
      '3': [0, 0],
      '4': [0],
      '5': [0, 0]
    }
  },
      coverage = global[gcv] || (global[gcv] = {});

  if (coverage[path] && coverage[path].hash === hash) {
    return coverage[path];
  }

  coverageData.hash = hash;
  return coverage[path] = coverageData;
}();

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _getBorderCharacters = require('./getBorderCharacters');

var _getBorderCharacters2 = _interopRequireDefault(_getBorderCharacters);

var _validateConfig = require('./validateConfig');

var _validateConfig2 = _interopRequireDefault(_validateConfig);

var _calculateMaximumColumnWidthIndex = require('./calculateMaximumColumnWidthIndex');

var _calculateMaximumColumnWidthIndex2 = _interopRequireDefault(_calculateMaximumColumnWidthIndex);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Merges user provided border characters with the default border ("honeywell") characters.
 *
 * @param {Object} border
 * @returns {Object}
 */
const makeBorder = (++cov_6np2uykqo.s[0], function () {
  let border = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : (++cov_6np2uykqo.b[0][0], {});
  ++cov_6np2uykqo.f[0];
  ++cov_6np2uykqo.s[1];

  return _lodash2.default.assign({}, (0, _getBorderCharacters2.default)('honeywell'), border);
});

/**
 * Creates a configuration for every column using default
 * values for the missing configuration properties.
 *
 * @param {Array[]} rows
 * @param {Object} columns
 * @param {Object} columnDefault
 * @returns {Object}
 */
const makeColumns = (++cov_6np2uykqo.s[2], function (rows) {
  let columns = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (++cov_6np2uykqo.b[1][0], {});
  let columnDefault = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : (++cov_6np2uykqo.b[2][0], {});
  ++cov_6np2uykqo.f[1];

  const maximumColumnWidthIndex = (++cov_6np2uykqo.s[3], (0, _calculateMaximumColumnWidthIndex2.default)(rows));

  ++cov_6np2uykqo.s[4];
  _lodash2.default.times(rows[0].length, index => {
    ++cov_6np2uykqo.f[2];
    ++cov_6np2uykqo.s[5];

    if (_lodash2.default.isUndefined(columns[index])) {
      ++cov_6np2uykqo.b[3][0];
      ++cov_6np2uykqo.s[6];

      columns[index] = {};
    } else {
      ++cov_6np2uykqo.b[3][1];
    }

    ++cov_6np2uykqo.s[7];
    columns[index] = _lodash2.default.assign({
      alignment: 'left',
      paddingLeft: 1,
      paddingRight: 1,
      truncate: Infinity,
      width: maximumColumnWidthIndex[index],
      wrapWord: false
    }, columnDefault, columns[index]);
  });

  ++cov_6np2uykqo.s[8];
  return columns;
});

/**
 * Makes a new configuration object out of the userConfig object
 * using default values for the missing configuration properties.
 *
 * @param {Array[]} rows
 * @param {Object} userConfig
 * @returns {Object}
 */

exports.default = function (rows) {
  let userConfig = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (++cov_6np2uykqo.b[4][0], {});
  ++cov_6np2uykqo.f[3];
  ++cov_6np2uykqo.s[9];

  (0, _validateConfig2.default)('config.json', userConfig);

  const config = (++cov_6np2uykqo.s[10], _lodash2.default.cloneDeep(userConfig));

  ++cov_6np2uykqo.s[11];
  config.border = makeBorder(config.border);
  ++cov_6np2uykqo.s[12];
  config.columns = makeColumns(rows, config.columns, config.columnDefault);

  ++cov_6np2uykqo.s[13];
  if (!config.drawHorizontalLine) {
    ++cov_6np2uykqo.b[5][0];
    ++cov_6np2uykqo.s[14];

    /**
     * @returns {boolean}
     */
    config.drawHorizontalLine = () => {
      ++cov_6np2uykqo.f[4];
      ++cov_6np2uykqo.s[15];

      return true;
    };
  } else {
    ++cov_6np2uykqo.b[5][1];
  }

  ++cov_6np2uykqo.s[16];
  return config;
};

module.exports = exports['default'];