/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver.model;

import java.io.File;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.plugins.ide.internal.resolver.model.IdeRepoFileDependency;

public class IdeExtendedRepoFileDependency
extends IdeRepoFileDependency {
    private static final Comparator<File> FILE_COMPARATOR = new FileNameComparator();
    private final SortedSet<File> sourceFiles = new TreeSet<File>(FILE_COMPARATOR);
    private final SortedSet<File> javadocFiles = new TreeSet<File>(FILE_COMPARATOR);

    public IdeExtendedRepoFileDependency(File file) {
        super(file);
    }

    public File getSourceFile() {
        return this.sourceFiles.isEmpty() ? null : this.sourceFiles.first();
    }

    public Set<File> getSourceFiles() {
        return this.sourceFiles;
    }

    public void addSourceFile(File sourceFile) {
        this.sourceFiles.add(sourceFile);
    }

    public File getJavadocFile() {
        return this.javadocFiles.isEmpty() ? null : this.javadocFiles.first();
    }

    public Set<File> getJavadocFiles() {
        return this.javadocFiles;
    }

    public void addJavadocFile(File javadocFile) {
        this.javadocFiles.add(javadocFile);
    }

    private static class FileNameComparator
    implements Comparator<File> {
        private FileNameComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

