/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.file;

import java.io.IOException;
import java.net.URI;
import org.gradle.api.Nullable;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transport.AbstractRepositoryTransport;
import org.gradle.internal.resource.transport.ExternalResourceRepository;
import org.gradle.internal.resource.transport.file.FileResourceConnector;

public class FileTransport
extends AbstractRepositoryTransport {
    private final FileResourceConnector repository = new FileResourceConnector();
    private final NoOpCacheAwareExternalResourceAccessor resourceAccessor = new NoOpCacheAwareExternalResourceAccessor(this.repository);

    public FileTransport(String name) {
        super(name);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public ExternalResourceRepository getRepository() {
        return this.repository;
    }

    @Override
    public CacheAwareExternalResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    private static class NoOpCacheAwareExternalResourceAccessor
    implements CacheAwareExternalResourceAccessor {
        private final FileResourceConnector connector;

        public NoOpCacheAwareExternalResourceAccessor(FileResourceConnector connector) {
            this.connector = connector;
        }

        @Override
        public LocallyAvailableExternalResource getResource(URI source, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, @Nullable LocallyAvailableResourceCandidates localCandidates) throws IOException {
            return this.connector.getResource(source);
        }
    }
}

