/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class TextHighlighter
extends DefaultStyledDocument {
    private static final long serialVersionUID = 3812224127502539817L;
    private final HashMap<String, Color> keywords = new HashMap();
    private final MutableAttributeSet style;

    public TextHighlighter() {
        this.keywords.put("GET", Color.black);
        this.keywords.put("PUT", Color.black);
        this.keywords.put("POST", Color.black);
        this.keywords.put("HEAD", Color.black);
        this.keywords.put("TRACE", Color.black);
        this.keywords.put("PROPFIND", Color.black);
        this.keywords.put("HTTP/\\d.\\d", Color.black);
        Color lightBlue = new Color(51, 102, 102);
        this.keywords.put("Apache", lightBlue);
        this.keywords.put("Windows", lightBlue);
        this.keywords.put("Windows NT \\d.\\d", lightBlue);
        this.keywords.put("Mozilla/\\d.\\d", lightBlue);
        this.keywords.put("Firefox", lightBlue);
        this.keywords.put("Internet", lightBlue);
        this.keywords.put("Gecko", lightBlue);
        this.keywords.put("Keep-Alive", lightBlue);
        this.keywords.put("keep-alive", lightBlue);
        this.keywords.put("Mozilla", lightBlue);
        this.keywords.put("MSIE", lightBlue);
        this.keywords.put("SymbianOS", lightBlue);
        this.keywords.put("Chrome", lightBlue);
        this.keywords.put("Safari", lightBlue);
        this.keywords.put("Linux", lightBlue);
        this.keywords.put("Android", lightBlue);
        Color darkGreen = new Color(0, 128, 0);
        this.keywords.put("ISO-[0-9]{4}-[0-9]", darkGreen);
        this.keywords.put("iso-[0-9]{4}-[0-9]", darkGreen);
        this.keywords.put("utf-[0-9]{2}", darkGreen);
        this.keywords.put("UTF-[0-9]{2}", darkGreen);
        this.keywords.put("GMT", darkGreen);
        this.keywords.put("utf-8", darkGreen);
        this.keywords.put("private", darkGreen);
        this.keywords.put("public", darkGreen);
        this.keywords.put("text", darkGreen);
        this.keywords.put("xml", darkGreen);
        this.keywords.put("png", darkGreen);
        this.keywords.put("image", darkGreen);
        this.keywords.put("application", darkGreen);
        this.keywords.put("HttpOnly", darkGreen);
        this.keywords.put("CLR", darkGreen);
        this.keywords.put("html", Color.green);
        this.keywords.put("gif", Color.green);
        this.keywords.put("pjpeg", Color.green);
        this.keywords.put("jpeg", Color.green);
        this.keywords.put("xhtml", Color.green);
        this.keywords.put("x-xbitmap", Color.green);
        this.keywords.put("plain", Color.green);
        this.keywords.put("iPhone", Color.green);
        Color dateColor = new Color(153, 0, 153);
        this.keywords.put("Mon", dateColor);
        this.keywords.put("Tue", dateColor);
        this.keywords.put("Wed", dateColor);
        this.keywords.put("Thu", dateColor);
        this.keywords.put("Fri", dateColor);
        this.keywords.put("Sat", dateColor);
        this.keywords.put("Sun", dateColor);
        this.keywords.put("Jan", dateColor);
        this.keywords.put("Feb", dateColor);
        this.keywords.put("Mar", dateColor);
        this.keywords.put("Apr", dateColor);
        this.keywords.put("May", dateColor);
        this.keywords.put("Jun", dateColor);
        this.keywords.put("Jul", dateColor);
        this.keywords.put("Aug", dateColor);
        this.keywords.put("Sep", dateColor);
        this.keywords.put("Oct", dateColor);
        this.keywords.put("Nov", dateColor);
        this.keywords.put("Dec", dateColor);
        Color keramidi = new Color(204, 51, 0);
        this.keywords.put("en", keramidi);
        this.keywords.put("en-us", keramidi);
        this.keywords.put("en-gb", keramidi);
        this.keywords.put("en-GB", keramidi);
        this.keywords.put("en-US", keramidi);
        this.keywords.put("XMLHttpRequest", keramidi);
        this.keywords.put("gzip", keramidi);
        this.keywords.put("x-gzip", keramidi);
        this.keywords.put("x86", keramidi);
        this.keywords.put("localhost", keramidi);
        this.keywords.put("identity", keramidi);
        this.keywords.put("compatible", keramidi);
        this.keywords.put("deflate", Color.orange);
        this.keywords.put("sdch", Color.orange);
        this.keywords.put("bzip2", Color.orange);
        this.keywords.put("[\\d\\.]+", Color.orange);
        this.keywords.put("[\\w]+=", Color.magenta);
        this.keywords.put(";", Color.red);
        this.keywords.put("/", Color.red);
        this.keywords.put("?", Color.red);
        this.keywords.put(":", Color.red);
        this.keywords.put("@", Color.red);
        this.keywords.put("$", Color.red);
        this.keywords.put("Accept", Color.blue);
        this.keywords.put("Accept-Charset", Color.blue);
        this.keywords.put("Accept-charset", Color.blue);
        this.keywords.put("Accept-Encoding", Color.blue);
        this.keywords.put("Accept-encoding", Color.blue);
        this.keywords.put("Accept-Language", Color.blue);
        this.keywords.put("Age", Color.blue);
        this.keywords.put("Cache-Control", Color.blue);
        this.keywords.put("Cache-control", Color.blue);
        this.keywords.put("Connection", Color.blue);
        this.keywords.put("Content-Encoding", Color.blue);
        this.keywords.put("Content-encoding", Color.blue);
        this.keywords.put("Content-language", Color.blue);
        this.keywords.put("content-length", Color.blue);
        this.keywords.put("Content-length", Color.blue);
        this.keywords.put("Content-Length", Color.blue);
        this.keywords.put("Accept-Ranges", Color.blue);
        this.keywords.put("Content-type", Color.blue);
        this.keywords.put("Content-Type", Color.blue);
        this.keywords.put("Cookie", Color.blue);
        this.keywords.put("Date", Color.blue);
        this.keywords.put("ETag", Color.blue);
        this.keywords.put("Expect", Color.blue);
        this.keywords.put("expect", Color.blue);
        this.keywords.put("Expires", Color.blue);
        this.keywords.put("expires", Color.blue);
        this.keywords.put("Host", Color.blue);
        this.keywords.put("^Keep-Alive", Color.blue);
        this.keywords.put("Last-Modified", Color.blue);
        this.keywords.put("Last-modified", Color.blue);
        this.keywords.put("Location", Color.blue);
        this.keywords.put("Mime-Version", Color.blue);
        this.keywords.put("P3P", Color.blue);
        this.keywords.put("P3p", Color.blue);
        this.keywords.put("Pragma", Color.blue);
        this.keywords.put("Proxy-Agent", Color.blue);
        this.keywords.put("Proxy-agent", Color.blue);
        this.keywords.put("Proxy-Authorization", Color.blue);
        this.keywords.put("Proxy-authorization", Color.blue);
        this.keywords.put("Proxy-Connection", Color.blue);
        this.keywords.put("Referer", Color.blue);
        this.keywords.put("Server", Color.blue);
        this.keywords.put("Set-Cookie", Color.blue);
        this.keywords.put("Set-cookie", Color.blue);
        this.keywords.put("Transfer-Encoding", Color.blue);
        this.keywords.put("UA-CPU", Color.blue);
        this.keywords.put("UA-color", Color.blue);
        this.keywords.put("UA-pixels", Color.blue);
        this.keywords.put("UA-OS", Color.blue);
        this.keywords.put("User-Agent", Color.blue);
        this.keywords.put("User-agent", Color.blue);
        this.keywords.put("Vary", Color.blue);
        this.keywords.put("Via", Color.blue);
        this.keywords.put("X-AspNet-Version", Color.blue);
        this.keywords.put("x-aspnet-version", Color.blue);
        this.keywords.put("x-aspnetmvc-version", Color.blue);
        this.keywords.put("X-Cache-TTL", Color.blue);
        this.keywords.put("X-Cached-Time", Color.blue);
        this.keywords.put("X-Content-Type-Options", Color.blue);
        this.keywords.put("X-PHP-Load", Color.blue);
        this.keywords.put("X-Powered-By", Color.blue);
        this.keywords.put("X-Powered-by", Color.blue);
        this.keywords.put("X-powered-by", Color.blue);
        this.keywords.put("X-Requested-With", Color.blue);
        this.keywords.put("X-SDCH", Color.blue);
        this.keywords.put("x-ps3-browser", Color.blue);
        this.keywords.put("x-wap-profile", Color.blue);
        this.keywords.put("x-prototype-version", Color.blue);
        this.keywords.put("x-requested-with", Color.blue);
        String prefixHTML = "|\\B+\\<.?";
        String suffixHTML = "+\\>\\B|";
        this.keywords.put("|\\B+\\<.? +\\>\\B|", Color.blue);
        this.keywords.put("|\\B+\\<.?html+\\>\\B|", Color.green);
        this.keywords.put("|\\B+\\<.?hr+\\>\\B|", Color.pink);
        this.keywords.put("|\\B+\\<.?header.*+\\>\\B|", Color.cyan);
        this.keywords.put("|\\B+\\<.?body+\\>\\B|", Color.red);
        this.keywords.put("|\\B+\\<.?title+\\>\\B|", Color.yellow);
        this.keywords.put("|\\B+\\<.?b+\\>\\B|", Color.blue);
        this.keywords.put("|\\B+\\<.?i+\\>\\B|", Color.green);
        this.keywords.put("|\\B+\\<.?u+\\>\\B|", Color.pink);
        this.keywords.put("|\\B+\\<.?sup+\\>\\B|", Color.cyan);
        this.keywords.put("|\\B+\\<.?sub+\\>\\B|", Color.yellow);
        this.keywords.put("|\\B+\\<.?tt+\\>\\B|", Color.magenta);
        this.keywords.put("|\\B+\\<.?h+\\d+\\>\\B|", Color.pink);
        this.keywords.put("|\\B+\\<.?small+\\>\\B|", Color.darkGray);
        this.keywords.put("|\\B+\\<.?big+\\>\\B|", Color.green);
        this.keywords.put("|\\B+\\<.?font+\\>\\B|", Color.pink);
        this.keywords.put("|\\B+\\<.?p+\\>\\B|", Color.darkGray);
        this.keywords.put("|\\B+\\<.?center+\\>\\B|", Color.blue);
        this.keywords.put("|\\B+\\<.?br+\\>\\B|", Color.gray);
        this.keywords.put("|\\B+\\<.?nobr +\\>\\B|", Color.red);
        this.keywords.put("|\\B+\\<.?blockquote+\\>\\B|", Color.green);
        this.keywords.put("|\\B+\\<.?li+\\>\\B|", Color.blue);
        this.keywords.put("|\\B+\\<.?ul+\\>\\B|", Color.gray);
        this.keywords.put("|\\B+\\<.?ol+\\>\\B|", Color.green);
        this.keywords.put("|\\B+\\<.?a+\\>\\B|", Color.blue);
        this.keywords.put("|\\B+\\<.?table+\\>\\B|", Color.yellow);
        this.keywords.put("|\\B+\\<.?td+\\>\\B|", Color.magenta);
        this.keywords.put("|\\B+\\<.?tr+\\>\\B|", Color.pink);
        this.keywords.put("|\\B+\\<.?div+\\>\\B|", Color.green);
        this.keywords.put("|\\B+\\<.?footer+\\>\\B|", Color.green);
        this.keywords.put("|\\B+\\<.?iframe+\\>\\B|", Color.lightGray);
        this.keywords.put("|\\B+\\<.?span+\\>\\B|", Color.magenta);
        this.keywords.put("|\\B+\\<.?!--+\\B|", Color.orange);
        this.keywords.put("|\\B+.?--+\\>\\B|", Color.orange);
        this.style = new SimpleAttributeSet();
    }

    private void highlightString(Color col, int begin, int length, boolean flag, boolean bold) {
        StyleConstants.setForeground(this.style, col);
        StyleConstants.setBold(this.style, bold);
        this.setCharacterAttributes(begin, length, this.style, flag);
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        super.insertString(offset, str, attr);
        this.processChangedLines(offset, str.length());
    }

    private void processChangedLines(int offset, int length) throws BadLocationException {
        String text = this.getText(0, this.getLength());
        this.highlightString(Color.black, 0, this.getLength(), true, false);
        Set<String> keyw = this.keywords.keySet();
        for (String keyword : keyw) {
            Color col = this.keywords.get(keyword);
            Pattern p = Pattern.compile("\\b" + keyword + "\\b");
            Matcher m = p.matcher(text);
            while (m.find()) {
                this.highlightString(col, m.start(), m.group().length(), true, true);
            }
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.processChangedLines(offset, length);
    }
}

