/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.zaproxy.zap.utils.ExecutorTerminatedListener;
import org.zaproxy.zap.utils.PausableExecutorService;

public class PausableThreadPoolExecutor
extends ThreadPoolExecutor
implements PausableExecutorService {
    private final ReentrantLock pauseLock = new ReentrantLock();
    private final Condition unpaused = this.pauseLock.newCondition();
    private boolean paused;
    private List<ExecutorTerminatedListener> listeners = new ArrayList<ExecutorTerminatedListener>(1);

    public PausableThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory());
    }

    public PausableThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory);
    }

    public PausableThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public PausableThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory, rejectedExecutionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        this.pauseLock.lock();
        try {
            while (this.paused) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException interruptedException) {
            thread.interrupt();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        this.pauseLock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        this.pauseLock.lock();
        try {
            if (!this.paused) {
                return;
            }
            this.paused = false;
            this.unpaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.resume();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.resume();
        return super.shutdownNow();
    }

    @Override
    protected void terminated() {
        super.terminated();
        PausableThreadPoolExecutor.notifyListeners(new ArrayList<ExecutorTerminatedListener>(this.listeners));
    }

    private static void notifyListeners(List<ExecutorTerminatedListener> list) {
        for (ExecutorTerminatedListener executorTerminatedListener : list) {
            executorTerminatedListener.terminated();
        }
    }

    @Override
    public void addExecutorTerminatedListener(ExecutorTerminatedListener executorTerminatedListener) {
        this.listeners.add(executorTerminatedListener);
    }

    @Override
    public void removeExecutorTerminatedListener(ExecutorTerminatedListener executorTerminatedListener) {
        this.listeners.remove(executorTerminatedListener);
    }
}

