/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.notations;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.artifacts.dependencies.DefaultSelfResolvingDependency;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.FileCollectionAdapter;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.SingletonFileSet;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarFactory;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarType;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

public class DependencyClassPathNotationConverter
implements NotationConverter<DependencyFactory.ClassPathNotation, SelfResolvingDependency> {
    private final ClassPathRegistry classPathRegistry;
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final RuntimeShadedJarFactory runtimeShadedJarFactory;
    private final CurrentGradleInstallation currentGradleInstallation;
    private final Map<DependencyFactory.ClassPathNotation, SelfResolvingDependency> internCache = Maps.newEnumMap(DependencyFactory.ClassPathNotation.class);
    private final Lock internCacheWriteLock = new ReentrantLock();

    public DependencyClassPathNotationConverter(Instantiator instantiator, ClassPathRegistry classPathRegistry, FileResolver fileResolver, RuntimeShadedJarFactory runtimeShadedJarFactory, CurrentGradleInstallation currentGradleInstallation) {
        this.instantiator = instantiator;
        this.classPathRegistry = classPathRegistry;
        this.fileResolver = fileResolver;
        this.runtimeShadedJarFactory = runtimeShadedJarFactory;
        this.currentGradleInstallation = currentGradleInstallation;
    }

    public void describe(DiagnosticsVisitor visitor) {
        visitor.candidate("ClassPathNotation").example("gradleApi()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(DependencyFactory.ClassPathNotation notation, NotationConvertResult<? super SelfResolvingDependency> result) throws TypeConversionException {
        SelfResolvingDependency dependency = this.internCache.get(notation);
        if (dependency == null) {
            this.internCacheWriteLock.lock();
            try {
                dependency = this.maybeCreateUnderLock(notation);
            }
            finally {
                this.internCacheWriteLock.unlock();
            }
        }
        result.converted((Object)dependency);
    }

    private SelfResolvingDependency maybeCreateUnderLock(DependencyFactory.ClassPathNotation notation) {
        SelfResolvingDependency dependency = this.internCache.get(notation);
        if (dependency == null) {
            boolean runningFromInstallation;
            List classpath = this.classPathRegistry.getClassPath(notation.name()).getAsFiles();
            boolean bl = runningFromInstallation = this.currentGradleInstallation.getInstallation() != null;
            FileCollectionInternal files = runningFromInstallation && notation.equals((Object)DependencyFactory.ClassPathNotation.GRADLE_API) ? this.gradleApiFileCollection(classpath) : (runningFromInstallation && notation.equals((Object)DependencyFactory.ClassPathNotation.GRADLE_TEST_KIT) ? this.gradleTestKitFileCollection(classpath) : this.fileResolver.resolveFiles(new Object[]{classpath}));
            dependency = (SelfResolvingDependency)this.instantiator.newInstance(DefaultSelfResolvingDependency.class, new Object[]{files});
            this.internCache.put(notation, dependency);
        }
        return dependency;
    }

    private FileCollectionInternal gradleApiFileCollection(Collection<File> apiClasspath) {
        List groovyImpl = this.classPathRegistry.getClassPath(DependencyFactory.ClassPathNotation.LOCAL_GROOVY.name()).getAsFiles();
        List installationBeacon = this.classPathRegistry.getClassPath("GRADLE_INSTALLATION_BEACON").getAsFiles();
        apiClasspath.removeAll(groovyImpl);
        apiClasspath.removeAll(installationBeacon);
        this.removeGradleScriptKotlin(apiClasspath);
        return (FileCollectionInternal)this.relocatedDepsJar(apiClasspath, "gradleApi()", RuntimeShadedJarType.API).plus((FileCollection)this.fileResolver.resolveFiles(new Object[]{groovyImpl, installationBeacon}));
    }

    private void removeGradleScriptKotlin(Collection<File> apiClasspath) {
        for (File file : new ArrayList<File>(apiClasspath)) {
            if (!file.getName().contains("kotlin")) continue;
            apiClasspath.remove(file);
        }
    }

    private FileCollectionInternal gradleTestKitFileCollection(Collection<File> testKitClasspath) {
        List gradleApi = this.classPathRegistry.getClassPath(DependencyFactory.ClassPathNotation.GRADLE_API.name()).getAsFiles();
        testKitClasspath.removeAll(gradleApi);
        return (FileCollectionInternal)this.relocatedDepsJar(testKitClasspath, "gradleTestKit()", RuntimeShadedJarType.TEST_KIT).plus((FileCollection)this.gradleApiFileCollection(gradleApi));
    }

    private FileCollectionInternal relocatedDepsJar(Collection<File> classpath, String displayName, RuntimeShadedJarType runtimeShadedJarType) {
        File gradleImplDepsJar = this.runtimeShadedJarFactory.get(runtimeShadedJarType, classpath);
        return new FileCollectionAdapter((MinimalFileSet)new SingletonFileSet(gradleImplDepsJar, displayName));
    }
}

