/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.springframework.test.util.AssertionErrors;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JsonPathExpectationsHelper {
    private final String expression;
    private final JsonPath jsonPath;

    public JsonPathExpectationsHelper(String expression, Object ... args) {
        Assert.hasText((String)expression, (String)"expression must not be null or empty");
        this.expression = String.format(expression, args);
        this.jsonPath = JsonPath.compile((String)this.expression, (Predicate[])new Predicate[0]);
    }

    public <T> void assertValue(String content, Matcher<T> matcher) throws ParseException {
        Object value = this.evaluateJsonPath(content);
        MatcherAssert.assertThat((String)("JSON path \"" + this.expression + "\""), (Object)value, matcher);
    }

    public void assertValue(String content, Object expectedValue) throws ParseException {
        Object actualValue = this.evaluateJsonPath(content);
        if (actualValue instanceof List && !(expectedValue instanceof List)) {
            List actualValueList = (List)actualValue;
            if (actualValueList.isEmpty()) {
                AssertionErrors.fail("No matching value at JSON path \"" + this.expression + "\"");
            }
            if (actualValueList.size() != 1) {
                AssertionErrors.fail("Got a list of values " + actualValue + " instead of the expected single value " + expectedValue);
            }
            actualValue = actualValueList.get(0);
        } else if (actualValue != null && expectedValue != null) {
            AssertionErrors.assertEquals("At JSON path \"" + this.expression + "\", type of value", expectedValue.getClass().getName(), actualValue.getClass().getName());
        }
        AssertionErrors.assertEquals("JSON path \"" + this.expression + "\"", expectedValue, actualValue);
    }

    public void assertValueIsString(String content) throws ParseException {
        Object value = this.assertExistsAndReturn(content);
        MatcherAssert.assertThat((String)this.failureReason("a string", value), (Object)value, (Matcher)IsInstanceOf.instanceOf(String.class));
    }

    public void assertValueIsBoolean(String content) throws ParseException {
        Object value = this.assertExistsAndReturn(content);
        MatcherAssert.assertThat((String)this.failureReason("a boolean", value), (Object)value, (Matcher)IsInstanceOf.instanceOf(Boolean.class));
    }

    public void assertValueIsNumber(String content) throws ParseException {
        Object value = this.assertExistsAndReturn(content);
        MatcherAssert.assertThat((String)this.failureReason("a number", value), (Object)value, (Matcher)IsInstanceOf.instanceOf(Number.class));
    }

    public void assertValueIsArray(String content) throws ParseException {
        Object value = this.assertExistsAndReturn(content);
        MatcherAssert.assertThat((String)this.failureReason("an array", value), (Object)value, (Matcher)IsInstanceOf.instanceOf(List.class));
    }

    public void assertValueIsMap(String content) throws ParseException {
        Object value = this.assertExistsAndReturn(content);
        MatcherAssert.assertThat((String)this.failureReason("a map", value), (Object)value, (Matcher)IsInstanceOf.instanceOf(Map.class));
    }

    public void exists(String content) throws ParseException {
        this.assertExistsAndReturn(content);
    }

    public void doesNotExist(String content) throws ParseException {
        Object value;
        try {
            value = this.evaluateJsonPath(content);
        }
        catch (AssertionError ex) {
            return;
        }
        String reason = this.failureReason("no value", value);
        if (this.pathIsIndefinite() && value instanceof List) {
            AssertionErrors.assertTrue(reason, ((List)value).isEmpty());
        } else {
            AssertionErrors.assertTrue(reason, value == null);
        }
    }

    public void assertValueIsEmpty(String content) throws ParseException {
        Object value = this.evaluateJsonPath(content);
        AssertionErrors.assertTrue(this.failureReason("an empty value", value), ObjectUtils.isEmpty((Object)value));
    }

    public void assertValueIsNotEmpty(String content) throws ParseException {
        Object value = this.evaluateJsonPath(content);
        AssertionErrors.assertTrue(this.failureReason("a non-empty value", value), !ObjectUtils.isEmpty((Object)value));
    }

    private String failureReason(String expectedDescription, Object value) {
        return String.format("Expected %s at JSON path \"%s\" but found: %s", expectedDescription, this.expression, ObjectUtils.nullSafeToString((Object)StringUtils.quoteIfString((Object)value)));
    }

    private Object evaluateJsonPath(String content) throws ParseException {
        String message = "No value at JSON path \"" + this.expression + "\", exception: ";
        try {
            return this.jsonPath.read(content);
        }
        catch (InvalidPathException ex) {
            throw new AssertionError((Object)(message + ex.getMessage()));
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new AssertionError((Object)(message + ex.getMessage()));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new AssertionError((Object)(message + ex.getMessage()));
        }
    }

    private Object assertExistsAndReturn(String content) throws ParseException {
        Object value = this.evaluateJsonPath(content);
        String reason = "No value at JSON path \"" + this.expression + "\"";
        AssertionErrors.assertTrue(reason, value != null);
        if (this.pathIsIndefinite() && value instanceof List) {
            AssertionErrors.assertTrue(reason, !((List)value).isEmpty());
        }
        return value;
    }

    private boolean pathIsIndefinite() {
        return !this.jsonPath.isDefinite();
    }
}

