/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.glassfish.json.api.BufferPool;

class BufferPoolImpl
implements BufferPool {
    private volatile WeakReference<ConcurrentLinkedQueue<char[]>> queue;

    BufferPoolImpl() {
    }

    @Override
    public final char[] take() {
        char[] cArray = this.getQueue().poll();
        if (cArray == null) {
            return new char[4096];
        }
        return cArray;
    }

    private ConcurrentLinkedQueue<char[]> getQueue() {
        ConcurrentLinkedQueue<char[]> concurrentLinkedQueue;
        WeakReference<ConcurrentLinkedQueue<char[]>> weakReference = this.queue;
        if (weakReference != null && (concurrentLinkedQueue = (ConcurrentLinkedQueue<char[]>)weakReference.get()) != null) {
            return concurrentLinkedQueue;
        }
        concurrentLinkedQueue = new ConcurrentLinkedQueue<char[]>();
        this.queue = new WeakReference<ConcurrentLinkedQueue<char[]>>(concurrentLinkedQueue);
        return concurrentLinkedQueue;
    }

    @Override
    public final void recycle(char[] cArray) {
        this.getQueue().offer(cArray);
    }
}

