# -*- coding: binary -*-

module Msf
  module Exploit::Remote::SMB::Server
    module Share
      module Command
        module Trans2
          module FindFirst2

            # Handles an TRANS2_FIND_FIRST2 subcommand, used to begin a search for file(s) within a
            # directory or for a directory.
            #
            # @param c [Socket] The client sending the request.
            # @param buff [String] The data including the client request.
            # @return [Fixnum] The number of bytes returned to the client as response.
            def smb_cmd_trans2_find_first2(c, buff)
              smb = @state[c]

              params = CONST::SMB_TRANS2_FIND_FIRST2_PARAMETERS.make_struct
              params.from_s(buff)

              loi = params.v['InformationLevel']
              normalized_path = normalize_path(params.v['FileName'])
              search_path = smb_expand(normalized_path)

              case loi
              when CONST::SMB_FIND_FILE_NAMES_INFO
                return smb_cmd_find_file_names_info(c, search_path)
              when CONST::SMB_FIND_FILE_BOTH_DIRECTORY_INFO
                return smb_cmd_find_file_both_directory_info(c, search_path)
              when CONST::SMB_FIND_FILE_FULL_DIRECTORY_INFO
                return smb_cmd_find_file_full_directory_info(c, search_path)
              else
                # Send STATUS_SUCCESS with the hope of going ahead
                vprint_status("SMB Share - #{smb[:ip]} Unknown TRANS2_FIND_FIRST2 with loi: #{loi.to_s(16)}")
                return smb_error(CONST::SMB_COM_TRANSACTION2, c, CONST::SMB_STATUS_SUCCESS)
              end
            end
          end
        end
      end
    end
  end
end
