/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.Application;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import java.awt.Image;
import java.awt.Toolkit;
import org.apache.log4j.Logger;
import org.zaproxy.zap.GuiBootstrap;
import org.zaproxy.zap.view.osxhandlers.OSXAboutHandler;
import org.zaproxy.zap.view.osxhandlers.OSXPreferencesHandler;
import org.zaproxy.zap.view.osxhandlers.OSXQuitHandler;

class OsXGui {
    private static final Logger LOGGER = Logger.getLogger(OsXGui.class);

    private OsXGui() {
    }

    public static void setup() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("dock:name", "ZAP");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "ZAP");
        LOGGER.info((Object)"Initializing OS X specific settings, despite Apple's best efforts");
        Application application = Application.getApplication();
        Image image = Toolkit.getDefaultToolkit().getImage(GuiBootstrap.class.getResource("/resource/zap1024x1024.png"));
        application.setDockIconImage(image);
        application.setAboutHandler((AboutHandler)new OSXAboutHandler());
        application.setPreferencesHandler((PreferencesHandler)new OSXPreferencesHandler());
        OSXQuitHandler oSXQuitHandler = new OSXQuitHandler();
        application.setQuitHandler((QuitHandler)oSXQuitHandler);
    }
}

