/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.payloads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.version.ImageCreator;

public class OpenLocationDialog
extends JDialog
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = -5815321460026044259L;
    private static final int SIZE_X = 340;
    private static final int SIZE_Y = 180;
    private final JButton ok;
    private final JButton cancel;
    private final JBroFuzzWindow m;
    private final JPopupMenu popmenu;
    private final JComboBox urlBox;
    private final JComboBox methodBox;
    private final JComboBox charsetBox;
    private final JComboBox versionBox;

    public OpenLocationDialog(JBroFuzzWindow parent) {
        super(parent, " Open URL Location ", true);
        this.setFont(new Font("Verdana", 1, 12));
        this.setIconImage(ImageCreator.IMG_FRAME.getImage());
        this.setLayout(new BorderLayout());
        this.m = parent;
        this.urlBox = new JComboBox();
        this.urlBox.setPreferredSize(new Dimension(250, 20));
        this.urlBox.setEditable(true);
        this.urlBox.getEditor().getEditorComponent().addMouseListener(this);
        this.urlBox.setToolTipText("Copy/Paste a URL from your browser");
        this.urlBox.setFont(new Font("Verdana", 1, 12));
        this.urlBox.getEditor().getEditorComponent().addKeyListener(this);
        String[] methods = new String[]{"GET", "POST", "HEAD", "PUT", "DELETE", "TRACE", "PROPFIND", "OPTIONS"};
        String[] versions = new String[]{"0.9", "1.0", "1.1", "1.2"};
        String[] charsets = new String[]{"ISO-8859-1"};
        this.methodBox = new JComboBox<String>(methods);
        this.charsetBox = new JComboBox<String>(charsets);
        this.versionBox = new JComboBox<String>(versions);
        this.methodBox.setFont(new Font("Verdana", 1, 10));
        this.charsetBox.setFont(new Font("Verdana", 1, 10));
        this.versionBox.setFont(new Font("Verdana", 1, 10));
        this.methodBox.addKeyListener(this);
        this.charsetBox.addKeyListener(this);
        this.versionBox.addKeyListener(this);
        this.methodBox.setMaximumRowCount(3);
        this.charsetBox.setMaximumRowCount(3);
        this.versionBox.setMaximumRowCount(3);
        this.methodBox.setBackground(Color.BLACK);
        this.charsetBox.setBackground(Color.BLACK);
        this.versionBox.setBackground(Color.BLACK);
        this.methodBox.setForeground(Color.WHITE);
        this.charsetBox.setForeground(Color.WHITE);
        this.versionBox.setForeground(Color.WHITE);
        this.versionBox.setSelectedIndex(1);
        this.ok = new JButton("  OK  ");
        this.ok.setBounds(515, 305, 140, 40);
        this.ok.setToolTipText("Open the URL location in JBroFuzz");
        this.cancel = new JButton("Cancel");
        this.cancel.setBounds(515, 305, 140, 40);
        this.cancel.setToolTipText("Cancel opening a URL location");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OpenLocationDialog.this.clickOK();
                        OpenLocationDialog.this.dispose();
                    }
                });
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OpenLocationDialog.this.dispose();
                    }
                });
            }
        });
        this.popmenu = new JPopupMenu();
        JMenuItem i1 = new JMenuItem("Cut");
        JMenuItem i2 = new JMenuItem("Copy");
        JMenuItem i3 = new JMenuItem("Paste");
        JMenuItem i4 = new JMenuItem("Select All");
        this.popmenu.add(i1);
        this.popmenu.add(i2);
        this.popmenu.add(i3);
        this.popmenu.addSeparator();
        this.popmenu.add(i4);
        i1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable clipData = clipboard.getContents(clipboard);
                if (clipData != null) {
                    try {
                        if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            ((JTextComponent)OpenLocationDialog.this.urlBox.getEditor().getEditorComponent()).cut();
                        }
                    }
                    catch (Exception e1) {
                        Logger.log("Open Location: An error occured while cutting", 2);
                    }
                }
            }
        });
        i2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable clipData = clipboard.getContents(clipboard);
                if (clipData != null) {
                    try {
                        if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            ((JTextComponent)OpenLocationDialog.this.urlBox.getEditor().getEditorComponent()).copy();
                        }
                    }
                    catch (Exception e1) {
                        Logger.log("Open Location: An error occured while copying", 2);
                    }
                }
            }
        });
        i3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable clipData = clipboard.getContents(clipboard);
                if (clipData != null) {
                    try {
                        if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            ((JTextComponent)OpenLocationDialog.this.urlBox.getEditor().getEditorComponent()).replaceSelection((String)clipData.getTransferData(DataFlavor.stringFlavor));
                        }
                    }
                    catch (Exception e1) {
                        Logger.log("Open Location: An error occured while pasting", 2);
                    }
                }
            }
        });
        i4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenLocationDialog.this.urlBox.getEditor().selectAll();
            }
        });
        JPanel targetPanel = new JPanel(new FlowLayout(2, 15, 15));
        targetPanel.add(new JLabel("URL:"));
        targetPanel.add(this.urlBox);
        JPanel propertiesPanel = new JPanel(new FlowLayout(2, 15, 15));
        propertiesPanel.add(this.methodBox);
        propertiesPanel.add(this.charsetBox);
        propertiesPanel.add(this.versionBox);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 15, 15));
        buttonPanel.add(this.ok);
        buttonPanel.add(this.cancel);
        this.add((Component)targetPanel, "North");
        this.add((Component)propertiesPanel, "Center");
        this.add((Component)buttonPanel, "South");
        String url_displaying = parent.getPanelFuzzing().getTextURL();
        ((JTextComponent)this.urlBox.getEditor().getEditorComponent()).setText(url_displaying);
        ((JTextComponent)this.urlBox.getEditor().getEditorComponent()).selectAll();
        this.setLocation(parent.getLocation().x + 20, parent.getLocation().y + 40);
        this.setSize(340, 180);
        this.setResizable(true);
        this.setVisible(true);
    }

    private void checkForTriggerEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popmenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void clickOK() {
        String in_url_s = ((JTextComponent)this.urlBox.getEditor().getEditorComponent()).getText();
        if (!in_url_s.startsWith("http://") && !in_url_s.startsWith("https://")) {
            in_url_s = "http://" + in_url_s;
        }
        try {
            URL inputURL = new URL(in_url_s);
            StringBuffer out_url = new StringBuffer();
            out_url.append(inputURL.getProtocol());
            out_url.append("://");
            out_url.append(inputURL.getHost());
            if (inputURL.getPort() > 0) {
                out_url.append(":");
                out_url.append(inputURL.getPort());
            }
            StringBuffer req_url = new StringBuffer();
            req_url.append(this.methodBox.getModel().getElementAt(this.methodBox.getSelectedIndex()));
            req_url.append(' ');
            try {
                if (inputURL.getFile().isEmpty()) {
                    req_url.append('/');
                } else {
                    req_url.append(URLDecoder.decode(inputURL.getFile(), "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                Logger.log("Open Location: Unsupported URL Encoding Exception", 3);
                if (inputURL.getFile().isEmpty()) {
                    req_url.append('/');
                }
                req_url.append(inputURL.getFile());
            }
            req_url.append(' ');
            req_url.append("HTTP/");
            req_url.append(this.versionBox.getModel().getElementAt(this.versionBox.getSelectedIndex()));
            req_url.append('\n');
            req_url.append("Host: ");
            req_url.append(inputURL.getHost());
            req_url.append('\n');
            req_url.append("User-Agent: Mozilla/5.0 (Windows; U; Windows NT 6.0; en-GB; rv:1.9.0.10) Gecko/2009042316 Firefox/3.0.10 (.NET CLR 3.5.30729) JBroFuzz/");
            req_url.append("2.5");
            req_url.append('\n');
            req_url.append("Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
            req_url.append('\n');
            req_url.append("Accept-Language: en-gb,en;q=0.5");
            req_url.append('\n');
            req_url.append("Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            req_url.append('\n');
            this.m.getPanelFuzzing().setTextURL(out_url.toString());
            this.m.getPanelFuzzing().setTextRequest(req_url.toString());
        }
        catch (MalformedURLException e) {
            Logger.log("Open Location: Could not interpret the URL provided", 3);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 27) {
            this.dispose();
        }
        if (ke.getKeyCode() == 10) {
            this.clickOK();
            this.dispose();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkForTriggerEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkForTriggerEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkForTriggerEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkForTriggerEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkForTriggerEvent(e);
    }
}

