/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.behavior.ListViewBehavior;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class ListViewSkin<T>
extends VirtualContainerBase<ListView<T>, ListViewBehavior<T>, ListCell<T>> {
    private ObservableList<T> listViewItems;
    private boolean itemCountDirty;
    private final ListChangeListener listViewItemsListener = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change change) {
            ListViewSkin.this.itemCountDirty = true;
            ListViewSkin.this.requestLayout();
        }
    };
    private final WeakListChangeListener weakListViewItemsListener = new WeakListChangeListener(this.listViewItemsListener);

    public ListViewSkin(final ListView<T> listView) {
        super(listView, new ListViewBehavior(listView));
        this.updateListViewItems();
        this.flow.setId("virtual-flow");
        this.flow.setPannable(false);
        this.flow.setVertical(((ListView)this.getSkinnable()).getOrientation() == Orientation.VERTICAL);
        this.flow.setFocusTraversable(((ListView)this.getSkinnable()).isFocusTraversable());
        this.flow.setCreateCell((Callback<VirtualFlow, ? extends IndexedCell>)new Callback<VirtualFlow, ListCell>(){

            @Override
            public ListCell call(VirtualFlow virtualFlow) {
                return ListViewSkin.this.createCell();
            }
        });
        this.getChildren().add(this.flow);
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (listView.getEditingIndex() > -1) {
                    listView.edit(-1);
                }
                listView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.updateCellCount();
        ((ListViewBehavior)this.getBehavior()).setOnFocusPreviousRow(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onFocusPreviousCell();
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnFocusNextRow(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onFocusNextCell();
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnMoveToFirstCell(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onMoveToFirstCell();
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnMoveToLastCell(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onMoveToLastCell();
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnScrollPageDown(new Callback<Integer, Integer>(){

            @Override
            public Integer call(Integer n) {
                return ListViewSkin.this.onScrollPageDown(n);
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnScrollPageUp(new Callback<Integer, Integer>(){

            @Override
            public Integer call(Integer n) {
                return ListViewSkin.this.onScrollPageUp(n);
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnSelectPreviousRow(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onSelectPreviousCell();
            }
        });
        ((ListViewBehavior)this.getBehavior()).setOnSelectNextRow(new Runnable(){

            @Override
            public void run() {
                ListViewSkin.this.onSelectNextCell();
            }
        });
        this.registerChangeListener(listView.itemsProperty(), "ITEMS");
        this.registerChangeListener(listView.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(listView.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(listView.parentProperty(), "PARENT");
        this.registerChangeListener(listView.focusTraversableProperty(), "FOCUS_TRAVERSABLE");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "ITEMS") {
            this.updateListViewItems();
        } else if (string == "ORIENTATION") {
            this.flow.setVertical(((ListView)this.getSkinnable()).getOrientation() == Orientation.VERTICAL);
        } else if (string == "CELL_FACTORY") {
            this.flow.recreateCells();
        } else if (string == "PARENT") {
            if (((ListView)this.getSkinnable()).getParent() != null && ((ListView)this.getSkinnable()).isVisible()) {
                this.requestLayout();
            }
        } else if (string == "FOCUS_TRAVERSABLE") {
            this.flow.setFocusTraversable(((ListView)this.getSkinnable()).isFocusTraversable());
        }
    }

    public void updateListViewItems() {
        if (this.listViewItems != null) {
            this.listViewItems.removeListener(this.weakListViewItemsListener);
        }
        this.listViewItems = ((ListView)this.getSkinnable()).getItems();
        if (this.listViewItems != null) {
            this.listViewItems.addListener(this.weakListViewItemsListener);
        }
        this.itemCountDirty = true;
        this.requestLayout();
    }

    @Override
    public int getItemCount() {
        return this.listViewItems == null ? 0 : this.listViewItems.size();
    }

    void updateCellCount() {
        if (this.flow == null) {
            return;
        }
        int n = this.flow.getCellCount();
        int n2 = this.getItemCount();
        this.flow.setCellCount(this.getItemCount());
        if (n2 != n) {
            this.flow.recreateCells();
        } else {
            this.flow.reconfigureCells();
        }
    }

    @Override
    public ListCell<T> createCell() {
        ListCell listCell = ((ListView)this.getSkinnable()).getCellFactory() != null ? ((ListView)this.getSkinnable()).getCellFactory().call(this.getSkinnable()) : this.createDefaultCellImpl();
        listCell.updateListView((ListView)this.getSkinnable());
        return listCell;
    }

    private ListCell createDefaultCellImpl() {
        return new ListCell(){

            @Override
            public void updateItem(Object object, boolean bl) {
                super.updateItem(object, bl);
                if (bl) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (object instanceof Node) {
                    this.setText(null);
                    Node node = this.getGraphic();
                    Node node2 = (Node)object;
                    if (node == null || !node.equals(node2)) {
                        this.setGraphic(node2);
                    }
                } else {
                    this.setText(object == null ? "null" : object.toString());
                    this.setGraphic(null);
                }
            }
        };
    }

    @Override
    protected void layoutChildren() {
        if (this.itemCountDirty) {
            this.updateCellCount();
            this.itemCountDirty = false;
        }
        double d = this.getInsets().getLeft();
        double d2 = this.getInsets().getTop();
        double d3 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        double d4 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        this.flow.resizeRelocate(d, d2, d3, d4);
    }

    @Override
    protected double computePrefWidth(double d) {
        return this.computePrefHeight(-1.0) * 0.618033987;
    }

    @Override
    protected double computePrefHeight(double d) {
        return 400.0;
    }

    private void onFocusPreviousCell() {
        FocusModel focusModel = ((ListView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.show(focusModel.getFocusedIndex());
    }

    private void onFocusNextCell() {
        FocusModel focusModel = ((ListView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.show(focusModel.getFocusedIndex());
    }

    private void onSelectPreviousCell() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getSkinnable()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        this.flow.show(n);
        IndexedCell indexedCell = this.flow.getFirstVisibleCell();
        if (indexedCell == null || n < indexedCell.getIndex()) {
            this.flow.setPosition((double)n / (double)this.getItemCount());
        }
    }

    private void onSelectNextCell() {
        MultipleSelectionModel multipleSelectionModel = ((ListView)this.getSkinnable()).getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        int n = multipleSelectionModel.getSelectedIndex();
        this.flow.show(n);
        IndexedCell indexedCell = this.flow.getLastVisibleCell();
        if (indexedCell == null || indexedCell.getIndex() < n) {
            this.flow.setPosition((double)n / (double)this.getItemCount());
        }
    }

    private void onMoveToFirstCell() {
        this.flow.show(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        int n = this.getItemCount() - 1;
        this.flow.show(n);
        this.flow.setPosition(1.0);
    }

    private int onScrollPageDown(int n) {
        IndexedCell indexedCell = this.flow.getLastVisibleCellWithinViewPort();
        if (indexedCell == null) {
            return -1;
        }
        int n2 = -1;
        int n3 = indexedCell.getIndex();
        if (!indexedCell.isSelected() && !indexedCell.isFocused() || n3 != n) {
            n2 = indexedCell.getIndex();
        } else {
            this.flow.showAsFirst(indexedCell);
            indexedCell = this.flow.getLastVisibleCellWithinViewPort();
            n2 = indexedCell.getIndex();
        }
        this.flow.show(indexedCell);
        return n2;
    }

    private int onScrollPageUp(int n) {
        IndexedCell indexedCell = this.flow.getFirstVisibleCellWithinViewPort();
        if (indexedCell == null) {
            return -1;
        }
        int n2 = -1;
        int n3 = indexedCell.getIndex();
        if (!indexedCell.isSelected() && !indexedCell.isFocused() || n3 != n) {
            n2 = indexedCell.getIndex();
        } else {
            this.flow.showAsLast(indexedCell);
            indexedCell = this.flow.getFirstVisibleCellWithinViewPort();
            n2 = indexedCell.getIndex();
        }
        this.flow.show(indexedCell);
        return n2;
    }
}

