/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop.cext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.cast.NameToJavaStringNodeGen;
import org.jruby.truffle.interop.cext.CExtString;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.constants.GetConstantNode;
import org.jruby.truffle.language.constants.LookupConstantNode;
import org.jruby.truffle.language.control.RaiseException;

@CoreClass(value="Truffle::CExt")
public class CExtNodes {

    @CoreMethod(names={"rb_jt_io_handle"}, isModuleFunction=true)
    public static abstract class IOHandleNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyIO(io)"})
        public int ioHandle(DynamicObject io) {
            return Layouts.IO.getDescriptor(io);
        }
    }

    @CoreMethod(names={"rb_const_get_from"}, isModuleFunction=true, required=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ConstGetFromNode
    extends CoreMethodNode {
        @Node.Child
        LookupConstantNode lookupConstantNode = LookupConstantNode.create(true, false);
        @Node.Child
        GetConstantNode getConstantNode = GetConstantNode.create();

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(name);
        }

        @Specialization
        public Object constGetFrom(VirtualFrame frame, DynamicObject module, String name) {
            RubyConstant constant = this.lookupConstantNode.lookupConstant(frame, module, name);
            return this.getConstantNode.executeGetConstant(frame, module, name, constant, this.lookupConstantNode);
        }
    }

    @CoreMethod(names={"get_block"}, isModuleFunction=true)
    public static abstract class GetBlockNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject getBlock() {
            return Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<DynamicObject>(){

                @Override
                public DynamicObject visitFrame(FrameInstance frameInstance) {
                    Frame frame = frameInstance.getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
                    return RubyArguments.tryGetBlock(frame);
                }
            });
        }
    }

    @CoreMethod(names={"rb_block_given_p"}, isModuleFunction=true, needsCallerFrame=true)
    public static abstract class BlockGivenNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int blockGiven(MaterializedFrame callerFrame, @Cached(value="createBinaryProfile()") ConditionProfile blockProfile) {
            return blockProfile.profile(RubyArguments.getBlock(callerFrame) != null) ? 1 : 0;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int blockGiven(NotProvided noCallerFrame) {
            return RubyArguments.getBlock(Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, false)) != null ? 1 : 0;
        }
    }

    @CoreMethod(names={"to_ruby_string"}, isModuleFunction=true, required=1)
    public static abstract class ToRubyStringNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject toRubyString(CExtString cExtString) {
            return cExtString.getString();
        }

        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject toRubyString(DynamicObject string) {
            return string;
        }
    }

    @CoreMethod(names={"CExtString"}, isModuleFunction=true, required=1)
    public static abstract class CExtStringNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(string)"})
        public CExtString cExtString(DynamicObject string) {
            return new CExtString(string);
        }
    }

    @CoreMethod(names={"rb_long2int"}, isModuleFunction=true, required=1)
    public static abstract class Long2Int
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int long2fix(int num) {
            return num;
        }

        @Specialization(guards={"fitsIntoInteger(num)"})
        public int long2fixInRange(long num) {
            return (int)num;
        }

        @Specialization(guards={"!fitsIntoInteger(num)"})
        public int long2fixOutOfRange(long num) {
            throw new RaiseException(this.coreExceptions().rangeErrorConvertToInt(num, this));
        }

        protected boolean fitsIntoInteger(long num) {
            return CoreLibrary.fitsIntoInteger(num);
        }
    }

    @CoreMethod(names={"LONG2FIX"}, isModuleFunction=true, required=1)
    public static abstract class LONG2FIXNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int long2fix(int num) {
            return num;
        }
    }

    @CoreMethod(names={"ULONG2NUM"}, isModuleFunction=true, required=1)
    public static abstract class ULONG2NUMNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int ulong2num(int num) {
            return num;
        }
    }

    @CoreMethod(names={"LONG2NUM"}, isModuleFunction=true, required=1)
    public static abstract class LONG2NUMNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int long2num(int num) {
            return num;
        }
    }

    @CoreMethod(names={"UINT2NUM"}, isModuleFunction=true, required=1)
    public static abstract class UINT2NUMNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int uint2num(int num) {
            return num;
        }
    }

    @CoreMethod(names={"INT2FIX"}, isModuleFunction=true, required=1)
    public static abstract class INT2FIXNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int int2fix(int num) {
            return num;
        }

        @Specialization
        public long int2fix(long num) {
            return num;
        }
    }

    @CoreMethod(names={"INT2NUM"}, isModuleFunction=true, required=1)
    public static abstract class INT2NUMNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int int2num(int num) {
            return num;
        }

        @Specialization
        public long int2num(long num) {
            return num;
        }
    }

    @CoreMethod(names={"FIX2LONG"}, isModuleFunction=true, required=1)
    public static abstract class FIX2LONGNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public long fix2long(int num) {
            return num;
        }
    }

    @CoreMethod(names={"FIX2UINT"}, isModuleFunction=true, required=1)
    public static abstract class FIX2UINTNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int fix2uint(int num) {
            return num;
        }

        @Specialization
        public long fix2uint(long num) {
            return num;
        }
    }

    @CoreMethod(names={"FIX2INT"}, isModuleFunction=true, required=1)
    public static abstract class FIX2INTNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int fix2int(int num) {
            return num;
        }
    }

    @CoreMethod(names={"NUM2DBL"}, isModuleFunction=true, required=1)
    public static abstract class NUM2DBLNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public double num2dbl(int num) {
            return num;
        }
    }

    @CoreMethod(names={"NUM2ULONG"}, isModuleFunction=true, required=1)
    public static abstract class NUM2ULONGNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public long num2ulong(int num) {
            return num;
        }
    }

    @CoreMethod(names={"NUM2LONG"}, isModuleFunction=true, required=1)
    public static abstract class NUM2LONGNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public long num2long(int num) {
            return num;
        }
    }

    @CoreMethod(names={"NUM2UINT"}, isModuleFunction=true, required=1)
    public static abstract class NUM2UINTNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int num2uint(int num) {
            return num;
        }
    }

    @CoreMethod(names={"NUM2INT"}, isModuleFunction=true, required=1)
    public static abstract class NUM2INTNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int num2int(int num) {
            return num;
        }
    }
}

