/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.Util;

public final class CompletionTokenStream
extends TokenStream {
    private final PayloadAttribute payloadAttr = (PayloadAttribute)this.addAttribute(PayloadAttribute.class);
    private final PositionIncrementAttribute posAttr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final ByteTermAttribute bytesAtt = (ByteTermAttribute)this.addAttribute(ByteTermAttribute.class);
    private final TokenStream input;
    private BytesRef payload;
    private Iterator<IntsRef> finiteStrings;
    private ToFiniteStrings toFiniteStrings;
    private int posInc = -1;
    private static final int MAX_PATHS = 256;
    private CharTermAttribute charTermAttribute;

    public CompletionTokenStream(TokenStream input, BytesRef payload, ToFiniteStrings toFiniteStrings) {
        this.input = input;
        this.payload = payload;
        this.toFiniteStrings = toFiniteStrings;
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (this.finiteStrings == null) {
            Set<IntsRef> strings = this.toFiniteStrings.toFiniteStrings(this.input);
            if (strings.size() > 256) {
                throw new IllegalArgumentException("TokenStream expanded to " + strings.size() + " finite strings. Only <= " + 256 + " finite strings are supported");
            }
            this.posInc = strings.size();
            this.finiteStrings = strings.iterator();
        }
        if (this.finiteStrings.hasNext()) {
            this.posAttr.setPositionIncrement(this.posInc);
            this.posInc = 0;
            Util.toBytesRef((IntsRef)this.finiteStrings.next(), (BytesRefBuilder)this.bytesAtt.builder());
            if (this.charTermAttribute != null) {
                this.charTermAttribute.setLength(0);
                this.charTermAttribute.append(this.bytesAtt.toUTF16());
            }
            if (this.payload != null) {
                this.payloadAttr.setPayload(this.payload);
            }
            return true;
        }
        return false;
    }

    public void end() throws IOException {
        super.end();
        if (this.posInc == -1) {
            this.input.end();
        }
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void reset() throws IOException {
        super.reset();
        if (this.hasAttribute(CharTermAttribute.class)) {
            this.charTermAttribute = (CharTermAttribute)this.getAttribute(CharTermAttribute.class);
        }
        this.finiteStrings = null;
        this.posInc = -1;
    }

    public static final class ByteTermAttributeImpl
    extends AttributeImpl
    implements ByteTermAttribute,
    TermToBytesRefAttribute {
        private final BytesRefBuilder bytes = new BytesRefBuilder();
        private CharsRefBuilder charsRef;

        @Override
        public BytesRefBuilder builder() {
            return this.bytes;
        }

        public BytesRef getBytesRef() {
            return this.bytes.get();
        }

        public void clear() {
            this.bytes.clear();
        }

        public void copyTo(AttributeImpl target) {
            ByteTermAttributeImpl other = (ByteTermAttributeImpl)target;
            other.bytes.copyBytes(this.bytes);
        }

        @Override
        public CharSequence toUTF16() {
            if (this.charsRef == null) {
                this.charsRef = new CharsRefBuilder();
            }
            this.charsRef.copyUTF8Bytes(this.getBytesRef());
            return this.charsRef.get();
        }
    }

    public static interface ByteTermAttribute
    extends TermToBytesRefAttribute {
        public BytesRefBuilder builder();

        public CharSequence toUTF16();
    }

    public static interface ToFiniteStrings {
        public Set<IntsRef> toFiniteStrings(TokenStream var1) throws IOException;
    }
}

