/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001HB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u00020F0E\"\u00020FH\u0007\u00a2\u0006\u0002\u0010GR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020+0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00140\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00106\u001a\b\u0012\u0004\u0012\u0002070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00108\u001a\b\u0012\u0004\u0012\u0002070\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00100\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020@0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies;", "", "()V", "ABSTRACT_MODIFIER", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "ARRAY_ACCESS", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "AS_TYPE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "CALL_ELEMENT", "Lcom/intellij/psi/PsiElement;", "CALL_EXPRESSION", "COMPANION_OBJECT", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "CUT_CHAR_QUOTES", "Lorg/jetbrains/kotlin/psi/KtElement;", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "DECLARATION_RETURN_TYPE", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "DECLARATION_SIGNATURE", "DECLARATION_SIGNATURE_OR_DEFAULT", "DECLARATION_WITH_BODY", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "DEFAULT", "DELEGATOR_SUPER_CALL", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "ELSE_ENTRY", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "FOR_REDECLARATION", "FOR_UNRESOLVED_REFERENCE", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "FUNCTION_PARAMETERS", "Lorg/jetbrains/kotlin/psi/KtFunction;", "IMPORT_ALIAS", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "LONG_LITERAL_SUFFIX", "NULLABLE_TYPE", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "OPEN_MODIFIER", "OVERRIDE_MODIFIER", "PARAMETER_DEFAULT_VALUE", "Lorg/jetbrains/kotlin/psi/KtParameter;", "PARAMETER_VARARG_MODIFIER", "PRIVATE_MODIFIER", "RETURN_WITH_LABEL", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "SECONDARY_CONSTRUCTOR_DELEGATION_CALL", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "SPECIAL_CONSTRUCT_TOKEN", "Lorg/jetbrains/kotlin/psi/KtExpression;", "TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE", "UNREACHABLE_CODE", "UNUSED_VALUE", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "USELESS_ELVIS", "VALUE_ARGUMENTS", "VAL_OR_VAR_NODE", "VARIANCE_IN_PROJECTION", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "VARIANCE_MODIFIER", "VISIBILITY_MODIFIER", "WHEN_CONDITION_IN_RANGE", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "WHEN_EXPRESSION", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "modifierSetPosition", "tokens", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "DeclarationHeader", "kotlin-compiler"})
public final class PositioningStrategies {
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_RETURN_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> DECLARATION_NAME;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> DECLARATION_SIGNATURE_OR_DEFAULT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclaration> TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> ABSTRACT_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OPEN_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> OVERRIDE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> PRIVATE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VARIANCE_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReferenceExpression> FOR_UNRESOLVED_REFERENCE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtArrayAccessExpression> ARRAY_ACCESS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> VISIBILITY_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtTypeProjection> VARIANCE_IN_PROJECTION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_DEFAULT_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtParameter> PARAMETER_VARARG_MODIFIER;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtDeclarationWithBody> DECLARATION_WITH_BODY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNamedDeclaration> VAL_OR_VAR_NODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenEntry> ELSE_ENTRY;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenExpression> WHEN_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtWhenConditionInRange> WHEN_CONDITION_IN_RANGE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtExpression> SPECIAL_CONSTRUCT_TOKEN;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtNullableType> NULLABLE_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> VALUE_ARGUMENTS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtFunction> FUNCTION_PARAMETERS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> CUT_CHAR_QUOTES;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtElement> LONG_LITERAL_SUFFIX;
    @JvmField
    @NotNull
    public static final PositioningStrategy<PsiElement> UNREACHABLE_CODE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpressionWithTypeRHS> AS_TYPE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtObjectDeclaration> COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtConstructorDelegationCall> SECONDARY_CONSTRUCTOR_DELEGATION_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtEnumEntry> DELEGATOR_SUPER_CALL;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> UNUSED_VALUE;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtBinaryExpression> USELESS_ELVIS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtImportDirective> IMPORT_ALIAS;
    @JvmField
    @NotNull
    public static final PositioningStrategy<KtReturnExpression> RETURN_WITH_LABEL;
    public static final PositioningStrategies INSTANCE;

    @JvmStatic
    @NotNull
    public static final PositioningStrategy<KtModifierListOwner> modifierSetPosition(KtModifierKeywordToken ... tokens) {
        Intrinsics.checkParameterIsNotNull(tokens, "tokens");
        return new PositioningStrategy<KtModifierListOwner>(tokens){
            final /* synthetic */ KtModifierKeywordToken[] $tokens;

            @NotNull
            public List<TextRange> mark(@NotNull KtModifierListOwner element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtModifierList $receiver$iv = element.getModifierList();
                KtModifierList ktModifierList = $receiver$iv;
                if (ktModifierList == null) {
                    AssertionError assertionError;
                    AssertionError assertionError2 = assertionError;
                    AssertionError assertionError3 = assertionError;
                    String string = "No modifier list, but modifier has been found by the analyzer";
                    assertionError2((Object)string);
                    throw (Throwable)((Object)assertionError3);
                }
                KtModifierList modifierList = ktModifierList;
                KtModifierKeywordToken[] ktModifierKeywordTokenArray = this.$tokens;
                for (int i = 0; i < ktModifierKeywordTokenArray.length; ++i) {
                    KtModifierKeywordToken token = ktModifierKeywordTokenArray[i];
                    PsiElement modifier = modifierList.getModifier(token);
                    if (modifier == null) continue;
                    return PositioningStrategyKt.markElement(modifier);
                }
                throw (Throwable)new IllegalStateException("None of the modifiers is found: " + CollectionsKt.listOf(Arrays.copyOf(this.$tokens, this.$tokens.length)));
            }
            {
                this.$tokens = $captured_local_variable$0;
            }
        };
    }

    private PositioningStrategies() {
        INSTANCE = this;
        DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element;
                if (psiElement instanceof KtObjectLiteralExpression) {
                    KtObjectDeclaration objectDeclaration = ((KtObjectLiteralExpression)element).getObjectDeclaration();
                    PsiElement psiElement2 = objectDeclaration.getObjectKeyword();
                    if (psiElement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    PsiElement objectKeyword = psiElement2;
                    KtSuperTypeList delegationSpecifierList = objectDeclaration.getSuperTypeList();
                    if (delegationSpecifierList == null) {
                        return PositioningStrategyKt.markElement(objectKeyword);
                    }
                    return PositioningStrategyKt.markRange(objectKeyword, delegationSpecifierList);
                }
                if (psiElement instanceof KtObjectDeclaration) {
                    PsiElement psiElement3;
                    PsiElement psiElement4 = ((KtObjectDeclaration)element).getObjectKeyword();
                    if (psiElement4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((psiElement3 = ((KtObjectDeclaration)element).getNameIdentifier()) == null && (psiElement3 = ((KtObjectDeclaration)element).getObjectKeyword()) == null) {
                        Intrinsics.throwNpe();
                    }
                    return PositioningStrategyKt.markRange(psiElement4, psiElement3);
                }
                if (psiElement instanceof KtConstructorDelegationCall) {
                    return PositioningStrategies.SECONDARY_CONSTRUCTOR_DELEGATION_CALL.mark((KtConstructorDelegationCall)element);
                }
                return super.mark(element);
            }
        };
        DECLARATION_RETURN_TYPE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return PositioningStrategyKt.markElement(this.getElementToMark(element));
            }

            public boolean isValid(@NotNull KtDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return !PositioningStrategyKt.hasSyntaxErrors(this.getElementToMark(element));
            }

            /*
             * WARNING - void declaration
             */
            private final PsiElement getElementToMark(KtDeclaration declaration) {
                void nameIdentifierOrPlaceholder;
                void returnTypeRef;
                KtDeclaration ktDeclaration = declaration;
                Pair<KtTypeReference, PsiElement> pair = ktDeclaration instanceof KtCallableDeclaration ? new Pair<KtTypeReference, PsiElement>(((KtCallableDeclaration)declaration).getTypeReference(), ((KtCallableDeclaration)declaration).getNameIdentifier()) : (ktDeclaration instanceof KtPropertyAccessor ? new Pair<KtTypeReference, PsiElement>(((KtPropertyAccessor)declaration).getReturnTypeReference(), ((KtPropertyAccessor)declaration).getNamePlaceholder()) : new Pair<Object, Object>(null, null));
                KtTypeReference ktTypeReference = pair.component1();
                PsiElement psiElement = pair.component2();
                pair = null;
                if (returnTypeRef != null) {
                    return (PsiElement)returnTypeRef;
                }
                if (nameIdentifierOrPlaceholder != null) {
                    return nameIdentifierOrPlaceholder;
                }
                return declaration;
            }
        };
        DECLARATION_NAME = new DeclarationHeader<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNamedDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement nameIdentifier = element.getNameIdentifier();
                if (nameIdentifier != null) {
                    if (element instanceof KtClassOrObject) {
                        PsiElement psiElement;
                        PsiElement psiElement2 = element.getModifierList();
                        if (psiElement2 == null || (psiElement2 = psiElement2.getModifier(KtTokens.ENUM_KEYWORD)) == null) {
                            ASTNode aSTNode = ((KtClassOrObject)element).getNode().findChildByType(TokenSet.create(KtTokens.CLASS_KEYWORD, KtTokens.OBJECT_KEYWORD));
                            psiElement2 = psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                        }
                        if (psiElement2 == null) {
                            psiElement = element;
                        }
                        PsiElement startElement = psiElement;
                        return PositioningStrategyKt.markRange(startElement, nameIdentifier);
                    }
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                if (element instanceof KtNamedFunction) {
                    return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        DECLARATION_SIGNATURE = new DeclarationHeader<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtDeclaration ktDeclaration = element;
                if (ktDeclaration instanceof KtConstructor) {
                    PsiElement psiElement = ((KtConstructor)element).getConstructorKeyword();
                    if (psiElement == null) {
                        psiElement = ((KtConstructor)element).getValueParameterList();
                    }
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement begin = psiElement;
                    KtParameterList ktParameterList = ((KtConstructor)element).getValueParameterList();
                    PsiElement psiElement2 = ktParameterList != null ? (PsiElement)ktParameterList : ((KtConstructor)element).getConstructorKeyword();
                    if (psiElement2 == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement end = psiElement2;
                    return PositioningStrategyKt.markRange(begin, end);
                }
                if (ktDeclaration instanceof KtFunction) {
                    NavigatablePsiElement navigatablePsiElement;
                    PsiElement endOfSignatureElement;
                    PsiElement psiElement;
                    KtTypeReference ktTypeReference = ((KtFunction)element).getTypeReference();
                    PsiElement psiElement3 = ktTypeReference != null ? (PsiElement)ktTypeReference : (PsiElement)((KtFunction)element).getValueParameterList();
                    if (psiElement3 == null) {
                        psiElement3 = psiElement = ((KtFunction)element).getNameIdentifier();
                    }
                    if (psiElement3 == null) {
                        psiElement = endOfSignatureElement = (PsiElement)element;
                    }
                    if (element instanceof KtFunctionLiteral) {
                        KtTypeReference ktTypeReference2 = ((KtFunction)element).getReceiverTypeReference();
                        navigatablePsiElement = ktTypeReference2 != null ? (NavigatablePsiElement)ktTypeReference2 : (NavigatablePsiElement)((KtFunction)element).getValueParameterList();
                        if (navigatablePsiElement == null) {
                            navigatablePsiElement = element;
                        }
                    } else {
                        navigatablePsiElement = element;
                    }
                    NavigatablePsiElement startElement = navigatablePsiElement;
                    return PositioningStrategyKt.markRange(startElement, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtProperty) {
                    KtTypeReference ktTypeReference = ((KtProperty)element).getTypeReference();
                    PsiElement psiElement = ktTypeReference != null ? (PsiElement)ktTypeReference : ((KtProperty)element).getNameIdentifier();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    PsiElement endOfSignatureElement = psiElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtPropertyAccessor) {
                    PsiElement psiElement;
                    PsiElement psiElement4;
                    KtTypeReference ktTypeReference = ((KtPropertyAccessor)element).getReturnTypeReference();
                    if (ktTypeReference != null) {
                        psiElement4 = ktTypeReference;
                    } else {
                        ASTNode aSTNode = ((KtPropertyAccessor)element).getRightParenthesis();
                        psiElement4 = psiElement = aSTNode != null ? aSTNode.getPsi() : null;
                    }
                    if (psiElement4 == null) {
                        PsiElement psiElement5 = ((KtPropertyAccessor)element).getNamePlaceholder();
                        psiElement = psiElement5;
                        Intrinsics.checkExpressionValueIsNotNull(psiElement5, "element.getNamePlaceholder()");
                    }
                    PsiElement endOfSignatureElement = psiElement;
                    return PositioningStrategyKt.markRange(element, endOfSignatureElement);
                }
                if (ktDeclaration instanceof KtClass) {
                    PsiElement psiElement = ((KtClass)element).getNameIdentifier();
                    if (psiElement == null) {
                        return PositioningStrategyKt.markElement(element);
                    }
                    PsiElement nameAsDeclaration = psiElement;
                    KtParameterList ktParameterList = ((KtClass)element).getPrimaryConstructorParameterList();
                    if (ktParameterList == null) {
                        PsiElement psiElement6 = nameAsDeclaration;
                        Intrinsics.checkExpressionValueIsNotNull(psiElement6, "nameAsDeclaration");
                        return PositioningStrategyKt.markElement(psiElement6);
                    }
                    KtParameterList primaryConstructorParameterList = ktParameterList;
                    PsiElement psiElement7 = nameAsDeclaration;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement7, "nameAsDeclaration");
                    return PositioningStrategyKt.markRange(psiElement7, primaryConstructorParameterList);
                }
                if (ktDeclaration instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DECLARATION_NAME.mark((KtNamedDeclaration)element);
                }
                return super.mark((PsiElement)element);
            }
        };
        DECLARATION_SIGNATURE_OR_DEFAULT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)element) : PositioningStrategies.DEFAULT.mark(element);
            }

            public boolean isValid(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return element instanceof KtDeclaration ? PositioningStrategies.DECLARATION_SIGNATURE.isValid((KtDeclaration)element) : PositioningStrategies.DEFAULT.isValid(element);
            }
        };
        TYPE_PARAMETERS_OR_DECLARATION_SIGNATURE = new PositioningStrategy<KtDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclaration element) {
                KtTypeParameterList jetTypeParameterList;
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtTypeParameterListOwner && (jetTypeParameterList = ((KtTypeParameterListOwner)element).getTypeParameterList()) != null) {
                    return PositioningStrategyKt.markElement(jetTypeParameterList);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE.mark((KtDeclaration)((PsiElement)element));
            }
        };
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "KtTokens.ABSTRACT_KEYWORD");
        ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
        ABSTRACT_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray2 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken2, "KtTokens.OPEN_KEYWORD");
        ktModifierKeywordTokenArray2[0] = ktModifierKeywordToken2;
        OPEN_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray2);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray3 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken3, "KtTokens.OVERRIDE_KEYWORD");
        ktModifierKeywordTokenArray3[0] = ktModifierKeywordToken3;
        OVERRIDE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray3);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray4 = new KtModifierKeywordToken[1];
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken4, "KtTokens.PRIVATE_KEYWORD");
        ktModifierKeywordTokenArray4[0] = ktModifierKeywordToken4;
        PRIVATE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray4);
        KtModifierKeywordToken[] ktModifierKeywordTokenArray5 = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.IN_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken5, "KtTokens.IN_KEYWORD");
        ktModifierKeywordTokenArray5[0] = ktModifierKeywordToken5;
        KtModifierKeywordToken ktModifierKeywordToken6 = KtTokens.OUT_KEYWORD;
        Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken6, "KtTokens.OUT_KEYWORD");
        ktModifierKeywordTokenArray5[1] = ktModifierKeywordToken6;
        VARIANCE_MODIFIER = PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray5);
        FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                PsiElement nameIdentifier;
                PsiElement psiElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement2 = element;
                if (psiElement2 instanceof KtNamedDeclaration) {
                    psiElement = ((KtNamedDeclaration)element).getNameIdentifier();
                } else if (psiElement2 instanceof KtFile) {
                    KtPackageDirective ktPackageDirective = ((KtFile)element).getPackageDirective();
                    if (ktPackageDirective == null) {
                        Intrinsics.throwNpe();
                    }
                    psiElement = ktPackageDirective.getNameIdentifier();
                } else {
                    psiElement = nameIdentifier = (PsiElement)null;
                }
                if (nameIdentifier == null && element instanceof KtObjectDeclaration) {
                    return PositioningStrategies.DEFAULT.mark(element);
                }
                PsiElement psiElement3 = nameIdentifier;
                if (psiElement3 == null) {
                    psiElement3 = element;
                }
                return PositioningStrategyKt.markElement(psiElement3);
            }
        };
        FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<KtReferenceExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReferenceExpression element) {
                List<TextRange> ranges2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtArrayAccessExpression && !(ranges2 = ((KtArrayAccessExpression)element).getBracketRanges()).isEmpty()) {
                    List<TextRange> list2 = ranges2;
                    Intrinsics.checkExpressionValueIsNotNull(list2, "ranges");
                    return list2;
                }
                return CollectionsKt.listOf(element.getTextRange());
            }
        };
        ARRAY_ACCESS = new PositioningStrategy<KtArrayAccessExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtArrayAccessExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getIndicesNode();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.indicesNode");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        VISIBILITY_MODIFIER = new PositioningStrategy<KtModifierListOwner>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public List<TextRange> mark(@NotNull KtModifierListOwner element) {
                PsiElement psiElement;
                PsiElement nameIdentifier;
                void destination$iv$iv;
                void $receiver$iv$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull(element, "element");
                List<KtModifierKeywordToken[]> visibilityTokens = CollectionsKt.listOf(new KtModifierKeywordToken[]{KtTokens.PRIVATE_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PUBLIC_KEYWORD, KtTokens.INTERNAL_KEYWORD});
                KtModifierList modifierList = element.getModifierList();
                Iterable iterable = visibilityTokens;
                KtModifierListOwner ktModifierListOwner = $receiver$iv;
                Collection collection = new ArrayList<E>();
                void var8_7 = $receiver$iv$iv;
                Iterator<T> iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    TextRange textRange;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    KtModifierKeywordToken it = (KtModifierKeywordToken)element$iv$iv;
                    PsiElement psiElement2 = modifierList;
                    if ((psiElement2 != null && (psiElement2 = ((KtModifierList)psiElement2).getModifier(it)) != null ? psiElement2.getTextRange() : null) == null) continue;
                    textRange = textRange;
                    TextRange it$iv$iv = textRange;
                    destination$iv$iv.add(it$iv$iv);
                }
                List result2 = (List)destination$iv$iv;
                if (!result2.isEmpty()) {
                    return result2;
                }
                if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element)).getNameIdentifier()) != null) {
                    return PositioningStrategyKt.markElement(nameIdentifier);
                }
                ktModifierListOwner = element;
                if (ktModifierListOwner instanceof KtObjectDeclaration) {
                    psiElement = ((KtObjectDeclaration)element).getObjectKeyword();
                    if (psiElement == null) {
                        Intrinsics.throwNpe();
                    }
                } else if (ktModifierListOwner instanceof KtPropertyAccessor) {
                    PsiElement psiElement3 = ((KtPropertyAccessor)element).getNamePlaceholder();
                    psiElement = psiElement3;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement3, "element.getNamePlaceholder()");
                } else if (ktModifierListOwner instanceof KtAnonymousInitializer) {
                    psiElement = element;
                } else {
                    throw (Throwable)new IllegalArgumentException("Can't find text range for element '" + element.getClass().getCanonicalName() + "' with the text '" + element.getText() + "'");
                }
                PsiElement elementToMark = psiElement;
                return PositioningStrategyKt.markElement(elementToMark);
            }
        };
        VARIANCE_IN_PROJECTION = new PositioningStrategy<KtTypeProjection>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtTypeProjection element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getProjectionToken();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.getProjectionToken()!!");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        PARAMETER_DEFAULT_VALUE = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtExpression ktExpression = element.getDefaultValue();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                ASTNode aSTNode = ktExpression.getNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getDefaultValue()!!.node");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        PARAMETER_VARARG_MODIFIER = new PositioningStrategy<KtParameter>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtParameter element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtModifierList ktModifierList = element.getModifierList();
                if (ktModifierList == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement psiElement = ktModifierList.getModifier(KtTokens.VARARG_KEYWORD);
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                PsiElement varargModifier = psiElement;
                ASTNode aSTNode = varargModifier.getNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "varargModifier.node");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                KtElement ktElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element;
                if (!(psiElement instanceof KtCallElement)) {
                    psiElement = null;
                }
                return PositioningStrategyKt.markElement((ktElement = (KtCallElement)psiElement) != null && (ktElement = ktElement.getCalleeExpression()) != null ? (PsiElement)ktElement : element);
            }
        };
        DECLARATION_WITH_BODY = new PositioningStrategy<KtDeclarationWithBody>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtDeclarationWithBody element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtExpression ktExpression = element.getBodyExpression();
                if (!(ktExpression instanceof KtBlockExpression)) {
                    ktExpression = null;
                }
                KtBlockExpression ktBlockExpression = (KtBlockExpression)ktExpression;
                TextRange lastBracketRange = ktBlockExpression != null ? ktBlockExpression.getLastBracketRange() : null;
                return lastBracketRange != null ? PositioningStrategyKt.markRange(lastBracketRange) : PositioningStrategyKt.markElement(element);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean isValid(@NotNull KtDeclarationWithBody element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (!super.isValid((PsiElement)element)) return false;
                KtExpression ktExpression = element.getBodyExpression();
                if (!(ktExpression instanceof KtBlockExpression)) {
                    ktExpression = null;
                }
                KtBlockExpression ktBlockExpression = (KtBlockExpression)ktExpression;
                if (ktBlockExpression == null) return false;
                TextRange textRange = ktBlockExpression.getLastBracketRange();
                if (textRange == null) return false;
                return true;
            }
        };
        VAL_OR_VAR_NODE = new PositioningStrategy<KtNamedDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNamedDeclaration element) {
                List<TextRange> list2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtNamedDeclaration ktNamedDeclaration = element;
                if (ktNamedDeclaration instanceof KtParameter) {
                    PsiElement psiElement = ((KtParameter)element).getValOrVarKeyword();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktNamedDeclaration instanceof KtProperty) {
                    PsiElement psiElement = ((KtProperty)element).getValOrVarKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.valOrVarKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else {
                    String string = "Declaration is neither a parameter nor a property: " + PsiUtilsKt.getElementTextWithContext(element);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return list2;
            }
        };
        ELSE_ENTRY = new PositioningStrategy<KtWhenEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenEntry element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getElseKeyword();
                if (psiElement == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.elseKeyword!!");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_EXPRESSION = new PositioningStrategy<KtWhenExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getWhenKeyword();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.whenKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        WHEN_CONDITION_IN_RANGE = new PositioningStrategy<KtWhenConditionInRange>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtWhenConditionInRange element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.operationReference");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        SPECIAL_CONSTRUCT_TOKEN = new PositioningStrategy<KtExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtExpression element) {
                List<TextRange> list2;
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtExpression ktExpression = element;
                if (ktExpression instanceof KtWhenExpression) {
                    PsiElement psiElement = ((KtWhenExpression)element).getWhenKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.whenKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtIfExpression) {
                    PsiElement psiElement = ((KtIfExpression)element).getIfKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.ifKeyword");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else if (ktExpression instanceof KtOperationExpression) {
                    PsiElement psiElement = ((KtOperationExpression)element).getOperationReference();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.operationReference");
                    list2 = PositioningStrategyKt.markElement(psiElement);
                } else {
                    String string = "Expression is not an if, when or operation expression: " + PsiUtilsKt.getElementTextWithContext(element);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return list2;
            }
        };
        NULLABLE_TYPE = new PositioningStrategy<KtNullableType>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtNullableType element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                ASTNode aSTNode = element.getQuestionMarkNode();
                Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getQuestionMarkNode()");
                return PositioningStrategyKt.markNode(aSTNode);
            }
        };
        CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtCallExpression) {
                    KtTypeArgumentList ktTypeArgumentList = ((KtCallExpression)element).getTypeArgumentList();
                    PsiElement psiElement = ktTypeArgumentList != null ? (PsiElement)ktTypeArgumentList : (PsiElement)((KtCallExpression)element).getCalleeExpression();
                    if (psiElement == null) {
                        psiElement = element;
                    }
                    return PositioningStrategyKt.markRange(element, psiElement);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        VALUE_ARGUMENTS = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                PsiElement psiElement;
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtElement ktElement = element;
                if (!(ktElement instanceof KtValueArgumentList)) {
                    ktElement = null;
                }
                if ((psiElement = (KtValueArgumentList)ktElement) == null || (psiElement = psiElement.getRightParenthesis()) == null) {
                    psiElement = element;
                }
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
        FUNCTION_PARAMETERS = new PositioningStrategy<KtFunction>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtFunction element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtParameterList valueParameterList = element.getValueParameterList();
                if (valueParameterList != null) {
                    return PositioningStrategyKt.markElement(valueParameterList);
                }
                if (element instanceof KtFunctionLiteral) {
                    ASTNode aSTNode = ((KtFunctionLiteral)element).getLBrace().getNode();
                    Intrinsics.checkExpressionValueIsNotNull(aSTNode, "element.getLBrace().node");
                    return PositioningStrategyKt.markNode(aSTNode);
                }
                return PositioningStrategies.DECLARATION_SIGNATURE_OR_DEFAULT.mark(element);
            }
        };
        CUT_CHAR_QUOTES = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)element).getNode().getElementType(), KtNodeTypes.CHARACTER_CONSTANT)) {
                    TextRange elementTextRange = element.getTextRange();
                    return CollectionsKt.listOf(TextRange.create(elementTextRange.getStartOffset() + 1, elementTextRange.getEndOffset() - 1));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        LONG_LITERAL_SUFFIX = new PositioningStrategy<KtElement>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element instanceof KtConstantExpression && Intrinsics.areEqual(((KtConstantExpression)element).getNode().getElementType(), KtNodeTypes.INTEGER_CONSTANT)) {
                    int endOffset = PsiUtilsKt.getEndOffset(element);
                    return CollectionsKt.listOf(TextRange.create(endOffset - 1, endOffset));
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        UNREACHABLE_CODE = new PositioningStrategy<PsiElement>(){

            @NotNull
            public List<TextRange> markDiagnostic(@NotNull ParametrizedDiagnostic<? extends PsiElement> diagnostic) {
                Intrinsics.checkParameterIsNotNull(diagnostic, "diagnostic");
                List list2 = (List)((DiagnosticWithParameters1)Errors.UNREACHABLE_CODE.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull(list2, "Errors.UNREACHABLE_CODE.cast(diagnostic).getA()");
                return list2;
            }
        };
        AS_TYPE = new PositioningStrategy<KtBinaryExpressionWithTypeRHS>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpressionWithTypeRHS element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement psiElement = element.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.operationReference");
                return PositioningStrategyKt.markRange(psiElement, element);
            }
        };
        COMPANION_OBJECT = new PositioningStrategy<KtObjectDeclaration>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtObjectDeclaration element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element.hasModifier(KtTokens.COMPANION_KEYWORD)) {
                    KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[1];
                    KtModifierKeywordToken ktModifierKeywordToken = KtTokens.COMPANION_KEYWORD;
                    Intrinsics.checkExpressionValueIsNotNull(ktModifierKeywordToken, "KtTokens.COMPANION_KEYWORD");
                    ktModifierKeywordTokenArray[0] = ktModifierKeywordToken;
                    return PositioningStrategies.modifierSetPosition(ktModifierKeywordTokenArray).mark((KtModifierListOwner)((PsiElement)element));
                }
                return PositioningStrategies.DEFAULT.mark(element);
            }
        };
        SECONDARY_CONSTRUCTOR_DELEGATION_CALL = new PositioningStrategy<KtConstructorDelegationCall>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtConstructorDelegationCall element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                if (element.isImplicit()) {
                    PsiElement $receiver$iv = element;
                    KtSecondaryConstructor ktSecondaryConstructor = PsiTreeUtil.getParentOfType($receiver$iv, KtSecondaryConstructor.class, true);
                    if (ktSecondaryConstructor == null) {
                        Intrinsics.throwNpe();
                    }
                    KtSecondaryConstructor constructor = ktSecondaryConstructor;
                    KtParameterList ktParameterList = constructor.getValueParameterList();
                    if (ktParameterList == null) {
                        return PositioningStrategyKt.markElement(constructor);
                    }
                    KtParameterList valueParameterList = ktParameterList;
                    PsiElement psiElement = constructor.getConstructorKeyword();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "constructor.getConstructorKeyword()");
                    PsiElement psiElement2 = valueParameterList.getLastChild();
                    Intrinsics.checkExpressionValueIsNotNull(psiElement2, "valueParameterList.getLastChild()");
                    return PositioningStrategyKt.markRange(psiElement, psiElement2);
                }
                KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = element.getCalleeExpression();
                return PositioningStrategyKt.markElement(ktConstructorDelegationReferenceExpression != null ? (PsiElement)ktConstructorDelegationReferenceExpression : (PsiElement)element);
            }
        };
        DELEGATOR_SUPER_CALL = new PositioningStrategy<KtEnumEntry>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtEnumEntry element) {
                KtElementImplStub ktElementImplStub;
                Intrinsics.checkParameterIsNotNull(element, "element");
                List<KtSuperTypeListEntry> specifiers = element.getSuperTypeListEntries();
                if (specifiers.isEmpty()) {
                    ktElementImplStub = element;
                } else {
                    KtElementImplStub ktElementImplStub2 = specifiers.get(0);
                    ktElementImplStub = ktElementImplStub2;
                    Intrinsics.checkExpressionValueIsNotNull(ktElementImplStub2, "specifiers[0]");
                }
                return PositioningStrategyKt.markElement(ktElementImplStub);
            }
        };
        UNUSED_VALUE = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                KtExpression ktExpression = element.getLeft();
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                return CollectionsKt.listOf(new TextRange(PsiUtilsKt.getStartOffset(ktExpression), PsiUtilsKt.getEndOffset(element.getOperationReference())));
            }
        };
        USELESS_ELVIS = new PositioningStrategy<KtBinaryExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtBinaryExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return CollectionsKt.listOf(new TextRange(PsiUtilsKt.getStartOffset(element.getOperationReference()), PsiUtilsKt.getEndOffset(element)));
            }
        };
        IMPORT_ALIAS = new PositioningStrategy<KtImportDirective>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtImportDirective element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                ASTNode aSTNode = element.getAliasNameNode();
                if (aSTNode != null) {
                    ASTNode it;
                    ASTNode aSTNode2 = aSTNode;
                    ASTNode aSTNode3 = it = aSTNode2;
                    Intrinsics.checkExpressionValueIsNotNull(aSTNode3, "it");
                    return PositioningStrategyKt.markNode(aSTNode3);
                }
                KtExpression ktExpression = element.getImportedReference();
                if (ktExpression != null) {
                    KtExpression ktExpression2 = ktExpression;
                    KtExpression it = ktExpression2;
                    if (it instanceof KtQualifiedExpression) {
                        KtExpression ktExpression3 = ((KtQualifiedExpression)it).getSelectorExpression();
                        if (ktExpression3 != null) {
                            KtExpression ktExpression4 = ktExpression3;
                            KtExpression it2 = ktExpression4;
                            return PositioningStrategyKt.markElement(it2);
                        }
                    }
                    PsiElement psiElement = it;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "it");
                    return PositioningStrategyKt.markElement(psiElement);
                }
                return PositioningStrategyKt.markElement(element);
            }
        };
        RETURN_WITH_LABEL = new PositioningStrategy<KtReturnExpression>(){

            @NotNull
            public List<TextRange> mark(@NotNull KtReturnExpression element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                PsiElement labeledExpression = element.getLabeledExpression();
                if (labeledExpression != null) {
                    return PositioningStrategyKt.markRange(element, labeledExpression);
                }
                PsiElement psiElement = element.getReturnKeyword();
                Intrinsics.checkExpressionValueIsNotNull(psiElement, "element.returnKeyword");
                return PositioningStrategyKt.markElement(psiElement);
            }
        };
    }

    static {
        new PositioningStrategies();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0012\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategies$DeclarationHeader;", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "()V", "isValid", "", "element", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "kotlin-compiler"})
    private static class DeclarationHeader<T extends KtDeclaration>
    extends PositioningStrategy<T> {
        @Override
        public boolean isValid(@NotNull T element) {
            Intrinsics.checkParameterIsNotNull(element, "element");
            if (element instanceof KtNamedDeclaration && !(element instanceof KtObjectDeclaration) && !(element instanceof KtSecondaryConstructor) && !(element instanceof KtFunction) && ((KtNamedDeclaration)element).getNameIdentifier() == null) {
                return false;
            }
            return super.isValid((PsiElement)element);
        }
    }
}

