/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.java.model.elements;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.java.model.elements.JeAnnotationValueKt;
import org.jetbrains.kotlin.java.model.elements.JeMethodExecutableElement;
import org.jetbrains.kotlin.java.model.elements.JeSingletonArrayAnnotationValue;
import org.jetbrains.kotlin.java.model.types.JeDeclaredErrorType;
import org.jetbrains.kotlin.java.model.types.JeDeclaredType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0016\u0010\r\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016J\u001e\u0010\r\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/java/model/elements/JeAnnotationMirror;", "Ljavax/lang/model/element/AnnotationMirror;", "psi", "Lcom/intellij/psi/PsiAnnotation;", "(Lcom/intellij/psi/PsiAnnotation;)V", "getPsi", "()Lcom/intellij/psi/PsiAnnotation;", "getAllElementValues", "", "Ljavax/lang/model/element/ExecutableElement;", "Ljavax/lang/model/element/AnnotationValue;", "getAnnotationType", "Ljavax/lang/model/type/DeclaredType;", "getElementValues", "withDefaults", "", "resolveAnnotationClass", "Lcom/intellij/psi/PsiClass;", "annotation-processing"})
public final class JeAnnotationMirror
implements AnnotationMirror {
    @NotNull
    private final PsiAnnotation psi;

    @Override
    @Nullable
    public DeclaredType getAnnotationType() {
        PsiClass psiClass = this.resolveAnnotationClass();
        if (psiClass == null) {
            return JeDeclaredErrorType.INSTANCE;
        }
        PsiClass psiClass2 = psiClass;
        PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)psiClass2);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"PsiTypesUtil.getClassType(psiClass)");
        return new JeDeclaredType(psiClassType, psiClass2, null, false, 12, null);
    }

    @NotNull
    public Map<? extends ExecutableElement, AnnotationValue> getElementValues() {
        return this.getElementValues(false);
    }

    @NotNull
    public final Map<? extends ExecutableElement, AnnotationValue> getAllElementValues() {
        return this.getElementValues(true);
    }

    private final Map<? extends ExecutableElement, AnnotationValue> getElementValues(boolean withDefaults) {
        PsiClass psiClass = this.resolveAnnotationClass();
        if (psiClass == null) {
            return MapsKt.emptyMap();
        }
        PsiClass annotationClass = psiClass;
        Map map = MapsKt.mutableMapOf((Pair[])new Pair[0]);
        Map $receiver = map;
        PsiMethod[] psiMethodArray = annotationClass.getMethods();
        for (int i = 0; i < psiMethodArray.length; ++i) {
            PsiType returnType;
            PsiMethod method = psiMethodArray[i];
            PsiMethod psiMethod = method;
            if (!(psiMethod instanceof PsiAnnotationMethod)) {
                psiMethod = null;
            }
            if ((PsiAnnotationMethod)psiMethod == null) {
                continue;
            }
            if (((PsiAnnotationMethod)method).getReturnType() == null) {
                continue;
            }
            PsiAnnotationMemberValue psiAnnotationMemberValue = this.psi.findDeclaredAttributeValue(((PsiAnnotationMethod)method).getName());
            if (psiAnnotationMemberValue == null) {
                psiAnnotationMemberValue = withDefaults ? ((PsiAnnotationMethod)method).getDefaultValue() : (PsiAnnotationMemberValue)null;
            }
            if (psiAnnotationMemberValue == null) {
                continue;
            }
            PsiAnnotationMemberValue attributeValue = psiAnnotationMemberValue;
            AnnotationValue annotationValue = returnType instanceof PsiArrayType && !(attributeValue instanceof PsiArrayInitializerMemberValue) ? (AnnotationValue)new JeSingletonArrayAnnotationValue(attributeValue) : JeAnnotationValueKt.JeAnnotationValue(attributeValue);
            $receiver.put(new JeMethodExecutableElement(method), annotationValue);
        }
        return map;
    }

    private final PsiClass resolveAnnotationClass() {
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.psi.getNameReferenceElement();
        Object object = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.resolve() : null;
        if (!(object instanceof PsiClass)) {
            object = null;
        }
        return (PsiClass)object;
    }

    @NotNull
    public final PsiAnnotation getPsi() {
        return this.psi;
    }

    public JeAnnotationMirror(@NotNull PsiAnnotation psi) {
        Intrinsics.checkParameterIsNotNull((Object)psi, (String)"psi");
        this.psi = psi;
    }
}

