/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.ThreadPool;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.core.scanner.AbstractHostPlugin;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.Analyser;
import org.parosproxy.paros.core.scanner.Kb;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerHook;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.users.User;

public class HostProcess
implements Runnable {
    private static final Logger log = Logger.getLogger(HostProcess.class);
    private static final DecimalFormat decimalFormat = new DecimalFormat("###0.###");
    private List<StructuralNode> startNodes = null;
    private boolean isStop = false;
    private PluginFactory pluginFactory;
    private ScannerParam scannerParam = null;
    private HttpSender httpSender = null;
    private ThreadPool threadPool = null;
    private Scanner parentScanner = null;
    private String hostAndPort = "";
    private Analyser analyser = null;
    private Kb kb = null;
    private User user = null;
    private TechSet techSet = null;
    private final Map<Integer, PluginStats> mapPluginStats = new HashMap<Integer, PluginStats>();
    private final Set<Integer> listPluginIdSkipped = new HashSet<Integer>();
    private long hostProcessStartTime = 0L;
    private int nodeInScopeCount = 0;
    private int percentage = 0;

    public HostProcess(String string, Scanner scanner, ScannerParam scannerParam, ConnectionParam connectionParam, ScanPolicy scanPolicy) {
        this.hostAndPort = string;
        this.parentScanner = scanner;
        this.scannerParam = scannerParam;
        this.pluginFactory = scanPolicy.getPluginFactory().clone();
        this.httpSender = new HttpSender(connectionParam, true, 2);
        this.httpSender.setUser(this.user);
        this.httpSender.setRemoveUserDefinedAuthHeaders(true);
        int n = scannerParam.getHandleAntiCSRFTokens() ? 1 : scannerParam.getThreadPerHost();
        this.threadPool = new ThreadPool(n, "ZAP-ActiveScanner-");
    }

    public void setStartNode(StructuralNode structuralNode) {
        this.startNodes = new ArrayList<StructuralNode>();
        this.startNodes.add(structuralNode);
    }

    public void addStartNode(StructuralNode structuralNode) {
        if (this.startNodes == null) {
            this.startNodes = new ArrayList<StructuralNode>();
        }
        this.startNodes.add(structuralNode);
    }

    public void stop() {
        this.isStop = true;
        this.getAnalyser().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug((Object)"HostProcess.run");
        try {
            TraverseCounter traverseCounter = new TraverseCounter();
            this.hostProcessStartTime = System.currentTimeMillis();
            for (StructuralNode structuralNode : this.startNodes) {
                this.traverse(structuralNode, true, traverseCounter);
                this.getAnalyser().start(structuralNode);
            }
            this.nodeInScopeCount = traverseCounter.getCount();
            log.info((Object)("Scanning " + this.nodeInScopeCount + " node(s) from " + this.hostAndPort));
            while (!this.isStop() && this.pluginFactory.existPluginToRun()) {
                Plugin plugin = this.pluginFactory.nextPlugin();
                if (plugin != null) {
                    plugin.setDelayInMs(this.scannerParam.getDelayInMs());
                    plugin.setTechSet(this.techSet);
                    this.processPlugin(plugin);
                    continue;
                }
                Util.sleep(1000);
            }
            this.threadPool.waitAllThreadComplete(300000);
        }
        catch (Exception exception) {
            log.error((Object)"An error occurred while active scanning:", (Throwable)exception);
            this.stop();
        }
        finally {
            this.notifyHostProgress(null);
            this.notifyHostComplete();
            this.getHttpSender().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPlugin(final Plugin plugin) {
        Map<Integer, PluginStats> map = this.mapPluginStats;
        synchronized (map) {
            this.mapPluginStats.put(plugin.getId(), new PluginStats());
        }
        if (this.techSet != null && !plugin.targets(this.techSet)) {
            this.listPluginIdSkipped.add(plugin.getId());
            this.pluginCompleted(plugin);
            return;
        }
        log.info((Object)("start host " + this.hostAndPort + " | " + plugin.getCodeName() + " strength " + (Object)((Object)plugin.getAttackStrength()) + " threshold " + (Object)((Object)plugin.getAlertThreshold())));
        for (StructuralNode structuralNode : this.startNodes) {
            if (plugin instanceof AbstractHostPlugin) {
                if (this.scanSingleNode(plugin, structuralNode)) continue;
                this.pluginCompleted(plugin);
                continue;
            }
            if (!(plugin instanceof AbstractAppPlugin)) continue;
            try {
                this.traverse(structuralNode, true, new TraverseAction(){

                    @Override
                    public void apply(StructuralNode structuralNode) {
                        log.debug((Object)("traverse: plugin=" + plugin.getName() + " url=" + structuralNode.getName()));
                        HostProcess.this.scanSingleNode(plugin, structuralNode);
                    }

                    @Override
                    public boolean isStopTraversing() {
                        return HostProcess.this.isSkipped(plugin);
                    }
                });
                this.threadPool.waitAllThreadComplete(600000);
            }
            finally {
                this.pluginCompleted(plugin);
            }
        }
    }

    private void traverse(StructuralNode structuralNode, TraverseAction traverseAction) {
        this.traverse(structuralNode, false, traverseAction);
    }

    private void traverse(StructuralNode structuralNode, boolean bl, TraverseAction traverseAction) {
        if (structuralNode == null || this.isStop()) {
            return;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(structuralNode);
        traverseAction.apply(structuralNode);
        if (!traverseAction.isStopTraversing() && this.parentScanner.scanChildren()) {
            Object object;
            if (bl) {
                try {
                    Iterator<Object> iterator = structuralNode.getParent().getChildIterator();
                    Object object2 = SessionStructure.getCleanRelativeName(structuralNode, false);
                    while (iterator.hasNext()) {
                        object = (StructuralNode)iterator.next();
                        if (structuralNode.isSameAs((StructuralNode)object) || !((String)object2).equals(SessionStructure.getCleanRelativeName((StructuralNode)object, false))) continue;
                        log.debug((Object)("traverse: including related sibling " + object.getName()));
                        hashSet.add(object);
                    }
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
            }
            for (Object object2 : hashSet) {
                object = object2.getChildIterator();
                while (object.hasNext() && !this.isStop() && !traverseAction.isStopTraversing()) {
                    StructuralNode structuralNode2 = (StructuralNode)object.next();
                    while (this.parentScanner.isPaused() && !this.isStop()) {
                        Util.sleep(500);
                    }
                    try {
                        this.traverse(structuralNode2, traverseAction);
                    }
                    catch (Exception exception) {
                        log.error((Object)exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        }
    }

    protected boolean nodeInScope(String string) {
        return this.parentScanner.isInScope(string);
    }

    private boolean scanSingleNode(Plugin plugin, StructuralNode structuralNode) {
        Thread thread;
        Plugin plugin2;
        log.debug((Object)("scanSingleNode node plugin=" + plugin.getName() + " node=" + structuralNode.getName()));
        try {
            if (structuralNode == null || structuralNode.getHistoryReference() == null) {
                log.debug((Object)("scanSingleNode node or href null, returning: node=" + structuralNode));
                return false;
            }
            if (3 == structuralNode.getHistoryReference().getHistoryType()) {
                log.debug((Object)"Ignoring \"scanner\" type href");
                return false;
            }
            if (!this.nodeInScope(structuralNode.getName())) {
                log.debug((Object)"scanSingleNode node not in scope");
                return false;
            }
            HttpMessage httpMessage = structuralNode.getHistoryReference().getHttpMessage();
            if (httpMessage == null) {
                log.debug((Object)"scanSingleNode msg null");
                return false;
            }
            plugin2 = (Plugin)plugin.getClass().newInstance();
            plugin2.setConfig(plugin.getConfig());
            plugin2.setDelayInMs(plugin.getDelayInMs());
            plugin2.setDefaultAlertThreshold(plugin.getAlertThreshold());
            plugin2.setDefaultAttackStrength(plugin.getAttackStrength());
            plugin2.setTechSet(this.getTechSet());
            plugin2.init(httpMessage, this);
            this.notifyHostProgress(plugin.getName() + ": " + httpMessage.getRequestHeader().getURI().toString());
        }
        catch (Exception exception) {
            log.error((Object)(exception.getMessage() + " " + structuralNode.getName()), (Throwable)exception);
            return false;
        }
        do {
            if (this.isStop()) {
                return false;
            }
            thread = this.threadPool.getFreeThreadAndRun(plugin2);
            if (thread != null) continue;
            Util.sleep(200);
        } while (thread == null);
        this.mapPluginStats.get(plugin.getId()).incProgress();
        return true;
    }

    public int getTestTotalCount() {
        return this.nodeInScopeCount;
    }

    public int getTestCurrentCount(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return 0;
        }
        return pluginStats.getProgress();
    }

    @Deprecated
    public void setTestCurrentCount(Plugin plugin, int n) {
    }

    public HttpSender getHttpSender() {
        return this.httpSender;
    }

    public boolean isStop() {
        return this.isStop || this.parentScanner.isStop();
    }

    public boolean isPaused() {
        return this.parentScanner.isPaused();
    }

    public int getPercentageComplete() {
        return this.percentage;
    }

    private void notifyHostProgress(String string) {
        if (this.pluginFactory.totalPluginToRun() == 0) {
            this.percentage = 100;
        } else {
            int n = 0;
            double d = 0.0;
            for (Plugin plugin : this.pluginFactory.getRunning()) {
                int n2 = this.getTestCurrentCount(plugin);
                double d2 = (double)n2 * 100.0 / (double)this.getTestTotalCount();
                if (d2 >= 100.0) {
                    this.nodeInScopeCount = n2;
                    d2 = 99.0;
                }
                d += d2;
                ++n;
            }
            int n3 = (int)(d / (double)n);
            this.percentage = (100 * this.pluginFactory.totalPluginCompleted() + n3) / this.pluginFactory.totalPluginToRun();
        }
        this.parentScanner.notifyHostProgress(this.hostAndPort, string, this.percentage);
    }

    private void notifyHostComplete() {
        long l = System.currentTimeMillis() - this.hostProcessStartTime;
        String string = decimalFormat.format((double)l / 1000.0) + "s";
        log.info((Object)("completed host " + this.hostAndPort + " in " + string));
        this.parentScanner.notifyHostComplete(this.hostAndPort);
    }

    public void notifyNewMessage(HttpMessage httpMessage) {
        this.parentScanner.notifyNewMessage(httpMessage);
    }

    public void notifyNewMessage(Plugin plugin, HttpMessage httpMessage) {
        this.parentScanner.notifyNewMessage(httpMessage);
        this.notifyNewMessage(plugin);
    }

    public void notifyNewMessage(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Parameter plugin must not be null.");
        }
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats != null) {
            pluginStats.incMessageCount();
        }
    }

    public void alertFound(Alert alert) {
        this.parentScanner.notifyAlertFound(alert);
    }

    public Analyser getAnalyser() {
        if (this.analyser == null) {
            this.analyser = new Analyser(this.getHttpSender(), this);
        }
        return this.analyser;
    }

    public boolean handleAntiCsrfTokens() {
        return this.scannerParam.getHandleAntiCSRFTokens();
    }

    public void pluginSkipped(Plugin plugin) {
        if (this.pluginFactory.isRunning(plugin)) {
            this.listPluginIdSkipped.add(plugin.getId());
        }
    }

    public boolean isSkipped(Plugin plugin) {
        return !this.listPluginIdSkipped.isEmpty() && this.listPluginIdSkipped.contains(plugin.getId());
    }

    void pluginCompleted(Plugin plugin) {
        PluginStats pluginStats = this.mapPluginStats.get(plugin.getId());
        if (pluginStats == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isStop()) {
            stringBuilder.append("stopped host/plugin ");
        } else if (this.isSkipped(plugin)) {
            stringBuilder.append("skipped plugin ");
        } else {
            stringBuilder.append("completed host/plugin ");
        }
        stringBuilder.append(this.hostAndPort).append(" | ").append(plugin.getCodeName());
        long l = pluginStats.getStartTime();
        long l2 = System.currentTimeMillis() - l;
        String string = decimalFormat.format((double)l2 / 1000.0) + "s";
        stringBuilder.append(" in ").append(string);
        log.info((Object)stringBuilder.toString());
        this.pluginFactory.setRunningPluginCompleted(plugin);
        this.notifyHostProgress(null);
        pluginStats.setProgress(this.nodeInScopeCount);
    }

    Kb getKb() {
        if (this.kb == null) {
            this.kb = new Kb();
        }
        return this.kb;
    }

    protected ScannerParam getScannerParam() {
        return this.scannerParam;
    }

    public List<Plugin> getPending() {
        return this.pluginFactory.getPending();
    }

    public List<Plugin> getRunning() {
        return this.pluginFactory.getRunning();
    }

    public List<Plugin> getCompleted() {
        return this.pluginFactory.getCompleted();
    }

    public void setUser(User user) {
        this.user = user;
        if (this.httpSender != null) {
            this.httpSender.setUser(user);
        }
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    public void setTechSet(TechSet techSet) {
        this.techSet = techSet;
    }

    protected synchronized void performScannerHookBeforeScan(HttpMessage httpMessage, AbstractPlugin abstractPlugin) {
        for (ScannerHook scannerHook : this.parentScanner.getScannerHooks()) {
            if (scannerHook == null) continue;
            try {
                scannerHook.beforeScan(httpMessage, abstractPlugin, this.parentScanner);
            }
            catch (Exception exception) {
                log.info((Object)("An exception occurred while trying to call beforeScan(msg, plugin) for one of the ScannerHooks: " + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    protected synchronized void performScannerHookAfterScan(HttpMessage httpMessage, AbstractPlugin abstractPlugin) {
        for (ScannerHook scannerHook : this.parentScanner.getScannerHooks()) {
            if (scannerHook == null) continue;
            try {
                scannerHook.afterScan(httpMessage, abstractPlugin, this.parentScanner);
            }
            catch (Exception exception) {
                log.info((Object)("An exception occurred while trying to call afterScan(msg, plugin) for one of the ScannerHooks: " + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    public String getHostAndPort() {
        return this.hostAndPort;
    }

    @Deprecated
    public void setPluginRequestCount(int n, int n2) {
    }

    public int getPluginRequestCount(int n) {
        PluginStats pluginStats = this.mapPluginStats.get(n);
        if (pluginStats != null) {
            return pluginStats.getMessageCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequestCount() {
        Map<Integer, PluginStats> map = this.mapPluginStats;
        synchronized (map) {
            int n = this.getAnalyser().getRequestCount();
            for (PluginStats pluginStats : this.mapPluginStats.values()) {
                n += pluginStats.getMessageCount();
            }
            return n;
        }
    }

    private static class PluginStats {
        private final long startTime = System.currentTimeMillis();
        private int messageCount;
        private int progress;

        public long getStartTime() {
            return this.startTime;
        }

        public int getMessageCount() {
            return this.messageCount;
        }

        public void incMessageCount() {
            ++this.messageCount;
        }

        public int getProgress() {
            return this.progress;
        }

        public void incProgress() {
            ++this.progress;
        }

        public void setProgress(int n) {
            this.progress = n;
        }
    }

    private static class TraverseCounter
    implements TraverseAction {
        private int count;

        private TraverseCounter() {
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void apply(StructuralNode structuralNode) {
            ++this.count;
        }

        @Override
        public boolean isStopTraversing() {
            return false;
        }
    }

    private static interface TraverseAction {
        public void apply(StructuralNode var1);

        public boolean isStopTraversing();
    }
}

