/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.view.StatusUI;

public class PolicyPassiveScanTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("ascan.policy.table.testname"), Constant.messages.getString("ascan.policy.table.threshold"), Constant.messages.getString("ascan.policy.table.quality")};
    private static final int QUALITY_COLUMN_IDX = 2;
    private List<ScannerWrapper> listScanners = new ArrayList<ScannerWrapper>();
    private Map<String, String> i18nToStr = null;

    public void addScanner(PluginPassiveScanner pluginPassiveScanner) {
        this.listScanners.add(new ScannerWrapper(pluginPassiveScanner, View.getSingleton().getStatusUI(pluginPassiveScanner.getStatus())));
        this.fireTableDataChanged();
    }

    public void persistChanges() {
        for (ScannerWrapper scannerWrapper : this.listScanners) {
            scannerWrapper.persistChanges();
        }
    }

    public void reset() {
        for (ScannerWrapper scannerWrapper : this.listScanners) {
            scannerWrapper.reset();
        }
    }

    public void applyThreshold(Plugin.AlertThreshold alertThreshold, String string) {
        for (ScannerWrapper scannerWrapper : this.listScanners) {
            if (!string.equals(scannerWrapper.getQuality().toString())) continue;
            scannerWrapper.setThreshold(alertThreshold);
        }
    }

    public void applyThresholdToAll(Plugin.AlertThreshold alertThreshold) {
        for (ScannerWrapper scannerWrapper : this.listScanners) {
            scannerWrapper.setThreshold(alertThreshold);
        }
    }

    public void removeScanner(PluginPassiveScanner pluginPassiveScanner) {
        for (int i = 0; i < this.listScanners.size(); ++i) {
            if (!pluginPassiveScanner.equals(this.listScanners.get(i).getScanner())) continue;
            this.listScanners.remove(i);
            this.fireTableRowsDeleted(i, i);
            break;
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 2) {
            return StatusUI.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ScannerWrapper scannerWrapper = this.listScanners.get(n);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                Plugin.AlertThreshold alertThreshold = Plugin.AlertThreshold.valueOf(this.i18nToStr((String)object));
                scannerWrapper.setThreshold(alertThreshold);
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    private String strToI18n(String string) {
        return Constant.messages.getString("ascan.policy.level." + string.toLowerCase());
    }

    private String i18nToStr(String string) {
        if (this.i18nToStr == null) {
            this.i18nToStr = new HashMap<String, String>();
            for (Plugin.AlertThreshold alertThreshold : Plugin.AlertThreshold.values()) {
                this.i18nToStr.put(this.strToI18n(alertThreshold.name()), alertThreshold.name());
            }
        }
        return this.i18nToStr.get(string);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.listScanners == null) {
            return 0;
        }
        return this.listScanners.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ScannerWrapper scannerWrapper = this.listScanners.get(n);
        Object object = null;
        switch (n2) {
            case 0: {
                object = scannerWrapper.getName();
                break;
            }
            case 1: {
                object = this.strToI18n(scannerWrapper.getThreshold().name());
                break;
            }
            case 2: {
                object = scannerWrapper.getQuality();
                break;
            }
            default: {
                object = "";
            }
        }
        return object;
    }

    private static class ScannerWrapper {
        private final PluginPassiveScanner scanner;
        private final StatusUI quality;
        private Plugin.AlertThreshold threshold;

        public ScannerWrapper(PluginPassiveScanner pluginPassiveScanner, StatusUI statusUI) {
            this.scanner = pluginPassiveScanner;
            this.quality = statusUI;
            this.reset();
        }

        public PluginPassiveScanner getScanner() {
            return this.scanner;
        }

        public void reset() {
            this.threshold = this.scanner.getLevel();
        }

        public void persistChanges() {
            this.scanner.setLevel(this.threshold);
            this.scanner.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)this.threshold));
            this.scanner.save();
        }

        public String getName() {
            return this.scanner.getName();
        }

        public Plugin.AlertThreshold getThreshold() {
            return this.threshold;
        }

        public void setThreshold(Plugin.AlertThreshold alertThreshold) {
            this.threshold = alertThreshold;
        }

        public StatusUI getQuality() {
            return this.quality;
        }
    }
}

