/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import groovy.lang.Closure;
import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.specs.Spec;

public class ErrorHandlingConfigurationResolver
implements ConfigurationResolver {
    private final ConfigurationResolver delegate;

    public ErrorHandlingConfigurationResolver(ConfigurationResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public void resolve(ConfigurationInternal configuration, ResolverResults results) throws ResolveException {
        try {
            this.delegate.resolve(configuration, results);
        }
        catch (Throwable e) {
            results.failed(ErrorHandlingConfigurationResolver.wrapException(e, configuration));
            results.withResolvedConfiguration(new BrokenResolvedConfiguration(e, configuration));
            return;
        }
        ErrorHandlingResolutionResult wrappedResult = new ErrorHandlingResolutionResult(results.getResolutionResult(), configuration);
        results.resolved(wrappedResult, results.getResolvedLocalComponents());
    }

    @Override
    public void resolveArtifacts(ConfigurationInternal configuration, ResolverResults results) throws ResolveException {
        try {
            this.delegate.resolveArtifacts(configuration, results);
        }
        catch (ResolveException e) {
            results.withResolvedConfiguration(new BrokenResolvedConfiguration(e, configuration));
            return;
        }
        ErrorHandlingResolvedConfiguration wrappedConfiguration = new ErrorHandlingResolvedConfiguration(results.getResolvedConfiguration(), configuration);
        results.withResolvedConfiguration(wrappedConfiguration);
    }

    private static ResolveException wrapException(Throwable e, ResolveContext resolveContext) {
        if (e instanceof ResolveException) {
            return (ResolveException)e;
        }
        return new ResolveException(resolveContext.getDisplayName(), e);
    }

    private static class BrokenResolvedConfiguration
    implements ResolvedConfiguration {
        private final Throwable e;
        private final ConfigurationInternal configuration;

        public BrokenResolvedConfiguration(Throwable e, ConfigurationInternal configuration) {
            this.e = e;
            this.configuration = configuration;
        }

        public boolean hasError() {
            return true;
        }

        public LenientConfiguration getLenientConfiguration() {
            throw ErrorHandlingConfigurationResolver.wrapException(this.e, this.configuration);
        }

        public void rethrowFailure() throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.e, this.configuration);
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.e, this.configuration);
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.e, this.configuration);
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.e, this.configuration);
        }

        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.e, this.configuration);
        }
    }

    private static class ErrorHandlingResolvedConfiguration
    implements ResolvedConfiguration {
        private final ResolvedConfiguration resolvedConfiguration;
        private final ConfigurationInternal configuration;

        public ErrorHandlingResolvedConfiguration(ResolvedConfiguration resolvedConfiguration, ConfigurationInternal configuration) {
            this.resolvedConfiguration = resolvedConfiguration;
            this.configuration = configuration;
        }

        public boolean hasError() {
            return this.resolvedConfiguration.hasError();
        }

        public LenientConfiguration getLenientConfiguration() {
            try {
                return new ErrorHandlingLenientConfiguration(this.resolvedConfiguration.getLenientConfiguration(), this.configuration);
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        public void rethrowFailure() throws ResolveException {
            try {
                this.resolvedConfiguration.rethrowFailure();
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFiles(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies();
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            try {
                return this.resolvedConfiguration.getResolvedArtifacts();
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }
    }

    private static class ErrorHandlingResolutionResult
    implements ResolutionResult {
        private final ResolutionResult resolutionResult;
        private final ResolveContext resolveContext;

        public ErrorHandlingResolutionResult(ResolutionResult resolutionResult, ResolveContext configuration) {
            this.resolutionResult = resolutionResult;
            this.resolveContext = configuration;
        }

        public ResolvedComponentResult getRoot() {
            try {
                return this.resolutionResult.getRoot();
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        public void allDependencies(Action<? super DependencyResult> action) {
            this.resolutionResult.allDependencies(action);
        }

        public Set<? extends DependencyResult> getAllDependencies() {
            try {
                return this.resolutionResult.getAllDependencies();
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        public void allDependencies(Closure closure) {
            this.resolutionResult.allDependencies(closure);
        }

        public Set<ResolvedComponentResult> getAllComponents() {
            try {
                return this.resolutionResult.getAllComponents();
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        public void allComponents(Action<? super ResolvedComponentResult> action) {
            this.resolutionResult.allComponents(action);
        }

        public void allComponents(Closure closure) {
            this.resolutionResult.allComponents(closure);
        }
    }

    private static class ErrorHandlingLenientConfiguration
    implements LenientConfiguration {
        private final LenientConfiguration lenientConfiguration;
        private final ResolveContext resolveContext;

        private ErrorHandlingLenientConfiguration(LenientConfiguration lenientConfiguration, ResolveContext resolveContext) {
            this.lenientConfiguration = lenientConfiguration;
            this.resolveContext = resolveContext;
        }

        public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getArtifacts(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getAllModuleDependencies() {
            try {
                return this.lenientConfiguration.getAllModuleDependencies();
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
            try {
                return this.lenientConfiguration.getUnresolvedModuleDependencies();
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getFiles(dependencySpec);
            }
            catch (Throwable e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }
    }
}

