/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gnu.trove;

import java.io.Serializable;
import org.jetbrains.kotlin.gnu.trove.HashFunctions;
import org.jetbrains.kotlin.gnu.trove.TIntProcedure;

public class TIntArrayList
implements Serializable,
Cloneable {
    protected transient int[] _data;
    protected transient int _pos;

    public TIntArrayList() {
        this(4);
    }

    public TIntArrayList(int capacity) {
        this._data = new int[capacity];
        this._pos = 0;
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            int[] tmp = new int[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void add(int val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public int get(int offset2) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        return this._data[offset2];
    }

    public int getQuick(int offset2) {
        return this._data[offset2];
    }

    public void clear() {
        this.clear(4);
    }

    public void clear(int capacity) {
        this._data = new int[capacity];
        this._pos = 0;
    }

    public int remove(int offset2) {
        int old = this.get(offset2);
        this.remove(offset2, 1);
        return old;
    }

    public void remove(int offset2, int length) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        if (offset2 == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset2) {
            System.arraycopy(this._data, offset2 + length, this._data, offset2, this._pos - (offset2 + length));
        }
        this._pos -= length;
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i = from;
        for (int j = to - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
    }

    private void swap(int i, int j) {
        int tmp = this._data[i];
        this._data[i] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        TIntArrayList clone = null;
        try {
            clone = (TIntArrayList)super.clone();
            clone._data = (int[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public int[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public int[] toNativeArray(int offset2, int len) {
        int[] rv = new int[len];
        this.toNativeArray(rv, offset2, len);
        return rv;
    }

    public void toNativeArray(int[] dest, int offset2, int len) {
        if (len == 0) {
            return;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TIntArrayList) {
            TIntArrayList that = (TIntArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data[i]);
        }
        return h;
    }

    public boolean forEach(TIntProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TIntProcedure(){

            @Override
            public boolean execute(int val) {
                buf.append(val);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }
}

