/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationFailure;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.process.internal.ExecAction;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.ExecException;
import org.gradle.util.GFileUtils;

public class DefaultCommandLineToolInvocationWorker
implements CommandLineToolInvocationWorker {
    private final String name;
    private final File executable;
    private final ExecActionFactory execActionFactory;

    public DefaultCommandLineToolInvocationWorker(String name, File executable, ExecActionFactory execActionFactory) {
        this.name = name;
        this.executable = executable;
        this.execActionFactory = execActionFactory;
    }

    @Override
    public String getDisplayName() {
        return "command line tool '" + this.name + "'";
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void execute(CommandLineToolInvocation invocation) {
        ExecAction toolExec = this.execActionFactory.newExecAction();
        toolExec.executable((Object)this.executable);
        if (invocation.getWorkDirectory() != null) {
            GFileUtils.mkdirs((File)invocation.getWorkDirectory());
            toolExec.workingDir((Object)invocation.getWorkDirectory());
        }
        toolExec.args(invocation.getArgs());
        if (!invocation.getPath().isEmpty()) {
            String pathVar = OperatingSystem.current().getPathVar();
            String toolPath = Joiner.on((String)File.pathSeparator).join(invocation.getPath());
            toolPath = toolPath + File.pathSeparator + System.getenv(pathVar);
            toolExec.environment(pathVar, (Object)toolPath);
            if (OperatingSystem.current().isWindows() && toolExec.getEnvironment().containsKey(pathVar.toUpperCase())) {
                toolExec.getEnvironment().remove(pathVar.toUpperCase());
            }
        }
        toolExec.environment(invocation.getEnvironment());
        ByteArrayOutputStream errOutput = new ByteArrayOutputStream();
        ByteArrayOutputStream stdOutput = new ByteArrayOutputStream();
        toolExec.setErrorOutput((OutputStream)errOutput);
        toolExec.setStandardOutput((OutputStream)stdOutput);
        try {
            toolExec.execute();
            invocation.getLogger().operationSuccess(invocation.getDescription(), this.combineOutput(stdOutput, errOutput));
        }
        catch (ExecException e) {
            invocation.getLogger().operationFailed(invocation.getDescription(), this.combineOutput(stdOutput, errOutput));
            throw new CommandLineToolInvocationFailure(invocation, String.format("%s failed while %s.", this.name, invocation.getDescription()));
        }
    }

    private String combineOutput(OutputStream stdOutput, OutputStream errOutput) {
        return stdOutput.toString() + errOutput.toString();
    }
}

