/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.TextStyle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class Label
implements Selectable,
Serializable,
Elevatable {
    private static final long serialVersionUID = 1L;
    private static final double TWICE_PI = Math.PI * 2;
    private String text;
    private float x;
    private float y;
    private TextStyle style;
    private Integer color;
    private float angle;
    private Float pitch;
    private float elevation;
    private Level level;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Label(String string, float f, float f2) {
        this.text = string;
        this.x = f;
        this.y = f2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        objectInputStream.defaultReadObject();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (!(string == this.text || string != null && string.equals(this.text))) {
            String string2 = this.text;
            this.text = string;
            this.propertyChangeSupport.firePropertyChange(Property.TEXT.name(), string2, string);
        }
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        if (f != this.x) {
            float f2 = this.x;
            this.x = f;
            this.propertyChangeSupport.firePropertyChange(Property.X.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        if (f != this.y) {
            float f2 = this.y;
            this.y = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getGroundElevation() {
        if (this.level != null) {
            return this.elevation + this.level.getElevation();
        }
        return this.elevation;
    }

    public float getElevation() {
        return this.elevation;
    }

    public void setElevation(float f) {
        if (f != this.elevation) {
            float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public void setStyle(TextStyle textStyle) {
        if (textStyle != this.style) {
            TextStyle textStyle2 = this.style;
            this.style = textStyle;
            this.propertyChangeSupport.firePropertyChange(Property.STYLE.name(), textStyle2, textStyle);
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer n) {
        if (n != this.color) {
            Integer n2 = this.color;
            this.color = n;
            this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
        }
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        if ((f = (float)(((double)f % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2))) != this.angle) {
            float f2 = this.angle;
            this.angle = f;
            this.propertyChangeSupport.firePropertyChange(Property.ANGLE.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public Float getPitch() {
        return this.pitch;
    }

    public void setPitch(Float f) {
        if (f != null) {
            f = Float.valueOf((float)(((double)f.floatValue() % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2)));
        }
        if (!(f == this.pitch || f != null && f.equals(this.pitch))) {
            Float f2 = this.pitch;
            this.pitch = f;
            this.propertyChangeSupport.firePropertyChange(Property.PITCH.name(), f2, f);
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level != this.level) {
            Level level2 = this.level;
            this.level = level;
            this.propertyChangeSupport.firePropertyChange(Property.LEVEL.name(), level2, level);
        }
    }

    public boolean isAtLevel(Level level) {
        return this.level == level || this.level != null && level != null && this.level.getElevation() == level.getElevation() && this.level.getElevationIndex() < level.getElevationIndex();
    }

    public float[][] getPoints() {
        return new float[][]{{this.x, this.y}};
    }

    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, 0.0f, 0.0f);
        float_.add(f3, f4);
        return float_.contains(this.x, this.y);
    }

    public boolean containsPoint(float f, float f2, float f3) {
        return Math.abs(f - this.x) <= f3 && Math.abs(f2 - this.y) <= f3;
    }

    public void move(float f, float f2) {
        this.setX(this.getX() + f);
        this.setY(this.getY() + f2);
    }

    public Label clone() {
        try {
            Label label = (Label)super.clone();
            label.propertyChangeSupport = new PropertyChangeSupport(label);
            label.level = null;
            return label;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Super class isn't cloneable");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        TEXT,
        X,
        Y,
        ELEVATION,
        STYLE,
        COLOR,
        ANGLE,
        PITCH,
        LEVEL;

    }
}

