-- EFL LuaJIT bindings: efl_event_input.eo (class Efl.Event.Input)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.efl_event_input_mixin_get()
    eo.class_register("Efl_Event_Input", nil, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *efl_event_input_mixin_get(void);
    void efl_event_device_set(Efl_Input_Device * dev);
    Efl_Input_Device *efl_event_device_get(void);
    void efl_event_flags_set(Efl_Event_Flags flags);
    Efl_Event_Flags efl_event_flags_get(void);
    void efl_event_processed_set(Eina_Bool val);
    Eina_Bool efl_event_processed_get(void);
    void efl_event_scrolling_set(Eina_Bool val);
    Eina_Bool efl_event_scrolling_get(void);
    Eina_Bool efl_event_fake_get(void);
]]

local __M = util.get_namespace(M, { "event" })
__body = {
    device_set = function(self, dev)
        eo.__do_start(self, __class)
        __lib.efl_event_device_set(dev)
        eo.__do_end()
    end,

    device_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_device_get()
        eo.__do_end()
        return v
    end,

    event_flags_set = function(self, flags)
        eo.__do_start(self, __class)
        __lib.efl_event_flags_set(flags)
        eo.__do_end()
    end,

    event_flags_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_flags_get()
        eo.__do_end()
        return v
    end,

    processed_set = function(self, val)
        eo.__do_start(self, __class)
        __lib.efl_event_processed_set(val)
        eo.__do_end()
    end,

    processed_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_processed_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    scrolling_set = function(self, val)
        eo.__do_start(self, __class)
        __lib.efl_event_scrolling_set(val)
        eo.__do_end()
    end,

    scrolling_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_scrolling_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    fake_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_fake_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    __properties = {
        ["scrolling"] = { 0, 0, 1, 1, true, true },
        ["fake"] = { 0, 0, 1, 0, true, false },
        ["event_flags"] = { 0, 0, 1, 1, true, true },
        ["device"] = { 0, 0, 1, 1, true, true },
        ["processed"] = { 0, 0, 1, 1, true, true }
    }
}
__body["__mixin_Efl_Event_Input"] = true

return M
