/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.loader;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.pentaho.loader.InputRepositoryResourceData;
import org.libreoffice.report.pentaho.loader.InputResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;

public class InputRepositoryLoader
implements ResourceLoader {
    private final InputRepository inputRepository;

    public InputRepositoryLoader(InputRepository inputRepository) {
        if (inputRepository == null) {
            throw new NullPointerException();
        }
        this.inputRepository = inputRepository;
    }

    public boolean isSupportedKey(ResourceKey key) {
        return InputRepositoryLoader.class.getName().equals(key.getSchema());
    }

    public ResourceKey createKey(Object value, Map factoryKeys) throws ResourceKeyCreationException {
        String strVal;
        if (value instanceof String && (strVal = (String)value).startsWith("sun:oo://")) {
            return new ResourceKey((Object)InputRepositoryLoader.class.getName(), (Object)new InputResourceKey(this.inputRepository.getId(), strVal), factoryKeys);
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        HashMap map;
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertion: Unsupported parent key type");
        }
        InputResourceKey parentKey = (InputResourceKey)parent.getIdentifier();
        String resource = path.startsWith("sun:oo://") ? path : (path.charAt(0) == '/' ? "sun:oo:/" + path : LoaderUtils.mergePaths((String)parentKey.getPath(), (String)path));
        if (factoryKeys != null) {
            map = new HashMap();
            map.putAll(parent.getFactoryParameters());
            map.putAll(factoryKeys);
        } else {
            map = parent.getFactoryParameters();
        }
        return new ResourceKey(parent.getSchema(), (Object)new InputResourceKey(parentKey.getInputRepositoryId(), resource), map);
    }

    public URL toURL(ResourceKey key) {
        return null;
    }

    public ResourceData load(ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            throw new ResourceLoadingException("None of my keys.");
        }
        return new InputRepositoryResourceData(key, this.inputRepository);
    }

    public boolean isSupportedDeserializer(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String serialize(ResourceKey rk, ResourceKey rk1) throws ResourceException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ResourceKey deserialize(ResourceKey rk, String string) throws ResourceKeyCreationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

