/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.AbstractColorInterpolationRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.GaussianBlurRable;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.GaussianBlurRed8Bit;
import org.apache.batik.ext.awt.image.rendered.PadRed;

public class GaussianBlurRable8Bit
extends AbstractColorInterpolationRable
implements GaussianBlurRable {
    private double stdDeviationX;
    private double stdDeviationY;
    static final double DSQRT2PI = Math.sqrt(Math.PI * 2) * 3.0 / 4.0;
    public static final double eps = 1.0E-4;

    public GaussianBlurRable8Bit(Filter filter, double d, double d2) {
        super(filter, null);
        this.setStdDeviationX(d);
        this.setStdDeviationY(d2);
    }

    @Override
    public void setStdDeviationX(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.stdDeviationX = d;
    }

    @Override
    public void setStdDeviationY(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.stdDeviationY = d;
    }

    @Override
    public double getStdDeviationX() {
        return this.stdDeviationX;
    }

    @Override
    public double getStdDeviationY() {
        return this.stdDeviationY;
    }

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = this.getSource().getBounds2D();
        float f = (float)(this.stdDeviationX * DSQRT2PI);
        float f2 = (float)(this.stdDeviationY * DSQRT2PI);
        float f3 = 3.0f * f / 2.0f;
        float f4 = 3.0f * f2 / 2.0f;
        return new Rectangle2D.Float((float)(rectangle2D.getMinX() - (double)f3), (float)(rectangle2D.getMinY() - (double)f4), (float)(rectangle2D.getWidth() + (double)(2.0f * f3)), (float)(rectangle2D.getHeight() + (double)(2.0f * f4)));
    }

    @Override
    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public static boolean eps_eq(double d, double d2) {
        return d >= d2 - 1.0E-4 && d <= d2 + 1.0E-4;
    }

    public static boolean eps_abs_eq(double d, double d2) {
        if (d < 0.0) {
            d = -d;
        }
        if (d2 < 0.0) {
            d2 = -d2;
        }
        return GaussianBlurRable8Bit.eps_eq(d, d2);
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        Rectangle2D rectangle2D;
        Object object;
        int n;
        int n2;
        AffineTransform affineTransform;
        AffineTransform affineTransform2;
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        }
        AffineTransform affineTransform3 = renderContext.getTransform();
        double d = affineTransform3.getScaleX();
        double d2 = affineTransform3.getScaleY();
        double d3 = affineTransform3.getShearX();
        double d4 = affineTransform3.getShearY();
        double d5 = affineTransform3.getTranslateX();
        double d6 = affineTransform3.getTranslateY();
        double d7 = Math.sqrt(d * d + d4 * d4);
        double d8 = Math.sqrt(d2 * d2 + d3 * d3);
        double d9 = this.stdDeviationX * d7;
        double d10 = this.stdDeviationY * d8;
        if (d9 < 10.0 && d10 < 10.0 && GaussianBlurRable8Bit.eps_eq(d9, d10) && GaussianBlurRable8Bit.eps_abs_eq(d / d7, d2 / d8)) {
            affineTransform2 = affineTransform3;
            affineTransform = null;
            n2 = 0;
            n = 0;
        } else {
            if (d9 > 10.0) {
                d7 = d7 * 10.0 / d9;
                d9 = 10.0;
            }
            if (d10 > 10.0) {
                d8 = d8 * 10.0 / d10;
                d10 = 10.0;
            }
            affineTransform2 = AffineTransform.getScaleInstance(d7, d8);
            affineTransform = new AffineTransform(d / d7, d4 / d7, d3 / d8, d2 / d8, d5, d6);
            n2 = 1;
            n = 1;
        }
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = this.getBounds2D();
        }
        Shape shape2 = affineTransform2.createTransformedShape(shape);
        Rectangle rectangle = shape2.getBounds();
        rectangle.x -= (n2 += GaussianBlurRed8Bit.surroundPixels(d9, renderingHints));
        rectangle.y -= (n += GaussianBlurRed8Bit.surroundPixels(d10, renderingHints));
        rectangle.width += 2 * n2;
        rectangle.height += 2 * n;
        try {
            object = affineTransform2.createInverse();
            rectangle2D = ((AffineTransform)object).createTransformedShape(rectangle).getBounds2D();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            rectangle2D = shape.getBounds2D();
            rectangle2D = new Rectangle2D.Double(rectangle2D.getX() - (double)n2 / d7, rectangle2D.getY() - (double)n / d8, rectangle2D.getWidth() + (double)(2 * n2) / d7, rectangle2D.getHeight() + (double)(2 * n) / d8);
        }
        object = this.getSource().createRendering(new RenderContext(affineTransform2, rectangle2D, renderingHints));
        if (object == null) {
            return null;
        }
        CachableRed cachableRed = this.convertSourceCS((RenderedImage)object);
        if (!rectangle.equals(cachableRed.getBounds())) {
            cachableRed = new PadRed(cachableRed, rectangle, PadMode.ZERO_PAD, renderingHints);
        }
        cachableRed = new GaussianBlurRed8Bit(cachableRed, d9, d10, renderingHints);
        if (affineTransform != null && !affineTransform.isIdentity()) {
            cachableRed = new AffineRed(cachableRed, affineTransform, renderingHints);
        }
        return cachableRed;
    }

    @Override
    public Shape getDependencyRegion(int n, Rectangle2D rectangle2D) {
        if (n != 0) {
            rectangle2D = null;
        } else {
            Rectangle2D rectangle2D2;
            float f = (float)(this.stdDeviationX * DSQRT2PI);
            float f2 = (float)(this.stdDeviationY * DSQRT2PI);
            float f3 = 3.0f * f / 2.0f;
            float f4 = 3.0f * f2 / 2.0f;
            if (!(rectangle2D = new Rectangle2D.Float((float)(rectangle2D.getMinX() - (double)f3), (float)(rectangle2D.getMinY() - (double)f4), (float)(rectangle2D.getWidth() + (double)(2.0f * f3)), (float)(rectangle2D.getHeight() + (double)(2.0f * f4)))).intersects(rectangle2D2 = this.getBounds2D())) {
                return new Rectangle2D.Float();
            }
            rectangle2D = rectangle2D.createIntersection(rectangle2D2);
        }
        return rectangle2D;
    }

    @Override
    public Shape getDirtyRegion(int n, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = null;
        if (n == 0) {
            Rectangle2D rectangle2D3;
            float f = (float)(this.stdDeviationX * DSQRT2PI);
            float f2 = (float)(this.stdDeviationY * DSQRT2PI);
            float f3 = 3.0f * f / 2.0f;
            float f4 = 3.0f * f2 / 2.0f;
            if (!(rectangle2D = new Rectangle2D.Float((float)(rectangle2D.getMinX() - (double)f3), (float)(rectangle2D.getMinY() - (double)f4), (float)(rectangle2D.getWidth() + (double)(2.0f * f3)), (float)(rectangle2D.getHeight() + (double)(2.0f * f4)))).intersects(rectangle2D3 = this.getBounds2D())) {
                return new Rectangle2D.Float();
            }
            rectangle2D2 = rectangle2D.createIntersection(rectangle2D3);
        }
        return rectangle2D2;
    }
}

