/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import java.util.Locale;

public final class ColorHelper {
    private ColorHelper() {
    }

    public static Color html2color(String string) {
        if (!string.isEmpty() && string.charAt(0) == '#') {
            string = string.substring(1);
        }
        if (string.length() == 3) {
            return ColorHelper.html2color(new String(new char[]{string.charAt(0), string.charAt(0), string.charAt(1), string.charAt(1), string.charAt(2), string.charAt(2)}));
        }
        if (string.length() != 6 && string.length() != 8) {
            return null;
        }
        try {
            return new Color(Integer.parseInt(string.substring(0, 2), 16), Integer.parseInt(string.substring(2, 4), 16), Integer.parseInt(string.substring(4, 6), 16), string.length() == 8 ? Integer.parseInt(string.substring(6, 8), 16) : 255);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static String int2hex(int n) {
        String string = Integer.toHexString(n / 16) + Integer.toHexString(n % 16);
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static String color2html(Color color) {
        return ColorHelper.color2html(color, true);
    }

    public static String color2html(Color color, boolean bl) {
        int n;
        if (color == null) {
            return null;
        }
        String string = '#' + ColorHelper.int2hex(color.getRed()) + ColorHelper.int2hex(color.getGreen()) + ColorHelper.int2hex(color.getBlue());
        if (bl && (n = color.getAlpha()) < 255) {
            string = string + ColorHelper.int2hex(n);
        }
        return string;
    }

    public static Color getForegroundColor(Color color) {
        return color == null ? null : ((double)color.getRed() * 0.299 + (double)color.getGreen() * 0.587 + (double)color.getBlue() * 0.114 > 186.0 ? Color.BLACK : Color.WHITE);
    }
}

