/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.util;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.IterableCode;
import com.github.mustachejava.codes.NotIterableCode;
import com.github.mustachejava.codes.ValueCode;
import java.io.Writer;

public class CapturingMustacheVisitor
extends DefaultMustacheVisitor {
    private final Captured captured;

    public CapturingMustacheVisitor(DefaultMustacheFactory cf, Captured captured) {
        super(cf);
        this.captured = captured;
    }

    @Override
    public void value(TemplateContext tc, String variable, boolean encoded) {
        this.list.add(new ValueCode(tc, this.df, variable, encoded){

            @Override
            public Object get(Object[] scopes) {
                Object o = super.get(scopes);
                if (o != null) {
                    CapturingMustacheVisitor.this.captured.value(this.name, o.toString());
                }
                return o;
            }
        });
    }

    @Override
    public void iterable(TemplateContext tc, String variable, Mustache mustache) {
        this.list.add(new IterableCode(tc, this.df, mustache, variable){

            @Override
            public Writer execute(Writer writer, Object[] scopes) {
                Writer execute = super.execute(writer, scopes);
                CapturingMustacheVisitor.this.captured.arrayEnd();
                return execute;
            }

            @Override
            public Writer next(Writer writer, Object next, Object ... scopes) {
                CapturingMustacheVisitor.this.captured.objectStart();
                Writer nextObject = super.next(writer, next, scopes);
                CapturingMustacheVisitor.this.captured.objectEnd();
                return nextObject;
            }

            @Override
            public Object get(Object[] scopes) {
                Object o = super.get(scopes);
                CapturingMustacheVisitor.this.captured.arrayStart(this.name);
                return o;
            }
        });
    }

    @Override
    public void notIterable(TemplateContext tc, String variable, Mustache mustache) {
        this.list.add(new NotIterableCode(tc, this.df, mustache, variable){
            boolean called;

            @Override
            public Object get(Object[] scopes) {
                return super.get(scopes);
            }

            @Override
            public Writer next(Writer writer, Object object, Object[] scopes) {
                this.called = true;
                return super.next(writer, object, scopes);
            }

            @Override
            public Writer execute(Writer writer, Object[] scopes) {
                Writer execute = super.execute(writer, scopes);
                if (this.called) {
                    CapturingMustacheVisitor.this.captured.arrayStart(this.name);
                    CapturingMustacheVisitor.this.captured.arrayEnd();
                }
                return execute;
            }
        });
    }

    public static interface Captured {
        public void value(String var1, String var2);

        public void arrayStart(String var1);

        public void arrayEnd();

        public void objectStart();

        public void objectEnd();
    }
}

