/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.ChiSquare;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.GND;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.JLHScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.MutualInformation;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.PercentageScore;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.ScriptHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;

public class SignificanceHeuristicStreams {
    private static Map<String, Stream> STREAMS = Collections.EMPTY_MAP;

    public static SignificanceHeuristic read(StreamInput in) throws IOException {
        return SignificanceHeuristicStreams.stream(in.readString()).readResult(in);
    }

    public static synchronized void registerStream(Stream stream) {
        if (STREAMS.containsKey(stream.getName())) {
            throw new IllegalArgumentException("Can't register stream with name [" + stream.getName() + "] more than once");
        }
        HashMap<String, Stream> map = new HashMap<String, Stream>();
        map.putAll(STREAMS);
        map.put(stream.getName(), stream);
        STREAMS = Collections.unmodifiableMap(map);
    }

    private static synchronized Stream stream(String name) {
        return STREAMS.get(name);
    }

    static {
        HashMap<String, Stream> map = new HashMap<String, Stream>();
        map.put(JLHScore.STREAM.getName(), JLHScore.STREAM);
        map.put(PercentageScore.STREAM.getName(), PercentageScore.STREAM);
        map.put(MutualInformation.STREAM.getName(), MutualInformation.STREAM);
        map.put(GND.STREAM.getName(), GND.STREAM);
        map.put(ChiSquare.STREAM.getName(), ChiSquare.STREAM);
        map.put(ScriptHeuristic.STREAM.getName(), ScriptHeuristic.STREAM);
        STREAMS = Collections.unmodifiableMap(map);
    }

    public static interface Stream {
        public SignificanceHeuristic readResult(StreamInput var1) throws IOException;

        public String getName();
    }
}

