/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.color.NamedProfileCache;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGColorProfileElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    public NamedProfileCache cache = new NamedProfileCache();

    public String getLocalName() {
        return "color-profile";
    }

    public ICCColorSpaceExt createICCColorSpaceExt(BridgeContext ctx, Element paintedElement, String iccProfileName) {
        ICCColorSpaceExt cs = this.cache.request(iccProfileName.toLowerCase());
        if (cs != null) {
            return cs;
        }
        Document doc = paintedElement.getOwnerDocument();
        NodeList list = doc.getElementsByTagNameNS("http://www.w3.org/2000/svg", "color-profile");
        int n = list.getLength();
        Element profile = null;
        int i = 0;
        while (i < n) {
            Element profileNode;
            String nameAttr;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && iccProfileName.equalsIgnoreCase(nameAttr = (profileNode = (Element)node).getAttributeNS(null, "name"))) {
                profile = profileNode;
            }
            ++i;
        }
        if (profile == null) {
            return null;
        }
        String href = XLinkSupport.getXLinkHref(profile);
        ICC_Profile p = null;
        if (href != null) {
            ParsedURL purl;
            String baseURI = ((AbstractNode)profile).getBaseURI();
            ParsedURL pDocURL = null;
            if (baseURI != null) {
                pDocURL = new ParsedURL(baseURI);
            }
            if (!(purl = new ParsedURL(pDocURL, href)).complete()) {
                throw new BridgeException(ctx, paintedElement, "uri.malformed", new Object[]{href});
            }
            try {
                ctx.getUserAgent().checkLoadExternalResource(purl, pDocURL);
                p = ICC_Profile.getInstance(purl.openStream());
            }
            catch (IOException ioEx) {
                throw new BridgeException(ctx, paintedElement, ioEx, "uri.io", new Object[]{href});
            }
            catch (SecurityException secEx) {
                throw new BridgeException(ctx, paintedElement, secEx, "uri.unsecure", new Object[]{href});
            }
        }
        if (p == null) {
            return null;
        }
        int intent = SVGColorProfileElementBridge.convertIntent(profile, ctx);
        cs = new ICCColorSpaceExt(p, intent);
        this.cache.put(iccProfileName.toLowerCase(), cs);
        return cs;
    }

    private static int convertIntent(Element profile, BridgeContext ctx) {
        String intent = profile.getAttributeNS(null, "rendering-intent");
        if (intent.length() == 0) {
            return 4;
        }
        if ("perceptual".equals(intent)) {
            return 0;
        }
        if ("auto".equals(intent)) {
            return 4;
        }
        if ("relative-colorimetric".equals(intent)) {
            return 1;
        }
        if ("absolute-colorimetric".equals(intent)) {
            return 2;
        }
        if ("saturation".equals(intent)) {
            return 3;
        }
        throw new BridgeException(ctx, profile, "attribute.malformed", new Object[]{"rendering-intent", intent});
    }
}

