/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Glyphs;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFCmapEntry;
import org.apache.fop.fonts.truetype.TTFDirTabEntry;
import org.apache.fop.fonts.truetype.TTFMtxEntry;

public class TTFFile {
    static final byte NTABS = 24;
    static final int NMACGLYPHS = 258;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    public static final boolean TRACE_ENABLED = false;
    private String encoding = "WinAnsiEncoding";
    private short firstChar = 0;
    private boolean isEmbeddable = true;
    private boolean hasSerifs = true;
    protected Map dirTabs;
    private Map kerningTab;
    private Map ansiKerningTab;
    private List cmaps;
    private List unicodeMapping;
    private int upem;
    private int nhmtx;
    private int postFormat;
    private int locaFormat;
    protected long lastLoca = 0L;
    private int numberOfGlyphs;
    private int nmGlyphs;
    protected TTFMtxEntry[] mtxTab;
    private int[] mtxEncoded = null;
    private String fontName = "";
    private String fullName = "";
    private String notice = "";
    private String familyName = "";
    private String subFamilyName = "";
    private long italicAngle = 0L;
    private long isFixedPitch = 0L;
    private int fontBBox1 = 0;
    private int fontBBox2 = 0;
    private int fontBBox3 = 0;
    private int fontBBox4 = 0;
    private int capHeight = 0;
    private int os2CapHeight = 0;
    private int underlinePosition = 0;
    private int underlineThickness = 0;
    private int xHeight = 0;
    private int os2xHeight = 0;
    private int ascender = 0;
    private int descender = 0;
    private int hheaAscender = 0;
    private int hheaDescender = 0;
    private int os2Ascender = 0;
    private int os2Descender = 0;
    private short lastChar = 0;
    private int[] ansiWidth;
    private Map ansiIndex;
    private Map glyphToUnicodeMap = new HashMap();
    private Map unicodeToGlyphMap = new HashMap();
    private TTFDirTabEntry currentDirTab;
    private boolean isCFF;
    protected Log log = LogFactory.getLog(class$org$apache$fop$fonts$truetype$TTFFile == null ? (class$org$apache$fop$fonts$truetype$TTFFile = TTFFile.class$("org.apache.fop.fonts.truetype.TTFFile")) : class$org$apache$fop$fonts$truetype$TTFFile);
    static /* synthetic */ Class class$org$apache$fop$fonts$truetype$TTFFile;

    boolean seekTab(FontFileReader in, String name, long offset) throws IOException {
        TTFDirTabEntry dt = (TTFDirTabEntry)this.dirTabs.get(name);
        if (dt == null) {
            this.log.error("Dirtab " + name + " not found.");
            return false;
        }
        in.seekSet(dt.getOffset() + offset);
        this.currentDirTab = dt;
        return true;
    }

    public int convertTTFUnit2PDFUnit(int n) {
        int ret;
        if (n < 0) {
            long rest1 = n % this.upem;
            long storrest = 1000L * rest1;
            long ledd2 = storrest != 0L ? rest1 / storrest : 0L;
            ret = -(-1000 * n / this.upem - (int)ledd2);
        } else {
            ret = n / this.upem * 1000 + n % this.upem * 1000 / this.upem;
        }
        return ret;
    }

    private boolean readCMAP(FontFileReader in) throws IOException {
        this.unicodeMapping = new ArrayList();
        int mtxPtr = 0;
        this.seekTab(in, "cmap", 2L);
        int numCMap = in.readTTFUShort();
        long cmapUniOffset = 0L;
        if (this.log.isDebugEnabled()) {
            this.log.debug(numCMap + " cmap tables");
        }
        int i = 0;
        while (i < numCMap) {
            int cmapPID = in.readTTFUShort();
            int cmapEID = in.readTTFUShort();
            long cmapOffset = in.readTTFULong();
            this.log.debug("Platform ID: " + cmapPID + " Encoding: " + cmapEID);
            if (cmapPID == 3 && cmapEID == 1) {
                cmapUniOffset = cmapOffset;
            }
            ++i;
        }
        if (cmapUniOffset <= 0L) {
            this.log.fatal("Unicode cmap table not present");
            this.log.fatal("Unsupported format: Aborting");
            return false;
        }
        this.seekTab(in, "cmap", cmapUniOffset);
        int cmapFormat = in.readTTFUShort();
        in.readTTFUShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug("CMAP format: " + cmapFormat);
        }
        if (cmapFormat == 4) {
            in.skip(2L);
            int cmapSegCountX2 = in.readTTFUShort();
            int cmapSearchRange = in.readTTFUShort();
            int cmapEntrySelector = in.readTTFUShort();
            int cmapRangeShift = in.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug("segCountX2   : " + cmapSegCountX2);
                this.log.debug("searchRange  : " + cmapSearchRange);
                this.log.debug("entrySelector: " + cmapEntrySelector);
                this.log.debug("rangeShift   : " + cmapRangeShift);
            }
            int[] cmapEndCounts = new int[cmapSegCountX2 / 2];
            int[] cmapStartCounts = new int[cmapSegCountX2 / 2];
            int[] cmapDeltas = new int[cmapSegCountX2 / 2];
            int[] cmapRangeOffsets = new int[cmapSegCountX2 / 2];
            int i2 = 0;
            while (i2 < cmapSegCountX2 / 2) {
                cmapEndCounts[i2] = in.readTTFUShort();
                ++i2;
            }
            in.skip(2L);
            int i3 = 0;
            while (i3 < cmapSegCountX2 / 2) {
                cmapStartCounts[i3] = in.readTTFUShort();
                ++i3;
            }
            int i4 = 0;
            while (i4 < cmapSegCountX2 / 2) {
                cmapDeltas[i4] = in.readTTFShort();
                ++i4;
            }
            int i5 = 0;
            while (i5 < cmapSegCountX2 / 2) {
                cmapRangeOffsets[i5] = in.readTTFUShort();
                ++i5;
            }
            int glyphIdArrayOffset = in.getCurrentPos();
            int i6 = 0;
            while (i6 < cmapStartCounts.length) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace(i6 + ": " + cmapStartCounts[i6] + " - " + cmapEndCounts[i6]);
                }
                int j = cmapStartCounts[i6];
                while (j <= cmapEndCounts[i6]) {
                    if (j < 256 && j > this.lastChar) {
                        this.lastChar = (short)j;
                    }
                    if (mtxPtr < this.mtxTab.length) {
                        int glyphIdx;
                        if (cmapRangeOffsets[i6] != 0 && j != 65535) {
                            int glyphOffset = glyphIdArrayOffset + (cmapRangeOffsets[i6] / 2 + (j - cmapStartCounts[i6]) + i6 - cmapSegCountX2 / 2) * 2;
                            in.seekSet(glyphOffset);
                            glyphIdx = in.readTTFUShort() + cmapDeltas[i6] & 0xFFFF;
                            this.unicodeMapping.add(new UnicodeMapping(glyphIdx, j));
                            this.mtxTab[glyphIdx].getUnicodeIndex().add(new Integer(j));
                            List v = (List)this.ansiIndex.get(new Integer(j));
                            if (v != null) {
                                ListIterator e = v.listIterator();
                                while (e.hasNext()) {
                                    Integer aIdx = (Integer)e.next();
                                    this.ansiWidth[aIdx.intValue()] = this.mtxTab[glyphIdx].getWx();
                                    if (!this.log.isTraceEnabled()) continue;
                                    this.log.trace("Added width " + this.mtxTab[glyphIdx].getWx() + " uni: " + j + " ansi: " + aIdx);
                                }
                            }
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Idx: " + glyphIdx + " Delta: " + cmapDeltas[i6] + " Unicode: " + j + " name: " + this.mtxTab[glyphIdx].getName());
                            }
                        } else {
                            glyphIdx = j + cmapDeltas[i6] & 0xFFFF;
                            if (glyphIdx < this.mtxTab.length) {
                                this.mtxTab[glyphIdx].getUnicodeIndex().add(new Integer(j));
                            } else {
                                this.log.debug("Glyph " + glyphIdx + " out of range: " + this.mtxTab.length);
                            }
                            this.unicodeMapping.add(new UnicodeMapping(glyphIdx, j));
                            if (glyphIdx < this.mtxTab.length) {
                                this.mtxTab[glyphIdx].getUnicodeIndex().add(new Integer(j));
                            } else {
                                this.log.debug("Glyph " + glyphIdx + " out of range: " + this.mtxTab.length);
                            }
                            List v = (List)this.ansiIndex.get(new Integer(j));
                            if (v != null) {
                                ListIterator e = v.listIterator();
                                while (e.hasNext()) {
                                    Integer aIdx = (Integer)e.next();
                                    this.ansiWidth[aIdx.intValue()] = this.mtxTab[glyphIdx].getWx();
                                }
                            }
                        }
                        if (glyphIdx < this.mtxTab.length && this.mtxTab[glyphIdx].getUnicodeIndex().size() < 2) {
                            ++mtxPtr;
                        }
                    }
                    ++j;
                }
                ++i6;
            }
        }
        return true;
    }

    private void printMaxMin() {
        int min = 255;
        int max = 0;
        int i = 0;
        while (i < this.mtxTab.length) {
            if (this.mtxTab[i].getIndex() < min) {
                min = this.mtxTab[i].getIndex();
            }
            if (this.mtxTab[i].getIndex() > max) {
                max = this.mtxTab[i].getIndex();
            }
            ++i;
        }
        this.log.info("Min: " + min);
        this.log.info("Max: " + max);
    }

    public void readFont(FontFileReader in) throws IOException {
        this.readFont(in, null);
    }

    private void initAnsiWidths() {
        this.ansiWidth = new int[256];
        int i = 0;
        while (i < 256) {
            this.ansiWidth[i] = this.mtxTab[0].getWx();
            ++i;
        }
        this.ansiIndex = new HashMap();
        int i2 = 32;
        while (i2 < Glyphs.WINANSI_ENCODING.length) {
            Integer ansi = new Integer(i2);
            Integer uni = new Integer(Glyphs.WINANSI_ENCODING[i2]);
            ArrayList<Integer> v = (ArrayList<Integer>)this.ansiIndex.get(uni);
            if (v == null) {
                v = new ArrayList<Integer>();
                this.ansiIndex.put(uni, v);
            }
            v.add(ansi);
            ++i2;
        }
    }

    public boolean readFont(FontFileReader in, String name) throws IOException {
        if (!this.checkTTC(in, name)) {
            if (name == null) {
                throw new IllegalArgumentException("For TrueType collection you must specify which font to select (-ttcname)");
            }
            throw new IOException("Name does not exist in the TrueType collection: " + name);
        }
        this.readDirTabs(in);
        this.readFontHeader(in);
        this.getNumGlyphs(in);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Number of glyphs in font: " + this.numberOfGlyphs);
        }
        this.readHorizontalHeader(in);
        this.readHorizontalMetrics(in);
        this.initAnsiWidths();
        this.readPostScript(in);
        this.readOS2(in);
        this.determineAscDesc();
        if (!this.isCFF) {
            this.readIndexToLocation(in);
            this.readGlyf(in);
        }
        this.readName(in);
        boolean pcltFound = this.readPCLT(in);
        boolean valid = this.readCMAP(in);
        if (!valid) {
            return false;
        }
        this.createCMaps();
        this.readKerning(in);
        this.guessVerticalMetricsFromGlyphBBox();
        return true;
    }

    private void createCMaps() {
        UnicodeMapping um;
        this.cmaps = new ArrayList();
        TTFCmapEntry tce = new TTFCmapEntry();
        ListIterator e = this.unicodeMapping.listIterator();
        UnicodeMapping lastMapping = um = (UnicodeMapping)e.next();
        tce.setUnicodeStart(um.getUnicodeIndex());
        tce.setGlyphStartIndex(um.getGlyphIndex());
        while (e.hasNext()) {
            um = (UnicodeMapping)e.next();
            if (lastMapping.getUnicodeIndex() + 1 != um.getUnicodeIndex() || lastMapping.getGlyphIndex() + 1 != um.getGlyphIndex()) {
                tce.setUnicodeEnd(lastMapping.getUnicodeIndex());
                this.cmaps.add(tce);
                tce = new TTFCmapEntry();
                tce.setUnicodeStart(um.getUnicodeIndex());
                tce.setGlyphStartIndex(um.getGlyphIndex());
            }
            lastMapping = um;
        }
        tce.setUnicodeEnd(um.getUnicodeIndex());
        this.cmaps.add(tce);
    }

    public String getWindowsName() {
        return this.familyName + "," + this.subFamilyName;
    }

    public String getPostScriptName() {
        if ("Regular".equals(this.subFamilyName) || "Roman".equals(this.subFamilyName)) {
            return this.familyName;
        }
        return this.familyName + "," + this.subFamilyName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }

    public String getCharSetName() {
        return this.encoding;
    }

    public int getCapHeight() {
        return this.convertTTFUnit2PDFUnit(this.capHeight);
    }

    public int getXHeight() {
        return this.convertTTFUnit2PDFUnit(this.xHeight);
    }

    public int getFlags() {
        int flags = 32;
        if (this.italicAngle != 0L) {
            flags |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            flags |= 2;
        }
        if (this.hasSerifs) {
            flags |= 1;
        }
        return flags;
    }

    public String getStemV() {
        return "0";
    }

    public String getItalicAngle() {
        String ia = Short.toString((short)(this.italicAngle / 65536L));
        return ia;
    }

    public int[] getFontBBox() {
        int[] fbb = new int[]{this.convertTTFUnit2PDFUnit(this.fontBBox1), this.convertTTFUnit2PDFUnit(this.fontBBox2), this.convertTTFUnit2PDFUnit(this.fontBBox3), this.convertTTFUnit2PDFUnit(this.fontBBox4)};
        return fbb;
    }

    public int getLowerCaseAscent() {
        return this.convertTTFUnit2PDFUnit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.convertTTFUnit2PDFUnit(this.descender);
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public short getFirstChar() {
        return this.firstChar;
    }

    public int[] getWidths() {
        int[] wx = new int[this.mtxTab.length];
        int i = 0;
        while (i < wx.length) {
            wx[i] = this.convertTTFUnit2PDFUnit(this.mtxTab[i].getWx());
            ++i;
        }
        return wx;
    }

    public int getCharWidth(int idx) {
        return this.convertTTFUnit2PDFUnit(this.ansiWidth[idx]);
    }

    public Map getKerning() {
        return this.kerningTab;
    }

    public Map getAnsiKerning() {
        return this.ansiKerningTab;
    }

    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    public boolean isCFF() {
        return this.isCFF;
    }

    protected void readDirTabs(FontFileReader in) throws IOException {
        int sfntVersion = in.readTTFLong();
        switch (sfntVersion) {
            case 65536: {
                this.log.debug("sfnt version: OpenType 1.0");
                break;
            }
            case 0x4F54544F: {
                this.isCFF = true;
                this.log.debug("sfnt version: OpenType with CFF data");
                break;
            }
            case 1953658213: {
                this.log.debug("sfnt version: Apple TrueType");
                break;
            }
            case 1954115633: {
                this.log.debug("sfnt version: Apple Type 1 housed in sfnt wrapper");
                break;
            }
            default: {
                this.log.debug("Unknown sfnt version: " + Integer.toHexString(sfntVersion));
            }
        }
        int ntabs = in.readTTFUShort();
        in.skip(6L);
        this.dirTabs = new HashMap();
        TTFDirTabEntry[] pd = new TTFDirTabEntry[ntabs];
        this.log.debug("Reading " + ntabs + " dir tables");
        int i = 0;
        while (i < ntabs) {
            pd[i] = new TTFDirTabEntry();
            this.dirTabs.put(pd[i].read(in), pd[i]);
            ++i;
        }
        this.log.debug("dir tables: " + this.dirTabs.keySet());
    }

    protected void readFontHeader(FontFileReader in) throws IOException {
        this.seekTab(in, "head", 18L);
        this.upem = in.readTTFUShort();
        this.log.debug("unit per em: " + this.upem);
        in.skip(16L);
        this.fontBBox1 = in.readTTFShort();
        this.fontBBox2 = in.readTTFShort();
        this.fontBBox3 = in.readTTFShort();
        this.fontBBox4 = in.readTTFShort();
        in.skip(6L);
        this.locaFormat = in.readTTFShort();
    }

    protected void getNumGlyphs(FontFileReader in) throws IOException {
        this.seekTab(in, "maxp", 4L);
        this.numberOfGlyphs = in.readTTFUShort();
    }

    protected void readHorizontalHeader(FontFileReader in) throws IOException {
        this.seekTab(in, "hhea", 4L);
        this.hheaAscender = in.readTTFShort();
        this.log.debug("hhea.Ascender: " + this.hheaAscender + " " + this.convertTTFUnit2PDFUnit(this.hheaAscender));
        this.hheaDescender = in.readTTFShort();
        this.log.debug("hhea.Descender: " + this.hheaDescender + " " + this.convertTTFUnit2PDFUnit(this.hheaDescender));
        in.skip(26L);
        this.nhmtx = in.readTTFUShort();
        this.log.debug("Number of horizontal metrics: " + this.nhmtx);
    }

    protected void readHorizontalMetrics(FontFileReader in) throws IOException {
        this.seekTab(in, "hmtx", 0L);
        int mtxSize = Math.max(this.numberOfGlyphs, this.nhmtx);
        this.mtxTab = new TTFMtxEntry[mtxSize];
        int i = 0;
        while (i < mtxSize) {
            this.mtxTab[i] = new TTFMtxEntry();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.nhmtx) {
            this.mtxTab[i2].setWx(in.readTTFUShort());
            this.mtxTab[i2].setLsb(in.readTTFUShort());
            ++i2;
        }
        if (this.nhmtx < mtxSize) {
            int lastWidth = this.mtxTab[this.nhmtx - 1].getWx();
            int i3 = this.nhmtx;
            while (i3 < mtxSize) {
                this.mtxTab[i3].setWx(lastWidth);
                this.mtxTab[i3].setLsb(in.readTTFUShort());
                ++i3;
            }
        }
    }

    private final void readPostScript(FontFileReader in) throws IOException {
        this.seekTab(in, "post", 0L);
        this.postFormat = in.readTTFLong();
        this.italicAngle = in.readTTFULong();
        this.underlinePosition = in.readTTFShort();
        this.underlineThickness = in.readTTFShort();
        this.isFixedPitch = in.readTTFULong();
        in.skip(16L);
        this.log.debug("PostScript format: 0x" + Integer.toHexString(this.postFormat));
        switch (this.postFormat) {
            case 65536: {
                this.log.debug("PostScript format 1");
                int i = 0;
                while (i < Glyphs.MAC_GLYPH_NAMES.length) {
                    this.mtxTab[i].setName(Glyphs.MAC_GLYPH_NAMES[i]);
                    ++i;
                }
                break;
            }
            case 131072: {
                this.log.debug("PostScript format 2");
                int numGlyphStrings = 0;
                int l = in.readTTFUShort();
                int i = 0;
                while (i < l) {
                    this.mtxTab[i].setIndex(in.readTTFUShort());
                    if (this.mtxTab[i].getIndex() > 257) {
                        ++numGlyphStrings;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("PostScript index: " + this.mtxTab[i].getIndexAsString());
                    }
                    ++i;
                }
                String[] psGlyphsBuffer = new String[numGlyphStrings];
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Reading " + numGlyphStrings + " glyphnames, that are not in the standard Macintosh" + " set. Total number of glyphs=" + l);
                }
                int i2 = 0;
                while (i2 < psGlyphsBuffer.length) {
                    psGlyphsBuffer[i2] = in.readTTFString(in.readTTFUByte());
                    ++i2;
                }
                int i3 = 0;
                while (i3 < l) {
                    if (this.mtxTab[i3].getIndex() < 258) {
                        this.mtxTab[i3].setName(Glyphs.MAC_GLYPH_NAMES[this.mtxTab[i3].getIndex()]);
                    } else if (!this.mtxTab[i3].isIndexReserved()) {
                        int k = this.mtxTab[i3].getIndex() - 258;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(k + " i=" + i3 + " mtx=" + this.mtxTab.length + " ps=" + psGlyphsBuffer.length);
                        }
                        this.mtxTab[i3].setName(psGlyphsBuffer[k]);
                    }
                    ++i3;
                }
                break;
            }
            case 196608: {
                this.log.debug("PostScript format 3");
                break;
            }
            default: {
                this.log.error("Unknown PostScript format: " + this.postFormat);
            }
        }
    }

    private final void readOS2(FontFileReader in) throws IOException {
        if (this.dirTabs.get("OS/2") != null) {
            this.seekTab(in, "OS/2", 8L);
            int fsType = in.readTTFUShort();
            this.isEmbeddable = fsType != 2;
            in.skip(22L);
            in.skip(10L);
            in.skip(16L);
            in.skip(4L);
            in.skip(6L);
            this.os2Ascender = in.readTTFShort();
            this.log.debug("sTypoAscender: " + this.os2Ascender + " " + this.convertTTFUnit2PDFUnit(this.os2Ascender));
            this.os2Descender = in.readTTFShort();
            this.log.debug("sTypoDescender: " + this.os2Descender + " " + this.convertTTFUnit2PDFUnit(this.os2Descender));
            int v = in.readTTFShort();
            this.log.debug("sTypoLineGap: " + v);
            v = in.readTTFUShort();
            this.log.debug("usWinAscent: " + v + " " + this.convertTTFUnit2PDFUnit(v));
            v = in.readTTFUShort();
            this.log.debug("usWinDescent: " + v + " " + this.convertTTFUnit2PDFUnit(v));
            in.skip(8L);
            this.os2xHeight = in.readTTFShort();
            this.log.debug("sxHeight: " + this.os2xHeight);
            this.os2CapHeight = in.readTTFShort();
            this.log.debug("sCapHeight: " + this.os2CapHeight);
        } else {
            this.isEmbeddable = true;
        }
    }

    protected final void readIndexToLocation(FontFileReader in) throws IOException {
        if (!this.seekTab(in, "loca", 0L)) {
            throw new IOException("'loca' table not found, happens when the font file doesn't contain TrueType outlines (trying to read an OpenType CFF font maybe?)");
        }
        int i = 0;
        while (i < this.numberOfGlyphs) {
            this.mtxTab[i].setOffset(this.locaFormat == 1 ? in.readTTFULong() : (long)(in.readTTFUShort() << 1));
            ++i;
        }
        this.lastLoca = this.locaFormat == 1 ? in.readTTFULong() : (long)(in.readTTFUShort() << 1);
    }

    private final void readGlyf(FontFileReader in) throws IOException {
        TTFDirTabEntry dirTab = (TTFDirTabEntry)this.dirTabs.get("glyf");
        if (dirTab == null) {
            throw new IOException("glyf table not found, cannot continue");
        }
        int i = 0;
        while (i < this.numberOfGlyphs - 1) {
            if (this.mtxTab[i].getOffset() != this.mtxTab[i + 1].getOffset()) {
                in.seekSet(dirTab.getOffset() + this.mtxTab[i].getOffset());
                in.skip(2L);
                int[] bbox = new int[]{in.readTTFShort(), in.readTTFShort(), in.readTTFShort(), in.readTTFShort()};
                this.mtxTab[i].setBoundingBox(bbox);
            } else {
                this.mtxTab[i].setBoundingBox(this.mtxTab[0].getBoundingBox());
            }
            ++i;
        }
        long n = ((TTFDirTabEntry)this.dirTabs.get("glyf")).getOffset();
        int i2 = 0;
        while (i2 < this.numberOfGlyphs) {
            if (i2 + 1 >= this.mtxTab.length || this.mtxTab[i2].getOffset() != this.mtxTab[i2 + 1].getOffset()) {
                in.seekSet(n + this.mtxTab[i2].getOffset());
                in.skip(2L);
                int[] bbox = new int[]{in.readTTFShort(), in.readTTFShort(), in.readTTFShort(), in.readTTFShort()};
                this.mtxTab[i2].setBoundingBox(bbox);
            } else {
                int bbox0 = this.mtxTab[0].getBoundingBox()[0];
                int[] bbox = new int[]{bbox0, bbox0, bbox0, bbox0};
                this.mtxTab[i2].setBoundingBox(bbox);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.mtxTab[i2].toString(this));
            }
            ++i2;
        }
    }

    private final void readName(FontFileReader in) throws IOException {
        this.seekTab(in, "name", 2L);
        int i = in.getCurrentPos();
        int n = in.readTTFUShort();
        int j = in.readTTFUShort() + i - 2;
        i += 4;
        while (n-- > 0) {
            in.seekSet(i);
            int platformID = in.readTTFUShort();
            int encodingID = in.readTTFUShort();
            int languageID = in.readTTFUShort();
            int k = in.readTTFUShort();
            int l = in.readTTFUShort();
            if (!(platformID != 1 && platformID != 3 || encodingID != 0 && encodingID != 1 || k != 1 && k != 2 && k != 0 && k != 4 && k != 6)) {
                in.seekSet(j + in.readTTFUShort());
                String txt = in.readTTFString(l);
                this.log.debug(platformID + " " + encodingID + " " + languageID + " " + k + " " + txt);
                switch (k) {
                    case 0: {
                        this.notice = txt;
                        break;
                    }
                    case 1: {
                        this.familyName = txt;
                        break;
                    }
                    case 2: {
                        this.subFamilyName = txt;
                        break;
                    }
                    case 4: {
                        this.fullName = txt;
                        break;
                    }
                    case 6: {
                        this.fontName = txt;
                    }
                }
                if (!this.notice.equals("") && !this.fullName.equals("") && !this.fontName.equals("") && !this.familyName.equals("") && !this.subFamilyName.equals("")) break;
            }
            i += 12;
        }
    }

    private final boolean readPCLT(FontFileReader in) throws IOException {
        TTFDirTabEntry dirTab = (TTFDirTabEntry)this.dirTabs.get("PCLT");
        if (dirTab != null) {
            in.seekSet(dirTab.getOffset() + 4L + 4L + 2L);
            this.xHeight = in.readTTFUShort();
            this.log.debug("xHeight from PCLT: " + this.xHeight + " " + this.convertTTFUnit2PDFUnit(this.xHeight));
            in.skip(4L);
            this.capHeight = in.readTTFUShort();
            this.log.debug("capHeight from PCLT: " + this.capHeight + " " + this.convertTTFUnit2PDFUnit(this.capHeight));
            in.skip(34L);
            int serifStyle = in.readTTFUByte();
            serifStyle >>= 6;
            this.hasSerifs = (serifStyle &= 3) != 1;
            return true;
        }
        return false;
    }

    private void determineAscDesc() {
        int hheaBoxHeight = this.hheaAscender - this.hheaDescender;
        int os2BoxHeight = this.os2Ascender - this.os2Descender;
        if (this.os2Ascender > 0 && os2BoxHeight <= this.upem) {
            this.ascender = this.os2Ascender;
            this.descender = this.os2Descender;
        } else if (this.hheaAscender > 0 && hheaBoxHeight <= this.upem) {
            this.ascender = this.hheaAscender;
            this.descender = this.hheaDescender;
        } else if (this.os2Ascender > 0) {
            this.ascender = this.os2Ascender;
            this.descender = this.os2Descender;
        } else {
            this.ascender = this.hheaAscender;
            this.descender = this.hheaDescender;
        }
        this.log.debug("Font box height: " + (this.ascender - this.descender));
        if (this.ascender - this.descender > this.upem) {
            this.log.warn("Ascender and descender together are larger than the em box. This could lead to a wrong baseline placement in Apache FOP.");
        }
    }

    private void guessVerticalMetricsFromGlyphBBox() {
        int localCapHeight = 0;
        int localXHeight = 0;
        int localAscender = 0;
        int localDescender = 0;
        int i = 0;
        while (i < this.mtxTab.length) {
            if ("H".equals(this.mtxTab[i].getName())) {
                localCapHeight = this.mtxTab[i].getBoundingBox()[3];
            } else if ("x".equals(this.mtxTab[i].getName())) {
                localXHeight = this.mtxTab[i].getBoundingBox()[3];
            } else if ("d".equals(this.mtxTab[i].getName())) {
                localAscender = this.mtxTab[i].getBoundingBox()[3];
            } else if ("p".equals(this.mtxTab[i].getName())) {
                localDescender = this.mtxTab[i].getBoundingBox()[1];
            } else {
                List unicodeIndex = this.mtxTab[i].getUnicodeIndex();
                if (unicodeIndex.size() > 0) {
                    char ch = (char)((Integer)unicodeIndex.get(0)).intValue();
                    if (ch == 'H') {
                        localCapHeight = this.mtxTab[i].getBoundingBox()[3];
                    } else if (ch == 'x') {
                        localXHeight = this.mtxTab[i].getBoundingBox()[3];
                    } else if (ch == 'd') {
                        localAscender = this.mtxTab[i].getBoundingBox()[3];
                    } else if (ch == 'p') {
                        localDescender = this.mtxTab[i].getBoundingBox()[1];
                    }
                }
            }
            ++i;
        }
        this.log.debug("Ascender from glyph 'd': " + localAscender + " " + this.convertTTFUnit2PDFUnit(localAscender));
        this.log.debug("Descender from glyph 'p': " + localDescender + " " + this.convertTTFUnit2PDFUnit(localDescender));
        if (this.ascender - this.descender > this.upem) {
            this.log.debug("Replacing specified ascender/descender with derived values to get values which fit in the em box.");
            this.ascender = localAscender;
            this.descender = localDescender;
        }
        this.log.debug("xHeight from glyph 'x': " + localXHeight + " " + this.convertTTFUnit2PDFUnit(localXHeight));
        this.log.debug("CapHeight from glyph 'H': " + localCapHeight + " " + this.convertTTFUnit2PDFUnit(localCapHeight));
        if (this.capHeight == 0) {
            this.capHeight = localCapHeight;
            if (this.capHeight == 0) {
                this.capHeight = this.os2CapHeight;
            }
            if (this.capHeight == 0) {
                this.log.warn("capHeight value could not be determined. The font may not work as expected.");
            }
        }
        if (this.xHeight == 0) {
            this.xHeight = localXHeight;
            if (this.xHeight == 0) {
                this.xHeight = this.os2xHeight;
            }
            if (this.xHeight == 0) {
                this.log.warn("xHeight value could not be determined. The font may not work as expected.");
            }
        }
    }

    private final void readKerning(FontFileReader in) throws IOException {
        this.kerningTab = new HashMap();
        this.ansiKerningTab = new HashMap();
        TTFDirTabEntry dirTab = (TTFDirTabEntry)this.dirTabs.get("kern");
        if (dirTab != null) {
            this.seekTab(in, "kern", 2L);
            int n = in.readTTFUShort();
            while (n > 0) {
                in.skip(4L);
                int k = in.readTTFUShort();
                if ((k & 1) == 0 || (k & 2) != 0 || (k & 4) != 0) {
                    return;
                }
                if (k >> 8 == 0) {
                    k = in.readTTFUShort();
                    in.skip(6L);
                    while (k-- > 0) {
                        int i = in.readTTFUShort();
                        int j = in.readTTFUShort();
                        short kpx = in.readTTFShort();
                        if (kpx == 0) continue;
                        Integer iObj = this.glyphToUnicode(i);
                        Integer u2 = this.glyphToUnicode(j);
                        if (iObj == null) {
                            this.log.warn("Unicode index (1) not found for glyph " + i);
                            continue;
                        }
                        if (u2 == null) {
                            this.log.warn("Unicode index (2) not found for glyph " + i);
                            continue;
                        }
                        HashMap<Integer, Integer> adjTab = (HashMap<Integer, Integer>)this.kerningTab.get(iObj);
                        if (adjTab == null) {
                            adjTab = new HashMap<Integer, Integer>();
                        }
                        adjTab.put(u2, new Integer(this.convertTTFUnit2PDFUnit(kpx)));
                        this.kerningTab.put(iObj, adjTab);
                    }
                }
                --n;
            }
            Iterator ae = this.kerningTab.keySet().iterator();
            while (ae.hasNext()) {
                Integer unicodeKey1 = (Integer)ae.next();
                Integer cidKey1 = this.unicodeToGlyph(unicodeKey1);
                HashMap<Integer, Integer> akpx = new HashMap<Integer, Integer>();
                Map ckpx = (Map)this.kerningTab.get(unicodeKey1);
                Iterator aee = ckpx.keySet().iterator();
                while (aee.hasNext()) {
                    Integer unicodeKey2 = (Integer)aee.next();
                    Integer cidKey2 = this.unicodeToGlyph(unicodeKey2);
                    Integer kern = (Integer)ckpx.get(unicodeKey2);
                    ListIterator uniMap = this.mtxTab[cidKey2].getUnicodeIndex().listIterator();
                    while (uniMap.hasNext()) {
                        Integer unicodeKey = (Integer)uniMap.next();
                        Integer[] ansiKeys = this.unicodeToWinAnsi(unicodeKey);
                        int u = 0;
                        while (u < ansiKeys.length) {
                            akpx.put(ansiKeys[u], kern);
                            ++u;
                        }
                    }
                }
                if (akpx.size() <= 0) continue;
                ListIterator uniMap = this.mtxTab[cidKey1].getUnicodeIndex().listIterator();
                while (uniMap.hasNext()) {
                    Integer unicodeKey = (Integer)uniMap.next();
                    Integer[] ansiKeys = this.unicodeToWinAnsi(unicodeKey);
                    int u = 0;
                    while (u < ansiKeys.length) {
                        this.ansiKerningTab.put(ansiKeys[u], akpx);
                        ++u;
                    }
                }
            }
        }
    }

    public List getCMaps() {
        return this.cmaps;
    }

    protected final boolean checkTTC(FontFileReader in, String name) throws IOException {
        String tag = in.readTTFString(4);
        if ("ttcf".equals(tag)) {
            in.skip(4L);
            int numDirectories = (int)in.readTTFULong();
            long[] dirOffsets = new long[numDirectories];
            int i = 0;
            while (i < numDirectories) {
                dirOffsets[i] = in.readTTFULong();
                ++i;
            }
            this.log.info("This is a TrueType collection file with " + numDirectories + " fonts");
            this.log.info("Containing the following fonts: ");
            boolean found = false;
            long dirTabOffset = 0L;
            int i2 = 0;
            while (i2 < numDirectories) {
                in.seekSet(dirOffsets[i2]);
                this.readDirTabs(in);
                this.readName(in);
                if (this.fullName.equals(name)) {
                    found = true;
                    dirTabOffset = dirOffsets[i2];
                    this.log.info(this.fullName + " <-- selected");
                } else {
                    this.log.info(this.fullName);
                }
                this.notice = "";
                this.fullName = "";
                this.familyName = "";
                this.fontName = "";
                this.subFamilyName = "";
                ++i2;
            }
            in.seekSet(dirTabOffset);
            return found;
        }
        in.seekSet(0L);
        return true;
    }

    private Integer[] unicodeToWinAnsi(int unicode) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int i = 32;
        while (i < Glyphs.WINANSI_ENCODING.length) {
            if (unicode == Glyphs.WINANSI_ENCODING[i]) {
                ret.add(new Integer(i));
            }
            ++i;
        }
        return ret.toArray(new Integer[0]);
    }

    public void printStuff() {
        System.out.println("Font name:   " + this.fontName);
        System.out.println("Full name:   " + this.fullName);
        System.out.println("Family name: " + this.familyName);
        System.out.println("Subfamily name: " + this.subFamilyName);
        System.out.println("Notice:      " + this.notice);
        System.out.println("xHeight:     " + this.convertTTFUnit2PDFUnit(this.xHeight));
        System.out.println("capheight:   " + this.convertTTFUnit2PDFUnit(this.capHeight));
        int italic = (int)(this.italicAngle >> 16);
        System.out.println("Italic:      " + italic);
        System.out.print("ItalicAngle: " + (short)(this.italicAngle / 65536L));
        if (this.italicAngle % 65536L > 0L) {
            System.out.print("." + (short)(this.italicAngle % 65536L * 1000L) / 65536);
        }
        System.out.println();
        System.out.println("Ascender:    " + this.convertTTFUnit2PDFUnit(this.ascender));
        System.out.println("Descender:   " + this.convertTTFUnit2PDFUnit(this.descender));
        System.out.println("FontBBox:    [" + this.convertTTFUnit2PDFUnit(this.fontBBox1) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox2) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox3) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox4) + "]");
    }

    private Integer glyphToUnicode(int glyphIndex) throws IOException {
        return (Integer)this.glyphToUnicodeMap.get(new Integer(glyphIndex));
    }

    private Integer unicodeToGlyph(int unicodeIndex) throws IOException {
        Integer result = (Integer)this.unicodeToGlyphMap.get(new Integer(unicodeIndex));
        if (result == null) {
            throw new IOException("Glyph index not found for unicode value " + unicodeIndex);
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            TTFFile ttfFile = new TTFFile();
            FontFileReader reader = new FontFileReader(args[0]);
            String name = null;
            if (args.length >= 2) {
                name = args[1];
            }
            ttfFile.readFont(reader, name);
            ttfFile.printStuff();
        }
        catch (IOException ioe) {
            System.err.println("Problem reading font: " + ioe.toString());
            ioe.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class UnicodeMapping {
        private int unicodeIndex;
        private int glyphIndex;

        UnicodeMapping(int glyphIndex, int unicodeIndex) {
            this.unicodeIndex = unicodeIndex;
            this.glyphIndex = glyphIndex;
            TTFFile.this.glyphToUnicodeMap.put(new Integer(glyphIndex), new Integer(unicodeIndex));
            TTFFile.this.unicodeToGlyphMap.put(new Integer(unicodeIndex), new Integer(glyphIndex));
        }

        public int getGlyphIndex() {
            return this.glyphIndex;
        }

        public int getUnicodeIndex() {
            return this.unicodeIndex;
        }
    }
}

