/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.plugins;

import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.nativeplatform.DependentSourceSet;
import org.gradle.model.Each;
import org.gradle.model.Finalize;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.plugins.NativeComponentPlugin;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.internal.DefaultNativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.internal.NativeTestSuiteBinarySpecInternal;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.testing.base.plugins.TestingModelBasePlugin;

@Incubating
public class NativeBinariesTestPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(NativeComponentPlugin.class);
        project.getPluginManager().apply(TestingModelBasePlugin.class);
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        void nativeTestSuiteBinary(TypeBuilder<NativeTestSuiteBinarySpec> builder) {
            builder.defaultImplementation(DefaultNativeTestSuiteBinarySpec.class);
            builder.internalView(NativeTestSuiteBinarySpecInternal.class);
        }

        @Finalize
        void attachTestedBinarySourcesToTestBinaries(final @Each NativeTestSuiteBinarySpecInternal testSuiteBinary) {
            NativeBinarySpec testedBinary = testSuiteBinary.getTestedBinary();
            testSuiteBinary.getInputs().withType(DependentSourceSet.class).all((Action)new Action<DependentSourceSet>((BinarySpec)testedBinary){
                final /* synthetic */ BinarySpec val$testedBinary;
                {
                    this.val$testedBinary = binarySpec;
                }

                public void execute(DependentSourceSet testSource) {
                    testSource.lib((Object)this.val$testedBinary.getInputs());
                }
            });
            testedBinary.getInputs().all((Action)new Action<LanguageSourceSet>(){

                public void execute(LanguageSourceSet testedSource) {
                    testSuiteBinary.getInputs().add((Object)testedSource);
                }
            });
        }

        @Finalize
        void configureRunTask(@Each NativeTestSuiteBinarySpecInternal testSuiteBinary) {
            BinaryNamingScheme namingScheme = testSuiteBinary.getNamingScheme();
            NativeTestSuiteBinarySpec.TasksCollection tasks = testSuiteBinary.getTasks();
            InstallExecutable installTask = (InstallExecutable)tasks.getInstall();
            RunTestExecutable runTask = (RunTestExecutable)tasks.getRun();
            runTask.getInputs().files(new Object[]{installTask.getOutputs().getFiles()}).withPropertyName("installTask.outputs");
            runTask.setExecutable(installTask.getRunScript().getPath());
            Project project = runTask.getProject();
            runTask.setOutputDir(namingScheme.getOutputDirectory(project.getBuildDir(), "test-results"));
        }
    }
}

