/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.internal.Factory;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultResolvedArtifact
implements ResolvedArtifact {
    private final ResolvedModuleVersion owner;
    private final IvyArtifactName artifact;
    private final ComponentArtifactIdentifier artifactId;
    private Factory<File> artifactSource;
    private File file;

    public DefaultResolvedArtifact(ResolvedModuleVersion owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, Factory<File> artifactSource) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.artifactSource = artifactSource;
    }

    public ResolvedModuleVersion getModuleVersion() {
        return this.owner;
    }

    public ComponentArtifactIdentifier getId() {
        return this.artifactId;
    }

    public String toString() {
        return String.format("[ResolvedArtifact dependency:%s name:%s classifier:%s extension:%s type:%s]", this.owner, this.getName(), this.getClassifier(), this.getExtension(), this.getType());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultResolvedArtifact other = (DefaultResolvedArtifact)obj;
        return other.owner.getId().equals(this.owner.getId()) && other.artifactId.equals(this.artifactId);
    }

    public int hashCode() {
        return this.owner.getId().hashCode() ^ this.artifactId.hashCode();
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public String getExtension() {
        return this.artifact.getExtension();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public File getFile() {
        if (this.file == null) {
            this.file = (File)this.artifactSource.create();
            this.artifactSource = null;
        }
        return this.file;
    }
}

