/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import groovy.util.Node;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;

public class SourceFolder
extends AbstractClasspathEntry {
    private String output;
    private List<String> includes;
    private List<String> excludes;
    private File dir;
    private String name;

    public SourceFolder(Node node) {
        super(node);
        this.output = this.normalizePath((String)node.attribute((Object)"output"));
        this.includes = this.parseNodeListAttribute(node, "including");
        this.excludes = this.parseNodeListAttribute(node, "excluding");
    }

    private List<String> parseNodeListAttribute(Node node, String attributeName) {
        Object attribute = node.attribute((Object)attributeName);
        if (attribute == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(((String)attribute).split("\\|"));
    }

    public SourceFolder(String projectRelativePath, String output) {
        super(projectRelativePath);
        this.output = this.normalizePath(output);
        this.includes = Lists.newArrayList();
        this.excludes = Lists.newArrayList();
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getKind() {
        return "src";
    }

    public String getAbsolutePath() {
        return this.dir.getAbsolutePath();
    }

    public void trim() {
        this.trim(null);
    }

    public void trim(String prefix) {
        if (prefix != null) {
            this.name = prefix + "-" + this.name;
        }
        this.path = this.name;
    }

    @Override
    public void appendNode(Node node) {
        HashMap attributes = Maps.newHashMap();
        Joiner joiner = Joiner.on((String)"|");
        attributes.put("including", joiner.join(this.includes));
        attributes.put("excluding", joiner.join(this.excludes));
        attributes.put("output", this.output);
        this.addClasspathEntry(node, attributes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceFolder that = (SourceFolder)o;
        return Objects.equal((Object)this.exported, (Object)that.exported) && Objects.equal((Object)this.accessRules, (Object)that.accessRules) && Objects.equal(this.excludes, that.excludes) && Objects.equal(this.includes, that.includes) && Objects.equal((Object)this.getNativeLibraryLocation(), (Object)that.getNativeLibraryLocation()) && Objects.equal((Object)this.output, (Object)that.output) && Objects.equal((Object)this.path, (Object)that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.exported, this.accessRules, this.excludes, this.includes, this.getNativeLibraryLocation(), this.output, this.path});
    }

    @Override
    public String toString() {
        return "SourceFolder{path='" + this.path + "', dir='" + this.dir + "', nativeLibraryLocation='" + this.getNativeLibraryLocation() + "', exported=" + this.exported + ", accessRules=" + this.accessRules + ", output='" + this.output + "', excludes=" + this.excludes + ", includes=" + this.includes + "}";
    }
}

