/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.script.KotlinScriptExternalDependencies;
import org.jetbrains.kotlin.script.ScriptFileUtilKt;
import org.jetbrains.kotlin.script.ScriptNameUtil;
import org.jetbrains.kotlin.script.ScriptParameter;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J/\u0010\n\u001a\u0004\u0018\u00010\u000b\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u0002H\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001b\u0010\u001e\u001a\u00020\u001f\"\u0004\b\u0000\u0010\f2\u0006\u0010\r\u001a\u0002H\fH\u0016\u00a2\u0006\u0002\u0010 R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "", "fileType", "Lorg/jetbrains/kotlin/com/intellij/openapi/fileTypes/LanguageFileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/LanguageFileType;", "name", "", "getName", "()Ljava/lang/String;", "getDependenciesFor", "Lorg/jetbrains/kotlin/script/KotlinScriptExternalDependencies;", "TF", "file", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "previousDependencies", "(Ljava/lang/Object;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/script/KotlinScriptExternalDependencies;)Lorg/jetbrains/kotlin/script/KotlinScriptExternalDependencies;", "getScriptName", "Lorg/jetbrains/kotlin/name/Name;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "getScriptParameters", "", "Lorg/jetbrains/kotlin/script/ScriptParameter;", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "getScriptParametersToPassToSuperclass", "getScriptSupertypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "isScript", "", "(Ljava/lang/Object;)Z", "kotlin-compiler"})
public interface KotlinScriptDefinition {
    @NotNull
    public String getName();

    @NotNull
    public LanguageFileType getFileType();

    public <TF> boolean isScript(TF var1);

    @NotNull
    public List<ScriptParameter> getScriptParameters(@NotNull ScriptDescriptor var1);

    @NotNull
    public List<KotlinType> getScriptSupertypes(@NotNull ScriptDescriptor var1);

    @NotNull
    public List<Name> getScriptParametersToPassToSuperclass(@NotNull ScriptDescriptor var1);

    @NotNull
    public Name getScriptName(@NotNull KtScript var1);

    @Nullable
    public <TF> KotlinScriptExternalDependencies getDependenciesFor(TF var1, @NotNull Project var2, @Nullable KotlinScriptExternalDependencies var3);

    @Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static String getName(KotlinScriptDefinition $this) {
            return "Kotlin Script";
        }

        @NotNull
        public static LanguageFileType getFileType(KotlinScriptDefinition $this) {
            LanguageFileType languageFileType = KotlinFileType.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull(languageFileType, "KotlinFileType.INSTANCE");
            return languageFileType;
        }

        public static <TF> boolean isScript(KotlinScriptDefinition $this, TF file2) {
            return StringsKt.endsWith$default(ScriptFileUtilKt.getFileName(file2), KotlinParserDefinition.STD_SCRIPT_EXT, false, 2, null);
        }

        @NotNull
        public static List<KotlinType> getScriptSupertypes(@NotNull KotlinScriptDefinition $this, ScriptDescriptor scriptDescriptor) {
            Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
            return CollectionsKt.emptyList();
        }

        @NotNull
        public static List<Name> getScriptParametersToPassToSuperclass(@NotNull KotlinScriptDefinition $this, ScriptDescriptor scriptDescriptor) {
            Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
            return CollectionsKt.emptyList();
        }

        @NotNull
        public static Name getScriptName(@NotNull KotlinScriptDefinition $this, KtScript script2) {
            Intrinsics.checkParameterIsNotNull(script2, "script");
            return ScriptNameUtil.INSTANCE.fileNameWithExtensionStripped(script2, KotlinParserDefinition.STD_SCRIPT_EXT);
        }

        @Nullable
        public static <TF> KotlinScriptExternalDependencies getDependenciesFor(KotlinScriptDefinition $this, @NotNull TF file2, @Nullable Project project, KotlinScriptExternalDependencies previousDependencies) {
            Intrinsics.checkParameterIsNotNull(project, "project");
            return null;
        }
    }
}

