/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine;

import java.io.IOException;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCacheEventQueue<K, V>
implements ICacheEventQueue<K, V> {
    private static final Log log = LogFactory.getLog(AbstractCacheEventQueue.class);
    protected static final int DEFAULT_WAIT_TO_DIE_MILLIS = 10000;
    private int waitToDieMillis = 10000;
    protected ICacheListener<K, V> listener;
    protected long listenerId;
    protected String cacheName;
    protected int maxFailure;
    protected int waitBeforeRetry;
    protected boolean destroyed = true;
    private boolean working = true;

    public int getWaitToDieMillis() {
        return this.waitToDieMillis;
    }

    public void setWaitToDieMillis(int n) {
        this.waitToDieMillis = n;
    }

    public String toString() {
        return "CacheEventQueue [listenerId=" + this.listenerId + ", cacheName=" + this.cacheName + "]";
    }

    @Override
    public synchronized boolean isAlive() {
        return !this.destroyed;
    }

    public synchronized void setAlive(boolean bl) {
        this.destroyed = !bl;
    }

    @Override
    public long getListenerId() {
        return this.listenerId;
    }

    @Override
    public synchronized void addPutEvent(ICacheElement<K, V> iCacheElement) throws IOException {
        if (this.isWorking()) {
            this.put(new PutEvent(iCacheElement));
        } else if (log.isWarnEnabled()) {
            log.warn("Not enqueuing Put Event for [" + this + "] because it's non-functional.");
        }
    }

    @Override
    public synchronized void addRemoveEvent(K k) throws IOException {
        if (this.isWorking()) {
            this.put(new RemoveEvent(k));
        } else if (log.isWarnEnabled()) {
            log.warn("Not enqueuing Remove Event for [" + this + "] because it's non-functional.");
        }
    }

    @Override
    public synchronized void addRemoveAllEvent() throws IOException {
        if (this.isWorking()) {
            this.put(new RemoveAllEvent());
        } else if (log.isWarnEnabled()) {
            log.warn("Not enqueuing RemoveAll Event for [" + this + "] because it's non-functional.");
        }
    }

    @Override
    public synchronized void addDisposeEvent() throws IOException {
        if (this.isWorking()) {
            this.put(new DisposeEvent());
        } else if (log.isWarnEnabled()) {
            log.warn("Not enqueuing Dispose Event for [" + this + "] because it's non-functional.");
        }
    }

    protected abstract void put(AbstractCacheEvent var1);

    @Override
    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean bl) {
        this.working = bl;
    }

    protected class DisposeEvent
    extends AbstractCacheEvent {
        protected DisposeEvent() {
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handleDispose(AbstractCacheEventQueue.this.cacheName);
        }

        public String toString() {
            return "DisposeEvent";
        }
    }

    protected class RemoveAllEvent
    extends AbstractCacheEvent {
        protected RemoveAllEvent() {
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handleRemoveAll(AbstractCacheEventQueue.this.cacheName);
        }

        public String toString() {
            return "RemoveAllEvent";
        }
    }

    protected class RemoveEvent
    extends AbstractCacheEvent {
        private final K key;

        RemoveEvent(K k) throws IOException {
            this.key = k;
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handleRemove(AbstractCacheEventQueue.this.cacheName, this.key);
        }

        public String toString() {
            return "RemoveEvent for " + this.key;
        }
    }

    protected class PutEvent
    extends AbstractCacheEvent {
        private final ICacheElement<K, V> ice;

        PutEvent(ICacheElement<K, V> iCacheElement) throws IOException {
            this.ice = iCacheElement;
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handlePut(this.ice);
        }

        public String toString() {
            return "PutEvent for key: " + this.ice.getKey() + " value: " + this.ice.getVal();
        }
    }

    protected abstract class AbstractCacheEvent
    implements Runnable {
        int failures = 0;

        protected AbstractCacheEvent() {
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (IOException iOException) {
                if (log.isWarnEnabled()) {
                    log.warn(iOException);
                }
                if (++this.failures >= AbstractCacheEventQueue.this.maxFailure) {
                    if (log.isWarnEnabled()) {
                        log.warn("Error while running event from Queue: " + this + ". Dropping Event and marking Event Queue as non-functional.");
                    }
                    AbstractCacheEventQueue.this.setWorking(false);
                    AbstractCacheEventQueue.this.setAlive(false);
                    return;
                }
                if (log.isInfoEnabled()) {
                    log.info("Error while running event from Queue: " + this + ". Retrying...");
                }
                try {
                    Thread.sleep(AbstractCacheEventQueue.this.waitBeforeRetry);
                    this.run();
                }
                catch (InterruptedException interruptedException) {
                    if (log.isErrorEnabled()) {
                        log.warn("Interrupted while sleeping for retry on event " + this + ".");
                    }
                    AbstractCacheEventQueue.this.setWorking(false);
                    AbstractCacheEventQueue.this.setAlive(false);
                }
            }
        }

        protected abstract void doRun() throws IOException;
    }

    protected static class Node {
        Node next = null;
        AbstractCacheEvent event = null;

        protected Node() {
        }
    }
}

