/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.RemoveNodesCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UnJoinNodeWayAction
extends JosmAction {
    public UnJoinNodeWayAction() {
        super(I18n.tr("Disconnect Node from Way", new Object[0]), "unjoinnodeway", I18n.tr("Disconnect nodes from a way they currently belong to", new Object[0]), Shortcut.registerShortcut("tools:unjoinnodeway", I18n.tr("Tool: {0}", I18n.tr("Disconnect Node from Way", new Object[0])), 74, 5004), true);
        this.putValue("help", HelpUtil.ht("/Action/UnJoinNodeWay"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
        List<Node> list = OsmPrimitive.getFilteredList(collection, Node.class);
        List<Way> list2 = OsmPrimitive.getFilteredList(collection, Way.class);
        List<Way> list3 = UnJoinNodeWayAction.getApplicableWays(list2, list = this.cleanSelectedNodes(list2, list));
        if (list3 == null) {
            this.notify(I18n.tr("Select at least one node to be disconnected.", new Object[0]), 2);
            return;
        }
        if (list3.isEmpty()) {
            this.notify(I18n.trn("Selected node cannot be disconnected from anything.", "Selected nodes cannot be disconnected from anything.", list.size(), new Object[0]), 2);
            return;
        }
        if (list3.size() > 1) {
            this.notify(I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", list.size(), new Object[0]), 2);
            return;
        }
        if (list3.get(0).getRealNodesCount() < list.size() + 2) {
            this.notify(I18n.trn("The affected way would disappear after disconnecting the selected node.", "The affected way would disappear after disconnecting the selected nodes.", list.size(), new Object[0]), 2);
            return;
        }
        Way way = list3.get(0);
        Main.main.undoRedo.add(new RemoveNodesCommand(way, list));
    }

    public void notify(String string, int n) {
        new Notification(string).setIcon(n).show();
    }

    private List<Node> cleanSelectedNodes(List<Way> list, List<Node> list2) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Node object : list2) {
            if (!object.isReferredByWays(1)) continue;
            linkedList.add(object);
        }
        if (list.size() == 1) {
            Way way = list.get(0);
            for (Node node : new ArrayList<Node>(linkedList)) {
                if (way.containsNode(node)) continue;
                linkedList.remove(node);
            }
        }
        if (linkedList.size() != list2.size()) {
            this.notify(I18n.tr("Some irrelevant nodes have been removed from the selection", new Object[0]), 1);
        }
        return linkedList;
    }

    static List<Way> getApplicableWays(List<Way> list, List<Node> list2) {
        if (list2.isEmpty()) {
            return null;
        }
        ArrayList<Way> arrayList = new ArrayList<Way>(OsmPrimitive.getFilteredList(list2.get(0).getReferrers(), Way.class));
        for (int i = 1; i < list2.size(); ++i) {
            List<OsmPrimitive> list3 = list2.get(i).getReferrers();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (list3.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (((Way)iterator.next()).getNodesCount() > 2) continue;
            iterator.remove();
        }
        if (list.isEmpty()) {
            return arrayList;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (list.contains(iterator.next())) continue;
            iterator.remove();
        }
        return arrayList;
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

