/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTable;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryViewerPanel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TagInfoTransferHandler;
import org.openstreetmap.josm.gui.history.TagTableColumnModel;

public class TagInfoViewer
extends HistoryViewerPanel {
    public TagInfoViewer(HistoryBrowserModel historyBrowserModel) {
        super(historyBrowserModel);
    }

    @Override
    protected JTable buildReferenceTable() {
        JTable jTable = new JTable(this.model.getTagTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME), new TagTableColumnModel());
        jTable.setName("table.referencetagtable");
        this.setUpDataTransfer(jTable);
        return jTable;
    }

    @Override
    protected JTable buildCurrentTable() {
        JTable jTable = new JTable(this.model.getTagTableModel(PointInTimeType.CURRENT_POINT_IN_TIME), new TagTableColumnModel());
        jTable.setName("table.currenttagtable");
        this.setUpDataTransfer(jTable);
        return jTable;
    }

    private void setUpDataTransfer(JTable jTable) {
        jTable.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(jTable.getSelectionModel());
        jTable.setTransferHandler(new TagInfoTransferHandler());
        jTable.addFocusListener(new RepaintOnFocusChange());
    }

    private static final class RepaintOnFocusChange
    implements FocusListener {
        private RepaintOnFocusChange() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            RepaintOnFocusChange.repaintSelected(focusEvent);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            RepaintOnFocusChange.repaintSelected(focusEvent);
        }

        private static void repaintSelected(FocusEvent focusEvent) {
            focusEvent.getComponent().repaint();
        }
    }
}

