/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class WebMarker
extends ButtonMarker {
    private final URL webUrl;

    public WebMarker(LatLon latLon, URL uRL, MarkerLayer markerLayer, double d, double d2) {
        super(latLon, "web", markerLayer, d, d2);
        CheckParameterUtil.ensureParameterNotNull(uRL, "webUrl");
        this.webUrl = uRL;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = OpenBrowser.displayUrl(this.webUrl.toString());
        if (string != null) {
            this.setErroneous(true);
            new Notification("<b>" + I18n.tr("There was an error while trying to display the URL for this marker", new Object[0]) + "</b><br>" + I18n.tr("(URL was: ", new Object[0]) + this.webUrl + ')' + "<br>" + string).setIcon(0).setDuration(Notification.TIME_LONG).show();
        } else {
            this.updateErroneous();
        }
    }

    @Override
    public WayPoint convertToWayPoint() {
        WayPoint wayPoint = super.convertToWayPoint();
        GpxLink gpxLink = new GpxLink(this.webUrl.toString());
        gpxLink.type = "web";
        wayPoint.put("meta.links", Collections.singleton(gpxLink));
        return wayPoint;
    }

    private void updateErroneous() {
        if ("file".equals(this.webUrl.getProtocol())) {
            String string = this.webUrl.getPath();
            try {
                this.setErroneous(string.isEmpty() || !new File(string).exists());
            }
            catch (SecurityException securityException) {
                Main.warn(securityException);
                this.setErroneous(true);
            }
        } else {
            this.setErroneous(false);
        }
    }
}

