/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SourceSectionFilter {
    private final EventFilterExpression[] expressions;

    private SourceSectionFilter(EventFilterExpression[] expressions) {
        this.expressions = expressions;
    }

    public static Builder newBuilder() {
        SourceSectionFilter sourceSectionFilter = new SourceSectionFilter(null);
        sourceSectionFilter.getClass();
        return sourceSectionFilter.new Builder();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("SourceSectionFilter[");
        String sep = "";
        for (EventFilterExpression expression : this.expressions) {
            b.append(sep);
            b.append(expression.toString());
            sep = " and ";
        }
        b.append("]");
        return b.toString();
    }

    Set<Class<?>> getReferencedTags() {
        HashSet usedTags = new HashSet();
        for (EventFilterExpression expression : this.expressions) {
            expression.collectReferencedTags(usedTags);
        }
        return usedTags;
    }

    boolean isSourceOnly() {
        for (EventFilterExpression eventFilterExpression : this.expressions) {
            if (eventFilterExpression.isSourceOnly()) continue;
            return false;
        }
        return true;
    }

    boolean isInstrumentedRoot(Set<Class<?>> providedTags, SourceSection rootSourceSection) {
        for (EventFilterExpression exp : this.expressions) {
            if (exp.isRootIncluded(providedTags, rootSourceSection)) continue;
            return false;
        }
        return true;
    }

    boolean isInstrumentedNode(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection sourceSection) {
        if (sourceSection == null) {
            return false;
        }
        for (EventFilterExpression exp : this.expressions) {
            if (exp.isIncluded(providedTags, instrumentedNode, sourceSection)) continue;
            return false;
        }
        return true;
    }

    boolean isInstrumentedSource(Source source) {
        if (source == null) {
            return false;
        }
        for (EventFilterExpression exp : this.expressions) {
            assert (exp.isSourceOnly());
            if (exp.isSourceIncluded(source)) continue;
            return false;
        }
        return true;
    }

    private static final class Not
    extends EventFilterExpression {
        private final EventFilterExpression delegate;

        Not(EventFilterExpression delegate) {
            this.delegate = delegate;
        }

        @Override
        boolean isSourceOnly() {
            return this.delegate.isSourceOnly();
        }

        @Override
        boolean isSourceIncluded(Source source) {
            return !this.delegate.isSourceIncluded(source);
        }

        @Override
        void collectReferencedTags(Set<Class<?>> collectTags) {
            this.delegate.collectReferencedTags(collectTags);
        }

        @Override
        boolean isRootIncluded(Set<Class<?>> providedTags, SourceSection rootSection) {
            return true;
        }

        @Override
        boolean isIncluded(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection sourceSection) {
            return !this.delegate.isIncluded(providedTags, instrumentedNode, sourceSection);
        }

        @Override
        protected int getOrder() {
            return this.delegate.getOrder();
        }

        public String toString() {
            return "not(" + this.delegate.toString() + ")";
        }
    }

    private static abstract class EventFilterExpression
    implements Comparable<EventFilterExpression> {
        private EventFilterExpression() {
        }

        protected abstract int getOrder();

        void collectReferencedTags(Set<Class<?>> collectTags) {
        }

        boolean isSourceIncluded(Source source) {
            return false;
        }

        abstract boolean isIncluded(Set<Class<?>> var1, Node var2, SourceSection var3);

        abstract boolean isRootIncluded(Set<Class<?>> var1, SourceSection var2);

        boolean isSourceOnly() {
            return false;
        }

        @Override
        public final int compareTo(EventFilterExpression o) {
            return o.getOrder() - this.getOrder();
        }

        static void appendRanges(StringBuilder builder, IndexRange[] ranges) {
            String sep = "";
            for (IndexRange range : ranges) {
                builder.append(sep).append(range);
                sep = " or ";
            }
        }

        private static Class<?>[] checkTags(Class<?>[] tags) {
            for (int i = 0; i < tags.length; ++i) {
                if (tags[i] != null) continue;
                throw new IllegalArgumentException("Tags must not be null.");
            }
            return tags;
        }

        private static final class LineIn
        extends EventFilterExpression {
            private final IndexRange[] ranges;

            LineIn(IndexRange[] ranges) {
                this.ranges = ranges;
            }

            @Override
            boolean isRootIncluded(Set<Class<?>> providedTags, SourceSection rootSourceSection) {
                if (rootSourceSection == null) {
                    return true;
                }
                return this.isIncluded(null, null, rootSourceSection);
            }

            @Override
            boolean isIncluded(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection sourceSection) {
                return LineIn.isLineIn(sourceSection, this.ranges);
            }

            static boolean isLineIn(SourceSection sourceSection, IndexRange[] ranges) {
                int otherStart = sourceSection.getStartLine();
                int otherEnd = sourceSection.getSource() == null ? otherStart : sourceSection.getEndLine();
                for (IndexRange indexRange : ranges) {
                    if (!indexRange.contains(otherStart, otherEnd)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected int getOrder() {
                return 10;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder("(line-between ");
                LineIn.appendRanges(builder, this.ranges);
                builder.append(")");
                return builder.toString();
            }
        }

        private static final class LineEndsIn
        extends EventFilterExpression {
            private final IndexRange[] ranges;

            LineEndsIn(IndexRange[] ranges) {
                this.ranges = ranges;
            }

            @Override
            boolean isRootIncluded(Set<Class<?>> providedTags, SourceSection rootSection) {
                if (rootSection == null) {
                    return true;
                }
                return LineIn.isLineIn(rootSection, this.ranges);
            }

            @Override
            boolean isIncluded(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection sourceSection) {
                int otherStart = sourceSection.getStartLine();
                int otherEnd = sourceSection.getSource() == null ? otherStart : sourceSection.getEndLine();
                for (IndexRange indexRange : this.ranges) {
                    if (!indexRange.contains(otherEnd, otherEnd)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected int getOrder() {
                return 10;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder("(line-ends-between ");
                LineEndsIn.appendRanges(builder, this.ranges);
                builder.append(")");
                return builder.toString();
            }
        }

        private static final class LineStartsIn
        extends EventFilterExpression {
            private final IndexRange[] ranges;

            LineStartsIn(IndexRange[] ranges) {
                this.ranges = ranges;
            }

            @Override
            boolean isRootIncluded(Set<Class<?>> providedTags, SourceSection rootSection) {
                if (rootSection == null) {
                    return true;
                }
                return LineIn.isLineIn(rootSection, this.ranges);
            }

            @Override
            boolean isIncluded(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection sourceSection) {
                int otherStart = sourceSection.getStartLine();
                for (IndexRange indexRange : this.ranges) {
                    if (!indexRange.contains(otherStart, otherStart)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected int getOrder() {
                return 10;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder("(line-starts-between ");
                LineStartsIn.appendRanges(builder, this.ranges);
                builder.append(")");
                return builder.toString();
            }
        }

        private static final class IndexIn
        extends EventFilterExpression {
            private final IndexRange[] ranges;

            IndexIn(IndexRange[] ranges) {
                this.ranges = ranges;
            }

            @Override
            boolean isRootIncluded(Set<Class<?>> providedTags, SourceSection rootSourceSection) {
                if (rootSourceSection == null) {
                    return true;
                }
                return this.isIncluded(null, null, rootSourceSection);
            }

            @Override
            boolean isIncluded(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection sourceSection) {
                int otherStart = sourceSection.getCharIndex();
                int otherEnd = otherStart + sourceSection.getCharLength();
                for (IndexRange indexRange : this.ranges) {
                    if (!indexRange.contains(otherStart, otherEnd)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected int getOrder() {
                return 8;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder("(index-between ");
                IndexIn.appendRanges(builder, this.ranges);
                builder.append(")");
                return builder.toString();
            }
        }

        private static final class RootSourceSectionEquals
        extends EventFilterExpression {
            private final SourceSection[] sourceSections;

            RootSourceSectionEquals(SourceSection ... sourceSection) {
                this.sourceSections = sourceSection;
                for (int i = 0; i < sourceSection.length; ++i) {
                    this.sourceSections[i] = sourceSection[i].withTags(new String[0]);
                }
            }

            @Override
            boolean isIncluded(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection s) {
                return true;
            }

            @Override
            boolean isRootIncluded(Set<Class<?>> providedTags, SourceSection rootSection) {
                if (rootSection == null) {
                    return false;
                }
                SourceSection withoutTags = rootSection.withTags(new String[0]);
                for (SourceSection compareSection : this.sourceSections) {
                    if (!withoutTags.equals(compareSection)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected int getOrder() {
                return 6;
            }

            public String toString() {
                return String.format("source-section equals one-of %s", Arrays.toString(this.sourceSections));
            }
        }

        private static final class SourceSectionEquals
        extends EventFilterExpression {
            private final SourceSection[] sourceSections;

            SourceSectionEquals(SourceSection ... sourceSection) {
                this.sourceSections = sourceSection;
                for (int i = 0; i < sourceSection.length; ++i) {
                    this.sourceSections[i] = sourceSection[i].withTags(new String[0]);
                }
            }

            @Override
            boolean isIncluded(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection s) {
                SourceSection withoutTags = s.withTags(new String[0]);
                for (SourceSection compareSection : this.sourceSections) {
                    if (!withoutTags.equals(compareSection)) continue;
                    return true;
                }
                return false;
            }

            @Override
            boolean isRootIncluded(Set<Class<?>> providedTags, SourceSection rootSection) {
                if (rootSection == null) {
                    return true;
                }
                Source rootSource = rootSection.getSource();
                if (rootSource != null) {
                    for (SourceSection compareSection : this.sourceSections) {
                        if (!rootSource.equals(compareSection.getSource())) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            protected int getOrder() {
                return 6;
            }

            public String toString() {
                return String.format("source-section equals one-of %s", Arrays.toString(this.sourceSections));
            }
        }

        private static final class TagIs
        extends EventFilterExpression {
            private final Class<?>[] tags;

            TagIs(Class<?> ... tags) {
                this.tags = EventFilterExpression.checkTags(tags);
            }

            @Override
            void collectReferencedTags(Set<Class<?>> collectTags) {
                for (Class<?> tag : this.tags) {
                    collectTags.add(tag);
                }
            }

            @Override
            boolean isIncluded(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection sourceSection) {
                Class<?>[] filterTags = this.tags;
                for (int i = 0; i < filterTags.length; ++i) {
                    Class<?> tag = filterTags[i];
                    if (!InstrumentationHandler.hasTagImpl(providedTags, instrumentedNode, tag)) continue;
                    return true;
                }
                return false;
            }

            @Override
            boolean isRootIncluded(Set<Class<?>> providedTags, SourceSection rootSection) {
                for (Class<?> tag : this.tags) {
                    if (!providedTags.contains(tag)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected int getOrder() {
                return 4;
            }

            public String toString() {
                return String.format("tag is one of %s", Arrays.toString(this.tags));
            }
        }

        private static final class MimeTypeIs
        extends EventFilterExpression {
            private final String[] mimeTypes;

            MimeTypeIs(String ... mimeTypes) {
                this.mimeTypes = mimeTypes;
            }

            @Override
            boolean isRootIncluded(Set<Class<?>> providedTags, SourceSection rootSourceSection) {
                if (rootSourceSection == null) {
                    return true;
                }
                return this.isSourceIncluded(rootSourceSection.getSource());
            }

            @Override
            boolean isSourceOnly() {
                return true;
            }

            @Override
            boolean isSourceIncluded(Source source) {
                String mimeType = source.getMimeType();
                if (mimeType != null) {
                    for (String otherMimeType : this.mimeTypes) {
                        if (!otherMimeType.equals(mimeType)) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            boolean isIncluded(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection sourceSection) {
                return this.isSourceIncluded(sourceSection.getSource());
            }

            @Override
            protected int getOrder() {
                return 2;
            }

            public String toString() {
                return String.format("mime-type is one-of %s", Arrays.toString(this.mimeTypes));
            }
        }

        private static final class SourceIs
        extends EventFilterExpression {
            private final Source[] sources;

            SourceIs(Source ... source) {
                this.sources = source;
            }

            @Override
            boolean isSourceOnly() {
                return true;
            }

            @Override
            boolean isSourceIncluded(Source src) {
                for (Source otherSource : this.sources) {
                    if (src != otherSource) continue;
                    return true;
                }
                return false;
            }

            @Override
            boolean isRootIncluded(Set<Class<?>> providedTags, SourceSection rootSourceSection) {
                if (rootSourceSection == null) {
                    return true;
                }
                return this.isSourceIncluded(rootSourceSection.getSource());
            }

            @Override
            boolean isIncluded(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection sourceSection) {
                return this.isSourceIncluded(sourceSection.getSource());
            }

            @Override
            protected int getOrder() {
                return 1;
            }

            public String toString() {
                return String.format("source is %s", Arrays.toString(this.sources));
            }
        }
    }

    public static final class IndexRange {
        final int startIndex;
        final int endIndex;

        private IndexRange(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public static IndexRange between(int startIndex, int endIndex) {
            if (startIndex < 0) {
                throw new IllegalArgumentException(String.format("The argument startIndex must be positive but is %s.", startIndex));
            }
            if (endIndex < startIndex) {
                throw new IllegalArgumentException(String.format("Invalid range %s:%s.", startIndex, endIndex));
            }
            return new IndexRange(startIndex, endIndex);
        }

        public static IndexRange byLength(int startIndex, int length) {
            if (length < 0) {
                throw new IllegalArgumentException(String.format("The argument length must be positive but is %s.", length));
            }
            if (startIndex < 0) {
                throw new IllegalArgumentException(String.format("The argument startIndex must be positive but is %s.", startIndex));
            }
            return new IndexRange(startIndex, startIndex + length);
        }

        boolean contains(int otherStartIndex, int otherEndIndex) {
            return this.startIndex <= otherEndIndex && otherStartIndex < this.endIndex;
        }

        public String toString() {
            return "[" + this.startIndex + "-" + this.endIndex + "[";
        }
    }

    public final class Builder {
        private List<EventFilterExpression> expressions = new ArrayList<EventFilterExpression>();

        private Builder() {
        }

        public Builder sourceIs(Source ... source) {
            this.verifyNotNull(source);
            this.expressions.add(new EventFilterExpression.SourceIs(source));
            return this;
        }

        public Builder mimeTypeIs(String ... mimeTypes) {
            this.verifyNotNull(mimeTypes);
            this.expressions.add(new EventFilterExpression.MimeTypeIs(mimeTypes));
            return this;
        }

        public Builder tagIs(Class<?> ... tags) {
            this.verifyNotNull(tags);
            this.expressions.add(new EventFilterExpression.TagIs(tags));
            return this;
        }

        public Builder tagIsNot(Class<?> ... tags) {
            this.verifyNotNull(tags);
            this.expressions.add(new Not(new EventFilterExpression.TagIs(tags)));
            return this;
        }

        public Builder sourceSectionEquals(SourceSection ... section) {
            this.verifyNotNull(section);
            this.expressions.add(new EventFilterExpression.SourceSectionEquals(section));
            return this;
        }

        public Builder rootSourceSectionEquals(SourceSection ... section) {
            this.verifyNotNull(section);
            this.expressions.add(new EventFilterExpression.RootSourceSectionEquals(section));
            return this;
        }

        public Builder indexNotIn(IndexRange ... ranges) {
            this.verifyNotNull(ranges);
            this.expressions.add(new Not(new EventFilterExpression.IndexIn(ranges)));
            return this;
        }

        public Builder indexIn(IndexRange ... ranges) {
            this.verifyNotNull(ranges);
            this.expressions.add(new EventFilterExpression.IndexIn(ranges));
            return this;
        }

        public Builder indexIn(int startIndex, int length) {
            return this.indexIn(IndexRange.byLength(startIndex, length));
        }

        public Builder lineIn(IndexRange ... ranges) {
            this.verifyLineIndices(ranges);
            this.expressions.add(new EventFilterExpression.LineIn(ranges));
            return this;
        }

        public Builder lineNotIn(IndexRange ... ranges) {
            this.verifyLineIndices(ranges);
            this.expressions.add(new Not(new EventFilterExpression.LineIn(ranges)));
            return this;
        }

        public Builder lineIn(int startLine, int length) {
            return this.lineIn(IndexRange.byLength(startLine, length));
        }

        public Builder lineStartsIn(IndexRange ... ranges) {
            this.verifyLineIndices(ranges);
            this.expressions.add(new EventFilterExpression.LineStartsIn(ranges));
            return this;
        }

        public Builder lineEndsIn(IndexRange ... ranges) {
            this.verifyLineIndices(ranges);
            this.expressions.add(new EventFilterExpression.LineEndsIn(ranges));
            return this;
        }

        private void verifyLineIndices(IndexRange ... ranges) {
            this.verifyNotNull(ranges);
            for (IndexRange indexRange : ranges) {
                if (indexRange.startIndex >= 1) continue;
                throw new IllegalArgumentException(String.format("Start line indices must be >= 1 but were %s.", indexRange.startIndex));
            }
        }

        public Builder lineIs(int line) {
            return this.lineIn(line, 1);
        }

        public SourceSectionFilter build() {
            Collections.sort(this.expressions);
            return new SourceSectionFilter(this.expressions.toArray(new EventFilterExpression[0]));
        }

        private void verifyNotNull(Object[] values) {
            if (values == null) {
                throw new IllegalArgumentException("Given arguments must not be null.");
            }
            for (int i = 0; i < values.length; ++i) {
                if (values[i] != null) continue;
                throw new IllegalArgumentException("None of the given argument values must be null.");
            }
        }
    }
}

