/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.Content;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;

final class FileSourceImpl
extends Content
implements Content.CreateURI {
    private final File file;
    private final String name;
    private final String path;

    FileSourceImpl(File file, String name, String path) {
        this.file = file.getAbsoluteFile();
        this.name = name;
        this.path = path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.file.getName();
    }

    @Override
    Object getHashKey() {
        return this.path;
    }

    @Override
    public String getCode() {
        if (Source.fileCacheEnabled) {
            if (this.code == null) {
                try {
                    this.code = Source.read(this.getReader());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.code;
        }
        try {
            return Source.read(new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    URI getURI() {
        return this.createURIOnce(this);
    }

    @Override
    public URI createURI() {
        return this.file.toURI();
    }

    @Override
    public Reader getReader() {
        if (this.code != null) {
            return new StringReader(this.code);
        }
        try {
            return new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Can't find file " + this.path, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding in file " + this.path, e);
        }
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    String findMimeType() throws IOException {
        return Files.probeContentType(this.file.toPath());
    }
}

